/*******************************************************************************
 * Copyright (c) 2010 Robert "Unlogic" Olofsson (unlogic@unlogic.se).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0-standalone.html
 ******************************************************************************/
package se.unlogic.standardutils.dao;

import se.unlogic.standardutils.populators.QueryParameterPopulator;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

public interface Column<BeanType,ColumnType> {

	public abstract Field getBeanField();

	public abstract Class<?> getParamType();

	public Object getParamValue(Object param);

	public Object getBeanValue(BeanType bean);

	public abstract Method getQueryMethod();

	public abstract String getColumnName();

	public abstract boolean isAutoGenerated();

	public abstract QueryParameterPopulator<?> getQueryParameterPopulator();

}
