# Announce: Rakudo Perl 6 compiler, Release #131 (2019.07)

On behalf of the Rakudo development team, I’m very happy to announce the
July 2019 release of Rakudo Perl 6 #131. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1].

This release implements 6.c and 6.d versions of the Perl 6 specification.
6.c version of the language is available if you use the `use v6.c`
version pragma, otherwise 6.d is the default.

Upcoming releases in 2019 will include new functionality that is not
part of 6.c or 6.d specifications, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of
6.c and 6.d specifications will continue to work unchanged. There may
be incremental spec releases this year as well.

The tarball for this release is available from <https://rakudo.org/files/rakudo>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] — it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<https://rakudo.org/files/star>.

The changes in this release are outlined below:

New in 2019.07:
  + SPECIAL NOTES:
    + Upcoming releases after this one will have a different changelog format
    + Java 9 is now required for JVM backend [ea94966d][8a37b931][b1fac3d6]
  + Deprecations:
    + `--profile-filename` will be deprecated in the future. Instead, there
        is a `--profile-kind` option that accepts the `instrumented` (default)
        or `heap` arguments, and `--profile(-compile)` accepts a filename as an
        argument [31e534cf]
  + Fixes:
    + Fixed `asinh` with large negative arguments [5281c23a]
    + Fixed laziness check on `[\+]` [8f424c9d]
    + Fixed representation of constant constraint in `Parameter.perl` [a1591fbe]
    + Fixed `$*KERNEL.bits` on Windows [5a9b720d][6e8df010]
    + Made sure creating a Failure from a Failure object throws [c9110654]
    + Made a Failure throw when it is used as something `Iterable` [23fca8f6]
        [4ffb4082]
    + Fixed `CLIENT::.keys` [6599998c]
    + Fixed a crash when values are deleted from `(Set|Bag|Mix)Hash` while
        iterating [a6a60705][1f066d96][63657986][c5664301][787d5bf6]
    + Fixed method cloning [d14fad4a]
    + Fixed USAGE message to not omit candidates when it shouldn't [bea51993]
        [dd1c8059][2b991664]
    + Class symbols are now merged into stub when
        using `require STUB:file<>` [f03c7814]
    + Fixed named parameters in `MAIN` so that a single parameter for a
        `@`-sigilled parameter is now accepted [87d219ee]
    + Improved USAGE message for `@` sigilled parameters [d5faa02b]
    + Implemented `:123foo` parameter format in POD6 config [95ce37d3]
    + Fixed notification queue growth in `Channel.Supply` [d5044de2]
    + Fixed `FatRat.base` failure for large denominators [d4e1d8e7][b69964b5]
    + Allowed `:at`/`:in`/`:every` to be `Inf`/`-Inf`/`NaN`
        in `ThreadPoolScheduler.cue` [cc88d63d][de76a056][9b46cb90]
        [c977d6c5][1a19c660]
    + Fixed an error when `RAKUDO_EXCEPTIONS_HANDLER` is set [939ea419]
    + Fixed parsing of Unicode brackets in string interpolation [ba07a62f]
    + Fixed a lot of reproducibility issues in Rakudo and precompiled modules
        [0990ecc4][50699817][e1f1eb00][7926cdd6][95af2f4c][a2ba5737][4af81c36]
        [5ee341cc][5b8b9c0c][5dcc687e][aa1d1ce0][7b5a9981][a973dae6][4d44bd93]
        [8ec2c43f][532d19fc][5669bc92][37b7ef7c][5c24182f][c5bc71e3][cd11b507]
        [b0dd44b0]
    + Fixed an issue with multiple dimensioned indexes throwing rather than
        failing [7bbbebc0][9ce87eeb]
    + Made sure the REPL creates a history file if it doesn't exist [cb691da5]
    + Made sure that `.head`/`.tail` can take `Cool` values [74c8f044]
    + Fixed bogus role conflict when the same method is added under
        multiple names [e274f4a2]
    + Made sure classes doing the `QuantHash` role have `.hash` and
        `.Hash` [650bbc1d]
    + Fixed `ThreadPoolScheduler.cue` when called with a `times` named
        parameter [48a12551]
    + Fixed an off-by-one error in infinite range subscript [35b69f07]
    + Fixed colon parsing of adverbs [76e5ee1b][91359141][c227693a][a26e95ba]
    + Fixed `List.perl` for lazy lists [ec978780]
    + Fixed `compile_in_context` with an immediate block [b9f89954]
    + Fixed parsing of `&` in regexes [f18af941]
    + Allowed capture argument to `MAIN` to accept arguments [410ff564]
    + Made `Date.truncate-to('day')` a no-op [e943f3eb]
    + Fixed assigning `Nil` to a scalar declared with captured type [c0134d2a]
    + Fixed roles inheriting from a class failing to type check against
        that class [90d81c7f][41f6f9ea]
    + Fixed type checking on curried roles [86290889][5f07a394]
        [9b65b33b][9c6fa1e7]
    + Fixed type matching of parameterized roles [0023f64c]
    + Fixed type matching of roles against their "parent" classes [6c023546]
    + Fixed role exports [163f0a03]
    + Fixed assigning a native array from an `Array` with deleted
        elements [ef766010]
    + Fixed number of elements when `Slip`ping an `Array` [f5f41901]
    + Fixed multi-dimensional `EXISTS-POS` for out of bounds
        dimensions [ca7408e9][c9a78928]
    + Made sure sorting a 2-element list with a mapper is stable [ab56324d]
    + Made sure calling `push`/`append`/`unshift`/`prepend` as a sub with
        named parameters dies [b20ccbae]
    + Made `is export` export role's group [120b8d95]
    + Fixed internal `from-json` so that it doesn't creatie nested arrays
        on assign [b7e0e894]
    + Made sure `Channel.fail`, `.poll`, and `.receive` will update status
        of `Channel.closed` [ef1ea42c]
    + Made some methods return `Bool`s instead of 0 or 1 [6f8442ad]
    + Made sure formatter information is kept when using operators
        on `Date`/`DateTime` [34c0e892][5bdeedcb][f05b1b08]
    + Fixed `require` to do the right thing when importing sigilless
        symbols [63b9e1fe]
    + Implemented a more fine-grained deconting of exported symbols [93f20871]
    + Made sure `Junction`s used in a `grep` are interpreted in `Bool`
        context [86523869]
    + Fixed signatures on several multi methods in core [66d92c62]
        [8969399b][9b639961]
    + Changed the value of `RAKUDO_FIRST_FLAG` to avoid collision
        with `MVM_CF_FORWARDER_VALID` [bf61f597]
    + Various fixes for the JVM backend [e84f7270][a5b22387][f26fbd37]
        [3e51bd4e][1aae63a6][5e8451f7][96a976b3][417fa68e][f1c80fdd]
        [07b4f743][ee2297b5]
    + Various fixes for the JS backend [0ecd037b][4f8a16e0][6e650cd3]
        [b0668b26][75e2fb70][9d187287][7aa72ce0][1aae63a6][f1c80fdd]
        [8abfbbc4][07f6ccc3][88712199][ea795710]
    + Various improvements to produced messages [54a89b6b][6563f1ab]
        [2732a286][69d88be3][1ec4f171][33e2d7f4][2f6e5fde][2e8f326d]
        [e3529622][24eb4d59][8f59177a][d8a41f7e][aeba161c][a362fac5]
  + Additions:
    + Added an `X::Cannot::Map` exception [fd8a00a3][ef8899f6][a804ed0f]
    + Telemetry's `snap` now also accepts an optional
        "checkpoint" message [afc9f849]
    + Telemetry: allow snap `:heap` for heap snapshots [90e18b65][0c80e067]
    + `CompUnit::Repository::FileSystem` objects can now also be
        created from an `IO::Path` [e9bbefd3][b2e72d6d]
    + Added support for `use v6.e.PREVIEW` [d4afd480]
    + `EVAL` now supports a `:check` flag to just check
        syntax (like `perl6 -c`) [d41f162d][5b3a8ce0]
    + Implemented support for `Kernel.free-memory` and
        `Kernel.total-memory` [31671f8f]
    + Added the `CachedIterator` role for creating iterators on cached
        lists [94ba19f7][a4d38539]
    + By default a parametric role group would now choose non-signatured
        candidate for introspection; if there is no such candidate then
        the first one would be chosen [6c023546]
    + Added `--confprog`, a way to configure the behavior of some
        moarvm-internal systems like the profiler [97334711]
  + Removals:
    + Removed `:where` support for `Signature/Parameter.perl` [4cfe5ec1]
    + Removed several internal functions from `CORE::` and
        `SETTING::` namespaces [45eb1c5f][ed074cd1][80185031][bf57f762]
    + Removed wrappers for no longer existing internal function
        from `RESTRICTED` setting [47832fe1]
    + Removed `Compiler::build-date` [019ccf05][35423a6e]
    + Removed the timestamp in `Distro`'s desc [2d4d2ca0]
    + Removed unused `%opts` argument from
        `Perl6::World::load_module_early` [bc764c2e]
  + Build system:
    + Replaced shell runner scripts with native executables
        [ed9b963d][7ab19817][5366c4fa][4b461bf7][2c9c823c][e0f84e05][637ba57d]
        [1853eb91][9e63da47][7846144e][787596d0][5bc62699][4459364e][bb7e6094]
        [11c55fb8][34162e96][9aec73a7][134b1baa][8fac1099][c4f33fce][afc79c24]
        [474997fc][ef0bc23f][c63c06e7][40cc12ac]
    + Made Rakudo relocatable on most platforms [b989882d][e27c1ec3][efa9f54e]
        [171bb6eb][a11e9ab5][d76fe0ae][aed29234][f20a2b6e][98a0df6e][ab96f1a6]
        [f0915e92][e00c9ea8][4ec400be][52b80c44][27adb553][ffaf3fc3][a542ec94]
        [090f1c96][4a7c487b][efb35b00][1add622d][1d538977][e20dcc4e][d3d4b2e8]
        [65217aaa][109ce1f4][99176243][249c730e][340f692b][5a07a7fd][8809b9ce]
        [de42e719][cac95fbb][0c8f269f][96e8d4f4][3fffe283][83f6256a][65ed8249]
        [3f0dfcd7][f8ced498][3a4ebf34][75e234a2][6c5be5e0]
    + Revamped the whole build system [db5becfb][c1c108fd][bafa5239][3627de6d]
        [6d40290e][2c4f7c79][9ce98098][c7b3bd7a][2974076b][d54fafca][7c20b9c8]
        [2c256531][0299578d][01e8b85f][55ebbacc][9ac52616][59d44cf0][8784b21c]
        [cc584b72][cf33f1a0][7960454a][b619b560][86fe3a05][825b6787][38980f0d]
        [4b481194][dd250027][6695777e][7d2bb288][13d65042][0adb7769][5404c2a2]
        [c314acc8][8d2fade7][e91668ad][5935b1dd][f12a8c95][99c53c39][141bd4e1]
        [da6d90e4][16ccbeb0][f6438b02][f2ccd6fa][49a4ddbd][1fceeada][87647236]
        [9ba51a8b][f077f57c][adc8e212][4e15f205][4816277c][0acd27f4][6e14da54]
        [79629bde][c86742ac][09b9e065][88218704][caae6e33][de53f43b][2b1e5ab4]
        [63a1b50a][e132e476][fd0a4c21][c24b1875][b25d7c94][7467ab1d][70d481b2]
        [2d7e7aa4][0522259d][3f25ba92][00362541][c8b5bd3e][6ee37f8b][b93201f5]
        [136e8a43][0296102e][7fc38d55][bf1bf73c][02e78700][50034d15][e51d2adb]
        [1655e73c][7f69ef1d][f15f5687][f935bd20][2f8a4d78][9dca33b6][c5830f4c]
    + Introduced `PERL6_HOME` and `NQP_HOME` which allow to control where
        Perl 6 and NQP look for their installation [8055fc1b][f76db01b]
        [9196db5c][2633aad6][472c8c90]
    + Fixed default target on `nmake` [44e0386a]
    + Debugging commandline arguments now work on perl6 directly [2d3a7fbf]
        [e26cd449][9ce17929][8b9297de]
    + Moved `spectest.data` file into roast [ed6d91c0]
    + Rakudo NQP libs are now installed into `/share/perl6/lib` instead
        of `/share/nqp/lib` [34476c3a]
    + The "perl6" Perl 6 CompUnit repo was renamed to "core" and is now
        installed in its own folder [80dff595][4d5b254e]
  + Efficiency:
    + Replaced internal json parser with `JSON::Fast` code [ce24f604]
        [43ff9f1c][a8cd286a]
    + Made `say(\x)` about 1.08x as fast [9770c1aa]
    + Made `Iterable (<=) Map` 2x to 3x as fast [44a6468f]
    + Made internal `to-json` functionality about 3x as fast on
        MoarVM, 1.6x as fast on JVM [667c75d3][8540c94d][a6a2ba90]
        [e22aeafb][ee2f2d2d][dc782575][1d4bcac3]
    + Made chained calls of `.reverse` much less memory hungry and a bit
        faster [2683b3d0][e118d4ef][719eefde][8ddc2ad5]
    + ReifiedListIterator is now a PredictiveIterator [9107215a]
    + Many small internal optimizations [f0915624][29878d82][76b6416d][a9b9cdc9]
        [17643d49][29ce2ce3][847783e2][165f9184][2eb93b2d][286aa29e]
        [a21cf6ae][86d66ea1][3556f270][0b66e011][e316c1a1]
        [7db3a06d][b559512a][25fe9b0b][3cde10a7][6df735b2][bb2c3f3a]
        [5b7870bf][9dad99b8][36fa16bb][0e7c6e77][c361736e][cbb9034a]
        [ce30ff2a][bed0695d][95a7866c][ffc47aae][2b0ac401][7b10a428]
  + Work in progress:
    + Re-implementation of `sprintf` [8fc53ec2][12a094ad][7201d89e]
        [29107b17][972a242f][1cad10b7][4ae023c7][af7b833f][74505389]
        [d000a125][dc02335d][e6cbbcc8][0f3bdfb8][e84845ad][7931fc25]
    + Providing an API to spesh logs [84144c79][4e677f04][f91de3e2]
    + Providing an API to the MoarVM profiler logic [c4fdb642][e421e638]
        [f7bcbb70][b51acee6][3910042a][28ce83a0][a70a82ea][51c6e585]
        [19c74bd0][9e8da747][ef7f0408][8e49a86b][4b8eb734][6e3a4b93]
        [ac698cd4][26a309b2][9203ef2e][a32ad594][29966a1a][e623265e]
        [13d3f0d4][161d7eef]
  + Internal:
    + Refactored `$*KERNEL` internal use of uname [ec40933d]
    + Got rid of a hack involving early return in `Test.pm6` [84b0e380]
    + Fixed `.&fail` after better return handler tracking [90722780]
    + Exposed `newmixintype` via `Metamodel::Primitives` [4702c245]
    + Fixed subclassing of `Parameter` [d31fb270]


The following people contributed to this release:

Vadim Belman, Elizabeth Mattijsen, Patrick Böker, Timo Paulssen,
Jonathan Worthington, Will "Coke" Coleda, Paweł Murias,
Juan Julián Merelo Guervós, Daniel Green, Ben Davies, Christian Bartolomäus,
Altai-man, Nick Logan, Stefan Seifert, Aleks-Daniel Jakimenko-Aleksejev,
Tobias Boege, Antonio, cfa, Samantha McVey, lukasvalle, Clifton Wood,
Elena Merelo, Tom Browder, Rafael Schipiura, Moritz Lenz, Trey Harris,
Kane Valentine, Luis F. Uceta, Kaz Wesley, Jack Kuan, Mike Clarke,
Jan-Olof Hendig, Luc St-Louis, Madeleine Goebel, Paul Marquess,
Peter du Marchie van Voorthuysen, thundergnat, tony-o,
Bart Wiegmans, Chloé Kekoa, Patrick Sebastian Zimmermann,
Christopher Bottoms, Elronnd, Leon Timmermans, Oleksii Varianyk,
Tadeusz Sośnierz, Tim Smith, Tim Van den Langenbergh, Wenjie Sun, Zili Chen,
alanrocker, brian d foy

If you would like to contribute or find out more information, visit
<https://perl6.org>, <https://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Perl 6 development: <https://donate.perlfoundation.org/>
(put “Perl 6 Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#132), is tentatively scheduled for 2019-09-21.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, Perl 6 introductory
documentation, and other software that can be used with the Rakudo
compiler to enhance its utility.
