% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/font_outline.R
\name{glyph_outline}
\alias{glyph_outline}
\title{Get the outline of glyphs}
\usage{
glyph_outline(
  glyph,
  path,
  index = 0,
  size = 12,
  tolerance = 0.2,
  verbose = FALSE
)
}
\arguments{
\item{glyph}{The index of the glyph in the font file}

\item{path}{The path to the font file encoding the glyph}

\item{index}{The index of the font in the font file}

\item{size}{The size of the font in big points (1/72 inch)}

\item{tolerance}{The deviation tolerance for decomposing bezier curves of the
glyph. Given in the same unit as size. Smaller values give more detailed
polygons}

\item{verbose}{Should font and glyph loading errors be reported as warnings}
}
\value{
A data frame giving the outlines of the glyphs provide in \code{glyph}. It
contains the columns \code{glyph} pointing to the element in the input it relates
to, \code{contour} enumerating the contours the glyph consists of, and \code{x} and \code{y}
giving the coordinates in big points
}
\description{
This function allows you to retrieve the outline of glyphs as polygon
coordinates. The glyphs are given as indexes into a font file and not as
characters allowing you to retrieve outlines for glyphs that doesn't have a
character counterpoint. Glyphs that are given as bitmaps are ignored.
}
\examples{
# Get the shape of s in the default font
font <- font_info()
glyph <- glyph_info("s", path = font$path, index = font$index)

s <- glyph_outline(glyph$index, font$path, font$index, size = 150)

plot(s$x, s$y, type = 'l')

}
