% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{formatSummarizedFactors}
\alias{formatSummarizedFactors}
\title{Prints out the contents of an object created by summarizeFactors
in the style of base::summary}
\usage{
formatSummarizedFactors(x, ...)
}
\arguments{
\item{x}{A summarizedFactors object produced by summarizeFactors}

\item{...}{optional arguments. Only value currently used is digits,
which defaults to 2.}
}
\value{
A table of formatted output
}
\description{
An object with class "summarizedFactors" is the input. Such an
object should be created with the function
rockchalk::summarizeFactors. Each element in that list is then
organized for printing in a tabular summary.  This should look
almost like R's own summary function, except for the additional
information that these factor summaries include.
}
\examples{
dat <- data.frame(xcat1 = gl(10, 3), xcat2 = gl(5, 6))
summarizeFactors(dat, maxLevels = 8)
formatSummarizedFactors(summarizeFactors(dat))
}
\seealso{
\code{\link{summarize}}, \code{\link{summarizeFactors}}, \code{\link{formatSummarizedNumerics}}
}
\author{
Paul E. Johnson \email{pauljohn@ku.edu}
}
