% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl-format-setup.R
\name{new_tbl_format_setup}
\alias{new_tbl_format_setup}
\title{Construct a setup object for formatting}
\usage{
new_tbl_format_setup(
  width,
  tbl_sum,
  x = NULL,
  df = NULL,
  body = NULL,
  rows_missing = NULL,
  rows_total = NULL,
  extra_cols = NULL,
  extra_cols_total = NULL,
  max_footer_lines = NULL,
  abbrev_cols = NULL
)
}
\arguments{
\item{width}{The \code{width} argument unchanged.}

\item{tbl_sum}{A named character vector, as returned from \code{\link[=tbl_sum]{tbl_sum()}}.}

\item{x}{The input object unchanged.}

\item{df}{A data frame representation of the intended output,
trimmed to the desired number of rows.}

\item{body}{A character vector with the formatted body,
one element per line,}

\item{rows_missing}{The number of rows not shown from the body,
\code{NA} if unknown.}

\item{rows_total}{The total number of rows in the data,
\code{NA} if unknown.}

\item{extra_cols}{Columns that did not fit into the body,
as a character vector of formatted column names and types.}

\item{extra_cols_total}{The total number of columns, may be larger than
\code{length(extra_cols)}.}

\item{max_footer_lines}{The maximum number of lines in the footer.}

\item{abbrev_cols}{Formatted names of the columns that are shown abbreviated
in the body.}
}
\description{
The object returned from the default method of \code{\link[=tbl_format_setup]{tbl_format_setup()}}
is an object with a \code{"class"} attribute and the elements described in the
"Parameters" section.

Named elements can be added to such objects without affecting the behavior.
Do not modify existing elements.
}
\keyword{internal}
