% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ns_search_eco.R
\name{ns_search_eco}
\alias{ns_search_eco}
\title{Ecosystem search}
\usage{
ns_search_eco(
  text = NULL,
  text_adv = NULL,
  status = NULL,
  location = NULL,
  ecosystem_taxonomy = NULL,
  record_subtype = NULL,
  modified_since = NULL,
  page = NULL,
  per_page = NULL,
  ...
)
}
\arguments{
\item{text}{(character) basic text search, equiavalent to \code{text_adv}
with \code{matchAgainst="allNames"} and \code{operator="similarTo"}}

\item{text_adv}{(list) advanced search, must specify the following three
elements: \code{searchToken}, \code{matchAgainst}, and \code{operator}. see
https://explorer.natureserve.org/api-docs/#_advanced_text_search_parameter}

\item{status}{(character) conservation status, one of G1, G2, G3, G4,
G5, GH, GX, GNR, GNA, GU. case insensitive}

\item{location}{(list) location, country and sub-country. specify either
\code{nation} OR \code{nation} and \code{subnation}. each expects a two-letter ISO code}

\item{ecosystem_taxonomy}{(character) the classification code of the
higher level (ancestor) ecosystem. E.g.'s: "1" (Class code),
"1.B" (Subclass code), "1.B.2" (Formation code), "1.B.2.Nd" (Division code),
"M886" (Macrogroup key), "G206" (Group key), "A3328" (Alliance Key)}

\item{record_subtype}{(character) limit results by record sub-type, one of:
"class", "subclass", "formation", "division", "macrogroup", "group",
"alliance", "association", "terrestrial_ecological_system"}

\item{modified_since}{(character) search for records modified since a
given time. value must be a date and time with a UTC offset in ISO 8601
format. optional}

\item{page}{(integer) Zero-indexed page number; default: 0. optional}

\item{per_page}{(integer) Records per page; default: 20. optional}

\item{...}{Curl options passed on to \code{\link[crul]{verb-GET}}}
}
\description{
Ecosystem search
}
\examples{
\dontrun{
ns_search_eco(text = "robin")
ns_search_eco(text_adv = list(searchToken = "bird",
  matchAgainst = "allNames", operator="similarTo"))
ns_search_eco(status = "G1")
ns_search_eco(location = list(nation = "US"))
ns_search_eco(location = list(nation = "US", subnation = "VA"))
ns_search_eco(ecosystem_taxonomy = "M067")
ns_search_eco(record_subtype = "macrogroup")
ns_search_eco(modified_since = "2020-04-30T00:00:00+0000")
ns_search_eco(page = 0, per_page = 2)
}
}
\references{
https://explorer.natureserve.org/api-docs/
}
\seealso{
Other search: 
\code{\link{ns_search_comb}()},
\code{\link{ns_search_spp}()}
}
\concept{search}
