% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/array-stream.R
\name{as_nanoarrow_array_stream}
\alias{as_nanoarrow_array_stream}
\title{Convert an object to a nanoarrow array_stream}
\usage{
as_nanoarrow_array_stream(x, ..., schema = NULL)
}
\arguments{
\item{x}{An object to convert to a array_stream}

\item{...}{Passed to S3 methods}

\item{schema}{An optional schema used to enforce conversion to a particular
type. Defaults to \code{\link[=infer_nanoarrow_schema]{infer_nanoarrow_schema()}}.}
}
\value{
An object of class 'nanoarrow_array_stream'
}
\description{
In nanoarrow, an 'array stream' corresponds to the \verb{struct ArrowArrayStream}
as defined in the Arrow C Stream interface. This object is used to represent
a stream of \link[=as_nanoarrow_array]{arrays} with a common
\link[=as_nanoarrow_schema]{schema}. This is similar to an
\link[arrow:RecordBatchReader]{arrow::RecordBatchReader} except it can be used to represent a stream of
any type (not just record batches). Note that a stream of record batches
and a stream of non-nullable struct arrays are represented identically.
Also note that array streams are mutable objects and are passed by
reference and not by value.
}
\examples{
(stream <- as_nanoarrow_array_stream(data.frame(x = 1:5)))
stream$get_schema()
stream$get_next()

# The last batch is returned as NULL
stream$get_next()

# Release the stream
stream$release()

}
