% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/which_grepl_linter.R
\name{which_grepl_linter}
\alias{which_grepl_linter}
\title{Require usage of grep over which(grepl(.))}
\usage{
which_grepl_linter()
}
\description{
\code{which(grepl(pattern, x))} is the same as \code{grep(pattern, x)}, but harder
to read and requires two passes over the vector.
}
\examples{
# will produce lints
lint(
  text = "which(grepl('^a', x))",
  linters = which_grepl_linter()
)

# okay
lint(
  text = "which(grepl('^a', x) | grepl('^b', x))",
  linters = which_grepl_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=consistency_linters]{consistency}, \link[=efficiency_linters]{efficiency}, \link[=readability_linters]{readability}, \link[=regex_linters]{regex}
}
