% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrangeGrob.r
\name{arrangeGrob}
\alias{arrangeGrob}
\alias{grid.arrange}
\alias{marrangeGrob}
\alias{grid.arrange}
\alias{marrangeGrob}
\title{Arrange multiple grobs on a page}
\usage{
arrangeGrob(..., grobs = list(...), layout_matrix, vp = NULL,
  name = "arrange", as.table = TRUE, respect = FALSE, clip = "off",
  nrow = NULL, ncol = NULL, widths = NULL, heights = NULL, top = NULL,
  bottom = NULL, left = NULL, right = NULL, padding = unit(0.5, "line"))

grid.arrange(..., newpage = TRUE)

marrangeGrob(grobs, ..., ncol, nrow, layout_matrix = matrix(seq_len(nrow *
  ncol), nrow = nrow, ncol = ncol), top = quote(paste("page", g, "of",
  npages)))
}
\arguments{
\item{...}{grobs, gtables, ggplot or trellis objects}

\item{grobs}{list of grobs}

\item{layout_matrix}{optional layout}

\item{vp}{viewport}

\item{name}{argument of gtable}

\item{as.table}{logical: bottom-left to top-right (TRUE) or top-left to bottom-right (FALSE)}

\item{respect}{argument of gtable}

\item{clip}{argument of gtable}

\item{nrow}{argument of gtable}

\item{ncol}{argument of gtable}

\item{widths}{argument of gtable}

\item{heights}{argument of gtable}

\item{top}{optional string, or grob}

\item{bottom}{optional string, or grob}

\item{left}{optional string, or grob}

\item{right}{optional string, or grob}

\item{padding}{unit of length one, margin around annotations}

\item{newpage}{open a new page}
}
\value{
arrangeGrob returns a gtable.

marrangeGrob returns a list of class arrangelist
}
\description{
Set up a gtable layout to place multiple grobs on a page.
}
\details{
Using marrangeGrob, if the layout specifies both nrow and ncol, the list of grobs can be split into multiple pages. On interactive devices print opens new windows, whilst non-interactive devices such as pdf call grid.newpage() between the drawings.
}
\section{Functions}{
\itemize{
\item \code{arrangeGrob}: return a grob without drawing

\item \code{grid.arrange}: draw on the current device

\item \code{marrangeGrob}: interface to arrangeGrob that can dispatch on multiple pages
}}

\examples{
library(grid)
grid.arrange(rectGrob(), rectGrob())
\dontrun{ 
library(ggplot2)
pl <- lapply(1:11, function(.x) qplot(1:10, rnorm(10), main=paste("plot", .x)))
ml <- marrangeGrob(pl, nrow=2, ncol=2)
## non-interactive use, multipage pdf
ggsave("multipage.pdf", ml)
## interactive use; open new devices
ml
}
}
