% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation.R
\name{dyAnnotation}
\alias{dyAnnotation}
\title{Annotation for dygraph chart}
\usage{
dyAnnotation(dygraph, x, text, tooltip = NULL, width = NULL,
  height = NULL, cssClass = NULL, tickHeight = NULL,
  attachAtBottom = FALSE, clickHandler = NULL, mouseOverHandler = NULL,
  mouseOutHandler = NULL, dblClickHandler = NULL, series = NULL)
}
\arguments{
\item{dygraph}{Dygraph to add an annotation to}

\item{x}{Either numeric or date value indicating where to place the
annotation. For date value, this should be of class \code{POSIXct} or
convertible to \code{POSIXct}.}

\item{text}{Text to overlay on the chart at the location of x}

\item{tooltip}{Additional tooltip text to display on mouse hover}

\item{width}{Width (in pixels) of the annotation flag.}

\item{height}{Height (in pixels) of the annotation flag.}

\item{cssClass}{CSS class to use for styling the annotation.}

\item{tickHeight}{Height of the tick mark (in pixels) connecting the point to
its flag or icon.}

\item{attachAtBottom}{If true, attach annotations to the x-axis, rather than 
to actual points.}

\item{clickHandler}{JavaScript function to call when an annotation is 
clicked.}

\item{mouseOverHandler}{JavaScript function to call when the mouse hovers 
over an annotation.}

\item{mouseOutHandler}{JavaScript function to call when the mouse exits an 
annotation.}

\item{dblClickHandler}{JavaScript function to call when an annotation is 
double clicked.}

\item{series}{Series to attach the annotation to. By default, the last series
defined using \code{\link{dySeries}}.}
}
\value{
Dygraph with specified annotation
}
\description{
Define a text annotation for a data-point on a dygraph chart.
}
\note{
Annotations are bound to specific series in the input data. If you have
  only one series or if you define annotations immediately after a call to 
  \code{\link{dySeries}} then you need not specify the series explicitly. 
  Otherwise, you should use the \code{series} parameter to indicate which
  series the annotation should be bound to.
  
  Annotation event handlers can also specified globally (see 
  \code{\link{dyCallbacks}}).

See the
  \href{https://rstudio.github.io/dygraphs/gallery-annotations.html}{online
  documentation} for additional details and examples.
}
\examples{
library(dygraphs)
  
dygraph(presidents, main = "Presidential Approval") \%>\%
  dyAxis("y", valueRange = c(0, 100)) \%>\%
  dyAnnotation("1950-7-1", text = "A", tooltip = "Korea") \%>\%
  dyAnnotation("1965-1-1", text = "B", tooltip = "Vietnam")   
  
}
