% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step.R
\name{collect.dtplyr_step}
\alias{collect.dtplyr_step}
\alias{compute.dtplyr_step}
\alias{as.data.table.dtplyr_step}
\alias{as.data.frame.dtplyr_step}
\alias{as_tibble.dtplyr_step}
\title{Force computation of a lazy data.table}
\usage{
\method{collect}{dtplyr_step}(x, ...)

\method{compute}{dtplyr_step}(x, name = unique_name(), ...)

\method{as.data.table}{dtplyr_step}(x, keep.rownames = FALSE, ...)

\method{as.data.frame}{dtplyr_step}(x, ...)

\method{as_tibble}{dtplyr_step}(x, ..., .name_repair = "check_unique")
}
\arguments{
\item{x}{A \link{lazy_dt}}

\item{...}{Arguments used by other methods.}

\item{name}{Name of intermediate data.table.}

\item{keep.rownames}{Ignored as dplyr never preserves rownames.}

\item{.name_repair}{Treatment of problematic column names}
}
\description{
\itemize{
\item \code{collect()} returns a tibble, grouped if needed.
\item \code{compute()} generates an intermediate assignment in the translation.
\item \code{as.data.table()} returns a data.table.
\item \code{as.data.frame()} returns a data frame.
\item \code{as_tibble()} returns a tibble.
}
}
\examples{
library(dplyr, warn.conflicts = FALSE)

dt <- lazy_dt(mtcars)

# Generate translation
avg_mpg <- dt \%>\%
  filter(am == 1) \%>\%
  group_by(cyl) \%>\%
  summarise(mpg = mean(mpg))

# Show translation and temporarily compute result
avg_mpg

# compute and return tibble
avg_mpg_tb <- as_tibble(avg_mpg)
avg_mpg_tb

# compute and return data.table
avg_mpg_dt <- data.table::as.data.table(avg_mpg)
avg_mpg_dt

# modify translation to use intermediate assignment
compute(avg_mpg)

}
