% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCWL.R
\name{plotCWL}
\alias{plotCWL}
\title{plotCWL}
\usage{
plotCWL(cwl, output = "graph", layout = "tree", ...)
}
\arguments{
\item{cwl}{A cwlWorkflow object to plot}

\item{output}{A string specifying the output type. An option
inherits from `render_graph` and can also be "mermaid".}

\item{layout}{Layout from `render_graph`.}

\item{...}{other parameters from `mermaid` or `render_graph`
function}
}
\value{
A workflow plot.
}
\description{
Function to plot cwlWorkflow object.
}
\examples{
input1 <- InputParam(id = "sth")
echo1 <- cwlProcess(baseCommand = "echo",
                  inputs = InputParamList(input1))
input2 <- InputParam(id = "sthout", type = "File")
echo2 <- cwlProcess(baseCommand = "echo",
                  inputs = InputParamList(input2),
                  stdout = "out.txt")
i1 <- InputParam(id = "sth")
o1 <- OutputParam(id = "out", type = "File", outputSource = "echo2/output")
wf <- cwlWorkflow(inputs = InputParamList(i1),
                   outputs = OutputParamList(o1))
s1 <- cwlStep(id = "echo1", run = echo1, In = list(sth = "sth"))
s2 <- cwlStep(id = "echo2", run = echo2, In = list(sthout = "echo1/output"))
wf <- wf + s1 + s2
plotCWL(wf)
}
