# -*- coding: utf-8 -*-
# Copyright (C) 2012, Almar Klein
#
# Visvis is distributed under the terms of the (new) BSD License.
# The full license can be found in 'license.txt'.

import numpy as np
import visvis as vv

import sys
import zlib
import base64

# todo: parameterize; allow custum Gaussian blobs at specified positions.

if False:
    # Get data (exported from Matlab)
    from visvis import ssdf
    db = ssdf.load('d:/almar/projects/peaks.ssdf')
    data = db.z.astype(np.float32)

    # Dump
    data = data.tostring()
    data = zlib.compress(data)
    text = base64.encodebytes(data)
    print(text)

def peaks():
    """ peaks()

    Returs a 2D map of z-values that represent an example landscape with
    Gaussian blobs.

    """

    # Decode z data
    base64decode = base64.decodebytes if sys.version_info > (3, ) else base64.decodestring
    data = base64decode(zData.encode('ascii'))
    data = zlib.decompress(data)
    z = np.frombuffer(data, dtype=np.float32 )
    z.shape = 49, 49

    # Done!
    return z


zData = """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==
"""

if __name__ == "__main__":
    m = vv.surf(peaks())
