# -*- coding: utf-8 -*-

import re
from setuptools import setup
from setuptools import find_packages

REQUIRES = [
    'six>=1.9.0',
    'webargs>=0.18.0',
    'marshmallow-sqlalchemy>=0.6.0',
]

def find_version(fname):
    """Attempts to find the version number in the file names fname.
    Raises RuntimeError if not found.
    """
    version = ''
    with open(fname, 'r') as fp:
        reg = re.compile(r'__version__ = [\'"]([^\'"]*)[\'"]')
        for line in fp:
            m = reg.match(line)
            if m:
                version = m.group(1)
                break
    if not version:
        raise RuntimeError('Cannot find version information')
    return version

def read(fname):
    with open(fname) as fp:
        content = fp.read()
    return content

setup(
    name='filteralchemy-fork',
    version=find_version('filteralchemy/__init__.py'),
    description=(
        'Declarative query builder for SQLAlchemy. This is a fork of the '
        'original project with the changes of https://github.com/jmcarp/filteralchemy/pull/2 '
        'applied'
    ),
    long_description=read('README.rst'),
    author='Matias Lang',
    author_email='shareman1204@gmail.com',
    url='https://github.com/infobyte/filteralchemy',
    packages=find_packages(exclude=('test*', )),
    package_dir={'filteralchemy': 'filteralchemy'},
    include_package_data=True,
    install_requires=REQUIRES,
    license=read('LICENSE'),
    zip_safe=False,
    keywords='filteralchemy',
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Natural Language :: English',
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.3',
        'Programming Language :: Python :: 3.4',
    ],
    test_suite='tests'
)
