require 'spec_helper'

describe 'collectd::plugin::fscache', type: :class do
  test_on = {
    hardwaremodels: ['x86_64'],
    supported_os: [
      {
        'operatingsystem'        => 'FreeBSD',
        'operatingsystemrelease' => %w[9 10]
      }
    ]
  }

  on_supported_os(test_on).each do |_os, facts|
    let(:facts) { facts }
  end

  context ':ensure => present' do
    it 'Will create 10-fscache.conf' do
      is_expected.to contain_file('fscache.load').with(
        ensure: 'present',
        path: '/usr/local/etc/collectd/10-fscache.conf',
        content: %r{\#\ Generated by Puppet\n<LoadPlugin fscache>\n}
      )
    end
  end

  context ':ensure => absent' do
    let(:params) { { ensure: 'absent' } }

    it 'Will not create 10-fscache.conf' do
      is_expected.to contain_file('fscache.load').with(
        ensure: 'absent',
        path: '/usr/local/etc/collectd/10-fscache.conf'
      )
    end
  end
end
