/*
 * Decompiled with CFR 0.152.
 */
package ork;

import java.util.Vector;
import ork.FileListLoader;
import ork.OracleTNSSocket;

public class SIDList
extends FileListLoader {
    private String m_sHostname = null;
    private int m_nPort = 1521;
    private int m_nError = 0;
    public static final int ERROR_HOST_NOT_FOUND = -1000;
    public static final int ERROR_CONNECTION_FAILED = -1001;
    public static final int ERROR_GETSIDS_FAILED = -1002;
    public static final int OK = 0;

    public SIDList() {
    }

    public SIDList(String sHost, int nPort) {
        this.m_sHostname = sHost;
        this.m_nPort = nPort;
    }

    public void dumpSIDs() {
        System.err.println("SIDs");
        System.err.println("====");
        int i = 0;
        while (i < this.size()) {
            System.err.println((String)this.get(i));
            ++i;
        }
    }

    public void setHostname(String sHostname) {
        this.m_sHostname = sHostname;
    }

    public void setPort(int nPort) {
        this.m_nPort = nPort;
    }

    public String getNextSID() {
        return this.getNextItem();
    }

    public String getErrorMessage() {
        if (this.m_nError == -1001) {
            return "Connetion to server failed";
        }
        if (this.m_nError == -1000) {
            return "The host was not found";
        }
        if (this.m_nError == -1002) {
            return "Failed to retrieve sids";
        }
        return "";
    }

    public int retrieveSids() {
        OracleTNSSocket oTNSSock = null;
        if (this.m_sHostname == null) {
            this.m_nError = -1000;
        }
        if (!(oTNSSock = new OracleTNSSocket(this.m_sHostname, this.m_nPort)).connect()) {
            this.m_nError = -1001;
        }
        Vector oTmp = oTNSSock.getOracleSIDS();
        oTNSSock.close();
        if (oTmp == null || oTmp.size() == 0) {
            return -1002;
        }
        int i = 0;
        while (i < oTmp.size()) {
            this.add((String)oTmp.get(i));
            ++i;
        }
        return this.m_nError;
    }
}

