/*************************************************************************
 * odil - Copyright (C) Universite de Strasbourg
 * Distributed under the terms of the CeCILL-B license, as published by
 * the CEA-CNRS-INRIA. Refer to the LICENSE file or to
 * http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 * for details.
 ************************************************************************/

#include <map>
#include <string>
#include <tuple>

#include "odil/ElementsDictionary.h"
#include "odil/Tag.h"

namespace odil
{

namespace registry
{

void update_0022(
    ElementsDictionary & public_dictionary,
    std::map<std::string, odil::Tag> & public_tags)
{

    public_dictionary.emplace(Tag(0x0022, 0x0001), ElementsDictionaryEntry("Light Path Filter Pass-Through Wavelength", "LightPathFilterPassThroughWavelength",  "US", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0002), ElementsDictionaryEntry("Light Path Filter Pass Band", "LightPathFilterPassBand",  "US", "2"));
    public_dictionary.emplace(Tag(0x0022, 0x0003), ElementsDictionaryEntry("Image Path Filter Pass-Through Wavelength", "ImagePathFilterPassThroughWavelength",  "US", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0004), ElementsDictionaryEntry("Image Path Filter Pass Band", "ImagePathFilterPassBand",  "US", "2"));
    public_dictionary.emplace(Tag(0x0022, 0x0005), ElementsDictionaryEntry("Patient Eye Movement Commanded", "PatientEyeMovementCommanded",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0006), ElementsDictionaryEntry("Patient Eye Movement Command Code Sequence", "PatientEyeMovementCommandCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0007), ElementsDictionaryEntry("Spherical Lens Power", "SphericalLensPower",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0008), ElementsDictionaryEntry("Cylinder Lens Power", "CylinderLensPower",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0009), ElementsDictionaryEntry("Cylinder Axis", "CylinderAxis",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x000a), ElementsDictionaryEntry("Emmetropic Magnification", "EmmetropicMagnification",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x000b), ElementsDictionaryEntry("Intra Ocular Pressure", "IntraOcularPressure",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x000c), ElementsDictionaryEntry("Horizontal Field of View", "HorizontalFieldOfView",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x000d), ElementsDictionaryEntry("Pupil Dilated", "PupilDilated",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x000e), ElementsDictionaryEntry("Degree of Dilation", "DegreeOfDilation",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0010), ElementsDictionaryEntry("Stereo Baseline Angle", "StereoBaselineAngle",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0011), ElementsDictionaryEntry("Stereo Baseline Displacement", "StereoBaselineDisplacement",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0012), ElementsDictionaryEntry("Stereo Horizontal Pixel Offset", "StereoHorizontalPixelOffset",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0013), ElementsDictionaryEntry("Stereo Vertical Pixel Offset", "StereoVerticalPixelOffset",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0014), ElementsDictionaryEntry("Stereo Rotation", "StereoRotation",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0015), ElementsDictionaryEntry("Acquisition Device Type Code Sequence", "AcquisitionDeviceTypeCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0016), ElementsDictionaryEntry("Illumination Type Code Sequence", "IlluminationTypeCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0017), ElementsDictionaryEntry("Light Path Filter Type Stack Code Sequence", "LightPathFilterTypeStackCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0018), ElementsDictionaryEntry("Image Path Filter Type Stack Code Sequence", "ImagePathFilterTypeStackCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0019), ElementsDictionaryEntry("Lenses Code Sequence", "LensesCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x001a), ElementsDictionaryEntry("Channel Description Code Sequence", "ChannelDescriptionCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x001b), ElementsDictionaryEntry("Refractive State Sequence", "RefractiveStateSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x001c), ElementsDictionaryEntry("Mydriatic Agent Code Sequence", "MydriaticAgentCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x001d), ElementsDictionaryEntry("Relative Image Position Code Sequence", "RelativeImagePositionCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x001e), ElementsDictionaryEntry("Camera Angle of View", "CameraAngleOfView",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0020), ElementsDictionaryEntry("Stereo Pairs Sequence", "StereoPairsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0021), ElementsDictionaryEntry("Left Image Sequence", "LeftImageSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0022), ElementsDictionaryEntry("Right Image Sequence", "RightImageSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0028), ElementsDictionaryEntry("Stereo Pairs Present", "StereoPairsPresent",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0030), ElementsDictionaryEntry("Axial Length of the Eye", "AxialLengthOfTheEye",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0031), ElementsDictionaryEntry("Ophthalmic Frame Location Sequence", "OphthalmicFrameLocationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0032), ElementsDictionaryEntry("Reference Coordinates", "ReferenceCoordinates",  "FL", "2-2n"));
    public_dictionary.emplace(Tag(0x0022, 0x0035), ElementsDictionaryEntry("Depth Spatial Resolution", "DepthSpatialResolution",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0036), ElementsDictionaryEntry("Maximum Depth Distortion", "MaximumDepthDistortion",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0037), ElementsDictionaryEntry("Along-scan Spatial Resolution", "AlongScanSpatialResolution",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0038), ElementsDictionaryEntry("Maximum Along-scan Distortion", "MaximumAlongScanDistortion",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0039), ElementsDictionaryEntry("Ophthalmic Image Orientation", "OphthalmicImageOrientation",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0041), ElementsDictionaryEntry("Depth of Transverse Image", "DepthOfTransverseImage",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0042), ElementsDictionaryEntry("Mydriatic Agent Concentration Units Sequence", "MydriaticAgentConcentrationUnitsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0048), ElementsDictionaryEntry("Across-scan Spatial Resolution", "AcrossScanSpatialResolution",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0049), ElementsDictionaryEntry("Maximum Across-scan Distortion", "MaximumAcrossScanDistortion",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x004e), ElementsDictionaryEntry("Mydriatic Agent Concentration", "MydriaticAgentConcentration",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0055), ElementsDictionaryEntry("Illumination Wave Length", "IlluminationWaveLength",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0056), ElementsDictionaryEntry("Illumination Power", "IlluminationPower",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0057), ElementsDictionaryEntry("Illumination Bandwidth", "IlluminationBandwidth",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x0058), ElementsDictionaryEntry("Mydriatic Agent Sequence", "MydriaticAgentSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1007), ElementsDictionaryEntry("Ophthalmic Axial Measurements Right Eye Sequence", "OphthalmicAxialMeasurementsRightEyeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1008), ElementsDictionaryEntry("Ophthalmic Axial Measurements Left Eye Sequence", "OphthalmicAxialMeasurementsLeftEyeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1009), ElementsDictionaryEntry("Ophthalmic Axial Measurements Device Type", "OphthalmicAxialMeasurementsDeviceType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1010), ElementsDictionaryEntry("Ophthalmic Axial Length Measurements Type", "OphthalmicAxialLengthMeasurementsType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1012), ElementsDictionaryEntry("Ophthalmic Axial Length Sequence", "OphthalmicAxialLengthSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1019), ElementsDictionaryEntry("Ophthalmic Axial Length", "OphthalmicAxialLength",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1024), ElementsDictionaryEntry("Lens Status Code Sequence", "LensStatusCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1025), ElementsDictionaryEntry("Vitreous Status Code Sequence", "VitreousStatusCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1028), ElementsDictionaryEntry("IOL Formula Code Sequence", "IOLFormulaCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1029), ElementsDictionaryEntry("IOL Formula Detail", "IOLFormulaDetail",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1033), ElementsDictionaryEntry("Keratometer Index", "KeratometerIndex",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1035), ElementsDictionaryEntry("Source of Ophthalmic Axial Length Code Sequence", "SourceOfOphthalmicAxialLengthCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1036), ElementsDictionaryEntry("Source of Corneal Size Data Code Sequence", "SourceOfCornealSizeDataCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1037), ElementsDictionaryEntry("Target Refraction", "TargetRefraction",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1039), ElementsDictionaryEntry("Refractive Procedure Occurred", "RefractiveProcedureOccurred",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1040), ElementsDictionaryEntry("Refractive Surgery Type Code Sequence", "RefractiveSurgeryTypeCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1044), ElementsDictionaryEntry("Ophthalmic Ultrasound Method Code Sequence", "OphthalmicUltrasoundMethodCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1045), ElementsDictionaryEntry("Surgically Induced Astigmatism Sequence", "SurgicallyInducedAstigmatismSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1046), ElementsDictionaryEntry("Type of Optical Correction", "TypeOfOpticalCorrection",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1047), ElementsDictionaryEntry("Toric IOL Power Sequence", "ToricIOLPowerSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1048), ElementsDictionaryEntry("Predicted Toric Error Sequence", "PredictedToricErrorSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1049), ElementsDictionaryEntry("Pre-Selected for Implantation", "PreSelectedForImplantation",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x104a), ElementsDictionaryEntry("Toric IOL Power for Exact Emmetropia Sequence", "ToricIOLPowerForExactEmmetropiaSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x104b), ElementsDictionaryEntry("Toric IOL Power for Exact Target Refraction Sequence", "ToricIOLPowerForExactTargetRefractionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1050), ElementsDictionaryEntry("Ophthalmic Axial Length Measurements Sequence", "OphthalmicAxialLengthMeasurementsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1053), ElementsDictionaryEntry("IOL Power", "IOLPower",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1054), ElementsDictionaryEntry("Predicted Refractive Error", "PredictedRefractiveError",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1059), ElementsDictionaryEntry("Ophthalmic Axial Length Velocity", "OphthalmicAxialLengthVelocity",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1065), ElementsDictionaryEntry("Lens Status Description", "LensStatusDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1066), ElementsDictionaryEntry("Vitreous Status Description", "VitreousStatusDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1090), ElementsDictionaryEntry("IOL Power Sequence", "IOLPowerSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1092), ElementsDictionaryEntry("Lens Constant Sequence", "LensConstantSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1093), ElementsDictionaryEntry("IOL Manufacturer", "IOLManufacturer",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1094), ElementsDictionaryEntry("Lens Constant Description", "LensConstantDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1095), ElementsDictionaryEntry("Implant Name", "ImplantName",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1096), ElementsDictionaryEntry("Keratometry Measurement Type Code Sequence", "KeratometryMeasurementTypeCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1097), ElementsDictionaryEntry("Implant Part Number", "ImplantPartNumber",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1100), ElementsDictionaryEntry("Referenced Ophthalmic Axial Measurements Sequence", "ReferencedOphthalmicAxialMeasurementsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1101), ElementsDictionaryEntry("Ophthalmic Axial Length Measurements Segment Name Code Sequence", "OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1103), ElementsDictionaryEntry("Refractive Error Before Refractive Surgery Code Sequence", "RefractiveErrorBeforeRefractiveSurgeryCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1121), ElementsDictionaryEntry("IOL Power For Exact Emmetropia", "IOLPowerForExactEmmetropia",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1122), ElementsDictionaryEntry("IOL Power For Exact Target Refraction", "IOLPowerForExactTargetRefraction",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1125), ElementsDictionaryEntry("Anterior Chamber Depth Definition Code Sequence", "AnteriorChamberDepthDefinitionCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1127), ElementsDictionaryEntry("Lens Thickness Sequence", "LensThicknessSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1128), ElementsDictionaryEntry("Anterior Chamber Depth Sequence", "AnteriorChamberDepthSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x112a), ElementsDictionaryEntry("Calculation Comment Sequence", "CalculationCommentSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x112b), ElementsDictionaryEntry("Calculation Comment Type", "CalculationCommentType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x112c), ElementsDictionaryEntry("Calculation Comment", "CalculationComment",  "LT", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1130), ElementsDictionaryEntry("Lens Thickness", "LensThickness",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1131), ElementsDictionaryEntry("Anterior Chamber Depth", "AnteriorChamberDepth",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1132), ElementsDictionaryEntry("Source of Lens Thickness Data Code Sequence", "SourceOfLensThicknessDataCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1133), ElementsDictionaryEntry("Source of Anterior Chamber Depth Data Code Sequence", "SourceOfAnteriorChamberDepthDataCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1134), ElementsDictionaryEntry("Source of Refractive Measurements Sequence", "SourceOfRefractiveMeasurementsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1135), ElementsDictionaryEntry("Source of Refractive Measurements Code Sequence", "SourceOfRefractiveMeasurementsCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1140), ElementsDictionaryEntry("Ophthalmic Axial Length Measurement Modified", "OphthalmicAxialLengthMeasurementModified",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1150), ElementsDictionaryEntry("Ophthalmic Axial Length Data Source Code Sequence", "OphthalmicAxialLengthDataSourceCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1153), ElementsDictionaryEntry("Ophthalmic Axial Length Acquisition Method Code Sequence", "OphthalmicAxialLengthAcquisitionMethodCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1155), ElementsDictionaryEntry("Signal to Noise Ratio", "SignalToNoiseRatio",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1159), ElementsDictionaryEntry("Ophthalmic Axial Length Data Source Description", "OphthalmicAxialLengthDataSourceDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1210), ElementsDictionaryEntry("Ophthalmic Axial Length Measurements Total Length Sequence", "OphthalmicAxialLengthMeasurementsTotalLengthSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1211), ElementsDictionaryEntry("Ophthalmic Axial Length Measurements Segmental Length Sequence", "OphthalmicAxialLengthMeasurementsSegmentalLengthSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1212), ElementsDictionaryEntry("Ophthalmic Axial Length Measurements Length Summation Sequence", "OphthalmicAxialLengthMeasurementsLengthSummationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1220), ElementsDictionaryEntry("Ultrasound Ophthalmic Axial Length Measurements Sequence", "UltrasoundOphthalmicAxialLengthMeasurementsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1225), ElementsDictionaryEntry("Optical Ophthalmic Axial Length Measurements Sequence", "OpticalOphthalmicAxialLengthMeasurementsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1230), ElementsDictionaryEntry("Ultrasound Selected Ophthalmic Axial Length Sequence", "UltrasoundSelectedOphthalmicAxialLengthSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1250), ElementsDictionaryEntry("Ophthalmic Axial Length Selection Method Code Sequence", "OphthalmicAxialLengthSelectionMethodCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1255), ElementsDictionaryEntry("Optical Selected Ophthalmic Axial Length Sequence", "OpticalSelectedOphthalmicAxialLengthSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1257), ElementsDictionaryEntry("Selected Segmental Ophthalmic Axial Length Sequence", "SelectedSegmentalOphthalmicAxialLengthSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1260), ElementsDictionaryEntry("Selected Total Ophthalmic Axial Length Sequence", "SelectedTotalOphthalmicAxialLengthSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1262), ElementsDictionaryEntry("Ophthalmic Axial Length Quality Metric Sequence", "OphthalmicAxialLengthQualityMetricSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1265), ElementsDictionaryEntry("Ophthalmic Axial Length Quality Metric Type Code Sequence", "OphthalmicAxialLengthQualityMetricTypeCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1273), ElementsDictionaryEntry("Ophthalmic Axial Length Quality Metric Type Description", "OphthalmicAxialLengthQualityMetricTypeDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1300), ElementsDictionaryEntry("Intraocular Lens Calculations Right Eye Sequence", "IntraocularLensCalculationsRightEyeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1310), ElementsDictionaryEntry("Intraocular Lens Calculations Left Eye Sequence", "IntraocularLensCalculationsLeftEyeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1330), ElementsDictionaryEntry("Referenced Ophthalmic Axial Length Measurement QC Image Sequence", "ReferencedOphthalmicAxialLengthMeasurementQCImageSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1415), ElementsDictionaryEntry("Ophthalmic Mapping Device Type", "OphthalmicMappingDeviceType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1420), ElementsDictionaryEntry("Acquisition Method Code Sequence", "AcquisitionMethodCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1423), ElementsDictionaryEntry("Acquisition Method Algorithm Sequence", "AcquisitionMethodAlgorithmSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1436), ElementsDictionaryEntry("Ophthalmic Thickness Map Type Code Sequence", "OphthalmicThicknessMapTypeCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1443), ElementsDictionaryEntry("Ophthalmic Thickness Mapping Normals Sequence", "OphthalmicThicknessMappingNormalsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1445), ElementsDictionaryEntry("Retinal Thickness Definition Code Sequence", "RetinalThicknessDefinitionCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1450), ElementsDictionaryEntry("Pixel Value Mapping to Coded Concept Sequence", "PixelValueMappingToCodedConceptSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1452), ElementsDictionaryEntry("Mapped Pixel Value", "MappedPixelValue",  "US or SS", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1454), ElementsDictionaryEntry("Pixel Value Mapping Explanation", "PixelValueMappingExplanation",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1458), ElementsDictionaryEntry("Ophthalmic Thickness Map Quality Threshold Sequence", "OphthalmicThicknessMapQualityThresholdSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1460), ElementsDictionaryEntry("Ophthalmic Thickness Map Threshold Quality Rating", "OphthalmicThicknessMapThresholdQualityRating",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1463), ElementsDictionaryEntry("Anatomic Structure Reference Point", "AnatomicStructureReferencePoint",  "FL", "2"));
    public_dictionary.emplace(Tag(0x0022, 0x1465), ElementsDictionaryEntry("Registration to Localizer Sequence", "RegistrationToLocalizerSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1466), ElementsDictionaryEntry("Registered Localizer Units", "RegisteredLocalizerUnits",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1467), ElementsDictionaryEntry("Registered Localizer Top Left Hand Corner", "RegisteredLocalizerTopLeftHandCorner",  "FL", "2"));
    public_dictionary.emplace(Tag(0x0022, 0x1468), ElementsDictionaryEntry("Registered Localizer Bottom Right Hand Corner", "RegisteredLocalizerBottomRightHandCorner",  "FL", "2"));
    public_dictionary.emplace(Tag(0x0022, 0x1470), ElementsDictionaryEntry("Ophthalmic Thickness Map Quality Rating Sequence", "OphthalmicThicknessMapQualityRatingSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1472), ElementsDictionaryEntry("Relevant OPT Attributes Sequence", "RelevantOPTAttributesSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1512), ElementsDictionaryEntry("Transformation Method Code Sequence", "TransformationMethodCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1513), ElementsDictionaryEntry("Transformation Algorithm Sequence", "TransformationAlgorithmSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1515), ElementsDictionaryEntry("Ophthalmic Axial Length Method", "OphthalmicAxialLengthMethod",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1517), ElementsDictionaryEntry("Ophthalmic FOV", "OphthalmicFOV",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1518), ElementsDictionaryEntry("Two Dimensional to Three Dimensional Map Sequence", "TwoDimensionalToThreeDimensionalMapSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1525), ElementsDictionaryEntry("Wide Field Ophthalmic Photography Quality Rating Sequence", "WideFieldOphthalmicPhotographyQualityRatingSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1526), ElementsDictionaryEntry("Wide Field Ophthalmic Photography Quality Threshold Sequence", "WideFieldOphthalmicPhotographyQualityThresholdSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1527), ElementsDictionaryEntry("Wide Field Ophthalmic Photography Threshold Quality Rating", "WideFieldOphthalmicPhotographyThresholdQualityRating",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1528), ElementsDictionaryEntry("X Coordinates Center Pixel View Angle", "XCoordinatesCenterPixelViewAngle",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1529), ElementsDictionaryEntry("Y Coordinates Center Pixel View Angle", "YCoordinatesCenterPixelViewAngle",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1530), ElementsDictionaryEntry("Number of Map Points", "NumberOfMapPoints",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1531), ElementsDictionaryEntry("Two Dimensional to Three Dimensional Map Data", "TwoDimensionalToThreeDimensionalMapData",  "OF", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1612), ElementsDictionaryEntry("Derivation Algorithm Sequence", "DerivationAlgorithmSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1615), ElementsDictionaryEntry("Ophthalmic Image Type Code Sequence", "OphthalmicImageTypeCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1616), ElementsDictionaryEntry("Ophthalmic Image Type Description", "OphthalmicImageTypeDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1618), ElementsDictionaryEntry("Scan Pattern Type Code Sequence", "ScanPatternTypeCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1620), ElementsDictionaryEntry("Referenced Surface Mesh Identification Sequence", "ReferencedSurfaceMeshIdentificationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1622), ElementsDictionaryEntry("Ophthalmic Volumetric Properties Flag", "OphthalmicVolumetricPropertiesFlag",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1624), ElementsDictionaryEntry("Ophthalmic Anatomic Reference Point X-Coordinate", "OphthalmicAnatomicReferencePointXCoordinate",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1626), ElementsDictionaryEntry("Ophthalmic Anatomic Reference Point Y-Coordinate", "OphthalmicAnatomicReferencePointYCoordinate",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1628), ElementsDictionaryEntry("Ophthalmic En Face Image Quality Rating Sequence", "OphthalmicEnFaceImageQualityRatingSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1630), ElementsDictionaryEntry("Quality Threshold", "QualityThreshold",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1640), ElementsDictionaryEntry("OCT B-scan Analysis Acquisition Parameters Sequence", "OCTBscanAnalysisAcquisitionParametersSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1642), ElementsDictionaryEntry("Number of B-scans Per Frame", "NumberOfBscansPerFrame",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1643), ElementsDictionaryEntry("B-scan Slab Thickness", "BscanSlabThickness",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1644), ElementsDictionaryEntry("Distance Between B-scan Slabs", "DistanceBetweenBscanSlabs",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1645), ElementsDictionaryEntry("B-scan Cycle Time", "BscanCycleTime",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1646), ElementsDictionaryEntry("B-scan Cycle Time Vector", "BscanCycleTimeVector",  "FL", "1-n"));
    public_dictionary.emplace(Tag(0x0022, 0x1649), ElementsDictionaryEntry("A-scan Rate", "AscanRate",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1650), ElementsDictionaryEntry("B-scan Rate", "BscanRate",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0022, 0x1658), ElementsDictionaryEntry("Surface Mesh Z-Pixel Offset", "SurfaceMeshZPixelOffset",  "UL", "1"));

    public_tags.emplace("LightPathFilterPassThroughWavelength", Tag(0x0022, 0x0001));
    public_tags.emplace("LightPathFilterPassBand", Tag(0x0022, 0x0002));
    public_tags.emplace("ImagePathFilterPassThroughWavelength", Tag(0x0022, 0x0003));
    public_tags.emplace("ImagePathFilterPassBand", Tag(0x0022, 0x0004));
    public_tags.emplace("PatientEyeMovementCommanded", Tag(0x0022, 0x0005));
    public_tags.emplace("PatientEyeMovementCommandCodeSequence", Tag(0x0022, 0x0006));
    public_tags.emplace("SphericalLensPower", Tag(0x0022, 0x0007));
    public_tags.emplace("CylinderLensPower", Tag(0x0022, 0x0008));
    public_tags.emplace("CylinderAxis", Tag(0x0022, 0x0009));
    public_tags.emplace("EmmetropicMagnification", Tag(0x0022, 0x000a));
    public_tags.emplace("IntraOcularPressure", Tag(0x0022, 0x000b));
    public_tags.emplace("HorizontalFieldOfView", Tag(0x0022, 0x000c));
    public_tags.emplace("PupilDilated", Tag(0x0022, 0x000d));
    public_tags.emplace("DegreeOfDilation", Tag(0x0022, 0x000e));
    public_tags.emplace("StereoBaselineAngle", Tag(0x0022, 0x0010));
    public_tags.emplace("StereoBaselineDisplacement", Tag(0x0022, 0x0011));
    public_tags.emplace("StereoHorizontalPixelOffset", Tag(0x0022, 0x0012));
    public_tags.emplace("StereoVerticalPixelOffset", Tag(0x0022, 0x0013));
    public_tags.emplace("StereoRotation", Tag(0x0022, 0x0014));
    public_tags.emplace("AcquisitionDeviceTypeCodeSequence", Tag(0x0022, 0x0015));
    public_tags.emplace("IlluminationTypeCodeSequence", Tag(0x0022, 0x0016));
    public_tags.emplace("LightPathFilterTypeStackCodeSequence", Tag(0x0022, 0x0017));
    public_tags.emplace("ImagePathFilterTypeStackCodeSequence", Tag(0x0022, 0x0018));
    public_tags.emplace("LensesCodeSequence", Tag(0x0022, 0x0019));
    public_tags.emplace("ChannelDescriptionCodeSequence", Tag(0x0022, 0x001a));
    public_tags.emplace("RefractiveStateSequence", Tag(0x0022, 0x001b));
    public_tags.emplace("MydriaticAgentCodeSequence", Tag(0x0022, 0x001c));
    public_tags.emplace("RelativeImagePositionCodeSequence", Tag(0x0022, 0x001d));
    public_tags.emplace("CameraAngleOfView", Tag(0x0022, 0x001e));
    public_tags.emplace("StereoPairsSequence", Tag(0x0022, 0x0020));
    public_tags.emplace("LeftImageSequence", Tag(0x0022, 0x0021));
    public_tags.emplace("RightImageSequence", Tag(0x0022, 0x0022));
    public_tags.emplace("StereoPairsPresent", Tag(0x0022, 0x0028));
    public_tags.emplace("AxialLengthOfTheEye", Tag(0x0022, 0x0030));
    public_tags.emplace("OphthalmicFrameLocationSequence", Tag(0x0022, 0x0031));
    public_tags.emplace("ReferenceCoordinates", Tag(0x0022, 0x0032));
    public_tags.emplace("DepthSpatialResolution", Tag(0x0022, 0x0035));
    public_tags.emplace("MaximumDepthDistortion", Tag(0x0022, 0x0036));
    public_tags.emplace("AlongScanSpatialResolution", Tag(0x0022, 0x0037));
    public_tags.emplace("MaximumAlongScanDistortion", Tag(0x0022, 0x0038));
    public_tags.emplace("OphthalmicImageOrientation", Tag(0x0022, 0x0039));
    public_tags.emplace("DepthOfTransverseImage", Tag(0x0022, 0x0041));
    public_tags.emplace("MydriaticAgentConcentrationUnitsSequence", Tag(0x0022, 0x0042));
    public_tags.emplace("AcrossScanSpatialResolution", Tag(0x0022, 0x0048));
    public_tags.emplace("MaximumAcrossScanDistortion", Tag(0x0022, 0x0049));
    public_tags.emplace("MydriaticAgentConcentration", Tag(0x0022, 0x004e));
    public_tags.emplace("IlluminationWaveLength", Tag(0x0022, 0x0055));
    public_tags.emplace("IlluminationPower", Tag(0x0022, 0x0056));
    public_tags.emplace("IlluminationBandwidth", Tag(0x0022, 0x0057));
    public_tags.emplace("MydriaticAgentSequence", Tag(0x0022, 0x0058));
    public_tags.emplace("OphthalmicAxialMeasurementsRightEyeSequence", Tag(0x0022, 0x1007));
    public_tags.emplace("OphthalmicAxialMeasurementsLeftEyeSequence", Tag(0x0022, 0x1008));
    public_tags.emplace("OphthalmicAxialMeasurementsDeviceType", Tag(0x0022, 0x1009));
    public_tags.emplace("OphthalmicAxialLengthMeasurementsType", Tag(0x0022, 0x1010));
    public_tags.emplace("OphthalmicAxialLengthSequence", Tag(0x0022, 0x1012));
    public_tags.emplace("OphthalmicAxialLength", Tag(0x0022, 0x1019));
    public_tags.emplace("LensStatusCodeSequence", Tag(0x0022, 0x1024));
    public_tags.emplace("VitreousStatusCodeSequence", Tag(0x0022, 0x1025));
    public_tags.emplace("IOLFormulaCodeSequence", Tag(0x0022, 0x1028));
    public_tags.emplace("IOLFormulaDetail", Tag(0x0022, 0x1029));
    public_tags.emplace("KeratometerIndex", Tag(0x0022, 0x1033));
    public_tags.emplace("SourceOfOphthalmicAxialLengthCodeSequence", Tag(0x0022, 0x1035));
    public_tags.emplace("SourceOfCornealSizeDataCodeSequence", Tag(0x0022, 0x1036));
    public_tags.emplace("TargetRefraction", Tag(0x0022, 0x1037));
    public_tags.emplace("RefractiveProcedureOccurred", Tag(0x0022, 0x1039));
    public_tags.emplace("RefractiveSurgeryTypeCodeSequence", Tag(0x0022, 0x1040));
    public_tags.emplace("OphthalmicUltrasoundMethodCodeSequence", Tag(0x0022, 0x1044));
    public_tags.emplace("SurgicallyInducedAstigmatismSequence", Tag(0x0022, 0x1045));
    public_tags.emplace("TypeOfOpticalCorrection", Tag(0x0022, 0x1046));
    public_tags.emplace("ToricIOLPowerSequence", Tag(0x0022, 0x1047));
    public_tags.emplace("PredictedToricErrorSequence", Tag(0x0022, 0x1048));
    public_tags.emplace("PreSelectedForImplantation", Tag(0x0022, 0x1049));
    public_tags.emplace("ToricIOLPowerForExactEmmetropiaSequence", Tag(0x0022, 0x104a));
    public_tags.emplace("ToricIOLPowerForExactTargetRefractionSequence", Tag(0x0022, 0x104b));
    public_tags.emplace("OphthalmicAxialLengthMeasurementsSequence", Tag(0x0022, 0x1050));
    public_tags.emplace("IOLPower", Tag(0x0022, 0x1053));
    public_tags.emplace("PredictedRefractiveError", Tag(0x0022, 0x1054));
    public_tags.emplace("OphthalmicAxialLengthVelocity", Tag(0x0022, 0x1059));
    public_tags.emplace("LensStatusDescription", Tag(0x0022, 0x1065));
    public_tags.emplace("VitreousStatusDescription", Tag(0x0022, 0x1066));
    public_tags.emplace("IOLPowerSequence", Tag(0x0022, 0x1090));
    public_tags.emplace("LensConstantSequence", Tag(0x0022, 0x1092));
    public_tags.emplace("IOLManufacturer", Tag(0x0022, 0x1093));
    public_tags.emplace("LensConstantDescription", Tag(0x0022, 0x1094));
    public_tags.emplace("ImplantName", Tag(0x0022, 0x1095));
    public_tags.emplace("KeratometryMeasurementTypeCodeSequence", Tag(0x0022, 0x1096));
    public_tags.emplace("ImplantPartNumber", Tag(0x0022, 0x1097));
    public_tags.emplace("ReferencedOphthalmicAxialMeasurementsSequence", Tag(0x0022, 0x1100));
    public_tags.emplace("OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence", Tag(0x0022, 0x1101));
    public_tags.emplace("RefractiveErrorBeforeRefractiveSurgeryCodeSequence", Tag(0x0022, 0x1103));
    public_tags.emplace("IOLPowerForExactEmmetropia", Tag(0x0022, 0x1121));
    public_tags.emplace("IOLPowerForExactTargetRefraction", Tag(0x0022, 0x1122));
    public_tags.emplace("AnteriorChamberDepthDefinitionCodeSequence", Tag(0x0022, 0x1125));
    public_tags.emplace("LensThicknessSequence", Tag(0x0022, 0x1127));
    public_tags.emplace("AnteriorChamberDepthSequence", Tag(0x0022, 0x1128));
    public_tags.emplace("CalculationCommentSequence", Tag(0x0022, 0x112a));
    public_tags.emplace("CalculationCommentType", Tag(0x0022, 0x112b));
    public_tags.emplace("CalculationComment", Tag(0x0022, 0x112c));
    public_tags.emplace("LensThickness", Tag(0x0022, 0x1130));
    public_tags.emplace("AnteriorChamberDepth", Tag(0x0022, 0x1131));
    public_tags.emplace("SourceOfLensThicknessDataCodeSequence", Tag(0x0022, 0x1132));
    public_tags.emplace("SourceOfAnteriorChamberDepthDataCodeSequence", Tag(0x0022, 0x1133));
    public_tags.emplace("SourceOfRefractiveMeasurementsSequence", Tag(0x0022, 0x1134));
    public_tags.emplace("SourceOfRefractiveMeasurementsCodeSequence", Tag(0x0022, 0x1135));
    public_tags.emplace("OphthalmicAxialLengthMeasurementModified", Tag(0x0022, 0x1140));
    public_tags.emplace("OphthalmicAxialLengthDataSourceCodeSequence", Tag(0x0022, 0x1150));
    public_tags.emplace("OphthalmicAxialLengthAcquisitionMethodCodeSequence", Tag(0x0022, 0x1153));
    public_tags.emplace("SignalToNoiseRatio", Tag(0x0022, 0x1155));
    public_tags.emplace("OphthalmicAxialLengthDataSourceDescription", Tag(0x0022, 0x1159));
    public_tags.emplace("OphthalmicAxialLengthMeasurementsTotalLengthSequence", Tag(0x0022, 0x1210));
    public_tags.emplace("OphthalmicAxialLengthMeasurementsSegmentalLengthSequence", Tag(0x0022, 0x1211));
    public_tags.emplace("OphthalmicAxialLengthMeasurementsLengthSummationSequence", Tag(0x0022, 0x1212));
    public_tags.emplace("UltrasoundOphthalmicAxialLengthMeasurementsSequence", Tag(0x0022, 0x1220));
    public_tags.emplace("OpticalOphthalmicAxialLengthMeasurementsSequence", Tag(0x0022, 0x1225));
    public_tags.emplace("UltrasoundSelectedOphthalmicAxialLengthSequence", Tag(0x0022, 0x1230));
    public_tags.emplace("OphthalmicAxialLengthSelectionMethodCodeSequence", Tag(0x0022, 0x1250));
    public_tags.emplace("OpticalSelectedOphthalmicAxialLengthSequence", Tag(0x0022, 0x1255));
    public_tags.emplace("SelectedSegmentalOphthalmicAxialLengthSequence", Tag(0x0022, 0x1257));
    public_tags.emplace("SelectedTotalOphthalmicAxialLengthSequence", Tag(0x0022, 0x1260));
    public_tags.emplace("OphthalmicAxialLengthQualityMetricSequence", Tag(0x0022, 0x1262));
    public_tags.emplace("OphthalmicAxialLengthQualityMetricTypeCodeSequence", Tag(0x0022, 0x1265));
    public_tags.emplace("OphthalmicAxialLengthQualityMetricTypeDescription", Tag(0x0022, 0x1273));
    public_tags.emplace("IntraocularLensCalculationsRightEyeSequence", Tag(0x0022, 0x1300));
    public_tags.emplace("IntraocularLensCalculationsLeftEyeSequence", Tag(0x0022, 0x1310));
    public_tags.emplace("ReferencedOphthalmicAxialLengthMeasurementQCImageSequence", Tag(0x0022, 0x1330));
    public_tags.emplace("OphthalmicMappingDeviceType", Tag(0x0022, 0x1415));
    public_tags.emplace("AcquisitionMethodCodeSequence", Tag(0x0022, 0x1420));
    public_tags.emplace("AcquisitionMethodAlgorithmSequence", Tag(0x0022, 0x1423));
    public_tags.emplace("OphthalmicThicknessMapTypeCodeSequence", Tag(0x0022, 0x1436));
    public_tags.emplace("OphthalmicThicknessMappingNormalsSequence", Tag(0x0022, 0x1443));
    public_tags.emplace("RetinalThicknessDefinitionCodeSequence", Tag(0x0022, 0x1445));
    public_tags.emplace("PixelValueMappingToCodedConceptSequence", Tag(0x0022, 0x1450));
    public_tags.emplace("MappedPixelValue", Tag(0x0022, 0x1452));
    public_tags.emplace("PixelValueMappingExplanation", Tag(0x0022, 0x1454));
    public_tags.emplace("OphthalmicThicknessMapQualityThresholdSequence", Tag(0x0022, 0x1458));
    public_tags.emplace("OphthalmicThicknessMapThresholdQualityRating", Tag(0x0022, 0x1460));
    public_tags.emplace("AnatomicStructureReferencePoint", Tag(0x0022, 0x1463));
    public_tags.emplace("RegistrationToLocalizerSequence", Tag(0x0022, 0x1465));
    public_tags.emplace("RegisteredLocalizerUnits", Tag(0x0022, 0x1466));
    public_tags.emplace("RegisteredLocalizerTopLeftHandCorner", Tag(0x0022, 0x1467));
    public_tags.emplace("RegisteredLocalizerBottomRightHandCorner", Tag(0x0022, 0x1468));
    public_tags.emplace("OphthalmicThicknessMapQualityRatingSequence", Tag(0x0022, 0x1470));
    public_tags.emplace("RelevantOPTAttributesSequence", Tag(0x0022, 0x1472));
    public_tags.emplace("TransformationMethodCodeSequence", Tag(0x0022, 0x1512));
    public_tags.emplace("TransformationAlgorithmSequence", Tag(0x0022, 0x1513));
    public_tags.emplace("OphthalmicAxialLengthMethod", Tag(0x0022, 0x1515));
    public_tags.emplace("OphthalmicFOV", Tag(0x0022, 0x1517));
    public_tags.emplace("TwoDimensionalToThreeDimensionalMapSequence", Tag(0x0022, 0x1518));
    public_tags.emplace("WideFieldOphthalmicPhotographyQualityRatingSequence", Tag(0x0022, 0x1525));
    public_tags.emplace("WideFieldOphthalmicPhotographyQualityThresholdSequence", Tag(0x0022, 0x1526));
    public_tags.emplace("WideFieldOphthalmicPhotographyThresholdQualityRating", Tag(0x0022, 0x1527));
    public_tags.emplace("XCoordinatesCenterPixelViewAngle", Tag(0x0022, 0x1528));
    public_tags.emplace("YCoordinatesCenterPixelViewAngle", Tag(0x0022, 0x1529));
    public_tags.emplace("NumberOfMapPoints", Tag(0x0022, 0x1530));
    public_tags.emplace("TwoDimensionalToThreeDimensionalMapData", Tag(0x0022, 0x1531));
    public_tags.emplace("DerivationAlgorithmSequence", Tag(0x0022, 0x1612));
    public_tags.emplace("OphthalmicImageTypeCodeSequence", Tag(0x0022, 0x1615));
    public_tags.emplace("OphthalmicImageTypeDescription", Tag(0x0022, 0x1616));
    public_tags.emplace("ScanPatternTypeCodeSequence", Tag(0x0022, 0x1618));
    public_tags.emplace("ReferencedSurfaceMeshIdentificationSequence", Tag(0x0022, 0x1620));
    public_tags.emplace("OphthalmicVolumetricPropertiesFlag", Tag(0x0022, 0x1622));
    public_tags.emplace("OphthalmicAnatomicReferencePointXCoordinate", Tag(0x0022, 0x1624));
    public_tags.emplace("OphthalmicAnatomicReferencePointYCoordinate", Tag(0x0022, 0x1626));
    public_tags.emplace("OphthalmicEnFaceImageQualityRatingSequence", Tag(0x0022, 0x1628));
    public_tags.emplace("QualityThreshold", Tag(0x0022, 0x1630));
    public_tags.emplace("OCTBscanAnalysisAcquisitionParametersSequence", Tag(0x0022, 0x1640));
    public_tags.emplace("NumberOfBscansPerFrame", Tag(0x0022, 0x1642));
    public_tags.emplace("BscanSlabThickness", Tag(0x0022, 0x1643));
    public_tags.emplace("DistanceBetweenBscanSlabs", Tag(0x0022, 0x1644));
    public_tags.emplace("BscanCycleTime", Tag(0x0022, 0x1645));
    public_tags.emplace("BscanCycleTimeVector", Tag(0x0022, 0x1646));
    public_tags.emplace("AscanRate", Tag(0x0022, 0x1649));
    public_tags.emplace("BscanRate", Tag(0x0022, 0x1650));
    public_tags.emplace("SurfaceMeshZPixelOffset", Tag(0x0022, 0x1658));
}

}

}