
/* autogenerated from motiondetectorc.orc */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifndef _ORC_INTEGER_TYPEDEFS_
#define _ORC_INTEGER_TYPEDEFS_
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#include <stdint.h>
typedef int8_t orc_int8;
typedef int16_t orc_int16;
typedef int32_t orc_int32;
typedef int64_t orc_int64;
typedef uint8_t orc_uint8;
typedef uint16_t orc_uint16;
typedef uint32_t orc_uint32;
typedef uint64_t orc_uint64;
#define ORC_UINT64_C(x) UINT64_C(x)
#elif defined(_MSC_VER)
typedef signed __int8 orc_int8;
typedef signed __int16 orc_int16;
typedef signed __int32 orc_int32;
typedef signed __int64 orc_int64;
typedef unsigned __int8 orc_uint8;
typedef unsigned __int16 orc_uint16;
typedef unsigned __int32 orc_uint32;
typedef unsigned __int64 orc_uint64;
#define ORC_UINT64_C(x) (x##Ui64)
#define inline __inline
#else
#include <limits.h>
typedef signed char orc_int8;
typedef short orc_int16;
typedef int orc_int32;
typedef unsigned char orc_uint8;
typedef unsigned short orc_uint16;
typedef unsigned int orc_uint32;
#if INT_MAX == LONG_MAX
typedef long long orc_int64;
typedef unsigned long long orc_uint64;
#define ORC_UINT64_C(x) (x##ULL)
#else
typedef long orc_int64;
typedef unsigned long orc_uint64;
#define ORC_UINT64_C(x) (x##UL)
#endif
#endif
typedef union { orc_int16 i; orc_int8 x2[2]; } orc_union16;
typedef union { orc_int32 i; float f; orc_int16 x2[2]; orc_int8 x4[4]; } orc_union32;
typedef union { orc_int64 i; double f; orc_int32 x2[2]; float x2f[2]; orc_int16 x4[4]; } orc_union64;
#endif
#ifndef ORC_RESTRICT
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#define ORC_RESTRICT restrict
#elif defined(__GNUC__) && __GNUC__ >= 4
#define ORC_RESTRICT __restrict__
#else
#define ORC_RESTRICT
#endif
#endif

#ifndef DISABLE_ORC
#include <orc/orc.h>
#endif
void image_difference_optimized (orc_uint32 * ORC_RESTRICT a1, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int n, int m);
void image_line_difference_optimized (orc_uint32 * ORC_RESTRICT a1, const orc_uint8 * ORC_RESTRICT s1, const orc_uint8 * ORC_RESTRICT s2, int n);
void image_sum_optimized (int * ORC_RESTRICT a1, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void image_variance_optimized (int * ORC_RESTRICT a1, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, int p2, int n, int m);


/* begin Orc C target preamble */
#define ORC_CLAMP(x,a,b) ((x)<(a) ? (a) : ((x)>(b) ? (b) : (x)))
#define ORC_ABS(a) ((a)<0 ? -(a) : (a))
#define ORC_MIN(a,b) ((a)<(b) ? (a) : (b))
#define ORC_MAX(a,b) ((a)>(b) ? (a) : (b))
#define ORC_SB_MAX 127
#define ORC_SB_MIN (-1-ORC_SB_MAX)
#define ORC_UB_MAX 255
#define ORC_UB_MIN 0
#define ORC_SW_MAX 32767
#define ORC_SW_MIN (-1-ORC_SW_MAX)
#define ORC_UW_MAX 65535
#define ORC_UW_MIN 0
#define ORC_SL_MAX 2147483647
#define ORC_SL_MIN (-1-ORC_SL_MAX)
#define ORC_UL_MAX 4294967295U
#define ORC_UL_MIN 0
#define ORC_CLAMP_SB(x) ORC_CLAMP(x,ORC_SB_MIN,ORC_SB_MAX)
#define ORC_CLAMP_UB(x) ORC_CLAMP(x,ORC_UB_MIN,ORC_UB_MAX)
#define ORC_CLAMP_SW(x) ORC_CLAMP(x,ORC_SW_MIN,ORC_SW_MAX)
#define ORC_CLAMP_UW(x) ORC_CLAMP(x,ORC_UW_MIN,ORC_UW_MAX)
#define ORC_CLAMP_SL(x) ORC_CLAMP(x,ORC_SL_MIN,ORC_SL_MAX)
#define ORC_CLAMP_UL(x) ORC_CLAMP(x,ORC_UL_MIN,ORC_UL_MAX)
#define ORC_SWAP_W(x) ((((x)&0xff)<<8) | (((x)&0xff00)>>8))
#define ORC_SWAP_L(x) ((((x)&0xff)<<24) | (((x)&0xff00)<<8) | (((x)&0xff0000)>>8) | (((x)&0xff000000)>>24))
#define ORC_SWAP_Q(x) ((((x)&ORC_UINT64_C(0xff))<<56) | (((x)&ORC_UINT64_C(0xff00))<<40) | (((x)&ORC_UINT64_C(0xff0000))<<24) | (((x)&ORC_UINT64_C(0xff000000))<<8) | (((x)&ORC_UINT64_C(0xff00000000))>>8) | (((x)&ORC_UINT64_C(0xff0000000000))>>24) | (((x)&ORC_UINT64_C(0xff000000000000))>>40) | (((x)&ORC_UINT64_C(0xff00000000000000))>>56))
#define ORC_PTR_OFFSET(ptr,offset) ((void *)(((unsigned char *)(ptr)) + (offset)))
#define ORC_DENORMAL(x) ((x) & ((((x)&0x7f800000) == 0) ? 0xff800000 : 0xffffffff))
#define ORC_ISNAN(x) ((((x)&0x7f800000) == 0x7f800000) && (((x)&0x007fffff) != 0))
#define ORC_DENORMAL_DOUBLE(x) ((x) & ((((x)&ORC_UINT64_C(0x7ff0000000000000)) == 0) ? ORC_UINT64_C(0xfff0000000000000) : ORC_UINT64_C(0xffffffffffffffff)))
#define ORC_ISNAN_DOUBLE(x) ((((x)&ORC_UINT64_C(0x7ff0000000000000)) == ORC_UINT64_C(0x7ff0000000000000)) && (((x)&ORC_UINT64_C(0x000fffffffffffff)) != 0))
#ifndef ORC_RESTRICT
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#define ORC_RESTRICT restrict
#elif defined(__GNUC__) && __GNUC__ >= 4
#define ORC_RESTRICT __restrict__
#else
#define ORC_RESTRICT
#endif
#endif
/* end Orc C target preamble */



/* image_difference_optimized */
#ifdef DISABLE_ORC
void
image_difference_optimized (orc_uint32 * ORC_RESTRICT a1, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int n, int m){
  int i;
  int j;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_union32 var12 =  { 0 };
  orc_int8 var32;
  orc_int8 var33;

  for (j = 0; j < m; j++) {
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: loadb */
      var33 = ptr5[i];
      /* 2: accsadubl */
      var12.i = var12.i + ORC_ABS((orc_int32)(orc_uint8)var32 - (orc_int32)(orc_uint8)var33);
    }
  }
  *a1 = var12.i;

}

#else
static void
_backup_image_difference_optimized (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_union32 var12 =  { 0 };
  orc_int8 var32;
  orc_int8 var33;

  for (j = 0; j < m; j++) {
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: loadb */
      var33 = ptr5[i];
      /* 2: accsadubl */
      var12.i = var12.i + ORC_ABS((orc_int32)(orc_uint8)var32 - (orc_int32)(orc_uint8)var33);
    }
  }
  ex->accumulators[0] = var12.i;

}

void
image_difference_optimized (orc_uint32 * ORC_RESTRICT a1, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, const orc_uint8 * ORC_RESTRICT s2, int s2_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "image_difference_optimized");
      orc_program_set_backup_function (p, _backup_image_difference_optimized);
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_accumulator (p, 4, "a1");

      orc_program_append_2 (p, "accsadubl", 0, ORC_VAR_A1, ORC_VAR_S1, ORC_VAR_S2, ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  func = c->exec;
  func (ex);
  *a1 = orc_executor_get_accumulator (ex, ORC_VAR_A1);
}
#endif


/* image_line_difference_optimized */
#ifdef DISABLE_ORC
void
image_line_difference_optimized (orc_uint32 * ORC_RESTRICT a1, const orc_uint8 * ORC_RESTRICT s1, const orc_uint8 * ORC_RESTRICT s2, int n){
  int i;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_union32 var12 =  { 0 };
  orc_int8 var32;
  orc_int8 var33;

  ptr4 = (orc_int8 *)s1;
  ptr5 = (orc_int8 *)s2;


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr5[i];
    /* 2: accsadubl */
    var12.i = var12.i + ORC_ABS((orc_int32)(orc_uint8)var32 - (orc_int32)(orc_uint8)var33);
  }
  *a1 = var12.i;

}

#else
static void
_backup_image_line_difference_optimized (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_union32 var12 =  { 0 };
  orc_int8 var32;
  orc_int8 var33;

  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr5[i];
    /* 2: accsadubl */
    var12.i = var12.i + ORC_ABS((orc_int32)(orc_uint8)var32 - (orc_int32)(orc_uint8)var33);
  }
  ex->accumulators[0] = var12.i;

}

void
image_line_difference_optimized (orc_uint32 * ORC_RESTRICT a1, const orc_uint8 * ORC_RESTRICT s1, const orc_uint8 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_name (p, "image_line_difference_optimized");
      orc_program_set_backup_function (p, _backup_image_line_difference_optimized);
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_accumulator (p, 4, "a1");

      orc_program_append_2 (p, "accsadubl", 0, ORC_VAR_A1, ORC_VAR_S1, ORC_VAR_S2, ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
  *a1 = orc_executor_get_accumulator (ex, ORC_VAR_A1);
}
#endif


/* image_sum_optimized */
#ifdef DISABLE_ORC
void
image_sum_optimized (int * ORC_RESTRICT a1, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, int n, int m){
  int i;
  int j;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_union32 var12 =  { 0 };
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;

  for (j = 0; j < m; j++) {
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var34 = ptr4[i];
      /* 1: convubw */
      var35.i = (orc_uint8)var34;
      /* 2: convuwl */
      var36.i = (orc_uint16)var35.i;
      /* 3: accl */
      var12.i = var12.i + var36.i;
    }
  }
  *a1 = var12.i;

}

#else
static void
_backup_image_sum_optimized (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_union32 var12 =  { 0 };
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;

  for (j = 0; j < m; j++) {
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var34 = ptr4[i];
      /* 1: convubw */
      var35.i = (orc_uint8)var34;
      /* 2: convuwl */
      var36.i = (orc_uint16)var35.i;
      /* 3: accl */
      var12.i = var12.i + var36.i;
    }
  }
  ex->accumulators[0] = var12.i;

}

void
image_sum_optimized (int * ORC_RESTRICT a1, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "image_sum_optimized");
      orc_program_set_backup_function (p, _backup_image_sum_optimized);
      orc_program_add_source (p, 1, "s1");
      orc_program_add_accumulator (p, 4, "a1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convuwl", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "accl", 0, ORC_VAR_A1, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
  *a1 = orc_executor_get_accumulator (ex, ORC_VAR_A1);
}
#endif


/* image_variance_optimized */
#ifdef DISABLE_ORC
void
image_variance_optimized (int * ORC_RESTRICT a1, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, int p2, int n, int m){
  int i;
  int j;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_union32 var12 =  { 0 };
  orc_int8 var32;
  orc_int8 var33;

  for (j = 0; j < m; j++) {
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);

      /* 1: loadpb */
        var33 = p2;

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 2: accsadubl */
      var12.i = var12.i + ORC_ABS((orc_int32)(orc_uint8)var32 - (orc_int32)(orc_uint8)var33);
    }
  }
  *a1 = var12.i;

}

#else
static void
_backup_image_variance_optimized (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_union32 var12 =  { 0 };
  orc_int8 var32;
  orc_int8 var33;

  for (j = 0; j < m; j++) {
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);

      /* 1: loadpb */
        var33 = ex->params[25];

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 2: accsadubl */
      var12.i = var12.i + ORC_ABS((orc_int32)(orc_uint8)var32 - (orc_int32)(orc_uint8)var33);
    }
  }
  ex->accumulators[0] = var12.i;

}

void
image_variance_optimized (int * ORC_RESTRICT a1, const orc_uint8 * ORC_RESTRICT s1, int s1_stride, int p2, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "image_variance_optimized");
      orc_program_set_backup_function (p, _backup_image_variance_optimized);
      orc_program_add_source (p, 1, "s1");
      orc_program_add_accumulator (p, 4, "a1");
      orc_program_add_parameter (p, 1, "p2");

      orc_program_append_2 (p, "accsadubl", 0, ORC_VAR_A1, ORC_VAR_S1, ORC_VAR_P2, ORC_VAR_D1);

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->params[ORC_VAR_P2] = p2;

  func = c->exec;
  func (ex);
  *a1 = orc_executor_get_accumulator (ex, ORC_VAR_A1);
}
#endif


