/* ----- encode/1277xint16, derived from supercop/crypto_encode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *encode_1277xint16_checksums[] = {
  "d5348da2ff27262d66e755b86943578667e0356e52efc69e5f8ff7135cd8c5b2",
  "7076c2a55d93f7846a8a8a1fcadea82529d82a42e8bf6ef033d8b4974c8d8e7d",
} ;

static void (*crypto_encode)(unsigned char *,const void *);
#define crypto_encode_STRBYTES ntruprime_encode_1277xint16_STRBYTES
#define crypto_encode_ITEMS ntruprime_encode_1277xint16_ITEMS
#define crypto_encode_ITEMBYTES ntruprime_encode_1277xint16_ITEMBYTES

static void *storage_encode_1277xint16_s;
static unsigned char *test_encode_1277xint16_s;
static void *storage_encode_1277xint16_x;
static unsigned char *test_encode_1277xint16_x;
static void *storage_encode_1277xint16_s2;
static unsigned char *test_encode_1277xint16_s2;
static void *storage_encode_1277xint16_x2;
static unsigned char *test_encode_1277xint16_x2;

#define precomputed_encode_1277xint16_NUM 4

static const unsigned char precomputed_encode_1277xint16_s[precomputed_encode_1277xint16_NUM][crypto_encode_STRBYTES] = {
  {89,174,186,48,42,140,113,67,126,181,102,237,46,51,55,82,242,22,22,63,26,21,188,88,21,147,89,245,90,114,155,251,124,74,95,25,46,220,98,210,42,242,148,162,129,236,16,185,176,153,19,173,160,17,71,205,208,25,9,196,254,194,238,129,140,215,103,104,110,216,163,204,56,85,45,168,94,214,24,241,104,63,234,107,134,27,209,101,70,34,155,94,46,10,140,3,197,137,164,231,29,29,206,166,171,133,225,17,112,186,23,113,64,85,31,191,231,169,99,206,204,76,60,40,155,171,35,20,94,176,163,78,35,179,169,253,106,80,213,141,94,159,225,189,128,224,192,64,184,8,206,255,254,82,172,98,27,29,177,98,209,82,93,195,255,240,37,235,49,25,130,181,14,79,17,103,15,131,20,55,192,135,67,239,141,168,150,61,24,246,69,90,116,14,3,18,23,42,212,229,115,240,116,13,28,73,95,206,46,142,63,165,110,129,84,26,43,27,210,181,34,147,244,244,24,91,205,246,34,139,190,151,239,116,41,29,154,10,184,224,34,55,206,148,7,7,12,155,229,31,109,0,110,226,75,196,192,243,147,90,211,187,174,104,40,166,94,70,102,24,164,98,143,113,229,79,242,167,207,51,183,21,169,134,222,76,14,123,104,251,126,116,168,240,17,171,230,94,92,166,207,133,114,193,252,121,171,181,144,39,164,31,195,126,219,77,75,109,37,151,1,105,165,71,36,233,47,37,73,119,173,129,208,92,91,37,203,204,145,117,38,246,157,244,26,32,160,243,190,234,231,254,133,40,229,45,35,185,219,41,236,138,104,93,184,49,54,194,253,113,76,139,128,144,206,190,200,191,106,24,18,47,95,206,150,112,40,205,166,164,150,181,3,192,144,73,82,45,103,236,180,135,50,47,184,74,232,183,234,35,216,198,151,81,73,78,137,184,44,213,2,82,97,183,123,0,197,160,160,107,189,183,207,130,63,5,97,180,106,43,130,124,19,38,206,75,55,110,230,159,255,168,183,198,155,162,255,214,173,58,95,114,214,16,204,143,204,224,40,140,186,85,250,121,153,226,66,203,154,78,201,202,168,4,83,97,100,239,97,248,84,154,85,248,238,47,186,38,213,127,135,208,37,154,42,132,145,2,110,137,225,115,27,148,220,244,228,170,21,124,19,216,74,111,1,102,177,141,117,114,15,176,211,100,55,7,109,175,183,169,204,214,161,230,150,119,71,167,186,115,81,101,107,37,207,34,240,66,171,3,225,156,250,11,80,25,227,90,190,38,95,118,2,7,67,139,96,104,182,202,51,14,125,198,136,135,215,180,116,36,13,246,32,225,158,132,92,195,198,183,216,15,80,189,120,218,223,94,230,234,120,163,80,253,153,52,227,39,50,138,36,185,39,115,212,201,34,124,203,180,9,109,3,203,66,132,78,221,85,177,10,5,113,22,25,32,64,105,8,59,164,10,44,176,108,114,253,145,124,111,125,253,120,53,69,20,8,86,62,246,84,207,201,53,194,126,177,36,39,88,113,144,37,80,12,89,53,174,207,18,65,74,249,6,44,226,226,167,51,19,37,234,162,30,1,162,181,211,20,22,59,188,83,75,30,63,15,168,173,143,158,213,254,227,226,34,41,62,102,127,164,198,28,24,249,70,223,125,83,236,119,169,173,55,2,172,137,13,93,205,247,8,104,44,64,27,132,198,248,107,113,108,69,186,28,129,151,126,100,209,25,52,98,49,65,72,101,129,104,112,101,142,116,133,164,33,255,187,67,143,24,110,199,176,46,112,38,91,218,208,99,200,67,222,195,213,167,194,123,139,253,113,239,242,73,96,212,155,94,198,111,201,97,172,35,170,117,92,233,167,186,119,122,103,34,151,164,47,176,101,152,125,104,232,106,166,44,181,207,150,154,139,116,241,145,164,56,215,58,48,58,1,195,140,250,145,243,40,35,21,242,119,188,172,172,85,210,132,137,37,238,14,22,135,186,132,129,204,134,35,198,75,14,190,88,165,254,52,231,67,167,16,218,154,141,19,34,129,150,131,251,192,197,48,66,219,80,9,181,205,193,127,173,207,190,180,119,49,29,161,71,22,15,114,143,42,61,238,89,172,29,16,60,69,109,106,125,50,25,128,207,91,245,178,62,92,58,153,129,207,167,253,91,73,144,172,61,244,227,6,170,66,228,222,78,126,12,15,127,233,182,59,51,192,176,144,134,218,233,165,253,194,21,196,123,121,140,101,72,44,162,106,53,31,235,171,108,15,249,66,180,0,173,124,137,234,184,70,250,197,214,43,122,75,191,126,170,173,223,23,189,242,185,150,142,153,1,227,188,22,6,119,111,49,240,246,45,180,240,239,153,89,180,70,213,217,113,95,65,10,146,54,87,124,191,109,9,199,84,252,2,185,224,238,14,139,206,99,135,47,55,73,204,158,172,178,170,46,71,224,172,172,198,34,76,90,195,43,178,64,225,107,140,135,35,254,123,107,36,62,158,219,195,174,126,148,11,38,201,236,92,254,17,203,108,157,69,127,32,163,186,227,223,196,162,103,194,253,151,244,246,215,243,177,19,93,36,11,183,200,79,100,248,49,53,70,142,186,43,120,129,130,116,36,21,113,151,53,193,61,255,90,217,1,184,10,98,242,168,128,39,180,246,154,23,201,219,2,14,14,217,165,150,11,27,65,64,90,27,194,226,240,35,76,247,178,162,59,102,206,230,227,94,146,227,200,145,191,48,197,27,90,209,218,221,154,209,159,239,184,86,115,233,97,127,249,35,0,211,31,235,80,119,181,88,83,218,111,189,159,15,36,255,39,164,169,194,131,225,6,118,164,109,188,114,58,100,242,245,70,48,69,98,214,216,79,25,84,83,50,52,89,72,247,186,205,31,133,157,172,40,181,100,84,38,134,95,221,189,101,229,90,172,32,21,78,11,187,189,141,169,211,221,58,221,68,242,87,167,147,88,10,28,104,152,124,116,58,81,47,47,38,65,45,68,228,215,188,76,110,169,136,79,165,166,245,64,30,130,10,246,112,189,88,58,180,156,127,252,237,172,232,87,9,161,208,55,24,10,130,162,5,106,230,169,132,48,140,163,242,164,254,205,167,59,192,37,90,254,231,96,189,58,248,111,82,105,196,123,13,171,143,155,115,48,9,233,22,2,139,41,223,210,137,150,144,200,149,94,118,228,129,100,209,67,118,33,19,62,243,101,242,239,91,137,104,215,224,44,249,206,136,64,125,177,22,16,101,91,241,20,246,190,176,39,4,54,138,79,9,160,237,99,3,121,60,255,231,62,185,28,162,46,78,198,177,235,152,153,229,151,22,93,88,19,70,32,224,160,108,190,220,66,207,230,126,212,195,94,29,22,80,172,205,219,80,57,72,101,103,219,45,117,142,230,234,5,246,116,136,96,178,185,44,242,132,4,198,24,114,172,250,130,91,148,112,197,85,242,50,177,133,18,67,44,5,14,62,212,15,203,237,42,7,174,176,69,101,105,130,118,218,96,228,152,192,133,193,244,43,66,120,211,4,89,214,254,223,103,108,212,111,131,101,234,196,73,61,147,174,161,9,174,173,19,190,180,29,75,196,53,119,59,233,17,167,95,212,252,181,145,105,156,126,81,172,97,162,168,207,156,177,172,194,204,119,80,1,243,84,126,245,74,14,187,6,158,202,72,31,132,201,197,2,159,137,46,251,219,29,248,181,43,109,199,195,228,115,228,197,119,32,36,210,126,24,95,21,236,219,121,206,187,91,65,159,247,238,49,162,67,236,160,8,218,114,205,155,44,79,170,170,29,100,175,174,200,130,133,217,0,205,250,223,136,158,214,69,18,63,93,223,13,85,162,160,175,103,229,68,145,137,110,243,73,24,240,28,251,26,105,80,85,242,77,4,250,29,186,100,195,206,148,95,219,128,65,44,246,67,8,176,85,180,136,174,172,239,216,187,115,107,186,236,241,79,210,126,77,118,211,146,170,241,148,56,156,205,217,235,55,66,236,197,96,214,226,43,141,76,183,216,90,236,112,27,106,89,87,202,24,213,44,130,23,16,170,15,210,250,143,97,45,79,47,104,232,102,80,152,115,94,166,58,115,154,31,245,236,18,230,60,47,29,114,221,94,17,221,211,48,248,5,101,203,248,245,99,180,4,74,185,144,117,239,188,90,143,85,176,144,34,198,158,172,143,148,80,64,250,226,30,165,69,244,42,178,52,34,207,29,39,17,216,221,237,104,252,151,60,94,210,150,137,226,180,17,69,84,91,87,245,22,25,238,64,170,61,171,121,87,223,56,131,229,69,241,138,172,210,54,201,114,245,13,210,174,96,185,124,26,185,243,132,30,225,31,41,184,255,78,158,144,182,135,124,199,182,71,155,177,101,63,53,71,197,162,215,106,238,143,120,220,220,241,59,130,50,245,133,77,210,118,52,2,185,101,76,6,249,187,153,150,180,164,147,187,246,242,69,182,94,5,113,18,19,246,219,96,194,126,164,33,76,173,51,133,150,29,141,201,181,201,226,169,130,70,150,76,159,211,238,154,89,133,100,82,208,85,173,2,227,64,16,255,135,19,174,35,59,230,74,229,45,5,234,99,184,49,208,96,14,203,153,235,111,91,144,44,236,166,52,113,110,152,86,250,153,48,1,159,215,54,62,208,100,67,121,96,82,32,7,112,69,245,183,241,127,65,215,34,149,235,128,202,104,151,20,49,134,60,240,85,35,236,195,17,98,3,27,37,196,96,38,224,25,178,253,70,37,236,173,242,167,92,29,243,0,248,149,83,121,20,169,75,33,155,73,239,202,28,96,245,24,161,218,40,192,30,251,33,56,72,223,130,111,185,108,25,185,250,206,47,142,193,246,124,99,245,134,139,174,6,226,151,96,52,237,230,218,129,190,38,44,77,147,76,125,58,14,62,161,178,44,59,212,183,237,29,43,28,88,99,53,193,132,240,228,150,9,81,231,210,57,161,146,6,121,107,197,17,148,41,175,122,165,47,136,179,203,190,103,198,154,109,202,4,236,99,104,59,52,87,205,129,50,51,60,130,16,26,156,120,146,154,75,44,234,124,178,136,251,43,11,196,184,249,84,201,48,60,68,63,117,41,13,40,233,72,64,70,12,162,209,113,91,208,104,107,159,145,13,92,73,124,130,58,164,12,237,15,83,248,46,174,223,89,125,214,162,28,155,17,241,111,50,212,117,228,34,231,109,251,149,103,76,161,125,154,178,164,92,51,88,138,62,169,135,52,110,53,57,14,144,46,49,35,233,249,185,56,118,7,25,145,203,157,10,201,86,251,39,33,117,233,70,252,61,12,147,18,124,232,70,32,186,166,251,108,117,140,154,116,232,95,81,87,96,199,66,231,242,42,229,56,203,40,177,156,51,159,234,38,50,194,189,58,189,106,246,83,28,64,224,103,21,165,83,52,28,144,206,52,249,228,59,40,254,199,34,6,67,217,17,96,150,6,183,77,188,166,26,3,162,53,242,150,155,180,109,172,54,142,232,78,76,179,70,6,114,175,246,108,87,33,172,137,126,111,68,149,203,152,112,121,11,245,145,14,102,173,176,211,22,81,179,233,21,63,152,212,192,162,203,194,138,29,254,14,196,235,28,140,45,252,151,126,11,199,170,44,118,135,25,25,17,50,195,204,187,190,112,125,97,37,28,44,123,81,2,163,22,164,230,103,124,38,138,186,155,85,234,226,54,29,253,128,240,41,67,8,193,92,235},
  {243,230,112,245,251,23,72,160,151,11,106,24,104,0,43,238,136,194,104,48,145,48,253,236,177,250,17,188,252,56,16,180,19,138,72,104,77,221,147,13,93,171,157,163,2,7,253,175,59,203,215,165,50,15,52,30,138,25,186,23,12,27,112,23,27,83,29,140,91,84,143,36,97,113,136,189,126,44,245,52,21,69,52,57,215,110,239,201,4,229,63,254,74,239,27,55,218,82,0,27,249,58,12,52,152,218,198,165,124,184,108,214,12,68,180,157,29,229,226,43,191,151,204,172,252,24,202,74,16,33,136,217,62,55,33,27,248,251,250,157,54,182,198,61,233,99,70,69,143,157,139,27,125,186,194,171,2,57,161,197,46,120,17,64,221,114,91,183,114,93,116,175,72,137,151,110,62,133,54,212,172,248,144,220,73,153,157,45,254,217,164,136,153,87,111,107,245,162,143,129,168,122,173,22,107,64,134,74,62,127,120,197,238,23,226,228,220,122,220,207,214,45,33,226,76,220,115,103,9,67,120,202,167,93,39,241,187,156,15,84,148,34,86,78,52,90,134,30,51,172,0,19,131,60,76,131,51,105,103,181,109,176,152,65,20,81,221,49,169,95,54,54,80,27,62,141,214,161,89,174,186,131,150,40,98,155,246,82,181,42,29,194,155,210,58,37,108,66,146,213,29,29,110,17,50,124,43,241,76,243,44,160,6,12,240,72,82,252,26,103,13,199,202,68,196,250,101,240,163,42,96,209,41,13,19,182,200,41,91,102,58,35,118,203,11,200,140,209,196,114,75,140,163,147,63,27,21,29,201,31,113,230,131,116,181,150,94,51,42,183,251,175,194,119,12,63,104,36,238,141,96,186,186,72,3,145,199,174,142,76,144,171,99,104,89,70,254,109,224,236,128,14,120,191,141,141,61,157,108,30,242,50,101,229,4,167,111,215,192,28,224,189,119,3,118,24,24,103,209,199,203,182,99,72,191,159,163,105,57,206,40,204,14,59,16,23,30,96,254,7,183,186,96,13,31,147,169,120,197,79,166,30,45,50,90,63,62,83,80,217,121,115,181,35,102,152,204,25,208,102,44,66,125,28,99,157,79,18,180,161,84,160,237,229,177,46,87,84,196,91,28,215,136,225,193,192,144,4,38,111,207,4,8,64,172,247,30,246,134,255,54,42,121,232,145,11,253,152,238,99,194,228,114,15,235,63,201,62,183,251,236,20,35,62,228,57,153,253,7,0,66,27,157,178,54,8,161,138,50,62,175,167,55,200,55,134,49,66,116,235,9,100,93,127,39,34,193,23,99,76,75,22,237,93,223,48,122,47,206,232,188,235,97,22,68,118,92,236,23,247,183,222,191,145,51,212,4,10,13,225,2,79,0,174,77,53,97,174,149,19,104,120,247,72,115,127,82,123,196,76,181,239,219,77,17,77,203,145,171,157,147,106,198,90,110,189,169,246,124,233,56,120,24,167,128,79,134,202,45,220,225,29,39,85,165,15,42,107,22,82,67,230,66,204,156,16,218,239,246,242,248,224,226,179,134,154,223,202,94,227,99,73,244,44,87,212,179,233,247,170,216,36,133,198,165,138,51,13,242,175,192,241,165,48,92,94,117,0,14,225,211,205,241,105,206,146,128,148,223,194,112,89,111,244,251,66,196,225,233,46,162,212,203,185,148,173,211,158,65,234,212,82,53,67,116,156,211,127,17,156,17,156,140,97,8,104,46,226,126,228,24,72,156,17,5,169,127,190,111,181,248,238,81,122,61,217,109,136,224,65,160,210,254,33,118,192,225,110,197,21,18,163,61,215,15,224,169,78,150,243,160,92,48,88,57,168,147,73,129,132,20,187,150,65,71,25,163,21,169,154,93,213,6,59,98,56,60,8,6,184,159,74,215,122,254,138,70,112,4,26,109,5,23,8,136,248,130,196,16,62,5,33,173,74,225,204,167,246,173,67,191,107,159,92,147,187,187,200,86,173,247,35,122,185,129,107,179,42,81,61,112,145,155,141,235,254,14,116,124,200,56,247,78,67,37,54,47,252,34,202,13,153,185,241,69,150,169,72,52,148,142,87,28,113,199,113,8,246,66,199,65,2,93,90,54,182,102,59,65,154,245,93,182,215,58,177,182,226,111,165,144,242,57,115,241,131,73,237,27,131,159,61,124,181,70,18,230,79,139,139,169,49,13,0,96,215,193,137,33,175,227,77,153,213,147,245,81,163,17,156,122,124,26,72,161,10,53,208,82,38,11,233,203,221,63,222,240,50,221,223,225,52,9,9,102,64,102,178,126,65,205,126,48,123,63,63,226,98,34,14,27,8,252,13,19,63,85,170,144,202,88,129,187,25,59,79,132,72,169,115,54,173,131,175,18,239,156,233,113,122,217,8,35,248,5,132,227,85,26,101,152,121,122,171,41,84,57,163,210,28,3,12,192,77,122,23,249,50,92,218,77,208,167,138,121,218,153,255,148,40,67,195,30,57,62,172,6,202,42,157,37,65,133,248,25,238,119,143,209,105,222,17,114,162,106,95,230,208,201,52,201,147,27,20,153,244,37,124,224,112,71,94,142,238,92,180,125,149,212,156,177,249,195,172,22,85,20,3,244,130,177,232,252,83,6,107,116,15,87,80,253,143,218,213,2,230,131,98,242,6,197,91,170,178,200,217,119,3,70,66,213,148,58,157,214,87,167,121,186,22,136,165,138,142,108,100,144,178,124,3,149,244,99,91,185,123,145,24,149,89,164,70,95,126,254,86,167,73,73,81,174,22,19,65,52,199,146,195,206,4,215,192,117,233,111,110,2,108,131,247,54,126,146,202,157,19,77,186,48,138,2,103,145,81,220,216,84,158,204,47,49,25,82,128,205,134,43,199,128,10,176,184,212,210,220,96,162,230,232,192,166,112,230,118,207,60,174,160,87,195,51,61,55,18,115,71,169,6,5,46,227,239,23,195,51,2,162,25,117,251,168,254,157,92,221,234,125,168,255,128,54,139,218,61,33,245,104,192,136,139,178,30,197,219,17,93,41,93,144,79,56,74,12,107,49,66,53,22,170,168,177,203,36,120,18,32,136,123,232,255,116,74,251,210,120,12,74,165,164,252,239,63,80,18,106,118,161,238,112,156,68,34,211,142,177,16,151,251,83,94,108,75,169,213,50,58,89,198,249,26,143,149,74,32,115,235,36,206,248,22,172,131,218,59,254,236,34,179,21,68,130,184,55,40,136,167,148,40,135,219,231,18,220,215,242,139,235,191,1,65,7,199,109,45,219,40,220,56,203,30,41,32,148,65,12,191,103,7,116,70,240,103,39,80,130,199,88,49,232,98,13,233,42,190,151,103,18,5,116,201,96,27,165,103,110,26,66,228,132,53,239,102,120,19,188,167,213,233,49,121,20,253,188,83,177,157,93,11,1,117,251,236,39,92,243,191,203,239,44,153,12,144,191,147,175,76,46,130,173,47,206,195,208,15,75,60,114,51,62,205,130,84,37,52,54,127,247,164,212,123,33,59,206,23,227,201,201,64,251,74,80,190,139,55,105,53,188,7,33,202,75,148,137,154,122,6,235,203,222,194,171,241,243,1,204,102,252,116,3,219,86,210,254,94,158,235,244,188,102,211,117,90,131,19,21,31,208,154,130,177,137,150,248,185,216,125,243,251,28,22,183,137,188,242,10,150,33,92,224,156,221,55,231,253,236,142,58,119,100,34,95,85,23,234,91,55,30,69,115,189,130,21,44,249,57,174,83,3,155,65,164,171,238,27,139,3,243,112,230,46,206,122,5,138,16,145,94,234,131,18,48,6,210,62,79,240,243,21,71,187,100,18,201,246,223,174,132,63,181,141,246,174,5,110,60,60,143,203,87,59,37,146,163,98,92,253,172,125,11,3,96,123,121,26,4,138,110,146,180,214,98,129,186,251,2,212,98,195,149,212,171,197,143,241,229,197,99,213,199,63,81,252,86,46,111,177,79,67,70,175,13,237,166,179,240,173,40,146,41,207,188,237,242,12,185,175,160,107,254,217,53,203,111,169,1,232,210,82,139,166,48,67,216,105,63,233,229,227,193,221,85,122,25,236,16,234,66,114,186,157,27,15,243,148,248,156,137,204,149,58,206,111,94,195,68,54,3,133,178,174,39,121,114,109,29,169,14,98,160,223,94,73,42,248,39,30,64,248,149,77,92,223,229,19,142,9,124,33,90,197,80,39,155,8,33,68,5,56,112,8,211,147,247,226,136,0,167,208,7,79,2,66,160,158,100,56,155,168,236,115,48,50,71,83,137,245,220,49,185,51,170,245,238,2,25,170,209,189,195,84,211,138,248,22,113,251,31,106,36,184,235,59,106,68,247,230,247,217,131,17,253,51,239,71,214,113,48,159,43,3,101,146,180,156,138,42,91,98,83,2,206,179,151,233,75,210,232,19,30,120,27,214,176,245,95,27,203,119,136,167,144,238,135,122,76,163,251,36,190,122,66,205,137,57,110,109,222,249,76,122,185,226,125,71,73,125,48,127,69,131,225,188,216,193,62,116,36,162,92,176,242,249,10,195,88,204,218,75,45,43,17,19,6,106,211,63,240,9,13,207,84,12,244,139,201,214,172,38,34,217,251,73,105,22,117,49,128,34,78,8,224,162,252,207,251,95,121,182,151,2,9,177,245,247,213,241,132,222,100,188,213,172,36,176,246,52,237,153,107,231,134,14,142,29,143,233,248,13,190,214,162,163,232,73,214,37,104,205,101,242,232,83,178,51,97,111,99,95,147,229,138,154,65,24,121,97,38,247,9,90,162,233,50,255,13,14,2,143,38,48,243,97,222,75,251,182,77,8,65,29,5,45,180,15,150,249,142,209,163,84,218,142,187,80,189,254,209,207,232,1,240,126,56,214,131,196,139,163,222,65,26,87,87,215,7,37,14,180,3,168,80,118,61,229,173,23,61,25,109,174,170,154,235,195,99,174,201,143,118,37,248,199,130,75,116,71,234,204,17,95,153,247,3,209,25,30,206,91,145,146,46,173,122,101,236,25,67,27,181,108,124,79,136,100,169,13,28,36,106,136,27,10,230,19,173,236,247,17,130,51,103,15,207,142,29,44,118,44,220,164,76,24,84,68,252,221,0,148,142,73,131,118,176,236,79,185,205,133,15,95,232,28,142,232,126,226,139,202,9,84,132,163,228,179,111,40,125,179,213,1,10,110,214,242,134,238,251,49,238,62,108,195,225,56,16,81,182,120,145,144,247,117,187,77,234,8,145,130,25,249,120,41,51,118,166,170,20,166,253,169,149,169,52,110,238,40,106,25,105,83,61,217,247,47,26,162,20,184,169,26,108,51,140,14,160,85,216,192,227,67,106,166,52,183,129,82,245,126,38,153,228,243,169,72,106,183,16,164,143,188,173,249,11,75,41,22,3,165,199,139,126,66,114,105,149,106,150,238,165,121,22,129,190,236,5,207,174,121,232,117,213,75,4,8,221,138,160,191,123,10,79,241,47,172,95,157,13,244,195,94,100,140,153,178,18,59,190,77,94,112,100,12,67,6,133,138,16,64,207,67,51,199,140,255,132,166,45,218,62,92,241,212,152,23,240,136,72,116,179,198,119,82,249,184,192,220,153,119,44,168,82,29,0,188,203,176,84,22,247,185,95,16,116,86,56,124,238,172,110,248,231,246,118,45,105,124,62,85,163,245,67,240,21,238,38,182,44,102,223,16,111,185,4,55,130,70,87,198,71,252,66,30,252,239},
  {223,127,95,111,147,79,212,179,197,41,31,175,1,0,92,68,40,119,42,65,133,61,146,46,94,65,112,56,206,20,214,112,70,49,115,131,115,100,145,242,52,249,72,114,155,150,187,28,166,119,179,65,167,59,60,117,225,85,230,235,244,191,6,14,127,73,147,223,207,116,105,66,2,129,150,184,6,74,103,38,250,27,19,254,14,11,91,84,111,234,200,177,8,37,172,105,45,202,132,98,226,182,210,250,107,237,246,120,136,123,6,253,108,187,45,193,0,45,234,115,70,196,49,183,244,51,69,86,127,211,148,241,227,76,243,230,147,143,90,81,91,68,239,137,84,135,132,10,25,238,81,183,102,214,134,131,96,179,181,107,10,133,147,135,214,80,41,201,114,251,185,23,3,86,65,72,52,124,146,231,40,52,189,14,122,180,104,178,173,37,13,69,18,112,99,40,74,142,91,30,235,39,189,13,4,83,77,116,24,56,186,1,54,63,164,141,126,9,94,121,8,15,78,21,85,132,163,16,5,217,16,159,180,61,148,188,69,178,174,226,254,36,170,107,244,21,168,24,0,78,69,198,147,56,144,36,180,188,182,139,159,19,137,1,233,129,80,134,89,88,200,138,69,104,228,207,16,248,84,21,129,86,42,65,136,114,153,167,161,170,174,63,147,157,207,238,145,201,88,186,34,172,183,93,168,144,81,102,67,10,219,89,83,219,252,140,198,24,65,5,119,101,138,58,93,17,103,231,145,52,182,86,66,129,122,242,144,70,196,210,157,222,166,139,220,159,54,50,123,158,232,13,101,243,212,60,182,200,253,226,69,202,174,8,192,235,68,100,140,225,227,215,174,217,27,43,28,32,16,38,229,39,199,106,19,22,41,246,254,105,194,19,170,97,106,28,42,159,106,151,183,229,186,144,199,16,140,43,33,243,96,231,12,168,228,94,106,170,153,113,252,85,94,24,22,127,151,24,33,103,26,85,231,142,149,252,186,168,100,255,154,91,148,104,81,64,100,49,245,56,135,77,188,11,169,158,181,235,241,42,171,141,102,172,45,11,145,104,135,111,251,44,87,26,245,22,225,61,184,155,103,106,9,6,106,96,236,85,219,96,193,139,206,70,178,99,6,61,178,77,232,122,199,63,10,217,26,141,145,201,231,82,174,88,17,15,122,243,14,96,217,74,9,60,41,170,120,184,66,67,253,229,73,82,1,9,61,85,165,137,225,185,170,199,119,73,116,166,246,190,207,23,188,172,69,203,120,212,134,127,114,16,145,199,33,244,131,186,153,73,58,108,127,19,34,51,190,96,61,132,200,94,148,204,38,27,14,103,154,39,28,109,158,205,236,86,94,119,2,50,88,100,106,114,205,84,166,188,13,125,235,29,238,1,97,222,202,245,211,64,115,50,94,22,237,53,61,212,167,78,118,54,170,68,158,240,175,204,222,211,232,200,191,102,40,222,38,41,96,168,103,145,224,79,225,88,56,110,72,50,181,58,121,250,183,80,125,252,200,5,233,221,178,48,34,44,232,50,251,205,74,50,2,189,5,46,149,67,227,125,255,135,71,120,72,198,124,108,241,39,203,57,139,240,217,170,33,159,169,236,81,136,227,219,252,108,211,123,87,119,192,91,4,7,207,1,178,201,211,106,230,187,212,78,63,220,59,218,217,169,214,81,195,181,112,56,234,14,85,135,72,13,228,228,155,217,30,148,28,251,195,236,54,127,116,201,207,11,235,23,97,84,109,41,49,4,125,26,253,59,202,125,168,146,117,252,44,62,17,101,21,78,51,177,28,208,163,92,30,127,35,10,188,38,219,145,38,139,144,42,51,231,204,228,252,101,61,200,26,179,236,74,20,18,234,189,181,203,87,31,120,197,33,121,173,148,29,136,30,115,221,78,250,209,182,52,173,116,185,157,37,115,9,125,202,153,112,174,35,249,168,143,16,158,209,149,131,182,193,116,87,140,230,187,23,253,198,65,83,29,40,141,109,92,85,223,73,247,131,219,229,97,231,110,189,85,95,178,22,99,72,226,193,30,251,13,114,242,29,180,139,117,89,178,130,136,95,206,183,31,51,61,11,12,146,219,255,71,142,87,141,156,115,214,235,204,27,30,189,100,59,102,248,66,83,164,66,115,35,69,224,153,142,142,82,233,48,23,143,202,3,209,58,172,121,146,40,72,149,127,11,51,133,32,255,102,39,195,119,55,175,185,140,184,5,12,244,101,115,221,5,111,241,103,66,165,146,69,33,145,156,113,101,46,128,66,206,157,191,29,126,236,202,154,99,64,147,124,210,152,149,35,86,171,99,168,157,186,209,221,209,240,97,47,167,124,159,73,93,245,86,220,171,27,71,161,30,168,84,82,253,122,131,225,76,186,59,59,218,43,36,237,19,144,115,231,9,232,38,71,68,59,150,92,186,56,37,149,34,167,245,11,129,206,138,164,76,202,170,1,90,18,101,75,21,179,14,93,19,158,195,97,72,113,230,81,72,124,162,29,145,17,219,177,144,54,218,81,76,175,123,105,127,155,109,253,108,197,133,52,158,21,1,56,142,59,53,2,50,88,225,204,185,180,94,242,241,130,40,225,24,148,41,158,97,118,188,69,54,193,82,137,200,219,209,151,173,77,72,207,218,106,226,77,152,7,193,24,112,109,173,29,166,120,36,113,35,252,184,206,53,84,197,82,217,211,142,227,72,87,150,26,110,219,149,179,97,128,228,19,88,227,77,102,155,172,81,177,237,111,107,106,161,220,101,203,208,155,85,239,116,174,26,150,147,246,145,194,99,192,87,99,191,104,83,153,103,176,33,161,56,235,145,164,124,26,99,172,238,190,165,234,208,84,250,25,229,176,20,231,54,102,14,190,121,210,47,83,143,186,59,213,48,118,234,252,223,231,195,184,176,93,215,140,184,253,29,122,173,40,208,202,211,190,217,125,82,254,198,5,162,66,146,229,211,62,243,238,222,119,0,94,178,182,56,67,10,3,175,38,233,177,74,191,237,170,181,106,23,121,187,31,184,48,215,6,10,56,168,70,211,232,236,77,21,82,115,126,227,240,171,192,42,80,161,231,255,44,214,51,58,241,102,64,239,218,8,98,233,179,166,7,149,151,96,69,16,96,90,85,219,115,89,235,115,154,191,123,1,158,28,169,142,224,54,233,7,28,5,241,238,196,31,33,50,138,75,111,238,192,1,175,146,113,47,217,63,153,78,57,133,104,227,75,14,193,166,248,197,204,87,191,236,133,19,188,239,127,106,220,151,116,175,79,112,53,153,181,79,197,74,211,205,239,39,138,33,56,148,39,243,204,217,242,192,51,107,16,101,249,58,235,29,221,160,67,76,145,202,47,102,5,147,250,98,76,197,131,235,70,159,26,88,152,114,228,182,246,1,198,218,22,233,178,148,133,137,64,59,189,111,69,219,5,62,185,29,238,169,191,87,192,62,29,237,119,124,21,7,56,221,129,168,201,144,213,97,11,135,6,41,61,197,47,82,231,134,190,116,245,63,203,87,73,203,61,107,239,25,228,223,170,127,43,129,72,77,214,39,190,228,232,219,58,91,192,48,126,122,227,117,223,17,182,46,93,126,122,84,191,241,124,76,90,10,164,155,1,174,200,245,50,50,53,145,41,92,201,236,21,3,192,33,8,146,142,51,225,97,198,132,182,122,194,254,88,73,35,41,133,142,164,243,44,68,68,175,211,224,206,196,19,240,66,157,30,218,27,189,25,93,19,62,219,135,198,234,9,125,217,144,25,113,212,153,4,65,176,109,124,115,30,170,242,215,181,118,248,52,182,177,207,228,12,74,235,145,157,110,85,81,17,225,232,239,76,162,135,8,97,173,20,77,29,236,113,127,54,191,125,72,202,192,194,24,7,46,113,194,90,66,180,28,194,58,82,75,129,165,67,208,62,93,93,92,86,83,111,112,113,206,243,123,46,44,219,29,194,136,189,43,26,177,75,47,84,154,254,27,174,208,203,145,118,28,225,151,76,15,253,84,134,201,85,205,176,208,108,99,47,218,117,228,132,66,19,102,195,203,226,65,35,115,129,25,113,49,204,216,242,48,190,18,111,214,63,215,176,9,44,110,112,186,140,201,28,198,212,16,43,185,68,8,172,171,66,30,110,9,199,4,100,58,236,151,136,22,217,11,236,91,17,135,98,152,130,100,70,219,65,103,205,190,23,2,147,93,193,213,172,248,204,133,156,8,134,237,169,220,110,223,47,152,72,143,220,205,217,140,62,188,167,20,1,57,145,238,7,3,183,125,206,99,129,14,45,127,67,254,34,30,159,238,111,21,31,18,140,86,201,153,168,201,212,123,197,214,146,52,176,46,200,116,180,161,98,27,142,67,140,213,109,244,44,197,30,38,173,43,19,188,132,52,212,51,20,101,113,206,84,156,67,6,22,166,105,157,63,39,40,56,7,68,106,64,249,117,174,99,119,216,24,170,7,207,74,88,132,8,131,26,238,5,249,101,144,165,0,161,153,185,138,128,149,58,75,84,197,89,157,201,27,59,65,13,233,98,75,86,144,19,247,38,135,46,161,37,24,249,24,129,73,71,84,96,209,88,91,185,231,141,25,10,200,222,79,86,90,34,16,15,49,123,217,205,182,30,73,118,149,174,59,25,114,210,94,227,3,199,155,29,63,243,126,104,135,12,148,197,228,97,33,247,216,99,249,51,51,245,255,44,43,162,167,32,223,197,242,27,193,118,224,2,214,178,72,116,205,111,169,65,156,134,81,58,208,213,247,76,175,90,86,53,170,204,174,28,55,166,163,192,48,70,215,7,210,53,194,39,51,103,208,53,61,244,22,139,58,215,230,216,36,246,187,138,93,230,60,141,203,111,236,20,45,147,154,215,49,175,48,119,145,104,255,24,103,166,104,212,196,95,4,32,107,140,117,44,91,190,100,12,12,26,20,76,220,218,121,147,10,190,223,241,138,6,38,234,214,12,29,1,229,65,164,11,39,186,28,152,62,44,224,82,66,199,211,112,221,237,102,152,8,142,109,39,33,255,47,133,41,43,76,118,9,15,55,86,246,170,137,150,195,126,125,241,77,11,116,116,219,128,239,1,226,118,63,46,17,138,142,24,24,241,245,120,245,181,72,199,160,92,173,15,227,110,76,228,171,204,49,48,154,243,169,54,122,167,0,60,47,58,127,89,184,3,89,18,126,101,5,116,158,99,14,87,68,19,103,34,127,214,74,252,186,241,163,143,241,118,242,230,161,62,26,48,183,101,90,52,115,218,17,252,220,232,61,6,65,201,36,100,96,249,203,220,247,100,242,110,27,109,105,38,222,43,251,91,139,185,20,83,49,121,255,133,77,202,86,197,199,112,26,72,232,86,13,194,5,226,209,193,26,187,134,10,194,41,17,111,81,41,45,218,101,69,114,216,79,19,111,74,123,253,96,139,61,80,113,29,224,216,47,110,191,165,142,67,41,202,167,109,99,8,101,153,45,243,181,219,132,134,98,245,126,106,103,243,44,175,250,104,87,151,201,5,21,40,69,1,89,84,44,48,144,172,148,137,97,214,182,37,157,234,79,185,139,172,219,115,137,199,148,166,105,151,111,224,74,152,91,62,138,24,113,154,142,67,26,118,37,245,113,208,206,152,87,169,54,181,217,226,121,190,43,96,124,177,167,190,202,88,160,92,188,16,43,63,144,45,16,103,68,107,76,217,135,216,31,126,106,10,66,98,4,204,133,146,249,205,220,96,78,7,87},
  {11,13,245,165,146,102,213,12,79,164,210,208,86,195,181,167,100,61,231,9,111,178,238,205,147,234,248,94,111,190,28,116,135,143,205,99,20,144,213,74,174,55,75,167,154,86,134,0,16,14,135,117,240,235,14,13,84,150,244,170,35,110,240,34,50,105,15,88,205,52,251,56,175,75,218,38,212,32,73,104,71,102,143,144,158,193,41,0,47,7,161,15,231,248,155,181,116,48,196,168,150,61,127,176,68,171,222,244,254,11,158,214,80,63,204,116,5,148,133,246,38,134,226,73,162,26,254,187,187,86,6,70,143,214,219,82,41,3,242,194,139,247,202,111,22,120,150,136,253,34,24,246,158,250,45,220,250,212,86,54,223,203,240,115,138,253,115,8,55,247,246,82,32,34,58,241,126,89,104,78,116,233,199,112,6,57,193,118,140,19,143,88,238,232,174,39,55,221,211,59,80,175,222,166,48,40,247,137,98,200,209,172,200,104,1,213,113,243,196,218,154,146,200,84,59,131,242,191,54,138,12,126,123,154,254,143,239,152,20,165,146,137,28,191,34,69,153,201,110,219,72,199,7,211,119,37,82,253,157,21,183,249,179,158,88,204,75,92,165,133,13,93,97,21,176,151,242,217,185,198,255,8,103,161,229,34,179,8,144,4,45,99,131,230,198,2,240,48,215,60,0,173,50,19,139,104,68,251,58,73,71,212,18,210,225,74,62,96,117,239,140,98,16,219,61,161,241,82,41,105,135,152,51,75,164,66,62,71,127,18,95,108,118,154,109,61,77,61,253,194,182,35,130,66,139,171,210,164,219,237,3,127,116,171,206,46,253,197,61,83,44,132,247,109,182,183,38,149,243,193,133,208,115,136,157,121,201,43,14,149,7,10,109,148,9,219,146,219,239,160,217,209,184,222,217,22,165,185,235,20,216,240,26,109,205,21,15,215,44,123,169,82,204,183,219,121,203,200,163,235,140,68,17,238,88,15,119,115,24,165,182,120,252,80,161,227,189,155,245,17,248,170,136,205,70,154,238,229,76,255,129,47,200,114,61,171,59,86,38,199,54,175,197,12,26,105,71,190,76,143,82,243,218,82,105,116,19,187,25,95,171,140,115,61,1,243,147,36,212,250,147,227,62,64,172,241,59,118,87,17,55,17,61,237,1,122,108,53,218,211,244,23,27,105,36,11,248,229,33,193,60,134,20,104,39,148,212,28,243,170,32,56,220,185,241,160,97,135,63,109,56,248,49,238,28,12,27,86,249,55,135,19,27,40,26,44,3,75,125,31,227,61,118,144,217,41,169,18,74,132,186,172,142,90,10,141,80,38,131,52,165,26,69,59,165,20,220,89,126,204,254,155,172,19,181,57,44,130,53,38,19,147,247,149,181,71,50,141,246,115,221,23,155,1,109,14,205,57,78,149,208,129,5,205,6,250,176,200,170,218,253,76,160,16,70,160,79,57,218,36,102,121,226,116,156,193,191,106,249,55,225,101,131,64,245,18,252,210,7,200,171,17,135,14,198,229,52,136,255,213,201,8,188,38,96,8,12,143,89,80,213,7,30,223,65,51,234,99,83,32,135,15,64,76,21,90,221,2,13,21,176,206,108,2,7,165,93,231,35,12,196,125,125,166,164,38,35,71,246,94,40,118,176,81,170,97,181,220,169,237,41,194,73,230,49,72,197,3,13,222,28,8,150,14,156,170,153,97,64,183,71,120,168,52,255,247,39,229,27,183,27,57,172,239,189,180,234,220,217,58,99,133,119,184,243,246,121,138,204,47,15,207,123,29,151,167,134,188,111,246,82,177,41,127,171,135,249,109,30,255,156,65,241,209,138,88,15,52,62,23,194,6,52,150,18,144,12,17,85,22,125,249,52,37,243,98,209,33,26,145,236,119,23,233,91,116,200,254,0,252,116,100,2,126,220,119,69,90,32,87,227,219,159,180,77,164,32,213,129,175,95,27,51,64,55,232,31,68,16,222,214,40,206,255,7,47,9,207,214,77,2,70,80,215,78,141,50,132,187,232,133,106,18,159,143,1,45,226,178,196,74,151,0,1,176,132,110,201,18,74,143,104,60,126,237,101,141,115,90,16,50,58,82,104,51,193,212,106,213,132,180,96,24,233,144,181,203,246,214,159,172,97,17,28,27,196,116,57,143,38,112,198,228,137,105,162,205,174,196,158,123,26,11,83,61,210,190,2,93,21,38,22,29,185,222,92,100,0,208,141,0,110,43,249,15,15,187,235,208,46,47,17,126,98,144,253,202,163,86,53,191,40,82,245,98,29,119,117,31,233,65,28,196,247,31,168,213,181,202,32,87,188,187,116,246,241,31,91,202,225,54,96,224,250,66,88,209,153,80,126,163,48,145,30,246,249,165,78,2,180,123,149,126,34,135,33,139,154,211,44,232,204,164,145,85,238,200,58,245,178,70,23,24,36,75,136,45,147,29,181,76,164,142,254,52,112,42,92,0,88,244,4,130,228,74,18,65,114,232,223,221,101,66,112,57,46,215,167,137,9,123,141,208,100,201,142,236,168,229,43,149,160,226,101,176,40,29,218,28,246,202,230,36,184,201,234,56,110,111,166,92,109,110,66,56,247,134,241,156,137,178,200,73,169,140,3,210,192,177,130,251,236,208,0,18,82,71,232,242,79,7,108,82,157,62,34,82,131,35,56,208,184,111,216,171,9,119,121,201,124,218,172,125,146,77,147,101,161,135,148,5,90,184,101,61,58,161,71,244,120,1,106,2,219,12,60,121,44,77,243,4,47,85,3,123,17,130,95,16,38,37,135,119,90,93,209,156,109,123,111,215,25,168,252,28,103,242,186,88,49,130,216,210,78,238,88,204,202,254,195,176,66,194,119,216,229,55,202,75,204,245,28,210,5,53,141,235,70,208,38,218,39,27,222,43,86,153,176,149,128,133,240,241,222,135,199,127,238,210,25,176,61,219,227,45,54,221,121,95,230,11,146,158,75,244,229,92,87,58,130,90,192,137,130,183,104,27,228,158,34,105,160,89,228,8,84,62,45,107,64,155,248,179,45,154,168,120,182,156,76,146,3,89,110,223,35,166,167,218,134,172,120,155,185,10,238,189,220,128,91,147,69,100,142,230,1,135,168,111,252,197,24,155,77,61,40,100,123,187,116,104,40,140,77,11,218,125,155,110,75,227,73,7,78,21,127,122,212,178,34,28,130,62,54,42,95,19,34,84,158,110,43,233,112,228,254,243,28,63,234,60,69,49,164,108,100,30,131,176,242,254,49,94,67,177,18,155,142,24,212,9,153,12,167,146,200,118,210,67,219,30,218,169,16,42,49,162,54,151,139,248,20,251,247,15,65,19,3,217,254,20,245,96,0,231,132,96,248,203,10,24,69,119,182,133,127,245,229,252,255,32,100,243,127,51,202,147,211,60,249,17,132,93,237,70,195,242,31,208,96,245,46,29,168,201,236,189,37,128,44,30,88,111,171,4,202,173,180,197,206,147,157,123,177,60,66,146,141,12,254,34,252,236,49,94,133,2,8,78,178,143,227,76,131,227,199,210,5,10,204,181,78,57,194,232,89,240,118,15,234,236,4,86,219,103,146,137,245,149,126,140,97,243,134,5,181,19,103,88,114,128,239,53,15,159,96,176,7,236,25,254,39,8,13,169,118,26,38,52,214,57,137,178,49,47,184,150,23,196,80,219,250,15,215,54,6,105,15,101,115,128,60,191,0,88,122,249,88,230,165,14,128,255,173,58,225,30,211,104,108,157,65,50,29,245,38,121,53,231,191,125,146,238,239,88,91,199,230,230,9,104,80,142,29,224,255,5,72,79,127,28,110,251,232,207,34,37,248,80,235,1,160,98,148,88,164,0,247,19,161,186,112,34,107,3,68,39,21,135,209,69,193,223,161,59,14,182,255,134,51,97,236,165,184,32,107,158,130,245,112,49,168,203,61,1,2,255,77,28,183,183,239,215,236,48,162,234,188,191,155,221,177,25,83,226,181,7,251,149,97,10,233,144,20,43,99,234,137,88,130,153,141,39,162,131,129,137,239,207,150,32,211,34,200,128,83,104,129,5,26,160,18,178,241,117,154,118,198,139,24,178,115,16,64,174,170,235,48,249,182,177,138,180,212,219,70,250,88,216,182,83,33,184,3,216,141,77,50,22,36,42,80,13,217,72,214,214,116,203,39,237,119,229,125,184,23,62,201,206,251,11,96,217,53,194,10,24,166,7,204,2,92,119,218,31,231,179,232,238,84,98,79,218,99,230,71,7,251,14,243,232,246,15,30,231,138,40,126,222,162,196,228,211,194,52,159,35,239,48,149,156,229,207,2,36,89,8,205,63,203,95,239,68,121,159,153,16,126,98,94,137,86,82,69,68,143,170,219,156,185,9,239,126,101,21,181,42,78,45,110,2,214,238,41,76,161,127,46,187,204,80,222,73,197,37,91,177,21,100,254,116,211,254,98,140,119,239,126,100,207,24,58,9,63,26,129,214,252,34,10,58,112,87,51,226,255,22,18,102,194,22,196,95,68,119,69,239,146,206,59,33,50,6,236,187,135,212,162,59,168,172,111,241,218,160,84,207,121,4,121,222,205,197,236,32,107,75,197,161,54,120,249,122,62,172,202,194,239,194,163,140,150,246,123,141,99,46,233,99,235,248,201,114,201,50,11,76,193,207,85,52,12,102,131,99,174,240,228,172,213,47,14,23,250,196,225,135,129,168,99,163,141,63,55,20,85,63,184,107,196,101,144,144,192,14,7,255,90,157,113,238,197,82,145,39,179,186,249,49,107,78,238,45,11,99,47,52,47,110,44,101,73,61,24,138,245,240,233,98,84,129,116,158,173,17,119,35,28,185,85,129,90,173,163,202,161,26,134,209,154,110,95,211,201,99,232,101,57,57,24,113,50,193,166,106,137,61,123,207,231,143,191,228,224,154,247,240,59,35,47,225,60,189,169,42,225,248,170,61,55,111,79,143,47,215,107,183,94,246,39,85,251,169,101,185,27,197,174,19,171,240,74,240,225,25,145,146,45,5,202,147,128,2,152,241,108,127,19,48,220,227,199,15,221,126,153,85,247,233,46,188,150,173,89,127,224,150,224,246,203,14,50,182,185,235,244,101,146,188,236,191,121,109,114,78,82,178,134,161,195,101,127,143,183,109,41,106,37,132,228,229,247,20,56,14,161,249,164,149,37,195,131,106,249,54,58,168,58,80,64,139,25,34,143,48,238,107,240,193,235,222,159,17,25,32,246,45,171,147,220,74,152,130,51,153,19,102,91,42,126,94,30,38,243,111,150,25,168,201,200,75,106,239,85,134,249,193,135,25,107,35,190,149,229,62,232,62,226,246,130,230,225,22,4,208,220,99,48,97,236,14,124,229,97,85,233,239,252,2,96,238,69,208,243,18,236,194,92,253,120,90,234,178,69,253,93,9,105,104,119,48,101,213,183,221,151,208,244,58,200,83,63,58,7,166,200,203,136,104,74,208,160,123,254,110,40,96,175,187,85,82,114,10,177,3,231,153,143,222,91,167,191,248,38,34,232,24,213,221,176,90,223,46,249,73,141,169,70,203,101,186,120,228,9,7,56,82,77,54,87,244,81,71,173,230,160,230,18,74,20,229,80,218,150,242,196,4,76,140,80,27,94,187,45,177,18,141,18,178,22,162,57,214,99,207,95,119,44,255,70,148,125,236,88,222,61,61,108,128,56,153,177,178,199,76,119,47,34,151,6,87,42,170,215},
} ;

static const uint16_t precomputed_encode_1277xint16_x[precomputed_encode_1277xint16_NUM][crypto_encode_ITEMS] = {
  {44633,12474,35882,17265,46462,60774,13102,21047,5874,16150,5402,22716,37653,62809,29274,64411,19068,6495,56366,53858,61994,41620,60545,47376,39344,44307,4512,52551,6608,50185,49918,33262,55180,26727,55406,52387,21816,43053,54878,61720,16232,27626,7046,26065,8774,24219,2606,908,35269,59300,7453,42702,34219,4577,47728,28951,21824,48927,43495,52835,19660,10300,43931,5155,45150,20131,45859,64937,20586,36309,40798,48609,57472,16576,2232,65486,21246,25260,7451,25265,21201,50013,61695,60197,6449,46466,20238,26385,33551,14100,34752,61251,43149,15766,63000,23109,3700,4611,10775,58836,61555,3444,18716,52831,36398,42303,33134,6740,6955,46546,37666,62708,23320,63181,35618,38846,29935,7465,2714,57528,14114,38094,1799,39692,8165,109,57966,50251,62400,23187,48083,26798,42536,18014,6246,25252,29071,20453,42994,13263,5559,34473,19678,31502,64360,29822,61608,43793,24294,42588,34255,49522,31228,46507,10128,8100,32451,19931,27979,38693,26881,18341,59684,9519,30537,33197,23760,9563,52427,30097,63014,62621,8218,62368,60094,65255,10373,11749,47395,10715,35564,23912,12728,49718,29181,35660,36992,48846,49096,6250,12050,52831,28822,52520,42150,46486,49155,18832,11602,60519,34740,12082,19128,47080,9194,50904,20887,20041,47241,54572,20994,46945,123,41157,27552,47037,33487,1343,46177,11114,31874,9747,19406,28215,40934,43263,50871,41627,55039,15021,29279,4310,36812,57548,35880,21946,31226,58009,52034,20122,51913,1192,24915,61284,63585,39508,63573,12270,9914,32725,53383,39461,33834,657,35182,29665,37915,62684,43748,31765,55315,28490,26113,36273,29301,45071,25811,1847,44909,43447,54988,59041,30614,42823,29626,25937,9579,8911,17136,939,40161,3066,6480,23267,9918,30303,1794,35651,26720,51894,3635,50813,34696,46295,9332,62989,57632,33950,50012,47046,4056,48464,55928,24287,60134,41848,64848,13465,10211,35378,47396,29479,51668,31778,46283,27913,51971,33858,56654,45397,1290,5745,8217,26944,15112,2724,45100,29292,37373,28540,64893,13688,5189,22024,63038,53076,13769,32450,9393,22567,36977,20517,22796,44597,4815,19009,1785,57900,42978,4915,59941,7842,41473,54197,5652,48187,19283,16158,43023,36781,54686,58366,8930,15913,32614,50852,6172,18169,32223,60499,43383,14253,44034,3465,52573,2295,11368,6976,50820,27640,27761,47685,33052,32407,53604,13337,12642,18497,33125,28776,36453,34164,8612,48127,36675,28184,45255,28718,23334,53466,51299,56899,54723,49831,35707,29181,62191,24649,39892,50782,51567,44129,43555,23669,42985,30650,26490,38690,12196,26032,32152,59496,42602,46380,38607,35738,61812,42129,55096,12346,314,36035,37370,10483,5411,30706,44220,21932,34002,9609,3822,34582,33978,52353,9094,19398,48654,42328,13566,17383,4263,39642,5005,33058,33686,49403,12485,56130,2384,52661,32705,53165,46270,12663,41245,5703,29199,10895,60989,44121,4125,17724,27245,12925,32793,23503,45813,23614,39226,53121,64935,18779,44176,62525,1763,17066,57060,32334,3852,59775,15286,49203,37040,55942,42473,49917,50197,31099,25996,11336,27298,7989,44011,3948,17145,180,31917,60041,18104,50682,11222,19322,32447,44458,6111,62141,38585,39310,58113,5820,30470,12655,63216,46125,61424,22937,18100,55765,24433,2625,13970,31831,28095,50953,64596,47362,61152,35598,25550,12167,18743,40652,45740,11946,57415,44204,8902,23116,11203,16562,27617,34700,65059,27515,15908,56222,44739,38014,9739,60617,65116,51985,40300,32581,41760,58298,50399,26530,64962,62615,55286,45555,23827,2852,51383,25679,12792,17973,47758,30763,33409,9332,28949,13719,15809,23295,473,2744,62050,32936,46119,39670,51479,731,3598,42457,2966,16667,23104,49691,61666,19491,45815,15266,52838,58342,37470,51427,49041,50480,23067,56017,39645,40913,47343,29526,25065,63871,35,8147,20715,46455,21336,28634,40893,9231,10239,43428,33730,1761,42102,48237,14962,62052,18165,17712,54882,20440,21529,12883,22836,63304,52666,34079,44189,46376,21604,34342,56671,26045,23269,8364,19989,47883,36285,54185,15069,17629,22514,37799,2648,26652,31896,14964,12113,9775,11585,58436,48343,28236,34985,42319,62886,7744,2690,28918,22717,46138,32668,60924,59564,2391,53409,6199,33290,1442,58986,33961,35888,62115,65188,42957,49211,23077,59390,48480,63546,21103,50281,3451,36779,29595,2352,5865,35586,57129,35282,37014,38344,30302,33252,53604,30275,4897,62270,62053,23535,26761,57559,63788,35022,32064,5809,25872,61787,62996,45246,1063,35382,2383,60832,867,15481,59391,47422,41500,20014,45510,39147,58777,5783,22621,17939,57376,27808,56510,53058,32486,50132,7518,20502,52652,20699,18489,26469,11739,36469,60134,62981,34932,45664,11449,34034,50692,29208,64172,23426,28820,21957,13042,34225,17170,1324,15886,4052,60875,1834,45230,25925,33385,55926,58464,49304,49541,11252,30786,1235,54873,57342,27751,28628,25987,50410,15689,44691,2465,44462,48659,7604,50251,30517,59707,42769,54367,46588,27025,32412,44113,41569,53160,45468,49836,30668,336,21747,62846,3658,1723,51870,8008,51588,709,35231,64302,7643,46584,27947,50119,29668,50660,8311,53796,6270,5471,56300,52857,23483,40769,61175,41521,60483,2208,29402,39885,20268,43690,25629,44719,33480,55685,52480,57338,40584,17878,16146,57181,21773,41122,26543,17637,35217,62318,6217,7408,6907,20585,62037,1101,7674,25786,52931,24468,32987,11329,17398,45064,46165,44680,61356,48088,27507,60602,20465,32466,30285,37587,61866,14484,52636,60377,16951,50668,54880,11234,19597,55479,60506,7024,22890,51799,54552,33324,4119,4010,64210,24975,20269,26671,26344,38992,24179,15014,39539,62751,4844,15590,7471,56690,4446,54237,63536,25861,63691,25589,1204,47434,30096,48367,36698,45141,8848,40646,36780,20628,64064,7906,17829,10996,13490,53026,10013,55313,60893,64616,15511,53854,35222,46306,17681,23380,62807,6422,16622,15786,31147,57175,33592,17893,35569,53932,51510,62834,53773,24750,31929,47386,34035,57630,10527,65464,40526,46736,31879,46791,39751,26033,13631,50503,55202,61034,30863,56540,15345,12930,34293,53837,13430,47362,19557,63750,39355,46230,37796,63163,17906,24246,28933,4882,56310,49760,42110,19489,13229,38533,36125,46537,58057,33449,38470,40780,61139,22938,25733,53330,44373,58114,4160,34815,44563,15139,19174,11749,59909,47203,53297,3680,39371,28651,36955,60460,13478,28273,22168,39418,304,55199,15926,25808,31043,21088,1824,17776,47093,32753,55105,38178,33003,26826,5271,34353,61500,9045,50156,25105,6915,50213,9824,6624,64946,9542,44524,42994,7516,243,38392,31059,43284,8523,18843,51951,24604,6389,55969,49192,64286,14369,57160,28546,27833,47385,52986,36399,63169,25468,34549,44683,57862,24727,60724,56038,48769,11302,37709,32076,3642,41278,11442,54331,60855,11037,22556,13667,33985,58608,2454,59217,14802,37537,30982,50539,37905,44841,42362,34863,52147,26558,39622,51821,60420,26723,13371,52567,12929,15411,4226,39962,37496,19354,59948,45692,64392,2859,47300,21753,12489,17468,30015,3369,59688,16456,3142,53666,23409,26832,40811,3473,18780,33404,42042,60684,21263,12024,57262,32089,41686,39708,61713,12911,30164,8932,28135,38395,19559,32161,45722,23716,22579,16010,34729,28212,14645,36878,12590,59683,47609,30264,6407,52113,2717,22217,10235,29985,18153,15868,37644,31762,18152,47648,64422,30060,39564,59508,20831,24663,17095,62183,58666,52024,45352,13212,60063,12838,48578,48442,63082,7251,57408,5479,21413,7220,52880,63796,15332,65064,8903,17158,4569,38496,46854,48205,6822,41475,62005,39830,28084,13996,59534,19534,18099,29190,63151,22380,44065,32393,17519,52117,28824,2937,37365,26126,45229,5843,45905,5609,38975,49364,52130,35522,65053,50190,7403,11660,38908,2942,43719,30252,6535,4377,49970,48076,28862,24957,7205,31532,593,5795,59044,31847,35366,39866,59989,14050,64797,61568,17193,49416,60252},
  {59123,62832,6139,41032,2967,6250,104,60971,49800,12392,12433,60669,64177,48145,14588,46096,35347,26696,56653,3475,43869,41885,1794,45053,52027,42455,3890,7732,6538,6074,6924,6000,21275,35869,21595,9359,29025,48520,11390,13557,17685,14644,28375,51695,58628,65087,61258,14107,21210,6912,15097,13324,55960,42438,47228,54892,17420,40372,58653,11234,38847,44236,6396,19146,8464,55688,14142,6945,64504,40442,46646,15814,25577,17734,40335,7051,47741,43970,14594,50593,30766,16401,29405,46939,23922,44916,35144,28311,34110,54326,63660,56464,39241,11677,55806,34980,22425,27503,41717,33167,31400,5805,16491,19078,32574,50552,6126,58594,31452,53212,11734,57889,56396,26483,17161,51832,23975,61735,40123,21519,8852,20054,23092,7814,44083,4864,15491,33612,26931,46439,45165,16792,20756,12765,24489,13878,6992,36158,41430,44633,33722,10390,39778,21238,10933,49693,53915,9530,17004,54674,7453,4462,31794,61739,62284,41004,3078,18672,64594,26394,50957,17610,64196,61541,10915,53600,3369,46611,10696,26203,9018,52086,51211,53644,29380,35915,37795,6975,7445,8137,58993,29827,38581,13150,46890,45051,30658,16140,9320,36334,47712,18618,37123,44743,19598,43920,26723,18009,28158,60640,3712,49016,36237,40253,7788,13042,58725,42756,55151,7360,48608,887,6262,26392,51153,46795,18531,40895,27043,52793,52264,15118,5904,24606,2046,47799,3424,37663,30889,20421,7846,12845,16218,21310,55632,29561,9141,39014,6604,26320,16940,7293,40291,4687,41396,41044,58861,11953,21591,23492,55068,57736,49345,1168,28454,1231,16392,63404,63006,65414,10806,59513,2961,39165,25582,58562,3954,16363,16073,64439,5356,15907,14820,64921,7,6978,45725,2102,35489,15922,42927,51255,34359,16945,60276,25609,32605,8743,6081,19555,5707,24045,12511,12154,59598,60348,5729,30276,60508,63255,57015,37311,54323,2564,57613,20226,44544,13645,44641,5013,30824,18679,32627,31570,19652,61365,19931,19729,37323,40363,27283,23238,48494,63145,59772,30776,42776,20352,51846,56365,7649,21799,4005,27434,21014,58947,52290,4252,61402,62198,57592,46050,39558,51935,58206,18787,11508,54359,59827,43767,9432,50821,35493,3379,45042,61888,12453,24156,117,57614,52691,27121,37582,38016,49887,22896,62575,17147,57796,12009,54434,47563,44436,40659,59969,21204,17205,40052,32723,39953,39953,24972,26632,57902,58494,18456,4508,43269,48767,46447,61176,31313,55613,34925,16864,53920,8702,49270,28385,5573,41746,55101,57359,20137,62358,23712,22576,43065,18835,33921,47892,16790,6471,5539,39593,54621,15110,14434,2108,47110,19103,31447,35582,28742,6660,1389,2071,63624,50306,15888,8453,19117,52449,63143,17325,27583,23711,48019,51387,44374,9207,47482,27521,10931,15697,37232,36251,65259,29710,51324,63288,17230,13861,64559,51746,39181,61881,38469,18601,37940,22414,28956,29127,62984,51010,577,23133,46646,15206,39489,24053,55222,45370,58038,42351,62096,29497,33777,60745,33563,15775,46460,4678,20454,35723,12713,13,55136,35265,44833,19939,54681,62867,41809,39953,31866,18458,2721,53301,9810,59659,56779,56895,13040,57309,13537,2313,16486,45670,16766,32461,31536,16191,25314,3618,2075,3580,16147,43605,51856,33112,6587,20283,18564,29609,44342,44931,61202,59804,31345,2265,63523,33797,21987,25882,31128,43898,21545,41785,7378,3075,19904,6010,13049,55900,53325,35495,55929,65433,10388,49987,14622,44094,51718,40234,16677,63621,60953,36727,27089,4574,41586,24426,53478,13513,37833,5147,62617,31781,28896,24135,61070,46172,38269,40148,63921,44227,21782,788,33524,59569,21500,27398,3956,20567,36861,54746,58882,25219,1778,23493,45738,55752,887,16966,38101,40250,22486,31143,5818,42376,36490,25708,45712,892,62613,23395,31673,6289,22933,18084,32351,22270,18855,20809,5806,16659,50996,50066,1230,49367,59765,28271,27650,63363,32310,51858,5021,47693,35376,26370,20881,55516,40532,12236,6449,32850,34509,50987,2688,47280,53972,24796,59042,49384,28838,30438,15567,41134,50007,15667,4663,18291,1705,11781,61411,49943,563,6562,64373,65192,23709,60125,43133,33023,35638,15834,62753,49256,35720,7858,56261,23825,23849,20368,19000,27404,16945,5685,43178,52145,30756,8210,31624,65512,19060,54011,3192,42314,64676,16367,4688,30314,61089,40048,8772,36563,4273,64407,24147,19308,54697,14898,50777,6905,38287,8266,60275,52772,5880,33708,15322,60670,45858,17429,47234,10295,42888,10388,56199,4839,55260,35826,49131,16641,50951,11629,10459,14556,7883,8233,16788,48908,1895,18036,26608,20519,51074,12632,25320,59661,48682,26519,1298,51572,7008,26533,6766,58434,13700,26351,4984,42940,59861,31025,64788,21436,40369,2909,29953,60667,23591,49139,61387,39212,36876,37823,19631,33326,12205,50126,4048,15435,13170,52542,21634,13349,32566,42231,31700,15137,6094,51683,16585,19195,48720,14219,13673,1980,51745,37963,39561,1658,52203,49886,61867,499,26316,29948,56067,53846,24318,60318,48372,54118,23157,4995,7957,39632,45442,38537,47608,32216,64499,5660,35255,62140,38410,23585,40160,14301,64999,36588,30522,8804,21855,59927,14171,17694,48499,5506,63788,44601,851,16795,43940,7150,907,28915,12006,31438,35333,37136,59998,4739,1584,16082,61519,5619,47943,4708,63177,44767,16260,36277,44790,28165,15420,52111,15191,37413,25251,64860,32172,779,31584,6777,35332,37486,54964,33122,64442,54274,50018,54421,50603,61839,50661,54627,16327,64593,11862,45423,17231,44870,60685,45990,44528,37416,53033,60860,3314,44985,27552,55806,52021,43375,59393,21202,42635,17200,27096,59711,58341,56769,31317,60441,59920,29250,40378,3867,38131,40184,52361,14997,28622,50014,13892,34051,44722,31015,28018,43293,25102,57248,18782,63530,7719,63552,19861,57180,5093,2446,8572,50522,10064,2203,17441,14341,2160,37843,58103,136,53415,20231,16898,40608,14436,43163,29676,12848,21319,62857,12764,13241,62890,750,43545,48593,21699,35539,5880,64369,27167,47140,15339,17514,59127,55799,4483,13309,18415,29142,40752,811,37477,40116,10890,25179,595,46030,59799,53835,5096,30750,54811,62896,7007,30667,42888,61072,31367,41804,9467,31422,52546,14729,28014,63966,31308,58041,18301,32073,32560,33605,48353,49624,29758,41508,45148,63986,49930,52312,19418,11053,4881,27142,16339,2544,53005,3156,35828,54985,9900,55586,18939,5737,12661,8832,2126,41696,53244,24571,46713,663,45321,63477,61909,56964,48228,44245,45092,13558,39405,59243,3718,7566,59791,3576,54974,41890,18920,9686,52584,62053,21480,13234,28513,24419,58771,39562,6209,24953,63270,23049,59810,65330,3597,36610,12326,25075,19422,46843,2125,7489,11525,4020,63894,53646,21667,36570,20667,65213,53201,488,32496,54840,50307,41867,16862,22298,55127,9479,46094,43011,30288,58685,6061,6461,44653,39594,50155,44643,36809,9590,51192,19330,18292,52458,24337,63385,53507,7705,23502,37521,44334,25978,6636,6979,27829,20348,25736,3497,9244,34922,2587,5094,60589,4599,13186,3943,36559,11293,11382,42204,6220,17492,56828,37888,18830,30339,60592,47439,34253,24335,7400,59534,57982,51851,21513,41860,46052,10351,45949,469,28170,62166,61062,12795,16110,50028,14561,20752,30902,37009,30199,19899,2282,33425,63769,10616,30259,43686,42516,43517,43413,28212,10478,6506,21353,55613,12279,41498,47124,6825,13164,3724,21920,49368,17379,42602,46900,21121,32501,39206,62436,18601,46954,42000,48271,63917,19211,5673,42243,35783,17022,26994,27285,61078,31141,33046,60606,52997,31150,30184,19413,2052,35549,49056,2683,61775,44079,40287,62477,24259,35940,45721,15122,19902,28766,3172,1603,35461,16400,17359,50995,65420,42628,55853,23614,54513,6040,35056,29768,50867,21111,47353,56512,30617,43052,7506,48128,45259,5716,47607,4191,22132,31800,44270,63598,63207,11638,31849,21822,62883,61507,60949,46630,26156,4319,47471,14084,18050,50775,64583,7746,61436},
  {32735,28511,20371,46036,10693,44831,1,17500,30504,16682,15749,11922,16734,14448,5326,28886,12614,33651,25715,62097,63796,29256,38555,7355,30630,16819,15271,30012,21985,60390,49140,3590,18815,57235,29903,17001,33026,47254,18950,9831,7162,65043,2830,21595,60015,45512,9480,27052,51757,25220,46818,64210,60779,30966,31624,64774,47980,49453,11520,29674,50246,46897,13300,22085,54143,61844,19683,59123,36755,20826,17499,35311,34644,2692,60953,46929,54886,33670,45920,27573,34058,34707,20694,51497,64370,6073,22019,18497,31796,59282,13352,3773,46202,45672,9645,17677,28690,10339,36426,7771,10219,3517,21252,29773,14360,442,16182,36260,2430,31070,3848,5454,33877,4259,55557,40720,15796,48276,45637,58030,9470,27562,5620,6312,19968,50757,14483,9360,48308,35766,5023,393,33257,34384,22617,35528,26693,53220,63504,5460,22145,16682,29320,42905,43681,16302,40339,61135,51601,47704,44066,23991,37032,26193,2627,23003,56147,36092,6342,1345,25975,14986,4445,59239,13457,22198,33090,62074,18064,53956,56989,35750,40924,12854,40571,3560,62309,15572,51382,58109,51781,2222,60352,25668,57740,55267,55726,11035,8220,9744,10213,27335,5651,63017,27134,5058,25002,7274,40746,38762,58807,37050,4295,11148,62241,59232,43020,24292,43626,29081,22012,6238,32534,6295,26401,21786,36583,64661,43194,65380,23450,26772,16465,12644,14581,19847,3004,40617,60341,10993,36267,44134,2861,26769,28551,11515,6743,5877,15841,39864,27239,1545,24682,21996,24795,35777,18126,25522,15622,19890,31464,16327,55562,36122,51601,21223,22702,3857,62330,24590,19161,15369,43561,47224,17218,58877,21065,2305,21821,35237,47585,51114,18807,42612,48886,6095,44220,52037,54392,32646,4210,51089,62497,47747,18841,27706,4991,13090,24766,33853,24264,52372,6950,26382,10138,27932,52638,22252,30558,12802,25688,29290,21709,48294,32013,7659,494,56929,62922,16595,12915,5726,13805,54333,20135,13942,17578,61598,52399,54238,51432,26303,56872,10534,43104,37223,20448,22753,28216,12872,15029,64121,20663,64637,1480,56809,12466,11298,13032,52731,12874,48386,11781,17301,32227,34815,30791,50760,27772,10225,14795,61579,43737,40737,60585,34897,56291,27900,31699,30551,23488,1796,463,51634,27347,48102,20180,56383,55867,43481,20950,46531,14448,3818,34645,3400,58596,55707,37918,64284,60611,32566,51572,3023,6123,21601,10605,1073,6781,15357,32202,37544,64629,15916,25873,19989,45363,53276,23715,32542,2595,9916,37339,35622,10896,59187,58572,26108,51261,45850,19180,4628,48618,52149,8023,50552,31009,38061,34845,29470,20189,53754,13494,29869,40377,29477,32009,39370,44656,63779,36776,40464,38353,46723,29889,35927,48102,64791,16838,7507,36136,23661,57173,63305,56195,25061,28391,21949,45663,25366,57928,7873,3579,62066,46109,30091,45657,34946,52831,8119,15667,3083,56210,18431,22414,40077,54899,52459,7707,25789,26171,17144,42067,29506,17699,39392,36494,59730,5936,51855,53507,44090,37497,18472,32661,13067,8325,26367,49959,14199,47535,47244,3077,26100,56691,28421,26609,42306,17810,37153,29084,11877,17024,40398,7615,60542,39626,16483,31891,39122,9109,43862,43107,47773,56785,61649,12129,31911,18847,62813,56406,7083,41287,43038,21076,31485,57731,47692,15163,11226,60708,36883,59251,59401,18214,15172,23702,14522,38181,42786,3061,52865,42122,51788,426,4698,19301,45845,23822,40467,25027,29000,20966,31816,7586,4497,45531,13968,20954,44876,27003,39807,64877,50540,13445,5534,14337,15246,565,22578,52449,46265,62046,33521,57640,37912,40489,30305,17852,49462,35154,56264,38865,19885,53064,27354,19938,1944,6337,28016,7597,30886,28964,64547,52920,21557,21189,54233,58254,22344,6806,56174,45973,32865,5092,58200,26189,44187,45393,28653,27243,56481,52069,39888,61269,44660,38426,63123,49809,49251,25431,26815,39251,45159,41249,60216,42129,6780,44131,48878,60069,21712,6650,45285,59156,26166,48654,53881,21295,47759,54587,30256,64746,59359,47299,23984,36055,64952,31261,10413,51920,48851,32217,65106,1478,17058,58770,16083,61171,30686,24064,46770,17208,778,9903,45545,48970,43757,27317,30999,8123,12472,1751,14346,18088,59603,19948,21013,32371,61667,49323,20522,59297,11519,13270,61754,16486,56047,25096,46057,1958,38805,17760,24592,21850,29659,60249,39539,31679,40449,43292,57486,59702,7175,61701,50414,8479,35378,28491,49390,44801,29074,55599,39231,14670,26757,19427,49422,63654,52421,48983,34284,48147,32751,56426,29847,20399,13680,46489,50511,54090,61389,35367,14369,10132,52467,62169,13248,4203,63845,60218,56605,17312,37196,12234,1382,64147,19554,33733,18155,6815,39000,58482,63158,50689,5850,45801,34196,16521,48443,17775,1499,47422,60957,49065,49239,7486,30701,5500,14343,33245,51624,54672,2913,1671,15657,12229,59218,48774,62836,52031,18775,15819,61291,58393,43743,11135,18561,54861,48679,59620,15067,49243,32304,58234,57205,46609,23854,31358,48980,31985,23116,41994,411,51374,13045,13618,10641,51548,5612,49155,2081,36498,57651,50785,46724,49786,22782,9033,34089,42126,11507,17476,54191,52960,5060,17136,7837,7130,6589,4957,56126,50823,2538,55677,6544,54385,1177,45121,31853,7795,62122,46551,63606,46644,53169,3300,60234,40337,21870,4433,59617,19695,34722,24840,5293,7501,29164,13951,32191,51784,49856,1816,28974,23234,46146,49692,21050,33099,17317,16080,23901,22108,28499,29040,62414,11899,56108,49693,48520,6699,19377,21551,65178,44571,52176,30353,57628,19607,64783,34388,21961,45261,27856,12131,30170,34020,4930,50022,58059,9025,33139,28953,52273,62168,48688,28434,16342,45271,11273,28782,36026,7369,54470,11024,17593,44040,17067,28190,50953,25604,60474,34967,55574,60427,4443,25223,33432,18020,16859,52583,6078,37634,49501,44245,52472,40069,34312,43501,28380,12255,18584,56463,55757,16012,42940,276,37177,2030,46851,52861,33123,11534,17279,8958,40734,28654,7957,35858,51542,43161,54473,50555,37590,45108,51246,46196,25249,36379,35907,28117,11508,7877,44326,4907,33980,54324,5171,29029,21710,17308,5638,27046,16285,10279,1848,27204,63808,44661,30563,6360,1962,19151,33880,33544,60954,63749,36965,165,39329,35513,38272,19258,50516,40281,7113,16699,59661,19298,36950,63251,34598,41262,6181,6393,18817,21575,53600,23384,59321,6541,51210,20446,23126,4130,12559,55675,46797,18718,38262,15278,29209,24274,995,39879,16157,32499,34664,37900,58565,8545,55543,63843,13107,65525,11052,42914,57120,62149,49435,57462,54786,18610,52596,43375,40001,20870,53306,63445,44876,22106,43573,44748,14108,41894,12480,55110,53767,49717,13095,53351,15669,5876,14987,59095,9432,48118,23946,15590,52109,60527,11540,39571,12759,12463,37239,65384,26392,26790,50388,1119,27424,30092,23340,25790,3084,5146,56396,31194,2707,57278,35569,9734,55018,7436,58625,42049,9995,7354,16024,57388,16978,54215,56688,26349,2200,28046,8487,12287,10629,19499,2422,14095,63062,35242,50070,32126,19953,29707,56180,61312,57857,16246,4398,36490,6168,62961,62840,18613,41159,44380,58127,19566,44004,12748,39472,43507,31286,167,12092,32570,47193,22787,32274,1381,40564,3683,17495,26387,32546,19158,47868,41969,61839,62070,41446,6718,46896,23141,29492,4570,56572,15848,16646,9417,24676,52217,63452,62052,7022,26989,56870,64299,35675,5305,12627,65401,19845,22218,51141,6768,59464,3414,1474,53730,6849,34491,49674,4393,20847,11561,26074,29253,20440,28435,31562,24829,15755,29008,57373,12248,49006,36517,10563,42954,25453,25864,11673,46579,34011,25222,32501,26474,11507,64175,22376,51607,5381,17704,22785,11348,36912,38060,24969,46806,40229,20458,35769,56236,35187,38087,27046,28567,19168,23448,35390,28952,36506,6723,9590,29173,52944,22424,13993,55733,31202,11198,31840,42929,51902,41048,48220,11024,36927,4141,17511,19563,34777,8152,27262,16906,1122,34252,63890,56525,20064,22279},
  {3339,42485,26258,3285,42063,53458,50006,42933,15716,2535,45679,52718,60051,24312,48751,29724,36743,25549,36884,19157,14254,42827,22170,134,3600,30087,60400,3342,38484,43764,28195,8944,26930,22543,13517,14587,19375,9946,8404,26697,26183,37007,49566,41,1839,4001,63719,46491,12404,43204,15766,45183,43844,62686,3070,54942,16208,29900,37893,63109,34342,18914,6818,48126,22203,17926,54927,21211,809,49906,63371,28618,30742,34966,8957,63000,64158,56365,54522,13910,52191,29680,64906,2163,63287,21238,8736,61754,22910,20072,59764,28871,14598,30401,5004,22671,59630,10158,56631,15315,44880,42718,10288,35319,51298,44241,26824,54529,62321,56004,37530,21704,33595,49138,35382,32268,39547,36862,39151,42260,35218,48924,17698,51609,56174,51016,54023,9591,64850,5533,63927,40627,52312,23627,34213,23821,5473,38832,55794,50873,2303,41319,8933,2227,1168,25389,59011,710,12528,15575,44288,4914,26763,64324,18746,54343,53778,19169,24638,61301,25228,56080,41277,21233,26921,39047,19251,17060,18238,4735,27743,39542,15725,15693,49917,9142,17026,43915,42194,60891,32515,43892,11982,50685,21309,33836,28151,47030,38182,49651,53381,34931,31133,11209,38158,2567,37997,56073,56210,41199,53721,57016,5849,47525,5355,61656,27930,5581,55055,31532,21161,47052,31195,51403,60323,17548,60945,3928,29559,42264,30902,20732,58273,39869,4597,43768,52616,39494,58862,65356,12161,29384,43837,22075,50982,44854,3269,26906,48711,36684,62290,21210,29801,47891,24345,36011,15731,62209,9363,64212,58259,16446,61868,30267,4439,4407,60733,31233,13676,54234,6132,26907,2852,58872,49441,34364,26644,37927,7380,43763,14368,47580,41201,34657,27967,63544,60977,3100,22043,14329,4999,10267,11290,19203,8061,15843,36982,10713,4777,33866,44218,23182,36106,9808,13443,6821,15173,5285,23004,52350,39934,5036,14773,33324,9781,37651,38391,18357,36146,29686,6109,411,3693,14797,38222,33232,52485,64006,51376,55978,19709,4256,41030,14671,9434,31078,29922,49564,27327,14329,26081,16515,4853,54012,51207,4523,3719,58822,34868,54783,2249,9916,2144,36620,20569,2005,57118,13121,25578,8275,3975,19520,23061,733,5389,52912,620,42247,59229,3107,32196,42621,9892,18211,24310,30248,20912,25002,56501,60841,49705,58953,18481,965,56845,2076,3734,43676,24985,46912,30791,13480,63487,58663,46875,14619,61356,46269,56554,15065,34147,47223,63219,35449,12236,53007,7547,42903,48262,63087,45394,32553,34731,28153,65310,16796,53745,22666,13327,5950,1730,38452,36882,4364,5717,63869,9524,25331,8657,37146,30700,59671,29787,65224,64512,25716,32258,30684,23109,22304,56291,46239,42061,54560,44929,7007,16435,59447,17439,56848,10454,65486,12039,53001,19926,17922,55120,36174,33842,59579,27269,40722,399,57901,50354,38730,256,33968,51566,18962,26767,32316,26093,29581,4186,14898,26706,49459,27348,34005,24756,59672,46480,63179,40918,25004,7185,50203,14708,9871,50800,35300,41577,44749,40644,6779,21259,53821,702,5469,5670,47389,23774,100,36304,28160,63787,3855,60347,11984,4399,25214,64912,41930,13654,10431,62802,7522,30071,59679,7233,63428,43039,46549,8394,48215,29883,61942,23327,57802,24630,64224,22594,39377,32336,12451,7825,63990,20133,46082,38267,8830,8583,39563,11475,52456,37284,61013,15048,45813,5958,9240,34891,37677,46365,42060,65166,28724,23594,22528,1268,58498,4682,29249,57320,26077,28738,11833,42967,2441,36219,25808,36553,43244,11237,41109,26082,10416,55837,63004,59082,47140,60105,28216,42607,27996,17006,63288,61830,35228,51378,43337,908,49362,33457,60667,208,21010,59463,20466,27655,40274,8766,33618,14371,47312,55407,2475,31095,31945,44250,37501,37709,41317,38023,23045,26040,14909,18337,30964,27137,56066,15372,11385,62285,12036,853,4475,24450,9744,34597,23159,53597,28060,28539,6615,64680,26396,47858,12632,55426,20178,22766,51916,50174,17072,30658,58840,51767,52299,7413,1490,36149,18155,9936,10202,56859,22059,45209,32917,61573,57073,51079,61055,6610,15792,58331,13869,31197,58975,37387,19358,58868,22364,33338,49242,33417,26807,58395,8862,41065,58457,21512,11582,16491,63643,11699,43162,46712,19612,914,28249,9183,42918,34522,30892,47515,60938,56509,23424,17811,36452,486,43143,64623,6341,19867,10301,31588,29883,10344,19852,55819,39805,19310,18915,19975,32533,54394,8882,33308,13886,24362,8723,40532,11118,28905,65252,7411,59967,17724,42033,25708,33566,62128,12798,17246,4785,36507,54296,39177,42764,51346,53878,56131,55838,4265,12586,13986,35735,5368,63483,16655,787,65241,62740,96,34023,63584,2763,17688,46711,32645,58869,65532,25632,32755,51763,54163,63804,33809,60765,49990,8178,24784,12021,43037,60617,9661,11392,22558,43887,51716,46253,52933,40339,45435,16956,36242,65036,64546,12780,34142,2050,45646,58255,33612,51171,1490,52234,20149,49721,23016,30448,59919,1260,56150,37479,62857,32405,24972,34547,46341,26387,29272,61312,3893,24735,1968,6636,10238,3336,30377,9754,54836,35129,12722,47151,6038,20676,64219,55055,1590,3945,29541,15488,191,31320,22777,42470,32782,44543,57658,54046,27752,16797,7474,9973,13689,49127,37501,61422,23384,59079,2534,20584,7566,65504,18437,32591,28188,59643,8911,63525,60240,40961,37986,42072,63232,41235,28858,27426,17411,5415,53639,49477,41439,3643,65462,13190,60513,47269,27424,33438,28917,43057,15819,513,19967,46876,61367,60631,41520,48362,39871,45533,21273,46562,64263,24981,59658,5264,25387,35306,33368,36249,41511,33155,61321,38607,54048,51234,21376,33128,6661,4768,61874,39541,50806,6283,29618,16400,43694,12523,46841,35505,54452,18139,22778,46808,8531,952,36312,12877,9238,20522,55565,54856,29910,10187,30701,32229,6072,51518,64462,24587,13785,2754,42520,52231,23554,55927,59167,59571,21742,20322,25562,18406,64263,62222,63208,7695,35559,32296,41694,58564,49875,40756,61219,38192,58780,719,22820,52488,52031,61279,31044,39327,32272,24162,22153,17746,36676,56234,47516,61193,25982,46357,20010,28205,54786,10734,41292,11903,52411,56912,50505,23333,5553,65124,54132,25342,30604,32495,53092,14872,16137,33050,64726,2594,28730,13143,65506,4630,49766,50198,17503,17783,37615,15310,12833,60422,34747,41684,43067,28588,56049,21664,31183,30980,52702,60613,27424,50507,13985,63864,15994,51884,61378,41922,38540,31734,25485,59694,60259,51704,51570,2866,49484,21967,3124,33638,44643,58608,54700,3631,64023,57796,33159,25512,36259,14143,21780,47167,50283,36965,49296,1806,23295,29085,50670,37202,45863,63930,27441,61006,2861,12131,12084,11374,18789,6205,62858,59888,21602,29825,44446,30481,7203,21945,23169,41901,41418,34330,39633,24430,51667,59491,14693,6201,12913,42689,35178,31549,59343,49039,57572,63386,15344,12067,15585,43453,57642,43768,14141,20335,12175,27607,24247,10230,64341,26025,7097,44741,43795,19184,57840,37145,11666,51717,32915,38914,27889,4991,56368,51171,56591,39294,63317,12009,38588,22957,57471,57494,52214,12814,47542,62699,37477,60604,31167,29293,21070,34482,50081,32613,46991,10605,9578,58500,63461,14356,41230,42233,9621,33731,63850,14902,15016,16464,6539,36642,60976,61547,60353,40926,6417,63008,43821,56467,38986,13186,5017,23398,32298,7774,62246,38511,43033,51401,27211,21999,63878,34753,27417,48675,58773,59454,57918,33526,57830,1046,56528,12387,60513,31758,25061,59733,64751,24578,17902,62416,60434,23746,30973,59994,17842,24061,26889,30568,25904,47061,38877,62672,51258,16211,1850,51366,35019,19048,41168,65147,10350,44896,21947,29266,45322,59139,36761,23518,49063,9976,59426,54552,45277,57178,63790,36169,18089,26059,30906,2532,14343,19794,22326,20980,44359,41190,4838,5194,20709,38618,50418,19460,20620,24091,11707,4785,4749,5810,14754,25558,24527,11383,18175,32148,22764,15838,27709,14464,45465,51122,30540,8751,1687,10839,55210},
} ;

static void test_encode_1277xint16_impl(long long impl)
{
  unsigned char *s = test_encode_1277xint16_s;
  unsigned char *x = test_encode_1277xint16_x;
  unsigned char *s2 = test_encode_1277xint16_s2;
  unsigned char *x2 = test_encode_1277xint16_x2;
  long long slen = crypto_encode_STRBYTES;
  long long xwords = crypto_encode_ITEMS;
  long long xlen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_encode_1277xint16_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_encode = ntruprime_dispatch_encode_1277xint16(impl);
    printf("encode_1277xint16 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_1277xint16_implementation(impl),ntruprime_dispatch_encode_1277xint16_compiler(impl));
  } else {
    crypto_encode = ntruprime_encode_1277xint16;
    printf("encode_1277xint16 selected implementation %s compiler %s\n",ntruprime_encode_1277xint16_implementation(),ntruprime_encode_1277xint16_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_encode_ITEMBYTES;

      output_prepare(s2,s,slen);
      input_prepare(x2,x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      secret(x,xlen);
      crypto_encode(s,x);
      public(x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      public(s,slen);
      checksum(s,slen);
      output_compare(s2,s,slen,"crypto_encode");
      input_compare(x2,x,xlen,"crypto_encode");

      double_canary(s2,s,slen);
      double_canary(x2,x,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      secret(x2,xlen);
      crypto_encode(s2,x2);
      public(x2,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      public(s2,slen);
      if (memcmp(s2,s,slen) != 0) fail("failure: crypto_encode is nondeterministic\n");
    }
    checksum_expected(encode_1277xint16_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_encode_1277xint16_NUM;++precomp) {
    output_prepare(s2,s,crypto_encode_STRBYTES);
    input_prepare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x,precomputed_encode_1277xint16_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x2,precomputed_encode_1277xint16_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    crypto_encode(s,x);
    if (memcmp(s,precomputed_encode_1277xint16_s[precomp],crypto_encode_STRBYTES)) {
      fail("failure: crypto_encode fails precomputed test vectors\n");
      printf("expected s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",((unsigned char *) precomputed_encode_1277xint16_s[precomp])[pos]);
      printf("\n");
      printf("received s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",s[pos]);
      printf("\n");
    }
    output_compare(s2,s,crypto_encode_STRBYTES,"crypto_encode");
    input_compare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES,"crypto_encode");
  }
}

void test_encode_1277xint16(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"1277xint16")) return;
  storage_encode_1277xint16_s = callocplus(crypto_encode_STRBYTES);
  test_encode_1277xint16_s = aligned(storage_encode_1277xint16_s,crypto_encode_STRBYTES);
  if (crypto_encode_STRBYTES > maxalloc) maxalloc = crypto_encode_STRBYTES;
  storage_encode_1277xint16_x = callocplus(crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  test_encode_1277xint16_x = aligned(storage_encode_1277xint16_x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  if (crypto_encode_ITEMS*crypto_encode_ITEMBYTES > maxalloc) maxalloc = crypto_encode_ITEMS*crypto_encode_ITEMBYTES;
  storage_encode_1277xint16_s2 = callocplus(maxalloc);
  test_encode_1277xint16_s2 = aligned(storage_encode_1277xint16_s2,crypto_encode_STRBYTES);
  storage_encode_1277xint16_x2 = callocplus(maxalloc);
  test_encode_1277xint16_x2 = aligned(storage_encode_1277xint16_x2,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("encode_1277xint16 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_encode_1277xint16();++impl)
      forked(test_encode_1277xint16_impl,impl);
    ++test_encode_1277xint16_s;
    ++test_encode_1277xint16_x;
    ++test_encode_1277xint16_s2;
    ++test_encode_1277xint16_x2;
  }
  free(storage_encode_1277xint16_x2);
  free(storage_encode_1277xint16_s2);
  free(storage_encode_1277xint16_x);
  free(storage_encode_1277xint16_s);
}
#undef crypto_encode_STRBYTES
#undef crypto_encode_ITEMS
#undef crypto_encode_ITEMBYTES

