/*
 * Kylin-video
 *
 * Copyright (C) 2021, Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Liu Cong <liucong1@kylinos.cn>
 *
 */

#include "systemtrayicon.h"

#include <QMenu>
#include <QAction>

SystemTrayIcon::SystemTrayIcon(QObject *parent) :
    QSystemTrayIcon(parent)
{
    initMenu();
    initIcon();
    setToolTip(tr("Video Player"));
}

SystemTrayIcon::~SystemTrayIcon()
{

}

void SystemTrayIcon::initIcon()
{
    setIcon(QIcon::fromTheme("kylin-video"));
}

void SystemTrayIcon::initMenu()
{
    menu = new QMenu;
    actQuit = new QAction(tr("Quit"));
    connect(actQuit, &QAction::triggered, [&](){emit sigQuit();});
    menu->addAction(actQuit);
    setContextMenu(menu);
}
