/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.android;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("plugins/android-extensions/android-extensions-idea/testData/android/findUsages")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class AndroidFindUsagesTestGenerated extends AbstractAndroidFindUsagesTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
    }

    public void testAllFilesPresentInFindUsages() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("plugins/android-extensions/android-extensions-idea/testData/android/findUsages"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, false);
    }

    @TestMetadata("fqNameInAttr")
    public void testFqNameInAttr() throws Exception {
        runTest("plugins/android-extensions/android-extensions-idea/testData/android/findUsages/fqNameInAttr/");
    }

    @TestMetadata("fqNameInAttrFragment")
    public void testFqNameInAttrFragment() throws Exception {
        runTest("plugins/android-extensions/android-extensions-idea/testData/android/findUsages/fqNameInAttrFragment/");
    }

    @TestMetadata("fqNameInTag")
    public void testFqNameInTag() throws Exception {
        runTest("plugins/android-extensions/android-extensions-idea/testData/android/findUsages/fqNameInTag/");
    }

    @TestMetadata("fqNameInTagFragment")
    public void testFqNameInTagFragment() throws Exception {
        runTest("plugins/android-extensions/android-extensions-idea/testData/android/findUsages/fqNameInTagFragment/");
    }

    @TestMetadata("multiFile")
    public void testMultiFile() throws Exception {
        runTest("plugins/android-extensions/android-extensions-idea/testData/android/findUsages/multiFile/");
    }

    @TestMetadata("multiFileFragment")
    public void testMultiFileFragment() throws Exception {
        runTest("plugins/android-extensions/android-extensions-idea/testData/android/findUsages/multiFileFragment/");
    }

    @TestMetadata("simple")
    public void testSimple() throws Exception {
        runTest("plugins/android-extensions/android-extensions-idea/testData/android/findUsages/simple/");
    }

    @TestMetadata("simpleFragment")
    public void testSimpleFragment() throws Exception {
        runTest("plugins/android-extensions/android-extensions-idea/testData/android/findUsages/simpleFragment/");
    }

    @TestMetadata("simpleView")
    public void testSimpleView() throws Exception {
        runTest("plugins/android-extensions/android-extensions-idea/testData/android/findUsages/simpleView/");
    }

    @TestMetadata("wrongIdFormat")
    public void testWrongIdFormat() throws Exception {
        runTest("plugins/android-extensions/android-extensions-idea/testData/android/findUsages/wrongIdFormat/");
    }
}
