#include <stdio.h>
#include <math.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include "threshdialog.h"
#include "gtkloopview.h"

static void low_callback(GtkWidget* lowspin, gpointer data){
	looper_data_t *looperdata = (looper_data_t*)data;
	GtkWidget* highspin = 
                g_object_get_data (G_OBJECT(lowspin),"highspin");

	looperdata_lock(looperdata);
	looperdata_set_low_threshold(looperdata, (double)gtk_spin_button_get_value ((GtkSpinButton*)lowspin));
	looperdata_unlock(looperdata);
	if (looperdata_get_low_threshold(looperdata) > looperdata_get_high_threshold(looperdata)){
                gtk_spin_button_set_value ((GtkSpinButton*)highspin,
                looperdata_get_low_threshold(looperdata));
        }
}

static void high_callback(GtkWidget* highspin, gpointer data){
        looper_data_t *looperdata = (looper_data_t*)data;
	GtkWidget* lowspin =
                g_object_get_data (G_OBJECT(highspin),"lowspin");

	looperdata_lock(looperdata);
        looperdata_set_high_threshold(looperdata, (double)gtk_spin_button_get_value ((GtkSpinButton*)highspin));
	looperdata_unlock(looperdata);
	if (looperdata_get_low_threshold(looperdata) > looperdata_get_high_threshold(looperdata)){
                gtk_spin_button_set_value ((GtkSpinButton*)lowspin,
                looperdata_get_high_threshold(looperdata));
        }
}

static void size_callback(GtkWidget* sizespin, gpointer data){
        looper_data_t *looperdata = (looper_data_t*)data;
	
	looperdata_lock(looperdata);
        looperdata_set_thresholdbuffersize(looperdata, (double)gtk_spin_button_get_value ((GtkSpinButton*)sizespin));
	looperdata_unlock(looperdata);
}


void threshdialog_new(GtkWidget* parent, looper_data_t* looperdata){
	GtkAdjustment 	*adj;
	/*GtkTooltips     *tooltips;*/
        GtkWidget       *dialog;
        GtkWidget       *lowlabel;
        GtkWidget       *highlabel;
	GtkWidget	*sizelabel;

	GtkWidget	*lowbox;
	GtkWidget	*highbox;
	GtkWidget	*sizebox;
	GtkWidget	*mainbox;

        GtkWidget       *lowspin;       /* spinbutton */
        GtkWidget       *highspin;     	/* spinbutton */
	GtkWidget	*sizespin;	/* spinbutton */
	/*gint result;*/


	/*tooltips = gtk_tooltips_new ();*/

	
	lowlabel = gtk_label_new ("low threshold");
	highlabel = gtk_label_new ("high threshold");
	sizelabel = gtk_label_new ("buffer size (in samples)");

        adj = (GtkAdjustment *) gtk_adjustment_new (looperdata_get_low_threshold(looperdata),
				 0., 1., .001, .01, .01);
        lowspin = gtk_spin_button_new (adj, .01, 3);

	adj = (GtkAdjustment *) gtk_adjustment_new (looperdata_get_high_threshold(looperdata),
				0., 1., .001, .01, .01);
	highspin = gtk_spin_button_new (adj, .01, 3);

        adj = (GtkAdjustment *) gtk_adjustment_new (looperdata_get_thresholdbuffersize(looperdata),
				64, 882000, 1, 1000, 100);
	sizespin = gtk_spin_button_new (adj, 1, 0);

	g_object_set_data (G_OBJECT (lowspin),"highspin",highspin);
	g_object_set_data (G_OBJECT (highspin),"lowspin",lowspin);

	g_signal_connect (G_OBJECT (lowspin), "value_changed",
                        G_CALLBACK (low_callback), (gpointer) looperdata);
        g_signal_connect (G_OBJECT (highspin), "value_changed",
                        G_CALLBACK (high_callback), (gpointer) looperdata);
	g_signal_connect (G_OBJECT (sizespin), "value_changed",
			G_CALLBACK (size_callback), (gpointer) looperdata);


	lowbox = gtk_hbox_new(TRUE,10);
	highbox = gtk_hbox_new(TRUE,10);
	sizebox = gtk_hbox_new(TRUE,10);

	gtk_box_pack_start (GTK_BOX (lowbox),lowlabel, TRUE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (lowbox),lowspin, TRUE, TRUE, 0);

	gtk_box_pack_start (GTK_BOX (highbox),highlabel, TRUE, TRUE, 0);
        gtk_box_pack_start (GTK_BOX (highbox),highspin, TRUE, TRUE, 0);

	gtk_box_pack_start (GTK_BOX (sizebox),sizelabel, TRUE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (sizebox),sizespin, TRUE, TRUE, 0);

	mainbox = gtk_vbox_new (FALSE,5);
	gtk_box_pack_start (GTK_BOX(mainbox), lowbox, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX(mainbox), highbox, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX(mainbox), sizebox, FALSE, FALSE, 0);

	
	dialog = gtk_dialog_new_with_buttons ("settings for automatic recording",
                        (GtkWindow*)parent,
                        /*GTK_DIALOG_MODAL |*/ GTK_DIALOG_DESTROY_WITH_PARENT,
                        GTK_STOCK_OK,
                        GTK_RESPONSE_ACCEPT,
                        NULL);

	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox),mainbox);
	gtk_widget_show_all (dialog);

	/*result =*/ gtk_dialog_run (GTK_DIALOG (dialog));
        gtk_widget_destroy (dialog);
}

