---
title: "GPS"
permalink: /docs/devel/webui_rest/gps/
toc: true
docgroup: "devel-rest"
excerpt: "Supported GPS devices, defined GPS devices, and current location information."
---
Kismet now supports multiple simultaneous GPS devices, and can select the 'best' quality device based on priority and GPS signal.

## List all available GPS drivers

Kismet supports multiple types of GPS device, and can be extended by plugins. 

* URL

    /gps/drivers.json

    /gps/drivers.ekjson

    /gps/drivers.itjson

* Methods

    `GET`

* Role

    `readonly`

* Return 

    Array of all supported GPS drivers

## List all GPS devices

* URL

    /gps/all_gps.json

    /gps/all_gps.ekjson

    /gps/all_gps.itjson

* Methods

    `GET`

* Role

    `readonly`

* Return 

    All configured GPS devices

## Add a GPS device

* URL

    /gps/add_gps.cmd

* Methods

    `POST`

* API Added

    `2021-02`

* Role

    `admin`

* POST parameters

    A [command dictionary](/docs/devel/webui_rest/commands/) containing:

    | Key        | Description         |
    | ---        | -----------         |
    | definition | GPS definition line |

* Results

    Newly defined GPS, or HTTP error on failure

## Remove a GPS device

* URL

    /gps/by-uuid/*[UUID]*/remove_gps.cmd

* Methods

    `GET`

* API Added

    `2021-02`

* Role

    `admin`

* URI parameters

    | Key  | Description                |
    | ---  | -----------                |
    | UUID | GPS to be removed, by UUID |

* Results

    HTTP success if GPS removed
    
    HTTP failure if GPS could not be removed or command is malformed


## GPS location

The current "best" GPS location can be retrieved, with timestamp, for presentation in the UI or use in logging.

* URL

    /gps/location.json

* Methods

    `GET`, `POST`

* Role

    `readonly`

* POST parameters

    If submitted via POST,

    A [command dictionary](/docs/devel/webui_rest/commands/) containing:

    | Key  | Description                                |
    | ---- | ---------------------------------------    |
    | fields | Optional Kismet [field simplification](/docs/devel/webui_rest/commands/#field-specifications). |

* Return

    Current "best" GPS location and information

## All GPS locations

Returns the current location of all GPS interfaces.

* URL

    /gps/all_locations.json

* Methods

    `GET`, `POST`

* Role

    `readonly`

* POST parameters

    If submitted via POST,

    A [command dictionary](/docs/devel/webui_rest/commands/) containing:

    | Key  | Description                                |
    | ---- | ---------------------------------------    |
    | fields | Optional Kismet [field simplification](/docs/devel/webui_rest/commands/#field-specifications). |

* Return

    A dictionary, indexed by UUID, of all GPS devices and locations


## Per-receiver GPS location

The current location of the GPS specified by the UUID parameter.

* URL

    /gps/by-uuid/*[UUID]*/location.json

* Methods

    `GET`, `POST`

* Role

    `readonly`

* URI parameters

    | Key  | Description                     |
    | ---  | -----------                     |
    | UUID | GPS UUID to fetch location from |

* POST parameters

    If submitted via POST,

    A [command dictionary](/docs/devel/webui_rest/commands/) containing:

    | Key  | Description                                |
    | ---- | ---------------------------------------    |
    | fields | Optional Kismet [field simplification](/docs/devel/webui_rest/commands/#field-specifications). |

* Return

    The current location of the specified GPS, or HTTP error if the GPS interface is not found.

## Web GPS

Kismet supports a Web-based GPS, where the data is provided by the browser (or submitted over the HTTP channel from another GPS source).

* URL

    /gps/web/update.cmd

* Methods

    `POST`

* Role

    `admin`, `WEBGPS`

* POST parameters

    A [command dictionary](/docs/devel/webui_rest/commands/) containing:

    | Key  | Description                                |
    | ---- | ---------------------------------------    |
    | lat  | GPS latitude                               |
    | lon  | GPS longitude                              |
    | alt  | Optional, GPS altitude in meters           |
    | spd  | Optional, GPS speed in kilometers per hour |

* Returns

    `HTTP 200` on successful update of the webgps location

    HTTP error on failure

## WebGPS Websocket

Kismet supports a Web-based GPS, where the data is provided by the browser (or submitted over the HTTP channel from another GPS source).  The websocket interface allows a continual update on a single connection.

* URL

    /gps/web/update.ws

* API Added

    `2021-08`

* Methods

    `WEBSOCKET` (HTTP Upgrade + Websocket handshake)

* Role

    `admin`, `WEBGPS`

* URI parameters

    | Key      | Description                                                  |
    | ---      | -----------                                                  |
    | user     | Kismet administrative username, as HTTP URI-encoded variable |
    | password | Kismet administrative password, as HTTP URI-encoded variable |
    | KISMET   | Kismet auth cookie, as HTTP URI-encoded variable             |

* Websocket interface

    The websocket subscription API accepts JSON data posting an updated GPS location.

    The JSON data should contain:

    | Key  | Description                                |
    | ---- | ---------------------------------------    |
    | lat  | GPS latitude                               |
    | lon  | GPS longitude                              |
    | alt  | Optional, GPS altitude in meters           |
    | spd  | Optional, GPS speed in kilometers per hour |

* Result

    A valid location update receives a websocket response of: `{"update": "ok"}`
    An invalid location update receives a websocket response of: `{"update": "error"}` and Kismet may terminate the connection

* Notes

    Kismet websockets will accept authentication as HTTP basic auth headers, Kismet session token cookies, or HTTP URI-encoded GET parameters of the basic auth or session cookie.

    Some tools (websocat, others) allow sending HTTP basic auth as part of the URI (`ws://user:pass@host:port/eventbus/events.ws`).  However, modern browser implementations do *not* support this, and websockets must be constructed using GET parameters, such as `ws://host:port/eventbus/events.ws?user=username&password=userpass`.

    Websocket URIs *must* match the content type of the calling page; a `https` page must use the `wss` URI and a `http` page must use the `ws` URI.  The Kismet UI detects this via javascript, but other implementations must provide a similar match.


## Meta GPS

A meta-gps is a GPS with no defined backend driver.  Typically it would be used for attaching a GPS to a [remote capture](/docs/readme/datasources_remote_capture/) using the `metagps=...` source option.

* URL

    /gps/meta/*[name]*/update.cmd

* API Added

    `2022-01-R3`

* Methods

    `POST`

* Role

    `admin`, `WEBGPS`

* URI parameters

    | Key  | Description                                                                                   |
    | ---  | -----------                                                                                   |
    | name | Name of the metagps, as per when it was created, such as from the `metagps=...` source option |

* POST parameters

    A [command dictionary](/docs/devel/webui_rest/commands/) containing:

    | Key  | Description                                |
    | ---- | ---------------------------------------    |
    | lat  | GPS latitude                               |
    | lon  | GPS longitude                              |
    | alt  | Optional, GPS altitude in meters           |
    | spd  | Optional, GPS speed in kilometers per hour |

* Returns

    `HTTP 200` on successful update of the webgps location

    HTTP error on failure

## Meta GPS Websocket

A meta-gps is a GPS with no defined backend driver.  Typically it would be used for attaching a GPS to a [remote capture](/docs/readme/datasources_remote_capture/) using the `metagps=...` source option.
* URL

    /gps/meta/*[name]*/update.ws*[?user=...&password=...]

* API Added

    `2022-01-R3`

* Methods

    `WEBSOCKET` (HTTP Upgrade + Websocket handshake)

* Role

    `admin`, `WEBGPS`

* URI parameters

    | Key      | Description                                                                                   |
    | ---      | -----------                                                                                   |
    | name     | Name of the metagps, as per when it was created, such as from the `metagps=...` source option |
    | user     | Kismet administrative username, as HTTP URI-encoded variable                                  |
    | password | Kismet administrative password, as HTTP URI-encoded variable                                  |
    | KISMET   | Kismet auth cookie, as HTTP URI-encoded variable                                              |

* Websocket interface

    The websocket subscription API accepts JSON data posting an updated GPS location.

    The JSON data should contain:

    | Key  | Description                                |
    | ---- | ---------------------------------------    |
    | lat  | GPS latitude                               |
    | lon  | GPS longitude                              |
    | alt  | Optional, GPS altitude in meters           |
    | spd  | Optional, GPS speed in kilometers per hour |

* Result

    A valid location update receives a websocket response of: `{"update": "ok"}`
    An invalid location update receives a websocket response of: `{"update": "error"}` and Kismet may terminate the connection

* Notes

    Kismet websockets will accept authentication as HTTP basic auth headers, Kismet session token cookies, or HTTP URI-encoded GET parameters of the basic auth or session cookie.

    Some tools (websocat, others) allow sending HTTP basic auth as part of the URI (`ws://user:pass@host:port/eventbus/events.ws`).  However, modern browser implementations do *not* support this, and websockets must be constructed using GET parameters, such as `ws://host:port/eventbus/events.ws?user=username&password=userpass`.

    Websocket URIs *must* match the content type of the calling page; a `https` page must use the `wss` URI and a `http` page must use the `ws` URI.  The Kismet UI detects this via javascript, but other implementations must provide a similar match.


