/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.util;

import com.jsql.model.InjectionModel;
import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.model.exception.InjectionFailureException;
import com.jsql.model.injection.method.AbstractMethodInjection;
import com.jsql.util.LogLevelUtil;
import java.net.IDN;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ParameterUtil {
    private static final Logger LOGGER;
    private List<AbstractMap.SimpleEntry<String, String>> listQueryString = new CopyOnWriteArrayList<AbstractMap.SimpleEntry<String, String>>();
    private List<AbstractMap.SimpleEntry<String, String>> listRequest = new CopyOnWriteArrayList<AbstractMap.SimpleEntry<String, String>>();
    private List<AbstractMap.SimpleEntry<String, String>> listHeader = new CopyOnWriteArrayList<AbstractMap.SimpleEntry<String, String>>();
    private String rawRequest = "";
    private String rawHeader = "";
    private boolean isMultipartRequest = false;
    private static final String FORMAT_KEY_VALUE = "%s=%s";
    private final InjectionModel injectionModel;
    private static final boolean[] tchar;

    public ParameterUtil(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
    }

    public void controlInput(String urlQuery, String rawRequest, String rawHeader, AbstractMethodInjection methodInjection, String typeRequest, boolean isScanning) {
        try {
            String authority;
            Object urlQueryFixed = urlQuery;
            if (((String)urlQueryFixed).isEmpty()) {
                throw new MalformedURLException("empty URL");
            }
            if (!((String)urlQueryFixed).matches("(?i)^https?://.*")) {
                if (!((String)urlQueryFixed).matches("(?i)^\\w+://.*")) {
                    LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Undefined URL protocol, forcing to [http://]");
                    urlQueryFixed = "http://" + (String)urlQueryFixed;
                } else {
                    throw new MalformedURLException("unknown URL protocol");
                }
            }
            if ((authority = URI.create((String)urlQueryFixed).getAuthority()) == null) {
                throw new MalformedURLException("incorrect domain authority");
            }
            String authorityPunycode = IDN.toASCII(authority);
            if (!authority.equals(authorityPunycode)) {
                LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Punycode domain detected, using [{}] instead of [{}]", (Object)authorityPunycode, (Object)authority);
                urlQueryFixed = ((String)urlQueryFixed).replace(authority, authorityPunycode);
            }
            this.initQueryString((String)urlQueryFixed);
            this.initHeader(rawHeader);
            this.initRequest(rawRequest);
            this.injectionModel.getMediatorUtils().getConnectionUtil().setMethodInjection(methodInjection);
            this.injectionModel.getMediatorUtils().getConnectionUtil().setTypeRequest(typeRequest);
            if (isScanning) {
                this.injectionModel.beginInjection();
            } else {
                new Thread(this.injectionModel::beginInjection, "ThreadBeginInjection").start();
            }
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Incorrect Url: {}", (Object)e.getMessage());
            Request request = new Request();
            request.setMessage(Interaction.END_PREPARATION);
            this.injectionModel.sendToViews(request);
        }
    }

    public void checkParametersFormat() throws InjectionFailureException {
        this.checkOneOrLessStar();
        this.checkStarMatchMethod();
        this.checkMethodNotEmpty();
        this.checkMultipart();
        if (ParameterUtil.isInvalidName(this.injectionModel.getMediatorUtils().getConnectionUtil().getTypeRequest())) {
            throw new InjectionFailureException(String.format("Illegal method: \"%s\"", this.injectionModel.getMediatorUtils().getConnectionUtil().getTypeRequest()));
        }
    }

    public static boolean isInvalidName(String token) {
        for (int i = 0; i < token.length(); ++i) {
            char c = token.charAt(i);
            if (c <= '\u00ff' && tchar[c]) continue;
            return true;
        }
        return token.isEmpty();
    }

    private void checkMultipart() throws InjectionFailureException {
        this.isMultipartRequest = false;
        if (this.getListHeader().stream().filter(entry -> "Content-Type".equals(entry.getKey())).anyMatch(entry -> entry.getValue() != null && ((String)entry.getValue()).contains("multipart/form-data") && ((String)entry.getValue()).contains("boundary="))) {
            LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "Multipart boundary found in header");
            Matcher matcherBoundary = Pattern.compile("boundary=([^;]*)").matcher(this.getHeaderFromEntries());
            if (matcherBoundary.find()) {
                String boundary = matcherBoundary.group(1);
                if (!this.rawRequest.contains(boundary)) {
                    throw new InjectionFailureException(String.format("Incorrect multipart data, boundary not found in body: %s", boundary));
                }
                this.isMultipartRequest = true;
            }
        }
    }

    private void checkOneOrLessStar() throws InjectionFailureException {
        int nbStarInParameter = 0;
        if (this.getQueryStringFromEntries().contains("*")) {
            ++nbStarInParameter;
        }
        if (this.getRequestFromEntries().contains("*")) {
            ++nbStarInParameter;
        }
        if (this.getHeaderFromEntries().contains("*")) {
            ++nbStarInParameter;
        }
        if (nbStarInParameter > 1 || StringUtils.countMatches((CharSequence)this.getQueryStringFromEntries(), "*") > 1 || StringUtils.countMatches((CharSequence)this.getRequestFromEntries(), "*") > 1 || StringUtils.countMatches((CharSequence)this.getHeaderFromEntries(), "*") > 1) {
            throw new InjectionFailureException("Character insertion [*] must be used once in Query String, Request or Header parameters");
        }
    }

    public void checkStarMatchMethod() throws InjectionFailureException {
        AbstractMethodInjection methodInjection = this.injectionModel.getMediatorUtils().getConnectionUtil().getMethodInjection();
        boolean isCheckingAllParam = this.injectionModel.getMediatorUtils().getPreferencesUtil().isCheckingAllParam();
        if (this.getQueryStringFromEntries().contains("*") && methodInjection != this.injectionModel.getMediatorMethod().getQuery() && !isCheckingAllParam) {
            throw new InjectionFailureException("Select method GET to use character [*] or remove [*] from GET parameters");
        }
        if (this.getRequestFromEntries().contains("*") && methodInjection != this.injectionModel.getMediatorMethod().getRequest() && !isCheckingAllParam) {
            throw new InjectionFailureException("Select a Request method (like POST) to use [*], or remove [*] from Request parameters");
        }
        if (this.getHeaderFromEntries().contains("*") && methodInjection != this.injectionModel.getMediatorMethod().getHeader() && !isCheckingAllParam) {
            throw new InjectionFailureException("Select method Header to use character [*] or remove [*] from Header parameters");
        }
    }

    public void checkMethodNotEmpty() throws InjectionFailureException {
        AbstractMethodInjection methodInjection = this.injectionModel.getMediatorUtils().getConnectionUtil().getMethodInjection();
        boolean isCheckingAllParam = this.injectionModel.getMediatorUtils().getPreferencesUtil().isCheckingAllParam();
        if (methodInjection == this.injectionModel.getMediatorMethod().getQuery() && !isCheckingAllParam && this.getListQueryString().isEmpty() && !this.injectionModel.getMediatorUtils().getConnectionUtil().getUrlBase().contains("*")) {
            throw new InjectionFailureException("No query string");
        }
        if (methodInjection == this.injectionModel.getMediatorMethod().getRequest() && this.getListRequest().isEmpty()) {
            throw new InjectionFailureException("Incorrect Request format");
        }
        if (methodInjection == this.injectionModel.getMediatorMethod().getHeader() && this.getListHeader().isEmpty()) {
            throw new InjectionFailureException("Incorrect Header format");
        }
    }

    public String initStar(AbstractMap.SimpleEntry<String, String> parameterToInject) {
        String characterInsertionByUser;
        if (parameterToInject == null) {
            characterInsertionByUser = "*";
        } else {
            characterInsertionByUser = parameterToInject.getValue();
            parameterToInject.setValue("*");
        }
        return characterInsertionByUser;
    }

    public void initQueryString(String urlQuery) throws MalformedURLException, URISyntaxException {
        URL url = new URI(urlQuery).toURL();
        if (StringUtils.isEmpty(urlQuery) || StringUtils.isEmpty(url.getHost())) {
            throw new MalformedURLException("empty URL");
        }
        this.injectionModel.getMediatorUtils().getConnectionUtil().setUrlByUser(urlQuery);
        this.injectionModel.getMediatorUtils().getConnectionUtil().setUrlBase(urlQuery);
        this.listQueryString.clear();
        Matcher regexQueryString = Pattern.compile("(.*\\?)(.*)").matcher(urlQuery);
        if (!regexQueryString.find()) {
            return;
        }
        this.injectionModel.getMediatorUtils().getConnectionUtil().setUrlBase(regexQueryString.group(1));
        if (StringUtils.isNotEmpty(url.getQuery())) {
            this.listQueryString = Pattern.compile("&").splitAsStream(url.getQuery()).map(keyValue -> Arrays.copyOf(keyValue.split("="), 2)).map(keyValue -> new AbstractMap.SimpleEntry<String, String>(keyValue[0], keyValue[1] == null ? "" : keyValue[1])).collect(Collectors.toList());
        }
    }

    public void initRequest(String rawRequest) {
        this.rawRequest = rawRequest;
        this.listRequest.clear();
        if (StringUtils.isNotEmpty(rawRequest)) {
            this.listRequest = this.isMultipartRequest ? new ArrayList<AbstractMap.SimpleEntry<String, String>>(List.of(new AbstractMap.SimpleEntry<String, String>(rawRequest, ""))) : Pattern.compile("&").splitAsStream(rawRequest).map(keyValue -> Arrays.copyOf(keyValue.split("="), 2)).map(keyValue -> new AbstractMap.SimpleEntry<String, String>(keyValue[0], keyValue[1] == null ? "" : keyValue[1])).collect(Collectors.toList());
        }
    }

    public void initHeader(String rawHeader) {
        this.rawHeader = rawHeader;
        this.listHeader.clear();
        if (StringUtils.isNotEmpty(rawHeader)) {
            this.listHeader = Pattern.compile("\\\\r\\\\n").splitAsStream(rawHeader).map(keyValue -> Arrays.copyOf(keyValue.split(":"), 2)).map(keyValue -> new AbstractMap.SimpleEntry<String, String>(keyValue[0], keyValue[1] == null ? "" : keyValue[1])).collect(Collectors.toList());
        }
    }

    public String getQueryStringFromEntries() {
        return this.listQueryString.stream().filter(Objects::nonNull).map(entry -> {
            if (this.injectionModel.getMediatorStrategy().getStrategy() == this.injectionModel.getMediatorStrategy().getMultibit() && entry.getValue() != null && ((String)entry.getValue()).contains("*")) {
                return String.format(FORMAT_KEY_VALUE, entry.getKey(), "*");
            }
            return String.format(FORMAT_KEY_VALUE, entry.getKey(), entry.getValue());
        }).collect(Collectors.joining("&"));
    }

    public String getRequestFromEntries() {
        return this.listRequest.stream().filter(Objects::nonNull).map(entry -> String.format(FORMAT_KEY_VALUE, entry.getKey(), StringUtils.isEmpty((CharSequence)entry.getValue()) ? "" : entry.getValue())).collect(Collectors.joining("&"));
    }

    public String getHeaderFromEntries() {
        return this.listHeader.stream().filter(Objects::nonNull).map(entry -> String.format("%s:%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("\\r\\n"));
    }

    public boolean isRequestSoap() {
        return this.rawRequest.trim().matches("^(<soapenv:|<\\?xml).*");
    }

    public String getRawRequest() {
        return this.rawRequest;
    }

    public String getRawHeader() {
        return this.rawHeader;
    }

    public List<AbstractMap.SimpleEntry<String, String>> getListRequest() {
        return this.listRequest;
    }

    public List<AbstractMap.SimpleEntry<String, String>> getListHeader() {
        return this.listHeader;
    }

    public List<AbstractMap.SimpleEntry<String, String>> getListQueryString() {
        return this.listQueryString;
    }

    public boolean isMultipartRequest() {
        return this.isMultipartRequest;
    }

    static {
        char[] allowedTokenChars;
        LOGGER = LogManager.getRootLogger();
        tchar = new boolean[256];
        for (char c : allowedTokenChars = "!#$%&'*+-.^_`|~0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray()) {
            ParameterUtil.tchar[c] = true;
        }
    }
}

