/**********************************************************************
 *
 * Copyright (c) 2004 Olaf Willuhn
 * All rights reserved.
 * 
 * This software is copyrighted work licensed under the terms of the
 * Jameica License.  Please consult the file "LICENSE" for details. 
 *
 **********************************************************************/

package de.willuhn.jameica.hbci.rmi;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.List;

/**
 * Interface fuer ein einzelnes Adressbuch.
 * Alle Klassen, die dieses Interface implementieren, werden automatisch von
 * Hibiscus erkannt.
 * Alle Implementierungen muessen einen parameterlosen Konstruktor
 * besitzen (Bean-Spezifikation), um via Reflection instanziiert werden zu koennen.
 */
public interface Addressbook extends Remote
{
  /**
   * Liefert einen sprechenden Namen fuer das Adressbuch.
   * @return Name des Adressbuches.
   * @throws RemoteException
   */
  public String getName() throws RemoteException;
  
  /**
   * Sucht nach Adressen und liefert die gefundenen zurueck.
   * Es ist der jeweiligen Implementierung des Adressbuches ueberlassen,
   * in welchen Feldern/Attributen der Adressdaten sie nach dem uebergebenen Text
   * sucht.
   * Wird kein Text uebergeben, kann das Adressbuch selbst entscheiden,
   * ob es alle Adressen zurueckliefert oder gar keine.
   * @param text der Suchtext.
   * @return Liste der gefundenen Adressen.
   * Die Objekte der Liste muessen vom Typ <code>Address</code> sein.
   * Die Funktion darf auch <code>null</code> zurueckliefern, wenn keine Adressen gefunden wurden.
   * @throws RemoteException
   * @see AddressbookService#findAddresses(String)
   */
  public List findAddresses(String text) throws RemoteException;
  
  /**
   * Prueft, ob im Adressbuch eine Adresse <b>mit diesen Eigenschaften</b> enthalten ist.
   * @param address die gesuchte Adresse.
   * @return die Adresse mit den gleichen Eigenschaften aus dem Adressbuch oder <code>null</code>.
   * @throws RemoteException
   */
  public Address contains(Address address) throws RemoteException;
}


/*********************************************************************
 * $Log: Addressbook.java,v $
 * Revision 1.3  2007/04/23 18:07:14  willuhn
 * @C Redesign: "Adresse" nach "HibiscusAddress" umbenannt
 * @C Redesign: "Transfer" nach "HibiscusTransfer" umbenannt
 * @C Redesign: Neues Interface "Transfer", welches von Ueberweisungen, Lastschriften UND Umsaetzen implementiert wird
 * @N Anbindung externer Adressbuecher
 *
 * Revision 1.2  2007/04/20 14:55:31  willuhn
 * @C s/findAddress/findAddresses/
 *
 * Revision 1.1  2007/04/20 14:49:05  willuhn
 * @N Support fuer externe Adressbuecher
 * @N Action "EmpfaengerAdd" "aufgebohrt"
 *
 **********************************************************************/