/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.internal.html.dita.editor;

import java.util.HashMap;

import org.dbdoclet.option.OptionException;
import org.dbdoclet.tag.dita.DitaTagFactory;
import org.dbdoclet.tag.html.HtmlDocument;
import org.dbdoclet.tag.html.HtmlElement;
import org.dbdoclet.trafo.html.EditorException;
import org.dbdoclet.trafo.html.EditorInstruction;
import org.dbdoclet.trafo.html.dita.SectionDetector;

public class HeadingEditor extends DitaEditor {

	public static HashMap<String, HashMap<String, String>> validHtmlParentPathMap;

	static {

		validHtmlParentPathMap = new HashMap<String, HashMap<String, String>>();
		validHtmlParentPathMap.put(new HtmlDocument().getNodeName(),
				HtmlElement.getAttributeMap());
		validHtmlParentPathMap.put(org.dbdoclet.tag.html.Html.getTag(),
				HtmlElement.getAttributeMap());
		validHtmlParentPathMap.put(HtmlElement.getTag(),
				HtmlElement.getAttributeMap());
		validHtmlParentPathMap.put(HtmlElement.getTag(),
				HtmlElement.getAttributeMap());
		validHtmlParentPathMap.put(HtmlElement.getTag(),
				HtmlElement.getAttributeMap());
		validHtmlParentPathMap.put(HtmlElement.getTag(),
				HtmlElement.getAttributeMap());
	}

	@Override
	public EditorInstruction edit(EditorInstruction values)
			throws EditorException {

		try {

			DitaTagFactory tagFactory = getTagFactory();
			SectionDetector sectionDetector = new SectionDetector();
			sectionDetector.setScript(script);
			sectionDetector.setTagFactory(tagFactory);
			sectionDetector.edit(values);

			setValues(super.edit(values));
			return finalizeValues();

		} catch (OptionException oops) {

			throw new EditorException(oops);
		}
	}

}
