# emicklei/go-restful instrumentation example

An HTTP server using emicklei/go-restful and instrumentation. The server has a
`/users/{id:[0-9]+}` endpoint. The server generates span information to
`stdout`.

These instructions assume you have
[docker-compose](https://docs.docker.com/compose/) installed.

Bring up the `go-restful-server` and `go-restful-client` services to run the
example:

```sh
docker-compose up --detach go-restful-server go-restful-client
```

The `go-restful-client` service sends just one HTTP request to `go-restful-server`
and then exits. View the span generated by `go-restful-server` in the logs:

```sh
docker-compose logs go-restful-server
```

Shut down the services when you are finished with the example:

```sh
docker-compose down
```
