## Introduction

Marshaling is a basic interface representing fixed-length (or known-length)
cryptographic objects or structures having a built-in binary encoding.
Implementors must ensure that calls to these methods do not modify the
underlying object so that other users of the object can access it concurrently.

```
type Marshaling interface {
	encoding.BinaryMarshaler
	encoding.BinaryUnmarshaler

	String() string
	MarshalSize() int
	MarshalTo(w io.Writer) (int, error)
	UnmarshalFrom(r io.Reader) (int, error)
}
```

## Data Members

### BinaryMarshaler

```
type BinaryMarshaler interface {
	MarshalBinary() (data []byte, err error)
}
```
[BinaryMarshaler](https://pkg.go.dev/encoding#BinaryMarshaler) is an interface
present in the encoding library of Golang. It is an interface implemented by an
object which can marshal itself into a binary form. MarshalBinary function
encodes the receiver into a binary form and returns the result.

### BinaryUnmarshaler

```
type BinaryUnmarshaler interface {
	UnmarshalBinary(data []byte) error
}
```
[BinaryUnmarshaler](https://pkg.go.dev/encoding#BinaryUnmarshaler) is an
interface present in the encoding library of Golang. It is an interface
implemented by an object which can unmarshal a binary representation itself.
UnmarshalBinary must be able ti decode the form generated by MarshalBinary.
UnmarshalBinary must copy the data if wishes to retain the data after returning.

## Functions

**Note** : The Object in here refers to the object of the class which has
implemented the marshalling interface.

### String()

|            |                                        |
| ---------- |----------------------------------------|
| Function   | `Object.String() string`               |
| Parameters | - `None`                               |
| Output     | - `string` : The human readable string |

This functions returns a human readable string representation of the object
value.

### MarshalSize()

|            |                                        |
| ---------- |----------------------------------------|
| Function   | `Object.MarshalSize() int`             |
| Parameters | - `None`                               |
| Output     | - `int` : Length of the encoded object |

The MarshalSize function returns the encoded length of the object in bytes

### MarshalTo()

|            |                                                                                                                     |
| ---------- |---------------------------------------------------------------------------------------------------------------------|
| Function   | `Object.MarshalTo(io.Writer) (int, error)`                                                                          |
| Parameters | - `io.Writer` : The destination writer to which the object will be marshalled                                       |
| Output     | - `int` : Number of bytes written<br/>- `error` : Contains an error if something unexpected happened, otherwise nil |

The MarshalTo function is used to encode the contents of the object and then
write them to an io.Writer. The int being returned here indicates the byte count
of the encoded object.

### UnmarshalFrom()

|            |                                                                                                                     |
| ---------- |---------------------------------------------------------------------------------------------------------------------|
| Function   | `Object.UnmarshalFrom(r io.Reader) (int, error)`                                                                    |
| Parameters | - `io.Reader` : The source from where the object will be unmarshalled from                                          |
| Output     | - `int` : Number of bytes written<br/>- `error` : Contains an error if something unexpected happened, otherwise nil |

This function decodes the content of the object by reading from io.Reader. If r
is an XOF, it uses r o pick a valid object pseudo-randomly, which may entail
more than Len bytes due to retries.