// Copyright The Notary Project Authors.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package cose

import (
	"testing"
)

func FuzzSignatureCose(f *testing.F) {
	f.Fuzz(func(t *testing.T, envelopeBytes []byte, shouldVerify bool) {
		e, err := ParseEnvelope(envelopeBytes)
		if err != nil {
			t.Skip()
		}

		if shouldVerify {
			_, _ = e.Verify()
		} else {
			_, _ = e.Content()
		}
	})
}
