package available

// List of fingerprinted "available" responses for each possible TLD.
func fingerprints() map[string]string {
	fprints := map[string]string{
		"gop":                      "This domain name has not been registered",
		"cooking":                  "This domain name has not been registered",
		"bbc":                      "This domain name has not been registered",
		"yoga":                     "This domain name has not been registered",
		"horse":                    "This domain name has not been registered",
		"abogado":                  "This domain name has not been registered",
		"broadway":                 "This domain name has not been registered",
		"bayern":                   "This domain name has not been registered",
		"fishing":                  "This domain name has not been registered",
		"cymru":                    "This domain name has not been registered",
		"work":                     "This domain name has not been registered",
		"luxe":                     "This domain name has not been registered",
		"law":                      "This domain name has not been registered",
		"wedding":                  "This domain name has not been registered",
		"rodeo":                    "This domain name has not been registered",
		"miami":                    "This domain name has not been registered",
		"bentley":                  "This domain name has not been registered",
		"vip":                      "This domain name has not been registered",
		"fit":                      "This domain name has not been registered",
		"fashion":                  "This domain name has not been registered",
		"vodka":                    "This domain name has not been registered",
		"casa":                     "This domain name has not been registered",
		"wed":                      "This domain name has not been registered",
		"wales":                    "This domain name has not been registered",
		"bradesco":                 "This domain name has not been registered",
		"budapest":                 "This domain name has not been registered",
		"garden":                   "This domain name has not been registered",
		"uk":                       "This domain name has not been registered",
		"beer":                     "This domain name has not been registered",
		"london":                   "This domain name has not been registered",
		"surf":                     "This domain name has not been registered",
		"allfinanz":                "The queried object does not exist",
		"alsace":                   "The queried object does not exist",
		"aquarelle":                "The queried object does not exist",
		"bar":                      "The queried object does not exist",
		"barcelona":                "The queried object does not exist",
		"bauhaus":                  "The queried object does not exist",
		"bcn":                      "The queried object does not exist",
		"berlin":                   "The queried object does not exist",
		"best":                     "The queried object does not exist",
		"bmw":                      "The queried object does not exist",
		"bom":                      "The queried object does not exist",
		"bostik":                   "The queried object does not exist",
		"bridgestone":              "The queried object does not exist",
		"brother":                  "The queried object does not exist",
		"brussels":                 "The queried object does not exist",
		"bzh":                      "The queried object does not exist",
		"canon":                    "The queried object does not exist",
		"cat":                      "The queried object does not exist",
		"ceo":                      "The queried object does not exist",
		"citic":                    "The queried object does not exist",
		"college":                  "The queried object does not exist",
		"cologne":                  "The queried object does not exist",
		"coop":                     "The queried object does not exist",
		"corsica":                  "The queried object does not exist",
		"datsun":                   "The queried object does not exist",
		"desi":                     "The queried object does not exist",
		"design":                   "The queried object does not exist",
		"dnp":                      "The queried object does not exist",
		"dvag":                     "The queried object does not exist",
		"epson":                    "The queried object does not exist",
		"erni":                     "The queried object does not exist",
		"eurovision":               "The queried object does not exist",
		"eus":                      "The queried object does not exist",
		"fan":                      "The queried object does not exist",
		"fans":                     "The queried object does not exist",
		"feedback":                 "The queried object does not exist",
		"final":                    "The queried object does not exist",
		"firestone":                "The queried object does not exist",
		"forum":                    "The queried object does not exist",
		"frl":                      "The queried object does not exist",
		"frogans":                  "The queried object does not exist",
		"gal":                      "The queried object does not exist",
		"gent":                     "The queried object does not exist",
		"ggee":                     "The queried object does not exist",
		"globo":                    "The queried object does not exist",
		"gmo":                      "The queried object does not exist",
		"gmx":                      "The queried object does not exist",
		"goldpoint":                "The queried object does not exist",
		"goo":                      "The queried object does not exist",
		"hamburg":                  "The queried object does not exist",
		"hitachi":                  "The queried object does not exist",
		"honda":                    "The queried object does not exist",
		"host":                     "The queried object does not exist",
		"hyundai":                  "The queried object does not exist",
		"icu":                      "The queried object does not exist",
		"ifm":                      "The queried object does not exist",
		"infiniti":                 "The queried object does not exist",
		"ink":                      "The queried object does not exist",
		"jcb":                      "The queried object does not exist",
		"jprs":                     "The queried object does not exist",
		"kddi":                     "The queried object does not exist",
		"kia":                      "The queried object does not exist",
		"koeln":                    "The queried object does not exist",
		"komatsu":                  "The queried object does not exist",
		"kred":                     "The queried object does not exist",
		"kyoto":                    "The queried object does not exist",
		"la":                       "The queried object does not exist",
		"lacaixa":                  "The queried object does not exist",
		"lancaster":                "The queried object does not exist",
		"lat":                      "The queried object does not exist",
		"leclerc":                  "The queried object does not exist",
		"lexus":                    "The queried object does not exist",
		"lidl":                     "The queried object does not exist",
		"lixil":                    "The queried object does not exist",
		"lotte":                    "The queried object does not exist",
		"love":                     "The queried object does not exist",
		"madrid":                   "The queried object does not exist",
		"man":                      "The queried object does not exist",
		"mango":                    "The queried object does not exist",
		"mini":                     "The queried object does not exist",
		"mma":                      "The queried object does not exist",
		"movistar":                 "The queried object does not exist",
		"museum":                   "The queried object does not exist",
		"nagoya":                   "The queried object does not exist",
		"nec":                      "The queried object does not exist",
		"nhk":                      "The queried object does not exist",
		"nico":                     "The queried object does not exist",
		"nissan":                   "The queried object does not exist",
		"nrw":                      "The queried object does not exist",
		"ntt":                      "The queried object does not exist",
		"okinawa":                  "The queried object does not exist",
		"online":                   "The queried object does not exist",
		"ooo":                      "The queried object does not exist",
		"otsuka":                   "The queried object does not exist",
		"ovh":                      "The queried object does not exist",
		"paris":                    "The queried object does not exist",
		"pohl":                     "The queried object does not exist",
		"press":                    "The queried object does not exist",
		"protection":               "The queried object does not exist",
		"pw":                       "The queried object does not exist",
		"quebec":                   "The queried object does not exist",
		"realty":                   "The queried object does not exist",
		"reit":                     "The queried object does not exist",
		"ren":                      "The queried object does not exist",
		"rent":                     "The queried object does not exist",
		"rest":                     "The queried object does not exist",
		"ricoh":                    "The queried object does not exist",
		"rio":                      "The queried object does not exist",
		"ruhr":                     "The queried object does not exist",
		"ryukyu":                   "The queried object does not exist",
		"saarland":                 "The queried object does not exist",
		"sakura":                   "The queried object does not exist",
		"sap":                      "The queried object does not exist",
		"schwarz":                  "The queried object does not exist",
		"scot":                     "The queried object does not exist",
		"seat":                     "The queried object does not exist",
		"security":                 "The queried object does not exist",
		"sfr":                      "The queried object does not exist",
		"sharp":                    "The queried object does not exist",
		"site":                     "The queried object does not exist",
		"sncf":                     "The queried object does not exist",
		"sohu":                     "The queried object does not exist",
		"sony":                     "The queried object does not exist",
		"space":                    "The queried object does not exist",
		"spiegel":                  "The queried object does not exist",
		"stc":                      "The queried object does not exist",
		"stcgroup":                 "The queried object does not exist",
		"suzuki":                   "The queried object does not exist",
		"swiss":                    "The queried object does not exist",
		"tatar":                    "The queried object does not exist",
		"tech":                     "The queried object does not exist",
		"telefonica":               "The queried object does not exist",
		"theatre":                  "The queried object does not exist",
		"tickets":                  "The queried object does not exist",
		"tirol":                    "The queried object does not exist",
		"tokyo":                    "The queried object does not exist",
		"top":                      "The queried object does not exist",
		"toray":                    "The queried object does not exist",
		"toshiba":                  "The queried object does not exist",
		"toyota":                   "The queried object does not exist",
		"tui":                      "The queried object does not exist",
		"uol":                      "The queried object does not exist",
		"versicherung":             "The queried object does not exist",
		"viva":                     "The queried object does not exist",
		"vlaanderen":               "The queried object does not exist",
		"voting":                   "The queried object does not exist",
		"wang":                     "The queried object does not exist",
		"website":                  "The queried object does not exist",
		"wiki":                     "The queried object does not exist",
		"wme":                      "The queried object does not exist",
		"ws":                       "The queried object does not exist",
		"xn--1qqw23a":              "The queried object does not exist",
		"xn--30rr7y":               "The queried object does not exist",
		"xn--3bst00m":              "The queried object does not exist",
		"xn--45q11c":               "The queried object does not exist",
		"xn--55qx5d":               "The queried object does not exist",
		"xn--6qq986b3xl":           "The queried object does not exist",
		"xn--80asehdb":             "The queried object does not exist",
		"xn--80aswg":               "The queried object does not exist",
		"xn--9et52u":               "The queried object does not exist",
		"xn--czr694b":              "The queried object does not exist",
		"xn--czru2d":               "The queried object does not exist",
		"xn--d1acj3b":              "The queried object does not exist",
		"xn--efvy88h":              "The queried object does not exist",
		"xn--fiq64b":               "The queried object does not exist",
		"xn--hxt814e":              "The queried object does not exist",
		"xn--imr513n":              "The queried object does not exist",
		"xn--io0a7i":               "The queried object does not exist",
		"xn--mgbab2bd":             "The queried object does not exist",
		"xn--ses554g":              "The queried object does not exist",
		"xn--vermgensberater-ctb":  "The queried object does not exist",
		"xn--vermgensberatung-pwb": "The queried object does not exist",
		"xn--xhq521b":              "The queried object does not exist",
		"xyz":                      "The queried object does not exist",
		"yodobashi":                "The queried object does not exist",
		"yokohama":                 "The queried object does not exist",
		"zuerich":                  "The queried object does not exist",
		"audio":                    "is available for registration",
		"auto":                     "is available for registration",
		"blackfriday":              "is available for registration",
		"car":                      "is available for registration",
		"cars":                     "is available for registration",
		"christmas":                "is available for registration",
		"click":                    "is available for registration",
		"country":                  "is available for registration",
		"diet":                     "is available for registration",
		"flowers":                  "is available for registration",
		"game":                     "is available for registration",
		"gift":                     "is available for registration",
		"guitars":                  "is available for registration",
		"help":                     "is available for registration",
		"hiphop":                   "is available for registration",
		"hiv":                      "is available for registration",
		"hosting":                  "is available for registration",
		"juegos":                   "is available for registration",
		"kg":                       "is available for registration",
		"ky":                       "is available for registration",
		"link":                     "is available for registration",
		"lol":                      "is available for registration",
		"mom":                      "is available for registration",
		"photo":                    "is available for registration",
		"pics":                     "is available for registration",
		"property":                 "is available for registration",
		"sexy":                     "is available for registration",
		"tattoo":                   "is available for registration",
		"academy":                  "Domain not found",
		"accountants":              "Domain not found",
		"actor":                    "Domain not found",
		"ads":                      "Domain not found",
		"agency":                   "Domain not found",
		"airforce":                 "Domain not found",
		"android":                  "Domain not found",
		"apartments":               "Domain not found",
		"app":                      "Domain not found",
		"army":                     "Domain not found",
		"associates":               "Domain not found",
		"attorney":                 "Domain not found",
		"auction":                  "Domain not found",
		"band":                     "Domain not found",
		"bargains":                 "Domain not found",
		"bike":                     "Domain not found",
		"bingo":                    "Domain not found",
		"bn":                       "Domain not found",
		"boo":                      "Domain not found",
		"boutique":                 "Domain not found",
		"builders":                 "Domain not found",
		"business":                 "Domain not found",
		"cab":                      "Domain not found",
		"cafe":                     "Domain not found",
		"cal":                      "Domain not found",
		"camera":                   "Domain not found",
		"camp":                     "Domain not found",
		"capital":                  "Domain not found",
		"cards":                    "Domain not found",
		"care":                     "Domain not found",
		"careers":                  "Domain not found",
		"cash":                     "Domain not found",
		"casino":                   "Domain not found",
		"catering":                 "Domain not found",
		"center":                   "Domain not found",
		"channel":                  "Domain not found",
		"chat":                     "Domain not found",
		"cheap":                    "Domain not found",
		"chrome":                   "Domain not found",
		"church":                   "Domain not found",
		"city":                     "Domain not found",
		"claims":                   "Domain not found",
		"cleaning":                 "Domain not found",
		"clinic":                   "Domain not found",
		"clothing":                 "Domain not found",
		"coach":                    "Domain not found",
		"codes":                    "Domain not found",
		"coffee":                   "Domain not found",
		"community":                "Domain not found",
		"company":                  "Domain not found",
		"computer":                 "Domain not found",
		"condos":                   "Domain not found",
		"construction":             "Domain not found",
		"consulting":               "Domain not found",
		"contractors":              "Domain not found",
		"cool":                     "Domain not found",
		"coupons":                  "Domain not found",
		"credit":                   "Domain not found",
		"creditcard":               "Domain not found",
		"cruises":                  "Domain not found",
		"dad":                      "Domain not found",
		"dance":                    "Domain not found",
		"dating":                   "Domain not found",
		"day":                      "Domain not found",
		"dclk":                     "Domain not found",
		"deals":                    "Domain not found",
		"degree":                   "Domain not found",
		"delivery":                 "Domain not found",
		"democrat":                 "Domain not found",
		"dental":                   "Domain not found",
		"dentist":                  "Domain not found",
		"dev":                      "Domain not found",
		"diamonds":                 "Domain not found",
		"digital":                  "Domain not found",
		"direct":                   "Domain not found",
		"directory":                "Domain not found",
		"discount":                 "Domain not found",
		"docs":                     "Domain not found",
		"dog":                      "Domain not found",
		"domains":                  "Domain not found",
		"drive":                    "Domain not found",
		"eat":                      "Domain not found",
		"education":                "Domain not found",
		"ee":                       "Domain not found",
		"email":                    "Domain not found",
		"energy":                   "Domain not found",
		"engineer":                 "Domain not found",
		"engineering":              "Domain not found",
		"enterprises":              "Domain not found",
		"equipment":                "Domain not found",
		"esq":                      "Domain not found",
		"estate":                   "Domain not found",
		"events":                   "Domain not found",
		"exchange":                 "Domain not found",
		"expert":                   "Domain not found",
		"exposed":                  "Domain not found",
		"express":                  "Domain not found",
		"fail":                     "Domain not found",
		"family":                   "Domain not found",
		"farm":                     "Domain not found",
		"fi":                       "Domain not found",
		"finance":                  "Domain not found",
		"financial":                "Domain not found",
		"firmdale":                 "Domain not found",
		"fish":                     "Domain not found",
		"fitness":                  "Domain not found",
		"flights":                  "Domain not found",
		"florist":                  "Domain not found",
		"fly":                      "Domain not found",
		"foo":                      "Domain not found",
		"football":                 "Domain not found",
		"forsale":                  "Domain not found",
		"foundation":               "Domain not found",
		"fund":                     "Domain not found",
		"furniture":                "Domain not found",
		"futbol":                   "Domain not found",
		"fyi":                      "Domain not found",
		"gallery":                  "Domain not found",
		"gbiz":                     "Domain not found",
		"gdn":                      "Domain not found",
		"gifts":                    "Domain not found",
		"gives":                    "Domain not found",
		"glass":                    "Domain not found",
		"gle":                      "Domain not found",
		"gmail":                    "Domain not found",
		"gold":                     "Domain not found",
		"golf":                     "Domain not found",
		"goog":                     "Domain not found",
		"google":                   "Domain not found",
		"graphics":                 "Domain not found",
		"gratis":                   "Domain not found",
		"gripe":                    "Domain not found",
		"group":                    "Domain not found",
		"guge":                     "Domain not found",
		"guide":                    "Domain not found",
		"guru":                     "Domain not found",
		"hangout":                  "Domain not found",
		"haus":                     "Domain not found",
		"healthcare":               "Domain not found",
		"here":                     "Domain not found",
		"hockey":                   "Domain not found",
		"holdings":                 "Domain not found",
		"holiday":                  "Domain not found",
		"house":                    "Domain not found",
		"how":                      "Domain not found",
		"id":                       "Domain not found",
		"immo":                     "Domain not found",
		"immobilien":               "Domain not found",
		"industries":               "Domain not found",
		"ing":                      "Domain not found",
		"institute":                "Domain not found",
		"insure":                   "Domain not found",
		"international":            "Domain not found",
		"investments":              "Domain not found",
		"irish":                    "Domain not found",
		"jetzt":                    "Domain not found",
		"jewelry":                  "Domain not found",
		"kaufen":                   "Domain not found",
		"kitchen":                  "Domain not found",
		"land":                     "Domain not found",
		"lawyer":                   "Domain not found",
		"lease":                    "Domain not found",
		"legal":                    "Domain not found",
		"life":                     "Domain not found",
		"lighting":                 "Domain not found",
		"limited":                  "Domain not found",
		"limo":                     "Domain not found",
		"live":                     "Domain not found",
		"loans":                    "Domain not found",
		"ltd":                      "Domain not found",
		"maison":                   "Domain not found",
		"management":               "Domain not found",
		"market":                   "Domain not found",
		"marketing":                "Domain not found",
		"mba":                      "Domain not found",
		"media":                    "Domain not found",
		"meet":                     "Domain not found",
		"meme":                     "Domain not found",
		"memorial":                 "Domain not found",
		"moda":                     "Domain not found",
		"money":                    "Domain not found",
		"mortgage":                 "Domain not found",
		"moscow":                   "Domain not found",
		"mov":                      "Domain not found",
		"movie":                    "Domain not found",
		"navy":                     "Domain not found",
		"network":                  "Domain not found",
		"new":                      "Domain not found",
		"news":                     "Domain not found",
		"nexus":                    "Domain not found",
		"ninja":                    "Domain not found",
		"page":                     "Domain not found",
		"partners":                 "Domain not found",
		"parts":                    "Domain not found",
		"photography":              "Domain not found",
		"photos":                   "Domain not found",
		"pictures":                 "Domain not found",
		"pizza":                    "Domain not found",
		"place":                    "Domain not found",
		"play":                     "Domain not found",
		"plumbing":                 "Domain not found",
		"plus":                     "Domain not found",
		"prod":                     "Domain not found",
		"productions":              "Domain not found",
		"prof":                     "Domain not found",
		"properties":               "Domain not found",
		"pub":                      "Domain not found",
		"recipes":                  "Domain not found",
		"rehab":                    "Domain not found",
		"reise":                    "Domain not found",
		"reisen":                   "Domain not found",
		"rentals":                  "Domain not found",
		"repair":                   "Domain not found",
		"report":                   "Domain not found",
		"republican":               "Domain not found",
		"restaurant":               "Domain not found",
		"reviews":                  "Domain not found",
		"rip":                      "Domain not found",
		"rocks":                    "Domain not found",
		"rsvp":                     "Domain not found",
		"run":                      "Domain not found",
		"sale":                     "Domain not found",
		"salon":                    "Domain not found",
		"samsung":                  "Domain not found",
		"sarl":                     "Domain not found",
		"school":                   "Domain not found",
		"schule":                   "Domain not found",
		"services":                 "Domain not found",
		"sg":                       "Domain not found",
		"shoes":                    "Domain not found",
		"show":                     "Domain not found",
		"singles":                  "Domain not found",
		"sk":                       "Domain not found",
		"soccer":                   "Domain not found",
		"social":                   "Domain not found",
		"software":                 "Domain not found",
		"solar":                    "Domain not found",
		"solutions":                "Domain not found",
		"soy":                      "Domain not found",
		"studio":                   "Domain not found",
		"style":                    "Domain not found",
		"supplies":                 "Domain not found",
		"supply":                   "Domain not found",
		"support":                  "Domain not found",
		"surgery":                  "Domain not found",
		"systems":                  "Domain not found",
		"tax":                      "Domain not found",
		"taxi":                     "Domain not found",
		"team":                     "Domain not found",
		"technology":               "Domain not found",
		"tennis":                   "Domain not found",
		"theater":                  "Domain not found",
		"tienda":                   "Domain not found",
		"tips":                     "Domain not found",
		"tires":                    "Domain not found",
		"today":                    "Domain not found",
		"tools":                    "Domain not found",
		"tours":                    "Domain not found",
		"town":                     "Domain not found",
		"toys":                     "Domain not found",
		"training":                 "Domain not found",
		"university":               "Domain not found",
		"vacations":                "Domain not found",
		"ventures":                 "Domain not found",
		"vet":                      "Domain not found",
		"viajes":                   "Domain not found",
		"video":                    "Domain not found",
		"villas":                   "Domain not found",
		"vin":                      "Domain not found",
		"vision":                   "Domain not found",
		"voyage":                   "Domain not found",
		"watch":                    "Domain not found",
		"wine":                     "Domain not found",
		"works":                    "Domain not found",
		"world":                    "Domain not found",
		"wtf":                      "Domain not found",
		"xn--80adxhks":             "Domain not found",
		"xn--cg4bki":               "Domain not found",
		"xn--clchc0ea0b2g2a9gcd":   "Domain not found",
		"xn--czrs0t":               "Domain not found",
		"xn--fjq720a":              "Domain not found",
		"xn--flw351e":              "Domain not found",
		"xn--q9jyb4c":              "Domain not found",
		"xn--qcka1pmc":             "Domain not found",
		"xn--unup4y":               "Domain not found",
		"xn--vhquv":                "Domain not found",
		"xn--yfro4i67o":            "Domain not found",
		"youtube":                  "Domain not found",
		"zip":                      "Domain not found",
		"zone":                     "Domain not found",
		"iq":                       "Domain Status: No Object Found",
		"cx":                       "Domain Status: No Object Found",
		"tc":                       "Domain Status: No Object Found",
		"gy":                       "Domain Status: No Object Found",
		"ke":                       "Domain Status: No Object Found",
		"mu":                       "Domain Status: No Object Found",
		"mg":                       "Domain Status: No Object Found",
		"ht":                       "Domain Status: No Object Found",
		"mz":                       "Domain Status: No Object Found",
		"zm":                       "Domain Status: No Object Found",
		"hn":                       "Domain Status: No Object Found",
		"bi":                       "Domain Status: No Object Found",
		"ci":                       "Domain Status: No Object Found",
		"nowruz":                   "Domain Status: No Object Found",
		"na":                       "Domain Status: No Object Found",
		"xn--ygbi2ammx":            "Domain Status: No Object Found",
		"gs":                       "Domain Status: No Object Found",
		"sl":                       "Domain Status: No Object Found",
		"sb":                       "Domain Status: No Object Found",
		"gl":                       "Domain Status: No Object Found",
		"rw":                       "Domain Status: No Object Found",
		"tl":                       "Domain Status: No Object Found",
		"xn--mgbtx2b":              "Domain Status: No Object Found",
		"xn--p1acf":                "Domain Status: No Object Found",
		"ki":                       "Domain Status: No Object Found",
		"sy":                       "Domain Status: No Object Found",
		"nf":                       "Domain Status: No Object Found",
		"bj":                       "Domain Status: No Object Found",
		"shia":                     "Domain Status: No Object Found",
		"tci":                      "Domain Status: No Object Found",
		"bw":                       "Domain Status: No Object Found",
		"pe":                       "Domain Status: No Object Found",
		"ps":                       "Domain Status: No Object Found",
		"ng":                       "Domain Status: No Object Found",
		"xn--ogbpf8fl":             "Domain Status: No Object Found",
		"ma":                       "Domain Status: No Object Found",
		"ms":                       "Domain Status: No Object Found",
		"af":                       "Domain Status: No Object Found",
		"aarp":                     "No match for",
		"abb":                      "No match for",
		"accenture":                "No match for",
		"aeg":                      "No match for",
		"airtel":                   "No match for",
		"arte":                     "No match for",
		"azure":                    "No match for",
		"bank":                     "No match for",
		"bbva":                     "No match for",
		"bharti":                   "No match for",
		"bing":                     "No match for",
		"bloomberg":                "No match for",
		"bms":                      "No match for",
		"br":                       "No match for",
		"broker":                   "No match for",
		"career":                   "No match for",
		"cc":                       "No match for",
		"cfa":                      "No match for",
		"cfd":                      "No match for",
		"chanel":                   "No match for",
		"cityeats":                 "No match for",
		"clubmed":                  "No match for",
		"com":                      "No match for",
		"comsec":                   "No match for",
		"crown":                    "No match for",
		"crs":                      "No match for",
		"csc":                      "No match for",
		"fairwinds":                "No match for",
		"forex":                    "No match for",
		"genting":                  "No match for",
		"gov":                      "No match for",
		"hotmail":                  "No match for",
		"ice":                      "No match for",
		"insurance":                "No match for",
		"jaguar":                   "No match for",
		"java":                     "No match for",
		"landrover":                "No match for",
		"liaison":                  "No match for",
		"lifestyle":                "No match for",
		"linde":                    "No match for",
		"lupin":                    "No match for",
		"maif":                     "No match for",
		"markets":                  "No match for",
		"med":                      "No match for",
		"microsoft":                "No match for",
		"nadex":                    "No match for",
		"name":                     "No match for",
		"net":                      "No match for",
		"norton":                   "No match for",
		"obi":                      "No match for",
		"omega":                    "No match for",
		"oracle":                   "No match for",
		"orange":                   "No match for",
		"pictet":                   "No match for",
		"realtor":                  "No match for",
		"rwe":                      "No match for",
		"sanofi":                   "No match for",
		"sbs":                      "No match for",
		"sca":                      "No match for",
		"sener":                    "No match for",
		"sky":                      "No match for",
		"spreadbetting":            "No match for",
		"statoil":                  "No match for",
		"swatch":                   "No match for",
		"symantec":                 "No match for",
		"tatamotors":               "No match for",
		"th":                       "No match for",
		"to":                       "No match for",
		"trading":                  "No match for",
		"tv":                       "No match for",
		"ubs":                      "No match for",
		"uy":                       "No match for",
		"vana":                     "No match for",
		"ve":                       "No match for",
		"verisign":                 "No match for",
		"weir":                     "No match for",
		"windows":                  "No match for",
		"xbox":                     "No match for",
		"xerox":                    "No match for",
		"xn--11b4c3d":              "No match for",
		"xn--3pxu8k":               "No match for",
		"xn--42c2d9a":              "No match for",
		"xn--9dbq2a":               "No match for",
		"xn--c2br7g":               "No match for",
		"xn--fhbei":                "No match for",
		"xn--j1aef":                "No match for",
		"xn--j1amh":                "No match for",
		"xn--mk1bu44c":             "No match for",
		"xn--o3cw4h":               "No match for",
		"xn--pssy2u":               "No match for",
		"xn--t60b56a":              "No match for",
		"xn--tckwe":                "No match for",
		"xperia":                   "No match for",
		"cr":                       "No entries found",
		"cz":                       "No entries found",
		"dk":                       "No entries found",
		"fr":                       "No entries found",
		"hr":                       "No entries found",
		"ir":                       "No entries found",
		"is":                       "No entries found",
		"mk":                       "No entries found",
		"nc":                       "No entries found",
		"pm":                       "No entries found",
		"re":                       "No entries found",
		"ro":                       "No entries found",
		"ru":                       "No entries found",
		"si":                       "No entries found",
		"sm":                       "No entries found",
		"st":                       "No entries found",
		"su":                       "No entries found",
		"tf":                       "No entries found",
		"tz":                       "No entries found",
		"ua":                       "No entries found",
		"wf":                       "No entries found",
		"xn--d1alf":                "No entries found",
		"xn--mgba3a4f16a":          "No entries found",
		"xn--p1ai":                 "No entries found",
		"yt":                       "No entries found",
		"aaa":                      "No Data Found",
		"accountant":               "No Data Found",
		"ae":                       "No Data Found",
		"afl":                      "No Data Found",
		"aig":                      "No Data Found",
		"amica":                    "No Data Found",
		"aramco":                   "No Data Found",
		"au":                       "No Data Found",
		"author":                   "No Data Found",
		"axa":                      "No Data Found",
		"barclaycard":              "No Data Found",
		"barclays":                 "No Data Found",
		"bible":                    "No Data Found",
		"bid":                      "No Data Found",
		"biz":                      "No Data Found",
		"bond":                     "No Data Found",
		"book":                     "No Data Found",
		"bot":                      "No Data Found",
		"build":                    "No Data Found",
		"buy":                      "No Data Found",
		"buzz":                     "No Data Found",
		"call":                     "No Data Found",
		"cancerresearch":           "No Data Found",
		"caravan":                  "No Data Found",
		"cartier":                  "No Data Found",
		"cba":                      "No Data Found",
		"cbn":                      "No Data Found",
		"circle":                   "No Data Found",
		"cisco":                    "No Data Found",
		"cloud":                    "No Data Found",
		"club":                     "No Data Found",
		"co":                       "No Data Found",
		"commbank":                 "No Data Found",
		"courses":                  "No Data Found",
		"cricket":                  "No Data Found",
		"cuisinella":               "No Data Found",
		"date":                     "No Data Found",
		"dell":                     "No Data Found",
		"doha":                     "No Data Found",
		"download":                 "No Data Found",
		"earth":                    "No Data Found",
		"everbank":                 "No Data Found",
		"faith":                    "No Data Found",
		"fast":                     "No Data Found",
		"ferrero":                  "No Data Found",
		"film":                     "No Data Found",
		"giving":                   "No Data Found",
		"got":                      "No Data Found",
		"grainger":                 "No Data Found",
		"gucci":                    "No Data Found",
		"hoteles":                  "No Data Found",
		"hsbc":                     "No Data Found",
		"ibm":                      "No Data Found",
		"ipiranga":                 "No Data Found",
		"itau":                     "No Data Found",
		"iwc":                      "No Data Found",
		"jlc":                      "No Data Found",
		"jot":                      "No Data Found",
		"joy":                      "No Data Found",
		"kinder":                   "No Data Found",
		"krd":                      "No Data Found",
		"latrobe":                  "No Data Found",
		"like":                     "No Data Found",
		"loan":                     "No Data Found",
		"luxury":                   "No Data Found",
		"melbourne":                "No Data Found",
		"men":                      "No Data Found",
		"menu":                     "No Data Found",
		"moe":                      "No Data Found",
		"moi":                      "No Data Found",
		"monash":                   "No Data Found",
		"mtn":                      "No Data Found",
		"netbank":                  "No Data Found",
		"neustar":                  "No Data Found",
		"nyc":                      "No Data Found",
		"office":                   "No Data Found",
		"om":                       "No Data Found",
		"one":                      "No Data Found",
		"osaka":                    "No Data Found",
		"panerai":                  "No Data Found",
		"party":                    "No Data Found",
		"pharmacy":                 "No Data Found",
		"philips":                  "No Data Found",
		"physio":                   "No Data Found",
		"piaget":                   "No Data Found",
		"pin":                      "No Data Found",
		"ping":                     "No Data Found",
		"praxi":                    "No Data Found",
		"qa":                       "No Data Found",
		"qpon":                     "No Data Found",
		"racing":                   "No Data Found",
		"read":                     "No Data Found",
		"review":                   "No Data Found",
		"rocher":                   "No Data Found",
		"room":                     "No Data Found",
		"safe":                     "No Data Found",
		"sandvik":                  "No Data Found",
		"sandvikcoromant":          "No Data Found",
		"saxo":                     "No Data Found",
		"schmidt":                  "No Data Found",
		"xn--mgb9awbf":             "No Data Found",
		"xn--mgbaam7a8h":           "No Data Found",
		"xn--wgbl6a":               "No Data Found",
		"aw":                       "is free",
		"nl":                       "is free",
		"at":                       "nothing found",
		"kz":                       "Nothing found for this query",
		"xn--80ao21a":              "Nothing found for this query",
		"int":                      "but this server does not have",
		"arpa":                     "but this server does not have",
		"amsterdam":                "Domain Status: free",
		"abbott":                   "NOT FOUND",
		"ac":                       "NOT FOUND",
		"aco":                      "NOT FOUND",
		"active":                   "NOT FOUND",
		"adult":                    "NOT FOUND",
		"aero":                     "NOT FOUND",
		"ag":                       "NOT FOUND",
		"apple":                    "NOT FOUND",
		"archi":                    "NOT FOUND",
		"as":                       "NOT FOUND",
		"asia":                     "NOT FOUND",
		"audi":                     "NOT FOUND",
		"autos":                    "NOT FOUND",
		"beats":                    "NOT FOUND",
		"bet":                      "NOT FOUND",
		"bio":                      "NOT FOUND",
		"black":                    "NOT FOUND",
		"blue":                     "NOT FOUND",
		"bnl":                      "NOT FOUND",
		"bnpparibas":               "NOT FOUND",
		"boats":                    "NOT FOUND",
		"boehringer":               "NOT FOUND",
		"bugatti":                  "NOT FOUND",
		"bz":                       "NOT FOUND",
		"ceb":                      "NOT FOUND",
		"cern":                     "NOT FOUND",
		"cipriani":                 "NOT FOUND",
		"creditunion":              "NOT FOUND",
		"cyou":                     "NOT FOUND",
		"dabur":                    "NOT FOUND",
		"delta":                    "NOT FOUND",
		"emerck":                   "NOT FOUND",
		"fage":                     "NOT FOUND",
		"gea":                      "NOT FOUND",
		"gg":                       "NOT FOUND",
		"gi":                       "NOT FOUND",
		"global":                   "NOT FOUND",
		"green":                    "NOT FOUND",
		"hermes":                   "NOT FOUND",
		"homedepot":                "NOT FOUND",
		"homes":                    "NOT FOUND",
		"icbc":                     "NOT FOUND",
		"in":                       "NOT FOUND",
		"info":                     "NOT FOUND",
		"io":                       "NOT FOUND",
		"ist":                      "NOT FOUND",
		"istanbul":                 "NOT FOUND",
		"je":                       "NOT FOUND",
		"jll":                      "NOT FOUND",
		"kim":                      "NOT FOUND",
		"lamborghini":              "NOT FOUND",
		"lasalle":                  "NOT FOUND",
		"lc":                       "NOT FOUND",
		"lds":                      "NOT FOUND",
		"lgbt":                     "NOT FOUND",
		"lotto":                    "NOT FOUND",
		"ltda":                     "NOT FOUND",
		"marriott":                 "NOT FOUND",
		"me":                       "NOT FOUND",
		"mn":                       "NOT FOUND",
		"mobi":                     "NOT FOUND",
		"mormon":                   "NOT FOUND",
		"motorcycles":              "NOT FOUND",
		"ngo":                      "NOT FOUND",
		"nokia":                    "NOT FOUND",
		"nra":                      "NOT FOUND",
		"ong":                      "NOT FOUND",
		"onl":                      "NOT FOUND",
		"org":                      "NOT FOUND",
		"organic":                  "NOT FOUND",
		"pet":                      "NOT FOUND",
		"pink":                     "NOT FOUND",
		"poker":                    "NOT FOUND",
		"porn":                     "NOT FOUND",
		"post":                     "NOT FOUND",
		"pr":                       "NOT FOUND",
		"red":                      "NOT FOUND",
		"redstone":                 "NOT FOUND",
		"rich":                     "NOT FOUND",
		"sc":                       "NOT FOUND",
		"scb":                      "NOT FOUND",
		"scholarships":             "NOT FOUND",
		"sew":                      "NOT FOUND",
		"sex":                      "NOT FOUND",
		"sh":                       "NOT FOUND",
		"shiksha":                  "NOT FOUND",
		"shriram":                  "NOT FOUND",
		"ski":                      "NOT FOUND",
		"srl":                      "NOT FOUND",
		"stada":                    "NOT FOUND",
		"stockholm":                "NOT FOUND",
		"temasek":                  "NOT FOUND",
		"thd":                      "NOT FOUND",
		"travelers":                "NOT FOUND",
		"vc":                       "NOT FOUND",
		"vegas":                    "NOT FOUND",
		"vote":                     "NOT FOUND",
		"voto":                     "NOT FOUND",
		"xin":                      "NOT FOUND",
		"xn--45brj9c":              "NOT FOUND",
		"xn--4gbrim":               "NOT FOUND",
		"xn--6frz82g":              "NOT FOUND",
		"xn--b4w605ferd":           "NOT FOUND",
		"xn--c1avg":                "NOT FOUND",
		"xn--estv75g":              "NOT FOUND",
		"xn--fpcrj9c3d":            "NOT FOUND",
		"xn--gecrj9c":              "NOT FOUND",
		"xn--h2brj9c":              "NOT FOUND",
		"xn--i1b6b1a6a2e":          "NOT FOUND",
		"xn--kput3i":               "NOT FOUND",
		"xn--mgbbh1a71e":           "NOT FOUND",
		"xn--nqv7f":                "NOT FOUND",
		"xn--nqv7fs00ema":          "NOT FOUND",
		"xn--s9brj9c":              "NOT FOUND",
		"xn--xkc2dl3a5ee0h":        "NOT FOUND",
		"xxx":                      "NOT FOUND",
		"yachts":                   "NOT FOUND",
		"zara":                     "NOT FOUND",
		"kr":                       "The requested domain was not found in the Registry",
		"ly":                       "Not found",
		"vg":                       "not found",
		"gd":                       "not found",
		"xn--mxtq1m":               "Not Found",
		"nu":                       "not found",
		"se":                       "not found",
		"so":                       "Not found",
		"kiwi":                     "Not found",
		"uz":                       "not found in database",
		"fj":                       "was not found",
		"im":                       "was not found",
		"dm":                       "not found",
		"xn--3ds443g":              "No matching record",
		"am":                       "No match",
		"no":                       "No match",
		"cn":                       "No matching record",
		"jp":                       "No match",
		"xn--fiqz9s":               "No matching record",
		"xn--fiq228c5hs":           "No matching record",
		"hu":                       "No match",
		"edu":                      "NO MATCH",
		"xn--vuq861b":              "No matching record",
		"xn--fiqs8s":               "No matching record",
		"ax":                       "Invalid domain name",
		"xn--90a3ac":               "Invalid domain name",
		"be":                       "Status:	AVAILABLE",
		"it":                       "AVAILABLE",
		"by":                       "Object does not exist",
		"nz":                       "220 Available",
		"wien":                     "Available",
		"capetown":                 "Available",
		"durban":                   "Available",
		"joburg":                   "Available",
		"tm":                       "available for purchase",
		"pl":                       "No information available about domain name",
		"cf":                       "Invalid query or domain name not known",
		"cl":                       "no entries found",
		"ie":                       "Not Registered",
		"xn--wgbh1c":               "Not Registered",
		"rs":                       "not registered",
		"cm":                       "Not Registered",
		"lv":                       "Status: free",
		"de":                       "Status: free",
		"dz":                       "NO OBJECT FOUND",
		"eu":                       "Status: AVAILABLE",
		"hk":                       "The domain has not been registered.",
		"xn--j6w193g":              "The domain has not been registered.",
		"mtr":                      "The domain has not been registered.",
		"il":                       "No data was found to match the request criteria",
		"lk":                       "This is not a Registered Domain under LK Domain Registry",
		"lu":                       "No such domain",
		"md":                       "No match",
		"mx":                       "Object_Not_Found",
		"tn":                       "NO OBJECT FOUND",
		"tw":                       "No Found",
		"xn--55qw42g":              "Not find MatchingRecord",
		"xn--fzc2c9e2c":            "This is not a Registered Domain under LK Domain Registry",
		"xn-xkc2al3hye2a":          "This is not a Registered Domain under LK Domain Registry",
		"ga":                       "Invalid query or domain name not known in My GA Domain Registry",
		"gq":                       "Invalid query or domain name not known in Dominio GQ Domain Registry",
		"jobs":                     "Name or service not known",
		"playstation":              "DOMAIN NOT FOUND",
		"pro":                      "Name or service not known",
		"sa":                       "Error.",
		"science":                  "No Data Found",
		"scor":                     "No Data Found",
		"seek":                     "No Data Found",
		"seven":                    "No Data Found",
		"skype":                    "No Data Found",
		"smile":                    "No Data Found",
		"sn":                       "NO OBJECT FOUND",
		"starhub":                  "No Data Found",
		"study":                    "No Data Found",
		"sucks":                    "No Data Found",
		"sx":                       "Temporary failure in name resolution",
		"sydney":                   "No Data Found",
		"tab":                      "No Data Found",
		"taipei":                   "No Data Found",
		"tel":                      "No Data Found",
		"tg":                       "NO OBJECT FOUND",
		"xn--node":                 "NO OBJECT FOUND",
		"tk":                       "Invalid query or domain name not known in Dot TK Domain Registry",
		"xn--nyqy26a":              "No Data Found",
		"uno":                      "No Data Found",
		"xn--mgba3a3ejt":           "No Data Found",
		"travel":                   "No Data Found",
		"wtc":                      "No Data Found",
		"xn--rhqv96g":              "No Data Found",
		"williamhill":              "No Data Found",
		"vistaprint":               "No Data Found",
		"trust":                    "No Data Found",
		"us":                       "No Data Found",
		"yandex":                   "No Data Found",
		"yamaxun":                  "No Data Found",
		"vista":                    "No Data Found",
		"walter":                   "No Data Found",
		"webcam":                   "No Data Found",
		"whoswho":                  "No Data Found",
		"xn--ngbc5azd":             "No Data Found",
		"virgin":                   "No Data Found",
		"zero":                     "No Data Found",
		"trade":                    "No Data Found",
		"xn--kcrx77d1x4a":          "No Data Found",
		"win":                      "No Data Found",
		"tr":                       "Invalid input",
		"xn--mgberp4a5d4ar":        "Error.",
		"xn--zfr164b":              "Not find MatchingRecord",
		"ca":                       "unavailable", // Opposite
		"lt":                       "registered",  // Opposite
	}

	return fprints
}

// List of all possible "available" responses.
func all_fingerprints() []string {
	fprints := []string{
		"220 available",
		"available for purchase",
		"but this server does not have",
		"domain not found",
		"domain status: free",
		"error.",
		"invalid domain name",
		"invalid input",
		"invalid query or domain not known",
		"is available for registration",
		"is free",
		"name or service not known",
		"no data found",
		"no data was found",
		"no entries found",
		"no found",
		"no information available about domain name",
		"no match",
		"no matching record",
		"no object found",
		"no such domain",
		"not find matchingrecord",
		"not found",
		"nothing found",
		"not registered",
		"object does not exist",
		"object_not_found",
		"status: available",
		"status: free",
		"temporary failure in name resolution",
		"the domain has not been registered",
		"the queried object does not exist",
		"the requested domain was not found in the registry",
		"this domain name has not been registered",
		"this is not a registered domain",
		"was not found",
	}

	return fprints
}
