// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAcceptMatch = "AcceptMatch"

// AcceptMatchRequest generates a "aws/request.Request" representing the
// client's request for the AcceptMatch operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptMatch for more information on using the AcceptMatch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AcceptMatchRequest method.
//	req, resp := client.AcceptMatchRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/AcceptMatch
func (c *GameLift) AcceptMatchRequest(input *AcceptMatchInput) (req *request.Request, output *AcceptMatchOutput) {
	op := &request.Operation{
		Name:       opAcceptMatch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcceptMatchInput{}
	}

	output = &AcceptMatchOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AcceptMatch API operation for Amazon GameLift.
//
// Registers a player's acceptance or rejection of a proposed FlexMatch match.
// A matchmaking configuration may require player acceptance; if so, then matches
// built with that configuration cannot be completed unless all players accept
// the proposed match within a specified time limit.
//
// When FlexMatch builds a match, all the matchmaking tickets involved in the
// proposed match are placed into status REQUIRES_ACCEPTANCE. This is a trigger
// for your game to get acceptance from all players in each ticket. Calls to
// this action are only valid for tickets that are in this status; calls for
// tickets not in this status result in an error.
//
// To register acceptance, specify the ticket ID, one or more players, and an
// acceptance response. When all players have accepted, Amazon GameLift advances
// the matchmaking tickets to status PLACING, and attempts to create a new game
// session for the match.
//
// If any player rejects the match, or if acceptances are not received before
// a specified timeout, the proposed match is dropped. Each matchmaking ticket
// in the failed match is handled as follows:
//
//   - If the ticket has one or more players who rejected the match or failed
//     to respond, the ticket status is set CANCELLED and processing is terminated.
//
//   - If all players in the ticket accepted the match, the ticket status is
//     returned to SEARCHING to find a new match.
//
// Learn more
//
//	Add FlexMatch to a game client (https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-client.html)
//
//	FlexMatch events (https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html)
//	(reference)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation AcceptMatch for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - UnsupportedRegionException
//     The requested operation is not supported in the Region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/AcceptMatch
func (c *GameLift) AcceptMatch(input *AcceptMatchInput) (*AcceptMatchOutput, error) {
	req, out := c.AcceptMatchRequest(input)
	return out, req.Send()
}

// AcceptMatchWithContext is the same as AcceptMatch with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptMatch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) AcceptMatchWithContext(ctx aws.Context, input *AcceptMatchInput, opts ...request.Option) (*AcceptMatchOutput, error) {
	req, out := c.AcceptMatchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opClaimGameServer = "ClaimGameServer"

// ClaimGameServerRequest generates a "aws/request.Request" representing the
// client's request for the ClaimGameServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ClaimGameServer for more information on using the ClaimGameServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ClaimGameServerRequest method.
//	req, resp := client.ClaimGameServerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ClaimGameServer
func (c *GameLift) ClaimGameServerRequest(input *ClaimGameServerInput) (req *request.Request, output *ClaimGameServerOutput) {
	op := &request.Operation{
		Name:       opClaimGameServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ClaimGameServerInput{}
	}

	output = &ClaimGameServerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ClaimGameServer API operation for Amazon GameLift.
//
// This operation is used with the Amazon GameLift FleetIQ solution and game
// server groups.
//
// Locates an available game server and temporarily reserves it to host gameplay
// and players. This operation is called from a game client or client service
// (such as a matchmaker) to request hosting resources for a new game session.
// In response, Amazon GameLift FleetIQ locates an available game server, places
// it in CLAIMED status for 60 seconds, and returns connection information that
// players can use to connect to the game server.
//
// To claim a game server, identify a game server group. You can also specify
// a game server ID, although this approach bypasses Amazon GameLift FleetIQ
// placement optimization. Optionally, include game data to pass to the game
// server at the start of a game session, such as a game map or player information.
// Add filter options to further restrict how a game server is chosen, such
// as only allowing game servers on ACTIVE instances to be claimed.
//
// When a game server is successfully claimed, connection information is returned.
// A claimed game server's utilization status remains AVAILABLE while the claim
// status is set to CLAIMED for up to 60 seconds. This time period gives the
// game server time to update its status to UTILIZED after players join. If
// the game server's status is not updated within 60 seconds, the game server
// reverts to unclaimed status and is available to be claimed by another request.
// The claim time period is a fixed value and is not configurable.
//
// If you try to claim a specific game server, this request will fail in the
// following cases:
//
//   - If the game server utilization status is UTILIZED.
//
//   - If the game server claim status is CLAIMED.
//
//   - If the game server is running on an instance in DRAINING status and
//     the provided filter option does not allow placing on DRAINING instances.
//
// # Learn more
//
// Amazon GameLift FleetIQ Guide (https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation ClaimGameServer for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - ConflictException
//     The requested operation would cause a conflict with the current state of
//     a service resource associated with the request. Resolve the conflict before
//     retrying this request.
//
//   - OutOfCapacityException
//     The specified game server group has no available game servers to fulfill
//     a ClaimGameServer request. Clients can retry such requests immediately or
//     after a waiting period.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ClaimGameServer
func (c *GameLift) ClaimGameServer(input *ClaimGameServerInput) (*ClaimGameServerOutput, error) {
	req, out := c.ClaimGameServerRequest(input)
	return out, req.Send()
}

// ClaimGameServerWithContext is the same as ClaimGameServer with the addition of
// the ability to pass a context and additional request options.
//
// See ClaimGameServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) ClaimGameServerWithContext(ctx aws.Context, input *ClaimGameServerInput, opts ...request.Option) (*ClaimGameServerOutput, error) {
	req, out := c.ClaimGameServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAlias = "CreateAlias"

// CreateAliasRequest generates a "aws/request.Request" representing the
// client's request for the CreateAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAlias for more information on using the CreateAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAliasRequest method.
//	req, resp := client.CreateAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateAlias
func (c *GameLift) CreateAliasRequest(input *CreateAliasInput) (req *request.Request, output *CreateAliasOutput) {
	op := &request.Operation{
		Name:       opCreateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAliasInput{}
	}

	output = &CreateAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAlias API operation for Amazon GameLift.
//
// Creates an alias for a fleet. In most situations, you can use an alias ID
// in place of a fleet ID. An alias provides a level of abstraction for a fleet
// that is useful when redirecting player traffic from one fleet to another,
// such as when updating your game build.
//
// Amazon GameLift supports two types of routing strategies for aliases: simple
// and terminal. A simple alias points to an active fleet. A terminal alias
// is used to display messaging or link to a URL instead of routing players
// to an active fleet. For example, you might use a terminal alias when a game
// version is no longer supported and you want to direct players to an upgrade
// site.
//
// To create a fleet alias, specify an alias name, routing strategy, and optional
// description. Each simple alias can point to only one fleet, but a fleet can
// have multiple aliases. If successful, a new alias record is returned, including
// an alias ID and an ARN. You can reassign an alias to another fleet by calling
// UpdateAlias.
//
// # Related actions
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation CreateAlias for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - ConflictException
//     The requested operation would cause a conflict with the current state of
//     a service resource associated with the request. Resolve the conflict before
//     retrying this request.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - LimitExceededException
//     The requested operation would cause the resource to exceed the allowed service
//     limit. Resolve the issue before retrying.
//
//   - TaggingFailedException
//     The requested tagging operation did not succeed. This may be due to invalid
//     tag format or the maximum tag limit may have been exceeded. Resolve the issue
//     before retrying.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateAlias
func (c *GameLift) CreateAlias(input *CreateAliasInput) (*CreateAliasOutput, error) {
	req, out := c.CreateAliasRequest(input)
	return out, req.Send()
}

// CreateAliasWithContext is the same as CreateAlias with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) CreateAliasWithContext(ctx aws.Context, input *CreateAliasInput, opts ...request.Option) (*CreateAliasOutput, error) {
	req, out := c.CreateAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBuild = "CreateBuild"

// CreateBuildRequest generates a "aws/request.Request" representing the
// client's request for the CreateBuild operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBuild for more information on using the CreateBuild
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateBuildRequest method.
//	req, resp := client.CreateBuildRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateBuild
func (c *GameLift) CreateBuildRequest(input *CreateBuildInput) (req *request.Request, output *CreateBuildOutput) {
	op := &request.Operation{
		Name:       opCreateBuild,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateBuildInput{}
	}

	output = &CreateBuildOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBuild API operation for Amazon GameLift.
//
// Creates a new Amazon GameLift build resource for your game server binary
// files. Combine game server binaries into a zip file for use with Amazon GameLift.
//
// When setting up a new game build for Amazon GameLift, we recommend using
// the CLI command upload-build (https://docs.aws.amazon.com/cli/latest/reference/gamelift/upload-build.html)
// . This helper command combines two tasks: (1) it uploads your build files
// from a file directory to an Amazon GameLift Amazon S3 location, and (2) it
// creates a new build resource.
//
// You can use the CreateBuild operation in the following scenarios:
//
//   - Create a new game build with build files that are in an Amazon S3 location
//     under an Amazon Web Services account that you control. To use this option,
//     you give Amazon GameLift access to the Amazon S3 bucket. With permissions
//     in place, specify a build name, operating system, and the Amazon S3 storage
//     location of your game build.
//
//   - Upload your build files to a Amazon GameLift Amazon S3 location. To
//     use this option, specify a build name and operating system. This operation
//     creates a new build resource and also returns an Amazon S3 location with
//     temporary access credentials. Use the credentials to manually upload your
//     build files to the specified Amazon S3 location. For more information,
//     see Uploading Objects (https://docs.aws.amazon.com/AmazonS3/latest/dev/UploadingObjects.html)
//     in the Amazon S3 Developer Guide. After you upload build files to the
//     Amazon GameLift Amazon S3 location, you can't update them.
//
// If successful, this operation creates a new build resource with a unique
// build ID and places it in INITIALIZED status. A build must be in READY status
// before you can create fleets with it.
//
// # Learn more
//
// Uploading Your Game (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html)
//
//	Create a Build with Files in Amazon S3 (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-cli-uploading.html#gamelift-build-cli-uploading-create-build)
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation CreateBuild for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - ConflictException
//     The requested operation would cause a conflict with the current state of
//     a service resource associated with the request. Resolve the conflict before
//     retrying this request.
//
//   - TaggingFailedException
//     The requested tagging operation did not succeed. This may be due to invalid
//     tag format or the maximum tag limit may have been exceeded. Resolve the issue
//     before retrying.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateBuild
func (c *GameLift) CreateBuild(input *CreateBuildInput) (*CreateBuildOutput, error) {
	req, out := c.CreateBuildRequest(input)
	return out, req.Send()
}

// CreateBuildWithContext is the same as CreateBuild with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBuild for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) CreateBuildWithContext(ctx aws.Context, input *CreateBuildInput, opts ...request.Option) (*CreateBuildOutput, error) {
	req, out := c.CreateBuildRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFleet = "CreateFleet"

// CreateFleetRequest generates a "aws/request.Request" representing the
// client's request for the CreateFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFleet for more information on using the CreateFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateFleetRequest method.
//	req, resp := client.CreateFleetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateFleet
func (c *GameLift) CreateFleetRequest(input *CreateFleetInput) (req *request.Request, output *CreateFleetOutput) {
	op := &request.Operation{
		Name:       opCreateFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFleetInput{}
	}

	output = &CreateFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFleet API operation for Amazon GameLift.
//
// Creates a fleet of Amazon Elastic Compute Cloud (Amazon EC2) instances to
// host your custom game server or Realtime Servers. Use this operation to configure
// the computing resources for your fleet and provide instructions for running
// game servers on each instance.
//
// Most Amazon GameLift fleets can deploy instances to multiple locations, including
// the home Region (where the fleet is created) and an optional set of remote
// locations. Fleets that are created in the following Amazon Web Services Regions
// support multiple locations: us-east-1 (N. Virginia), us-west-2 (Oregon),
// eu-central-1 (Frankfurt), eu-west-1 (Ireland), ap-southeast-2 (Sydney), ap-northeast-1
// (Tokyo), and ap-northeast-2 (Seoul). Fleets that are created in other Amazon
// GameLift Regions can deploy instances in the fleet's home Region only. All
// fleet instances use the same configuration regardless of location; however,
// you can adjust capacity settings and turn auto-scaling on/off for each location.
//
// To create a fleet, choose the hardware for your instances, specify a game
// server build or Realtime script to deploy, and provide a runtime configuration
// to direct Amazon GameLift how to start and run game servers on each instance
// in the fleet. Set permissions for inbound traffic to your game servers, and
// enable optional features as needed. When creating a multi-location fleet,
// provide a list of additional remote locations.
//
// If you need to debug your fleet, fetch logs, view performance metrics or
// other actions on the fleet, create the development fleet with port 22/3389
// open. As a best practice, we recommend opening ports for remote access only
// when you need them and closing them when you're finished.
//
// If successful, this operation creates a new Fleet resource and places it
// in NEW status, which prompts Amazon GameLift to initiate the fleet creation
// workflow (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-all.html#fleets-creation-workflow).
// You can track fleet creation by checking fleet status using DescribeFleetAttributes
// and DescribeFleetLocationAttributes/, or by monitoring fleet creation events
// using DescribeFleetEvents.
//
// When the fleet status changes to ACTIVE, you can enable automatic scaling
// with PutScalingPolicy and set capacity for the home Region with UpdateFleetCapacity.
// When the status of each remote location reaches ACTIVE, you can set capacity
// by location using UpdateFleetCapacity.
//
// # Learn more
//
// Setting up fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
//
// Debug fleet creation issues (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html#fleets-creating-debug-creation)
//
// Multi-location fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation CreateFleet for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - ConflictException
//     The requested operation would cause a conflict with the current state of
//     a service resource associated with the request. Resolve the conflict before
//     retrying this request.
//
//   - LimitExceededException
//     The requested operation would cause the resource to exceed the allowed service
//     limit. Resolve the issue before retrying.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - TaggingFailedException
//     The requested tagging operation did not succeed. This may be due to invalid
//     tag format or the maximum tag limit may have been exceeded. Resolve the issue
//     before retrying.
//
//   - UnsupportedRegionException
//     The requested operation is not supported in the Region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateFleet
func (c *GameLift) CreateFleet(input *CreateFleetInput) (*CreateFleetOutput, error) {
	req, out := c.CreateFleetRequest(input)
	return out, req.Send()
}

// CreateFleetWithContext is the same as CreateFleet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) CreateFleetWithContext(ctx aws.Context, input *CreateFleetInput, opts ...request.Option) (*CreateFleetOutput, error) {
	req, out := c.CreateFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFleetLocations = "CreateFleetLocations"

// CreateFleetLocationsRequest generates a "aws/request.Request" representing the
// client's request for the CreateFleetLocations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFleetLocations for more information on using the CreateFleetLocations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateFleetLocationsRequest method.
//	req, resp := client.CreateFleetLocationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateFleetLocations
func (c *GameLift) CreateFleetLocationsRequest(input *CreateFleetLocationsInput) (req *request.Request, output *CreateFleetLocationsOutput) {
	op := &request.Operation{
		Name:       opCreateFleetLocations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFleetLocationsInput{}
	}

	output = &CreateFleetLocationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFleetLocations API operation for Amazon GameLift.
//
// Adds remote locations to a fleet and begins populating the new locations
// with EC2 instances. The new instances conform to the fleet's instance type,
// auto-scaling, and other configuration settings.
//
// This operation cannot be used with fleets that don't support remote locations.
// Fleets can have multiple locations only if they reside in Amazon Web Services
// Regions that support this feature and were created after the feature was
// released in March 2021.
//
// To add fleet locations, specify the fleet to be updated and provide a list
// of one or more locations.
//
// If successful, this operation returns the list of added locations with their
// status set to NEW. Amazon GameLift initiates the process of starting an instance
// in each added location. You can track the status of each new location by
// monitoring location creation events using DescribeFleetEvents (https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetEvents.html).
//
// # Learn more
//
// Setting up fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
//
// Multi-location fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation CreateFleetLocations for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InvalidFleetStatusException
//     The requested operation would cause a conflict with the current state of
//     a resource associated with the request and/or the fleet. Resolve the conflict
//     before retrying.
//
//   - UnsupportedRegionException
//     The requested operation is not supported in the Region specified.
//
//   - ConflictException
//     The requested operation would cause a conflict with the current state of
//     a service resource associated with the request. Resolve the conflict before
//     retrying this request.
//
//   - LimitExceededException
//     The requested operation would cause the resource to exceed the allowed service
//     limit. Resolve the issue before retrying.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateFleetLocations
func (c *GameLift) CreateFleetLocations(input *CreateFleetLocationsInput) (*CreateFleetLocationsOutput, error) {
	req, out := c.CreateFleetLocationsRequest(input)
	return out, req.Send()
}

// CreateFleetLocationsWithContext is the same as CreateFleetLocations with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFleetLocations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) CreateFleetLocationsWithContext(ctx aws.Context, input *CreateFleetLocationsInput, opts ...request.Option) (*CreateFleetLocationsOutput, error) {
	req, out := c.CreateFleetLocationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGameServerGroup = "CreateGameServerGroup"

// CreateGameServerGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateGameServerGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGameServerGroup for more information on using the CreateGameServerGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateGameServerGroupRequest method.
//	req, resp := client.CreateGameServerGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameServerGroup
func (c *GameLift) CreateGameServerGroupRequest(input *CreateGameServerGroupInput) (req *request.Request, output *CreateGameServerGroupOutput) {
	op := &request.Operation{
		Name:       opCreateGameServerGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateGameServerGroupInput{}
	}

	output = &CreateGameServerGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGameServerGroup API operation for Amazon GameLift.
//
// This operation is used with the Amazon GameLift FleetIQ solution and game
// server groups.
//
// Creates a Amazon GameLift FleetIQ game server group for managing game hosting
// on a collection of Amazon Elastic Compute Cloud instances for game hosting.
// This operation creates the game server group, creates an Auto Scaling group
// in your Amazon Web Services account, and establishes a link between the two
// groups. You can view the status of your game server groups in the Amazon
// GameLift console. Game server group metrics and events are emitted to Amazon
// CloudWatch.
//
// Before creating a new game server group, you must have the following:
//
//   - An Amazon Elastic Compute Cloud launch template that specifies how to
//     launch Amazon Elastic Compute Cloud instances with your game server build.
//     For more information, see Launching an Instance from a Launch Template
//     (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html)
//     in the Amazon Elastic Compute Cloud User Guide.
//
//   - An IAM role that extends limited access to your Amazon Web Services
//     account to allow Amazon GameLift FleetIQ to create and interact with the
//     Auto Scaling group. For more information, see Create IAM roles for cross-service
//     interaction (https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-iam-permissions-roles.html)
//     in the Amazon GameLift FleetIQ Developer Guide.
//
// To create a new game server group, specify a unique group name, IAM role
// and Amazon Elastic Compute Cloud launch template, and provide a list of instance
// types that can be used in the group. You must also set initial maximum and
// minimum limits on the group's instance count. You can optionally set an Auto
// Scaling policy with target tracking based on a Amazon GameLift FleetIQ metric.
//
// Once the game server group and corresponding Auto Scaling group are created,
// you have full access to change the Auto Scaling group's configuration as
// needed. Several properties that are set when creating a game server group,
// including maximum/minimum size and auto-scaling policy settings, must be
// updated directly in the Auto Scaling group. Keep in mind that some Auto Scaling
// group properties are periodically updated by Amazon GameLift FleetIQ as part
// of its balancing activities to optimize for availability and cost.
//
// # Learn more
//
// Amazon GameLift FleetIQ Guide (https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation CreateGameServerGroup for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - ConflictException
//     The requested operation would cause a conflict with the current state of
//     a service resource associated with the request. Resolve the conflict before
//     retrying this request.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - LimitExceededException
//     The requested operation would cause the resource to exceed the allowed service
//     limit. Resolve the issue before retrying.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameServerGroup
func (c *GameLift) CreateGameServerGroup(input *CreateGameServerGroupInput) (*CreateGameServerGroupOutput, error) {
	req, out := c.CreateGameServerGroupRequest(input)
	return out, req.Send()
}

// CreateGameServerGroupWithContext is the same as CreateGameServerGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGameServerGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) CreateGameServerGroupWithContext(ctx aws.Context, input *CreateGameServerGroupInput, opts ...request.Option) (*CreateGameServerGroupOutput, error) {
	req, out := c.CreateGameServerGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGameSession = "CreateGameSession"

// CreateGameSessionRequest generates a "aws/request.Request" representing the
// client's request for the CreateGameSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGameSession for more information on using the CreateGameSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateGameSessionRequest method.
//	req, resp := client.CreateGameSessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameSession
func (c *GameLift) CreateGameSessionRequest(input *CreateGameSessionInput) (req *request.Request, output *CreateGameSessionOutput) {
	op := &request.Operation{
		Name:       opCreateGameSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateGameSessionInput{}
	}

	output = &CreateGameSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGameSession API operation for Amazon GameLift.
//
// Creates a multiplayer game session for players in a specific fleet location.
// This operation prompts an available server process to start a game session
// and retrieves connection information for the new game session. As an alternative,
// consider using the Amazon GameLift game session placement feature with StartGameSessionPlacement
// (https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartGameSessionPlacement.html)
// , which uses the FleetIQ algorithm and queues to optimize the placement process.
//
// When creating a game session, you specify exactly where you want to place
// it and provide a set of game session configuration settings. The target fleet
// must be in ACTIVE status.
//
// You can use this operation in the following ways:
//
//   - To create a game session on an instance in a fleet's home Region, provide
//     a fleet or alias ID along with your game session configuration.
//
//   - To create a game session on an instance in a fleet's remote location,
//     provide a fleet or alias ID and a location name, along with your game
//     session configuration.
//
//   - To create a game session on an instance in an Anywhere fleet, specify
//     the fleet's custom location.
//
// If successful, Amazon GameLift initiates a workflow to start a new game session
// and returns a GameSession object containing the game session configuration
// and status. When the game session status is ACTIVE, it is updated with connection
// information and you can create player sessions for the game session. By default,
// newly created game sessions are open to new players. You can restrict new
// player access by using UpdateGameSession (https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameSession.html)
// to change the game session's player session creation policy.
//
// Amazon GameLift retains logs for active for 14 days. To access the logs,
// call GetGameSessionLogUrl (https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetGameSessionLogUrl.html)
// to download the log files.
//
// Available in Amazon GameLift Local.
//
// # Learn more
//
// Start a game session (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation CreateGameSession for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     The requested operation would cause a conflict with the current state of
//     a service resource associated with the request. Resolve the conflict before
//     retrying this request.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidFleetStatusException
//     The requested operation would cause a conflict with the current state of
//     a resource associated with the request and/or the fleet. Resolve the conflict
//     before retrying.
//
//   - TerminalRoutingStrategyException
//     The service is unable to resolve the routing for a particular alias because
//     it has a terminal RoutingStrategy associated with it. The message returned
//     in this exception is the message defined in the routing strategy itself.
//     Such requests should only be retried if the routing strategy for the specified
//     alias is modified.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - FleetCapacityExceededException
//     The specified fleet has no available instances to fulfill a CreateGameSession
//     request. Clients can retry such requests immediately or after a waiting period.
//
//   - LimitExceededException
//     The requested operation would cause the resource to exceed the allowed service
//     limit. Resolve the issue before retrying.
//
//   - IdempotentParameterMismatchException
//     A game session with this custom ID string already exists in this fleet. Resolve
//     this conflict before retrying this request.
//
//   - UnsupportedRegionException
//     The requested operation is not supported in the Region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameSession
func (c *GameLift) CreateGameSession(input *CreateGameSessionInput) (*CreateGameSessionOutput, error) {
	req, out := c.CreateGameSessionRequest(input)
	return out, req.Send()
}

// CreateGameSessionWithContext is the same as CreateGameSession with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGameSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) CreateGameSessionWithContext(ctx aws.Context, input *CreateGameSessionInput, opts ...request.Option) (*CreateGameSessionOutput, error) {
	req, out := c.CreateGameSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGameSessionQueue = "CreateGameSessionQueue"

// CreateGameSessionQueueRequest generates a "aws/request.Request" representing the
// client's request for the CreateGameSessionQueue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGameSessionQueue for more information on using the CreateGameSessionQueue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateGameSessionQueueRequest method.
//	req, resp := client.CreateGameSessionQueueRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameSessionQueue
func (c *GameLift) CreateGameSessionQueueRequest(input *CreateGameSessionQueueInput) (req *request.Request, output *CreateGameSessionQueueOutput) {
	op := &request.Operation{
		Name:       opCreateGameSessionQueue,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateGameSessionQueueInput{}
	}

	output = &CreateGameSessionQueueOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGameSessionQueue API operation for Amazon GameLift.
//
// Creates a placement queue that processes requests for new game sessions.
// A queue uses FleetIQ algorithms to determine the best placement locations
// and find an available game server there, then prompts the game server process
// to start a new game session.
//
// A game session queue is configured with a set of destinations (Amazon GameLift
// fleets or aliases), which determine the locations where the queue can place
// new game sessions. These destinations can span multiple fleet types (Spot
// and On-Demand), instance types, and Amazon Web Services Regions. If the queue
// includes multi-location fleets, the queue is able to place game sessions
// in all of a fleet's remote locations. You can opt to filter out individual
// locations if needed.
//
// The queue configuration also determines how FleetIQ selects the best available
// placement for a new game session. Before searching for an available game
// server, FleetIQ first prioritizes the queue's destinations and locations,
// with the best placement locations on top. You can set up the queue to use
// the FleetIQ default prioritization or provide an alternate set of priorities.
//
// To create a new queue, provide a name, timeout value, and a list of destinations.
// Optionally, specify a sort configuration and/or a filter, and define a set
// of latency cap policies. You can also include the ARN for an Amazon Simple
// Notification Service (SNS) topic to receive notifications of game session
// placement activity. Notifications using SNS or CloudWatch events is the preferred
// way to track placement activity.
//
// If successful, a new GameSessionQueue object is returned with an assigned
// queue ARN. New game session requests, which are submitted to queue with StartGameSessionPlacement
// (https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartGameSessionPlacement.html)
// or StartMatchmaking (https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartMatchmaking.html),
// reference a queue's name or ARN.
//
// Learn more
//
//	Design a game session queue (https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-design.html)
//
//	Create a game session queue (https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-creating.html)
//
// # Related actions
//
// CreateGameSessionQueue (https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateGameSessionQueue.html)
// | DescribeGameSessionQueues (https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessionQueues.html)
// | UpdateGameSessionQueue (https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameSessionQueue.html)
// | DeleteGameSessionQueue (https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteGameSessionQueue.html)
// | All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation CreateGameSessionQueue for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - LimitExceededException
//     The requested operation would cause the resource to exceed the allowed service
//     limit. Resolve the issue before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - TaggingFailedException
//     The requested tagging operation did not succeed. This may be due to invalid
//     tag format or the maximum tag limit may have been exceeded. Resolve the issue
//     before retrying.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameSessionQueue
func (c *GameLift) CreateGameSessionQueue(input *CreateGameSessionQueueInput) (*CreateGameSessionQueueOutput, error) {
	req, out := c.CreateGameSessionQueueRequest(input)
	return out, req.Send()
}

// CreateGameSessionQueueWithContext is the same as CreateGameSessionQueue with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGameSessionQueue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) CreateGameSessionQueueWithContext(ctx aws.Context, input *CreateGameSessionQueueInput, opts ...request.Option) (*CreateGameSessionQueueOutput, error) {
	req, out := c.CreateGameSessionQueueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLocation = "CreateLocation"

// CreateLocationRequest generates a "aws/request.Request" representing the
// client's request for the CreateLocation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLocation for more information on using the CreateLocation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLocationRequest method.
//	req, resp := client.CreateLocationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateLocation
func (c *GameLift) CreateLocationRequest(input *CreateLocationInput) (req *request.Request, output *CreateLocationOutput) {
	op := &request.Operation{
		Name:       opCreateLocation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLocationInput{}
	}

	output = &CreateLocationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLocation API operation for Amazon GameLift.
//
// Creates a custom location for use in an Anywhere fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation CreateLocation for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - LimitExceededException
//     The requested operation would cause the resource to exceed the allowed service
//     limit. Resolve the issue before retrying.
//
//   - ConflictException
//     The requested operation would cause a conflict with the current state of
//     a service resource associated with the request. Resolve the conflict before
//     retrying this request.
//
//   - TaggingFailedException
//     The requested tagging operation did not succeed. This may be due to invalid
//     tag format or the maximum tag limit may have been exceeded. Resolve the issue
//     before retrying.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateLocation
func (c *GameLift) CreateLocation(input *CreateLocationInput) (*CreateLocationOutput, error) {
	req, out := c.CreateLocationRequest(input)
	return out, req.Send()
}

// CreateLocationWithContext is the same as CreateLocation with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLocation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) CreateLocationWithContext(ctx aws.Context, input *CreateLocationInput, opts ...request.Option) (*CreateLocationOutput, error) {
	req, out := c.CreateLocationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMatchmakingConfiguration = "CreateMatchmakingConfiguration"

// CreateMatchmakingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateMatchmakingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMatchmakingConfiguration for more information on using the CreateMatchmakingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMatchmakingConfigurationRequest method.
//	req, resp := client.CreateMatchmakingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateMatchmakingConfiguration
func (c *GameLift) CreateMatchmakingConfigurationRequest(input *CreateMatchmakingConfigurationInput) (req *request.Request, output *CreateMatchmakingConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateMatchmakingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateMatchmakingConfigurationInput{}
	}

	output = &CreateMatchmakingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMatchmakingConfiguration API operation for Amazon GameLift.
//
// Defines a new matchmaking configuration for use with FlexMatch. Whether your
// are using FlexMatch with Amazon GameLift hosting or as a standalone matchmaking
// service, the matchmaking configuration sets out rules for matching players
// and forming teams. If you're also using Amazon GameLift hosting, it defines
// how to start game sessions for each match. Your matchmaking system can use
// multiple configurations to handle different game scenarios. All matchmaking
// requests identify the matchmaking configuration to use and provide player
// attributes consistent with that configuration.
//
// To create a matchmaking configuration, you must provide the following: configuration
// name and FlexMatch mode (with or without Amazon GameLift hosting); a rule
// set that specifies how to evaluate players and find acceptable matches; whether
// player acceptance is required; and the maximum time allowed for a matchmaking
// attempt. When using FlexMatch with Amazon GameLift hosting, you also need
// to identify the game session queue to use when starting a game session for
// the match.
//
// In addition, you must set up an Amazon Simple Notification Service topic
// to receive matchmaking notifications. Provide the topic ARN in the matchmaking
// configuration.
//
// Learn more
//
//	Design a FlexMatch matchmaker (https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-configuration.html)
//
//	Set up FlexMatch event notification (https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation CreateMatchmakingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - LimitExceededException
//     The requested operation would cause the resource to exceed the allowed service
//     limit. Resolve the issue before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - UnsupportedRegionException
//     The requested operation is not supported in the Region specified.
//
//   - TaggingFailedException
//     The requested tagging operation did not succeed. This may be due to invalid
//     tag format or the maximum tag limit may have been exceeded. Resolve the issue
//     before retrying.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateMatchmakingConfiguration
func (c *GameLift) CreateMatchmakingConfiguration(input *CreateMatchmakingConfigurationInput) (*CreateMatchmakingConfigurationOutput, error) {
	req, out := c.CreateMatchmakingConfigurationRequest(input)
	return out, req.Send()
}

// CreateMatchmakingConfigurationWithContext is the same as CreateMatchmakingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMatchmakingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) CreateMatchmakingConfigurationWithContext(ctx aws.Context, input *CreateMatchmakingConfigurationInput, opts ...request.Option) (*CreateMatchmakingConfigurationOutput, error) {
	req, out := c.CreateMatchmakingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMatchmakingRuleSet = "CreateMatchmakingRuleSet"

// CreateMatchmakingRuleSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateMatchmakingRuleSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMatchmakingRuleSet for more information on using the CreateMatchmakingRuleSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMatchmakingRuleSetRequest method.
//	req, resp := client.CreateMatchmakingRuleSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateMatchmakingRuleSet
func (c *GameLift) CreateMatchmakingRuleSetRequest(input *CreateMatchmakingRuleSetInput) (req *request.Request, output *CreateMatchmakingRuleSetOutput) {
	op := &request.Operation{
		Name:       opCreateMatchmakingRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateMatchmakingRuleSetInput{}
	}

	output = &CreateMatchmakingRuleSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMatchmakingRuleSet API operation for Amazon GameLift.
//
// Creates a new rule set for FlexMatch matchmaking. A rule set describes the
// type of match to create, such as the number and size of teams. It also sets
// the parameters for acceptable player matches, such as minimum skill level
// or character type.
//
// To create a matchmaking rule set, provide unique rule set name and the rule
// set body in JSON format. Rule sets must be defined in the same Region as
// the matchmaking configuration they are used with.
//
// Since matchmaking rule sets cannot be edited, it is a good idea to check
// the rule set syntax using ValidateMatchmakingRuleSet (https://docs.aws.amazon.com/gamelift/latest/apireference/API_ValidateMatchmakingRuleSet.html)
// before creating a new rule set.
//
// Learn more
//
//   - Build a rule set (https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html)
//
//   - Design a matchmaker (https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-configuration.html)
//
//   - Matchmaking with FlexMatch (https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-intro.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation CreateMatchmakingRuleSet for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - LimitExceededException
//     The requested operation would cause the resource to exceed the allowed service
//     limit. Resolve the issue before retrying.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - UnsupportedRegionException
//     The requested operation is not supported in the Region specified.
//
//   - TaggingFailedException
//     The requested tagging operation did not succeed. This may be due to invalid
//     tag format or the maximum tag limit may have been exceeded. Resolve the issue
//     before retrying.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateMatchmakingRuleSet
func (c *GameLift) CreateMatchmakingRuleSet(input *CreateMatchmakingRuleSetInput) (*CreateMatchmakingRuleSetOutput, error) {
	req, out := c.CreateMatchmakingRuleSetRequest(input)
	return out, req.Send()
}

// CreateMatchmakingRuleSetWithContext is the same as CreateMatchmakingRuleSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMatchmakingRuleSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) CreateMatchmakingRuleSetWithContext(ctx aws.Context, input *CreateMatchmakingRuleSetInput, opts ...request.Option) (*CreateMatchmakingRuleSetOutput, error) {
	req, out := c.CreateMatchmakingRuleSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePlayerSession = "CreatePlayerSession"

// CreatePlayerSessionRequest generates a "aws/request.Request" representing the
// client's request for the CreatePlayerSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePlayerSession for more information on using the CreatePlayerSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePlayerSessionRequest method.
//	req, resp := client.CreatePlayerSessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreatePlayerSession
func (c *GameLift) CreatePlayerSessionRequest(input *CreatePlayerSessionInput) (req *request.Request, output *CreatePlayerSessionOutput) {
	op := &request.Operation{
		Name:       opCreatePlayerSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePlayerSessionInput{}
	}

	output = &CreatePlayerSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePlayerSession API operation for Amazon GameLift.
//
// Reserves an open player slot in a game session for a player. New player sessions
// can be created in any game session with an open slot that is in ACTIVE status
// and has a player creation policy of ACCEPT_ALL. You can add a group of players
// to a game session with CreatePlayerSessions (https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreatePlayerSessions.html) .
//
// To create a player session, specify a game session ID, player ID, and optionally
// a set of player data.
//
// If successful, a slot is reserved in the game session for the player and
// a new PlayerSessions object is returned with a player session ID. The player
// references the player session ID when sending a connection request to the
// game session, and the game server can use it to validate the player reservation
// with the Amazon GameLift service. Player sessions cannot be updated.
//
// The maximum number of players per game session is 200. It is not adjustable.
//
// # Related actions
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation CreatePlayerSession for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidGameSessionStatusException
//     The requested operation would cause a conflict with the current state of
//     a resource associated with the request and/or the game instance. Resolve
//     the conflict before retrying.
//
//   - GameSessionFullException
//     The game instance is currently full and cannot allow the requested player(s)
//     to join. Clients can retry such requests immediately or after a waiting period.
//
//   - TerminalRoutingStrategyException
//     The service is unable to resolve the routing for a particular alias because
//     it has a terminal RoutingStrategy associated with it. The message returned
//     in this exception is the message defined in the routing strategy itself.
//     Such requests should only be retried if the routing strategy for the specified
//     alias is modified.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreatePlayerSession
func (c *GameLift) CreatePlayerSession(input *CreatePlayerSessionInput) (*CreatePlayerSessionOutput, error) {
	req, out := c.CreatePlayerSessionRequest(input)
	return out, req.Send()
}

// CreatePlayerSessionWithContext is the same as CreatePlayerSession with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePlayerSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) CreatePlayerSessionWithContext(ctx aws.Context, input *CreatePlayerSessionInput, opts ...request.Option) (*CreatePlayerSessionOutput, error) {
	req, out := c.CreatePlayerSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePlayerSessions = "CreatePlayerSessions"

// CreatePlayerSessionsRequest generates a "aws/request.Request" representing the
// client's request for the CreatePlayerSessions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePlayerSessions for more information on using the CreatePlayerSessions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePlayerSessionsRequest method.
//	req, resp := client.CreatePlayerSessionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreatePlayerSessions
func (c *GameLift) CreatePlayerSessionsRequest(input *CreatePlayerSessionsInput) (req *request.Request, output *CreatePlayerSessionsOutput) {
	op := &request.Operation{
		Name:       opCreatePlayerSessions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePlayerSessionsInput{}
	}

	output = &CreatePlayerSessionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePlayerSessions API operation for Amazon GameLift.
//
// Reserves open slots in a game session for a group of players. New player
// sessions can be created in any game session with an open slot that is in
// ACTIVE status and has a player creation policy of ACCEPT_ALL. To add a single
// player to a game session, use CreatePlayerSession (https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreatePlayerSession.html)
//
// To create player sessions, specify a game session ID and a list of player
// IDs. Optionally, provide a set of player data for each player ID.
//
// If successful, a slot is reserved in the game session for each player, and
// new PlayerSession objects are returned with player session IDs. Each player
// references their player session ID when sending a connection request to the
// game session, and the game server can use it to validate the player reservation
// with the Amazon GameLift service. Player sessions cannot be updated.
//
// The maximum number of players per game session is 200. It is not adjustable.
//
// # Related actions
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation CreatePlayerSessions for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidGameSessionStatusException
//     The requested operation would cause a conflict with the current state of
//     a resource associated with the request and/or the game instance. Resolve
//     the conflict before retrying.
//
//   - GameSessionFullException
//     The game instance is currently full and cannot allow the requested player(s)
//     to join. Clients can retry such requests immediately or after a waiting period.
//
//   - TerminalRoutingStrategyException
//     The service is unable to resolve the routing for a particular alias because
//     it has a terminal RoutingStrategy associated with it. The message returned
//     in this exception is the message defined in the routing strategy itself.
//     Such requests should only be retried if the routing strategy for the specified
//     alias is modified.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreatePlayerSessions
func (c *GameLift) CreatePlayerSessions(input *CreatePlayerSessionsInput) (*CreatePlayerSessionsOutput, error) {
	req, out := c.CreatePlayerSessionsRequest(input)
	return out, req.Send()
}

// CreatePlayerSessionsWithContext is the same as CreatePlayerSessions with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePlayerSessions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) CreatePlayerSessionsWithContext(ctx aws.Context, input *CreatePlayerSessionsInput, opts ...request.Option) (*CreatePlayerSessionsOutput, error) {
	req, out := c.CreatePlayerSessionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateScript = "CreateScript"

// CreateScriptRequest generates a "aws/request.Request" representing the
// client's request for the CreateScript operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateScript for more information on using the CreateScript
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateScriptRequest method.
//	req, resp := client.CreateScriptRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateScript
func (c *GameLift) CreateScriptRequest(input *CreateScriptInput) (req *request.Request, output *CreateScriptOutput) {
	op := &request.Operation{
		Name:       opCreateScript,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateScriptInput{}
	}

	output = &CreateScriptOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateScript API operation for Amazon GameLift.
//
// Creates a new script record for your Realtime Servers script. Realtime scripts
// are JavaScript that provide configuration settings and optional custom game
// logic for your game. The script is deployed when you create a Realtime Servers
// fleet to host your game sessions. Script logic is executed during an active
// game session.
//
// To create a new script record, specify a script name and provide the script
// file(s). The script files and all dependencies must be zipped into a single
// file. You can pull the zip file from either of these locations:
//
//   - A locally available directory. Use the ZipFile parameter for this option.
//
//   - An Amazon Simple Storage Service (Amazon S3) bucket under your Amazon
//     Web Services account. Use the StorageLocation parameter for this option.
//     You'll need to have an Identity Access Management (IAM) role that allows
//     the Amazon GameLift service to access your S3 bucket.
//
// If the call is successful, a new script record is created with a unique script
// ID. If the script file is provided as a local file, the file is uploaded
// to an Amazon GameLift-owned S3 bucket and the script record's storage location
// reflects this location. If the script file is provided as an S3 bucket, Amazon
// GameLift accesses the file at this storage location as needed for deployment.
//
// # Learn more
//
// Amazon GameLift Realtime Servers (https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html)
//
// Set Up a Role for Amazon GameLift Access (https://docs.aws.amazon.com/gamelift/latest/developerguide/setting-up-role.html)
//
// # Related actions
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation CreateScript for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - ConflictException
//     The requested operation would cause a conflict with the current state of
//     a service resource associated with the request. Resolve the conflict before
//     retrying this request.
//
//   - TaggingFailedException
//     The requested tagging operation did not succeed. This may be due to invalid
//     tag format or the maximum tag limit may have been exceeded. Resolve the issue
//     before retrying.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateScript
func (c *GameLift) CreateScript(input *CreateScriptInput) (*CreateScriptOutput, error) {
	req, out := c.CreateScriptRequest(input)
	return out, req.Send()
}

// CreateScriptWithContext is the same as CreateScript with the addition of
// the ability to pass a context and additional request options.
//
// See CreateScript for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) CreateScriptWithContext(ctx aws.Context, input *CreateScriptInput, opts ...request.Option) (*CreateScriptOutput, error) {
	req, out := c.CreateScriptRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVpcPeeringAuthorization = "CreateVpcPeeringAuthorization"

// CreateVpcPeeringAuthorizationRequest generates a "aws/request.Request" representing the
// client's request for the CreateVpcPeeringAuthorization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVpcPeeringAuthorization for more information on using the CreateVpcPeeringAuthorization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVpcPeeringAuthorizationRequest method.
//	req, resp := client.CreateVpcPeeringAuthorizationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateVpcPeeringAuthorization
func (c *GameLift) CreateVpcPeeringAuthorizationRequest(input *CreateVpcPeeringAuthorizationInput) (req *request.Request, output *CreateVpcPeeringAuthorizationOutput) {
	op := &request.Operation{
		Name:       opCreateVpcPeeringAuthorization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpcPeeringAuthorizationInput{}
	}

	output = &CreateVpcPeeringAuthorizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVpcPeeringAuthorization API operation for Amazon GameLift.
//
// Requests authorization to create or delete a peer connection between the
// VPC for your Amazon GameLift fleet and a virtual private cloud (VPC) in your
// Amazon Web Services account. VPC peering enables the game servers on your
// fleet to communicate directly with other Amazon Web Services resources. After
// you've received authorization, use CreateVpcPeeringConnection (https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateVpcPeeringConnection.html)
// to establish the peering connection. For more information, see VPC Peering
// with Amazon GameLift Fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html).
//
// You can peer with VPCs that are owned by any Amazon Web Services account
// you have access to, including the account that you use to manage your Amazon
// GameLift fleets. You cannot peer with VPCs that are in different Regions.
//
// To request authorization to create a connection, call this operation from
// the Amazon Web Services account with the VPC that you want to peer to your
// Amazon GameLift fleet. For example, to enable your game servers to retrieve
// data from a DynamoDB table, use the account that manages that DynamoDB resource.
// Identify the following values: (1) The ID of the VPC that you want to peer
// with, and (2) the ID of the Amazon Web Services account that you use to manage
// Amazon GameLift. If successful, VPC peering is authorized for the specified
// VPC.
//
// To request authorization to delete a connection, call this operation from
// the Amazon Web Services account with the VPC that is peered with your Amazon
// GameLift fleet. Identify the following values: (1) VPC ID that you want to
// delete the peering connection for, and (2) ID of the Amazon Web Services
// account that you use to manage Amazon GameLift.
//
// The authorization remains valid for 24 hours unless it is canceled. You must
// create or delete the peering connection while the authorization is valid.
//
// # Related actions
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation CreateVpcPeeringAuthorization for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateVpcPeeringAuthorization
func (c *GameLift) CreateVpcPeeringAuthorization(input *CreateVpcPeeringAuthorizationInput) (*CreateVpcPeeringAuthorizationOutput, error) {
	req, out := c.CreateVpcPeeringAuthorizationRequest(input)
	return out, req.Send()
}

// CreateVpcPeeringAuthorizationWithContext is the same as CreateVpcPeeringAuthorization with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVpcPeeringAuthorization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) CreateVpcPeeringAuthorizationWithContext(ctx aws.Context, input *CreateVpcPeeringAuthorizationInput, opts ...request.Option) (*CreateVpcPeeringAuthorizationOutput, error) {
	req, out := c.CreateVpcPeeringAuthorizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVpcPeeringConnection = "CreateVpcPeeringConnection"

// CreateVpcPeeringConnectionRequest generates a "aws/request.Request" representing the
// client's request for the CreateVpcPeeringConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVpcPeeringConnection for more information on using the CreateVpcPeeringConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVpcPeeringConnectionRequest method.
//	req, resp := client.CreateVpcPeeringConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateVpcPeeringConnection
func (c *GameLift) CreateVpcPeeringConnectionRequest(input *CreateVpcPeeringConnectionInput) (req *request.Request, output *CreateVpcPeeringConnectionOutput) {
	op := &request.Operation{
		Name:       opCreateVpcPeeringConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpcPeeringConnectionInput{}
	}

	output = &CreateVpcPeeringConnectionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateVpcPeeringConnection API operation for Amazon GameLift.
//
// Establishes a VPC peering connection between a virtual private cloud (VPC)
// in an Amazon Web Services account with the VPC for your Amazon GameLift fleet.
// VPC peering enables the game servers on your fleet to communicate directly
// with other Amazon Web Services resources. You can peer with VPCs in any Amazon
// Web Services account that you have access to, including the account that
// you use to manage your Amazon GameLift fleets. You cannot peer with VPCs
// that are in different Regions. For more information, see VPC Peering with
// Amazon GameLift Fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html).
//
// Before calling this operation to establish the peering connection, you first
// need to use CreateVpcPeeringAuthorization (https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateVpcPeeringAuthorization.html)
// and identify the VPC you want to peer with. Once the authorization for the
// specified VPC is issued, you have 24 hours to establish the connection. These
// two operations handle all tasks necessary to peer the two VPCs, including
// acceptance, updating routing tables, etc.
//
// To establish the connection, call this operation from the Amazon Web Services
// account that is used to manage the Amazon GameLift fleets. Identify the following
// values: (1) The ID of the fleet you want to be enable a VPC peering connection
// for; (2) The Amazon Web Services account with the VPC that you want to peer
// with; and (3) The ID of the VPC you want to peer with. This operation is
// asynchronous. If successful, a connection request is created. You can use
// continuous polling to track the request's status using DescribeVpcPeeringConnections
// (https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeVpcPeeringConnections.html)
// , or by monitoring fleet events for success or failure using DescribeFleetEvents
// (https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetEvents.html) .
//
// # Related actions
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation CreateVpcPeeringConnection for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateVpcPeeringConnection
func (c *GameLift) CreateVpcPeeringConnection(input *CreateVpcPeeringConnectionInput) (*CreateVpcPeeringConnectionOutput, error) {
	req, out := c.CreateVpcPeeringConnectionRequest(input)
	return out, req.Send()
}

// CreateVpcPeeringConnectionWithContext is the same as CreateVpcPeeringConnection with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVpcPeeringConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) CreateVpcPeeringConnectionWithContext(ctx aws.Context, input *CreateVpcPeeringConnectionInput, opts ...request.Option) (*CreateVpcPeeringConnectionOutput, error) {
	req, out := c.CreateVpcPeeringConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAlias = "DeleteAlias"

// DeleteAliasRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAlias for more information on using the DeleteAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAliasRequest method.
//	req, resp := client.DeleteAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteAlias
func (c *GameLift) DeleteAliasRequest(input *DeleteAliasInput) (req *request.Request, output *DeleteAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAliasInput{}
	}

	output = &DeleteAliasOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAlias API operation for Amazon GameLift.
//
// Deletes an alias. This operation removes all record of the alias. Game clients
// attempting to access a server process using the deleted alias receive an
// error. To delete an alias, specify the alias ID to be deleted.
//
// # Related actions
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DeleteAlias for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - TaggingFailedException
//     The requested tagging operation did not succeed. This may be due to invalid
//     tag format or the maximum tag limit may have been exceeded. Resolve the issue
//     before retrying.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteAlias
func (c *GameLift) DeleteAlias(input *DeleteAliasInput) (*DeleteAliasOutput, error) {
	req, out := c.DeleteAliasRequest(input)
	return out, req.Send()
}

// DeleteAliasWithContext is the same as DeleteAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DeleteAliasWithContext(ctx aws.Context, input *DeleteAliasInput, opts ...request.Option) (*DeleteAliasOutput, error) {
	req, out := c.DeleteAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBuild = "DeleteBuild"

// DeleteBuildRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBuild operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBuild for more information on using the DeleteBuild
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBuildRequest method.
//	req, resp := client.DeleteBuildRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteBuild
func (c *GameLift) DeleteBuildRequest(input *DeleteBuildInput) (req *request.Request, output *DeleteBuildOutput) {
	op := &request.Operation{
		Name:       opDeleteBuild,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteBuildInput{}
	}

	output = &DeleteBuildOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBuild API operation for Amazon GameLift.
//
// Deletes a build. This operation permanently deletes the build resource and
// any uploaded build files. Deleting a build does not affect the status of
// any active fleets using the build, but you can no longer create new fleets
// with the deleted build.
//
// To delete a build, specify the build ID.
//
// Learn more
//
//	Upload a Custom Server Build (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html)
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DeleteBuild for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - TaggingFailedException
//     The requested tagging operation did not succeed. This may be due to invalid
//     tag format or the maximum tag limit may have been exceeded. Resolve the issue
//     before retrying.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteBuild
func (c *GameLift) DeleteBuild(input *DeleteBuildInput) (*DeleteBuildOutput, error) {
	req, out := c.DeleteBuildRequest(input)
	return out, req.Send()
}

// DeleteBuildWithContext is the same as DeleteBuild with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBuild for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DeleteBuildWithContext(ctx aws.Context, input *DeleteBuildInput, opts ...request.Option) (*DeleteBuildOutput, error) {
	req, out := c.DeleteBuildRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFleet = "DeleteFleet"

// DeleteFleetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFleet for more information on using the DeleteFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteFleetRequest method.
//	req, resp := client.DeleteFleetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteFleet
func (c *GameLift) DeleteFleetRequest(input *DeleteFleetInput) (req *request.Request, output *DeleteFleetOutput) {
	op := &request.Operation{
		Name:       opDeleteFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFleetInput{}
	}

	output = &DeleteFleetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFleet API operation for Amazon GameLift.
//
// Deletes all resources and information related a fleet. Any current fleet
// instances, including those in remote locations, are shut down. You don't
// need to call DeleteFleetLocations separately.
//
// If the fleet being deleted has a VPC peering connection, you first need to
// get a valid authorization (good for 24 hours) by calling CreateVpcPeeringAuthorization
// (https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateVpcPeeringAuthorization.html).
// You do not need to explicitly delete the VPC peering connection.
//
// To delete a fleet, specify the fleet ID to be terminated. During the deletion
// process the fleet status is changed to DELETING. When completed, the status
// switches to TERMINATED and the fleet event FLEET_DELETED is sent.
//
// # Learn more
//
// Setting up Amazon GameLift Fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DeleteFleet for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - InvalidFleetStatusException
//     The requested operation would cause a conflict with the current state of
//     a resource associated with the request and/or the fleet. Resolve the conflict
//     before retrying.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - TaggingFailedException
//     The requested tagging operation did not succeed. This may be due to invalid
//     tag format or the maximum tag limit may have been exceeded. Resolve the issue
//     before retrying.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteFleet
func (c *GameLift) DeleteFleet(input *DeleteFleetInput) (*DeleteFleetOutput, error) {
	req, out := c.DeleteFleetRequest(input)
	return out, req.Send()
}

// DeleteFleetWithContext is the same as DeleteFleet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DeleteFleetWithContext(ctx aws.Context, input *DeleteFleetInput, opts ...request.Option) (*DeleteFleetOutput, error) {
	req, out := c.DeleteFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFleetLocations = "DeleteFleetLocations"

// DeleteFleetLocationsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFleetLocations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFleetLocations for more information on using the DeleteFleetLocations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteFleetLocationsRequest method.
//	req, resp := client.DeleteFleetLocationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteFleetLocations
func (c *GameLift) DeleteFleetLocationsRequest(input *DeleteFleetLocationsInput) (req *request.Request, output *DeleteFleetLocationsOutput) {
	op := &request.Operation{
		Name:       opDeleteFleetLocations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFleetLocationsInput{}
	}

	output = &DeleteFleetLocationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFleetLocations API operation for Amazon GameLift.
//
// Removes locations from a multi-location fleet. When deleting a location,
// all game server process and all instances that are still active in the location
// are shut down.
//
// To delete fleet locations, identify the fleet ID and provide a list of the
// locations to be deleted.
//
// If successful, GameLift sets the location status to DELETING, and begins
// to shut down existing server processes and terminate instances in each location
// being deleted. When completed, the location status changes to TERMINATED.
//
// # Learn more
//
// Setting up Amazon GameLift fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DeleteFleetLocations for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - UnsupportedRegionException
//     The requested operation is not supported in the Region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteFleetLocations
func (c *GameLift) DeleteFleetLocations(input *DeleteFleetLocationsInput) (*DeleteFleetLocationsOutput, error) {
	req, out := c.DeleteFleetLocationsRequest(input)
	return out, req.Send()
}

// DeleteFleetLocationsWithContext is the same as DeleteFleetLocations with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFleetLocations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DeleteFleetLocationsWithContext(ctx aws.Context, input *DeleteFleetLocationsInput, opts ...request.Option) (*DeleteFleetLocationsOutput, error) {
	req, out := c.DeleteFleetLocationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGameServerGroup = "DeleteGameServerGroup"

// DeleteGameServerGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGameServerGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGameServerGroup for more information on using the DeleteGameServerGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteGameServerGroupRequest method.
//	req, resp := client.DeleteGameServerGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteGameServerGroup
func (c *GameLift) DeleteGameServerGroupRequest(input *DeleteGameServerGroupInput) (req *request.Request, output *DeleteGameServerGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteGameServerGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteGameServerGroupInput{}
	}

	output = &DeleteGameServerGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteGameServerGroup API operation for Amazon GameLift.
//
// This operation is used with the Amazon GameLift FleetIQ solution and game
// server groups.
//
// Terminates a game server group and permanently deletes the game server group
// record. You have several options for how these resources are impacted when
// deleting the game server group. Depending on the type of delete operation
// selected, this operation might affect these resources:
//
//   - The game server group
//
//   - The corresponding Auto Scaling group
//
//   - All game servers that are currently running in the group
//
// To delete a game server group, identify the game server group to delete and
// specify the type of delete operation to initiate. Game server groups can
// only be deleted if they are in ACTIVE or ERROR status.
//
// If the delete request is successful, a series of operations are kicked off.
// The game server group status is changed to DELETE_SCHEDULED, which prevents
// new game servers from being registered and stops automatic scaling activity.
// Once all game servers in the game server group are deregistered, Amazon GameLift
// FleetIQ can begin deleting resources. If any of the delete operations fail,
// the game server group is placed in ERROR status.
//
// Amazon GameLift FleetIQ emits delete events to Amazon CloudWatch.
//
// # Learn more
//
// Amazon GameLift FleetIQ Guide (https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DeleteGameServerGroup for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteGameServerGroup
func (c *GameLift) DeleteGameServerGroup(input *DeleteGameServerGroupInput) (*DeleteGameServerGroupOutput, error) {
	req, out := c.DeleteGameServerGroupRequest(input)
	return out, req.Send()
}

// DeleteGameServerGroupWithContext is the same as DeleteGameServerGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGameServerGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DeleteGameServerGroupWithContext(ctx aws.Context, input *DeleteGameServerGroupInput, opts ...request.Option) (*DeleteGameServerGroupOutput, error) {
	req, out := c.DeleteGameServerGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGameSessionQueue = "DeleteGameSessionQueue"

// DeleteGameSessionQueueRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGameSessionQueue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGameSessionQueue for more information on using the DeleteGameSessionQueue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteGameSessionQueueRequest method.
//	req, resp := client.DeleteGameSessionQueueRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteGameSessionQueue
func (c *GameLift) DeleteGameSessionQueueRequest(input *DeleteGameSessionQueueInput) (req *request.Request, output *DeleteGameSessionQueueOutput) {
	op := &request.Operation{
		Name:       opDeleteGameSessionQueue,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteGameSessionQueueInput{}
	}

	output = &DeleteGameSessionQueueOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteGameSessionQueue API operation for Amazon GameLift.
//
// Deletes a game session queue. Once a queue is successfully deleted, unfulfilled
// StartGameSessionPlacement (https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartGameSessionPlacement.html)
// requests that reference the queue will fail. To delete a queue, specify the
// queue name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DeleteGameSessionQueue for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - TaggingFailedException
//     The requested tagging operation did not succeed. This may be due to invalid
//     tag format or the maximum tag limit may have been exceeded. Resolve the issue
//     before retrying.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteGameSessionQueue
func (c *GameLift) DeleteGameSessionQueue(input *DeleteGameSessionQueueInput) (*DeleteGameSessionQueueOutput, error) {
	req, out := c.DeleteGameSessionQueueRequest(input)
	return out, req.Send()
}

// DeleteGameSessionQueueWithContext is the same as DeleteGameSessionQueue with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGameSessionQueue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DeleteGameSessionQueueWithContext(ctx aws.Context, input *DeleteGameSessionQueueInput, opts ...request.Option) (*DeleteGameSessionQueueOutput, error) {
	req, out := c.DeleteGameSessionQueueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLocation = "DeleteLocation"

// DeleteLocationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLocation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLocation for more information on using the DeleteLocation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteLocationRequest method.
//	req, resp := client.DeleteLocationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteLocation
func (c *GameLift) DeleteLocationRequest(input *DeleteLocationInput) (req *request.Request, output *DeleteLocationOutput) {
	op := &request.Operation{
		Name:       opDeleteLocation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLocationInput{}
	}

	output = &DeleteLocationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLocation API operation for Amazon GameLift.
//
// Deletes a custom location.
//
// Before deleting a custom location, review any fleets currently using the
// custom location and deregister the location if it is in use. For more information,
// see DeregisterCompute (https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeregisterCompute.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DeleteLocation for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteLocation
func (c *GameLift) DeleteLocation(input *DeleteLocationInput) (*DeleteLocationOutput, error) {
	req, out := c.DeleteLocationRequest(input)
	return out, req.Send()
}

// DeleteLocationWithContext is the same as DeleteLocation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLocation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DeleteLocationWithContext(ctx aws.Context, input *DeleteLocationInput, opts ...request.Option) (*DeleteLocationOutput, error) {
	req, out := c.DeleteLocationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMatchmakingConfiguration = "DeleteMatchmakingConfiguration"

// DeleteMatchmakingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMatchmakingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMatchmakingConfiguration for more information on using the DeleteMatchmakingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMatchmakingConfigurationRequest method.
//	req, resp := client.DeleteMatchmakingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteMatchmakingConfiguration
func (c *GameLift) DeleteMatchmakingConfigurationRequest(input *DeleteMatchmakingConfigurationInput) (req *request.Request, output *DeleteMatchmakingConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteMatchmakingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteMatchmakingConfigurationInput{}
	}

	output = &DeleteMatchmakingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMatchmakingConfiguration API operation for Amazon GameLift.
//
// Permanently removes a FlexMatch matchmaking configuration. To delete, specify
// the configuration name. A matchmaking configuration cannot be deleted if
// it is being used in any active matchmaking tickets.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DeleteMatchmakingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - UnsupportedRegionException
//     The requested operation is not supported in the Region specified.
//
//   - TaggingFailedException
//     The requested tagging operation did not succeed. This may be due to invalid
//     tag format or the maximum tag limit may have been exceeded. Resolve the issue
//     before retrying.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteMatchmakingConfiguration
func (c *GameLift) DeleteMatchmakingConfiguration(input *DeleteMatchmakingConfigurationInput) (*DeleteMatchmakingConfigurationOutput, error) {
	req, out := c.DeleteMatchmakingConfigurationRequest(input)
	return out, req.Send()
}

// DeleteMatchmakingConfigurationWithContext is the same as DeleteMatchmakingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMatchmakingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DeleteMatchmakingConfigurationWithContext(ctx aws.Context, input *DeleteMatchmakingConfigurationInput, opts ...request.Option) (*DeleteMatchmakingConfigurationOutput, error) {
	req, out := c.DeleteMatchmakingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMatchmakingRuleSet = "DeleteMatchmakingRuleSet"

// DeleteMatchmakingRuleSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMatchmakingRuleSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMatchmakingRuleSet for more information on using the DeleteMatchmakingRuleSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMatchmakingRuleSetRequest method.
//	req, resp := client.DeleteMatchmakingRuleSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteMatchmakingRuleSet
func (c *GameLift) DeleteMatchmakingRuleSetRequest(input *DeleteMatchmakingRuleSetInput) (req *request.Request, output *DeleteMatchmakingRuleSetOutput) {
	op := &request.Operation{
		Name:       opDeleteMatchmakingRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteMatchmakingRuleSetInput{}
	}

	output = &DeleteMatchmakingRuleSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMatchmakingRuleSet API operation for Amazon GameLift.
//
// Deletes an existing matchmaking rule set. To delete the rule set, provide
// the rule set name. Rule sets cannot be deleted if they are currently being
// used by a matchmaking configuration.
//
// Learn more
//
//   - Build a rule set (https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DeleteMatchmakingRuleSet for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - UnsupportedRegionException
//     The requested operation is not supported in the Region specified.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - TaggingFailedException
//     The requested tagging operation did not succeed. This may be due to invalid
//     tag format or the maximum tag limit may have been exceeded. Resolve the issue
//     before retrying.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteMatchmakingRuleSet
func (c *GameLift) DeleteMatchmakingRuleSet(input *DeleteMatchmakingRuleSetInput) (*DeleteMatchmakingRuleSetOutput, error) {
	req, out := c.DeleteMatchmakingRuleSetRequest(input)
	return out, req.Send()
}

// DeleteMatchmakingRuleSetWithContext is the same as DeleteMatchmakingRuleSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMatchmakingRuleSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DeleteMatchmakingRuleSetWithContext(ctx aws.Context, input *DeleteMatchmakingRuleSetInput, opts ...request.Option) (*DeleteMatchmakingRuleSetOutput, error) {
	req, out := c.DeleteMatchmakingRuleSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteScalingPolicy = "DeleteScalingPolicy"

// DeleteScalingPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteScalingPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteScalingPolicy for more information on using the DeleteScalingPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteScalingPolicyRequest method.
//	req, resp := client.DeleteScalingPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteScalingPolicy
func (c *GameLift) DeleteScalingPolicyRequest(input *DeleteScalingPolicyInput) (req *request.Request, output *DeleteScalingPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteScalingPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteScalingPolicyInput{}
	}

	output = &DeleteScalingPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteScalingPolicy API operation for Amazon GameLift.
//
// Deletes a fleet scaling policy. Once deleted, the policy is no longer in
// force and Amazon GameLift removes all record of it. To delete a scaling policy,
// specify both the scaling policy name and the fleet ID it is associated with.
//
// To temporarily suspend scaling policies, use StopFleetActions (https://docs.aws.amazon.com/gamelift/latest/apireference/API_StopFleetActions.html).
// This operation suspends all policies for the fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DeleteScalingPolicy for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteScalingPolicy
func (c *GameLift) DeleteScalingPolicy(input *DeleteScalingPolicyInput) (*DeleteScalingPolicyOutput, error) {
	req, out := c.DeleteScalingPolicyRequest(input)
	return out, req.Send()
}

// DeleteScalingPolicyWithContext is the same as DeleteScalingPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteScalingPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DeleteScalingPolicyWithContext(ctx aws.Context, input *DeleteScalingPolicyInput, opts ...request.Option) (*DeleteScalingPolicyOutput, error) {
	req, out := c.DeleteScalingPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteScript = "DeleteScript"

// DeleteScriptRequest generates a "aws/request.Request" representing the
// client's request for the DeleteScript operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteScript for more information on using the DeleteScript
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteScriptRequest method.
//	req, resp := client.DeleteScriptRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteScript
func (c *GameLift) DeleteScriptRequest(input *DeleteScriptInput) (req *request.Request, output *DeleteScriptOutput) {
	op := &request.Operation{
		Name:       opDeleteScript,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteScriptInput{}
	}

	output = &DeleteScriptOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteScript API operation for Amazon GameLift.
//
// Deletes a Realtime script. This operation permanently deletes the script
// record. If script files were uploaded, they are also deleted (files stored
// in an S3 bucket are not deleted).
//
// To delete a script, specify the script ID. Before deleting a script, be sure
// to terminate all fleets that are deployed with the script being deleted.
// Fleet instances periodically check for script updates, and if the script
// record no longer exists, the instance will go into an error state and be
// unable to host game sessions.
//
// # Learn more
//
// Amazon GameLift Realtime Servers (https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html)
//
// # Related actions
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DeleteScript for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - TaggingFailedException
//     The requested tagging operation did not succeed. This may be due to invalid
//     tag format or the maximum tag limit may have been exceeded. Resolve the issue
//     before retrying.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteScript
func (c *GameLift) DeleteScript(input *DeleteScriptInput) (*DeleteScriptOutput, error) {
	req, out := c.DeleteScriptRequest(input)
	return out, req.Send()
}

// DeleteScriptWithContext is the same as DeleteScript with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteScript for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DeleteScriptWithContext(ctx aws.Context, input *DeleteScriptInput, opts ...request.Option) (*DeleteScriptOutput, error) {
	req, out := c.DeleteScriptRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVpcPeeringAuthorization = "DeleteVpcPeeringAuthorization"

// DeleteVpcPeeringAuthorizationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVpcPeeringAuthorization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVpcPeeringAuthorization for more information on using the DeleteVpcPeeringAuthorization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVpcPeeringAuthorizationRequest method.
//	req, resp := client.DeleteVpcPeeringAuthorizationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteVpcPeeringAuthorization
func (c *GameLift) DeleteVpcPeeringAuthorizationRequest(input *DeleteVpcPeeringAuthorizationInput) (req *request.Request, output *DeleteVpcPeeringAuthorizationOutput) {
	op := &request.Operation{
		Name:       opDeleteVpcPeeringAuthorization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpcPeeringAuthorizationInput{}
	}

	output = &DeleteVpcPeeringAuthorizationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVpcPeeringAuthorization API operation for Amazon GameLift.
//
// Cancels a pending VPC peering authorization for the specified VPC. If you
// need to delete an existing VPC peering connection, use DeleteVpcPeeringConnection
// (https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteVpcPeeringConnection.html).
//
// # Related actions
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DeleteVpcPeeringAuthorization for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteVpcPeeringAuthorization
func (c *GameLift) DeleteVpcPeeringAuthorization(input *DeleteVpcPeeringAuthorizationInput) (*DeleteVpcPeeringAuthorizationOutput, error) {
	req, out := c.DeleteVpcPeeringAuthorizationRequest(input)
	return out, req.Send()
}

// DeleteVpcPeeringAuthorizationWithContext is the same as DeleteVpcPeeringAuthorization with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVpcPeeringAuthorization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DeleteVpcPeeringAuthorizationWithContext(ctx aws.Context, input *DeleteVpcPeeringAuthorizationInput, opts ...request.Option) (*DeleteVpcPeeringAuthorizationOutput, error) {
	req, out := c.DeleteVpcPeeringAuthorizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVpcPeeringConnection = "DeleteVpcPeeringConnection"

// DeleteVpcPeeringConnectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVpcPeeringConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVpcPeeringConnection for more information on using the DeleteVpcPeeringConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVpcPeeringConnectionRequest method.
//	req, resp := client.DeleteVpcPeeringConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteVpcPeeringConnection
func (c *GameLift) DeleteVpcPeeringConnectionRequest(input *DeleteVpcPeeringConnectionInput) (req *request.Request, output *DeleteVpcPeeringConnectionOutput) {
	op := &request.Operation{
		Name:       opDeleteVpcPeeringConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpcPeeringConnectionInput{}
	}

	output = &DeleteVpcPeeringConnectionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVpcPeeringConnection API operation for Amazon GameLift.
//
// Removes a VPC peering connection. To delete the connection, you must have
// a valid authorization for the VPC peering connection that you want to delete..
//
// Once a valid authorization exists, call this operation from the Amazon Web
// Services account that is used to manage the Amazon GameLift fleets. Identify
// the connection to delete by the connection ID and fleet ID. If successful,
// the connection is removed.
//
// # Related actions
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DeleteVpcPeeringConnection for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteVpcPeeringConnection
func (c *GameLift) DeleteVpcPeeringConnection(input *DeleteVpcPeeringConnectionInput) (*DeleteVpcPeeringConnectionOutput, error) {
	req, out := c.DeleteVpcPeeringConnectionRequest(input)
	return out, req.Send()
}

// DeleteVpcPeeringConnectionWithContext is the same as DeleteVpcPeeringConnection with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVpcPeeringConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DeleteVpcPeeringConnectionWithContext(ctx aws.Context, input *DeleteVpcPeeringConnectionInput, opts ...request.Option) (*DeleteVpcPeeringConnectionOutput, error) {
	req, out := c.DeleteVpcPeeringConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterCompute = "DeregisterCompute"

// DeregisterComputeRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterCompute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterCompute for more information on using the DeregisterCompute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeregisterComputeRequest method.
//	req, resp := client.DeregisterComputeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeregisterCompute
func (c *GameLift) DeregisterComputeRequest(input *DeregisterComputeInput) (req *request.Request, output *DeregisterComputeOutput) {
	op := &request.Operation{
		Name:       opDeregisterCompute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterComputeInput{}
	}

	output = &DeregisterComputeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterCompute API operation for Amazon GameLift.
//
// Removes a compute resource from an Amazon GameLift Anywhere fleet. Deregistered
// computes can no longer host game sessions through Amazon GameLift.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DeregisterCompute for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeregisterCompute
func (c *GameLift) DeregisterCompute(input *DeregisterComputeInput) (*DeregisterComputeOutput, error) {
	req, out := c.DeregisterComputeRequest(input)
	return out, req.Send()
}

// DeregisterComputeWithContext is the same as DeregisterCompute with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterCompute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DeregisterComputeWithContext(ctx aws.Context, input *DeregisterComputeInput, opts ...request.Option) (*DeregisterComputeOutput, error) {
	req, out := c.DeregisterComputeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterGameServer = "DeregisterGameServer"

// DeregisterGameServerRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterGameServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterGameServer for more information on using the DeregisterGameServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeregisterGameServerRequest method.
//	req, resp := client.DeregisterGameServerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeregisterGameServer
func (c *GameLift) DeregisterGameServerRequest(input *DeregisterGameServerInput) (req *request.Request, output *DeregisterGameServerOutput) {
	op := &request.Operation{
		Name:       opDeregisterGameServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterGameServerInput{}
	}

	output = &DeregisterGameServerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterGameServer API operation for Amazon GameLift.
//
// This operation is used with the Amazon GameLift FleetIQ solution and game
// server groups.
//
// Removes the game server from a game server group. As a result of this operation,
// the deregistered game server can no longer be claimed and will not be returned
// in a list of active game servers.
//
// To deregister a game server, specify the game server group and game server
// ID. If successful, this operation emits a CloudWatch event with termination
// timestamp and reason.
//
// # Learn more
//
// Amazon GameLift FleetIQ Guide (https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DeregisterGameServer for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeregisterGameServer
func (c *GameLift) DeregisterGameServer(input *DeregisterGameServerInput) (*DeregisterGameServerOutput, error) {
	req, out := c.DeregisterGameServerRequest(input)
	return out, req.Send()
}

// DeregisterGameServerWithContext is the same as DeregisterGameServer with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterGameServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DeregisterGameServerWithContext(ctx aws.Context, input *DeregisterGameServerInput, opts ...request.Option) (*DeregisterGameServerOutput, error) {
	req, out := c.DeregisterGameServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAlias = "DescribeAlias"

// DescribeAliasRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAlias for more information on using the DescribeAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAliasRequest method.
//	req, resp := client.DescribeAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeAlias
func (c *GameLift) DescribeAliasRequest(input *DescribeAliasInput) (req *request.Request, output *DescribeAliasOutput) {
	op := &request.Operation{
		Name:       opDescribeAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAliasInput{}
	}

	output = &DescribeAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAlias API operation for Amazon GameLift.
//
// Retrieves properties for an alias. This operation returns all alias metadata
// and settings. To get an alias's target fleet ID only, use ResolveAlias.
//
// To get alias properties, specify the alias ID. If successful, the requested
// alias record is returned.
//
// # Related actions
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeAlias for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeAlias
func (c *GameLift) DescribeAlias(input *DescribeAliasInput) (*DescribeAliasOutput, error) {
	req, out := c.DescribeAliasRequest(input)
	return out, req.Send()
}

// DescribeAliasWithContext is the same as DescribeAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeAliasWithContext(ctx aws.Context, input *DescribeAliasInput, opts ...request.Option) (*DescribeAliasOutput, error) {
	req, out := c.DescribeAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBuild = "DescribeBuild"

// DescribeBuildRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBuild operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBuild for more information on using the DescribeBuild
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeBuildRequest method.
//	req, resp := client.DescribeBuildRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeBuild
func (c *GameLift) DescribeBuildRequest(input *DescribeBuildInput) (req *request.Request, output *DescribeBuildOutput) {
	op := &request.Operation{
		Name:       opDescribeBuild,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeBuildInput{}
	}

	output = &DescribeBuildOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBuild API operation for Amazon GameLift.
//
// Retrieves properties for a custom game build. To request a build resource,
// specify a build ID. If successful, an object containing the build properties
// is returned.
//
// Learn more
//
//	Upload a Custom Server Build (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html)
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeBuild for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeBuild
func (c *GameLift) DescribeBuild(input *DescribeBuildInput) (*DescribeBuildOutput, error) {
	req, out := c.DescribeBuildRequest(input)
	return out, req.Send()
}

// DescribeBuildWithContext is the same as DescribeBuild with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBuild for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeBuildWithContext(ctx aws.Context, input *DescribeBuildInput, opts ...request.Option) (*DescribeBuildOutput, error) {
	req, out := c.DescribeBuildRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCompute = "DescribeCompute"

// DescribeComputeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCompute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCompute for more information on using the DescribeCompute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeComputeRequest method.
//	req, resp := client.DescribeComputeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeCompute
func (c *GameLift) DescribeComputeRequest(input *DescribeComputeInput) (req *request.Request, output *DescribeComputeOutput) {
	op := &request.Operation{
		Name:       opDescribeCompute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeComputeInput{}
	}

	output = &DescribeComputeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCompute API operation for Amazon GameLift.
//
// Retrieves properties for a compute resource in an Amazon GameLift fleet.
// Call ListCompute to get a list of compute resources in a fleet. You can request
// information for computes in either managed EC2 fleets or Anywhere fleets.
//
// To request compute properties, specify the compute name and fleet ID.
//
// If successful, this operation returns details for the requested compute resource.
// For managed EC2 fleets, this operation returns the fleet's EC2 instances.
// For Anywhere fleets, this operation returns the fleet's registered computes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeCompute for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeCompute
func (c *GameLift) DescribeCompute(input *DescribeComputeInput) (*DescribeComputeOutput, error) {
	req, out := c.DescribeComputeRequest(input)
	return out, req.Send()
}

// DescribeComputeWithContext is the same as DescribeCompute with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCompute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeComputeWithContext(ctx aws.Context, input *DescribeComputeInput, opts ...request.Option) (*DescribeComputeOutput, error) {
	req, out := c.DescribeComputeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEC2InstanceLimits = "DescribeEC2InstanceLimits"

// DescribeEC2InstanceLimitsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEC2InstanceLimits operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEC2InstanceLimits for more information on using the DescribeEC2InstanceLimits
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeEC2InstanceLimitsRequest method.
//	req, resp := client.DescribeEC2InstanceLimitsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeEC2InstanceLimits
func (c *GameLift) DescribeEC2InstanceLimitsRequest(input *DescribeEC2InstanceLimitsInput) (req *request.Request, output *DescribeEC2InstanceLimitsOutput) {
	op := &request.Operation{
		Name:       opDescribeEC2InstanceLimits,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEC2InstanceLimitsInput{}
	}

	output = &DescribeEC2InstanceLimitsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEC2InstanceLimits API operation for Amazon GameLift.
//
// Retrieves the instance limits and current utilization for an Amazon Web Services
// Region or location. Instance limits control the number of instances, per
// instance type, per location, that your Amazon Web Services account can use.
// Learn more at Amazon EC2 Instance Types (http://aws.amazon.com/ec2/instance-types/).
// The information returned includes the maximum number of instances allowed
// and your account's current usage across all fleets. This information can
// affect your ability to scale your Amazon GameLift fleets. You can request
// a limit increase for your account by using the Service limits page in the
// Amazon GameLift console.
//
// Instance limits differ based on whether the instances are deployed in a fleet's
// home Region or in a remote location. For remote locations, limits also differ
// based on the combination of home Region and remote location. All requests
// must specify an Amazon Web Services Region (either explicitly or as your
// default settings). To get the limit for a remote location, you must also
// specify the location. For example, the following requests all return different
// results:
//
//   - Request specifies the Region ap-northeast-1 with no location. The result
//     is limits and usage data on all instance types that are deployed in us-east-2,
//     by all of the fleets that reside in ap-northeast-1.
//
//   - Request specifies the Region us-east-1 with location ca-central-1. The
//     result is limits and usage data on all instance types that are deployed
//     in ca-central-1, by all of the fleets that reside in us-east-2. These
//     limits do not affect fleets in any other Regions that deploy instances
//     to ca-central-1.
//
//   - Request specifies the Region eu-west-1 with location ca-central-1. The
//     result is limits and usage data on all instance types that are deployed
//     in ca-central-1, by all of the fleets that reside in eu-west-1.
//
// This operation can be used in the following ways:
//
//   - To get limit and usage data for all instance types that are deployed
//     in an Amazon Web Services Region by fleets that reside in the same Region:
//     Specify the Region only. Optionally, specify a single instance type to
//     retrieve information for.
//
//   - To get limit and usage data for all instance types that are deployed
//     to a remote location by fleets that reside in different Amazon Web Services
//     Region: Provide both the Amazon Web Services Region and the remote location.
//     Optionally, specify a single instance type to retrieve information for.
//
// If successful, an EC2InstanceLimits object is returned with limits and usage
// data for each requested instance type.
//
// # Learn more
//
// Setting up Amazon GameLift fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeEC2InstanceLimits for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - UnsupportedRegionException
//     The requested operation is not supported in the Region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeEC2InstanceLimits
func (c *GameLift) DescribeEC2InstanceLimits(input *DescribeEC2InstanceLimitsInput) (*DescribeEC2InstanceLimitsOutput, error) {
	req, out := c.DescribeEC2InstanceLimitsRequest(input)
	return out, req.Send()
}

// DescribeEC2InstanceLimitsWithContext is the same as DescribeEC2InstanceLimits with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEC2InstanceLimits for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeEC2InstanceLimitsWithContext(ctx aws.Context, input *DescribeEC2InstanceLimitsInput, opts ...request.Option) (*DescribeEC2InstanceLimitsOutput, error) {
	req, out := c.DescribeEC2InstanceLimitsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFleetAttributes = "DescribeFleetAttributes"

// DescribeFleetAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleetAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFleetAttributes for more information on using the DescribeFleetAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFleetAttributesRequest method.
//	req, resp := client.DescribeFleetAttributesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetAttributes
func (c *GameLift) DescribeFleetAttributesRequest(input *DescribeFleetAttributesInput) (req *request.Request, output *DescribeFleetAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeFleetAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeFleetAttributesInput{}
	}

	output = &DescribeFleetAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleetAttributes API operation for Amazon GameLift.
//
// Retrieves core fleet-wide properties, including the computing hardware and
// deployment configuration for all instances in the fleet.
//
// This operation can be used in the following ways:
//
//   - To get attributes for one or more specific fleets, provide a list of
//     fleet IDs or fleet ARNs.
//
//   - To get attributes for all fleets, do not provide a fleet identifier.
//
// When requesting attributes for multiple fleets, use the pagination parameters
// to retrieve results as a set of sequential pages.
//
// If successful, a FleetAttributes object is returned for each fleet requested,
// unless the fleet identifier is not found.
//
// Some API operations limit the number of fleet IDs that allowed in one request.
// If a request exceeds this limit, the request fails and the error message
// contains the maximum allowed number.
//
// # Learn more
//
// Setting up Amazon GameLift fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeFleetAttributes for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetAttributes
func (c *GameLift) DescribeFleetAttributes(input *DescribeFleetAttributesInput) (*DescribeFleetAttributesOutput, error) {
	req, out := c.DescribeFleetAttributesRequest(input)
	return out, req.Send()
}

// DescribeFleetAttributesWithContext is the same as DescribeFleetAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFleetAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeFleetAttributesWithContext(ctx aws.Context, input *DescribeFleetAttributesInput, opts ...request.Option) (*DescribeFleetAttributesOutput, error) {
	req, out := c.DescribeFleetAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeFleetAttributesPages iterates over the pages of a DescribeFleetAttributes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeFleetAttributes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeFleetAttributes operation.
//	pageNum := 0
//	err := client.DescribeFleetAttributesPages(params,
//	    func(page *gamelift.DescribeFleetAttributesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GameLift) DescribeFleetAttributesPages(input *DescribeFleetAttributesInput, fn func(*DescribeFleetAttributesOutput, bool) bool) error {
	return c.DescribeFleetAttributesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeFleetAttributesPagesWithContext same as DescribeFleetAttributesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeFleetAttributesPagesWithContext(ctx aws.Context, input *DescribeFleetAttributesInput, fn func(*DescribeFleetAttributesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeFleetAttributesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeFleetAttributesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeFleetAttributesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeFleetCapacity = "DescribeFleetCapacity"

// DescribeFleetCapacityRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleetCapacity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFleetCapacity for more information on using the DescribeFleetCapacity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFleetCapacityRequest method.
//	req, resp := client.DescribeFleetCapacityRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetCapacity
func (c *GameLift) DescribeFleetCapacityRequest(input *DescribeFleetCapacityInput) (req *request.Request, output *DescribeFleetCapacityOutput) {
	op := &request.Operation{
		Name:       opDescribeFleetCapacity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeFleetCapacityInput{}
	}

	output = &DescribeFleetCapacityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleetCapacity API operation for Amazon GameLift.
//
// Retrieves the resource capacity settings for one or more fleets. The data
// returned includes the current fleet capacity (number of EC2 instances), and
// settings that can control how capacity scaling. For fleets with remote locations,
// this operation retrieves data for the fleet's home Region only.
//
// This operation can be used in the following ways:
//
//   - To get capacity data for one or more specific fleets, provide a list
//     of fleet IDs or fleet ARNs.
//
//   - To get capacity data for all fleets, do not provide a fleet identifier.
//
// When requesting multiple fleets, use the pagination parameters to retrieve
// results as a set of sequential pages.
//
// If successful, a FleetCapacity object is returned for each requested fleet
// ID. Each FleetCapacity object includes a Location property, which is set
// to the fleet's home Region. When a list of fleet IDs is provided, attribute
// objects are returned only for fleets that currently exist.
//
// Some API operations may limit the number of fleet IDs that are allowed in
// one request. If a request exceeds this limit, the request fails and the error
// message includes the maximum allowed.
//
// # Learn more
//
// Setting up Amazon GameLift fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
//
// GameLift metrics for fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeFleetCapacity for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetCapacity
func (c *GameLift) DescribeFleetCapacity(input *DescribeFleetCapacityInput) (*DescribeFleetCapacityOutput, error) {
	req, out := c.DescribeFleetCapacityRequest(input)
	return out, req.Send()
}

// DescribeFleetCapacityWithContext is the same as DescribeFleetCapacity with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFleetCapacity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeFleetCapacityWithContext(ctx aws.Context, input *DescribeFleetCapacityInput, opts ...request.Option) (*DescribeFleetCapacityOutput, error) {
	req, out := c.DescribeFleetCapacityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeFleetCapacityPages iterates over the pages of a DescribeFleetCapacity operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeFleetCapacity method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeFleetCapacity operation.
//	pageNum := 0
//	err := client.DescribeFleetCapacityPages(params,
//	    func(page *gamelift.DescribeFleetCapacityOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GameLift) DescribeFleetCapacityPages(input *DescribeFleetCapacityInput, fn func(*DescribeFleetCapacityOutput, bool) bool) error {
	return c.DescribeFleetCapacityPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeFleetCapacityPagesWithContext same as DescribeFleetCapacityPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeFleetCapacityPagesWithContext(ctx aws.Context, input *DescribeFleetCapacityInput, fn func(*DescribeFleetCapacityOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeFleetCapacityInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeFleetCapacityRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeFleetCapacityOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeFleetEvents = "DescribeFleetEvents"

// DescribeFleetEventsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleetEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFleetEvents for more information on using the DescribeFleetEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFleetEventsRequest method.
//	req, resp := client.DescribeFleetEventsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetEvents
func (c *GameLift) DescribeFleetEventsRequest(input *DescribeFleetEventsInput) (req *request.Request, output *DescribeFleetEventsOutput) {
	op := &request.Operation{
		Name:       opDescribeFleetEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeFleetEventsInput{}
	}

	output = &DescribeFleetEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleetEvents API operation for Amazon GameLift.
//
// Retrieves entries from a fleet's event log. Fleet events are initiated by
// changes in status, such as during fleet creation and termination, changes
// in capacity, etc. If a fleet has multiple locations, events are also initiated
// by changes to status and capacity in remote locations.
//
// You can specify a time range to limit the result set. Use the pagination
// parameters to retrieve results as a set of sequential pages.
//
// If successful, a collection of event log entries matching the request are
// returned.
//
// # Learn more
//
// Setting up Amazon GameLift fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeFleetEvents for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetEvents
func (c *GameLift) DescribeFleetEvents(input *DescribeFleetEventsInput) (*DescribeFleetEventsOutput, error) {
	req, out := c.DescribeFleetEventsRequest(input)
	return out, req.Send()
}

// DescribeFleetEventsWithContext is the same as DescribeFleetEvents with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFleetEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeFleetEventsWithContext(ctx aws.Context, input *DescribeFleetEventsInput, opts ...request.Option) (*DescribeFleetEventsOutput, error) {
	req, out := c.DescribeFleetEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeFleetEventsPages iterates over the pages of a DescribeFleetEvents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeFleetEvents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeFleetEvents operation.
//	pageNum := 0
//	err := client.DescribeFleetEventsPages(params,
//	    func(page *gamelift.DescribeFleetEventsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GameLift) DescribeFleetEventsPages(input *DescribeFleetEventsInput, fn func(*DescribeFleetEventsOutput, bool) bool) error {
	return c.DescribeFleetEventsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeFleetEventsPagesWithContext same as DescribeFleetEventsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeFleetEventsPagesWithContext(ctx aws.Context, input *DescribeFleetEventsInput, fn func(*DescribeFleetEventsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeFleetEventsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeFleetEventsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeFleetEventsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeFleetLocationAttributes = "DescribeFleetLocationAttributes"

// DescribeFleetLocationAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleetLocationAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFleetLocationAttributes for more information on using the DescribeFleetLocationAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFleetLocationAttributesRequest method.
//	req, resp := client.DescribeFleetLocationAttributesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetLocationAttributes
func (c *GameLift) DescribeFleetLocationAttributesRequest(input *DescribeFleetLocationAttributesInput) (req *request.Request, output *DescribeFleetLocationAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeFleetLocationAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeFleetLocationAttributesInput{}
	}

	output = &DescribeFleetLocationAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleetLocationAttributes API operation for Amazon GameLift.
//
// Retrieves information on a fleet's remote locations, including life-cycle
// status and any suspended fleet activity.
//
// This operation can be used in the following ways:
//
//   - To get data for specific locations, provide a fleet identifier and a
//     list of locations. Location data is returned in the order that it is requested.
//
//   - To get data for all locations, provide a fleet identifier only. Location
//     data is returned in no particular order.
//
// When requesting attributes for multiple locations, use the pagination parameters
// to retrieve results as a set of sequential pages.
//
// If successful, a LocationAttributes object is returned for each requested
// location. If the fleet does not have a requested location, no information
// is returned. This operation does not return the home Region. To get information
// on a fleet's home Region, call DescribeFleetAttributes.
//
// # Learn more
//
// Setting up Amazon GameLift fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeFleetLocationAttributes for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - UnsupportedRegionException
//     The requested operation is not supported in the Region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetLocationAttributes
func (c *GameLift) DescribeFleetLocationAttributes(input *DescribeFleetLocationAttributesInput) (*DescribeFleetLocationAttributesOutput, error) {
	req, out := c.DescribeFleetLocationAttributesRequest(input)
	return out, req.Send()
}

// DescribeFleetLocationAttributesWithContext is the same as DescribeFleetLocationAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFleetLocationAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeFleetLocationAttributesWithContext(ctx aws.Context, input *DescribeFleetLocationAttributesInput, opts ...request.Option) (*DescribeFleetLocationAttributesOutput, error) {
	req, out := c.DescribeFleetLocationAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeFleetLocationAttributesPages iterates over the pages of a DescribeFleetLocationAttributes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeFleetLocationAttributes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeFleetLocationAttributes operation.
//	pageNum := 0
//	err := client.DescribeFleetLocationAttributesPages(params,
//	    func(page *gamelift.DescribeFleetLocationAttributesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GameLift) DescribeFleetLocationAttributesPages(input *DescribeFleetLocationAttributesInput, fn func(*DescribeFleetLocationAttributesOutput, bool) bool) error {
	return c.DescribeFleetLocationAttributesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeFleetLocationAttributesPagesWithContext same as DescribeFleetLocationAttributesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeFleetLocationAttributesPagesWithContext(ctx aws.Context, input *DescribeFleetLocationAttributesInput, fn func(*DescribeFleetLocationAttributesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeFleetLocationAttributesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeFleetLocationAttributesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeFleetLocationAttributesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeFleetLocationCapacity = "DescribeFleetLocationCapacity"

// DescribeFleetLocationCapacityRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleetLocationCapacity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFleetLocationCapacity for more information on using the DescribeFleetLocationCapacity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFleetLocationCapacityRequest method.
//	req, resp := client.DescribeFleetLocationCapacityRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetLocationCapacity
func (c *GameLift) DescribeFleetLocationCapacityRequest(input *DescribeFleetLocationCapacityInput) (req *request.Request, output *DescribeFleetLocationCapacityOutput) {
	op := &request.Operation{
		Name:       opDescribeFleetLocationCapacity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFleetLocationCapacityInput{}
	}

	output = &DescribeFleetLocationCapacityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleetLocationCapacity API operation for Amazon GameLift.
//
// Retrieves the resource capacity settings for a fleet location. The data returned
// includes the current capacity (number of EC2 instances) and some scaling
// settings for the requested fleet location. Use this operation to retrieve
// capacity information for a fleet's remote location or home Region (you can
// also retrieve home Region capacity by calling DescribeFleetCapacity).
//
// To retrieve capacity data, identify a fleet and location.
//
// If successful, a FleetCapacity object is returned for the requested fleet
// location.
//
// # Learn more
//
// Setting up Amazon GameLift fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
//
// GameLift metrics for fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeFleetLocationCapacity for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - UnsupportedRegionException
//     The requested operation is not supported in the Region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetLocationCapacity
func (c *GameLift) DescribeFleetLocationCapacity(input *DescribeFleetLocationCapacityInput) (*DescribeFleetLocationCapacityOutput, error) {
	req, out := c.DescribeFleetLocationCapacityRequest(input)
	return out, req.Send()
}

// DescribeFleetLocationCapacityWithContext is the same as DescribeFleetLocationCapacity with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFleetLocationCapacity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeFleetLocationCapacityWithContext(ctx aws.Context, input *DescribeFleetLocationCapacityInput, opts ...request.Option) (*DescribeFleetLocationCapacityOutput, error) {
	req, out := c.DescribeFleetLocationCapacityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFleetLocationUtilization = "DescribeFleetLocationUtilization"

// DescribeFleetLocationUtilizationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleetLocationUtilization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFleetLocationUtilization for more information on using the DescribeFleetLocationUtilization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFleetLocationUtilizationRequest method.
//	req, resp := client.DescribeFleetLocationUtilizationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetLocationUtilization
func (c *GameLift) DescribeFleetLocationUtilizationRequest(input *DescribeFleetLocationUtilizationInput) (req *request.Request, output *DescribeFleetLocationUtilizationOutput) {
	op := &request.Operation{
		Name:       opDescribeFleetLocationUtilization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFleetLocationUtilizationInput{}
	}

	output = &DescribeFleetLocationUtilizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleetLocationUtilization API operation for Amazon GameLift.
//
// Retrieves current usage data for a fleet location. Utilization data provides
// a snapshot of current game hosting activity at the requested location. Use
// this operation to retrieve utilization information for a fleet's remote location
// or home Region (you can also retrieve home Region utilization by calling
// DescribeFleetUtilization).
//
// To retrieve utilization data, identify a fleet and location.
//
// If successful, a FleetUtilization object is returned for the requested fleet
// location.
//
// # Learn more
//
// Setting up Amazon GameLift fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
//
// GameLift metrics for fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeFleetLocationUtilization for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - UnsupportedRegionException
//     The requested operation is not supported in the Region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetLocationUtilization
func (c *GameLift) DescribeFleetLocationUtilization(input *DescribeFleetLocationUtilizationInput) (*DescribeFleetLocationUtilizationOutput, error) {
	req, out := c.DescribeFleetLocationUtilizationRequest(input)
	return out, req.Send()
}

// DescribeFleetLocationUtilizationWithContext is the same as DescribeFleetLocationUtilization with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFleetLocationUtilization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeFleetLocationUtilizationWithContext(ctx aws.Context, input *DescribeFleetLocationUtilizationInput, opts ...request.Option) (*DescribeFleetLocationUtilizationOutput, error) {
	req, out := c.DescribeFleetLocationUtilizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFleetPortSettings = "DescribeFleetPortSettings"

// DescribeFleetPortSettingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleetPortSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFleetPortSettings for more information on using the DescribeFleetPortSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFleetPortSettingsRequest method.
//	req, resp := client.DescribeFleetPortSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetPortSettings
func (c *GameLift) DescribeFleetPortSettingsRequest(input *DescribeFleetPortSettingsInput) (req *request.Request, output *DescribeFleetPortSettingsOutput) {
	op := &request.Operation{
		Name:       opDescribeFleetPortSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFleetPortSettingsInput{}
	}

	output = &DescribeFleetPortSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleetPortSettings API operation for Amazon GameLift.
//
// Retrieves a fleet's inbound connection permissions. Connection permissions
// specify the range of IP addresses and port settings that incoming traffic
// can use to access server processes in the fleet. Game sessions that are running
// on instances in the fleet must use connections that fall in this range.
//
// This operation can be used in the following ways:
//
//   - To retrieve the inbound connection permissions for a fleet, identify
//     the fleet's unique identifier.
//
//   - To check the status of recent updates to a fleet remote location, specify
//     the fleet ID and a location. Port setting updates can take time to propagate
//     across all locations.
//
// If successful, a set of IpPermission objects is returned for the requested
// fleet ID. When a location is specified, a pending status is included. If
// the requested fleet has been deleted, the result set is empty.
//
// # Learn more
//
// Setting up Amazon GameLift fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeFleetPortSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - UnsupportedRegionException
//     The requested operation is not supported in the Region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetPortSettings
func (c *GameLift) DescribeFleetPortSettings(input *DescribeFleetPortSettingsInput) (*DescribeFleetPortSettingsOutput, error) {
	req, out := c.DescribeFleetPortSettingsRequest(input)
	return out, req.Send()
}

// DescribeFleetPortSettingsWithContext is the same as DescribeFleetPortSettings with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFleetPortSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeFleetPortSettingsWithContext(ctx aws.Context, input *DescribeFleetPortSettingsInput, opts ...request.Option) (*DescribeFleetPortSettingsOutput, error) {
	req, out := c.DescribeFleetPortSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFleetUtilization = "DescribeFleetUtilization"

// DescribeFleetUtilizationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleetUtilization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFleetUtilization for more information on using the DescribeFleetUtilization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFleetUtilizationRequest method.
//	req, resp := client.DescribeFleetUtilizationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetUtilization
func (c *GameLift) DescribeFleetUtilizationRequest(input *DescribeFleetUtilizationInput) (req *request.Request, output *DescribeFleetUtilizationOutput) {
	op := &request.Operation{
		Name:       opDescribeFleetUtilization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeFleetUtilizationInput{}
	}

	output = &DescribeFleetUtilizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleetUtilization API operation for Amazon GameLift.
//
// Retrieves utilization statistics for one or more fleets. Utilization data
// provides a snapshot of how the fleet's hosting resources are currently being
// used. For fleets with remote locations, this operation retrieves data for
// the fleet's home Region only. See DescribeFleetLocationUtilization (https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationUtilization.html)
// to get utilization statistics for a fleet's remote locations.
//
// This operation can be used in the following ways:
//
//   - To get utilization data for one or more specific fleets, provide a list
//     of fleet IDs or fleet ARNs.
//
//   - To get utilization data for all fleets, do not provide a fleet identifier.
//
// When requesting multiple fleets, use the pagination parameters to retrieve
// results as a set of sequential pages.
//
// If successful, a FleetUtilization (https://docs.aws.amazon.com/gamelift/latest/apireference/API_FleetUtilization.html)
// object is returned for each requested fleet ID, unless the fleet identifier
// is not found. Each fleet utilization object includes a Location property,
// which is set to the fleet's home Region.
//
// Some API operations may limit the number of fleet IDs allowed in one request.
// If a request exceeds this limit, the request fails and the error message
// includes the maximum allowed.
//
// # Learn more
//
// Setting up Amazon GameLift Fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
//
// GameLift Metrics for Fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeFleetUtilization for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetUtilization
func (c *GameLift) DescribeFleetUtilization(input *DescribeFleetUtilizationInput) (*DescribeFleetUtilizationOutput, error) {
	req, out := c.DescribeFleetUtilizationRequest(input)
	return out, req.Send()
}

// DescribeFleetUtilizationWithContext is the same as DescribeFleetUtilization with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFleetUtilization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeFleetUtilizationWithContext(ctx aws.Context, input *DescribeFleetUtilizationInput, opts ...request.Option) (*DescribeFleetUtilizationOutput, error) {
	req, out := c.DescribeFleetUtilizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeFleetUtilizationPages iterates over the pages of a DescribeFleetUtilization operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeFleetUtilization method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeFleetUtilization operation.
//	pageNum := 0
//	err := client.DescribeFleetUtilizationPages(params,
//	    func(page *gamelift.DescribeFleetUtilizationOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GameLift) DescribeFleetUtilizationPages(input *DescribeFleetUtilizationInput, fn func(*DescribeFleetUtilizationOutput, bool) bool) error {
	return c.DescribeFleetUtilizationPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeFleetUtilizationPagesWithContext same as DescribeFleetUtilizationPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeFleetUtilizationPagesWithContext(ctx aws.Context, input *DescribeFleetUtilizationInput, fn func(*DescribeFleetUtilizationOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeFleetUtilizationInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeFleetUtilizationRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeFleetUtilizationOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeGameServer = "DescribeGameServer"

// DescribeGameServerRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGameServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGameServer for more information on using the DescribeGameServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeGameServerRequest method.
//	req, resp := client.DescribeGameServerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameServer
func (c *GameLift) DescribeGameServerRequest(input *DescribeGameServerInput) (req *request.Request, output *DescribeGameServerOutput) {
	op := &request.Operation{
		Name:       opDescribeGameServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeGameServerInput{}
	}

	output = &DescribeGameServerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGameServer API operation for Amazon GameLift.
//
// This operation is used with the Amazon GameLift FleetIQ solution and game
// server groups.
//
// Retrieves information for a registered game server. Information includes
// game server status, health check info, and the instance that the game server
// is running on.
//
// To retrieve game server information, specify the game server ID. If successful,
// the requested game server object is returned.
//
// # Learn more
//
// Amazon GameLift FleetIQ Guide (https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeGameServer for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameServer
func (c *GameLift) DescribeGameServer(input *DescribeGameServerInput) (*DescribeGameServerOutput, error) {
	req, out := c.DescribeGameServerRequest(input)
	return out, req.Send()
}

// DescribeGameServerWithContext is the same as DescribeGameServer with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGameServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeGameServerWithContext(ctx aws.Context, input *DescribeGameServerInput, opts ...request.Option) (*DescribeGameServerOutput, error) {
	req, out := c.DescribeGameServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGameServerGroup = "DescribeGameServerGroup"

// DescribeGameServerGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGameServerGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGameServerGroup for more information on using the DescribeGameServerGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeGameServerGroupRequest method.
//	req, resp := client.DescribeGameServerGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameServerGroup
func (c *GameLift) DescribeGameServerGroupRequest(input *DescribeGameServerGroupInput) (req *request.Request, output *DescribeGameServerGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeGameServerGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeGameServerGroupInput{}
	}

	output = &DescribeGameServerGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGameServerGroup API operation for Amazon GameLift.
//
// This operation is used with the Amazon GameLift FleetIQ solution and game
// server groups.
//
// Retrieves information on a game server group. This operation returns only
// properties related to Amazon GameLift FleetIQ. To view or update properties
// for the corresponding Auto Scaling group, such as launch template, auto scaling
// policies, and maximum/minimum group size, access the Auto Scaling group directly.
//
// To get attributes for a game server group, provide a group name or ARN value.
// If successful, a GameServerGroup object is returned.
//
// # Learn more
//
// Amazon GameLift FleetIQ Guide (https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeGameServerGroup for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameServerGroup
func (c *GameLift) DescribeGameServerGroup(input *DescribeGameServerGroupInput) (*DescribeGameServerGroupOutput, error) {
	req, out := c.DescribeGameServerGroupRequest(input)
	return out, req.Send()
}

// DescribeGameServerGroupWithContext is the same as DescribeGameServerGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGameServerGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeGameServerGroupWithContext(ctx aws.Context, input *DescribeGameServerGroupInput, opts ...request.Option) (*DescribeGameServerGroupOutput, error) {
	req, out := c.DescribeGameServerGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGameServerInstances = "DescribeGameServerInstances"

// DescribeGameServerInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGameServerInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGameServerInstances for more information on using the DescribeGameServerInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeGameServerInstancesRequest method.
//	req, resp := client.DescribeGameServerInstancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameServerInstances
func (c *GameLift) DescribeGameServerInstancesRequest(input *DescribeGameServerInstancesInput) (req *request.Request, output *DescribeGameServerInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeGameServerInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeGameServerInstancesInput{}
	}

	output = &DescribeGameServerInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGameServerInstances API operation for Amazon GameLift.
//
// This operation is used with the Amazon GameLift FleetIQ solution and game
// server groups.
//
// Retrieves status information about the Amazon EC2 instances associated with
// a Amazon GameLift FleetIQ game server group. Use this operation to detect
// when instances are active or not available to host new game servers.
//
// To request status for all instances in the game server group, provide a game
// server group ID only. To request status for specific instances, provide the
// game server group ID and one or more instance IDs. Use the pagination parameters
// to retrieve results in sequential segments. If successful, a collection of
// GameServerInstance objects is returned.
//
// This operation is not designed to be called with every game server claim
// request; this practice can cause you to exceed your API limit, which results
// in errors. Instead, as a best practice, cache the results and refresh your
// cache no more than once every 10 seconds.
//
// # Learn more
//
// Amazon GameLift FleetIQ Guide (https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeGameServerInstances for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameServerInstances
func (c *GameLift) DescribeGameServerInstances(input *DescribeGameServerInstancesInput) (*DescribeGameServerInstancesOutput, error) {
	req, out := c.DescribeGameServerInstancesRequest(input)
	return out, req.Send()
}

// DescribeGameServerInstancesWithContext is the same as DescribeGameServerInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGameServerInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeGameServerInstancesWithContext(ctx aws.Context, input *DescribeGameServerInstancesInput, opts ...request.Option) (*DescribeGameServerInstancesOutput, error) {
	req, out := c.DescribeGameServerInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeGameServerInstancesPages iterates over the pages of a DescribeGameServerInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeGameServerInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeGameServerInstances operation.
//	pageNum := 0
//	err := client.DescribeGameServerInstancesPages(params,
//	    func(page *gamelift.DescribeGameServerInstancesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GameLift) DescribeGameServerInstancesPages(input *DescribeGameServerInstancesInput, fn func(*DescribeGameServerInstancesOutput, bool) bool) error {
	return c.DescribeGameServerInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeGameServerInstancesPagesWithContext same as DescribeGameServerInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeGameServerInstancesPagesWithContext(ctx aws.Context, input *DescribeGameServerInstancesInput, fn func(*DescribeGameServerInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeGameServerInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeGameServerInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeGameServerInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeGameSessionDetails = "DescribeGameSessionDetails"

// DescribeGameSessionDetailsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGameSessionDetails operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGameSessionDetails for more information on using the DescribeGameSessionDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeGameSessionDetailsRequest method.
//	req, resp := client.DescribeGameSessionDetailsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionDetails
func (c *GameLift) DescribeGameSessionDetailsRequest(input *DescribeGameSessionDetailsInput) (req *request.Request, output *DescribeGameSessionDetailsOutput) {
	op := &request.Operation{
		Name:       opDescribeGameSessionDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeGameSessionDetailsInput{}
	}

	output = &DescribeGameSessionDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGameSessionDetails API operation for Amazon GameLift.
//
// Retrieves additional game session properties, including the game session
// protection policy in force, a set of one or more game sessions in a specific
// fleet location. You can optionally filter the results by current game session
// status.
//
// This operation can be used in the following ways:
//
//   - To retrieve details for all game sessions that are currently running
//     on all locations in a fleet, provide a fleet or alias ID, with an optional
//     status filter. This approach returns details from the fleet's home Region
//     and all remote locations.
//
//   - To retrieve details for all game sessions that are currently running
//     on a specific fleet location, provide a fleet or alias ID and a location
//     name, with optional status filter. The location can be the fleet's home
//     Region or any remote location.
//
//   - To retrieve details for a specific game session, provide the game session
//     ID. This approach looks for the game session ID in all fleets that reside
//     in the Amazon Web Services Region defined in the request.
//
// Use the pagination parameters to retrieve results as a set of sequential
// pages.
//
// If successful, a GameSessionDetail object is returned for each game session
// that matches the request.
//
// # Learn more
//
// Find a game session (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#gamelift-sdk-client-api-find)
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeGameSessionDetails for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - TerminalRoutingStrategyException
//     The service is unable to resolve the routing for a particular alias because
//     it has a terminal RoutingStrategy associated with it. The message returned
//     in this exception is the message defined in the routing strategy itself.
//     Such requests should only be retried if the routing strategy for the specified
//     alias is modified.
//
//   - UnsupportedRegionException
//     The requested operation is not supported in the Region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionDetails
func (c *GameLift) DescribeGameSessionDetails(input *DescribeGameSessionDetailsInput) (*DescribeGameSessionDetailsOutput, error) {
	req, out := c.DescribeGameSessionDetailsRequest(input)
	return out, req.Send()
}

// DescribeGameSessionDetailsWithContext is the same as DescribeGameSessionDetails with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGameSessionDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeGameSessionDetailsWithContext(ctx aws.Context, input *DescribeGameSessionDetailsInput, opts ...request.Option) (*DescribeGameSessionDetailsOutput, error) {
	req, out := c.DescribeGameSessionDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeGameSessionDetailsPages iterates over the pages of a DescribeGameSessionDetails operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeGameSessionDetails method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeGameSessionDetails operation.
//	pageNum := 0
//	err := client.DescribeGameSessionDetailsPages(params,
//	    func(page *gamelift.DescribeGameSessionDetailsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GameLift) DescribeGameSessionDetailsPages(input *DescribeGameSessionDetailsInput, fn func(*DescribeGameSessionDetailsOutput, bool) bool) error {
	return c.DescribeGameSessionDetailsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeGameSessionDetailsPagesWithContext same as DescribeGameSessionDetailsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeGameSessionDetailsPagesWithContext(ctx aws.Context, input *DescribeGameSessionDetailsInput, fn func(*DescribeGameSessionDetailsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeGameSessionDetailsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeGameSessionDetailsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeGameSessionDetailsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeGameSessionPlacement = "DescribeGameSessionPlacement"

// DescribeGameSessionPlacementRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGameSessionPlacement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGameSessionPlacement for more information on using the DescribeGameSessionPlacement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeGameSessionPlacementRequest method.
//	req, resp := client.DescribeGameSessionPlacementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionPlacement
func (c *GameLift) DescribeGameSessionPlacementRequest(input *DescribeGameSessionPlacementInput) (req *request.Request, output *DescribeGameSessionPlacementOutput) {
	op := &request.Operation{
		Name:       opDescribeGameSessionPlacement,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeGameSessionPlacementInput{}
	}

	output = &DescribeGameSessionPlacementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGameSessionPlacement API operation for Amazon GameLift.
//
// Retrieves information, including current status, about a game session placement
// request.
//
// To get game session placement details, specify the placement ID.
//
// This operation is not designed to be continually called to track game session
// status. This practice can cause you to exceed your API limit, which results
// in errors. Instead, you must configure configure an Amazon Simple Notification
// Service (SNS) topic to receive notifications from FlexMatch or queues. Continuously
// polling with DescribeGameSessionPlacement should only be used for games in
// development with low game session usage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeGameSessionPlacement for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionPlacement
func (c *GameLift) DescribeGameSessionPlacement(input *DescribeGameSessionPlacementInput) (*DescribeGameSessionPlacementOutput, error) {
	req, out := c.DescribeGameSessionPlacementRequest(input)
	return out, req.Send()
}

// DescribeGameSessionPlacementWithContext is the same as DescribeGameSessionPlacement with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGameSessionPlacement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeGameSessionPlacementWithContext(ctx aws.Context, input *DescribeGameSessionPlacementInput, opts ...request.Option) (*DescribeGameSessionPlacementOutput, error) {
	req, out := c.DescribeGameSessionPlacementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGameSessionQueues = "DescribeGameSessionQueues"

// DescribeGameSessionQueuesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGameSessionQueues operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGameSessionQueues for more information on using the DescribeGameSessionQueues
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeGameSessionQueuesRequest method.
//	req, resp := client.DescribeGameSessionQueuesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionQueues
func (c *GameLift) DescribeGameSessionQueuesRequest(input *DescribeGameSessionQueuesInput) (req *request.Request, output *DescribeGameSessionQueuesOutput) {
	op := &request.Operation{
		Name:       opDescribeGameSessionQueues,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeGameSessionQueuesInput{}
	}

	output = &DescribeGameSessionQueuesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGameSessionQueues API operation for Amazon GameLift.
//
// Retrieves the properties for one or more game session queues. When requesting
// multiple queues, use the pagination parameters to retrieve results as a set
// of sequential pages. When specifying a list of queues, objects are returned
// only for queues that currently exist in the Region.
//
// Learn more
//
//	View Your Queues (https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-console.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeGameSessionQueues for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionQueues
func (c *GameLift) DescribeGameSessionQueues(input *DescribeGameSessionQueuesInput) (*DescribeGameSessionQueuesOutput, error) {
	req, out := c.DescribeGameSessionQueuesRequest(input)
	return out, req.Send()
}

// DescribeGameSessionQueuesWithContext is the same as DescribeGameSessionQueues with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGameSessionQueues for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeGameSessionQueuesWithContext(ctx aws.Context, input *DescribeGameSessionQueuesInput, opts ...request.Option) (*DescribeGameSessionQueuesOutput, error) {
	req, out := c.DescribeGameSessionQueuesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeGameSessionQueuesPages iterates over the pages of a DescribeGameSessionQueues operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeGameSessionQueues method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeGameSessionQueues operation.
//	pageNum := 0
//	err := client.DescribeGameSessionQueuesPages(params,
//	    func(page *gamelift.DescribeGameSessionQueuesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GameLift) DescribeGameSessionQueuesPages(input *DescribeGameSessionQueuesInput, fn func(*DescribeGameSessionQueuesOutput, bool) bool) error {
	return c.DescribeGameSessionQueuesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeGameSessionQueuesPagesWithContext same as DescribeGameSessionQueuesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeGameSessionQueuesPagesWithContext(ctx aws.Context, input *DescribeGameSessionQueuesInput, fn func(*DescribeGameSessionQueuesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeGameSessionQueuesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeGameSessionQueuesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeGameSessionQueuesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeGameSessions = "DescribeGameSessions"

// DescribeGameSessionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGameSessions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGameSessions for more information on using the DescribeGameSessions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeGameSessionsRequest method.
//	req, resp := client.DescribeGameSessionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessions
func (c *GameLift) DescribeGameSessionsRequest(input *DescribeGameSessionsInput) (req *request.Request, output *DescribeGameSessionsOutput) {
	op := &request.Operation{
		Name:       opDescribeGameSessions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeGameSessionsInput{}
	}

	output = &DescribeGameSessionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGameSessions API operation for Amazon GameLift.
//
// Retrieves a set of one or more game sessions in a specific fleet location.
// You can optionally filter the results by current game session status.
//
// This operation can be used in the following ways:
//
//   - To retrieve all game sessions that are currently running on all locations
//     in a fleet, provide a fleet or alias ID, with an optional status filter.
//     This approach returns all game sessions in the fleet's home Region and
//     all remote locations.
//
//   - To retrieve all game sessions that are currently running on a specific
//     fleet location, provide a fleet or alias ID and a location name, with
//     optional status filter. The location can be the fleet's home Region or
//     any remote location.
//
//   - To retrieve a specific game session, provide the game session ID. This
//     approach looks for the game session ID in all fleets that reside in the
//     Amazon Web Services Region defined in the request.
//
// Use the pagination parameters to retrieve results as a set of sequential
// pages.
//
// If successful, a GameSession object is returned for each game session that
// matches the request.
//
// This operation is not designed to be continually called to track game session
// status. This practice can cause you to exceed your API limit, which results
// in errors. Instead, you must configure an Amazon Simple Notification Service
// (SNS) topic to receive notifications from FlexMatch or queues. Continuously
// polling with DescribeGameSessions should only be used for games in development
// with low game session usage.
//
// Available in Amazon GameLift Local.
//
// # Learn more
//
// Find a game session (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#gamelift-sdk-client-api-find)
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeGameSessions for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - TerminalRoutingStrategyException
//     The service is unable to resolve the routing for a particular alias because
//     it has a terminal RoutingStrategy associated with it. The message returned
//     in this exception is the message defined in the routing strategy itself.
//     Such requests should only be retried if the routing strategy for the specified
//     alias is modified.
//
//   - UnsupportedRegionException
//     The requested operation is not supported in the Region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessions
func (c *GameLift) DescribeGameSessions(input *DescribeGameSessionsInput) (*DescribeGameSessionsOutput, error) {
	req, out := c.DescribeGameSessionsRequest(input)
	return out, req.Send()
}

// DescribeGameSessionsWithContext is the same as DescribeGameSessions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGameSessions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeGameSessionsWithContext(ctx aws.Context, input *DescribeGameSessionsInput, opts ...request.Option) (*DescribeGameSessionsOutput, error) {
	req, out := c.DescribeGameSessionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeGameSessionsPages iterates over the pages of a DescribeGameSessions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeGameSessions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeGameSessions operation.
//	pageNum := 0
//	err := client.DescribeGameSessionsPages(params,
//	    func(page *gamelift.DescribeGameSessionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GameLift) DescribeGameSessionsPages(input *DescribeGameSessionsInput, fn func(*DescribeGameSessionsOutput, bool) bool) error {
	return c.DescribeGameSessionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeGameSessionsPagesWithContext same as DescribeGameSessionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeGameSessionsPagesWithContext(ctx aws.Context, input *DescribeGameSessionsInput, fn func(*DescribeGameSessionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeGameSessionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeGameSessionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeGameSessionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeInstances = "DescribeInstances"

// DescribeInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstances for more information on using the DescribeInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeInstancesRequest method.
//	req, resp := client.DescribeInstancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeInstances
func (c *GameLift) DescribeInstancesRequest(input *DescribeInstancesInput) (req *request.Request, output *DescribeInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeInstancesInput{}
	}

	output = &DescribeInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstances API operation for Amazon GameLift.
//
// Retrieves information about the EC2 instances in an Amazon GameLift managed
// fleet, including instance ID, connection data, and status. You can use this
// operation with a multi-location fleet to get location-specific instance information.
// As an alternative, use the operations ListCompute and DescribeCompute to
// retrieve information for compute resources, including EC2 and Anywhere fleets.
//
// You can call this operation in the following ways:
//
//   - To get information on all instances in a fleet's home Region, specify
//     the fleet ID.
//
//   - To get information on all instances in a fleet's remote location, specify
//     the fleet ID and location name.
//
//   - To get information on a specific instance in a fleet, specify the fleet
//     ID and instance ID.
//
// Use the pagination parameters to retrieve results as a set of sequential
// pages.
//
// If successful, this operation returns Instance objects for each requested
// instance, listed in no particular order. If you call this operation for an
// Anywhere fleet, you receive an InvalidRequestException.
//
// # Learn more
//
// Remotely connect to fleet instances (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-remote-access.html)
//
// Debug fleet issues (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html)
//
// # Related actions
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeInstances for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - UnsupportedRegionException
//     The requested operation is not supported in the Region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeInstances
func (c *GameLift) DescribeInstances(input *DescribeInstancesInput) (*DescribeInstancesOutput, error) {
	req, out := c.DescribeInstancesRequest(input)
	return out, req.Send()
}

// DescribeInstancesWithContext is the same as DescribeInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeInstancesWithContext(ctx aws.Context, input *DescribeInstancesInput, opts ...request.Option) (*DescribeInstancesOutput, error) {
	req, out := c.DescribeInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeInstancesPages iterates over the pages of a DescribeInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeInstances operation.
//	pageNum := 0
//	err := client.DescribeInstancesPages(params,
//	    func(page *gamelift.DescribeInstancesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GameLift) DescribeInstancesPages(input *DescribeInstancesInput, fn func(*DescribeInstancesOutput, bool) bool) error {
	return c.DescribeInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeInstancesPagesWithContext same as DescribeInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeInstancesPagesWithContext(ctx aws.Context, input *DescribeInstancesInput, fn func(*DescribeInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeMatchmaking = "DescribeMatchmaking"

// DescribeMatchmakingRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMatchmaking operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMatchmaking for more information on using the DescribeMatchmaking
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeMatchmakingRequest method.
//	req, resp := client.DescribeMatchmakingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmaking
func (c *GameLift) DescribeMatchmakingRequest(input *DescribeMatchmakingInput) (req *request.Request, output *DescribeMatchmakingOutput) {
	op := &request.Operation{
		Name:       opDescribeMatchmaking,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMatchmakingInput{}
	}

	output = &DescribeMatchmakingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMatchmaking API operation for Amazon GameLift.
//
// Retrieves one or more matchmaking tickets. Use this operation to retrieve
// ticket information, including--after a successful match is made--connection
// information for the resulting new game session.
//
// To request matchmaking tickets, provide a list of up to 10 ticket IDs. If
// the request is successful, a ticket object is returned for each requested
// ID that currently exists.
//
// This operation is not designed to be continually called to track matchmaking
// ticket status. This practice can cause you to exceed your API limit, which
// results in errors. Instead, as a best practice, set up an Amazon Simple Notification
// Service to receive notifications, and provide the topic ARN in the matchmaking
// configuration.
//
// Learn more
//
//	Add FlexMatch to a game client (https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-client.html)
//
//	Set Up FlexMatch event notification (https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeMatchmaking for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - UnsupportedRegionException
//     The requested operation is not supported in the Region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmaking
func (c *GameLift) DescribeMatchmaking(input *DescribeMatchmakingInput) (*DescribeMatchmakingOutput, error) {
	req, out := c.DescribeMatchmakingRequest(input)
	return out, req.Send()
}

// DescribeMatchmakingWithContext is the same as DescribeMatchmaking with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMatchmaking for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeMatchmakingWithContext(ctx aws.Context, input *DescribeMatchmakingInput, opts ...request.Option) (*DescribeMatchmakingOutput, error) {
	req, out := c.DescribeMatchmakingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMatchmakingConfigurations = "DescribeMatchmakingConfigurations"

// DescribeMatchmakingConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMatchmakingConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMatchmakingConfigurations for more information on using the DescribeMatchmakingConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeMatchmakingConfigurationsRequest method.
//	req, resp := client.DescribeMatchmakingConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingConfigurations
func (c *GameLift) DescribeMatchmakingConfigurationsRequest(input *DescribeMatchmakingConfigurationsInput) (req *request.Request, output *DescribeMatchmakingConfigurationsOutput) {
	op := &request.Operation{
		Name:       opDescribeMatchmakingConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeMatchmakingConfigurationsInput{}
	}

	output = &DescribeMatchmakingConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMatchmakingConfigurations API operation for Amazon GameLift.
//
// Retrieves the details of FlexMatch matchmaking configurations.
//
// This operation offers the following options: (1) retrieve all matchmaking
// configurations, (2) retrieve configurations for a specified list, or (3)
// retrieve all configurations that use a specified rule set name. When requesting
// multiple items, use the pagination parameters to retrieve results as a set
// of sequential pages.
//
// If successful, a configuration is returned for each requested name. When
// specifying a list of names, only configurations that currently exist are
// returned.
//
// Learn more
//
//	Setting up FlexMatch matchmakers (https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/matchmaker-build.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeMatchmakingConfigurations for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - UnsupportedRegionException
//     The requested operation is not supported in the Region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingConfigurations
func (c *GameLift) DescribeMatchmakingConfigurations(input *DescribeMatchmakingConfigurationsInput) (*DescribeMatchmakingConfigurationsOutput, error) {
	req, out := c.DescribeMatchmakingConfigurationsRequest(input)
	return out, req.Send()
}

// DescribeMatchmakingConfigurationsWithContext is the same as DescribeMatchmakingConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMatchmakingConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeMatchmakingConfigurationsWithContext(ctx aws.Context, input *DescribeMatchmakingConfigurationsInput, opts ...request.Option) (*DescribeMatchmakingConfigurationsOutput, error) {
	req, out := c.DescribeMatchmakingConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeMatchmakingConfigurationsPages iterates over the pages of a DescribeMatchmakingConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeMatchmakingConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeMatchmakingConfigurations operation.
//	pageNum := 0
//	err := client.DescribeMatchmakingConfigurationsPages(params,
//	    func(page *gamelift.DescribeMatchmakingConfigurationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GameLift) DescribeMatchmakingConfigurationsPages(input *DescribeMatchmakingConfigurationsInput, fn func(*DescribeMatchmakingConfigurationsOutput, bool) bool) error {
	return c.DescribeMatchmakingConfigurationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeMatchmakingConfigurationsPagesWithContext same as DescribeMatchmakingConfigurationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeMatchmakingConfigurationsPagesWithContext(ctx aws.Context, input *DescribeMatchmakingConfigurationsInput, fn func(*DescribeMatchmakingConfigurationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeMatchmakingConfigurationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeMatchmakingConfigurationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeMatchmakingConfigurationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeMatchmakingRuleSets = "DescribeMatchmakingRuleSets"

// DescribeMatchmakingRuleSetsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMatchmakingRuleSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMatchmakingRuleSets for more information on using the DescribeMatchmakingRuleSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeMatchmakingRuleSetsRequest method.
//	req, resp := client.DescribeMatchmakingRuleSetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingRuleSets
func (c *GameLift) DescribeMatchmakingRuleSetsRequest(input *DescribeMatchmakingRuleSetsInput) (req *request.Request, output *DescribeMatchmakingRuleSetsOutput) {
	op := &request.Operation{
		Name:       opDescribeMatchmakingRuleSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeMatchmakingRuleSetsInput{}
	}

	output = &DescribeMatchmakingRuleSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMatchmakingRuleSets API operation for Amazon GameLift.
//
// Retrieves the details for FlexMatch matchmaking rule sets. You can request
// all existing rule sets for the Region, or provide a list of one or more rule
// set names. When requesting multiple items, use the pagination parameters
// to retrieve results as a set of sequential pages. If successful, a rule set
// is returned for each requested name.
//
// Learn more
//
//   - Build a rule set (https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeMatchmakingRuleSets for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - UnsupportedRegionException
//     The requested operation is not supported in the Region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingRuleSets
func (c *GameLift) DescribeMatchmakingRuleSets(input *DescribeMatchmakingRuleSetsInput) (*DescribeMatchmakingRuleSetsOutput, error) {
	req, out := c.DescribeMatchmakingRuleSetsRequest(input)
	return out, req.Send()
}

// DescribeMatchmakingRuleSetsWithContext is the same as DescribeMatchmakingRuleSets with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMatchmakingRuleSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeMatchmakingRuleSetsWithContext(ctx aws.Context, input *DescribeMatchmakingRuleSetsInput, opts ...request.Option) (*DescribeMatchmakingRuleSetsOutput, error) {
	req, out := c.DescribeMatchmakingRuleSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeMatchmakingRuleSetsPages iterates over the pages of a DescribeMatchmakingRuleSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeMatchmakingRuleSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeMatchmakingRuleSets operation.
//	pageNum := 0
//	err := client.DescribeMatchmakingRuleSetsPages(params,
//	    func(page *gamelift.DescribeMatchmakingRuleSetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GameLift) DescribeMatchmakingRuleSetsPages(input *DescribeMatchmakingRuleSetsInput, fn func(*DescribeMatchmakingRuleSetsOutput, bool) bool) error {
	return c.DescribeMatchmakingRuleSetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeMatchmakingRuleSetsPagesWithContext same as DescribeMatchmakingRuleSetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeMatchmakingRuleSetsPagesWithContext(ctx aws.Context, input *DescribeMatchmakingRuleSetsInput, fn func(*DescribeMatchmakingRuleSetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeMatchmakingRuleSetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeMatchmakingRuleSetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeMatchmakingRuleSetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribePlayerSessions = "DescribePlayerSessions"

// DescribePlayerSessionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribePlayerSessions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePlayerSessions for more information on using the DescribePlayerSessions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribePlayerSessionsRequest method.
//	req, resp := client.DescribePlayerSessionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribePlayerSessions
func (c *GameLift) DescribePlayerSessionsRequest(input *DescribePlayerSessionsInput) (req *request.Request, output *DescribePlayerSessionsOutput) {
	op := &request.Operation{
		Name:       opDescribePlayerSessions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribePlayerSessionsInput{}
	}

	output = &DescribePlayerSessionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePlayerSessions API operation for Amazon GameLift.
//
// Retrieves properties for one or more player sessions.
//
// This action can be used in the following ways:
//
//   - To retrieve a specific player session, provide the player session ID
//     only.
//
//   - To retrieve all player sessions in a game session, provide the game
//     session ID only.
//
//   - To retrieve all player sessions for a specific player, provide a player
//     ID only.
//
// To request player sessions, specify either a player session ID, game session
// ID, or player ID. You can filter this request by player session status. If
// you provide a specific PlayerSessionId or PlayerId, Amazon GameLift ignores
// the filter criteria. Use the pagination parameters to retrieve results as
// a set of sequential pages.
//
// If successful, a PlayerSession object is returned for each session that matches
// the request.
//
// # Related actions
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribePlayerSessions for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribePlayerSessions
func (c *GameLift) DescribePlayerSessions(input *DescribePlayerSessionsInput) (*DescribePlayerSessionsOutput, error) {
	req, out := c.DescribePlayerSessionsRequest(input)
	return out, req.Send()
}

// DescribePlayerSessionsWithContext is the same as DescribePlayerSessions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePlayerSessions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribePlayerSessionsWithContext(ctx aws.Context, input *DescribePlayerSessionsInput, opts ...request.Option) (*DescribePlayerSessionsOutput, error) {
	req, out := c.DescribePlayerSessionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribePlayerSessionsPages iterates over the pages of a DescribePlayerSessions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribePlayerSessions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribePlayerSessions operation.
//	pageNum := 0
//	err := client.DescribePlayerSessionsPages(params,
//	    func(page *gamelift.DescribePlayerSessionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GameLift) DescribePlayerSessionsPages(input *DescribePlayerSessionsInput, fn func(*DescribePlayerSessionsOutput, bool) bool) error {
	return c.DescribePlayerSessionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribePlayerSessionsPagesWithContext same as DescribePlayerSessionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribePlayerSessionsPagesWithContext(ctx aws.Context, input *DescribePlayerSessionsInput, fn func(*DescribePlayerSessionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribePlayerSessionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribePlayerSessionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribePlayerSessionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeRuntimeConfiguration = "DescribeRuntimeConfiguration"

// DescribeRuntimeConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRuntimeConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRuntimeConfiguration for more information on using the DescribeRuntimeConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeRuntimeConfigurationRequest method.
//	req, resp := client.DescribeRuntimeConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeRuntimeConfiguration
func (c *GameLift) DescribeRuntimeConfigurationRequest(input *DescribeRuntimeConfigurationInput) (req *request.Request, output *DescribeRuntimeConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeRuntimeConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRuntimeConfigurationInput{}
	}

	output = &DescribeRuntimeConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRuntimeConfiguration API operation for Amazon GameLift.
//
// Retrieves a fleet's runtime configuration settings. The runtime configuration
// tells Amazon GameLift which server processes to run (and how) on each instance
// in the fleet.
//
// To get the runtime configuration that is currently in forces for a fleet,
// provide the fleet ID.
//
// If successful, a RuntimeConfiguration object is returned for the requested
// fleet. If the requested fleet has been deleted, the result set is empty.
//
// # Learn more
//
// Setting up Amazon GameLift fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
//
// Running multiple processes on a fleet (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-multiprocess.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeRuntimeConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeRuntimeConfiguration
func (c *GameLift) DescribeRuntimeConfiguration(input *DescribeRuntimeConfigurationInput) (*DescribeRuntimeConfigurationOutput, error) {
	req, out := c.DescribeRuntimeConfigurationRequest(input)
	return out, req.Send()
}

// DescribeRuntimeConfigurationWithContext is the same as DescribeRuntimeConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRuntimeConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeRuntimeConfigurationWithContext(ctx aws.Context, input *DescribeRuntimeConfigurationInput, opts ...request.Option) (*DescribeRuntimeConfigurationOutput, error) {
	req, out := c.DescribeRuntimeConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeScalingPolicies = "DescribeScalingPolicies"

// DescribeScalingPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScalingPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeScalingPolicies for more information on using the DescribeScalingPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeScalingPoliciesRequest method.
//	req, resp := client.DescribeScalingPoliciesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeScalingPolicies
func (c *GameLift) DescribeScalingPoliciesRequest(input *DescribeScalingPoliciesInput) (req *request.Request, output *DescribeScalingPoliciesOutput) {
	op := &request.Operation{
		Name:       opDescribeScalingPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeScalingPoliciesInput{}
	}

	output = &DescribeScalingPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeScalingPolicies API operation for Amazon GameLift.
//
// Retrieves all scaling policies applied to a fleet.
//
// To get a fleet's scaling policies, specify the fleet ID. You can filter this
// request by policy status, such as to retrieve only active scaling policies.
// Use the pagination parameters to retrieve results as a set of sequential
// pages. If successful, set of ScalingPolicy objects is returned for the fleet.
//
// A fleet may have all of its scaling policies suspended. This operation does
// not affect the status of the scaling policies, which remains ACTIVE.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeScalingPolicies for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - UnsupportedRegionException
//     The requested operation is not supported in the Region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeScalingPolicies
func (c *GameLift) DescribeScalingPolicies(input *DescribeScalingPoliciesInput) (*DescribeScalingPoliciesOutput, error) {
	req, out := c.DescribeScalingPoliciesRequest(input)
	return out, req.Send()
}

// DescribeScalingPoliciesWithContext is the same as DescribeScalingPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeScalingPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeScalingPoliciesWithContext(ctx aws.Context, input *DescribeScalingPoliciesInput, opts ...request.Option) (*DescribeScalingPoliciesOutput, error) {
	req, out := c.DescribeScalingPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeScalingPoliciesPages iterates over the pages of a DescribeScalingPolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeScalingPolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeScalingPolicies operation.
//	pageNum := 0
//	err := client.DescribeScalingPoliciesPages(params,
//	    func(page *gamelift.DescribeScalingPoliciesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GameLift) DescribeScalingPoliciesPages(input *DescribeScalingPoliciesInput, fn func(*DescribeScalingPoliciesOutput, bool) bool) error {
	return c.DescribeScalingPoliciesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeScalingPoliciesPagesWithContext same as DescribeScalingPoliciesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeScalingPoliciesPagesWithContext(ctx aws.Context, input *DescribeScalingPoliciesInput, fn func(*DescribeScalingPoliciesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeScalingPoliciesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeScalingPoliciesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeScalingPoliciesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeScript = "DescribeScript"

// DescribeScriptRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScript operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeScript for more information on using the DescribeScript
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeScriptRequest method.
//	req, resp := client.DescribeScriptRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeScript
func (c *GameLift) DescribeScriptRequest(input *DescribeScriptInput) (req *request.Request, output *DescribeScriptOutput) {
	op := &request.Operation{
		Name:       opDescribeScript,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeScriptInput{}
	}

	output = &DescribeScriptOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeScript API operation for Amazon GameLift.
//
// Retrieves properties for a Realtime script.
//
// To request a script record, specify the script ID. If successful, an object
// containing the script properties is returned.
//
// # Learn more
//
// Amazon GameLift Realtime Servers (https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html)
//
// # Related actions
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeScript for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeScript
func (c *GameLift) DescribeScript(input *DescribeScriptInput) (*DescribeScriptOutput, error) {
	req, out := c.DescribeScriptRequest(input)
	return out, req.Send()
}

// DescribeScriptWithContext is the same as DescribeScript with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeScript for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeScriptWithContext(ctx aws.Context, input *DescribeScriptInput, opts ...request.Option) (*DescribeScriptOutput, error) {
	req, out := c.DescribeScriptRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeVpcPeeringAuthorizations = "DescribeVpcPeeringAuthorizations"

// DescribeVpcPeeringAuthorizationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVpcPeeringAuthorizations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeVpcPeeringAuthorizations for more information on using the DescribeVpcPeeringAuthorizations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeVpcPeeringAuthorizationsRequest method.
//	req, resp := client.DescribeVpcPeeringAuthorizationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeVpcPeeringAuthorizations
func (c *GameLift) DescribeVpcPeeringAuthorizationsRequest(input *DescribeVpcPeeringAuthorizationsInput) (req *request.Request, output *DescribeVpcPeeringAuthorizationsOutput) {
	op := &request.Operation{
		Name:       opDescribeVpcPeeringAuthorizations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVpcPeeringAuthorizationsInput{}
	}

	output = &DescribeVpcPeeringAuthorizationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVpcPeeringAuthorizations API operation for Amazon GameLift.
//
// Retrieves valid VPC peering authorizations that are pending for the Amazon
// Web Services account. This operation returns all VPC peering authorizations
// and requests for peering. This includes those initiated and received by this
// account.
//
// # Related actions
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeVpcPeeringAuthorizations for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeVpcPeeringAuthorizations
func (c *GameLift) DescribeVpcPeeringAuthorizations(input *DescribeVpcPeeringAuthorizationsInput) (*DescribeVpcPeeringAuthorizationsOutput, error) {
	req, out := c.DescribeVpcPeeringAuthorizationsRequest(input)
	return out, req.Send()
}

// DescribeVpcPeeringAuthorizationsWithContext is the same as DescribeVpcPeeringAuthorizations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeVpcPeeringAuthorizations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeVpcPeeringAuthorizationsWithContext(ctx aws.Context, input *DescribeVpcPeeringAuthorizationsInput, opts ...request.Option) (*DescribeVpcPeeringAuthorizationsOutput, error) {
	req, out := c.DescribeVpcPeeringAuthorizationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeVpcPeeringConnections = "DescribeVpcPeeringConnections"

// DescribeVpcPeeringConnectionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVpcPeeringConnections operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeVpcPeeringConnections for more information on using the DescribeVpcPeeringConnections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeVpcPeeringConnectionsRequest method.
//	req, resp := client.DescribeVpcPeeringConnectionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeVpcPeeringConnections
func (c *GameLift) DescribeVpcPeeringConnectionsRequest(input *DescribeVpcPeeringConnectionsInput) (req *request.Request, output *DescribeVpcPeeringConnectionsOutput) {
	op := &request.Operation{
		Name:       opDescribeVpcPeeringConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVpcPeeringConnectionsInput{}
	}

	output = &DescribeVpcPeeringConnectionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVpcPeeringConnections API operation for Amazon GameLift.
//
// Retrieves information on VPC peering connections. Use this operation to get
// peering information for all fleets or for one specific fleet ID.
//
// To retrieve connection information, call this operation from the Amazon Web
// Services account that is used to manage the Amazon GameLift fleets. Specify
// a fleet ID or leave the parameter empty to retrieve all connection records.
// If successful, the retrieved information includes both active and pending
// connections. Active connections identify the IpV4 CIDR block that the VPC
// uses to connect.
//
// # Related actions
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation DescribeVpcPeeringConnections for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeVpcPeeringConnections
func (c *GameLift) DescribeVpcPeeringConnections(input *DescribeVpcPeeringConnectionsInput) (*DescribeVpcPeeringConnectionsOutput, error) {
	req, out := c.DescribeVpcPeeringConnectionsRequest(input)
	return out, req.Send()
}

// DescribeVpcPeeringConnectionsWithContext is the same as DescribeVpcPeeringConnections with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeVpcPeeringConnections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) DescribeVpcPeeringConnectionsWithContext(ctx aws.Context, input *DescribeVpcPeeringConnectionsInput, opts ...request.Option) (*DescribeVpcPeeringConnectionsOutput, error) {
	req, out := c.DescribeVpcPeeringConnectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetComputeAccess = "GetComputeAccess"

// GetComputeAccessRequest generates a "aws/request.Request" representing the
// client's request for the GetComputeAccess operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetComputeAccess for more information on using the GetComputeAccess
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetComputeAccessRequest method.
//	req, resp := client.GetComputeAccessRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetComputeAccess
func (c *GameLift) GetComputeAccessRequest(input *GetComputeAccessInput) (req *request.Request, output *GetComputeAccessOutput) {
	op := &request.Operation{
		Name:       opGetComputeAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetComputeAccessInput{}
	}

	output = &GetComputeAccessOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetComputeAccess API operation for Amazon GameLift.
//
// Requests authorization to remotely connect to a compute resource in an Amazon
// GameLift fleet. Call this action to connect to an instance in a managed EC2
// fleet if the fleet's game build uses Amazon GameLift server SDK 5.x or later.
// To connect to instances with game builds that use server SDK 4.x or earlier,
// call GetInstanceAccess.
//
// To request access to a compute, identify the specific EC2 instance and the
// fleet it belongs to. You can retrieve instances for a managed EC2 fleet by
// calling ListCompute.
//
// If successful, this operation returns a set of temporary Amazon Web Services
// credentials, including a two-part access key and a session token. Use these
// credentials with Amazon EC2 Systems Manager (SSM) to start a session with
// the compute. For more details, see Starting a session (CLI) (https://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-working-with-sessions-start.html#sessions-start-cli)
// in the Amazon EC2 Systems Manager User Guide.
//
// # Learn more
//
// Remotely connect to fleet instances (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-remote-access.html)
//
// Debug fleet issues (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation GetComputeAccess for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetComputeAccess
func (c *GameLift) GetComputeAccess(input *GetComputeAccessInput) (*GetComputeAccessOutput, error) {
	req, out := c.GetComputeAccessRequest(input)
	return out, req.Send()
}

// GetComputeAccessWithContext is the same as GetComputeAccess with the addition of
// the ability to pass a context and additional request options.
//
// See GetComputeAccess for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) GetComputeAccessWithContext(ctx aws.Context, input *GetComputeAccessInput, opts ...request.Option) (*GetComputeAccessOutput, error) {
	req, out := c.GetComputeAccessRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetComputeAuthToken = "GetComputeAuthToken"

// GetComputeAuthTokenRequest generates a "aws/request.Request" representing the
// client's request for the GetComputeAuthToken operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetComputeAuthToken for more information on using the GetComputeAuthToken
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetComputeAuthTokenRequest method.
//	req, resp := client.GetComputeAuthTokenRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetComputeAuthToken
func (c *GameLift) GetComputeAuthTokenRequest(input *GetComputeAuthTokenInput) (req *request.Request, output *GetComputeAuthTokenOutput) {
	op := &request.Operation{
		Name:       opGetComputeAuthToken,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetComputeAuthTokenInput{}
	}

	output = &GetComputeAuthTokenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetComputeAuthToken API operation for Amazon GameLift.
//
// Requests an authentication token from Amazon GameLift for a registered compute
// in an Anywhere fleet. The game servers that are running on the compute use
// this token to authenticate with the Amazon GameLift service. Each server
// process must provide a valid authentication token in its call to the Amazon
// GameLift server SDK action InitSDK().
//
// Authentication tokens are valid for a limited time span. Use a mechanism
// to regularly request a fresh authentication token before the current token
// expires.
//
// Learn more
//
//   - Create an Anywhere fleet (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-anywhere.html)
//
//   - Test your integration (https://docs.aws.amazon.com/gamelift/latest/developerguide/integration-testing.html)
//
//   - Server SDK reference guides (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk.html)
//     (for version 5.x)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation GetComputeAuthToken for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetComputeAuthToken
func (c *GameLift) GetComputeAuthToken(input *GetComputeAuthTokenInput) (*GetComputeAuthTokenOutput, error) {
	req, out := c.GetComputeAuthTokenRequest(input)
	return out, req.Send()
}

// GetComputeAuthTokenWithContext is the same as GetComputeAuthToken with the addition of
// the ability to pass a context and additional request options.
//
// See GetComputeAuthToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) GetComputeAuthTokenWithContext(ctx aws.Context, input *GetComputeAuthTokenInput, opts ...request.Option) (*GetComputeAuthTokenOutput, error) {
	req, out := c.GetComputeAuthTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGameSessionLogUrl = "GetGameSessionLogUrl"

// GetGameSessionLogUrlRequest generates a "aws/request.Request" representing the
// client's request for the GetGameSessionLogUrl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGameSessionLogUrl for more information on using the GetGameSessionLogUrl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetGameSessionLogUrlRequest method.
//	req, resp := client.GetGameSessionLogUrlRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetGameSessionLogUrl
func (c *GameLift) GetGameSessionLogUrlRequest(input *GetGameSessionLogUrlInput) (req *request.Request, output *GetGameSessionLogUrlOutput) {
	op := &request.Operation{
		Name:       opGetGameSessionLogUrl,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetGameSessionLogUrlInput{}
	}

	output = &GetGameSessionLogUrlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGameSessionLogUrl API operation for Amazon GameLift.
//
// Retrieves the location of stored game session logs for a specified game session
// on Amazon GameLift managed fleets. When a game session is terminated, Amazon
// GameLift automatically stores the logs in Amazon S3 and retains them for
// 14 days. Use this URL to download the logs.
//
// See the Amazon Web Services Service Limits (https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_gamelift)
// page for maximum log file sizes. Log files that exceed this limit are not
// saved.
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation GetGameSessionLogUrl for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetGameSessionLogUrl
func (c *GameLift) GetGameSessionLogUrl(input *GetGameSessionLogUrlInput) (*GetGameSessionLogUrlOutput, error) {
	req, out := c.GetGameSessionLogUrlRequest(input)
	return out, req.Send()
}

// GetGameSessionLogUrlWithContext is the same as GetGameSessionLogUrl with the addition of
// the ability to pass a context and additional request options.
//
// See GetGameSessionLogUrl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) GetGameSessionLogUrlWithContext(ctx aws.Context, input *GetGameSessionLogUrlInput, opts ...request.Option) (*GetGameSessionLogUrlOutput, error) {
	req, out := c.GetGameSessionLogUrlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInstanceAccess = "GetInstanceAccess"

// GetInstanceAccessRequest generates a "aws/request.Request" representing the
// client's request for the GetInstanceAccess operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInstanceAccess for more information on using the GetInstanceAccess
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetInstanceAccessRequest method.
//	req, resp := client.GetInstanceAccessRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetInstanceAccess
func (c *GameLift) GetInstanceAccessRequest(input *GetInstanceAccessInput) (req *request.Request, output *GetInstanceAccessOutput) {
	op := &request.Operation{
		Name:       opGetInstanceAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstanceAccessInput{}
	}

	output = &GetInstanceAccessOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstanceAccess API operation for Amazon GameLift.
//
// Requests authorization to remotely connect to an instance in an Amazon GameLift
// managed fleet. Use this operation to connect to instances with game servers
// that use Amazon GameLift server SDK 4.x or earlier. To connect to instances
// with game servers that use server SDK 5.x or later, call GetComputeAccess.
//
// To request access to an instance, specify IDs for the instance and the fleet
// it belongs to. You can retrieve instance IDs for a fleet by calling DescribeInstances
// (https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeInstances.html)
// with the fleet ID.
//
// If successful, this operation returns an IP address and credentials. The
// returned credentials match the operating system of the instance, as follows:
//
//   - For a Windows instance: returns a user name and secret (password) for
//     use with a Windows Remote Desktop client.
//
//   - For a Linux instance: returns a user name and secret (RSA private key)
//     for use with an SSH client. You must save the secret to a .pem file. If
//     you're using the CLI, see the example Get credentials for a Linux instance
//     (https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetInstanceAccess.html#API_GetInstanceAccess_Examples)
//     for tips on automatically saving the secret to a .pem file.
//
// # Learn more
//
// Remotely connect to fleet instances (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-remote-access.html)
//
// Debug fleet issues (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html)
//
// # Related actions
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation GetInstanceAccess for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetInstanceAccess
func (c *GameLift) GetInstanceAccess(input *GetInstanceAccessInput) (*GetInstanceAccessOutput, error) {
	req, out := c.GetInstanceAccessRequest(input)
	return out, req.Send()
}

// GetInstanceAccessWithContext is the same as GetInstanceAccess with the addition of
// the ability to pass a context and additional request options.
//
// See GetInstanceAccess for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) GetInstanceAccessWithContext(ctx aws.Context, input *GetInstanceAccessInput, opts ...request.Option) (*GetInstanceAccessOutput, error) {
	req, out := c.GetInstanceAccessRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAliases = "ListAliases"

// ListAliasesRequest generates a "aws/request.Request" representing the
// client's request for the ListAliases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAliases for more information on using the ListAliases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAliasesRequest method.
//	req, resp := client.ListAliasesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListAliases
func (c *GameLift) ListAliasesRequest(input *ListAliasesInput) (req *request.Request, output *ListAliasesOutput) {
	op := &request.Operation{
		Name:       opListAliases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAliasesInput{}
	}

	output = &ListAliasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAliases API operation for Amazon GameLift.
//
// Retrieves all aliases for this Amazon Web Services account. You can filter
// the result set by alias name and/or routing strategy type. Use the pagination
// parameters to retrieve results in sequential pages.
//
// Returned aliases are not listed in any particular order.
//
// # Related actions
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation ListAliases for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListAliases
func (c *GameLift) ListAliases(input *ListAliasesInput) (*ListAliasesOutput, error) {
	req, out := c.ListAliasesRequest(input)
	return out, req.Send()
}

// ListAliasesWithContext is the same as ListAliases with the addition of
// the ability to pass a context and additional request options.
//
// See ListAliases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) ListAliasesWithContext(ctx aws.Context, input *ListAliasesInput, opts ...request.Option) (*ListAliasesOutput, error) {
	req, out := c.ListAliasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAliasesPages iterates over the pages of a ListAliases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAliases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAliases operation.
//	pageNum := 0
//	err := client.ListAliasesPages(params,
//	    func(page *gamelift.ListAliasesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GameLift) ListAliasesPages(input *ListAliasesInput, fn func(*ListAliasesOutput, bool) bool) error {
	return c.ListAliasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAliasesPagesWithContext same as ListAliasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) ListAliasesPagesWithContext(ctx aws.Context, input *ListAliasesInput, fn func(*ListAliasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAliasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAliasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAliasesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListBuilds = "ListBuilds"

// ListBuildsRequest generates a "aws/request.Request" representing the
// client's request for the ListBuilds operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBuilds for more information on using the ListBuilds
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBuildsRequest method.
//	req, resp := client.ListBuildsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListBuilds
func (c *GameLift) ListBuildsRequest(input *ListBuildsInput) (req *request.Request, output *ListBuildsOutput) {
	op := &request.Operation{
		Name:       opListBuilds,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBuildsInput{}
	}

	output = &ListBuildsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBuilds API operation for Amazon GameLift.
//
// Retrieves build resources for all builds associated with the Amazon Web Services
// account in use. You can limit results to builds that are in a specific status
// by using the Status parameter. Use the pagination parameters to retrieve
// results in a set of sequential pages.
//
// Build resources are not listed in any particular order.
//
// Learn more
//
//	Upload a Custom Server Build (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html)
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation ListBuilds for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListBuilds
func (c *GameLift) ListBuilds(input *ListBuildsInput) (*ListBuildsOutput, error) {
	req, out := c.ListBuildsRequest(input)
	return out, req.Send()
}

// ListBuildsWithContext is the same as ListBuilds with the addition of
// the ability to pass a context and additional request options.
//
// See ListBuilds for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) ListBuildsWithContext(ctx aws.Context, input *ListBuildsInput, opts ...request.Option) (*ListBuildsOutput, error) {
	req, out := c.ListBuildsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBuildsPages iterates over the pages of a ListBuilds operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBuilds method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBuilds operation.
//	pageNum := 0
//	err := client.ListBuildsPages(params,
//	    func(page *gamelift.ListBuildsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GameLift) ListBuildsPages(input *ListBuildsInput, fn func(*ListBuildsOutput, bool) bool) error {
	return c.ListBuildsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBuildsPagesWithContext same as ListBuildsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) ListBuildsPagesWithContext(ctx aws.Context, input *ListBuildsInput, fn func(*ListBuildsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBuildsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBuildsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBuildsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCompute = "ListCompute"

// ListComputeRequest generates a "aws/request.Request" representing the
// client's request for the ListCompute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCompute for more information on using the ListCompute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListComputeRequest method.
//	req, resp := client.ListComputeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListCompute
func (c *GameLift) ListComputeRequest(input *ListComputeInput) (req *request.Request, output *ListComputeOutput) {
	op := &request.Operation{
		Name:       opListCompute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListComputeInput{}
	}

	output = &ListComputeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCompute API operation for Amazon GameLift.
//
// Retrieves the compute resources in an Amazon GameLift fleet. You can request
// information for either managed EC2 fleets or Anywhere fleets.
//
// To request a list of computes, specify the fleet ID. You can filter the result
// set by location. Use the pagination parameters to retrieve results in a set
// of sequential pages.
//
// If successful, this operation returns the compute resource for the requested
// fleet. For managed EC2 fleets, it returns a list of EC2 instances. For Anywhere
// fleets, it returns a list of registered compute names.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation ListCompute for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListCompute
func (c *GameLift) ListCompute(input *ListComputeInput) (*ListComputeOutput, error) {
	req, out := c.ListComputeRequest(input)
	return out, req.Send()
}

// ListComputeWithContext is the same as ListCompute with the addition of
// the ability to pass a context and additional request options.
//
// See ListCompute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) ListComputeWithContext(ctx aws.Context, input *ListComputeInput, opts ...request.Option) (*ListComputeOutput, error) {
	req, out := c.ListComputeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListComputePages iterates over the pages of a ListCompute operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCompute method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCompute operation.
//	pageNum := 0
//	err := client.ListComputePages(params,
//	    func(page *gamelift.ListComputeOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GameLift) ListComputePages(input *ListComputeInput, fn func(*ListComputeOutput, bool) bool) error {
	return c.ListComputePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListComputePagesWithContext same as ListComputePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) ListComputePagesWithContext(ctx aws.Context, input *ListComputeInput, fn func(*ListComputeOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListComputeInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListComputeRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListComputeOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFleets = "ListFleets"

// ListFleetsRequest generates a "aws/request.Request" representing the
// client's request for the ListFleets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFleets for more information on using the ListFleets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFleetsRequest method.
//	req, resp := client.ListFleetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListFleets
func (c *GameLift) ListFleetsRequest(input *ListFleetsInput) (req *request.Request, output *ListFleetsOutput) {
	op := &request.Operation{
		Name:       opListFleets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFleetsInput{}
	}

	output = &ListFleetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFleets API operation for Amazon GameLift.
//
// Retrieves a collection of fleet resources in an Amazon Web Services Region.
// You can call this operation to get fleets in a previously selected default
// Region (see https://docs.aws.amazon.com/credref/latest/refdocs/setting-global-region.html
// (https://docs.aws.amazon.com/credref/latest/refdocs/setting-global-region.html)or
// specify a Region in your request. You can filter the result set to find only
// those fleets that are deployed with a specific build or script. For fleets
// that have multiple locations, this operation retrieves fleets based on their
// home Region only.
//
// This operation can be used in the following ways:
//
//   - To get a list of all fleets in a Region, don't provide a build or script
//     identifier.
//
//   - To get a list of all fleets where a specific custom game build is deployed,
//     provide the build ID.
//
//   - To get a list of all Realtime Servers fleets with a specific configuration
//     script, provide the script ID.
//
// Use the pagination parameters to retrieve results as a set of sequential
// pages.
//
// If successful, a list of fleet IDs that match the request parameters is returned.
// A NextToken value is also returned if there are more result pages to retrieve.
//
// Fleet resources are not listed in a particular order.
//
// # Learn more
//
// Setting up Amazon GameLift fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation ListFleets for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListFleets
func (c *GameLift) ListFleets(input *ListFleetsInput) (*ListFleetsOutput, error) {
	req, out := c.ListFleetsRequest(input)
	return out, req.Send()
}

// ListFleetsWithContext is the same as ListFleets with the addition of
// the ability to pass a context and additional request options.
//
// See ListFleets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) ListFleetsWithContext(ctx aws.Context, input *ListFleetsInput, opts ...request.Option) (*ListFleetsOutput, error) {
	req, out := c.ListFleetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFleetsPages iterates over the pages of a ListFleets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFleets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFleets operation.
//	pageNum := 0
//	err := client.ListFleetsPages(params,
//	    func(page *gamelift.ListFleetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GameLift) ListFleetsPages(input *ListFleetsInput, fn func(*ListFleetsOutput, bool) bool) error {
	return c.ListFleetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFleetsPagesWithContext same as ListFleetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) ListFleetsPagesWithContext(ctx aws.Context, input *ListFleetsInput, fn func(*ListFleetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFleetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFleetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFleetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListGameServerGroups = "ListGameServerGroups"

// ListGameServerGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListGameServerGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGameServerGroups for more information on using the ListGameServerGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListGameServerGroupsRequest method.
//	req, resp := client.ListGameServerGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListGameServerGroups
func (c *GameLift) ListGameServerGroupsRequest(input *ListGameServerGroupsInput) (req *request.Request, output *ListGameServerGroupsOutput) {
	op := &request.Operation{
		Name:       opListGameServerGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGameServerGroupsInput{}
	}

	output = &ListGameServerGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGameServerGroups API operation for Amazon GameLift.
//
// Lists a game server groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation ListGameServerGroups for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListGameServerGroups
func (c *GameLift) ListGameServerGroups(input *ListGameServerGroupsInput) (*ListGameServerGroupsOutput, error) {
	req, out := c.ListGameServerGroupsRequest(input)
	return out, req.Send()
}

// ListGameServerGroupsWithContext is the same as ListGameServerGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListGameServerGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) ListGameServerGroupsWithContext(ctx aws.Context, input *ListGameServerGroupsInput, opts ...request.Option) (*ListGameServerGroupsOutput, error) {
	req, out := c.ListGameServerGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGameServerGroupsPages iterates over the pages of a ListGameServerGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGameServerGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListGameServerGroups operation.
//	pageNum := 0
//	err := client.ListGameServerGroupsPages(params,
//	    func(page *gamelift.ListGameServerGroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GameLift) ListGameServerGroupsPages(input *ListGameServerGroupsInput, fn func(*ListGameServerGroupsOutput, bool) bool) error {
	return c.ListGameServerGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGameServerGroupsPagesWithContext same as ListGameServerGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) ListGameServerGroupsPagesWithContext(ctx aws.Context, input *ListGameServerGroupsInput, fn func(*ListGameServerGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGameServerGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGameServerGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGameServerGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListGameServers = "ListGameServers"

// ListGameServersRequest generates a "aws/request.Request" representing the
// client's request for the ListGameServers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGameServers for more information on using the ListGameServers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListGameServersRequest method.
//	req, resp := client.ListGameServersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListGameServers
func (c *GameLift) ListGameServersRequest(input *ListGameServersInput) (req *request.Request, output *ListGameServersOutput) {
	op := &request.Operation{
		Name:       opListGameServers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGameServersInput{}
	}

	output = &ListGameServersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGameServers API operation for Amazon GameLift.
//
// This operation is used with the Amazon GameLift FleetIQ solution and game
// server groups.
//
// Retrieves information on all game servers that are currently active in a
// specified game server group. You can opt to sort the list by game server
// age. Use the pagination parameters to retrieve results in a set of sequential
// segments.
//
// # Learn more
//
// Amazon GameLift FleetIQ Guide (https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation ListGameServers for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListGameServers
func (c *GameLift) ListGameServers(input *ListGameServersInput) (*ListGameServersOutput, error) {
	req, out := c.ListGameServersRequest(input)
	return out, req.Send()
}

// ListGameServersWithContext is the same as ListGameServers with the addition of
// the ability to pass a context and additional request options.
//
// See ListGameServers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) ListGameServersWithContext(ctx aws.Context, input *ListGameServersInput, opts ...request.Option) (*ListGameServersOutput, error) {
	req, out := c.ListGameServersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGameServersPages iterates over the pages of a ListGameServers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGameServers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListGameServers operation.
//	pageNum := 0
//	err := client.ListGameServersPages(params,
//	    func(page *gamelift.ListGameServersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GameLift) ListGameServersPages(input *ListGameServersInput, fn func(*ListGameServersOutput, bool) bool) error {
	return c.ListGameServersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGameServersPagesWithContext same as ListGameServersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) ListGameServersPagesWithContext(ctx aws.Context, input *ListGameServersInput, fn func(*ListGameServersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGameServersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGameServersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGameServersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLocations = "ListLocations"

// ListLocationsRequest generates a "aws/request.Request" representing the
// client's request for the ListLocations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLocations for more information on using the ListLocations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListLocationsRequest method.
//	req, resp := client.ListLocationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListLocations
func (c *GameLift) ListLocationsRequest(input *ListLocationsInput) (req *request.Request, output *ListLocationsOutput) {
	op := &request.Operation{
		Name:       opListLocations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLocationsInput{}
	}

	output = &ListLocationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLocations API operation for Amazon GameLift.
//
// Lists all custom and Amazon Web Services locations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation ListLocations for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListLocations
func (c *GameLift) ListLocations(input *ListLocationsInput) (*ListLocationsOutput, error) {
	req, out := c.ListLocationsRequest(input)
	return out, req.Send()
}

// ListLocationsWithContext is the same as ListLocations with the addition of
// the ability to pass a context and additional request options.
//
// See ListLocations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) ListLocationsWithContext(ctx aws.Context, input *ListLocationsInput, opts ...request.Option) (*ListLocationsOutput, error) {
	req, out := c.ListLocationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLocationsPages iterates over the pages of a ListLocations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLocations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListLocations operation.
//	pageNum := 0
//	err := client.ListLocationsPages(params,
//	    func(page *gamelift.ListLocationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GameLift) ListLocationsPages(input *ListLocationsInput, fn func(*ListLocationsOutput, bool) bool) error {
	return c.ListLocationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLocationsPagesWithContext same as ListLocationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) ListLocationsPagesWithContext(ctx aws.Context, input *ListLocationsInput, fn func(*ListLocationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLocationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLocationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLocationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListScripts = "ListScripts"

// ListScriptsRequest generates a "aws/request.Request" representing the
// client's request for the ListScripts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListScripts for more information on using the ListScripts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListScriptsRequest method.
//	req, resp := client.ListScriptsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListScripts
func (c *GameLift) ListScriptsRequest(input *ListScriptsInput) (req *request.Request, output *ListScriptsOutput) {
	op := &request.Operation{
		Name:       opListScripts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListScriptsInput{}
	}

	output = &ListScriptsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListScripts API operation for Amazon GameLift.
//
// Retrieves script records for all Realtime scripts that are associated with
// the Amazon Web Services account in use.
//
// # Learn more
//
// Amazon GameLift Realtime Servers (https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html)
//
// # Related actions
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation ListScripts for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListScripts
func (c *GameLift) ListScripts(input *ListScriptsInput) (*ListScriptsOutput, error) {
	req, out := c.ListScriptsRequest(input)
	return out, req.Send()
}

// ListScriptsWithContext is the same as ListScripts with the addition of
// the ability to pass a context and additional request options.
//
// See ListScripts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) ListScriptsWithContext(ctx aws.Context, input *ListScriptsInput, opts ...request.Option) (*ListScriptsOutput, error) {
	req, out := c.ListScriptsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListScriptsPages iterates over the pages of a ListScripts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListScripts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListScripts operation.
//	pageNum := 0
//	err := client.ListScriptsPages(params,
//	    func(page *gamelift.ListScriptsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GameLift) ListScriptsPages(input *ListScriptsInput, fn func(*ListScriptsOutput, bool) bool) error {
	return c.ListScriptsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListScriptsPagesWithContext same as ListScriptsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) ListScriptsPagesWithContext(ctx aws.Context, input *ListScriptsInput, fn func(*ListScriptsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListScriptsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListScriptsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListScriptsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListTagsForResource
func (c *GameLift) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon GameLift.
//
// Retrieves all tags assigned to a Amazon GameLift resource. Use resource tags
// to organize Amazon Web Services resources for a range of purposes. This operation
// handles the permissions necessary to manage tags for Amazon GameLift resources
// that support tagging.
//
// To list tags for a resource, specify the unique ARN value for the resource.
//
// # Learn more
//
// Tagging Amazon Web Services Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
// in the Amazon Web Services General Reference
//
//	Amazon Web Services Tagging Strategies (http://aws.amazon.com/answers/account-management/aws-tagging-strategies/)
//
// # Related actions
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - TaggingFailedException
//     The requested tagging operation did not succeed. This may be due to invalid
//     tag format or the maximum tag limit may have been exceeded. Resolve the issue
//     before retrying.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListTagsForResource
func (c *GameLift) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutScalingPolicy = "PutScalingPolicy"

// PutScalingPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutScalingPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutScalingPolicy for more information on using the PutScalingPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutScalingPolicyRequest method.
//	req, resp := client.PutScalingPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/PutScalingPolicy
func (c *GameLift) PutScalingPolicyRequest(input *PutScalingPolicyInput) (req *request.Request, output *PutScalingPolicyOutput) {
	op := &request.Operation{
		Name:       opPutScalingPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutScalingPolicyInput{}
	}

	output = &PutScalingPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutScalingPolicy API operation for Amazon GameLift.
//
// Creates or updates a scaling policy for a fleet. Scaling policies are used
// to automatically scale a fleet's hosting capacity to meet player demand.
// An active scaling policy instructs Amazon GameLift to track a fleet metric
// and automatically change the fleet's capacity when a certain threshold is
// reached. There are two types of scaling policies: target-based and rule-based.
// Use a target-based policy to quickly and efficiently manage fleet scaling;
// this option is the most commonly used. Use rule-based policies when you need
// to exert fine-grained control over auto-scaling.
//
// Fleets can have multiple scaling policies of each type in force at the same
// time; you can have one target-based policy, one or multiple rule-based scaling
// policies, or both. We recommend caution, however, because multiple auto-scaling
// policies can have unintended consequences.
//
// Learn more about how to work with auto-scaling in Set Up Fleet Automatic
// Scaling (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-autoscaling.html).
//
// # Target-based policy
//
// A target-based policy tracks a single metric: PercentAvailableGameSessions.
// This metric tells us how much of a fleet's hosting capacity is ready to host
// game sessions but is not currently in use. This is the fleet's buffer; it
// measures the additional player demand that the fleet could handle at current
// capacity. With a target-based policy, you set your ideal buffer size and
// leave it to Amazon GameLift to take whatever action is needed to maintain
// that target.
//
// For example, you might choose to maintain a 10% buffer for a fleet that has
// the capacity to host 100 simultaneous game sessions. This policy tells Amazon
// GameLift to take action whenever the fleet's available capacity falls below
// or rises above 10 game sessions. Amazon GameLift will start new instances
// or stop unused instances in order to return to the 10% buffer.
//
// To create or update a target-based policy, specify a fleet ID and name, and
// set the policy type to "TargetBased". Specify the metric to track (PercentAvailableGameSessions)
// and reference a TargetConfiguration object with your desired buffer value.
// Exclude all other parameters. On a successful request, the policy name is
// returned. The scaling policy is automatically in force as soon as it's successfully
// created. If the fleet's auto-scaling actions are temporarily suspended, the
// new policy will be in force once the fleet actions are restarted.
//
// # Rule-based policy
//
// A rule-based policy tracks specified fleet metric, sets a threshold value,
// and specifies the type of action to initiate when triggered. With a rule-based
// policy, you can select from several available fleet metrics. Each policy
// specifies whether to scale up or scale down (and by how much), so you need
// one policy for each type of action.
//
// For example, a policy may make the following statement: "If the percentage
// of idle instances is greater than 20% for more than 15 minutes, then reduce
// the fleet capacity by 10%."
//
// A policy's rule statement has the following structure:
//
// If [MetricName] is [ComparisonOperator] [Threshold] for [EvaluationPeriods]
// minutes, then [ScalingAdjustmentType] to/by [ScalingAdjustment].
//
// To implement the example, the rule statement would look like this:
//
// If [PercentIdleInstances] is [GreaterThanThreshold] [20] for [15] minutes,
// then [PercentChangeInCapacity] to/by [10].
//
// To create or update a scaling policy, specify a unique combination of name
// and fleet ID, and set the policy type to "RuleBased". Specify the parameter
// values for a policy rule statement. On a successful request, the policy name
// is returned. Scaling policies are automatically in force as soon as they're
// successfully created. If the fleet's auto-scaling actions are temporarily
// suspended, the new policy will be in force once the fleet actions are restarted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation PutScalingPolicy for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/PutScalingPolicy
func (c *GameLift) PutScalingPolicy(input *PutScalingPolicyInput) (*PutScalingPolicyOutput, error) {
	req, out := c.PutScalingPolicyRequest(input)
	return out, req.Send()
}

// PutScalingPolicyWithContext is the same as PutScalingPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutScalingPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) PutScalingPolicyWithContext(ctx aws.Context, input *PutScalingPolicyInput, opts ...request.Option) (*PutScalingPolicyOutput, error) {
	req, out := c.PutScalingPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterCompute = "RegisterCompute"

// RegisterComputeRequest generates a "aws/request.Request" representing the
// client's request for the RegisterCompute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterCompute for more information on using the RegisterCompute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RegisterComputeRequest method.
//	req, resp := client.RegisterComputeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/RegisterCompute
func (c *GameLift) RegisterComputeRequest(input *RegisterComputeInput) (req *request.Request, output *RegisterComputeOutput) {
	op := &request.Operation{
		Name:       opRegisterCompute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterComputeInput{}
	}

	output = &RegisterComputeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterCompute API operation for Amazon GameLift.
//
// Registers a compute resource to an Amazon GameLift Anywhere fleet. With Anywhere
// fleets you can incorporate your own computing hardware into an Amazon GameLift
// game hosting solution.
//
// To register a compute to a fleet, give the compute a name (must be unique
// within the fleet) and specify the compute resource's DNS name or IP address.
// Provide the Anywhere fleet ID and a fleet location to associate with the
// compute being registered. You can optionally include the path to a TLS certificate
// on the compute resource.
//
// If successful, this operation returns the compute details, including an Amazon
// GameLift SDK endpoint. Game server processes that run on the compute use
// this endpoint to communicate with the Amazon GameLift service. Each server
// process includes the SDK endpoint in its call to the Amazon GameLift server
// SDK action InitSDK().
//
// Learn more
//
//   - Create an Anywhere fleet (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-anywhere.html)
//
//   - Test your integration (https://docs.aws.amazon.com/gamelift/latest/developerguide/integration-testing.html)
//
//   - Server SDK reference guides (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk.html)
//     (for version 5.x)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation RegisterCompute for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - ConflictException
//     The requested operation would cause a conflict with the current state of
//     a service resource associated with the request. Resolve the conflict before
//     retrying this request.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - LimitExceededException
//     The requested operation would cause the resource to exceed the allowed service
//     limit. Resolve the issue before retrying.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/RegisterCompute
func (c *GameLift) RegisterCompute(input *RegisterComputeInput) (*RegisterComputeOutput, error) {
	req, out := c.RegisterComputeRequest(input)
	return out, req.Send()
}

// RegisterComputeWithContext is the same as RegisterCompute with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterCompute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) RegisterComputeWithContext(ctx aws.Context, input *RegisterComputeInput, opts ...request.Option) (*RegisterComputeOutput, error) {
	req, out := c.RegisterComputeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterGameServer = "RegisterGameServer"

// RegisterGameServerRequest generates a "aws/request.Request" representing the
// client's request for the RegisterGameServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterGameServer for more information on using the RegisterGameServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RegisterGameServerRequest method.
//	req, resp := client.RegisterGameServerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/RegisterGameServer
func (c *GameLift) RegisterGameServerRequest(input *RegisterGameServerInput) (req *request.Request, output *RegisterGameServerOutput) {
	op := &request.Operation{
		Name:       opRegisterGameServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterGameServerInput{}
	}

	output = &RegisterGameServerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterGameServer API operation for Amazon GameLift.
//
// This operation is used with the Amazon GameLift FleetIQ solution and game
// server groups.
//
// Creates a new game server resource and notifies Amazon GameLift FleetIQ that
// the game server is ready to host gameplay and players. This operation is
// called by a game server process that is running on an instance in a game
// server group. Registering game servers enables Amazon GameLift FleetIQ to
// track available game servers and enables game clients and services to claim
// a game server for a new game session.
//
// To register a game server, identify the game server group and instance where
// the game server is running, and provide a unique identifier for the game
// server. You can also include connection and game server data.
//
// Once a game server is successfully registered, it is put in status AVAILABLE.
// A request to register a game server may fail if the instance it is running
// on is in the process of shutting down as part of instance balancing or scale-down
// activity.
//
// # Learn more
//
// Amazon GameLift FleetIQ Guide (https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation RegisterGameServer for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - ConflictException
//     The requested operation would cause a conflict with the current state of
//     a service resource associated with the request. Resolve the conflict before
//     retrying this request.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - LimitExceededException
//     The requested operation would cause the resource to exceed the allowed service
//     limit. Resolve the issue before retrying.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/RegisterGameServer
func (c *GameLift) RegisterGameServer(input *RegisterGameServerInput) (*RegisterGameServerOutput, error) {
	req, out := c.RegisterGameServerRequest(input)
	return out, req.Send()
}

// RegisterGameServerWithContext is the same as RegisterGameServer with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterGameServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) RegisterGameServerWithContext(ctx aws.Context, input *RegisterGameServerInput, opts ...request.Option) (*RegisterGameServerOutput, error) {
	req, out := c.RegisterGameServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRequestUploadCredentials = "RequestUploadCredentials"

// RequestUploadCredentialsRequest generates a "aws/request.Request" representing the
// client's request for the RequestUploadCredentials operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RequestUploadCredentials for more information on using the RequestUploadCredentials
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RequestUploadCredentialsRequest method.
//	req, resp := client.RequestUploadCredentialsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/RequestUploadCredentials
func (c *GameLift) RequestUploadCredentialsRequest(input *RequestUploadCredentialsInput) (req *request.Request, output *RequestUploadCredentialsOutput) {
	op := &request.Operation{
		Name:       opRequestUploadCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RequestUploadCredentialsInput{}
	}

	output = &RequestUploadCredentialsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RequestUploadCredentials API operation for Amazon GameLift.
//
// Retrieves a fresh set of credentials for use when uploading a new set of
// game build files to Amazon GameLift's Amazon S3. This is done as part of
// the build creation process; see GameSession (https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateBuild.html).
//
// To request new credentials, specify the build ID as returned with an initial
// CreateBuild request. If successful, a new set of credentials are returned,
// along with the S3 storage location associated with the build ID.
//
// Learn more
//
//	Create a Build with Files in S3 (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-cli-uploading.html#gamelift-build-cli-uploading-create-build)
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation RequestUploadCredentials for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/RequestUploadCredentials
func (c *GameLift) RequestUploadCredentials(input *RequestUploadCredentialsInput) (*RequestUploadCredentialsOutput, error) {
	req, out := c.RequestUploadCredentialsRequest(input)
	return out, req.Send()
}

// RequestUploadCredentialsWithContext is the same as RequestUploadCredentials with the addition of
// the ability to pass a context and additional request options.
//
// See RequestUploadCredentials for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) RequestUploadCredentialsWithContext(ctx aws.Context, input *RequestUploadCredentialsInput, opts ...request.Option) (*RequestUploadCredentialsOutput, error) {
	req, out := c.RequestUploadCredentialsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResolveAlias = "ResolveAlias"

// ResolveAliasRequest generates a "aws/request.Request" representing the
// client's request for the ResolveAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResolveAlias for more information on using the ResolveAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ResolveAliasRequest method.
//	req, resp := client.ResolveAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ResolveAlias
func (c *GameLift) ResolveAliasRequest(input *ResolveAliasInput) (req *request.Request, output *ResolveAliasOutput) {
	op := &request.Operation{
		Name:       opResolveAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResolveAliasInput{}
	}

	output = &ResolveAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ResolveAlias API operation for Amazon GameLift.
//
// Retrieves the fleet ID that an alias is currently pointing to.
//
// # Related actions
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation ResolveAlias for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - TerminalRoutingStrategyException
//     The service is unable to resolve the routing for a particular alias because
//     it has a terminal RoutingStrategy associated with it. The message returned
//     in this exception is the message defined in the routing strategy itself.
//     Such requests should only be retried if the routing strategy for the specified
//     alias is modified.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ResolveAlias
func (c *GameLift) ResolveAlias(input *ResolveAliasInput) (*ResolveAliasOutput, error) {
	req, out := c.ResolveAliasRequest(input)
	return out, req.Send()
}

// ResolveAliasWithContext is the same as ResolveAlias with the addition of
// the ability to pass a context and additional request options.
//
// See ResolveAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) ResolveAliasWithContext(ctx aws.Context, input *ResolveAliasInput, opts ...request.Option) (*ResolveAliasOutput, error) {
	req, out := c.ResolveAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResumeGameServerGroup = "ResumeGameServerGroup"

// ResumeGameServerGroupRequest generates a "aws/request.Request" representing the
// client's request for the ResumeGameServerGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResumeGameServerGroup for more information on using the ResumeGameServerGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ResumeGameServerGroupRequest method.
//	req, resp := client.ResumeGameServerGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ResumeGameServerGroup
func (c *GameLift) ResumeGameServerGroupRequest(input *ResumeGameServerGroupInput) (req *request.Request, output *ResumeGameServerGroupOutput) {
	op := &request.Operation{
		Name:       opResumeGameServerGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResumeGameServerGroupInput{}
	}

	output = &ResumeGameServerGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ResumeGameServerGroup API operation for Amazon GameLift.
//
// This operation is used with the Amazon GameLift FleetIQ solution and game
// server groups.
//
// Reinstates activity on a game server group after it has been suspended. A
// game server group might be suspended by the SuspendGameServerGroup (gamelift/latest/apireference/API_SuspendGameServerGroup.html)
// operation, or it might be suspended involuntarily due to a configuration
// problem. In the second case, you can manually resume activity on the group
// once the configuration problem has been resolved. Refer to the game server
// group status and status reason for more information on why group activity
// is suspended.
//
// To resume activity, specify a game server group ARN and the type of activity
// to be resumed. If successful, a GameServerGroup object is returned showing
// that the resumed activity is no longer listed in SuspendedActions.
//
// # Learn more
//
// Amazon GameLift FleetIQ Guide (https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation ResumeGameServerGroup for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ResumeGameServerGroup
func (c *GameLift) ResumeGameServerGroup(input *ResumeGameServerGroupInput) (*ResumeGameServerGroupOutput, error) {
	req, out := c.ResumeGameServerGroupRequest(input)
	return out, req.Send()
}

// ResumeGameServerGroupWithContext is the same as ResumeGameServerGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ResumeGameServerGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) ResumeGameServerGroupWithContext(ctx aws.Context, input *ResumeGameServerGroupInput, opts ...request.Option) (*ResumeGameServerGroupOutput, error) {
	req, out := c.ResumeGameServerGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchGameSessions = "SearchGameSessions"

// SearchGameSessionsRequest generates a "aws/request.Request" representing the
// client's request for the SearchGameSessions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchGameSessions for more information on using the SearchGameSessions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchGameSessionsRequest method.
//	req, resp := client.SearchGameSessionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/SearchGameSessions
func (c *GameLift) SearchGameSessionsRequest(input *SearchGameSessionsInput) (req *request.Request, output *SearchGameSessionsOutput) {
	op := &request.Operation{
		Name:       opSearchGameSessions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchGameSessionsInput{}
	}

	output = &SearchGameSessionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchGameSessions API operation for Amazon GameLift.
//
// Retrieves all active game sessions that match a set of search criteria and
// sorts them into a specified order.
//
// This operation is not designed to be continually called to track game session
// status. This practice can cause you to exceed your API limit, which results
// in errors. Instead, you must configure configure an Amazon Simple Notification
// Service (SNS) topic to receive notifications from FlexMatch or queues. Continuously
// polling game session status with DescribeGameSessions should only be used
// for games in development with low game session usage.
//
// When searching for game sessions, you specify exactly where you want to search
// and provide a search filter expression, a sort expression, or both. A search
// request can search only one fleet, but it can search all of a fleet's locations.
//
// This operation can be used in the following ways:
//
//   - To search all game sessions that are currently running on all locations
//     in a fleet, provide a fleet or alias ID. This approach returns game sessions
//     in the fleet's home Region and all remote locations that fit the search
//     criteria.
//
//   - To search all game sessions that are currently running on a specific
//     fleet location, provide a fleet or alias ID and a location name. For location,
//     you can specify a fleet's home Region or any remote location.
//
// Use the pagination parameters to retrieve results as a set of sequential
// pages.
//
// If successful, a GameSession object is returned for each game session that
// matches the request. Search finds game sessions that are in ACTIVE status
// only. To retrieve information on game sessions in other statuses, use DescribeGameSessions
// (https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessions.html) .
//
// You can search or sort by the following game session attributes:
//
//   - gameSessionId -- A unique identifier for the game session. You can use
//     either a GameSessionId or GameSessionArn value.
//
//   - gameSessionName -- Name assigned to a game session. Game session names
//     do not need to be unique to a game session.
//
//   - gameSessionProperties -- Custom data defined in a game session's GameProperty
//     parameter. GameProperty values are stored as key:value pairs; the filter
//     expression must indicate the key and a string to search the data values
//     for. For example, to search for game sessions with custom data containing
//     the key:value pair "gameMode:brawl", specify the following: gameSessionProperties.gameMode
//     = "brawl". All custom data values are searched as strings.
//
//   - maximumSessions -- Maximum number of player sessions allowed for a game
//     session.
//
//   - creationTimeMillis -- Value indicating when a game session was created.
//     It is expressed in Unix time as milliseconds.
//
//   - playerSessionCount -- Number of players currently connected to a game
//     session. This value changes rapidly as players join the session or drop
//     out.
//
//   - hasAvailablePlayerSessions -- Boolean value indicating whether a game
//     session has reached its maximum number of players. It is highly recommended
//     that all search requests include this filter attribute to optimize search
//     performance and return only sessions that players can join.
//
// Returned values for playerSessionCount and hasAvailablePlayerSessions change
// quickly as players join sessions and others drop out. Results should be considered
// a snapshot in time. Be sure to refresh search results often, and handle sessions
// that fill up before a player can join.
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation SearchGameSessions for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - TerminalRoutingStrategyException
//     The service is unable to resolve the routing for a particular alias because
//     it has a terminal RoutingStrategy associated with it. The message returned
//     in this exception is the message defined in the routing strategy itself.
//     Such requests should only be retried if the routing strategy for the specified
//     alias is modified.
//
//   - UnsupportedRegionException
//     The requested operation is not supported in the Region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/SearchGameSessions
func (c *GameLift) SearchGameSessions(input *SearchGameSessionsInput) (*SearchGameSessionsOutput, error) {
	req, out := c.SearchGameSessionsRequest(input)
	return out, req.Send()
}

// SearchGameSessionsWithContext is the same as SearchGameSessions with the addition of
// the ability to pass a context and additional request options.
//
// See SearchGameSessions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) SearchGameSessionsWithContext(ctx aws.Context, input *SearchGameSessionsInput, opts ...request.Option) (*SearchGameSessionsOutput, error) {
	req, out := c.SearchGameSessionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchGameSessionsPages iterates over the pages of a SearchGameSessions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchGameSessions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchGameSessions operation.
//	pageNum := 0
//	err := client.SearchGameSessionsPages(params,
//	    func(page *gamelift.SearchGameSessionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *GameLift) SearchGameSessionsPages(input *SearchGameSessionsInput, fn func(*SearchGameSessionsOutput, bool) bool) error {
	return c.SearchGameSessionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchGameSessionsPagesWithContext same as SearchGameSessionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) SearchGameSessionsPagesWithContext(ctx aws.Context, input *SearchGameSessionsInput, fn func(*SearchGameSessionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchGameSessionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchGameSessionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchGameSessionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartFleetActions = "StartFleetActions"

// StartFleetActionsRequest generates a "aws/request.Request" representing the
// client's request for the StartFleetActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartFleetActions for more information on using the StartFleetActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartFleetActionsRequest method.
//	req, resp := client.StartFleetActionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StartFleetActions
func (c *GameLift) StartFleetActionsRequest(input *StartFleetActionsInput) (req *request.Request, output *StartFleetActionsOutput) {
	op := &request.Operation{
		Name:       opStartFleetActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartFleetActionsInput{}
	}

	output = &StartFleetActionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartFleetActions API operation for Amazon GameLift.
//
// Resumes certain types of activity on fleet instances that were suspended
// with StopFleetActions (https://docs.aws.amazon.com/gamelift/latest/apireference/API_StopFleetActions.html).
// For multi-location fleets, fleet actions are managed separately for each
// location. Currently, this operation is used to restart a fleet's auto-scaling
// activity.
//
// This operation can be used in the following ways:
//
//   - To restart actions on instances in the fleet's home Region, provide
//     a fleet ID and the type of actions to resume.
//
//   - To restart actions on instances in one of the fleet's remote locations,
//     provide a fleet ID, a location name, and the type of actions to resume.
//
// If successful, Amazon GameLift once again initiates scaling events as triggered
// by the fleet's scaling policies. If actions on the fleet location were never
// stopped, this operation will have no effect.
//
// # Learn more
//
// Setting up Amazon GameLift fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation StartFleetActions for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - UnsupportedRegionException
//     The requested operation is not supported in the Region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StartFleetActions
func (c *GameLift) StartFleetActions(input *StartFleetActionsInput) (*StartFleetActionsOutput, error) {
	req, out := c.StartFleetActionsRequest(input)
	return out, req.Send()
}

// StartFleetActionsWithContext is the same as StartFleetActions with the addition of
// the ability to pass a context and additional request options.
//
// See StartFleetActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) StartFleetActionsWithContext(ctx aws.Context, input *StartFleetActionsInput, opts ...request.Option) (*StartFleetActionsOutput, error) {
	req, out := c.StartFleetActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartGameSessionPlacement = "StartGameSessionPlacement"

// StartGameSessionPlacementRequest generates a "aws/request.Request" representing the
// client's request for the StartGameSessionPlacement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartGameSessionPlacement for more information on using the StartGameSessionPlacement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartGameSessionPlacementRequest method.
//	req, resp := client.StartGameSessionPlacementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StartGameSessionPlacement
func (c *GameLift) StartGameSessionPlacementRequest(input *StartGameSessionPlacementInput) (req *request.Request, output *StartGameSessionPlacementOutput) {
	op := &request.Operation{
		Name:       opStartGameSessionPlacement,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartGameSessionPlacementInput{}
	}

	output = &StartGameSessionPlacementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartGameSessionPlacement API operation for Amazon GameLift.
//
// Places a request for a new game session in a queue. When processing a placement
// request, Amazon GameLift searches for available resources on the queue's
// destinations, scanning each until it finds resources or the placement request
// times out.
//
// A game session placement request can also request player sessions. When a
// new game session is successfully created, Amazon GameLift creates a player
// session for each player included in the request.
//
// When placing a game session, by default Amazon GameLift tries each fleet
// in the order they are listed in the queue configuration. Ideally, a queue's
// destinations are listed in preference order.
//
// Alternatively, when requesting a game session with players, you can also
// provide latency data for each player in relevant Regions. Latency data indicates
// the performance lag a player experiences when connected to a fleet in the
// Region. Amazon GameLift uses latency data to reorder the list of destinations
// to place the game session in a Region with minimal lag. If latency data is
// provided for multiple players, Amazon GameLift calculates each Region's average
// lag for all players and reorders to get the best game play across all players.
//
// To place a new game session request, specify the following:
//
//   - The queue name and a set of game session properties and settings
//
//   - A unique ID (such as a UUID) for the placement. You use this ID to track
//     the status of the placement request
//
//   - (Optional) A set of player data and a unique player ID for each player
//     that you are joining to the new game session (player data is optional,
//     but if you include it, you must also provide a unique ID for each player)
//
//   - Latency data for all players (if you want to optimize game play for
//     the players)
//
// If successful, a new game session placement is created.
//
// To track the status of a placement request, call DescribeGameSessionPlacement
// (https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessionPlacement.html)
// and check the request's status. If the status is FULFILLED, a new game session
// has been created and a game session ARN and Region are referenced. If the
// placement request times out, you can resubmit the request or retry it with
// a different queue.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation StartGameSessionPlacement for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StartGameSessionPlacement
func (c *GameLift) StartGameSessionPlacement(input *StartGameSessionPlacementInput) (*StartGameSessionPlacementOutput, error) {
	req, out := c.StartGameSessionPlacementRequest(input)
	return out, req.Send()
}

// StartGameSessionPlacementWithContext is the same as StartGameSessionPlacement with the addition of
// the ability to pass a context and additional request options.
//
// See StartGameSessionPlacement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) StartGameSessionPlacementWithContext(ctx aws.Context, input *StartGameSessionPlacementInput, opts ...request.Option) (*StartGameSessionPlacementOutput, error) {
	req, out := c.StartGameSessionPlacementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartMatchBackfill = "StartMatchBackfill"

// StartMatchBackfillRequest generates a "aws/request.Request" representing the
// client's request for the StartMatchBackfill operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMatchBackfill for more information on using the StartMatchBackfill
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartMatchBackfillRequest method.
//	req, resp := client.StartMatchBackfillRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StartMatchBackfill
func (c *GameLift) StartMatchBackfillRequest(input *StartMatchBackfillInput) (req *request.Request, output *StartMatchBackfillOutput) {
	op := &request.Operation{
		Name:       opStartMatchBackfill,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartMatchBackfillInput{}
	}

	output = &StartMatchBackfillOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartMatchBackfill API operation for Amazon GameLift.
//
// Finds new players to fill open slots in currently running game sessions.
// The backfill match process is essentially identical to the process of forming
// new matches. Backfill requests use the same matchmaker that was used to make
// the original match, and they provide matchmaking data for all players currently
// in the game session. FlexMatch uses this information to select new players
// so that backfilled match continues to meet the original match requirements.
//
// When using FlexMatch with Amazon GameLift managed hosting, you can request
// a backfill match from a client service by calling this operation with a GameSessions
// ID. You also have the option of making backfill requests directly from your
// game server. In response to a request, FlexMatch creates player sessions
// for the new players, updates the GameSession resource, and sends updated
// matchmaking data to the game server. You can request a backfill match at
// any point after a game session is started. Each game session can have only
// one active backfill request at a time; a subsequent request automatically
// replaces the earlier request.
//
// When using FlexMatch as a standalone component, request a backfill match
// by calling this operation without a game session identifier. As with newly
// formed matches, matchmaking results are returned in a matchmaking event so
// that your game can update the game session that is being backfilled.
//
// To request a backfill match, specify a unique ticket ID, the original matchmaking
// configuration, and matchmaking data for all current players in the game session
// being backfilled. Optionally, specify the GameSession ARN. If successful,
// a match backfill ticket is created and returned with status set to QUEUED.
// Track the status of backfill tickets using the same method for tracking tickets
// for new matches.
//
// Only game sessions created by FlexMatch are supported for match backfill.
//
// Learn more
//
//	Backfill existing games with FlexMatch (https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html)
//
//	Matchmaking events (https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html)
//	(reference)
//
//	How Amazon GameLift FlexMatch works (https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/gamelift-match.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation StartMatchBackfill for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - UnsupportedRegionException
//     The requested operation is not supported in the Region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StartMatchBackfill
func (c *GameLift) StartMatchBackfill(input *StartMatchBackfillInput) (*StartMatchBackfillOutput, error) {
	req, out := c.StartMatchBackfillRequest(input)
	return out, req.Send()
}

// StartMatchBackfillWithContext is the same as StartMatchBackfill with the addition of
// the ability to pass a context and additional request options.
//
// See StartMatchBackfill for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) StartMatchBackfillWithContext(ctx aws.Context, input *StartMatchBackfillInput, opts ...request.Option) (*StartMatchBackfillOutput, error) {
	req, out := c.StartMatchBackfillRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartMatchmaking = "StartMatchmaking"

// StartMatchmakingRequest generates a "aws/request.Request" representing the
// client's request for the StartMatchmaking operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMatchmaking for more information on using the StartMatchmaking
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartMatchmakingRequest method.
//	req, resp := client.StartMatchmakingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StartMatchmaking
func (c *GameLift) StartMatchmakingRequest(input *StartMatchmakingInput) (req *request.Request, output *StartMatchmakingOutput) {
	op := &request.Operation{
		Name:       opStartMatchmaking,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartMatchmakingInput{}
	}

	output = &StartMatchmakingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartMatchmaking API operation for Amazon GameLift.
//
// Uses FlexMatch to create a game match for a group of players based on custom
// matchmaking rules. With games that use Amazon GameLift managed hosting, this
// operation also triggers Amazon GameLift to find hosting resources and start
// a new game session for the new match. Each matchmaking request includes information
// on one or more players and specifies the FlexMatch matchmaker to use. When
// a request is for multiple players, FlexMatch attempts to build a match that
// includes all players in the request, placing them in the same team and finding
// additional players as needed to fill the match.
//
// To start matchmaking, provide a unique ticket ID, specify a matchmaking configuration,
// and include the players to be matched. You must also include any player attributes
// that are required by the matchmaking configuration's rule set. If successful,
// a matchmaking ticket is returned with status set to QUEUED.
//
// Track matchmaking events to respond as needed and acquire game session connection
// information for successfully completed matches. Ticket status updates are
// tracked using event notification through Amazon Simple Notification Service,
// which is defined in the matchmaking configuration.
//
// Learn more
//
//	Add FlexMatch to a game client (https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-client.html)
//
//	Set Up FlexMatch event notification (https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html)
//
//	How Amazon GameLift FlexMatch works (https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/gamelift-match.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation StartMatchmaking for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - UnsupportedRegionException
//     The requested operation is not supported in the Region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StartMatchmaking
func (c *GameLift) StartMatchmaking(input *StartMatchmakingInput) (*StartMatchmakingOutput, error) {
	req, out := c.StartMatchmakingRequest(input)
	return out, req.Send()
}

// StartMatchmakingWithContext is the same as StartMatchmaking with the addition of
// the ability to pass a context and additional request options.
//
// See StartMatchmaking for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) StartMatchmakingWithContext(ctx aws.Context, input *StartMatchmakingInput, opts ...request.Option) (*StartMatchmakingOutput, error) {
	req, out := c.StartMatchmakingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopFleetActions = "StopFleetActions"

// StopFleetActionsRequest generates a "aws/request.Request" representing the
// client's request for the StopFleetActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopFleetActions for more information on using the StopFleetActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopFleetActionsRequest method.
//	req, resp := client.StopFleetActionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StopFleetActions
func (c *GameLift) StopFleetActionsRequest(input *StopFleetActionsInput) (req *request.Request, output *StopFleetActionsOutput) {
	op := &request.Operation{
		Name:       opStopFleetActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopFleetActionsInput{}
	}

	output = &StopFleetActionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopFleetActions API operation for Amazon GameLift.
//
// Suspends certain types of activity in a fleet location. Currently, this operation
// is used to stop auto-scaling activity. For multi-location fleets, fleet actions
// are managed separately for each location.
//
// Stopping fleet actions has several potential purposes. It allows you to temporarily
// stop auto-scaling activity but retain your scaling policies for use in the
// future. For multi-location fleets, you can set up fleet-wide auto-scaling,
// and then opt out of it for certain locations.
//
// This operation can be used in the following ways:
//
//   - To stop actions on instances in the fleet's home Region, provide a fleet
//     ID and the type of actions to suspend.
//
//   - To stop actions on instances in one of the fleet's remote locations,
//     provide a fleet ID, a location name, and the type of actions to suspend.
//
// If successful, Amazon GameLift no longer initiates scaling events except
// in response to manual changes using UpdateFleetCapacity (https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateFleetCapacity.html).
//
// # Learn more
//
// Setting up Amazon GameLift Fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation StopFleetActions for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - UnsupportedRegionException
//     The requested operation is not supported in the Region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StopFleetActions
func (c *GameLift) StopFleetActions(input *StopFleetActionsInput) (*StopFleetActionsOutput, error) {
	req, out := c.StopFleetActionsRequest(input)
	return out, req.Send()
}

// StopFleetActionsWithContext is the same as StopFleetActions with the addition of
// the ability to pass a context and additional request options.
//
// See StopFleetActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) StopFleetActionsWithContext(ctx aws.Context, input *StopFleetActionsInput, opts ...request.Option) (*StopFleetActionsOutput, error) {
	req, out := c.StopFleetActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopGameSessionPlacement = "StopGameSessionPlacement"

// StopGameSessionPlacementRequest generates a "aws/request.Request" representing the
// client's request for the StopGameSessionPlacement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopGameSessionPlacement for more information on using the StopGameSessionPlacement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopGameSessionPlacementRequest method.
//	req, resp := client.StopGameSessionPlacementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StopGameSessionPlacement
func (c *GameLift) StopGameSessionPlacementRequest(input *StopGameSessionPlacementInput) (req *request.Request, output *StopGameSessionPlacementOutput) {
	op := &request.Operation{
		Name:       opStopGameSessionPlacement,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopGameSessionPlacementInput{}
	}

	output = &StopGameSessionPlacementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopGameSessionPlacement API operation for Amazon GameLift.
//
// Cancels a game session placement that is in PENDING status. To stop a placement,
// provide the placement ID values. If successful, the placement is moved to
// CANCELLED status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation StopGameSessionPlacement for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StopGameSessionPlacement
func (c *GameLift) StopGameSessionPlacement(input *StopGameSessionPlacementInput) (*StopGameSessionPlacementOutput, error) {
	req, out := c.StopGameSessionPlacementRequest(input)
	return out, req.Send()
}

// StopGameSessionPlacementWithContext is the same as StopGameSessionPlacement with the addition of
// the ability to pass a context and additional request options.
//
// See StopGameSessionPlacement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) StopGameSessionPlacementWithContext(ctx aws.Context, input *StopGameSessionPlacementInput, opts ...request.Option) (*StopGameSessionPlacementOutput, error) {
	req, out := c.StopGameSessionPlacementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopMatchmaking = "StopMatchmaking"

// StopMatchmakingRequest generates a "aws/request.Request" representing the
// client's request for the StopMatchmaking operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopMatchmaking for more information on using the StopMatchmaking
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopMatchmakingRequest method.
//	req, resp := client.StopMatchmakingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StopMatchmaking
func (c *GameLift) StopMatchmakingRequest(input *StopMatchmakingInput) (req *request.Request, output *StopMatchmakingOutput) {
	op := &request.Operation{
		Name:       opStopMatchmaking,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopMatchmakingInput{}
	}

	output = &StopMatchmakingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopMatchmaking API operation for Amazon GameLift.
//
// Cancels a matchmaking ticket or match backfill ticket that is currently being
// processed. To stop the matchmaking operation, specify the ticket ID. If successful,
// work on the ticket is stopped, and the ticket status is changed to CANCELLED.
//
// This call is also used to turn off automatic backfill for an individual game
// session. This is for game sessions that are created with a matchmaking configuration
// that has automatic backfill enabled. The ticket ID is included in the MatchmakerData
// of an updated game session object, which is provided to the game server.
//
// If the operation is successful, the service sends back an empty JSON struct
// with the HTTP 200 response (not an empty HTTP body).
//
// Learn more
//
//	Add FlexMatch to a game client (https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-client.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation StopMatchmaking for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - UnsupportedRegionException
//     The requested operation is not supported in the Region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/StopMatchmaking
func (c *GameLift) StopMatchmaking(input *StopMatchmakingInput) (*StopMatchmakingOutput, error) {
	req, out := c.StopMatchmakingRequest(input)
	return out, req.Send()
}

// StopMatchmakingWithContext is the same as StopMatchmaking with the addition of
// the ability to pass a context and additional request options.
//
// See StopMatchmaking for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) StopMatchmakingWithContext(ctx aws.Context, input *StopMatchmakingInput, opts ...request.Option) (*StopMatchmakingOutput, error) {
	req, out := c.StopMatchmakingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSuspendGameServerGroup = "SuspendGameServerGroup"

// SuspendGameServerGroupRequest generates a "aws/request.Request" representing the
// client's request for the SuspendGameServerGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SuspendGameServerGroup for more information on using the SuspendGameServerGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SuspendGameServerGroupRequest method.
//	req, resp := client.SuspendGameServerGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/SuspendGameServerGroup
func (c *GameLift) SuspendGameServerGroupRequest(input *SuspendGameServerGroupInput) (req *request.Request, output *SuspendGameServerGroupOutput) {
	op := &request.Operation{
		Name:       opSuspendGameServerGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SuspendGameServerGroupInput{}
	}

	output = &SuspendGameServerGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SuspendGameServerGroup API operation for Amazon GameLift.
//
// This operation is used with the Amazon GameLift FleetIQ solution and game
// server groups.
//
// Temporarily stops activity on a game server group without terminating instances
// or the game server group. You can restart activity by calling ResumeGameServerGroup
// (gamelift/latest/apireference/API_ResumeGameServerGroup.html). You can suspend
// the following activity:
//
//   - Instance type replacement - This activity evaluates the current game
//     hosting viability of all Spot instance types that are defined for the
//     game server group. It updates the Auto Scaling group to remove nonviable
//     Spot Instance types, which have a higher chance of game server interruptions.
//     It then balances capacity across the remaining viable Spot Instance types.
//     When this activity is suspended, the Auto Scaling group continues with
//     its current balance, regardless of viability. Instance protection, utilization
//     metrics, and capacity scaling activities continue to be active.
//
// To suspend activity, specify a game server group ARN and the type of activity
// to be suspended. If successful, a GameServerGroup object is returned showing
// that the activity is listed in SuspendedActions.
//
// # Learn more
//
// Amazon GameLift FleetIQ Guide (https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation SuspendGameServerGroup for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/SuspendGameServerGroup
func (c *GameLift) SuspendGameServerGroup(input *SuspendGameServerGroupInput) (*SuspendGameServerGroupOutput, error) {
	req, out := c.SuspendGameServerGroupRequest(input)
	return out, req.Send()
}

// SuspendGameServerGroupWithContext is the same as SuspendGameServerGroup with the addition of
// the ability to pass a context and additional request options.
//
// See SuspendGameServerGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) SuspendGameServerGroupWithContext(ctx aws.Context, input *SuspendGameServerGroupInput, opts ...request.Option) (*SuspendGameServerGroupOutput, error) {
	req, out := c.SuspendGameServerGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/TagResource
func (c *GameLift) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon GameLift.
//
// Assigns a tag to an Amazon GameLift resource. You can use tags to organize
// resources, create IAM permissions policies to manage access to groups of
// resources, customize Amazon Web Services cost breakdowns, and more. This
// operation handles the permissions necessary to manage tags for Amazon GameLift
// resources that support tagging.
//
// To add a tag to a resource, specify the unique ARN value for the resource
// and provide a tag list containing one or more tags. The operation succeeds
// even if the list includes tags that are already assigned to the resource.
//
// # Learn more
//
// Tagging Amazon Web Services Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
// in the Amazon Web Services General Reference
//
//	Amazon Web Services Tagging Strategies (http://aws.amazon.com/answers/account-management/aws-tagging-strategies/)
//
// # Related actions
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - TaggingFailedException
//     The requested tagging operation did not succeed. This may be due to invalid
//     tag format or the maximum tag limit may have been exceeded. Resolve the issue
//     before retrying.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/TagResource
func (c *GameLift) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UntagResource
func (c *GameLift) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon GameLift.
//
// Removes a tag assigned to a Amazon GameLift resource. You can use resource
// tags to organize Amazon Web Services resources for a range of purposes. This
// operation handles the permissions necessary to manage tags for Amazon GameLift
// resources that support tagging.
//
// To remove a tag from a resource, specify the unique ARN value for the resource
// and provide a string list containing one or more tags to remove. This operation
// succeeds even if the list includes tags that aren't assigned to the resource.
//
// # Learn more
//
// Tagging Amazon Web Services Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
// in the Amazon Web Services General Reference
//
//	Amazon Web Services Tagging Strategies (http://aws.amazon.com/answers/account-management/aws-tagging-strategies/)
//
// # Related actions
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - TaggingFailedException
//     The requested tagging operation did not succeed. This may be due to invalid
//     tag format or the maximum tag limit may have been exceeded. Resolve the issue
//     before retrying.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UntagResource
func (c *GameLift) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAlias = "UpdateAlias"

// UpdateAliasRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAlias for more information on using the UpdateAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAliasRequest method.
//	req, resp := client.UpdateAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateAlias
func (c *GameLift) UpdateAliasRequest(input *UpdateAliasInput) (req *request.Request, output *UpdateAliasOutput) {
	op := &request.Operation{
		Name:       opUpdateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAliasInput{}
	}

	output = &UpdateAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAlias API operation for Amazon GameLift.
//
// Updates properties for an alias. To update properties, specify the alias
// ID to be updated and provide the information to be changed. To reassign an
// alias to another fleet, provide an updated routing strategy. If successful,
// the updated alias record is returned.
//
// # Related actions
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation UpdateAlias for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateAlias
func (c *GameLift) UpdateAlias(input *UpdateAliasInput) (*UpdateAliasOutput, error) {
	req, out := c.UpdateAliasRequest(input)
	return out, req.Send()
}

// UpdateAliasWithContext is the same as UpdateAlias with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) UpdateAliasWithContext(ctx aws.Context, input *UpdateAliasInput, opts ...request.Option) (*UpdateAliasOutput, error) {
	req, out := c.UpdateAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBuild = "UpdateBuild"

// UpdateBuildRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBuild operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBuild for more information on using the UpdateBuild
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateBuildRequest method.
//	req, resp := client.UpdateBuildRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateBuild
func (c *GameLift) UpdateBuildRequest(input *UpdateBuildInput) (req *request.Request, output *UpdateBuildOutput) {
	op := &request.Operation{
		Name:       opUpdateBuild,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateBuildInput{}
	}

	output = &UpdateBuildOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBuild API operation for Amazon GameLift.
//
// Updates metadata in a build resource, including the build name and version.
// To update the metadata, specify the build ID to update and provide the new
// values. If successful, a build object containing the updated metadata is
// returned.
//
// Learn more
//
//	Upload a Custom Server Build (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html)
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation UpdateBuild for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateBuild
func (c *GameLift) UpdateBuild(input *UpdateBuildInput) (*UpdateBuildOutput, error) {
	req, out := c.UpdateBuildRequest(input)
	return out, req.Send()
}

// UpdateBuildWithContext is the same as UpdateBuild with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBuild for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) UpdateBuildWithContext(ctx aws.Context, input *UpdateBuildInput, opts ...request.Option) (*UpdateBuildOutput, error) {
	req, out := c.UpdateBuildRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFleetAttributes = "UpdateFleetAttributes"

// UpdateFleetAttributesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFleetAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFleetAttributes for more information on using the UpdateFleetAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateFleetAttributesRequest method.
//	req, resp := client.UpdateFleetAttributesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateFleetAttributes
func (c *GameLift) UpdateFleetAttributesRequest(input *UpdateFleetAttributesInput) (req *request.Request, output *UpdateFleetAttributesOutput) {
	op := &request.Operation{
		Name:       opUpdateFleetAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateFleetAttributesInput{}
	}

	output = &UpdateFleetAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFleetAttributes API operation for Amazon GameLift.
//
// Updates a fleet's mutable attributes, including game session protection and
// resource creation limits.
//
// To update fleet attributes, specify the fleet ID and the property values
// that you want to change.
//
// If successful, an updated FleetAttributes object is returned.
//
// # Learn more
//
// Setting up Amazon GameLift fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation UpdateFleetAttributes for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - ConflictException
//     The requested operation would cause a conflict with the current state of
//     a service resource associated with the request. Resolve the conflict before
//     retrying this request.
//
//   - InvalidFleetStatusException
//     The requested operation would cause a conflict with the current state of
//     a resource associated with the request and/or the fleet. Resolve the conflict
//     before retrying.
//
//   - LimitExceededException
//     The requested operation would cause the resource to exceed the allowed service
//     limit. Resolve the issue before retrying.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateFleetAttributes
func (c *GameLift) UpdateFleetAttributes(input *UpdateFleetAttributesInput) (*UpdateFleetAttributesOutput, error) {
	req, out := c.UpdateFleetAttributesRequest(input)
	return out, req.Send()
}

// UpdateFleetAttributesWithContext is the same as UpdateFleetAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFleetAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) UpdateFleetAttributesWithContext(ctx aws.Context, input *UpdateFleetAttributesInput, opts ...request.Option) (*UpdateFleetAttributesOutput, error) {
	req, out := c.UpdateFleetAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFleetCapacity = "UpdateFleetCapacity"

// UpdateFleetCapacityRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFleetCapacity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFleetCapacity for more information on using the UpdateFleetCapacity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateFleetCapacityRequest method.
//	req, resp := client.UpdateFleetCapacityRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateFleetCapacity
func (c *GameLift) UpdateFleetCapacityRequest(input *UpdateFleetCapacityInput) (req *request.Request, output *UpdateFleetCapacityOutput) {
	op := &request.Operation{
		Name:       opUpdateFleetCapacity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateFleetCapacityInput{}
	}

	output = &UpdateFleetCapacityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFleetCapacity API operation for Amazon GameLift.
//
// Updates capacity settings for a fleet. For fleets with multiple locations,
// use this operation to manage capacity settings in each location individually.
// Fleet capacity determines the number of game sessions and players that can
// be hosted based on the fleet configuration. Use this operation to set the
// following fleet capacity properties:
//
//   - Minimum/maximum size: Set hard limits on fleet capacity. Amazon GameLift
//     cannot set the fleet's capacity to a value outside of this range, whether
//     the capacity is changed manually or through automatic scaling.
//
//   - Desired capacity: Manually set the number of Amazon EC2 instances to
//     be maintained in a fleet location. Before changing a fleet's desired capacity,
//     you may want to call DescribeEC2InstanceLimits (https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeEC2InstanceLimits.html)
//     to get the maximum capacity of the fleet's Amazon EC2 instance type. Alternatively,
//     consider using automatic scaling to adjust capacity based on player demand.
//
// This operation can be used in the following ways:
//
//   - To update capacity for a fleet's home Region, or if the fleet has no
//     remote locations, omit the Location parameter. The fleet must be in ACTIVE
//     status.
//
//   - To update capacity for a fleet's remote location, include the Location
//     parameter set to the location to be updated. The location must be in ACTIVE
//     status.
//
// If successful, capacity settings are updated immediately. In response a change
// in desired capacity, Amazon GameLift initiates steps to start new instances
// or terminate existing instances in the requested fleet location. This continues
// until the location's active instance count matches the new desired instance
// count. You can track a fleet's current capacity by calling DescribeFleetCapacity
// (https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetCapacity.html)
// or DescribeFleetLocationCapacity (https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationCapacity.html).
// If the requested desired instance count is higher than the instance type's
// limit, the LimitExceeded exception occurs.
//
// # Learn more
//
// Scaling fleet capacity (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-manage-capacity.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation UpdateFleetCapacity for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - ConflictException
//     The requested operation would cause a conflict with the current state of
//     a service resource associated with the request. Resolve the conflict before
//     retrying this request.
//
//   - LimitExceededException
//     The requested operation would cause the resource to exceed the allowed service
//     limit. Resolve the issue before retrying.
//
//   - InvalidFleetStatusException
//     The requested operation would cause a conflict with the current state of
//     a resource associated with the request and/or the fleet. Resolve the conflict
//     before retrying.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - UnsupportedRegionException
//     The requested operation is not supported in the Region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateFleetCapacity
func (c *GameLift) UpdateFleetCapacity(input *UpdateFleetCapacityInput) (*UpdateFleetCapacityOutput, error) {
	req, out := c.UpdateFleetCapacityRequest(input)
	return out, req.Send()
}

// UpdateFleetCapacityWithContext is the same as UpdateFleetCapacity with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFleetCapacity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) UpdateFleetCapacityWithContext(ctx aws.Context, input *UpdateFleetCapacityInput, opts ...request.Option) (*UpdateFleetCapacityOutput, error) {
	req, out := c.UpdateFleetCapacityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFleetPortSettings = "UpdateFleetPortSettings"

// UpdateFleetPortSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFleetPortSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFleetPortSettings for more information on using the UpdateFleetPortSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateFleetPortSettingsRequest method.
//	req, resp := client.UpdateFleetPortSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateFleetPortSettings
func (c *GameLift) UpdateFleetPortSettingsRequest(input *UpdateFleetPortSettingsInput) (req *request.Request, output *UpdateFleetPortSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateFleetPortSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateFleetPortSettingsInput{}
	}

	output = &UpdateFleetPortSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFleetPortSettings API operation for Amazon GameLift.
//
// Updates permissions that allow inbound traffic to connect to game sessions
// that are being hosted on instances in the fleet.
//
// To update settings, specify the fleet ID to be updated and specify the changes
// to be made. List the permissions you want to add in InboundPermissionAuthorizations,
// and permissions you want to remove in InboundPermissionRevocations. Permissions
// to be removed must match existing fleet permissions.
//
// If successful, the fleet ID for the updated fleet is returned. For fleets
// with remote locations, port setting updates can take time to propagate across
// all locations. You can check the status of updates in each location by calling
// DescribeFleetPortSettings with a location name.
//
// # Learn more
//
// Setting up Amazon GameLift fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation UpdateFleetPortSettings for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - ConflictException
//     The requested operation would cause a conflict with the current state of
//     a service resource associated with the request. Resolve the conflict before
//     retrying this request.
//
//   - InvalidFleetStatusException
//     The requested operation would cause a conflict with the current state of
//     a resource associated with the request and/or the fleet. Resolve the conflict
//     before retrying.
//
//   - LimitExceededException
//     The requested operation would cause the resource to exceed the allowed service
//     limit. Resolve the issue before retrying.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateFleetPortSettings
func (c *GameLift) UpdateFleetPortSettings(input *UpdateFleetPortSettingsInput) (*UpdateFleetPortSettingsOutput, error) {
	req, out := c.UpdateFleetPortSettingsRequest(input)
	return out, req.Send()
}

// UpdateFleetPortSettingsWithContext is the same as UpdateFleetPortSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFleetPortSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) UpdateFleetPortSettingsWithContext(ctx aws.Context, input *UpdateFleetPortSettingsInput, opts ...request.Option) (*UpdateFleetPortSettingsOutput, error) {
	req, out := c.UpdateFleetPortSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGameServer = "UpdateGameServer"

// UpdateGameServerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGameServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGameServer for more information on using the UpdateGameServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateGameServerRequest method.
//	req, resp := client.UpdateGameServerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateGameServer
func (c *GameLift) UpdateGameServerRequest(input *UpdateGameServerInput) (req *request.Request, output *UpdateGameServerOutput) {
	op := &request.Operation{
		Name:       opUpdateGameServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGameServerInput{}
	}

	output = &UpdateGameServerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGameServer API operation for Amazon GameLift.
//
// This operation is used with the Amazon GameLift FleetIQ solution and game
// server groups.
//
// Updates information about a registered game server to help Amazon GameLift
// FleetIQ track game server availability. This operation is called by a game
// server process that is running on an instance in a game server group.
//
// Use this operation to update the following types of game server information.
// You can make all three types of updates in the same request:
//
//   - To update the game server's utilization status from AVAILABLE (when
//     the game server is available to be claimed) to UTILIZED (when the game
//     server is currently hosting games). Identify the game server and game
//     server group and specify the new utilization status. You can't change
//     the status from to UTILIZED to AVAILABLE .
//
//   - To report health status, identify the game server and game server group
//     and set health check to HEALTHY. If a game server does not report health
//     status for a certain length of time, the game server is no longer considered
//     healthy. As a result, it will be eventually deregistered from the game
//     server group to avoid affecting utilization metrics. The best practice
//     is to report health every 60 seconds.
//
//   - To change game server metadata, provide updated game server data.
//
// Once a game server is successfully updated, the relevant statuses and timestamps
// are updated.
//
// # Learn more
//
// Amazon GameLift FleetIQ Guide (https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation UpdateGameServer for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateGameServer
func (c *GameLift) UpdateGameServer(input *UpdateGameServerInput) (*UpdateGameServerOutput, error) {
	req, out := c.UpdateGameServerRequest(input)
	return out, req.Send()
}

// UpdateGameServerWithContext is the same as UpdateGameServer with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGameServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) UpdateGameServerWithContext(ctx aws.Context, input *UpdateGameServerInput, opts ...request.Option) (*UpdateGameServerOutput, error) {
	req, out := c.UpdateGameServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGameServerGroup = "UpdateGameServerGroup"

// UpdateGameServerGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGameServerGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGameServerGroup for more information on using the UpdateGameServerGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateGameServerGroupRequest method.
//	req, resp := client.UpdateGameServerGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateGameServerGroup
func (c *GameLift) UpdateGameServerGroupRequest(input *UpdateGameServerGroupInput) (req *request.Request, output *UpdateGameServerGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateGameServerGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGameServerGroupInput{}
	}

	output = &UpdateGameServerGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGameServerGroup API operation for Amazon GameLift.
//
// This operation is used with the Amazon GameLift FleetIQ solution and game
// server groups.
//
// Updates Amazon GameLift FleetIQ-specific properties for a game server group.
// Many Auto Scaling group properties are updated on the Auto Scaling group
// directly, including the launch template, Auto Scaling policies, and maximum/minimum/desired
// instance counts.
//
// To update the game server group, specify the game server group ID and provide
// the updated values. Before applying the updates, the new values are validated
// to ensure that Amazon GameLift FleetIQ can continue to perform instance balancing
// activity. If successful, a GameServerGroup object is returned.
//
// # Learn more
//
// Amazon GameLift FleetIQ Guide (https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation UpdateGameServerGroup for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateGameServerGroup
func (c *GameLift) UpdateGameServerGroup(input *UpdateGameServerGroupInput) (*UpdateGameServerGroupOutput, error) {
	req, out := c.UpdateGameServerGroupRequest(input)
	return out, req.Send()
}

// UpdateGameServerGroupWithContext is the same as UpdateGameServerGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGameServerGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) UpdateGameServerGroupWithContext(ctx aws.Context, input *UpdateGameServerGroupInput, opts ...request.Option) (*UpdateGameServerGroupOutput, error) {
	req, out := c.UpdateGameServerGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGameSession = "UpdateGameSession"

// UpdateGameSessionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGameSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGameSession for more information on using the UpdateGameSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateGameSessionRequest method.
//	req, resp := client.UpdateGameSessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateGameSession
func (c *GameLift) UpdateGameSessionRequest(input *UpdateGameSessionInput) (req *request.Request, output *UpdateGameSessionOutput) {
	op := &request.Operation{
		Name:       opUpdateGameSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGameSessionInput{}
	}

	output = &UpdateGameSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGameSession API operation for Amazon GameLift.
//
// Updates the mutable properties of a game session.
//
// To update a game session, specify the game session ID and the values you
// want to change.
//
// If successful, the updated GameSession object is returned.
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation UpdateGameSession for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - ConflictException
//     The requested operation would cause a conflict with the current state of
//     a service resource associated with the request. Resolve the conflict before
//     retrying this request.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidGameSessionStatusException
//     The requested operation would cause a conflict with the current state of
//     a resource associated with the request and/or the game instance. Resolve
//     the conflict before retrying.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateGameSession
func (c *GameLift) UpdateGameSession(input *UpdateGameSessionInput) (*UpdateGameSessionOutput, error) {
	req, out := c.UpdateGameSessionRequest(input)
	return out, req.Send()
}

// UpdateGameSessionWithContext is the same as UpdateGameSession with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGameSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) UpdateGameSessionWithContext(ctx aws.Context, input *UpdateGameSessionInput, opts ...request.Option) (*UpdateGameSessionOutput, error) {
	req, out := c.UpdateGameSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGameSessionQueue = "UpdateGameSessionQueue"

// UpdateGameSessionQueueRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGameSessionQueue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGameSessionQueue for more information on using the UpdateGameSessionQueue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateGameSessionQueueRequest method.
//	req, resp := client.UpdateGameSessionQueueRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateGameSessionQueue
func (c *GameLift) UpdateGameSessionQueueRequest(input *UpdateGameSessionQueueInput) (req *request.Request, output *UpdateGameSessionQueueOutput) {
	op := &request.Operation{
		Name:       opUpdateGameSessionQueue,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGameSessionQueueInput{}
	}

	output = &UpdateGameSessionQueueOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGameSessionQueue API operation for Amazon GameLift.
//
// Updates the configuration of a game session queue, which determines how the
// queue processes new game session requests. To update settings, specify the
// queue name to be updated and provide the new settings. When updating destinations,
// provide a complete list of destinations.
//
// Learn more
//
//	Using Multi-Region Queues (https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-intro.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation UpdateGameSessionQueue for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateGameSessionQueue
func (c *GameLift) UpdateGameSessionQueue(input *UpdateGameSessionQueueInput) (*UpdateGameSessionQueueOutput, error) {
	req, out := c.UpdateGameSessionQueueRequest(input)
	return out, req.Send()
}

// UpdateGameSessionQueueWithContext is the same as UpdateGameSessionQueue with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGameSessionQueue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) UpdateGameSessionQueueWithContext(ctx aws.Context, input *UpdateGameSessionQueueInput, opts ...request.Option) (*UpdateGameSessionQueueOutput, error) {
	req, out := c.UpdateGameSessionQueueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMatchmakingConfiguration = "UpdateMatchmakingConfiguration"

// UpdateMatchmakingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMatchmakingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMatchmakingConfiguration for more information on using the UpdateMatchmakingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateMatchmakingConfigurationRequest method.
//	req, resp := client.UpdateMatchmakingConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateMatchmakingConfiguration
func (c *GameLift) UpdateMatchmakingConfigurationRequest(input *UpdateMatchmakingConfigurationInput) (req *request.Request, output *UpdateMatchmakingConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateMatchmakingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateMatchmakingConfigurationInput{}
	}

	output = &UpdateMatchmakingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMatchmakingConfiguration API operation for Amazon GameLift.
//
// Updates settings for a FlexMatch matchmaking configuration. These changes
// affect all matches and game sessions that are created after the update. To
// update settings, specify the configuration name to be updated and provide
// the new settings.
//
// Learn more
//
//	Design a FlexMatch matchmaker (https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-configuration.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation UpdateMatchmakingConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - UnsupportedRegionException
//     The requested operation is not supported in the Region specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateMatchmakingConfiguration
func (c *GameLift) UpdateMatchmakingConfiguration(input *UpdateMatchmakingConfigurationInput) (*UpdateMatchmakingConfigurationOutput, error) {
	req, out := c.UpdateMatchmakingConfigurationRequest(input)
	return out, req.Send()
}

// UpdateMatchmakingConfigurationWithContext is the same as UpdateMatchmakingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMatchmakingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) UpdateMatchmakingConfigurationWithContext(ctx aws.Context, input *UpdateMatchmakingConfigurationInput, opts ...request.Option) (*UpdateMatchmakingConfigurationOutput, error) {
	req, out := c.UpdateMatchmakingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRuntimeConfiguration = "UpdateRuntimeConfiguration"

// UpdateRuntimeConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRuntimeConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRuntimeConfiguration for more information on using the UpdateRuntimeConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRuntimeConfigurationRequest method.
//	req, resp := client.UpdateRuntimeConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateRuntimeConfiguration
func (c *GameLift) UpdateRuntimeConfigurationRequest(input *UpdateRuntimeConfigurationInput) (req *request.Request, output *UpdateRuntimeConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateRuntimeConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRuntimeConfigurationInput{}
	}

	output = &UpdateRuntimeConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRuntimeConfiguration API operation for Amazon GameLift.
//
// Updates the current runtime configuration for the specified fleet, which
// tells Amazon GameLift how to launch server processes on all instances in
// the fleet. You can update a fleet's runtime configuration at any time after
// the fleet is created; it does not need to be in ACTIVE status.
//
// To update runtime configuration, specify the fleet ID and provide a RuntimeConfiguration
// with an updated set of server process configurations.
//
// If successful, the fleet's runtime configuration settings are updated. Each
// instance in the fleet regularly checks for and retrieves updated runtime
// configurations. Instances immediately begin complying with the new configuration
// by launching new server processes or not replacing existing processes when
// they shut down. Updating a fleet's runtime configuration never affects existing
// server processes.
//
// # Learn more
//
// Setting up Amazon GameLift fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation UpdateRuntimeConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - InvalidFleetStatusException
//     The requested operation would cause a conflict with the current state of
//     a resource associated with the request and/or the fleet. Resolve the conflict
//     before retrying.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateRuntimeConfiguration
func (c *GameLift) UpdateRuntimeConfiguration(input *UpdateRuntimeConfigurationInput) (*UpdateRuntimeConfigurationOutput, error) {
	req, out := c.UpdateRuntimeConfigurationRequest(input)
	return out, req.Send()
}

// UpdateRuntimeConfigurationWithContext is the same as UpdateRuntimeConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRuntimeConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) UpdateRuntimeConfigurationWithContext(ctx aws.Context, input *UpdateRuntimeConfigurationInput, opts ...request.Option) (*UpdateRuntimeConfigurationOutput, error) {
	req, out := c.UpdateRuntimeConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateScript = "UpdateScript"

// UpdateScriptRequest generates a "aws/request.Request" representing the
// client's request for the UpdateScript operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateScript for more information on using the UpdateScript
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateScriptRequest method.
//	req, resp := client.UpdateScriptRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateScript
func (c *GameLift) UpdateScriptRequest(input *UpdateScriptInput) (req *request.Request, output *UpdateScriptOutput) {
	op := &request.Operation{
		Name:       opUpdateScript,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateScriptInput{}
	}

	output = &UpdateScriptOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateScript API operation for Amazon GameLift.
//
// Updates Realtime script metadata and content.
//
// To update script metadata, specify the script ID and provide updated name
// and/or version values.
//
// To update script content, provide an updated zip file by pointing to either
// a local file or an Amazon S3 bucket location. You can use either method regardless
// of how the original script was uploaded. Use the Version parameter to track
// updates to the script.
//
// If the call is successful, the updated metadata is stored in the script record
// and a revised script is uploaded to the Amazon GameLift service. Once the
// script is updated and acquired by a fleet instance, the new version is used
// for all new game sessions.
//
// # Learn more
//
// Amazon GameLift Realtime Servers (https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html)
//
// # Related actions
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation UpdateScript for usage and error information.
//
// Returned Error Types:
//
//   - UnauthorizedException
//     The client failed authentication. Clients should not retry such requests.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
//   - NotFoundException
//     THe requested resources was not found. The resource was either not created
//     yet or deleted.
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/UpdateScript
func (c *GameLift) UpdateScript(input *UpdateScriptInput) (*UpdateScriptOutput, error) {
	req, out := c.UpdateScriptRequest(input)
	return out, req.Send()
}

// UpdateScriptWithContext is the same as UpdateScript with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateScript for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) UpdateScriptWithContext(ctx aws.Context, input *UpdateScriptInput, opts ...request.Option) (*UpdateScriptOutput, error) {
	req, out := c.UpdateScriptRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opValidateMatchmakingRuleSet = "ValidateMatchmakingRuleSet"

// ValidateMatchmakingRuleSetRequest generates a "aws/request.Request" representing the
// client's request for the ValidateMatchmakingRuleSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ValidateMatchmakingRuleSet for more information on using the ValidateMatchmakingRuleSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ValidateMatchmakingRuleSetRequest method.
//	req, resp := client.ValidateMatchmakingRuleSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ValidateMatchmakingRuleSet
func (c *GameLift) ValidateMatchmakingRuleSetRequest(input *ValidateMatchmakingRuleSetInput) (req *request.Request, output *ValidateMatchmakingRuleSetOutput) {
	op := &request.Operation{
		Name:       opValidateMatchmakingRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ValidateMatchmakingRuleSetInput{}
	}

	output = &ValidateMatchmakingRuleSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ValidateMatchmakingRuleSet API operation for Amazon GameLift.
//
// Validates the syntax of a matchmaking rule or rule set. This operation checks
// that the rule set is using syntactically correct JSON and that it conforms
// to allowed property expressions. To validate syntax, provide a rule set JSON
// string.
//
// Learn more
//
//   - Build a rule set (https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon GameLift's
// API operation ValidateMatchmakingRuleSet for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     The service encountered an unrecoverable internal failure while processing
//     the request. Clients can retry such requests immediately or after a waiting
//     period.
//
//   - UnsupportedRegionException
//     The requested operation is not supported in the Region specified.
//
//   - InvalidRequestException
//     One or more parameter values in the request are invalid. Correct the invalid
//     parameter values before retrying.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ValidateMatchmakingRuleSet
func (c *GameLift) ValidateMatchmakingRuleSet(input *ValidateMatchmakingRuleSetInput) (*ValidateMatchmakingRuleSetOutput, error) {
	req, out := c.ValidateMatchmakingRuleSetRequest(input)
	return out, req.Send()
}

// ValidateMatchmakingRuleSetWithContext is the same as ValidateMatchmakingRuleSet with the addition of
// the ability to pass a context and additional request options.
//
// See ValidateMatchmakingRuleSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GameLift) ValidateMatchmakingRuleSetWithContext(ctx aws.Context, input *ValidateMatchmakingRuleSetInput, opts ...request.Option) (*ValidateMatchmakingRuleSetOutput, error) {
	req, out := c.ValidateMatchmakingRuleSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AcceptMatchInput struct {
	_ struct{} `type:"structure"`

	// Player response to the proposed match.
	//
	// AcceptanceType is a required field
	AcceptanceType *string `type:"string" required:"true" enum:"AcceptanceType"`

	// A unique identifier for a player delivering the response. This parameter
	// can include one or multiple player IDs.
	//
	// PlayerIds is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AcceptMatchInput's
	// String and GoString methods.
	//
	// PlayerIds is a required field
	PlayerIds []*string `type:"list" required:"true" sensitive:"true"`

	// A unique identifier for a matchmaking ticket. The ticket must be in status
	// REQUIRES_ACCEPTANCE; otherwise this request will fail.
	//
	// TicketId is a required field
	TicketId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptMatchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptMatchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptMatchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptMatchInput"}
	if s.AcceptanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("AcceptanceType"))
	}
	if s.PlayerIds == nil {
		invalidParams.Add(request.NewErrParamRequired("PlayerIds"))
	}
	if s.TicketId == nil {
		invalidParams.Add(request.NewErrParamRequired("TicketId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptanceType sets the AcceptanceType field's value.
func (s *AcceptMatchInput) SetAcceptanceType(v string) *AcceptMatchInput {
	s.AcceptanceType = &v
	return s
}

// SetPlayerIds sets the PlayerIds field's value.
func (s *AcceptMatchInput) SetPlayerIds(v []*string) *AcceptMatchInput {
	s.PlayerIds = v
	return s
}

// SetTicketId sets the TicketId field's value.
func (s *AcceptMatchInput) SetTicketId(v string) *AcceptMatchInput {
	s.TicketId = &v
	return s
}

type AcceptMatchOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptMatchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptMatchOutput) GoString() string {
	return s.String()
}

// Properties that describe an alias resource.
//
// # Related actions
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
type Alias struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// that is assigned to a Amazon GameLift alias resource and uniquely identifies
	// it. ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::alias/alias-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912.
	// In a GameLift alias ARN, the resource ID matches the alias ID value.
	AliasArn *string `type:"string"`

	// A unique identifier for the alias. Alias IDs are unique within a Region.
	AliasId *string `type:"string"`

	// A time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time `type:"timestamp"`

	// A human-readable description of an alias.
	Description *string `type:"string"`

	// The time that this data object was last modified. Format is a number expressed
	// in Unix time as milliseconds (for example "1469498468.057").
	LastUpdatedTime *time.Time `type:"timestamp"`

	// A descriptive label that is associated with an alias. Alias names do not
	// need to be unique.
	Name *string `min:"1" type:"string"`

	// The routing configuration, including routing type and fleet target, for the
	// alias.
	RoutingStrategy *RoutingStrategy `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Alias) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Alias) GoString() string {
	return s.String()
}

// SetAliasArn sets the AliasArn field's value.
func (s *Alias) SetAliasArn(v string) *Alias {
	s.AliasArn = &v
	return s
}

// SetAliasId sets the AliasId field's value.
func (s *Alias) SetAliasId(v string) *Alias {
	s.AliasId = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Alias) SetCreationTime(v time.Time) *Alias {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Alias) SetDescription(v string) *Alias {
	s.Description = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Alias) SetLastUpdatedTime(v time.Time) *Alias {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Alias) SetName(v string) *Alias {
	s.Name = &v
	return s
}

// SetRoutingStrategy sets the RoutingStrategy field's value.
func (s *Alias) SetRoutingStrategy(v *RoutingStrategy) *Alias {
	s.RoutingStrategy = v
	return s
}

// Amazon GameLift Anywhere configuration options for your Anywhere fleets.
type AnywhereConfiguration struct {
	_ struct{} `type:"structure"`

	// The cost to run your fleet per hour. Amazon GameLift uses the provided cost
	// of your fleet to balance usage in queues. For more information about queues,
	// see Setting up queues (https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-intro.html)
	// in the Amazon GameLift Developer Guide.
	//
	// Cost is a required field
	Cost *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnywhereConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnywhereConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnywhereConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnywhereConfiguration"}
	if s.Cost == nil {
		invalidParams.Add(request.NewErrParamRequired("Cost"))
	}
	if s.Cost != nil && len(*s.Cost) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Cost", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCost sets the Cost field's value.
func (s *AnywhereConfiguration) SetCost(v string) *AnywhereConfiguration {
	s.Cost = &v
	return s
}

// Values for use in player attribute key-value pairs. This object lets you
// specify an attribute value using any of the valid data types: string, number,
// string array, or data map. Each AttributeValue object can use only one of
// the available properties.
type AttributeValue struct {
	_ struct{} `type:"structure"`

	// For number values, expressed as double.
	N *float64 `type:"double"`

	// For single string values. Maximum string length is 100 characters.
	S *string `min:"1" type:"string"`

	// For a map of up to 10 data type:value pairs. Maximum length for each string
	// value is 100 characters.
	SDM map[string]*float64 `type:"map"`

	// For a list of up to 100 strings. Maximum length for each string is 100 characters.
	// Duplicate values are not recognized; all occurrences of the repeated value
	// after the first of a repeated value are ignored.
	SL []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttributeValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttributeValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttributeValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttributeValue"}
	if s.S != nil && len(*s.S) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetN sets the N field's value.
func (s *AttributeValue) SetN(v float64) *AttributeValue {
	s.N = &v
	return s
}

// SetS sets the S field's value.
func (s *AttributeValue) SetS(v string) *AttributeValue {
	s.S = &v
	return s
}

// SetSDM sets the SDM field's value.
func (s *AttributeValue) SetSDM(v map[string]*float64) *AttributeValue {
	s.SDM = v
	return s
}

// SetSL sets the SL field's value.
func (s *AttributeValue) SetSL(v []*string) *AttributeValue {
	s.SL = v
	return s
}

// Amazon Web Services account security credentials that allow interactions
// with Amazon GameLift resources. The credentials are temporary and valid for
// a limited time span. You can request fresh credentials at any time.
//
// Amazon Web Services security credentials consist of three parts: an access
// key ID, a secret access key, and a session token. You must use all three
// parts together to authenticate your access requests.
//
// You need Amazon Web Services credentials for the following tasks:
//
//   - To upload a game server build directly to Amazon GameLift S3 storage
//     using CreateBuild. To get access for this task, call RequestUploadCredentials.
//
//   - To remotely connect to an active Amazon GameLift fleet instances. To
//     get remote access, call GetComputeAccess.
type AwsCredentials struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The access key ID that identifies the temporary security credentials.
	AccessKeyId *string `min:"1" type:"string"`

	// The secret access key that can be used to sign requests.
	SecretAccessKey *string `min:"1" type:"string"`

	// The token that users must pass to the service API to use the temporary credentials.
	SessionToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCredentials) GoString() string {
	return s.String()
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *AwsCredentials) SetAccessKeyId(v string) *AwsCredentials {
	s.AccessKeyId = &v
	return s
}

// SetSecretAccessKey sets the SecretAccessKey field's value.
func (s *AwsCredentials) SetSecretAccessKey(v string) *AwsCredentials {
	s.SecretAccessKey = &v
	return s
}

// SetSessionToken sets the SessionToken field's value.
func (s *AwsCredentials) SetSessionToken(v string) *AwsCredentials {
	s.SessionToken = &v
	return s
}

// Properties describing a custom game build.
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
type Build struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// assigned to a Amazon GameLift build resource and uniquely identifies it.
	// ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::build/build-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912.
	// In a GameLift build ARN, the resource ID matches the BuildId value.
	BuildArn *string `type:"string"`

	// A unique identifier for the build.
	BuildId *string `type:"string"`

	// A time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time `type:"timestamp"`

	// A descriptive label associated with a build. Build names don't need to be
	// unique. It can be set using CreateBuild (https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateBuild.html)
	// or UpdateBuild (https://docs.aws.amazon.com/gamelift/latest/apireference/UpdateBuild).
	Name *string `type:"string"`

	// Operating system that the game server binaries are built to run on. This
	// value determines the type of fleet resources that you can use for this build.
	OperatingSystem *string `type:"string" enum:"OperatingSystem"`

	// The Amazon GameLift Server SDK version used to develop your game server.
	ServerSdkVersion *string `type:"string"`

	// File size of the uploaded game build, expressed in bytes. When the build
	// status is INITIALIZED or when using a custom Amazon S3 storage location,
	// this value is 0.
	SizeOnDisk *int64 `min:"1" type:"long"`

	// Current status of the build.
	//
	// Possible build statuses include the following:
	//
	//    * INITIALIZED -- A new build has been defined, but no files have been
	//    uploaded. You cannot create fleets for builds that are in this status.
	//    When a build is successfully created, the build status is set to this
	//    value.
	//
	//    * READY -- The game build has been successfully uploaded. You can now
	//    create new fleets for this build.
	//
	//    * FAILED -- The game build upload failed. You cannot create new fleets
	//    for this build.
	Status *string `type:"string" enum:"BuildStatus"`

	// Version information associated with a build or script. Version strings don't
	// need to be unique.
	Version *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Build) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Build) GoString() string {
	return s.String()
}

// SetBuildArn sets the BuildArn field's value.
func (s *Build) SetBuildArn(v string) *Build {
	s.BuildArn = &v
	return s
}

// SetBuildId sets the BuildId field's value.
func (s *Build) SetBuildId(v string) *Build {
	s.BuildId = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Build) SetCreationTime(v time.Time) *Build {
	s.CreationTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Build) SetName(v string) *Build {
	s.Name = &v
	return s
}

// SetOperatingSystem sets the OperatingSystem field's value.
func (s *Build) SetOperatingSystem(v string) *Build {
	s.OperatingSystem = &v
	return s
}

// SetServerSdkVersion sets the ServerSdkVersion field's value.
func (s *Build) SetServerSdkVersion(v string) *Build {
	s.ServerSdkVersion = &v
	return s
}

// SetSizeOnDisk sets the SizeOnDisk field's value.
func (s *Build) SetSizeOnDisk(v int64) *Build {
	s.SizeOnDisk = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Build) SetStatus(v string) *Build {
	s.Status = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *Build) SetVersion(v string) *Build {
	s.Version = &v
	return s
}

// Determines whether a TLS/SSL certificate is generated for a fleet. This feature
// must be enabled when creating the fleet. All instances in a fleet share the
// same certificate. The certificate can be retrieved by calling the Amazon
// GameLift Server SDK (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk.html)
// operation GetInstanceCertificate.
type CertificateConfiguration struct {
	_ struct{} `type:"structure"`

	// Indicates whether a TLS/SSL certificate is generated for a fleet.
	//
	// Valid values include:
	//
	//    * GENERATED - Generate a TLS/SSL certificate for this fleet.
	//
	//    * DISABLED - (default) Do not generate a TLS/SSL certificate for this
	//    fleet.
	//
	// CertificateType is a required field
	CertificateType *string `type:"string" required:"true" enum:"CertificateType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CertificateConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CertificateConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CertificateConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CertificateConfiguration"}
	if s.CertificateType == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateType sets the CertificateType field's value.
func (s *CertificateConfiguration) SetCertificateType(v string) *CertificateConfiguration {
	s.CertificateType = &v
	return s
}

// This data type is used with the Amazon GameLift FleetIQ and game server groups.
//
// Filters which game servers may be claimed when calling ClaimGameServer.
type ClaimFilterOption struct {
	_ struct{} `type:"structure"`

	// List of instance statuses that game servers may be claimed on. If provided,
	// the list must contain the ACTIVE status.
	InstanceStatuses []*string `type:"list" enum:"FilterInstanceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClaimFilterOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClaimFilterOption) GoString() string {
	return s.String()
}

// SetInstanceStatuses sets the InstanceStatuses field's value.
func (s *ClaimFilterOption) SetInstanceStatuses(v []*string) *ClaimFilterOption {
	s.InstanceStatuses = v
	return s
}

type ClaimGameServerInput struct {
	_ struct{} `type:"structure"`

	// Object that restricts how a claimed game server is chosen.
	FilterOption *ClaimFilterOption `type:"structure"`

	// A set of custom game server properties, formatted as a single string value.
	// This data is passed to a game client or service when it requests information
	// on game servers.
	GameServerData *string `min:"1" type:"string"`

	// A unique identifier for the game server group where the game server is running.
	// If you are not specifying a game server to claim, this value identifies where
	// you want Amazon GameLift FleetIQ to look for an available game server to
	// claim.
	//
	// GameServerGroupName is a required field
	GameServerGroupName *string `min:"1" type:"string" required:"true"`

	// A custom string that uniquely identifies the game server to claim. If this
	// parameter is left empty, Amazon GameLift FleetIQ searches for an available
	// game server in the specified game server group.
	GameServerId *string `min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClaimGameServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClaimGameServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ClaimGameServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ClaimGameServerInput"}
	if s.GameServerData != nil && len(*s.GameServerData) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameServerData", 1))
	}
	if s.GameServerGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameServerGroupName"))
	}
	if s.GameServerGroupName != nil && len(*s.GameServerGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameServerGroupName", 1))
	}
	if s.GameServerId != nil && len(*s.GameServerId) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("GameServerId", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterOption sets the FilterOption field's value.
func (s *ClaimGameServerInput) SetFilterOption(v *ClaimFilterOption) *ClaimGameServerInput {
	s.FilterOption = v
	return s
}

// SetGameServerData sets the GameServerData field's value.
func (s *ClaimGameServerInput) SetGameServerData(v string) *ClaimGameServerInput {
	s.GameServerData = &v
	return s
}

// SetGameServerGroupName sets the GameServerGroupName field's value.
func (s *ClaimGameServerInput) SetGameServerGroupName(v string) *ClaimGameServerInput {
	s.GameServerGroupName = &v
	return s
}

// SetGameServerId sets the GameServerId field's value.
func (s *ClaimGameServerInput) SetGameServerId(v string) *ClaimGameServerInput {
	s.GameServerId = &v
	return s
}

type ClaimGameServerOutput struct {
	_ struct{} `type:"structure"`

	// Object that describes the newly claimed game server.
	GameServer *GameServer `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClaimGameServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClaimGameServerOutput) GoString() string {
	return s.String()
}

// SetGameServer sets the GameServer field's value.
func (s *ClaimGameServerOutput) SetGameServer(v *GameServer) *ClaimGameServerOutput {
	s.GameServer = v
	return s
}

// An Amazon GameLift compute resource for hosting your game servers. A compute
// can be an EC2instance in a managed EC2 fleet or a registered compute in an
// Anywhere fleet.
type Compute struct {
	_ struct{} `type:"structure"`

	// The ARN that is assigned to a compute resource and uniquely identifies it.
	// ARNs are unique across locations. Instances in managed EC2 fleets are not
	// assigned a ComputeARN.
	ComputeArn *string `type:"string"`

	// A descriptive label for the compute resource. For instances in a managed
	// EC2 fleet, the compute name is an instance ID.
	ComputeName *string `min:"1" type:"string"`

	// Current status of the compute. A compute must have an ACTIVE status to host
	// game sessions.
	ComputeStatus *string `type:"string" enum:"ComputeStatus"`

	// A time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time `type:"timestamp"`

	// The DNS name of a compute resource. Amazon GameLift requires a DNS name or
	// IP address for a compute.
	DnsName *string `type:"string"`

	// The Amazon Resource Name (ARN) of the fleet that the compute belongs to.
	FleetArn *string `type:"string"`

	// A unique identifier for the fleet that the compute belongs to.
	FleetId *string `type:"string"`

	// The Amazon GameLift SDK endpoint connection for a registered compute resource
	// in an Anywhere fleet. The game servers on the compute use this endpoint to
	// connect to the Amazon GameLift service.
	GameLiftServiceSdkEndpoint *string `min:"1" type:"string"`

	// The IP address of a compute resource. Amazon GameLift requires a DNS name
	// or IP address for a compute.
	//
	// IpAddress is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Compute's
	// String and GoString methods.
	IpAddress *string `min:"1" type:"string" sensitive:"true"`

	// The name of the custom location you added to the fleet that this compute
	// resource resides in.
	Location *string `min:"1" type:"string"`

	// The type of operating system on the compute resource.
	OperatingSystem *string `type:"string" enum:"OperatingSystem"`

	// The Amazon EC2 instance type that the fleet uses. For registered computes
	// in an Amazon GameLift Anywhere fleet, this property is empty.
	Type *string `type:"string" enum:"EC2InstanceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Compute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Compute) GoString() string {
	return s.String()
}

// SetComputeArn sets the ComputeArn field's value.
func (s *Compute) SetComputeArn(v string) *Compute {
	s.ComputeArn = &v
	return s
}

// SetComputeName sets the ComputeName field's value.
func (s *Compute) SetComputeName(v string) *Compute {
	s.ComputeName = &v
	return s
}

// SetComputeStatus sets the ComputeStatus field's value.
func (s *Compute) SetComputeStatus(v string) *Compute {
	s.ComputeStatus = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Compute) SetCreationTime(v time.Time) *Compute {
	s.CreationTime = &v
	return s
}

// SetDnsName sets the DnsName field's value.
func (s *Compute) SetDnsName(v string) *Compute {
	s.DnsName = &v
	return s
}

// SetFleetArn sets the FleetArn field's value.
func (s *Compute) SetFleetArn(v string) *Compute {
	s.FleetArn = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *Compute) SetFleetId(v string) *Compute {
	s.FleetId = &v
	return s
}

// SetGameLiftServiceSdkEndpoint sets the GameLiftServiceSdkEndpoint field's value.
func (s *Compute) SetGameLiftServiceSdkEndpoint(v string) *Compute {
	s.GameLiftServiceSdkEndpoint = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *Compute) SetIpAddress(v string) *Compute {
	s.IpAddress = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *Compute) SetLocation(v string) *Compute {
	s.Location = &v
	return s
}

// SetOperatingSystem sets the OperatingSystem field's value.
func (s *Compute) SetOperatingSystem(v string) *Compute {
	s.OperatingSystem = &v
	return s
}

// SetType sets the Type field's value.
func (s *Compute) SetType(v string) *Compute {
	s.Type = &v
	return s
}

// The requested operation would cause a conflict with the current state of
// a service resource associated with the request. Resolve the conflict before
// retrying this request.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateAliasInput struct {
	_ struct{} `type:"structure"`

	// A human-readable description of the alias.
	Description *string `min:"1" type:"string"`

	// A descriptive label that is associated with an alias. Alias names do not
	// need to be unique.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The routing configuration, including routing type and fleet target, for the
	// alias.
	//
	// RoutingStrategy is a required field
	RoutingStrategy *RoutingStrategy `type:"structure" required:"true"`

	// A list of labels to assign to the new alias resource. Tags are developer-defined
	// key-value pairs. Tagging Amazon Web Services resources are useful for resource
	// management, access management and cost allocation. For more information,
	// see Tagging Amazon Web Services Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// in the Amazon Web Services General Reference.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAliasInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoutingStrategy == nil {
		invalidParams.Add(request.NewErrParamRequired("RoutingStrategy"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateAliasInput) SetDescription(v string) *CreateAliasInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAliasInput) SetName(v string) *CreateAliasInput {
	s.Name = &v
	return s
}

// SetRoutingStrategy sets the RoutingStrategy field's value.
func (s *CreateAliasInput) SetRoutingStrategy(v *RoutingStrategy) *CreateAliasInput {
	s.RoutingStrategy = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAliasInput) SetTags(v []*Tag) *CreateAliasInput {
	s.Tags = v
	return s
}

type CreateAliasOutput struct {
	_ struct{} `type:"structure"`

	// The newly created alias resource.
	Alias *Alias `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAliasOutput) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *CreateAliasOutput) SetAlias(v *Alias) *CreateAliasOutput {
	s.Alias = v
	return s
}

type CreateBuildInput struct {
	_ struct{} `type:"structure"`

	// A descriptive label associated with a build. Build names don't need to be
	// unique. You can change this value later.
	Name *string `min:"1" type:"string"`

	// The operating system that your game server binaries run on. This value determines
	// the type of fleet resources that you use for this build. If your game build
	// contains multiple executables, they all must run on the same operating system.
	// You must specify a valid operating system in this request. There is no default
	// value. You can't change a build's operating system later.
	//
	// If you have active fleets using the Windows Server 2012 operating system,
	// you can continue to create new builds using this OS until October 10, 2023,
	// when Microsoft ends its support. All others must use Windows Server 2016
	// when creating new Windows-based builds.
	OperatingSystem *string `type:"string" enum:"OperatingSystem"`

	// A server SDK version you used when integrating your game server build with
	// Amazon GameLift. For more information see Integrate games with custom game
	// servers (https://docs.aws.amazon.com/gamelift/latest/developerguide/integration-custom-intro.html).
	// By default Amazon GameLift sets this value to 4.0.2.
	ServerSdkVersion *string `type:"string"`

	// Information indicating where your game build files are stored. Use this parameter
	// only when creating a build with files stored in an Amazon S3 bucket that
	// you own. The storage location must specify an Amazon S3 bucket name and key.
	// The location must also specify a role ARN that you set up to allow Amazon
	// GameLift to access your Amazon S3 bucket. The S3 bucket and your new build
	// must be in the same Region.
	//
	// If a StorageLocation is specified, the size of your file can be found in
	// your Amazon S3 bucket. Amazon GameLift will report a SizeOnDisk of 0.
	StorageLocation *S3Location `type:"structure"`

	// A list of labels to assign to the new build resource. Tags are developer
	// defined key-value pairs. Tagging Amazon Web Services resources are useful
	// for resource management, access management and cost allocation. For more
	// information, see Tagging Amazon Web Services Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// in the Amazon Web Services General Reference. Once the resource is created,
	// you can use TagResource (https://docs.aws.amazon.com/gamelift/latest/apireference/API_TagResource.html),
	// UntagResource (https://docs.aws.amazon.com/gamelift/latest/apireference/API_UntagResource.html),
	// and ListTagsForResource (https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListTagsForResource.html)
	// to add, remove, and view tags. The maximum tag limit may be lower than stated.
	// See the Amazon Web Services General Reference for actual tagging limits.
	Tags []*Tag `type:"list"`

	// Version information associated with a build or script. Version strings don't
	// need to be unique. You can change this value later.
	Version *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBuildInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBuildInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBuildInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBuildInput"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}
	if s.StorageLocation != nil {
		if err := s.StorageLocation.Validate(); err != nil {
			invalidParams.AddNested("StorageLocation", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateBuildInput) SetName(v string) *CreateBuildInput {
	s.Name = &v
	return s
}

// SetOperatingSystem sets the OperatingSystem field's value.
func (s *CreateBuildInput) SetOperatingSystem(v string) *CreateBuildInput {
	s.OperatingSystem = &v
	return s
}

// SetServerSdkVersion sets the ServerSdkVersion field's value.
func (s *CreateBuildInput) SetServerSdkVersion(v string) *CreateBuildInput {
	s.ServerSdkVersion = &v
	return s
}

// SetStorageLocation sets the StorageLocation field's value.
func (s *CreateBuildInput) SetStorageLocation(v *S3Location) *CreateBuildInput {
	s.StorageLocation = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateBuildInput) SetTags(v []*Tag) *CreateBuildInput {
	s.Tags = v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateBuildInput) SetVersion(v string) *CreateBuildInput {
	s.Version = &v
	return s
}

type CreateBuildOutput struct {
	_ struct{} `type:"structure"`

	// The newly created build resource, including a unique build IDs and status.
	Build *Build `type:"structure"`

	// Amazon S3 location for your game build file, including bucket name and key.
	StorageLocation *S3Location `type:"structure"`

	// This element is returned only when the operation is called without a storage
	// location. It contains credentials to use when you are uploading a build file
	// to an Amazon S3 bucket that is owned by Amazon GameLift. Credentials have
	// a limited life span. To refresh these credentials, call RequestUploadCredentials
	// (https://docs.aws.amazon.com/gamelift/latest/apireference/API_RequestUploadCredentials.html).
	//
	// UploadCredentials is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateBuildOutput's
	// String and GoString methods.
	UploadCredentials *AwsCredentials `type:"structure" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBuildOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBuildOutput) GoString() string {
	return s.String()
}

// SetBuild sets the Build field's value.
func (s *CreateBuildOutput) SetBuild(v *Build) *CreateBuildOutput {
	s.Build = v
	return s
}

// SetStorageLocation sets the StorageLocation field's value.
func (s *CreateBuildOutput) SetStorageLocation(v *S3Location) *CreateBuildOutput {
	s.StorageLocation = v
	return s
}

// SetUploadCredentials sets the UploadCredentials field's value.
func (s *CreateBuildOutput) SetUploadCredentials(v *AwsCredentials) *CreateBuildOutput {
	s.UploadCredentials = v
	return s
}

type CreateFleetInput struct {
	_ struct{} `type:"structure"`

	// Amazon GameLift Anywhere configuration options.
	AnywhereConfiguration *AnywhereConfiguration `type:"structure"`

	// The unique identifier for a custom game server build to be deployed on fleet
	// instances. You can use either the build ID or ARN. The build must be uploaded
	// to Amazon GameLift and in READY status. This fleet property can't be changed
	// after the fleet is created.
	BuildId *string `type:"string"`

	// Prompts Amazon GameLift to generate a TLS/SSL certificate for the fleet.
	// Amazon GameLift uses the certificates to encrypt traffic between game clients
	// and the game servers running on Amazon GameLift. By default, the CertificateConfiguration
	// is DISABLED. You can't change this property after you create the fleet.
	//
	// Certificate Manager (ACM) certificates expire after 13 months. Certificate
	// expiration can cause fleets to fail, preventing players from connecting to
	// instances in the fleet. We recommend you replace fleets before 13 months,
	// consider using fleet aliases for a smooth transition.
	//
	// ACM isn't available in all Amazon Web Services regions. A fleet creation
	// request with certificate generation enabled in an unsupported Region, fails
	// with a 4xx error. For more information about the supported Regions, see Supported
	// Regions (https://docs.aws.amazon.com/acm/latest/userguide/acm-regions.html)
	// in the Certificate Manager User Guide.
	CertificateConfiguration *CertificateConfiguration `type:"structure"`

	// The type of compute resource used to host your game servers. You can use
	// your own compute resources with Amazon GameLift Anywhere or use Amazon EC2
	// instances with managed Amazon GameLift. By default, this property is set
	// to EC2.
	ComputeType *string `type:"string" enum:"ComputeType"`

	// A description for the fleet.
	Description *string `min:"1" type:"string"`

	// The allowed IP address ranges and port settings that allow inbound traffic
	// to access game sessions on this fleet. If the fleet is hosting a custom game
	// build, this property must be set before players can connect to game sessions.
	// For Realtime Servers fleets, Amazon GameLift automatically sets TCP and UDP
	// ranges.
	EC2InboundPermissions []*IpPermission `type:"list"`

	// The Amazon GameLift-supported Amazon EC2 instance type to use for all fleet
	// instances. Instance type determines the computing resources that will be
	// used to host your game servers, including CPU, memory, storage, and networking
	// capacity. See Amazon Elastic Compute Cloud Instance Types (http://aws.amazon.com/ec2/instance-types/)
	// for detailed descriptions of Amazon EC2 instance types.
	EC2InstanceType *string `type:"string" enum:"EC2InstanceType"`

	// Indicates whether to use On-Demand or Spot instances for this fleet. By default,
	// this property is set to ON_DEMAND. Learn more about when to use On-Demand
	// versus Spot Instances (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot).
	// This fleet property can't be changed after the fleet is created.
	FleetType *string `type:"string" enum:"FleetType"`

	// A unique identifier for an IAM role with access permissions to other Amazon
	// Web Services services. Any application that runs on an instance in the fleet--including
	// install scripts, server processes, and other processes--can use these permissions
	// to interact with Amazon Web Services resources that you own or have access
	// to. For more information about using the role with your game server builds,
	// see Communicate with other Amazon Web Services resources from your fleets
	// (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html).
	// This fleet property can't be changed after the fleet is created.
	InstanceRoleArn *string `min:"1" type:"string"`

	// Prompts Amazon GameLift to generate a shared credentials file for the IAM
	// role defined in InstanceRoleArn. The shared credentials file is stored on
	// each fleet instance and refreshed as needed. Use shared credentials for applications
	// that are deployed along with the game server executable, if the game server
	// is integrated with server SDK version 5.x. For more information about using
	// shared credentials, see Communicate with other Amazon Web Services resources
	// from your fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html).
	InstanceRoleCredentialsProvider *string `type:"string" enum:"InstanceRoleCredentialsProvider"`

	// A set of remote locations to deploy additional instances to and manage as
	// part of the fleet. This parameter can only be used when creating fleets in
	// Amazon Web Services Regions that support multiple locations. You can add
	// any Amazon GameLift-supported Amazon Web Services Region as a remote location,
	// in the form of an Amazon Web Services Region code such as us-west-2. To create
	// a fleet with instances in the home Region only, don't use this parameter.
	//
	// To use this parameter, Amazon GameLift requires you to use your home location
	// in the request.
	Locations []*LocationConfiguration `min:"1" type:"list"`

	// This parameter is no longer used. To specify where Amazon GameLift should
	// store log files once a server process shuts down, use the Amazon GameLift
	// server API ProcessReady() and specify one or more directory paths in logParameters.
	// For more information, see Initialize the server process (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-initialize)
	// in the Amazon GameLift Developer Guide.
	LogPaths []*string `type:"list"`

	// The name of an Amazon Web Services CloudWatch metric group to add this fleet
	// to. A metric group is used to aggregate the metrics for multiple fleets.
	// You can specify an existing metric group name or set a new name to create
	// a new metric group. A fleet can be included in only one metric group at a
	// time.
	MetricGroups []*string `type:"list"`

	// A descriptive label that is associated with a fleet. Fleet names do not need
	// to be unique.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The status of termination protection for active game sessions on the fleet.
	// By default, this property is set to NoProtection. You can also set game session
	// protection for an individual game session by calling UpdateGameSession (gamelift/latest/apireference/API_UpdateGameSession.html).
	//
	//    * NoProtection - Game sessions can be terminated during active gameplay
	//    as a result of a scale-down event.
	//
	//    * FullProtection - Game sessions in ACTIVE status cannot be terminated
	//    during a scale-down event.
	NewGameSessionProtectionPolicy *string `type:"string" enum:"ProtectionPolicy"`

	// Used when peering your Amazon GameLift fleet with a VPC, the unique identifier
	// for the Amazon Web Services account that owns the VPC. You can find your
	// account ID in the Amazon Web Services Management Console under account settings.
	PeerVpcAwsAccountId *string `min:"1" type:"string"`

	// A unique identifier for a VPC with resources to be accessed by your Amazon
	// GameLift fleet. The VPC must be in the same Region as your fleet. To look
	// up a VPC ID, use the VPC Dashboard (https://console.aws.amazon.com/vpc/)
	// in the Amazon Web Services Management Console. Learn more about VPC peering
	// in VPC Peering with Amazon GameLift Fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html).
	PeerVpcId *string `min:"1" type:"string"`

	// A policy that limits the number of game sessions that an individual player
	// can create on instances in this fleet within a specified span of time.
	ResourceCreationLimitPolicy *ResourceCreationLimitPolicy `type:"structure"`

	// Instructions for how to launch and maintain server processes on instances
	// in the fleet. The runtime configuration defines one or more server process
	// configurations, each identifying a build executable or Realtime script file
	// and the number of processes of that type to run concurrently.
	//
	// The RuntimeConfiguration parameter is required unless the fleet is being
	// configured using the older parameters ServerLaunchPath and ServerLaunchParameters,
	// which are still supported for backward compatibility.
	RuntimeConfiguration *RuntimeConfiguration `type:"structure"`

	// The unique identifier for a Realtime configuration script to be deployed
	// on fleet instances. You can use either the script ID or ARN. Scripts must
	// be uploaded to Amazon GameLift prior to creating the fleet. This fleet property
	// can't be changed after the fleet is created.
	ScriptId *string `type:"string"`

	// This parameter is no longer used. Specify server launch parameters using
	// the RuntimeConfiguration parameter. Requests that use this parameter instead
	// continue to be valid.
	ServerLaunchParameters *string `min:"1" type:"string"`

	// This parameter is no longer used. Specify a server launch path using the
	// RuntimeConfiguration parameter. Requests that use this parameter instead
	// continue to be valid.
	ServerLaunchPath *string `min:"1" type:"string"`

	// A list of labels to assign to the new fleet resource. Tags are developer-defined
	// key-value pairs. Tagging Amazon Web Services resources are useful for resource
	// management, access management and cost allocation. For more information,
	// see Tagging Amazon Web Services Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// in the Amazon Web Services General Reference.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFleetInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.InstanceRoleArn != nil && len(*s.InstanceRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceRoleArn", 1))
	}
	if s.Locations != nil && len(s.Locations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Locations", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.PeerVpcAwsAccountId != nil && len(*s.PeerVpcAwsAccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PeerVpcAwsAccountId", 1))
	}
	if s.PeerVpcId != nil && len(*s.PeerVpcId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PeerVpcId", 1))
	}
	if s.ServerLaunchParameters != nil && len(*s.ServerLaunchParameters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerLaunchParameters", 1))
	}
	if s.ServerLaunchPath != nil && len(*s.ServerLaunchPath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerLaunchPath", 1))
	}
	if s.AnywhereConfiguration != nil {
		if err := s.AnywhereConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AnywhereConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.CertificateConfiguration != nil {
		if err := s.CertificateConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CertificateConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.EC2InboundPermissions != nil {
		for i, v := range s.EC2InboundPermissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EC2InboundPermissions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Locations != nil {
		for i, v := range s.Locations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Locations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RuntimeConfiguration != nil {
		if err := s.RuntimeConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RuntimeConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnywhereConfiguration sets the AnywhereConfiguration field's value.
func (s *CreateFleetInput) SetAnywhereConfiguration(v *AnywhereConfiguration) *CreateFleetInput {
	s.AnywhereConfiguration = v
	return s
}

// SetBuildId sets the BuildId field's value.
func (s *CreateFleetInput) SetBuildId(v string) *CreateFleetInput {
	s.BuildId = &v
	return s
}

// SetCertificateConfiguration sets the CertificateConfiguration field's value.
func (s *CreateFleetInput) SetCertificateConfiguration(v *CertificateConfiguration) *CreateFleetInput {
	s.CertificateConfiguration = v
	return s
}

// SetComputeType sets the ComputeType field's value.
func (s *CreateFleetInput) SetComputeType(v string) *CreateFleetInput {
	s.ComputeType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateFleetInput) SetDescription(v string) *CreateFleetInput {
	s.Description = &v
	return s
}

// SetEC2InboundPermissions sets the EC2InboundPermissions field's value.
func (s *CreateFleetInput) SetEC2InboundPermissions(v []*IpPermission) *CreateFleetInput {
	s.EC2InboundPermissions = v
	return s
}

// SetEC2InstanceType sets the EC2InstanceType field's value.
func (s *CreateFleetInput) SetEC2InstanceType(v string) *CreateFleetInput {
	s.EC2InstanceType = &v
	return s
}

// SetFleetType sets the FleetType field's value.
func (s *CreateFleetInput) SetFleetType(v string) *CreateFleetInput {
	s.FleetType = &v
	return s
}

// SetInstanceRoleArn sets the InstanceRoleArn field's value.
func (s *CreateFleetInput) SetInstanceRoleArn(v string) *CreateFleetInput {
	s.InstanceRoleArn = &v
	return s
}

// SetInstanceRoleCredentialsProvider sets the InstanceRoleCredentialsProvider field's value.
func (s *CreateFleetInput) SetInstanceRoleCredentialsProvider(v string) *CreateFleetInput {
	s.InstanceRoleCredentialsProvider = &v
	return s
}

// SetLocations sets the Locations field's value.
func (s *CreateFleetInput) SetLocations(v []*LocationConfiguration) *CreateFleetInput {
	s.Locations = v
	return s
}

// SetLogPaths sets the LogPaths field's value.
func (s *CreateFleetInput) SetLogPaths(v []*string) *CreateFleetInput {
	s.LogPaths = v
	return s
}

// SetMetricGroups sets the MetricGroups field's value.
func (s *CreateFleetInput) SetMetricGroups(v []*string) *CreateFleetInput {
	s.MetricGroups = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFleetInput) SetName(v string) *CreateFleetInput {
	s.Name = &v
	return s
}

// SetNewGameSessionProtectionPolicy sets the NewGameSessionProtectionPolicy field's value.
func (s *CreateFleetInput) SetNewGameSessionProtectionPolicy(v string) *CreateFleetInput {
	s.NewGameSessionProtectionPolicy = &v
	return s
}

// SetPeerVpcAwsAccountId sets the PeerVpcAwsAccountId field's value.
func (s *CreateFleetInput) SetPeerVpcAwsAccountId(v string) *CreateFleetInput {
	s.PeerVpcAwsAccountId = &v
	return s
}

// SetPeerVpcId sets the PeerVpcId field's value.
func (s *CreateFleetInput) SetPeerVpcId(v string) *CreateFleetInput {
	s.PeerVpcId = &v
	return s
}

// SetResourceCreationLimitPolicy sets the ResourceCreationLimitPolicy field's value.
func (s *CreateFleetInput) SetResourceCreationLimitPolicy(v *ResourceCreationLimitPolicy) *CreateFleetInput {
	s.ResourceCreationLimitPolicy = v
	return s
}

// SetRuntimeConfiguration sets the RuntimeConfiguration field's value.
func (s *CreateFleetInput) SetRuntimeConfiguration(v *RuntimeConfiguration) *CreateFleetInput {
	s.RuntimeConfiguration = v
	return s
}

// SetScriptId sets the ScriptId field's value.
func (s *CreateFleetInput) SetScriptId(v string) *CreateFleetInput {
	s.ScriptId = &v
	return s
}

// SetServerLaunchParameters sets the ServerLaunchParameters field's value.
func (s *CreateFleetInput) SetServerLaunchParameters(v string) *CreateFleetInput {
	s.ServerLaunchParameters = &v
	return s
}

// SetServerLaunchPath sets the ServerLaunchPath field's value.
func (s *CreateFleetInput) SetServerLaunchPath(v string) *CreateFleetInput {
	s.ServerLaunchPath = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFleetInput) SetTags(v []*Tag) *CreateFleetInput {
	s.Tags = v
	return s
}

type CreateFleetLocationsInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the fleet to add locations to. You can use either
	// the fleet ID or ARN value.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// A list of locations to deploy additional instances to and manage as part
	// of the fleet. You can add any Amazon GameLift-supported Amazon Web Services
	// Region as a remote location, in the form of an Amazon Web Services Region
	// code such as us-west-2.
	//
	// Locations is a required field
	Locations []*LocationConfiguration `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFleetLocationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFleetLocationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFleetLocationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFleetLocationsInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.Locations == nil {
		invalidParams.Add(request.NewErrParamRequired("Locations"))
	}
	if s.Locations != nil && len(s.Locations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Locations", 1))
	}
	if s.Locations != nil {
		for i, v := range s.Locations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Locations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *CreateFleetLocationsInput) SetFleetId(v string) *CreateFleetLocationsInput {
	s.FleetId = &v
	return s
}

// SetLocations sets the Locations field's value.
func (s *CreateFleetLocationsInput) SetLocations(v []*LocationConfiguration) *CreateFleetLocationsInput {
	s.Locations = v
	return s
}

type CreateFleetLocationsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// that is assigned to a Amazon GameLift fleet resource and uniquely identifies
	// it. ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912.
	FleetArn *string `type:"string"`

	// A unique identifier for the fleet that was updated with new locations.
	FleetId *string `type:"string"`

	// The remote locations that are being added to the fleet, and the life-cycle
	// status of each location. For new locations, the status is set to NEW. During
	// location creation, Amazon GameLift updates each location's status as instances
	// are deployed there and prepared for game hosting. This list does not include
	// the fleet home Region or any remote locations that were already added to
	// the fleet.
	LocationStates []*LocationState `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFleetLocationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFleetLocationsOutput) GoString() string {
	return s.String()
}

// SetFleetArn sets the FleetArn field's value.
func (s *CreateFleetLocationsOutput) SetFleetArn(v string) *CreateFleetLocationsOutput {
	s.FleetArn = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *CreateFleetLocationsOutput) SetFleetId(v string) *CreateFleetLocationsOutput {
	s.FleetId = &v
	return s
}

// SetLocationStates sets the LocationStates field's value.
func (s *CreateFleetLocationsOutput) SetLocationStates(v []*LocationState) *CreateFleetLocationsOutput {
	s.LocationStates = v
	return s
}

type CreateFleetOutput struct {
	_ struct{} `type:"structure"`

	// The properties for the new fleet, including the current status. All fleets
	// are placed in NEW status on creation.
	FleetAttributes *FleetAttributes `type:"structure"`

	// The fleet's locations and life-cycle status of each location. For new fleets,
	// the status of all locations is set to NEW. During fleet creation, Amazon
	// GameLift updates each location status as instances are deployed there and
	// prepared for game hosting. This list includes an entry for the fleet's home
	// Region. For fleets with no remote locations, only one entry, representing
	// the home Region, is returned.
	LocationStates []*LocationState `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFleetOutput) GoString() string {
	return s.String()
}

// SetFleetAttributes sets the FleetAttributes field's value.
func (s *CreateFleetOutput) SetFleetAttributes(v *FleetAttributes) *CreateFleetOutput {
	s.FleetAttributes = v
	return s
}

// SetLocationStates sets the LocationStates field's value.
func (s *CreateFleetOutput) SetLocationStates(v []*LocationState) *CreateFleetOutput {
	s.LocationStates = v
	return s
}

type CreateGameServerGroupInput struct {
	_ struct{} `type:"structure"`

	// Configuration settings to define a scaling policy for the Auto Scaling group
	// that is optimized for game hosting. The scaling policy uses the metric "PercentUtilizedGameServers"
	// to maintain a buffer of idle game servers that can immediately accommodate
	// new games and players. After the Auto Scaling group is created, update this
	// value directly in the Auto Scaling group using the Amazon Web Services console
	// or APIs.
	AutoScalingPolicy *GameServerGroupAutoScalingPolicy `type:"structure"`

	// Indicates how Amazon GameLift FleetIQ balances the use of Spot Instances
	// and On-Demand Instances in the game server group. Method options include
	// the following:
	//
	//    * SPOT_ONLY - Only Spot Instances are used in the game server group. If
	//    Spot Instances are unavailable or not viable for game hosting, the game
	//    server group provides no hosting capacity until Spot Instances can again
	//    be used. Until then, no new instances are started, and the existing nonviable
	//    Spot Instances are terminated (after current gameplay ends) and are not
	//    replaced.
	//
	//    * SPOT_PREFERRED - (default value) Spot Instances are used whenever available
	//    in the game server group. If Spot Instances are unavailable, the game
	//    server group continues to provide hosting capacity by falling back to
	//    On-Demand Instances. Existing nonviable Spot Instances are terminated
	//    (after current gameplay ends) and are replaced with new On-Demand Instances.
	//
	//    * ON_DEMAND_ONLY - Only On-Demand Instances are used in the game server
	//    group. No Spot Instances are used, even when available, while this balancing
	//    strategy is in force.
	BalancingStrategy *string `type:"string" enum:"BalancingStrategy"`

	// An identifier for the new game server group. This value is used to generate
	// unique ARN identifiers for the Amazon EC2 Auto Scaling group and the Amazon
	// GameLift FleetIQ game server group. The name must be unique per Region per
	// Amazon Web Services account.
	//
	// GameServerGroupName is a required field
	GameServerGroupName *string `min:"1" type:"string" required:"true"`

	// A flag that indicates whether instances in the game server group are protected
	// from early termination. Unprotected instances that have active game servers
	// running might be terminated during a scale-down event, causing players to
	// be dropped from the game. Protected instances cannot be terminated while
	// there are active game servers running except in the event of a forced game
	// server group deletion (see ). An exception to this is with Spot Instances,
	// which can be terminated by Amazon Web Services regardless of protection status.
	// This property is set to NO_PROTECTION by default.
	GameServerProtectionPolicy *string `type:"string" enum:"GameServerProtectionPolicy"`

	// The Amazon EC2 instance types and sizes to use in the Auto Scaling group.
	// The instance definitions must specify at least two different instance types
	// that are supported by Amazon GameLift FleetIQ. For more information on instance
	// types, see EC2 Instance Types (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html)
	// in the Amazon Elastic Compute Cloud User Guide. You can optionally specify
	// capacity weighting for each instance type. If no weight value is specified
	// for an instance type, it is set to the default value "1". For more information
	// about capacity weighting, see Instance Weighting for Amazon EC2 Auto Scaling
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	//
	// InstanceDefinitions is a required field
	InstanceDefinitions []*InstanceDefinition `min:"2" type:"list" required:"true"`

	// The Amazon EC2 launch template that contains configuration settings and game
	// server code to be deployed to all instances in the game server group. You
	// can specify the template using either the template name or ID. For help with
	// creating a launch template, see Creating a Launch Template for an Auto Scaling
	// Group (https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html)
	// in the Amazon Elastic Compute Cloud Auto Scaling User Guide. After the Auto
	// Scaling group is created, update this value directly in the Auto Scaling
	// group using the Amazon Web Services console or APIs.
	//
	// If you specify network interfaces in your launch template, you must explicitly
	// set the property AssociatePublicIpAddress to "true". If no network interface
	// is specified in the launch template, Amazon GameLift FleetIQ uses your account's
	// default VPC.
	//
	// LaunchTemplate is a required field
	LaunchTemplate *LaunchTemplateSpecification `type:"structure" required:"true"`

	// The maximum number of instances allowed in the Amazon EC2 Auto Scaling group.
	// During automatic scaling events, Amazon GameLift FleetIQ and EC2 do not scale
	// up the group above this maximum. After the Auto Scaling group is created,
	// update this value directly in the Auto Scaling group using the Amazon Web
	// Services console or APIs.
	//
	// MaxSize is a required field
	MaxSize *int64 `min:"1" type:"integer" required:"true"`

	// The minimum number of instances allowed in the Amazon EC2 Auto Scaling group.
	// During automatic scaling events, Amazon GameLift FleetIQ and Amazon EC2 do
	// not scale down the group below this minimum. In production, this value should
	// be set to at least 1. After the Auto Scaling group is created, update this
	// value directly in the Auto Scaling group using the Amazon Web Services console
	// or APIs.
	//
	// MinSize is a required field
	MinSize *int64 `type:"integer" required:"true"`

	// The Amazon Resource Name (ARN (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// for an IAM role that allows Amazon GameLift to access your Amazon EC2 Auto
	// Scaling groups.
	//
	// RoleArn is a required field
	RoleArn *string `min:"1" type:"string" required:"true"`

	// A list of labels to assign to the new game server group resource. Tags are
	// developer-defined key-value pairs. Tagging Amazon Web Services resources
	// is useful for resource management, access management, and cost allocation.
	// For more information, see Tagging Amazon Web Services Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// in the Amazon Web Services General Reference.
	Tags []*Tag `type:"list"`

	// A list of virtual private cloud (VPC) subnets to use with instances in the
	// game server group. By default, all Amazon GameLift FleetIQ-supported Availability
	// Zones are used. You can use this parameter to specify VPCs that you've set
	// up. This property cannot be updated after the game server group is created,
	// and the corresponding Auto Scaling group will always use the property value
	// that is set with this request, even if the Auto Scaling group is updated
	// directly.
	VpcSubnets []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGameServerGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGameServerGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGameServerGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGameServerGroupInput"}
	if s.GameServerGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameServerGroupName"))
	}
	if s.GameServerGroupName != nil && len(*s.GameServerGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameServerGroupName", 1))
	}
	if s.InstanceDefinitions == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceDefinitions"))
	}
	if s.InstanceDefinitions != nil && len(s.InstanceDefinitions) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceDefinitions", 2))
	}
	if s.LaunchTemplate == nil {
		invalidParams.Add(request.NewErrParamRequired("LaunchTemplate"))
	}
	if s.MaxSize == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxSize"))
	}
	if s.MaxSize != nil && *s.MaxSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxSize", 1))
	}
	if s.MinSize == nil {
		invalidParams.Add(request.NewErrParamRequired("MinSize"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.VpcSubnets != nil && len(s.VpcSubnets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VpcSubnets", 1))
	}
	if s.AutoScalingPolicy != nil {
		if err := s.AutoScalingPolicy.Validate(); err != nil {
			invalidParams.AddNested("AutoScalingPolicy", err.(request.ErrInvalidParams))
		}
	}
	if s.InstanceDefinitions != nil {
		for i, v := range s.InstanceDefinitions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InstanceDefinitions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.LaunchTemplate != nil {
		if err := s.LaunchTemplate.Validate(); err != nil {
			invalidParams.AddNested("LaunchTemplate", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingPolicy sets the AutoScalingPolicy field's value.
func (s *CreateGameServerGroupInput) SetAutoScalingPolicy(v *GameServerGroupAutoScalingPolicy) *CreateGameServerGroupInput {
	s.AutoScalingPolicy = v
	return s
}

// SetBalancingStrategy sets the BalancingStrategy field's value.
func (s *CreateGameServerGroupInput) SetBalancingStrategy(v string) *CreateGameServerGroupInput {
	s.BalancingStrategy = &v
	return s
}

// SetGameServerGroupName sets the GameServerGroupName field's value.
func (s *CreateGameServerGroupInput) SetGameServerGroupName(v string) *CreateGameServerGroupInput {
	s.GameServerGroupName = &v
	return s
}

// SetGameServerProtectionPolicy sets the GameServerProtectionPolicy field's value.
func (s *CreateGameServerGroupInput) SetGameServerProtectionPolicy(v string) *CreateGameServerGroupInput {
	s.GameServerProtectionPolicy = &v
	return s
}

// SetInstanceDefinitions sets the InstanceDefinitions field's value.
func (s *CreateGameServerGroupInput) SetInstanceDefinitions(v []*InstanceDefinition) *CreateGameServerGroupInput {
	s.InstanceDefinitions = v
	return s
}

// SetLaunchTemplate sets the LaunchTemplate field's value.
func (s *CreateGameServerGroupInput) SetLaunchTemplate(v *LaunchTemplateSpecification) *CreateGameServerGroupInput {
	s.LaunchTemplate = v
	return s
}

// SetMaxSize sets the MaxSize field's value.
func (s *CreateGameServerGroupInput) SetMaxSize(v int64) *CreateGameServerGroupInput {
	s.MaxSize = &v
	return s
}

// SetMinSize sets the MinSize field's value.
func (s *CreateGameServerGroupInput) SetMinSize(v int64) *CreateGameServerGroupInput {
	s.MinSize = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateGameServerGroupInput) SetRoleArn(v string) *CreateGameServerGroupInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateGameServerGroupInput) SetTags(v []*Tag) *CreateGameServerGroupInput {
	s.Tags = v
	return s
}

// SetVpcSubnets sets the VpcSubnets field's value.
func (s *CreateGameServerGroupInput) SetVpcSubnets(v []*string) *CreateGameServerGroupInput {
	s.VpcSubnets = v
	return s
}

type CreateGameServerGroupOutput struct {
	_ struct{} `type:"structure"`

	// The newly created game server group object, including the new ARN value for
	// the Amazon GameLift FleetIQ game server group and the object's status. The
	// Amazon EC2 Auto Scaling group ARN is initially null, since the group has
	// not yet been created. This value is added once the game server group status
	// reaches ACTIVE.
	GameServerGroup *GameServerGroup `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGameServerGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGameServerGroupOutput) GoString() string {
	return s.String()
}

// SetGameServerGroup sets the GameServerGroup field's value.
func (s *CreateGameServerGroupOutput) SetGameServerGroup(v *GameServerGroup) *CreateGameServerGroupOutput {
	s.GameServerGroup = v
	return s
}

type CreateGameSessionInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the alias associated with the fleet to create a game
	// session in. You can use either the alias ID or ARN value. Each request must
	// reference either a fleet ID or alias ID, but not both.
	AliasId *string `type:"string"`

	// A unique identifier for a player or entity creating the game session.
	//
	// If you add a resource creation limit policy to a fleet, the CreateGameSession
	// operation requires a CreatorId. Amazon GameLift limits the number of game
	// session creation requests with the same CreatorId in a specified time period.
	//
	// If you your fleet doesn't have a resource creation limit policy and you provide
	// a CreatorId in your CreateGameSession requests, Amazon GameLift limits requests
	// to one request per CreatorId per second.
	//
	// To not limit CreateGameSession requests with the same CreatorId, don't provide
	// a CreatorId in your CreateGameSession request.
	CreatorId *string `min:"1" type:"string"`

	// A unique identifier for the fleet to create a game session in. You can use
	// either the fleet ID or ARN value. Each request must reference either a fleet
	// ID or alias ID, but not both.
	FleetId *string `type:"string"`

	// A set of custom properties for a game session, formatted as key:value pairs.
	// These properties are passed to a game server process with a request to start
	// a new game session (see Start a Game Session (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	GameProperties []*GameProperty `type:"list"`

	// A set of custom game session properties, formatted as a single string value.
	// This data is passed to a game server process with a request to start a new
	// game session (see Start a Game Session (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	GameSessionData *string `min:"1" type:"string"`

	// This parameter is deprecated. Use IdempotencyToken instead.
	//
	// Custom string that uniquely identifies a request for a new game session.
	// Maximum token length is 48 characters. If provided, this string is included
	// in the new game session's ID.
	GameSessionId *string `min:"1" type:"string"`

	// Custom string that uniquely identifies the new game session request. This
	// is useful for ensuring that game session requests with the same idempotency
	// token are processed only once. Subsequent requests with the same string return
	// the original GameSession object, with an updated status. Maximum token length
	// is 48 characters. If provided, this string is included in the new game session's
	// ID. A game session ARN has the following format: arn:aws:gamelift:<region>::gamesession/<fleet
	// ID>/<custom ID string or idempotency token>. Idempotency tokens remain in
	// use for 30 days after a game session has ended; game session objects are
	// retained for this time period and then deleted.
	IdempotencyToken *string `min:"1" type:"string"`

	// A fleet's remote location to place the new game session in. If this parameter
	// is not set, the new game session is placed in the fleet's home Region. Specify
	// a remote location with an Amazon Web Services Region code such as us-west-2.
	// When using an Anywhere fleet, this parameter is required and must be set
	// to the Anywhere fleet's custom location.
	Location *string `min:"1" type:"string"`

	// The maximum number of players that can be connected simultaneously to the
	// game session.
	//
	// MaximumPlayerSessionCount is a required field
	MaximumPlayerSessionCount *int64 `type:"integer" required:"true"`

	// A descriptive label that is associated with a game session. Session names
	// do not need to be unique.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGameSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGameSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGameSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGameSessionInput"}
	if s.CreatorId != nil && len(*s.CreatorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CreatorId", 1))
	}
	if s.GameSessionData != nil && len(*s.GameSessionData) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionData", 1))
	}
	if s.GameSessionId != nil && len(*s.GameSessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionId", 1))
	}
	if s.IdempotencyToken != nil && len(*s.IdempotencyToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdempotencyToken", 1))
	}
	if s.Location != nil && len(*s.Location) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Location", 1))
	}
	if s.MaximumPlayerSessionCount == nil {
		invalidParams.Add(request.NewErrParamRequired("MaximumPlayerSessionCount"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.GameProperties != nil {
		for i, v := range s.GameProperties {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "GameProperties", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasId sets the AliasId field's value.
func (s *CreateGameSessionInput) SetAliasId(v string) *CreateGameSessionInput {
	s.AliasId = &v
	return s
}

// SetCreatorId sets the CreatorId field's value.
func (s *CreateGameSessionInput) SetCreatorId(v string) *CreateGameSessionInput {
	s.CreatorId = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *CreateGameSessionInput) SetFleetId(v string) *CreateGameSessionInput {
	s.FleetId = &v
	return s
}

// SetGameProperties sets the GameProperties field's value.
func (s *CreateGameSessionInput) SetGameProperties(v []*GameProperty) *CreateGameSessionInput {
	s.GameProperties = v
	return s
}

// SetGameSessionData sets the GameSessionData field's value.
func (s *CreateGameSessionInput) SetGameSessionData(v string) *CreateGameSessionInput {
	s.GameSessionData = &v
	return s
}

// SetGameSessionId sets the GameSessionId field's value.
func (s *CreateGameSessionInput) SetGameSessionId(v string) *CreateGameSessionInput {
	s.GameSessionId = &v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *CreateGameSessionInput) SetIdempotencyToken(v string) *CreateGameSessionInput {
	s.IdempotencyToken = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateGameSessionInput) SetLocation(v string) *CreateGameSessionInput {
	s.Location = &v
	return s
}

// SetMaximumPlayerSessionCount sets the MaximumPlayerSessionCount field's value.
func (s *CreateGameSessionInput) SetMaximumPlayerSessionCount(v int64) *CreateGameSessionInput {
	s.MaximumPlayerSessionCount = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateGameSessionInput) SetName(v string) *CreateGameSessionInput {
	s.Name = &v
	return s
}

type CreateGameSessionOutput struct {
	_ struct{} `type:"structure"`

	// Object that describes the newly created game session record.
	GameSession *GameSession `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGameSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGameSessionOutput) GoString() string {
	return s.String()
}

// SetGameSession sets the GameSession field's value.
func (s *CreateGameSessionOutput) SetGameSession(v *GameSession) *CreateGameSessionOutput {
	s.GameSession = v
	return s
}

type CreateGameSessionQueueInput struct {
	_ struct{} `type:"structure"`

	// Information to be added to all events that are related to this game session
	// queue.
	CustomEventData *string `type:"string"`

	// A list of fleets and/or fleet aliases that can be used to fulfill game session
	// placement requests in the queue. Destinations are identified by either a
	// fleet ARN or a fleet alias ARN, and are listed in order of placement preference.
	Destinations []*GameSessionQueueDestination `type:"list"`

	// A list of locations where a queue is allowed to place new game sessions.
	// Locations are specified in the form of Amazon Web Services Region codes,
	// such as us-west-2. If this parameter is not set, game sessions can be placed
	// in any queue location.
	FilterConfiguration *FilterConfiguration `type:"structure"`

	// A descriptive label that is associated with game session queue. Queue names
	// must be unique within each Region.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// An SNS topic ARN that is set up to receive game session placement notifications.
	// See Setting up notifications for game session placement (https://docs.aws.amazon.com/gamelift/latest/developerguide/queue-notification.html).
	NotificationTarget *string `type:"string"`

	// A set of policies that act as a sliding cap on player latency. FleetIQ works
	// to deliver low latency for most players in a game session. These policies
	// ensure that no individual player can be placed into a game with unreasonably
	// high latency. Use multiple policies to gradually relax latency requirements
	// a step at a time. Multiple policies are applied based on their maximum allowed
	// latency, starting with the lowest value.
	PlayerLatencyPolicies []*PlayerLatencyPolicy `type:"list"`

	// Custom settings to use when prioritizing destinations and locations for game
	// session placements. This configuration replaces the FleetIQ default prioritization
	// process. Priority types that are not explicitly named will be automatically
	// applied at the end of the prioritization process.
	PriorityConfiguration *PriorityConfiguration `type:"structure"`

	// A list of labels to assign to the new game session queue resource. Tags are
	// developer-defined key-value pairs. Tagging Amazon Web Services resources
	// are useful for resource management, access management and cost allocation.
	// For more information, see Tagging Amazon Web Services Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// in the Amazon Web Services General Reference.
	Tags []*Tag `type:"list"`

	// The maximum time, in seconds, that a new game session placement request remains
	// in the queue. When a request exceeds this time, the game session placement
	// changes to a TIMED_OUT status. By default, this property is set to 600.
	TimeoutInSeconds *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGameSessionQueueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGameSessionQueueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGameSessionQueueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGameSessionQueueInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Destinations != nil {
		for i, v := range s.Destinations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Destinations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.FilterConfiguration != nil {
		if err := s.FilterConfiguration.Validate(); err != nil {
			invalidParams.AddNested("FilterConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.PriorityConfiguration != nil {
		if err := s.PriorityConfiguration.Validate(); err != nil {
			invalidParams.AddNested("PriorityConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomEventData sets the CustomEventData field's value.
func (s *CreateGameSessionQueueInput) SetCustomEventData(v string) *CreateGameSessionQueueInput {
	s.CustomEventData = &v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *CreateGameSessionQueueInput) SetDestinations(v []*GameSessionQueueDestination) *CreateGameSessionQueueInput {
	s.Destinations = v
	return s
}

// SetFilterConfiguration sets the FilterConfiguration field's value.
func (s *CreateGameSessionQueueInput) SetFilterConfiguration(v *FilterConfiguration) *CreateGameSessionQueueInput {
	s.FilterConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateGameSessionQueueInput) SetName(v string) *CreateGameSessionQueueInput {
	s.Name = &v
	return s
}

// SetNotificationTarget sets the NotificationTarget field's value.
func (s *CreateGameSessionQueueInput) SetNotificationTarget(v string) *CreateGameSessionQueueInput {
	s.NotificationTarget = &v
	return s
}

// SetPlayerLatencyPolicies sets the PlayerLatencyPolicies field's value.
func (s *CreateGameSessionQueueInput) SetPlayerLatencyPolicies(v []*PlayerLatencyPolicy) *CreateGameSessionQueueInput {
	s.PlayerLatencyPolicies = v
	return s
}

// SetPriorityConfiguration sets the PriorityConfiguration field's value.
func (s *CreateGameSessionQueueInput) SetPriorityConfiguration(v *PriorityConfiguration) *CreateGameSessionQueueInput {
	s.PriorityConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateGameSessionQueueInput) SetTags(v []*Tag) *CreateGameSessionQueueInput {
	s.Tags = v
	return s
}

// SetTimeoutInSeconds sets the TimeoutInSeconds field's value.
func (s *CreateGameSessionQueueInput) SetTimeoutInSeconds(v int64) *CreateGameSessionQueueInput {
	s.TimeoutInSeconds = &v
	return s
}

type CreateGameSessionQueueOutput struct {
	_ struct{} `type:"structure"`

	// An object that describes the newly created game session queue.
	GameSessionQueue *GameSessionQueue `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGameSessionQueueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateGameSessionQueueOutput) GoString() string {
	return s.String()
}

// SetGameSessionQueue sets the GameSessionQueue field's value.
func (s *CreateGameSessionQueueOutput) SetGameSessionQueue(v *GameSessionQueue) *CreateGameSessionQueueOutput {
	s.GameSessionQueue = v
	return s
}

type CreateLocationInput struct {
	_ struct{} `type:"structure"`

	// A descriptive name for the custom location.
	//
	// LocationName is a required field
	LocationName *string `min:"8" type:"string" required:"true"`

	// A list of labels to assign to the new matchmaking configuration resource.
	// Tags are developer-defined key-value pairs. Tagging Amazon Web Services resources
	// are useful for resource management, access management and cost allocation.
	// For more information, see Tagging Amazon Web Services Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// in the Amazon Web Services General Rareference.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLocationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLocationInput"}
	if s.LocationName == nil {
		invalidParams.Add(request.NewErrParamRequired("LocationName"))
	}
	if s.LocationName != nil && len(*s.LocationName) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("LocationName", 8))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocationName sets the LocationName field's value.
func (s *CreateLocationInput) SetLocationName(v string) *CreateLocationInput {
	s.LocationName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLocationInput) SetTags(v []*Tag) *CreateLocationInput {
	s.Tags = v
	return s
}

type CreateLocationOutput struct {
	_ struct{} `type:"structure"`

	// The details of the custom location you created.
	Location *LocationModel `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLocationOutput) GoString() string {
	return s.String()
}

// SetLocation sets the Location field's value.
func (s *CreateLocationOutput) SetLocation(v *LocationModel) *CreateLocationOutput {
	s.Location = v
	return s
}

type CreateMatchmakingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// A flag that determines whether a match that was created with this configuration
	// must be accepted by the matched players. To require acceptance, set to TRUE.
	// With this option enabled, matchmaking tickets use the status REQUIRES_ACCEPTANCE
	// to indicate when a completed potential match is waiting for player acceptance.
	//
	// AcceptanceRequired is a required field
	AcceptanceRequired *bool `type:"boolean" required:"true"`

	// The length of time (in seconds) to wait for players to accept a proposed
	// match, if acceptance is required.
	AcceptanceTimeoutSeconds *int64 `min:"1" type:"integer"`

	// The number of player slots in a match to keep open for future players. For
	// example, if the configuration's rule set specifies a match for a single 10-person
	// team, and the additional player count is set to 2, 10 players will be selected
	// for the match and 2 more player slots will be open for future players. This
	// parameter is not used if FlexMatchMode is set to STANDALONE.
	AdditionalPlayerCount *int64 `type:"integer"`

	// The method used to backfill game sessions that are created with this matchmaking
	// configuration. Specify MANUAL when your game manages backfill requests manually
	// or does not use the match backfill feature. Specify AUTOMATIC to have Amazon
	// GameLift create a backfill request whenever a game session has one or more
	// open slots. Learn more about manual and automatic backfill in Backfill Existing
	// Games with FlexMatch (https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html).
	// Automatic backfill is not available when FlexMatchMode is set to STANDALONE.
	BackfillMode *string `type:"string" enum:"BackfillMode"`

	// Information to be added to all events related to this matchmaking configuration.
	CustomEventData *string `type:"string"`

	// A human-readable description of the matchmaking configuration.
	Description *string `min:"1" type:"string"`

	// Indicates whether this matchmaking configuration is being used with Amazon
	// GameLift hosting or as a standalone matchmaking solution.
	//
	//    * STANDALONE - FlexMatch forms matches and returns match information,
	//    including players and team assignments, in a MatchmakingSucceeded (https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html#match-events-matchmakingsucceeded)
	//    event.
	//
	//    * WITH_QUEUE - FlexMatch forms matches and uses the specified Amazon GameLift
	//    queue to start a game session for the match.
	FlexMatchMode *string `type:"string" enum:"FlexMatchMode"`

	// A set of custom properties for a game session, formatted as key:value pairs.
	// These properties are passed to a game server process with a request to start
	// a new game session (see Start a Game Session (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	// This information is added to the new GameSession object that is created for
	// a successful match. This parameter is not used if FlexMatchMode is set to
	// STANDALONE.
	GameProperties []*GameProperty `type:"list"`

	// A set of custom game session properties, formatted as a single string value.
	// This data is passed to a game server process with a request to start a new
	// game session (see Start a Game Session (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	// This information is added to the new GameSession object that is created for
	// a successful match. This parameter is not used if FlexMatchMode is set to
	// STANDALONE.
	GameSessionData *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// that is assigned to a Amazon GameLift game session queue resource and uniquely
	// identifies it. ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::gamesessionqueue/<queue
	// name>. Queues can be located in any Region. Queues are used to start new
	// Amazon GameLift-hosted game sessions for matches that are created with this
	// matchmaking configuration. If FlexMatchMode is set to STANDALONE, do not
	// set this parameter.
	GameSessionQueueArns []*string `type:"list"`

	// A unique identifier for the matchmaking configuration. This name is used
	// to identify the configuration associated with a matchmaking request or ticket.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// An SNS topic ARN that is set up to receive matchmaking notifications. See
	// Setting up notifications for matchmaking (https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html)
	// for more information.
	NotificationTarget *string `type:"string"`

	// The maximum duration, in seconds, that a matchmaking ticket can remain in
	// process before timing out. Requests that fail due to timing out can be resubmitted
	// as needed.
	//
	// RequestTimeoutSeconds is a required field
	RequestTimeoutSeconds *int64 `min:"1" type:"integer" required:"true"`

	// A unique identifier for the matchmaking rule set to use with this configuration.
	// You can use either the rule set name or ARN value. A matchmaking configuration
	// can only use rule sets that are defined in the same Region.
	//
	// RuleSetName is a required field
	RuleSetName *string `min:"1" type:"string" required:"true"`

	// A list of labels to assign to the new matchmaking configuration resource.
	// Tags are developer-defined key-value pairs. Tagging Amazon Web Services resources
	// are useful for resource management, access management and cost allocation.
	// For more information, see Tagging Amazon Web Services Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// in the Amazon Web Services General Reference.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMatchmakingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMatchmakingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMatchmakingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMatchmakingConfigurationInput"}
	if s.AcceptanceRequired == nil {
		invalidParams.Add(request.NewErrParamRequired("AcceptanceRequired"))
	}
	if s.AcceptanceTimeoutSeconds != nil && *s.AcceptanceTimeoutSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("AcceptanceTimeoutSeconds", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.GameSessionData != nil && len(*s.GameSessionData) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionData", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.RequestTimeoutSeconds == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestTimeoutSeconds"))
	}
	if s.RequestTimeoutSeconds != nil && *s.RequestTimeoutSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RequestTimeoutSeconds", 1))
	}
	if s.RuleSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleSetName"))
	}
	if s.RuleSetName != nil && len(*s.RuleSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleSetName", 1))
	}
	if s.GameProperties != nil {
		for i, v := range s.GameProperties {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "GameProperties", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceptanceRequired sets the AcceptanceRequired field's value.
func (s *CreateMatchmakingConfigurationInput) SetAcceptanceRequired(v bool) *CreateMatchmakingConfigurationInput {
	s.AcceptanceRequired = &v
	return s
}

// SetAcceptanceTimeoutSeconds sets the AcceptanceTimeoutSeconds field's value.
func (s *CreateMatchmakingConfigurationInput) SetAcceptanceTimeoutSeconds(v int64) *CreateMatchmakingConfigurationInput {
	s.AcceptanceTimeoutSeconds = &v
	return s
}

// SetAdditionalPlayerCount sets the AdditionalPlayerCount field's value.
func (s *CreateMatchmakingConfigurationInput) SetAdditionalPlayerCount(v int64) *CreateMatchmakingConfigurationInput {
	s.AdditionalPlayerCount = &v
	return s
}

// SetBackfillMode sets the BackfillMode field's value.
func (s *CreateMatchmakingConfigurationInput) SetBackfillMode(v string) *CreateMatchmakingConfigurationInput {
	s.BackfillMode = &v
	return s
}

// SetCustomEventData sets the CustomEventData field's value.
func (s *CreateMatchmakingConfigurationInput) SetCustomEventData(v string) *CreateMatchmakingConfigurationInput {
	s.CustomEventData = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateMatchmakingConfigurationInput) SetDescription(v string) *CreateMatchmakingConfigurationInput {
	s.Description = &v
	return s
}

// SetFlexMatchMode sets the FlexMatchMode field's value.
func (s *CreateMatchmakingConfigurationInput) SetFlexMatchMode(v string) *CreateMatchmakingConfigurationInput {
	s.FlexMatchMode = &v
	return s
}

// SetGameProperties sets the GameProperties field's value.
func (s *CreateMatchmakingConfigurationInput) SetGameProperties(v []*GameProperty) *CreateMatchmakingConfigurationInput {
	s.GameProperties = v
	return s
}

// SetGameSessionData sets the GameSessionData field's value.
func (s *CreateMatchmakingConfigurationInput) SetGameSessionData(v string) *CreateMatchmakingConfigurationInput {
	s.GameSessionData = &v
	return s
}

// SetGameSessionQueueArns sets the GameSessionQueueArns field's value.
func (s *CreateMatchmakingConfigurationInput) SetGameSessionQueueArns(v []*string) *CreateMatchmakingConfigurationInput {
	s.GameSessionQueueArns = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateMatchmakingConfigurationInput) SetName(v string) *CreateMatchmakingConfigurationInput {
	s.Name = &v
	return s
}

// SetNotificationTarget sets the NotificationTarget field's value.
func (s *CreateMatchmakingConfigurationInput) SetNotificationTarget(v string) *CreateMatchmakingConfigurationInput {
	s.NotificationTarget = &v
	return s
}

// SetRequestTimeoutSeconds sets the RequestTimeoutSeconds field's value.
func (s *CreateMatchmakingConfigurationInput) SetRequestTimeoutSeconds(v int64) *CreateMatchmakingConfigurationInput {
	s.RequestTimeoutSeconds = &v
	return s
}

// SetRuleSetName sets the RuleSetName field's value.
func (s *CreateMatchmakingConfigurationInput) SetRuleSetName(v string) *CreateMatchmakingConfigurationInput {
	s.RuleSetName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateMatchmakingConfigurationInput) SetTags(v []*Tag) *CreateMatchmakingConfigurationInput {
	s.Tags = v
	return s
}

type CreateMatchmakingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Object that describes the newly created matchmaking configuration.
	Configuration *MatchmakingConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMatchmakingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMatchmakingConfigurationOutput) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *CreateMatchmakingConfigurationOutput) SetConfiguration(v *MatchmakingConfiguration) *CreateMatchmakingConfigurationOutput {
	s.Configuration = v
	return s
}

type CreateMatchmakingRuleSetInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the matchmaking rule set. A matchmaking configuration
	// identifies the rule set it uses by this name value. Note that the rule set
	// name is different from the optional name field in the rule set body.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// A collection of matchmaking rules, formatted as a JSON string. Comments are
	// not allowed in JSON, but most elements support a description field.
	//
	// RuleSetBody is a required field
	RuleSetBody *string `min:"1" type:"string" required:"true"`

	// A list of labels to assign to the new matchmaking rule set resource. Tags
	// are developer-defined key-value pairs. Tagging Amazon Web Services resources
	// are useful for resource management, access management and cost allocation.
	// For more information, see Tagging Amazon Web Services Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// in the Amazon Web Services General Reference.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMatchmakingRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMatchmakingRuleSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMatchmakingRuleSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMatchmakingRuleSetInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.RuleSetBody == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleSetBody"))
	}
	if s.RuleSetBody != nil && len(*s.RuleSetBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleSetBody", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateMatchmakingRuleSetInput) SetName(v string) *CreateMatchmakingRuleSetInput {
	s.Name = &v
	return s
}

// SetRuleSetBody sets the RuleSetBody field's value.
func (s *CreateMatchmakingRuleSetInput) SetRuleSetBody(v string) *CreateMatchmakingRuleSetInput {
	s.RuleSetBody = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateMatchmakingRuleSetInput) SetTags(v []*Tag) *CreateMatchmakingRuleSetInput {
	s.Tags = v
	return s
}

type CreateMatchmakingRuleSetOutput struct {
	_ struct{} `type:"structure"`

	// The newly created matchmaking rule set.
	//
	// RuleSet is a required field
	RuleSet *MatchmakingRuleSet `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMatchmakingRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMatchmakingRuleSetOutput) GoString() string {
	return s.String()
}

// SetRuleSet sets the RuleSet field's value.
func (s *CreateMatchmakingRuleSetOutput) SetRuleSet(v *MatchmakingRuleSet) *CreateMatchmakingRuleSetOutput {
	s.RuleSet = v
	return s
}

type CreatePlayerSessionInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the game session to add a player to.
	//
	// GameSessionId is a required field
	GameSessionId *string `min:"1" type:"string" required:"true"`

	// Developer-defined information related to a player. Amazon GameLift does not
	// use this data, so it can be formatted as needed for use in the game.
	PlayerData *string `min:"1" type:"string"`

	// A unique identifier for a player. Player IDs are developer-defined.
	//
	// PlayerId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreatePlayerSessionInput's
	// String and GoString methods.
	//
	// PlayerId is a required field
	PlayerId *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePlayerSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePlayerSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePlayerSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePlayerSessionInput"}
	if s.GameSessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("GameSessionId"))
	}
	if s.GameSessionId != nil && len(*s.GameSessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionId", 1))
	}
	if s.PlayerData != nil && len(*s.PlayerData) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlayerData", 1))
	}
	if s.PlayerId == nil {
		invalidParams.Add(request.NewErrParamRequired("PlayerId"))
	}
	if s.PlayerId != nil && len(*s.PlayerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlayerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameSessionId sets the GameSessionId field's value.
func (s *CreatePlayerSessionInput) SetGameSessionId(v string) *CreatePlayerSessionInput {
	s.GameSessionId = &v
	return s
}

// SetPlayerData sets the PlayerData field's value.
func (s *CreatePlayerSessionInput) SetPlayerData(v string) *CreatePlayerSessionInput {
	s.PlayerData = &v
	return s
}

// SetPlayerId sets the PlayerId field's value.
func (s *CreatePlayerSessionInput) SetPlayerId(v string) *CreatePlayerSessionInput {
	s.PlayerId = &v
	return s
}

type CreatePlayerSessionOutput struct {
	_ struct{} `type:"structure"`

	// Object that describes the newly created player session record.
	PlayerSession *PlayerSession `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePlayerSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePlayerSessionOutput) GoString() string {
	return s.String()
}

// SetPlayerSession sets the PlayerSession field's value.
func (s *CreatePlayerSessionOutput) SetPlayerSession(v *PlayerSession) *CreatePlayerSessionOutput {
	s.PlayerSession = v
	return s
}

type CreatePlayerSessionsInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the game session to add players to.
	//
	// GameSessionId is a required field
	GameSessionId *string `min:"1" type:"string" required:"true"`

	// Map of string pairs, each specifying a player ID and a set of developer-defined
	// information related to the player. Amazon GameLift does not use this data,
	// so it can be formatted as needed for use in the game. Any player data strings
	// for player IDs that are not included in the PlayerIds parameter are ignored.
	PlayerDataMap map[string]*string `type:"map"`

	// List of unique identifiers for the players to be added.
	//
	// PlayerIds is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreatePlayerSessionsInput's
	// String and GoString methods.
	//
	// PlayerIds is a required field
	PlayerIds []*string `min:"1" type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePlayerSessionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePlayerSessionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePlayerSessionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePlayerSessionsInput"}
	if s.GameSessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("GameSessionId"))
	}
	if s.GameSessionId != nil && len(*s.GameSessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionId", 1))
	}
	if s.PlayerIds == nil {
		invalidParams.Add(request.NewErrParamRequired("PlayerIds"))
	}
	if s.PlayerIds != nil && len(s.PlayerIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlayerIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameSessionId sets the GameSessionId field's value.
func (s *CreatePlayerSessionsInput) SetGameSessionId(v string) *CreatePlayerSessionsInput {
	s.GameSessionId = &v
	return s
}

// SetPlayerDataMap sets the PlayerDataMap field's value.
func (s *CreatePlayerSessionsInput) SetPlayerDataMap(v map[string]*string) *CreatePlayerSessionsInput {
	s.PlayerDataMap = v
	return s
}

// SetPlayerIds sets the PlayerIds field's value.
func (s *CreatePlayerSessionsInput) SetPlayerIds(v []*string) *CreatePlayerSessionsInput {
	s.PlayerIds = v
	return s
}

type CreatePlayerSessionsOutput struct {
	_ struct{} `type:"structure"`

	// A collection of player session objects created for the added players.
	PlayerSessions []*PlayerSession `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePlayerSessionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePlayerSessionsOutput) GoString() string {
	return s.String()
}

// SetPlayerSessions sets the PlayerSessions field's value.
func (s *CreatePlayerSessionsOutput) SetPlayerSessions(v []*PlayerSession) *CreatePlayerSessionsOutput {
	s.PlayerSessions = v
	return s
}

type CreateScriptInput struct {
	_ struct{} `type:"structure"`

	// A descriptive label that is associated with a script. Script names don't
	// need to be unique. You can use UpdateScript (https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateScript.html)
	// to change this value later.
	Name *string `min:"1" type:"string"`

	// The location of the Amazon S3 bucket where a zipped file containing your
	// Realtime scripts is stored. The storage location must specify the Amazon
	// S3 bucket name, the zip file name (the "key"), and a role ARN that allows
	// Amazon GameLift to access the Amazon S3 storage location. The S3 bucket must
	// be in the same Region where you want to create a new script. By default,
	// Amazon GameLift uploads the latest version of the zip file; if you have S3
	// object versioning turned on, you can use the ObjectVersion parameter to specify
	// an earlier version.
	StorageLocation *S3Location `type:"structure"`

	// A list of labels to assign to the new script resource. Tags are developer-defined
	// key-value pairs. Tagging Amazon Web Services resources are useful for resource
	// management, access management and cost allocation. For more information,
	// see Tagging Amazon Web Services Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// in the Amazon Web Services General Reference. Once the resource is created,
	// you can use TagResource (https://docs.aws.amazon.com/gamelift/latest/apireference/API_TagResource.html),
	// UntagResource (https://docs.aws.amazon.com/gamelift/latest/apireference/API_UntagResource.html),
	// and ListTagsForResource (https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListTagsForResource.html)
	// to add, remove, and view tags. The maximum tag limit may be lower than stated.
	// See the Amazon Web Services General Reference for actual tagging limits.
	Tags []*Tag `type:"list"`

	// Version information associated with a build or script. Version strings don't
	// need to be unique. You can use UpdateScript (https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateScript.html)
	// to change this value later.
	Version *string `min:"1" type:"string"`

	// A data object containing your Realtime scripts and dependencies as a zip
	// file. The zip file can have one or multiple files. Maximum size of a zip
	// file is 5 MB.
	//
	// When using the Amazon Web Services CLI tool to create a script, this parameter
	// is set to the zip file name. It must be prepended with the string "fileb://"
	// to indicate that the file data is a binary object. For example: --zip-file
	// fileb://myRealtimeScript.zip.
	// ZipFile is automatically base64 encoded/decoded by the SDK.
	ZipFile []byte `type:"blob"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateScriptInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateScriptInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateScriptInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateScriptInput"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}
	if s.StorageLocation != nil {
		if err := s.StorageLocation.Validate(); err != nil {
			invalidParams.AddNested("StorageLocation", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateScriptInput) SetName(v string) *CreateScriptInput {
	s.Name = &v
	return s
}

// SetStorageLocation sets the StorageLocation field's value.
func (s *CreateScriptInput) SetStorageLocation(v *S3Location) *CreateScriptInput {
	s.StorageLocation = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateScriptInput) SetTags(v []*Tag) *CreateScriptInput {
	s.Tags = v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateScriptInput) SetVersion(v string) *CreateScriptInput {
	s.Version = &v
	return s
}

// SetZipFile sets the ZipFile field's value.
func (s *CreateScriptInput) SetZipFile(v []byte) *CreateScriptInput {
	s.ZipFile = v
	return s
}

type CreateScriptOutput struct {
	_ struct{} `type:"structure"`

	// The newly created script record with a unique script ID and ARN. The new
	// script's storage location reflects an Amazon S3 location: (1) If the script
	// was uploaded from an S3 bucket under your account, the storage location reflects
	// the information that was provided in the CreateScript request; (2) If the
	// script file was uploaded from a local zip file, the storage location reflects
	// an S3 location controls by the Amazon GameLift service.
	Script *Script `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateScriptOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateScriptOutput) GoString() string {
	return s.String()
}

// SetScript sets the Script field's value.
func (s *CreateScriptOutput) SetScript(v *Script) *CreateScriptOutput {
	s.Script = v
	return s
}

type CreateVpcPeeringAuthorizationInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the Amazon Web Services account that you use to manage
	// your Amazon GameLift fleet. You can find your Account ID in the Amazon Web
	// Services Management Console under account settings.
	//
	// GameLiftAwsAccountId is a required field
	GameLiftAwsAccountId *string `min:"1" type:"string" required:"true"`

	// A unique identifier for a VPC with resources to be accessed by your Amazon
	// GameLift fleet. The VPC must be in the same Region as your fleet. To look
	// up a VPC ID, use the VPC Dashboard (https://console.aws.amazon.com/vpc/)
	// in the Amazon Web Services Management Console. Learn more about VPC peering
	// in VPC Peering with Amazon GameLift Fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html).
	//
	// PeerVpcId is a required field
	PeerVpcId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVpcPeeringAuthorizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVpcPeeringAuthorizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVpcPeeringAuthorizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVpcPeeringAuthorizationInput"}
	if s.GameLiftAwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("GameLiftAwsAccountId"))
	}
	if s.GameLiftAwsAccountId != nil && len(*s.GameLiftAwsAccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameLiftAwsAccountId", 1))
	}
	if s.PeerVpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("PeerVpcId"))
	}
	if s.PeerVpcId != nil && len(*s.PeerVpcId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PeerVpcId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameLiftAwsAccountId sets the GameLiftAwsAccountId field's value.
func (s *CreateVpcPeeringAuthorizationInput) SetGameLiftAwsAccountId(v string) *CreateVpcPeeringAuthorizationInput {
	s.GameLiftAwsAccountId = &v
	return s
}

// SetPeerVpcId sets the PeerVpcId field's value.
func (s *CreateVpcPeeringAuthorizationInput) SetPeerVpcId(v string) *CreateVpcPeeringAuthorizationInput {
	s.PeerVpcId = &v
	return s
}

type CreateVpcPeeringAuthorizationOutput struct {
	_ struct{} `type:"structure"`

	// Details on the requested VPC peering authorization, including expiration.
	VpcPeeringAuthorization *VpcPeeringAuthorization `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVpcPeeringAuthorizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVpcPeeringAuthorizationOutput) GoString() string {
	return s.String()
}

// SetVpcPeeringAuthorization sets the VpcPeeringAuthorization field's value.
func (s *CreateVpcPeeringAuthorizationOutput) SetVpcPeeringAuthorization(v *VpcPeeringAuthorization) *CreateVpcPeeringAuthorizationOutput {
	s.VpcPeeringAuthorization = v
	return s
}

type CreateVpcPeeringConnectionInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the fleet. You can use either the fleet ID or ARN
	// value. This tells Amazon GameLift which GameLift VPC to peer with.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// A unique identifier for the Amazon Web Services account with the VPC that
	// you want to peer your Amazon GameLift fleet with. You can find your Account
	// ID in the Amazon Web Services Management Console under account settings.
	//
	// PeerVpcAwsAccountId is a required field
	PeerVpcAwsAccountId *string `min:"1" type:"string" required:"true"`

	// A unique identifier for a VPC with resources to be accessed by your Amazon
	// GameLift fleet. The VPC must be in the same Region as your fleet. To look
	// up a VPC ID, use the VPC Dashboard (https://console.aws.amazon.com/vpc/)
	// in the Amazon Web Services Management Console. Learn more about VPC peering
	// in VPC Peering with Amazon GameLift Fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html).
	//
	// PeerVpcId is a required field
	PeerVpcId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVpcPeeringConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVpcPeeringConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVpcPeeringConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVpcPeeringConnectionInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.PeerVpcAwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("PeerVpcAwsAccountId"))
	}
	if s.PeerVpcAwsAccountId != nil && len(*s.PeerVpcAwsAccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PeerVpcAwsAccountId", 1))
	}
	if s.PeerVpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("PeerVpcId"))
	}
	if s.PeerVpcId != nil && len(*s.PeerVpcId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PeerVpcId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *CreateVpcPeeringConnectionInput) SetFleetId(v string) *CreateVpcPeeringConnectionInput {
	s.FleetId = &v
	return s
}

// SetPeerVpcAwsAccountId sets the PeerVpcAwsAccountId field's value.
func (s *CreateVpcPeeringConnectionInput) SetPeerVpcAwsAccountId(v string) *CreateVpcPeeringConnectionInput {
	s.PeerVpcAwsAccountId = &v
	return s
}

// SetPeerVpcId sets the PeerVpcId field's value.
func (s *CreateVpcPeeringConnectionInput) SetPeerVpcId(v string) *CreateVpcPeeringConnectionInput {
	s.PeerVpcId = &v
	return s
}

type CreateVpcPeeringConnectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVpcPeeringConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVpcPeeringConnectionOutput) GoString() string {
	return s.String()
}

type DeleteAliasInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier of the alias that you want to delete. You can use either
	// the alias ID or ARN value.
	//
	// AliasId is a required field
	AliasId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAliasInput"}
	if s.AliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasId sets the AliasId field's value.
func (s *DeleteAliasInput) SetAliasId(v string) *DeleteAliasInput {
	s.AliasId = &v
	return s
}

type DeleteAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAliasOutput) GoString() string {
	return s.String()
}

type DeleteBuildInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the build to delete. You can use either the build
	// ID or ARN value.
	//
	// BuildId is a required field
	BuildId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBuildInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBuildInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBuildInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBuildInput"}
	if s.BuildId == nil {
		invalidParams.Add(request.NewErrParamRequired("BuildId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBuildId sets the BuildId field's value.
func (s *DeleteBuildInput) SetBuildId(v string) *DeleteBuildInput {
	s.BuildId = &v
	return s
}

type DeleteBuildOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBuildOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBuildOutput) GoString() string {
	return s.String()
}

type DeleteFleetInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the fleet to be deleted. You can use either the fleet
	// ID or ARN value.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFleetInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *DeleteFleetInput) SetFleetId(v string) *DeleteFleetInput {
	s.FleetId = &v
	return s
}

type DeleteFleetLocationsInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the fleet to delete locations for. You can use either
	// the fleet ID or ARN value.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// The list of fleet locations to delete. Specify locations in the form of an
	// Amazon Web Services Region code, such as us-west-2.
	//
	// Locations is a required field
	Locations []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFleetLocationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFleetLocationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFleetLocationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFleetLocationsInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.Locations == nil {
		invalidParams.Add(request.NewErrParamRequired("Locations"))
	}
	if s.Locations != nil && len(s.Locations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Locations", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *DeleteFleetLocationsInput) SetFleetId(v string) *DeleteFleetLocationsInput {
	s.FleetId = &v
	return s
}

// SetLocations sets the Locations field's value.
func (s *DeleteFleetLocationsInput) SetLocations(v []*string) *DeleteFleetLocationsInput {
	s.Locations = v
	return s
}

type DeleteFleetLocationsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// that is assigned to a Amazon GameLift fleet resource and uniquely identifies
	// it. ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912.
	FleetArn *string `type:"string"`

	// A unique identifier for the fleet that location attributes are being deleted
	// for.
	FleetId *string `type:"string"`

	// The remote locations that are being deleted, with each location status set
	// to DELETING.
	LocationStates []*LocationState `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFleetLocationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFleetLocationsOutput) GoString() string {
	return s.String()
}

// SetFleetArn sets the FleetArn field's value.
func (s *DeleteFleetLocationsOutput) SetFleetArn(v string) *DeleteFleetLocationsOutput {
	s.FleetArn = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *DeleteFleetLocationsOutput) SetFleetId(v string) *DeleteFleetLocationsOutput {
	s.FleetId = &v
	return s
}

// SetLocationStates sets the LocationStates field's value.
func (s *DeleteFleetLocationsOutput) SetLocationStates(v []*LocationState) *DeleteFleetLocationsOutput {
	s.LocationStates = v
	return s
}

type DeleteFleetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFleetOutput) GoString() string {
	return s.String()
}

type DeleteGameServerGroupInput struct {
	_ struct{} `type:"structure"`

	// The type of delete to perform. Options include the following:
	//
	//    * SAFE_DELETE – (default) Terminates the game server group and Amazon
	//    EC2 Auto Scaling group only when it has no game servers that are in UTILIZED
	//    status.
	//
	//    * FORCE_DELETE – Terminates the game server group, including all active
	//    game servers regardless of their utilization status, and the Amazon EC2
	//    Auto Scaling group.
	//
	//    * RETAIN – Does a safe delete of the game server group but retains the
	//    Amazon EC2 Auto Scaling group as is.
	DeleteOption *string `type:"string" enum:"GameServerGroupDeleteOption"`

	// A unique identifier for the game server group. Use either the name or ARN
	// value.
	//
	// GameServerGroupName is a required field
	GameServerGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGameServerGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGameServerGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGameServerGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGameServerGroupInput"}
	if s.GameServerGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameServerGroupName"))
	}
	if s.GameServerGroupName != nil && len(*s.GameServerGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameServerGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeleteOption sets the DeleteOption field's value.
func (s *DeleteGameServerGroupInput) SetDeleteOption(v string) *DeleteGameServerGroupInput {
	s.DeleteOption = &v
	return s
}

// SetGameServerGroupName sets the GameServerGroupName field's value.
func (s *DeleteGameServerGroupInput) SetGameServerGroupName(v string) *DeleteGameServerGroupInput {
	s.GameServerGroupName = &v
	return s
}

type DeleteGameServerGroupOutput struct {
	_ struct{} `type:"structure"`

	// An object that describes the deleted game server group resource, with status
	// updated to DELETE_SCHEDULED.
	GameServerGroup *GameServerGroup `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGameServerGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGameServerGroupOutput) GoString() string {
	return s.String()
}

// SetGameServerGroup sets the GameServerGroup field's value.
func (s *DeleteGameServerGroupOutput) SetGameServerGroup(v *GameServerGroup) *DeleteGameServerGroupOutput {
	s.GameServerGroup = v
	return s
}

type DeleteGameSessionQueueInput struct {
	_ struct{} `type:"structure"`

	// A descriptive label that is associated with game session queue. Queue names
	// must be unique within each Region. You can use either the queue ID or ARN
	// value.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGameSessionQueueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGameSessionQueueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGameSessionQueueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGameSessionQueueInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteGameSessionQueueInput) SetName(v string) *DeleteGameSessionQueueInput {
	s.Name = &v
	return s
}

type DeleteGameSessionQueueOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGameSessionQueueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGameSessionQueueOutput) GoString() string {
	return s.String()
}

type DeleteLocationInput struct {
	_ struct{} `type:"structure"`

	// The location name of the custom location to be deleted.
	//
	// LocationName is a required field
	LocationName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLocationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLocationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLocationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLocationInput"}
	if s.LocationName == nil {
		invalidParams.Add(request.NewErrParamRequired("LocationName"))
	}
	if s.LocationName != nil && len(*s.LocationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocationName sets the LocationName field's value.
func (s *DeleteLocationInput) SetLocationName(v string) *DeleteLocationInput {
	s.LocationName = &v
	return s
}

type DeleteLocationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLocationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLocationOutput) GoString() string {
	return s.String()
}

type DeleteMatchmakingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the matchmaking configuration. You can use either
	// the configuration name or ARN value.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMatchmakingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMatchmakingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMatchmakingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMatchmakingConfigurationInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteMatchmakingConfigurationInput) SetName(v string) *DeleteMatchmakingConfigurationInput {
	s.Name = &v
	return s
}

type DeleteMatchmakingConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMatchmakingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMatchmakingConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteMatchmakingRuleSetInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the matchmaking rule set to be deleted. (Note: The
	// rule set name is different from the optional "name" field in the rule set
	// body.) You can use either the rule set name or ARN value.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMatchmakingRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMatchmakingRuleSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMatchmakingRuleSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMatchmakingRuleSetInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteMatchmakingRuleSetInput) SetName(v string) *DeleteMatchmakingRuleSetInput {
	s.Name = &v
	return s
}

type DeleteMatchmakingRuleSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMatchmakingRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMatchmakingRuleSetOutput) GoString() string {
	return s.String()
}

type DeleteScalingPolicyInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the fleet to be deleted. You can use either the fleet
	// ID or ARN value.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// A descriptive label that is associated with a fleet's scaling policy. Policy
	// names do not need to be unique.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScalingPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScalingPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteScalingPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteScalingPolicyInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *DeleteScalingPolicyInput) SetFleetId(v string) *DeleteScalingPolicyInput {
	s.FleetId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteScalingPolicyInput) SetName(v string) *DeleteScalingPolicyInput {
	s.Name = &v
	return s
}

type DeleteScalingPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScalingPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScalingPolicyOutput) GoString() string {
	return s.String()
}

type DeleteScriptInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the Realtime script to delete. You can use either
	// the script ID or ARN value.
	//
	// ScriptId is a required field
	ScriptId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScriptInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScriptInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteScriptInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteScriptInput"}
	if s.ScriptId == nil {
		invalidParams.Add(request.NewErrParamRequired("ScriptId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScriptId sets the ScriptId field's value.
func (s *DeleteScriptInput) SetScriptId(v string) *DeleteScriptInput {
	s.ScriptId = &v
	return s
}

type DeleteScriptOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScriptOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScriptOutput) GoString() string {
	return s.String()
}

type DeleteVpcPeeringAuthorizationInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the Amazon Web Services account that you use to manage
	// your Amazon GameLift fleet. You can find your Account ID in the Amazon Web
	// Services Management Console under account settings.
	//
	// GameLiftAwsAccountId is a required field
	GameLiftAwsAccountId *string `min:"1" type:"string" required:"true"`

	// A unique identifier for a VPC with resources to be accessed by your Amazon
	// GameLift fleet. The VPC must be in the same Region as your fleet. To look
	// up a VPC ID, use the VPC Dashboard (https://console.aws.amazon.com/vpc/)
	// in the Amazon Web Services Management Console. Learn more about VPC peering
	// in VPC Peering with Amazon GameLift Fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html).
	//
	// PeerVpcId is a required field
	PeerVpcId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVpcPeeringAuthorizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVpcPeeringAuthorizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVpcPeeringAuthorizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVpcPeeringAuthorizationInput"}
	if s.GameLiftAwsAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("GameLiftAwsAccountId"))
	}
	if s.GameLiftAwsAccountId != nil && len(*s.GameLiftAwsAccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameLiftAwsAccountId", 1))
	}
	if s.PeerVpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("PeerVpcId"))
	}
	if s.PeerVpcId != nil && len(*s.PeerVpcId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PeerVpcId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameLiftAwsAccountId sets the GameLiftAwsAccountId field's value.
func (s *DeleteVpcPeeringAuthorizationInput) SetGameLiftAwsAccountId(v string) *DeleteVpcPeeringAuthorizationInput {
	s.GameLiftAwsAccountId = &v
	return s
}

// SetPeerVpcId sets the PeerVpcId field's value.
func (s *DeleteVpcPeeringAuthorizationInput) SetPeerVpcId(v string) *DeleteVpcPeeringAuthorizationInput {
	s.PeerVpcId = &v
	return s
}

type DeleteVpcPeeringAuthorizationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVpcPeeringAuthorizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVpcPeeringAuthorizationOutput) GoString() string {
	return s.String()
}

type DeleteVpcPeeringConnectionInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the fleet. This fleet specified must match the fleet
	// referenced in the VPC peering connection record. You can use either the fleet
	// ID or ARN value.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// A unique identifier for a VPC peering connection.
	//
	// VpcPeeringConnectionId is a required field
	VpcPeeringConnectionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVpcPeeringConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVpcPeeringConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVpcPeeringConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVpcPeeringConnectionInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.VpcPeeringConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcPeeringConnectionId"))
	}
	if s.VpcPeeringConnectionId != nil && len(*s.VpcPeeringConnectionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VpcPeeringConnectionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *DeleteVpcPeeringConnectionInput) SetFleetId(v string) *DeleteVpcPeeringConnectionInput {
	s.FleetId = &v
	return s
}

// SetVpcPeeringConnectionId sets the VpcPeeringConnectionId field's value.
func (s *DeleteVpcPeeringConnectionInput) SetVpcPeeringConnectionId(v string) *DeleteVpcPeeringConnectionInput {
	s.VpcPeeringConnectionId = &v
	return s
}

type DeleteVpcPeeringConnectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVpcPeeringConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVpcPeeringConnectionOutput) GoString() string {
	return s.String()
}

type DeregisterComputeInput struct {
	_ struct{} `type:"structure"`

	// The name of the compute resource to remove from the specified Anywhere fleet.
	//
	// ComputeName is a required field
	ComputeName *string `type:"string" required:"true"`

	// A unique identifier for the fleet the compute resource is currently registered
	// to.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterComputeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterComputeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterComputeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterComputeInput"}
	if s.ComputeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ComputeName"))
	}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputeName sets the ComputeName field's value.
func (s *DeregisterComputeInput) SetComputeName(v string) *DeregisterComputeInput {
	s.ComputeName = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *DeregisterComputeInput) SetFleetId(v string) *DeregisterComputeInput {
	s.FleetId = &v
	return s
}

type DeregisterComputeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterComputeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterComputeOutput) GoString() string {
	return s.String()
}

type DeregisterGameServerInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the game server group where the game server is running.
	//
	// GameServerGroupName is a required field
	GameServerGroupName *string `min:"1" type:"string" required:"true"`

	// A custom string that uniquely identifies the game server to deregister.
	//
	// GameServerId is a required field
	GameServerId *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterGameServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterGameServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterGameServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterGameServerInput"}
	if s.GameServerGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameServerGroupName"))
	}
	if s.GameServerGroupName != nil && len(*s.GameServerGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameServerGroupName", 1))
	}
	if s.GameServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("GameServerId"))
	}
	if s.GameServerId != nil && len(*s.GameServerId) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("GameServerId", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameServerGroupName sets the GameServerGroupName field's value.
func (s *DeregisterGameServerInput) SetGameServerGroupName(v string) *DeregisterGameServerInput {
	s.GameServerGroupName = &v
	return s
}

// SetGameServerId sets the GameServerId field's value.
func (s *DeregisterGameServerInput) SetGameServerId(v string) *DeregisterGameServerInput {
	s.GameServerId = &v
	return s
}

type DeregisterGameServerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterGameServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterGameServerOutput) GoString() string {
	return s.String()
}

type DescribeAliasInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the fleet alias that you want to retrieve. You
	// can use either the alias ID or ARN value.
	//
	// AliasId is a required field
	AliasId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAliasInput"}
	if s.AliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasId sets the AliasId field's value.
func (s *DescribeAliasInput) SetAliasId(v string) *DescribeAliasInput {
	s.AliasId = &v
	return s
}

type DescribeAliasOutput struct {
	_ struct{} `type:"structure"`

	// The requested alias resource.
	Alias *Alias `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAliasOutput) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *DescribeAliasOutput) SetAlias(v *Alias) *DescribeAliasOutput {
	s.Alias = v
	return s
}

type DescribeBuildInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the build to retrieve properties for. You can use
	// either the build ID or ARN value.
	//
	// BuildId is a required field
	BuildId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBuildInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBuildInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBuildInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBuildInput"}
	if s.BuildId == nil {
		invalidParams.Add(request.NewErrParamRequired("BuildId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBuildId sets the BuildId field's value.
func (s *DescribeBuildInput) SetBuildId(v string) *DescribeBuildInput {
	s.BuildId = &v
	return s
}

type DescribeBuildOutput struct {
	_ struct{} `type:"structure"`

	// Set of properties describing the requested build.
	Build *Build `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBuildOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBuildOutput) GoString() string {
	return s.String()
}

// SetBuild sets the Build field's value.
func (s *DescribeBuildOutput) SetBuild(v *Build) *DescribeBuildOutput {
	s.Build = v
	return s
}

type DescribeComputeInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the compute resource to retrieve properties for.
	// For an Anywhere fleet compute, use the registered compute name. For a managed
	// EC2 fleet instance, use the instance ID.
	//
	// ComputeName is a required field
	ComputeName *string `type:"string" required:"true"`

	// A unique identifier for the fleet that the compute is registered to. You
	// can use either the fleet ID or ARN value.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeComputeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeComputeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeComputeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeComputeInput"}
	if s.ComputeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ComputeName"))
	}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputeName sets the ComputeName field's value.
func (s *DescribeComputeInput) SetComputeName(v string) *DescribeComputeInput {
	s.ComputeName = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *DescribeComputeInput) SetFleetId(v string) *DescribeComputeInput {
	s.FleetId = &v
	return s
}

type DescribeComputeOutput struct {
	_ struct{} `type:"structure"`

	// The set of properties for the requested compute resource.
	Compute *Compute `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeComputeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeComputeOutput) GoString() string {
	return s.String()
}

// SetCompute sets the Compute field's value.
func (s *DescribeComputeOutput) SetCompute(v *Compute) *DescribeComputeOutput {
	s.Compute = v
	return s
}

type DescribeEC2InstanceLimitsInput struct {
	_ struct{} `type:"structure"`

	// Name of an Amazon EC2 instance type that is supported in Amazon GameLift.
	// A fleet instance type determines the computing resources of each instance
	// in the fleet, including CPU, memory, storage, and networking capacity. Do
	// not specify a value for this parameter to retrieve limits for all instance
	// types.
	EC2InstanceType *string `type:"string" enum:"EC2InstanceType"`

	// The name of a remote location to request instance limits for, in the form
	// of an Amazon Web Services Region code such as us-west-2.
	Location *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEC2InstanceLimitsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEC2InstanceLimitsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEC2InstanceLimitsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEC2InstanceLimitsInput"}
	if s.Location != nil && len(*s.Location) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Location", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEC2InstanceType sets the EC2InstanceType field's value.
func (s *DescribeEC2InstanceLimitsInput) SetEC2InstanceType(v string) *DescribeEC2InstanceLimitsInput {
	s.EC2InstanceType = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *DescribeEC2InstanceLimitsInput) SetLocation(v string) *DescribeEC2InstanceLimitsInput {
	s.Location = &v
	return s
}

type DescribeEC2InstanceLimitsOutput struct {
	_ struct{} `type:"structure"`

	// The maximum number of instances for the specified instance type.
	EC2InstanceLimits []*EC2InstanceLimit `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEC2InstanceLimitsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEC2InstanceLimitsOutput) GoString() string {
	return s.String()
}

// SetEC2InstanceLimits sets the EC2InstanceLimits field's value.
func (s *DescribeEC2InstanceLimitsOutput) SetEC2InstanceLimits(v []*EC2InstanceLimit) *DescribeEC2InstanceLimitsOutput {
	s.EC2InstanceLimits = v
	return s
}

type DescribeFleetAttributesInput struct {
	_ struct{} `type:"structure"`

	// A list of unique fleet identifiers to retrieve attributes for. You can use
	// either the fleet ID or ARN value. To retrieve attributes for all current
	// fleets, do not include this parameter.
	FleetIds []*string `min:"1" type:"list"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages. This parameter is ignored when
	// the request specifies one or a list of fleet IDs.
	Limit *int64 `min:"1" type:"integer"`

	// A token that indicates the start of the next sequential page of results.
	// Use the token that is returned with a previous call to this operation. To
	// start at the beginning of the result set, do not specify a value. This parameter
	// is ignored when the request specifies one or a list of fleet IDs.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFleetAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFleetAttributesInput"}
	if s.FleetIds != nil && len(s.FleetIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetIds", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetIds sets the FleetIds field's value.
func (s *DescribeFleetAttributesInput) SetFleetIds(v []*string) *DescribeFleetAttributesInput {
	s.FleetIds = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeFleetAttributesInput) SetLimit(v int64) *DescribeFleetAttributesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetAttributesInput) SetNextToken(v string) *DescribeFleetAttributesInput {
	s.NextToken = &v
	return s
}

type DescribeFleetAttributesOutput struct {
	_ struct{} `type:"structure"`

	// A collection of objects containing attribute metadata for each requested
	// fleet ID. Attribute objects are returned only for fleets that currently exist.
	FleetAttributes []*FleetAttributes `type:"list"`

	// A token that indicates where to resume retrieving results on the next call
	// to this operation. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetAttributesOutput) GoString() string {
	return s.String()
}

// SetFleetAttributes sets the FleetAttributes field's value.
func (s *DescribeFleetAttributesOutput) SetFleetAttributes(v []*FleetAttributes) *DescribeFleetAttributesOutput {
	s.FleetAttributes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetAttributesOutput) SetNextToken(v string) *DescribeFleetAttributesOutput {
	s.NextToken = &v
	return s
}

type DescribeFleetCapacityInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the fleet to retrieve capacity information for. You
	// can use either the fleet ID or ARN value. Leave this parameter empty to retrieve
	// capacity information for all fleets.
	FleetIds []*string `min:"1" type:"list"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages. This parameter is ignored when
	// the request specifies one or a list of fleet IDs.
	Limit *int64 `min:"1" type:"integer"`

	// A token that indicates the start of the next sequential page of results.
	// Use the token that is returned with a previous call to this operation. To
	// start at the beginning of the result set, do not specify a value. This parameter
	// is ignored when the request specifies one or a list of fleet IDs.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetCapacityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetCapacityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFleetCapacityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFleetCapacityInput"}
	if s.FleetIds != nil && len(s.FleetIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetIds", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetIds sets the FleetIds field's value.
func (s *DescribeFleetCapacityInput) SetFleetIds(v []*string) *DescribeFleetCapacityInput {
	s.FleetIds = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeFleetCapacityInput) SetLimit(v int64) *DescribeFleetCapacityInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetCapacityInput) SetNextToken(v string) *DescribeFleetCapacityInput {
	s.NextToken = &v
	return s
}

type DescribeFleetCapacityOutput struct {
	_ struct{} `type:"structure"`

	// A collection of objects that contains capacity information for each requested
	// fleet ID. Capacity objects are returned only for fleets that currently exist.
	// Changes in desired instance value can take up to 1 minute to be reflected.
	FleetCapacity []*FleetCapacity `type:"list"`

	// A token that indicates where to resume retrieving results on the next call
	// to this operation. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetCapacityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetCapacityOutput) GoString() string {
	return s.String()
}

// SetFleetCapacity sets the FleetCapacity field's value.
func (s *DescribeFleetCapacityOutput) SetFleetCapacity(v []*FleetCapacity) *DescribeFleetCapacityOutput {
	s.FleetCapacity = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetCapacityOutput) SetNextToken(v string) *DescribeFleetCapacityOutput {
	s.NextToken = &v
	return s
}

type DescribeFleetEventsInput struct {
	_ struct{} `type:"structure"`

	// The most recent date to retrieve event logs for. If no end time is specified,
	// this call returns entries from the specified start time up to the present.
	// Format is a number expressed in Unix time as milliseconds (ex: "1469498468.057").
	EndTime *time.Time `type:"timestamp"`

	// A unique identifier for the fleet to get event logs for. You can use either
	// the fleet ID or ARN value.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// A token that indicates the start of the next sequential page of results.
	// Use the token that is returned with a previous call to this operation. To
	// start at the beginning of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`

	// The earliest date to retrieve event logs for. If no start time is specified,
	// this call returns entries starting from when the fleet was created to the
	// specified end time. Format is a number expressed in Unix time as milliseconds
	// (ex: "1469498468.057").
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFleetEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFleetEventsInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeFleetEventsInput) SetEndTime(v time.Time) *DescribeFleetEventsInput {
	s.EndTime = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *DescribeFleetEventsInput) SetFleetId(v string) *DescribeFleetEventsInput {
	s.FleetId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeFleetEventsInput) SetLimit(v int64) *DescribeFleetEventsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetEventsInput) SetNextToken(v string) *DescribeFleetEventsInput {
	s.NextToken = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeFleetEventsInput) SetStartTime(v time.Time) *DescribeFleetEventsInput {
	s.StartTime = &v
	return s
}

type DescribeFleetEventsOutput struct {
	_ struct{} `type:"structure"`

	// A collection of objects containing event log entries for the specified fleet.
	Events []*Event `type:"list"`

	// A token that indicates where to resume retrieving results on the next call
	// to this operation. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetEventsOutput) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *DescribeFleetEventsOutput) SetEvents(v []*Event) *DescribeFleetEventsOutput {
	s.Events = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetEventsOutput) SetNextToken(v string) *DescribeFleetEventsOutput {
	s.NextToken = &v
	return s
}

type DescribeFleetLocationAttributesInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the fleet to retrieve remote locations for. You can
	// use either the fleet ID or ARN value.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages. This limit is not currently
	// enforced.
	Limit *int64 `min:"1" type:"integer"`

	// A list of fleet locations to retrieve information for. Specify locations
	// in the form of an Amazon Web Services Region code, such as us-west-2.
	Locations []*string `min:"1" type:"list"`

	// A token that indicates the start of the next sequential page of results.
	// Use the token that is returned with a previous call to this operation. To
	// start at the beginning of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetLocationAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetLocationAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFleetLocationAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFleetLocationAttributesInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Locations != nil && len(s.Locations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Locations", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *DescribeFleetLocationAttributesInput) SetFleetId(v string) *DescribeFleetLocationAttributesInput {
	s.FleetId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeFleetLocationAttributesInput) SetLimit(v int64) *DescribeFleetLocationAttributesInput {
	s.Limit = &v
	return s
}

// SetLocations sets the Locations field's value.
func (s *DescribeFleetLocationAttributesInput) SetLocations(v []*string) *DescribeFleetLocationAttributesInput {
	s.Locations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetLocationAttributesInput) SetNextToken(v string) *DescribeFleetLocationAttributesInput {
	s.NextToken = &v
	return s
}

type DescribeFleetLocationAttributesOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// that is assigned to a Amazon GameLift fleet resource and uniquely identifies
	// it. ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912.
	FleetArn *string `type:"string"`

	// A unique identifier for the fleet that location attributes were requested
	// for.
	FleetId *string `type:"string"`

	// Location-specific information on the requested fleet's remote locations.
	LocationAttributes []*LocationAttributes `type:"list"`

	// A token that indicates where to resume retrieving results on the next call
	// to this operation. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetLocationAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetLocationAttributesOutput) GoString() string {
	return s.String()
}

// SetFleetArn sets the FleetArn field's value.
func (s *DescribeFleetLocationAttributesOutput) SetFleetArn(v string) *DescribeFleetLocationAttributesOutput {
	s.FleetArn = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *DescribeFleetLocationAttributesOutput) SetFleetId(v string) *DescribeFleetLocationAttributesOutput {
	s.FleetId = &v
	return s
}

// SetLocationAttributes sets the LocationAttributes field's value.
func (s *DescribeFleetLocationAttributesOutput) SetLocationAttributes(v []*LocationAttributes) *DescribeFleetLocationAttributesOutput {
	s.LocationAttributes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetLocationAttributesOutput) SetNextToken(v string) *DescribeFleetLocationAttributesOutput {
	s.NextToken = &v
	return s
}

type DescribeFleetLocationCapacityInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the fleet to request location capacity for. You can
	// use either the fleet ID or ARN value.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// The fleet location to retrieve capacity information for. Specify a location
	// in the form of an Amazon Web Services Region code, such as us-west-2.
	//
	// Location is a required field
	Location *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetLocationCapacityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetLocationCapacityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFleetLocationCapacityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFleetLocationCapacityInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.Location == nil {
		invalidParams.Add(request.NewErrParamRequired("Location"))
	}
	if s.Location != nil && len(*s.Location) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Location", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *DescribeFleetLocationCapacityInput) SetFleetId(v string) *DescribeFleetLocationCapacityInput {
	s.FleetId = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *DescribeFleetLocationCapacityInput) SetLocation(v string) *DescribeFleetLocationCapacityInput {
	s.Location = &v
	return s
}

type DescribeFleetLocationCapacityOutput struct {
	_ struct{} `type:"structure"`

	// Resource capacity information for the requested fleet location. Capacity
	// objects are returned only for fleets and locations that currently exist.
	// Changes in desired instance value can take up to 1 minute to be reflected.
	FleetCapacity *FleetCapacity `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetLocationCapacityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetLocationCapacityOutput) GoString() string {
	return s.String()
}

// SetFleetCapacity sets the FleetCapacity field's value.
func (s *DescribeFleetLocationCapacityOutput) SetFleetCapacity(v *FleetCapacity) *DescribeFleetLocationCapacityOutput {
	s.FleetCapacity = v
	return s
}

type DescribeFleetLocationUtilizationInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the fleet to request location utilization for. You
	// can use either the fleet ID or ARN value.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// The fleet location to retrieve utilization information for. Specify a location
	// in the form of an Amazon Web Services Region code, such as us-west-2.
	//
	// Location is a required field
	Location *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetLocationUtilizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetLocationUtilizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFleetLocationUtilizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFleetLocationUtilizationInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.Location == nil {
		invalidParams.Add(request.NewErrParamRequired("Location"))
	}
	if s.Location != nil && len(*s.Location) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Location", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *DescribeFleetLocationUtilizationInput) SetFleetId(v string) *DescribeFleetLocationUtilizationInput {
	s.FleetId = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *DescribeFleetLocationUtilizationInput) SetLocation(v string) *DescribeFleetLocationUtilizationInput {
	s.Location = &v
	return s
}

type DescribeFleetLocationUtilizationOutput struct {
	_ struct{} `type:"structure"`

	// Utilization information for the requested fleet location. Utilization objects
	// are returned only for fleets and locations that currently exist.
	FleetUtilization *FleetUtilization `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetLocationUtilizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetLocationUtilizationOutput) GoString() string {
	return s.String()
}

// SetFleetUtilization sets the FleetUtilization field's value.
func (s *DescribeFleetLocationUtilizationOutput) SetFleetUtilization(v *FleetUtilization) *DescribeFleetLocationUtilizationOutput {
	s.FleetUtilization = v
	return s
}

type DescribeFleetPortSettingsInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the fleet to retrieve port settings for. You can
	// use either the fleet ID or ARN value.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// A remote location to check for status of port setting updates. Use the Amazon
	// Web Services Region code format, such as us-west-2.
	Location *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetPortSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetPortSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFleetPortSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFleetPortSettingsInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.Location != nil && len(*s.Location) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Location", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *DescribeFleetPortSettingsInput) SetFleetId(v string) *DescribeFleetPortSettingsInput {
	s.FleetId = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *DescribeFleetPortSettingsInput) SetLocation(v string) *DescribeFleetPortSettingsInput {
	s.Location = &v
	return s
}

type DescribeFleetPortSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// that is assigned to a Amazon GameLift fleet resource and uniquely identifies
	// it. ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912.
	FleetArn *string `type:"string"`

	// A unique identifier for the fleet that was requested.
	FleetId *string `type:"string"`

	// The port settings for the requested fleet ID.
	InboundPermissions []*IpPermission `type:"list"`

	// The requested fleet location, expressed as an Amazon Web Services Region
	// code, such as us-west-2.
	Location *string `min:"1" type:"string"`

	// The current status of updates to the fleet's port settings in the requested
	// fleet location. A status of PENDING_UPDATE indicates that an update was requested
	// for the fleet but has not yet been completed for the location.
	UpdateStatus *string `type:"string" enum:"LocationUpdateStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetPortSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetPortSettingsOutput) GoString() string {
	return s.String()
}

// SetFleetArn sets the FleetArn field's value.
func (s *DescribeFleetPortSettingsOutput) SetFleetArn(v string) *DescribeFleetPortSettingsOutput {
	s.FleetArn = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *DescribeFleetPortSettingsOutput) SetFleetId(v string) *DescribeFleetPortSettingsOutput {
	s.FleetId = &v
	return s
}

// SetInboundPermissions sets the InboundPermissions field's value.
func (s *DescribeFleetPortSettingsOutput) SetInboundPermissions(v []*IpPermission) *DescribeFleetPortSettingsOutput {
	s.InboundPermissions = v
	return s
}

// SetLocation sets the Location field's value.
func (s *DescribeFleetPortSettingsOutput) SetLocation(v string) *DescribeFleetPortSettingsOutput {
	s.Location = &v
	return s
}

// SetUpdateStatus sets the UpdateStatus field's value.
func (s *DescribeFleetPortSettingsOutput) SetUpdateStatus(v string) *DescribeFleetPortSettingsOutput {
	s.UpdateStatus = &v
	return s
}

type DescribeFleetUtilizationInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the fleet to retrieve utilization data for. You can
	// use either the fleet ID or ARN value. To retrieve attributes for all current
	// fleets, do not include this parameter.
	FleetIds []*string `min:"1" type:"list"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages. This parameter is ignored when
	// the request specifies one or a list of fleet IDs.
	Limit *int64 `min:"1" type:"integer"`

	// A token that indicates the start of the next sequential page of results.
	// Use the token that is returned with a previous call to this operation. To
	// start at the beginning of the result set, do not specify a value. This parameter
	// is ignored when the request specifies one or a list of fleet IDs.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetUtilizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetUtilizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFleetUtilizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFleetUtilizationInput"}
	if s.FleetIds != nil && len(s.FleetIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetIds", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetIds sets the FleetIds field's value.
func (s *DescribeFleetUtilizationInput) SetFleetIds(v []*string) *DescribeFleetUtilizationInput {
	s.FleetIds = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeFleetUtilizationInput) SetLimit(v int64) *DescribeFleetUtilizationInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetUtilizationInput) SetNextToken(v string) *DescribeFleetUtilizationInput {
	s.NextToken = &v
	return s
}

type DescribeFleetUtilizationOutput struct {
	_ struct{} `type:"structure"`

	// A collection of objects containing utilization information for each requested
	// fleet ID. Utilization objects are returned only for fleets that currently
	// exist.
	FleetUtilization []*FleetUtilization `type:"list"`

	// A token that indicates where to resume retrieving results on the next call
	// to this operation. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetUtilizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFleetUtilizationOutput) GoString() string {
	return s.String()
}

// SetFleetUtilization sets the FleetUtilization field's value.
func (s *DescribeFleetUtilizationOutput) SetFleetUtilization(v []*FleetUtilization) *DescribeFleetUtilizationOutput {
	s.FleetUtilization = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeFleetUtilizationOutput) SetNextToken(v string) *DescribeFleetUtilizationOutput {
	s.NextToken = &v
	return s
}

type DescribeGameServerGroupInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the game server group. Use either the name or ARN
	// value.
	//
	// GameServerGroupName is a required field
	GameServerGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGameServerGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGameServerGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGameServerGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGameServerGroupInput"}
	if s.GameServerGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameServerGroupName"))
	}
	if s.GameServerGroupName != nil && len(*s.GameServerGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameServerGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameServerGroupName sets the GameServerGroupName field's value.
func (s *DescribeGameServerGroupInput) SetGameServerGroupName(v string) *DescribeGameServerGroupInput {
	s.GameServerGroupName = &v
	return s
}

type DescribeGameServerGroupOutput struct {
	_ struct{} `type:"structure"`

	// An object with the property settings for the requested game server group
	// resource.
	GameServerGroup *GameServerGroup `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGameServerGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGameServerGroupOutput) GoString() string {
	return s.String()
}

// SetGameServerGroup sets the GameServerGroup field's value.
func (s *DescribeGameServerGroupOutput) SetGameServerGroup(v *GameServerGroup) *DescribeGameServerGroupOutput {
	s.GameServerGroup = v
	return s
}

type DescribeGameServerInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the game server group where the game server is running.
	//
	// GameServerGroupName is a required field
	GameServerGroupName *string `min:"1" type:"string" required:"true"`

	// A custom string that uniquely identifies the game server information to be
	// retrieved.
	//
	// GameServerId is a required field
	GameServerId *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGameServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGameServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGameServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGameServerInput"}
	if s.GameServerGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameServerGroupName"))
	}
	if s.GameServerGroupName != nil && len(*s.GameServerGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameServerGroupName", 1))
	}
	if s.GameServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("GameServerId"))
	}
	if s.GameServerId != nil && len(*s.GameServerId) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("GameServerId", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameServerGroupName sets the GameServerGroupName field's value.
func (s *DescribeGameServerInput) SetGameServerGroupName(v string) *DescribeGameServerInput {
	s.GameServerGroupName = &v
	return s
}

// SetGameServerId sets the GameServerId field's value.
func (s *DescribeGameServerInput) SetGameServerId(v string) *DescribeGameServerInput {
	s.GameServerId = &v
	return s
}

type DescribeGameServerInstancesInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the game server group. Use either the name or ARN
	// value.
	//
	// GameServerGroupName is a required field
	GameServerGroupName *string `min:"1" type:"string" required:"true"`

	// The Amazon EC2 instance IDs that you want to retrieve status on. Amazon EC2
	// instance IDs use a 17-character format, for example: i-1234567890abcdef0.
	// To retrieve all instances in the game server group, leave this parameter
	// empty.
	InstanceIds []*string `min:"1" type:"list"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// A token that indicates the start of the next sequential page of results.
	// Use the token that is returned with a previous call to this operation. To
	// start at the beginning of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGameServerInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGameServerInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGameServerInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGameServerInstancesInput"}
	if s.GameServerGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GameServerGroupName"))
	}
	if s.GameServerGroupName != nil && len(*s.GameServerGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameServerGroupName", 1))
	}
	if s.InstanceIds != nil && len(s.InstanceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceIds", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameServerGroupName sets the GameServerGroupName field's value.
func (s *DescribeGameServerInstancesInput) SetGameServerGroupName(v string) *DescribeGameServerInstancesInput {
	s.GameServerGroupName = &v
	return s
}

// SetInstanceIds sets the InstanceIds field's value.
func (s *DescribeGameServerInstancesInput) SetInstanceIds(v []*string) *DescribeGameServerInstancesInput {
	s.InstanceIds = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeGameServerInstancesInput) SetLimit(v int64) *DescribeGameServerInstancesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeGameServerInstancesInput) SetNextToken(v string) *DescribeGameServerInstancesInput {
	s.NextToken = &v
	return s
}

type DescribeGameServerInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The collection of requested game server instances.
	GameServerInstances []*GameServerInstance `type:"list"`

	// A token that indicates where to resume retrieving results on the next call
	// to this operation. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGameServerInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGameServerInstancesOutput) GoString() string {
	return s.String()
}

// SetGameServerInstances sets the GameServerInstances field's value.
func (s *DescribeGameServerInstancesOutput) SetGameServerInstances(v []*GameServerInstance) *DescribeGameServerInstancesOutput {
	s.GameServerInstances = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeGameServerInstancesOutput) SetNextToken(v string) *DescribeGameServerInstancesOutput {
	s.NextToken = &v
	return s
}

type DescribeGameServerOutput struct {
	_ struct{} `type:"structure"`

	// Object that describes the requested game server.
	GameServer *GameServer `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGameServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGameServerOutput) GoString() string {
	return s.String()
}

// SetGameServer sets the GameServer field's value.
func (s *DescribeGameServerOutput) SetGameServer(v *GameServer) *DescribeGameServerOutput {
	s.GameServer = v
	return s
}

type DescribeGameSessionDetailsInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the alias associated with the fleet to retrieve all
	// game sessions for. You can use either the alias ID or ARN value.
	AliasId *string `type:"string"`

	// A unique identifier for the fleet to retrieve all game sessions active on
	// the fleet. You can use either the fleet ID or ARN value.
	FleetId *string `type:"string"`

	// A unique identifier for the game session to retrieve.
	GameSessionId *string `min:"1" type:"string"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// A fleet location to get game session details for. You can specify a fleet's
	// home Region or a remote location. Use the Amazon Web Services Region code
	// format, such as us-west-2.
	Location *string `min:"1" type:"string"`

	// A token that indicates the start of the next sequential page of results.
	// Use the token that is returned with a previous call to this operation. To
	// start at the beginning of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`

	// Game session status to filter results on. Possible game session statuses
	// include ACTIVE, TERMINATED, ACTIVATING and TERMINATING (the last two are
	// transitory).
	StatusFilter *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGameSessionDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGameSessionDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGameSessionDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGameSessionDetailsInput"}
	if s.GameSessionId != nil && len(*s.GameSessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionId", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Location != nil && len(*s.Location) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Location", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StatusFilter != nil && len(*s.StatusFilter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatusFilter", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasId sets the AliasId field's value.
func (s *DescribeGameSessionDetailsInput) SetAliasId(v string) *DescribeGameSessionDetailsInput {
	s.AliasId = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *DescribeGameSessionDetailsInput) SetFleetId(v string) *DescribeGameSessionDetailsInput {
	s.FleetId = &v
	return s
}

// SetGameSessionId sets the GameSessionId field's value.
func (s *DescribeGameSessionDetailsInput) SetGameSessionId(v string) *DescribeGameSessionDetailsInput {
	s.GameSessionId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeGameSessionDetailsInput) SetLimit(v int64) *DescribeGameSessionDetailsInput {
	s.Limit = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *DescribeGameSessionDetailsInput) SetLocation(v string) *DescribeGameSessionDetailsInput {
	s.Location = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeGameSessionDetailsInput) SetNextToken(v string) *DescribeGameSessionDetailsInput {
	s.NextToken = &v
	return s
}

// SetStatusFilter sets the StatusFilter field's value.
func (s *DescribeGameSessionDetailsInput) SetStatusFilter(v string) *DescribeGameSessionDetailsInput {
	s.StatusFilter = &v
	return s
}

type DescribeGameSessionDetailsOutput struct {
	_ struct{} `type:"structure"`

	// A collection of properties for each game session that matches the request.
	GameSessionDetails []*GameSessionDetail `type:"list"`

	// A token that indicates where to resume retrieving results on the next call
	// to this operation. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGameSessionDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGameSessionDetailsOutput) GoString() string {
	return s.String()
}

// SetGameSessionDetails sets the GameSessionDetails field's value.
func (s *DescribeGameSessionDetailsOutput) SetGameSessionDetails(v []*GameSessionDetail) *DescribeGameSessionDetailsOutput {
	s.GameSessionDetails = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeGameSessionDetailsOutput) SetNextToken(v string) *DescribeGameSessionDetailsOutput {
	s.NextToken = &v
	return s
}

type DescribeGameSessionPlacementInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for a game session placement to retrieve.
	//
	// PlacementId is a required field
	PlacementId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGameSessionPlacementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGameSessionPlacementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGameSessionPlacementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGameSessionPlacementInput"}
	if s.PlacementId == nil {
		invalidParams.Add(request.NewErrParamRequired("PlacementId"))
	}
	if s.PlacementId != nil && len(*s.PlacementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlacementId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPlacementId sets the PlacementId field's value.
func (s *DescribeGameSessionPlacementInput) SetPlacementId(v string) *DescribeGameSessionPlacementInput {
	s.PlacementId = &v
	return s
}

type DescribeGameSessionPlacementOutput struct {
	_ struct{} `type:"structure"`

	// Object that describes the requested game session placement.
	GameSessionPlacement *GameSessionPlacement `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGameSessionPlacementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGameSessionPlacementOutput) GoString() string {
	return s.String()
}

// SetGameSessionPlacement sets the GameSessionPlacement field's value.
func (s *DescribeGameSessionPlacementOutput) SetGameSessionPlacement(v *GameSessionPlacement) *DescribeGameSessionPlacementOutput {
	s.GameSessionPlacement = v
	return s
}

type DescribeGameSessionQueuesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages. You can request up to 50 results.
	Limit *int64 `min:"1" type:"integer"`

	// A list of queue names to retrieve information for. You can use either the
	// queue ID or ARN value. To request settings for all queues, leave this parameter
	// empty.
	Names []*string `type:"list"`

	// A token that indicates the start of the next sequential page of results.
	// Use the token that is returned with a previous call to this operation. To
	// start at the beginning of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGameSessionQueuesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGameSessionQueuesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGameSessionQueuesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGameSessionQueuesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *DescribeGameSessionQueuesInput) SetLimit(v int64) *DescribeGameSessionQueuesInput {
	s.Limit = &v
	return s
}

// SetNames sets the Names field's value.
func (s *DescribeGameSessionQueuesInput) SetNames(v []*string) *DescribeGameSessionQueuesInput {
	s.Names = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeGameSessionQueuesInput) SetNextToken(v string) *DescribeGameSessionQueuesInput {
	s.NextToken = &v
	return s
}

type DescribeGameSessionQueuesOutput struct {
	_ struct{} `type:"structure"`

	// A collection of objects that describe the requested game session queues.
	GameSessionQueues []*GameSessionQueue `type:"list"`

	// A token that indicates where to resume retrieving results on the next call
	// to this operation. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGameSessionQueuesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGameSessionQueuesOutput) GoString() string {
	return s.String()
}

// SetGameSessionQueues sets the GameSessionQueues field's value.
func (s *DescribeGameSessionQueuesOutput) SetGameSessionQueues(v []*GameSessionQueue) *DescribeGameSessionQueuesOutput {
	s.GameSessionQueues = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeGameSessionQueuesOutput) SetNextToken(v string) *DescribeGameSessionQueuesOutput {
	s.NextToken = &v
	return s
}

type DescribeGameSessionsInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the alias associated with the fleet to retrieve game
	// sessions for. You can use either the alias ID or ARN value.
	AliasId *string `type:"string"`

	// A unique identifier for the fleet to retrieve game sessions for. You can
	// use either the fleet ID or ARN value.
	FleetId *string `type:"string"`

	// A unique identifier for the game session to retrieve.
	GameSessionId *string `min:"1" type:"string"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// A fleet location to get game sessions for. You can specify a fleet's home
	// Region or a remote location. Use the Amazon Web Services Region code format,
	// such as us-west-2.
	Location *string `min:"1" type:"string"`

	// A token that indicates the start of the next sequential page of results.
	// Use the token that is returned with a previous call to this operation. To
	// start at the beginning of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`

	// Game session status to filter results on. You can filter on the following
	// states: ACTIVE, TERMINATED, ACTIVATING, and TERMINATING. The last two are
	// transitory and used for only very brief periods of time.
	StatusFilter *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGameSessionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGameSessionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGameSessionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGameSessionsInput"}
	if s.GameSessionId != nil && len(*s.GameSessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionId", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Location != nil && len(*s.Location) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Location", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StatusFilter != nil && len(*s.StatusFilter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatusFilter", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasId sets the AliasId field's value.
func (s *DescribeGameSessionsInput) SetAliasId(v string) *DescribeGameSessionsInput {
	s.AliasId = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *DescribeGameSessionsInput) SetFleetId(v string) *DescribeGameSessionsInput {
	s.FleetId = &v
	return s
}

// SetGameSessionId sets the GameSessionId field's value.
func (s *DescribeGameSessionsInput) SetGameSessionId(v string) *DescribeGameSessionsInput {
	s.GameSessionId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeGameSessionsInput) SetLimit(v int64) *DescribeGameSessionsInput {
	s.Limit = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *DescribeGameSessionsInput) SetLocation(v string) *DescribeGameSessionsInput {
	s.Location = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeGameSessionsInput) SetNextToken(v string) *DescribeGameSessionsInput {
	s.NextToken = &v
	return s
}

// SetStatusFilter sets the StatusFilter field's value.
func (s *DescribeGameSessionsInput) SetStatusFilter(v string) *DescribeGameSessionsInput {
	s.StatusFilter = &v
	return s
}

type DescribeGameSessionsOutput struct {
	_ struct{} `type:"structure"`

	// A collection of properties for each game session that matches the request.
	GameSessions []*GameSession `type:"list"`

	// A token that indicates where to resume retrieving results on the next call
	// to this operation. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGameSessionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGameSessionsOutput) GoString() string {
	return s.String()
}

// SetGameSessions sets the GameSessions field's value.
func (s *DescribeGameSessionsOutput) SetGameSessions(v []*GameSession) *DescribeGameSessionsOutput {
	s.GameSessions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeGameSessionsOutput) SetNextToken(v string) *DescribeGameSessionsOutput {
	s.NextToken = &v
	return s
}

type DescribeInstancesInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the fleet to retrieve instance information for. You
	// can use either the fleet ID or ARN value.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// A unique identifier for an instance to retrieve. Specify an instance ID or
	// leave blank to retrieve all instances in the fleet.
	InstanceId *string `type:"string"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// The name of a location to retrieve instance information for, in the form
	// of an Amazon Web Services Region code such as us-west-2.
	Location *string `min:"1" type:"string"`

	// A token that indicates the start of the next sequential page of results.
	// Use the token that is returned with a previous call to this operation. To
	// start at the beginning of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInstancesInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Location != nil && len(*s.Location) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Location", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *DescribeInstancesInput) SetFleetId(v string) *DescribeInstancesInput {
	s.FleetId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeInstancesInput) SetInstanceId(v string) *DescribeInstancesInput {
	s.InstanceId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeInstancesInput) SetLimit(v int64) *DescribeInstancesInput {
	s.Limit = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *DescribeInstancesInput) SetLocation(v string) *DescribeInstancesInput {
	s.Location = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeInstancesInput) SetNextToken(v string) *DescribeInstancesInput {
	s.NextToken = &v
	return s
}

type DescribeInstancesOutput struct {
	_ struct{} `type:"structure"`

	// A collection of objects containing properties for each instance returned.
	Instances []*Instance `type:"list"`

	// A token that indicates where to resume retrieving results on the next call
	// to this operation. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInstancesOutput) GoString() string {
	return s.String()
}

// SetInstances sets the Instances field's value.
func (s *DescribeInstancesOutput) SetInstances(v []*Instance) *DescribeInstancesOutput {
	s.Instances = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeInstancesOutput) SetNextToken(v string) *DescribeInstancesOutput {
	s.NextToken = &v
	return s
}

type DescribeMatchmakingConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages. This parameter is limited to
	// 10.
	Limit *int64 `min:"1" type:"integer"`

	// A unique identifier for the matchmaking configuration(s) to retrieve. You
	// can use either the configuration name or ARN value. To request all existing
	// configurations, leave this parameter empty.
	Names []*string `type:"list"`

	// A token that indicates the start of the next sequential page of results.
	// Use the token that is returned with a previous call to this operation. To
	// start at the beginning of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`

	// A unique identifier for the matchmaking rule set. You can use either the
	// rule set name or ARN value. Use this parameter to retrieve all matchmaking
	// configurations that use this rule set.
	RuleSetName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMatchmakingConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMatchmakingConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMatchmakingConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMatchmakingConfigurationsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.RuleSetName != nil && len(*s.RuleSetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleSetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *DescribeMatchmakingConfigurationsInput) SetLimit(v int64) *DescribeMatchmakingConfigurationsInput {
	s.Limit = &v
	return s
}

// SetNames sets the Names field's value.
func (s *DescribeMatchmakingConfigurationsInput) SetNames(v []*string) *DescribeMatchmakingConfigurationsInput {
	s.Names = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeMatchmakingConfigurationsInput) SetNextToken(v string) *DescribeMatchmakingConfigurationsInput {
	s.NextToken = &v
	return s
}

// SetRuleSetName sets the RuleSetName field's value.
func (s *DescribeMatchmakingConfigurationsInput) SetRuleSetName(v string) *DescribeMatchmakingConfigurationsInput {
	s.RuleSetName = &v
	return s
}

type DescribeMatchmakingConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// A collection of requested matchmaking configurations.
	Configurations []*MatchmakingConfiguration `type:"list"`

	// A token that indicates where to resume retrieving results on the next call
	// to this operation. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMatchmakingConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMatchmakingConfigurationsOutput) GoString() string {
	return s.String()
}

// SetConfigurations sets the Configurations field's value.
func (s *DescribeMatchmakingConfigurationsOutput) SetConfigurations(v []*MatchmakingConfiguration) *DescribeMatchmakingConfigurationsOutput {
	s.Configurations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeMatchmakingConfigurationsOutput) SetNextToken(v string) *DescribeMatchmakingConfigurationsOutput {
	s.NextToken = &v
	return s
}

type DescribeMatchmakingInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for a matchmaking ticket. You can include up to 10 ID
	// values.
	//
	// TicketIds is a required field
	TicketIds []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMatchmakingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMatchmakingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMatchmakingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMatchmakingInput"}
	if s.TicketIds == nil {
		invalidParams.Add(request.NewErrParamRequired("TicketIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTicketIds sets the TicketIds field's value.
func (s *DescribeMatchmakingInput) SetTicketIds(v []*string) *DescribeMatchmakingInput {
	s.TicketIds = v
	return s
}

type DescribeMatchmakingOutput struct {
	_ struct{} `type:"structure"`

	// A collection of existing matchmaking ticket objects matching the request.
	TicketList []*MatchmakingTicket `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMatchmakingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMatchmakingOutput) GoString() string {
	return s.String()
}

// SetTicketList sets the TicketList field's value.
func (s *DescribeMatchmakingOutput) SetTicketList(v []*MatchmakingTicket) *DescribeMatchmakingOutput {
	s.TicketList = v
	return s
}

type DescribeMatchmakingRuleSetsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// A list of one or more matchmaking rule set names to retrieve details for.
	// (Note: The rule set name is different from the optional "name" field in the
	// rule set body.) You can use either the rule set name or ARN value.
	Names []*string `min:"1" type:"list"`

	// A token that indicates the start of the next sequential page of results.
	// Use the token that is returned with a previous call to this operation. To
	// start at the beginning of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMatchmakingRuleSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMatchmakingRuleSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMatchmakingRuleSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMatchmakingRuleSetsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Names != nil && len(s.Names) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Names", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *DescribeMatchmakingRuleSetsInput) SetLimit(v int64) *DescribeMatchmakingRuleSetsInput {
	s.Limit = &v
	return s
}

// SetNames sets the Names field's value.
func (s *DescribeMatchmakingRuleSetsInput) SetNames(v []*string) *DescribeMatchmakingRuleSetsInput {
	s.Names = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeMatchmakingRuleSetsInput) SetNextToken(v string) *DescribeMatchmakingRuleSetsInput {
	s.NextToken = &v
	return s
}

type DescribeMatchmakingRuleSetsOutput struct {
	_ struct{} `type:"structure"`

	// A token that indicates where to resume retrieving results on the next call
	// to this operation. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`

	// A collection of requested matchmaking rule set objects.
	//
	// RuleSets is a required field
	RuleSets []*MatchmakingRuleSet `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMatchmakingRuleSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMatchmakingRuleSetsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeMatchmakingRuleSetsOutput) SetNextToken(v string) *DescribeMatchmakingRuleSetsOutput {
	s.NextToken = &v
	return s
}

// SetRuleSets sets the RuleSets field's value.
func (s *DescribeMatchmakingRuleSetsOutput) SetRuleSets(v []*MatchmakingRuleSet) *DescribeMatchmakingRuleSetsOutput {
	s.RuleSets = v
	return s
}

type DescribePlayerSessionsInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the game session to retrieve player sessions for.
	GameSessionId *string `min:"1" type:"string"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages. If a player session ID is specified,
	// this parameter is ignored.
	Limit *int64 `min:"1" type:"integer"`

	// A token that indicates the start of the next sequential page of results.
	// Use the token that is returned with a previous call to this operation. To
	// start at the beginning of the result set, do not specify a value. If a player
	// session ID is specified, this parameter is ignored.
	NextToken *string `min:"1" type:"string"`

	// A unique identifier for a player to retrieve player sessions for.
	//
	// PlayerId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DescribePlayerSessionsInput's
	// String and GoString methods.
	PlayerId *string `min:"1" type:"string" sensitive:"true"`

	// A unique identifier for a player session to retrieve.
	PlayerSessionId *string `type:"string"`

	// Player session status to filter results on. Note that when a PlayerSessionId
	// or PlayerId is provided in a DescribePlayerSessions request, then the PlayerSessionStatusFilter
	// has no effect on the response.
	//
	// Possible player session statuses include the following:
	//
	//    * RESERVED -- The player session request has been received, but the player
	//    has not yet connected to the server process and/or been validated.
	//
	//    * ACTIVE -- The player has been validated by the server process and is
	//    currently connected.
	//
	//    * COMPLETED -- The player connection has been dropped.
	//
	//    * TIMEDOUT -- A player session request was received, but the player did
	//    not connect and/or was not validated within the timeout limit (60 seconds).
	PlayerSessionStatusFilter *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePlayerSessionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePlayerSessionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePlayerSessionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePlayerSessionsInput"}
	if s.GameSessionId != nil && len(*s.GameSessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionId", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.PlayerId != nil && len(*s.PlayerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlayerId", 1))
	}
	if s.PlayerSessionStatusFilter != nil && len(*s.PlayerSessionStatusFilter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlayerSessionStatusFilter", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameSessionId sets the GameSessionId field's value.
func (s *DescribePlayerSessionsInput) SetGameSessionId(v string) *DescribePlayerSessionsInput {
	s.GameSessionId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribePlayerSessionsInput) SetLimit(v int64) *DescribePlayerSessionsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribePlayerSessionsInput) SetNextToken(v string) *DescribePlayerSessionsInput {
	s.NextToken = &v
	return s
}

// SetPlayerId sets the PlayerId field's value.
func (s *DescribePlayerSessionsInput) SetPlayerId(v string) *DescribePlayerSessionsInput {
	s.PlayerId = &v
	return s
}

// SetPlayerSessionId sets the PlayerSessionId field's value.
func (s *DescribePlayerSessionsInput) SetPlayerSessionId(v string) *DescribePlayerSessionsInput {
	s.PlayerSessionId = &v
	return s
}

// SetPlayerSessionStatusFilter sets the PlayerSessionStatusFilter field's value.
func (s *DescribePlayerSessionsInput) SetPlayerSessionStatusFilter(v string) *DescribePlayerSessionsInput {
	s.PlayerSessionStatusFilter = &v
	return s
}

type DescribePlayerSessionsOutput struct {
	_ struct{} `type:"structure"`

	// A token that indicates where to resume retrieving results on the next call
	// to this operation. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`

	// A collection of objects containing properties for each player session that
	// matches the request.
	PlayerSessions []*PlayerSession `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePlayerSessionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePlayerSessionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribePlayerSessionsOutput) SetNextToken(v string) *DescribePlayerSessionsOutput {
	s.NextToken = &v
	return s
}

// SetPlayerSessions sets the PlayerSessions field's value.
func (s *DescribePlayerSessionsOutput) SetPlayerSessions(v []*PlayerSession) *DescribePlayerSessionsOutput {
	s.PlayerSessions = v
	return s
}

type DescribeRuntimeConfigurationInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the fleet to get the runtime configuration for. You
	// can use either the fleet ID or ARN value.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRuntimeConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRuntimeConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRuntimeConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRuntimeConfigurationInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *DescribeRuntimeConfigurationInput) SetFleetId(v string) *DescribeRuntimeConfigurationInput {
	s.FleetId = &v
	return s
}

type DescribeRuntimeConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Instructions that describe how server processes should be launched and maintained
	// on each instance in the fleet.
	RuntimeConfiguration *RuntimeConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRuntimeConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRuntimeConfigurationOutput) GoString() string {
	return s.String()
}

// SetRuntimeConfiguration sets the RuntimeConfiguration field's value.
func (s *DescribeRuntimeConfigurationOutput) SetRuntimeConfiguration(v *RuntimeConfiguration) *DescribeRuntimeConfigurationOutput {
	s.RuntimeConfiguration = v
	return s
}

type DescribeScalingPoliciesInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the fleet for which to retrieve scaling policies.
	// You can use either the fleet ID or ARN value.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// The fleet location. If you don't specify this value, the response contains
	// the scaling policies of every location in the fleet.
	Location *string `min:"1" type:"string"`

	// A token that indicates the start of the next sequential page of results.
	// Use the token that is returned with a previous call to this operation. To
	// start at the beginning of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`

	// Scaling policy status to filter results on. A scaling policy is only in force
	// when in an ACTIVE status.
	//
	//    * ACTIVE -- The scaling policy is currently in force.
	//
	//    * UPDATEREQUESTED -- A request to update the scaling policy has been received.
	//
	//    * UPDATING -- A change is being made to the scaling policy.
	//
	//    * DELETEREQUESTED -- A request to delete the scaling policy has been received.
	//
	//    * DELETING -- The scaling policy is being deleted.
	//
	//    * DELETED -- The scaling policy has been deleted.
	//
	//    * ERROR -- An error occurred in creating the policy. It should be removed
	//    and recreated.
	StatusFilter *string `type:"string" enum:"ScalingStatusType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScalingPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScalingPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeScalingPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeScalingPoliciesInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Location != nil && len(*s.Location) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Location", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *DescribeScalingPoliciesInput) SetFleetId(v string) *DescribeScalingPoliciesInput {
	s.FleetId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeScalingPoliciesInput) SetLimit(v int64) *DescribeScalingPoliciesInput {
	s.Limit = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *DescribeScalingPoliciesInput) SetLocation(v string) *DescribeScalingPoliciesInput {
	s.Location = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScalingPoliciesInput) SetNextToken(v string) *DescribeScalingPoliciesInput {
	s.NextToken = &v
	return s
}

// SetStatusFilter sets the StatusFilter field's value.
func (s *DescribeScalingPoliciesInput) SetStatusFilter(v string) *DescribeScalingPoliciesInput {
	s.StatusFilter = &v
	return s
}

type DescribeScalingPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// A token that indicates where to resume retrieving results on the next call
	// to this operation. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`

	// A collection of objects containing the scaling policies matching the request.
	ScalingPolicies []*ScalingPolicy `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScalingPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScalingPoliciesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeScalingPoliciesOutput) SetNextToken(v string) *DescribeScalingPoliciesOutput {
	s.NextToken = &v
	return s
}

// SetScalingPolicies sets the ScalingPolicies field's value.
func (s *DescribeScalingPoliciesOutput) SetScalingPolicies(v []*ScalingPolicy) *DescribeScalingPoliciesOutput {
	s.ScalingPolicies = v
	return s
}

type DescribeScriptInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the Realtime script to retrieve properties for. You
	// can use either the script ID or ARN value.
	//
	// ScriptId is a required field
	ScriptId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScriptInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScriptInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeScriptInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeScriptInput"}
	if s.ScriptId == nil {
		invalidParams.Add(request.NewErrParamRequired("ScriptId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScriptId sets the ScriptId field's value.
func (s *DescribeScriptInput) SetScriptId(v string) *DescribeScriptInput {
	s.ScriptId = &v
	return s
}

type DescribeScriptOutput struct {
	_ struct{} `type:"structure"`

	// A set of properties describing the requested script.
	Script *Script `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScriptOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeScriptOutput) GoString() string {
	return s.String()
}

// SetScript sets the Script field's value.
func (s *DescribeScriptOutput) SetScript(v *Script) *DescribeScriptOutput {
	s.Script = v
	return s
}

type DescribeVpcPeeringAuthorizationsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVpcPeeringAuthorizationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVpcPeeringAuthorizationsInput) GoString() string {
	return s.String()
}

type DescribeVpcPeeringAuthorizationsOutput struct {
	_ struct{} `type:"structure"`

	// A collection of objects that describe all valid VPC peering operations for
	// the current Amazon Web Services account.
	VpcPeeringAuthorizations []*VpcPeeringAuthorization `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVpcPeeringAuthorizationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVpcPeeringAuthorizationsOutput) GoString() string {
	return s.String()
}

// SetVpcPeeringAuthorizations sets the VpcPeeringAuthorizations field's value.
func (s *DescribeVpcPeeringAuthorizationsOutput) SetVpcPeeringAuthorizations(v []*VpcPeeringAuthorization) *DescribeVpcPeeringAuthorizationsOutput {
	s.VpcPeeringAuthorizations = v
	return s
}

type DescribeVpcPeeringConnectionsInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the fleet. You can use either the fleet ID or ARN
	// value.
	FleetId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVpcPeeringConnectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVpcPeeringConnectionsInput) GoString() string {
	return s.String()
}

// SetFleetId sets the FleetId field's value.
func (s *DescribeVpcPeeringConnectionsInput) SetFleetId(v string) *DescribeVpcPeeringConnectionsInput {
	s.FleetId = &v
	return s
}

type DescribeVpcPeeringConnectionsOutput struct {
	_ struct{} `type:"structure"`

	// A collection of VPC peering connection records that match the request.
	VpcPeeringConnections []*VpcPeeringConnection `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVpcPeeringConnectionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeVpcPeeringConnectionsOutput) GoString() string {
	return s.String()
}

// SetVpcPeeringConnections sets the VpcPeeringConnections field's value.
func (s *DescribeVpcPeeringConnectionsOutput) SetVpcPeeringConnections(v []*VpcPeeringConnection) *DescribeVpcPeeringConnectionsOutput {
	s.VpcPeeringConnections = v
	return s
}

// Player information for use when creating player sessions using a game session
// placement request.
type DesiredPlayerSession struct {
	_ struct{} `type:"structure"`

	// Developer-defined information related to a player. Amazon GameLift does not
	// use this data, so it can be formatted as needed for use in the game.
	PlayerData *string `min:"1" type:"string"`

	// A unique identifier for a player to associate with the player session.
	//
	// PlayerId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DesiredPlayerSession's
	// String and GoString methods.
	PlayerId *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DesiredPlayerSession) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DesiredPlayerSession) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DesiredPlayerSession) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DesiredPlayerSession"}
	if s.PlayerData != nil && len(*s.PlayerData) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlayerData", 1))
	}
	if s.PlayerId != nil && len(*s.PlayerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlayerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPlayerData sets the PlayerData field's value.
func (s *DesiredPlayerSession) SetPlayerData(v string) *DesiredPlayerSession {
	s.PlayerData = &v
	return s
}

// SetPlayerId sets the PlayerId field's value.
func (s *DesiredPlayerSession) SetPlayerId(v string) *DesiredPlayerSession {
	s.PlayerId = &v
	return s
}

// Resource capacity settings. Fleet capacity is measured in Amazon EC2 instances.
// Pending and terminating counts are non-zero when the fleet capacity is adjusting
// to a scaling event or if access to resources is temporarily affected.
type EC2InstanceCounts struct {
	_ struct{} `type:"structure"`

	// Actual number of instances that are ready to host game sessions.
	ACTIVE *int64 `type:"integer"`

	// Requested number of active instances. Amazon GameLift takes action as needed
	// to maintain the desired number of instances. Capacity is scaled up or down
	// by changing the desired instances. A change in the desired instances value
	// can take up to 1 minute to be reflected when viewing a fleet's capacity settings.
	DESIRED *int64 `type:"integer"`

	// Number of active instances that are not currently hosting a game session.
	IDLE *int64 `type:"integer"`

	// The maximum instance count value allowed.
	MAXIMUM *int64 `type:"integer"`

	// The minimum instance count value allowed.
	MINIMUM *int64 `type:"integer"`

	// Number of instances that are starting but not yet active.
	PENDING *int64 `type:"integer"`

	// Number of instances that are no longer active but haven't yet been terminated.
	TERMINATING *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EC2InstanceCounts) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EC2InstanceCounts) GoString() string {
	return s.String()
}

// SetACTIVE sets the ACTIVE field's value.
func (s *EC2InstanceCounts) SetACTIVE(v int64) *EC2InstanceCounts {
	s.ACTIVE = &v
	return s
}

// SetDESIRED sets the DESIRED field's value.
func (s *EC2InstanceCounts) SetDESIRED(v int64) *EC2InstanceCounts {
	s.DESIRED = &v
	return s
}

// SetIDLE sets the IDLE field's value.
func (s *EC2InstanceCounts) SetIDLE(v int64) *EC2InstanceCounts {
	s.IDLE = &v
	return s
}

// SetMAXIMUM sets the MAXIMUM field's value.
func (s *EC2InstanceCounts) SetMAXIMUM(v int64) *EC2InstanceCounts {
	s.MAXIMUM = &v
	return s
}

// SetMINIMUM sets the MINIMUM field's value.
func (s *EC2InstanceCounts) SetMINIMUM(v int64) *EC2InstanceCounts {
	s.MINIMUM = &v
	return s
}

// SetPENDING sets the PENDING field's value.
func (s *EC2InstanceCounts) SetPENDING(v int64) *EC2InstanceCounts {
	s.PENDING = &v
	return s
}

// SetTERMINATING sets the TERMINATING field's value.
func (s *EC2InstanceCounts) SetTERMINATING(v int64) *EC2InstanceCounts {
	s.TERMINATING = &v
	return s
}

// The Amazon GameLift service limits for an Amazon EC2 instance type and current
// utilization. Amazon GameLift allows Amazon Web Services accounts a maximum
// number of instances, per instance type, per Amazon Web Services Region or
// location, for use with Amazon GameLift. You can request an limit increase
// for your account by using the Service limits page in the Amazon GameLift
// console.
type EC2InstanceLimit struct {
	_ struct{} `type:"structure"`

	// The number of instances for the specified type and location that are currently
	// being used by the Amazon Web Services account.
	CurrentInstances *int64 `type:"integer"`

	// The name of an Amazon EC2 instance type. See Amazon Elastic Compute Cloud
	// Instance Types (http://aws.amazon.com/ec2/instance-types/) for detailed descriptions.
	EC2InstanceType *string `type:"string" enum:"EC2InstanceType"`

	// The number of instances that is allowed for the specified instance type and
	// location.
	InstanceLimit *int64 `type:"integer"`

	// An Amazon Web Services Region code, such as us-west-2.
	Location *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EC2InstanceLimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EC2InstanceLimit) GoString() string {
	return s.String()
}

// SetCurrentInstances sets the CurrentInstances field's value.
func (s *EC2InstanceLimit) SetCurrentInstances(v int64) *EC2InstanceLimit {
	s.CurrentInstances = &v
	return s
}

// SetEC2InstanceType sets the EC2InstanceType field's value.
func (s *EC2InstanceLimit) SetEC2InstanceType(v string) *EC2InstanceLimit {
	s.EC2InstanceType = &v
	return s
}

// SetInstanceLimit sets the InstanceLimit field's value.
func (s *EC2InstanceLimit) SetInstanceLimit(v int64) *EC2InstanceLimit {
	s.InstanceLimit = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *EC2InstanceLimit) SetLocation(v string) *EC2InstanceLimit {
	s.Location = &v
	return s
}

// Log entry describing an event that involves Amazon GameLift resources (such
// as a fleet). In addition to tracking activity, event codes and messages can
// provide additional information for troubleshooting and debugging problems.
type Event struct {
	_ struct{} `type:"structure"`

	// The type of event being logged.
	//
	// Fleet state transition events:
	//
	//    * FLEET_CREATED -- A fleet resource was successfully created with a status
	//    of NEW. Event messaging includes the fleet ID.
	//
	//    * FLEET_STATE_DOWNLOADING -- Fleet status changed from NEW to DOWNLOADING.
	//    The compressed build has started downloading to a fleet instance for installation.
	//
	//    * FLEET_STATE_VALIDATING -- Fleet status changed from DOWNLOADING to VALIDATING.
	//    Amazon GameLift has successfully downloaded the build and is now validating
	//    the build files.
	//
	//    * FLEET_STATE_BUILDING -- Fleet status changed from VALIDATING to BUILDING.
	//    Amazon GameLift has successfully verified the build files and is now running
	//    the installation scripts.
	//
	//    * FLEET_STATE_ACTIVATING -- Fleet status changed from BUILDING to ACTIVATING.
	//    Amazon GameLift is trying to launch an instance and test the connectivity
	//    between the build and the Amazon GameLift Service via the Server SDK.
	//
	//    * FLEET_STATE_ACTIVE -- The fleet's status changed from ACTIVATING to
	//    ACTIVE. The fleet is now ready to host game sessions.
	//
	//    * FLEET_STATE_ERROR -- The Fleet's status changed to ERROR. Describe the
	//    fleet event message for more details.
	//
	// Fleet creation events (ordered by fleet creation activity):
	//
	//    * FLEET_BINARY_DOWNLOAD_FAILED -- The build failed to download to the
	//    fleet instance.
	//
	//    * FLEET_CREATION_EXTRACTING_BUILD -- The game server build was successfully
	//    downloaded to an instance, and the build files are now being extracted
	//    from the uploaded build and saved to an instance. Failure at this stage
	//    prevents a fleet from moving to ACTIVE status. Logs for this stage display
	//    a list of the files that are extracted and saved on the instance. Access
	//    the logs by using the URL in PreSignedLogUrl.
	//
	//    * FLEET_CREATION_RUNNING_INSTALLER -- The game server build files were
	//    successfully extracted, and the GameLift is now running the build's install
	//    script (if one is included). Failure in this stage prevents a fleet from
	//    moving to ACTIVE status. Logs for this stage list the installation steps
	//    and whether or not the install completed successfully. Access the logs
	//    by using the URL in PreSignedLogUrl.
	//
	//    * FLEET_CREATION_VALIDATING_RUNTIME_CONFIG -- The build process was successful,
	//    and the GameLift is now verifying that the game server launch paths, which
	//    are specified in the fleet's runtime configuration, exist. If any listed
	//    launch path exists, Amazon GameLift tries to launch a game server process
	//    and waits for the process to report ready. Failures in this stage prevent
	//    a fleet from moving to ACTIVE status. Logs for this stage list the launch
	//    paths in the runtime configuration and indicate whether each is found.
	//    Access the logs by using the URL in PreSignedLogUrl.
	//
	//    * FLEET_VALIDATION_LAUNCH_PATH_NOT_FOUND -- Validation of the runtime
	//    configuration failed because the executable specified in a launch path
	//    does not exist on the instance.
	//
	//    * FLEET_VALIDATION_EXECUTABLE_RUNTIME_FAILURE -- Validation of the runtime
	//    configuration failed because the executable specified in a launch path
	//    failed to run on the fleet instance.
	//
	//    * FLEET_VALIDATION_TIMED_OUT -- Validation of the fleet at the end of
	//    creation timed out. Try fleet creation again.
	//
	//    * FLEET_ACTIVATION_FAILED -- The fleet failed to successfully complete
	//    one of the steps in the fleet activation process. This event code indicates
	//    that the game build was successfully downloaded to a fleet instance, built,
	//    and validated, but was not able to start a server process. For more information,
	//    see Debug Fleet Creation Issues (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html#fleets-creating-debug-creation).
	//
	//    * FLEET_ACTIVATION_FAILED_NO_INSTANCES -- Fleet creation was not able
	//    to obtain any instances based on the input fleet attributes. Try again
	//    at a different time or choose a different combination of fleet attributes
	//    such as fleet type, instance type, etc.
	//
	//    * FLEET_INITIALIZATION_FAILED -- A generic exception occurred during fleet
	//    creation. Describe the fleet event message for more details.
	//
	// VPC peering events:
	//
	//    * FLEET_VPC_PEERING_SUCCEEDED -- A VPC peering connection has been established
	//    between the VPC for an Amazon GameLift fleet and a VPC in your Amazon
	//    Web Services account.
	//
	//    * FLEET_VPC_PEERING_FAILED -- A requested VPC peering connection has failed.
	//    Event details and status information provide additional detail. A common
	//    reason for peering failure is that the two VPCs have overlapping CIDR
	//    blocks of IPv4 addresses. To resolve this, change the CIDR block for the
	//    VPC in your Amazon Web Services account. For more information on VPC peering
	//    failures, see https://docs.aws.amazon.com/AmazonVPC/latest/PeeringGuide/invalid-peering-configurations.html
	//    (https://docs.aws.amazon.com/AmazonVPC/latest/PeeringGuide/invalid-peering-configurations.html)
	//
	//    * FLEET_VPC_PEERING_DELETED -- A VPC peering connection has been successfully
	//    deleted.
	//
	// Spot instance events:
	//
	//    * INSTANCE_INTERRUPTED -- A spot instance was interrupted by EC2 with
	//    a two-minute notification.
	//
	//    * INSTANCE_RECYCLED -- A spot instance was determined to have a high risk
	//    of interruption and is scheduled to be recycled once it has no active
	//    game sessions.
	//
	// Server process events:
	//
	//    * SERVER_PROCESS_INVALID_PATH -- The game server executable or script
	//    could not be found based on the Fleet runtime configuration. Check that
	//    the launch path is correct based on the operating system of the Fleet.
	//
	//    * SERVER_PROCESS_SDK_INITIALIZATION_TIMEOUT -- The server process did
	//    not call InitSDK() within the time expected. Check your game session log
	//    to see why InitSDK() was not called in time.
	//
	//    * SERVER_PROCESS_PROCESS_READY_TIMEOUT -- The server process did not call
	//    ProcessReady() within the time expected after calling InitSDK(). Check
	//    your game session log to see why ProcessReady() was not called in time.
	//
	//    * SERVER_PROCESS_CRASHED -- The server process exited without calling
	//    ProcessEnding(). Check your game session log to see why ProcessEnding()
	//    was not called.
	//
	//    * SERVER_PROCESS_TERMINATED_UNHEALTHY -- The server process did not report
	//    a valid health check for too long and was therefore terminated by GameLift.
	//    Check your game session log to see if the thread became stuck processing
	//    a synchronous task for too long.
	//
	//    * SERVER_PROCESS_FORCE_TERMINATED -- The server process did not exit cleanly
	//    after OnProcessTerminate() was sent within the time expected. Check your
	//    game session log to see why termination took longer than expected.
	//
	//    * SERVER_PROCESS_PROCESS_EXIT_TIMEOUT -- The server process did not exit
	//    cleanly within the time expected after calling ProcessEnding(). Check
	//    your game session log to see why termination took longer than expected.
	//
	// Game session events:
	//
	//    * GAME_SESSION_ACTIVATION_TIMEOUT -- GameSession failed to activate within
	//    the expected time. Check your game session log to see why ActivateGameSession()
	//    took longer to complete than expected.
	//
	// Other fleet events:
	//
	//    * FLEET_SCALING_EVENT -- A change was made to the fleet's capacity settings
	//    (desired instances, minimum/maximum scaling limits). Event messaging includes
	//    the new capacity settings.
	//
	//    * FLEET_NEW_GAME_SESSION_PROTECTION_POLICY_UPDATED -- A change was made
	//    to the fleet's game session protection policy setting. Event messaging
	//    includes both the old and new policy setting.
	//
	//    * FLEET_DELETED -- A request to delete a fleet was initiated.
	//
	//    * GENERIC_EVENT -- An unspecified event has occurred.
	EventCode *string `type:"string" enum:"EventCode"`

	// A unique identifier for a fleet event.
	EventId *string `min:"1" type:"string"`

	// Time stamp indicating when this event occurred. Format is a number expressed
	// in Unix time as milliseconds (for example "1469498468.057").
	EventTime *time.Time `type:"timestamp"`

	// Additional information related to the event.
	Message *string `min:"1" type:"string"`

	// Location of stored logs with additional detail that is related to the event.
	// This is useful for debugging issues. The URL is valid for 15 minutes. You
	// can also access fleet creation logs through the Amazon GameLift console.
	PreSignedLogUrl *string `min:"1" type:"string"`

	// A unique identifier for an event resource, such as a fleet ID.
	ResourceId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Event) GoString() string {
	return s.String()
}

// SetEventCode sets the EventCode field's value.
func (s *Event) SetEventCode(v string) *Event {
	s.EventCode = &v
	return s
}

// SetEventId sets the EventId field's value.
func (s *Event) SetEventId(v string) *Event {
	s.EventId = &v
	return s
}

// SetEventTime sets the EventTime field's value.
func (s *Event) SetEventTime(v time.Time) *Event {
	s.EventTime = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *Event) SetMessage(v string) *Event {
	s.Message = &v
	return s
}

// SetPreSignedLogUrl sets the PreSignedLogUrl field's value.
func (s *Event) SetPreSignedLogUrl(v string) *Event {
	s.PreSignedLogUrl = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *Event) SetResourceId(v string) *Event {
	s.ResourceId = &v
	return s
}

// A list of fleet locations where a game session queue can place new game sessions.
// You can use a filter to temporarily turn off placements for specific locations.
// For queues that have multi-location fleets, you can use a filter configuration
// allow placement with some, but not all of these locations.
type FilterConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of locations to allow game session placement in, in the form of Amazon
	// Web Services Region codes such as us-west-2.
	AllowedLocations []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FilterConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FilterConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FilterConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FilterConfiguration"}
	if s.AllowedLocations != nil && len(s.AllowedLocations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AllowedLocations", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowedLocations sets the AllowedLocations field's value.
func (s *FilterConfiguration) SetAllowedLocations(v []*string) *FilterConfiguration {
	s.AllowedLocations = v
	return s
}

// Describes a Amazon GameLift fleet of game hosting resources.
//
// Related actions
type FleetAttributes struct {
	_ struct{} `type:"structure"`

	// Amazon GameLift Anywhere configuration options for your Anywhere fleets.
	AnywhereConfiguration *AnywhereConfiguration `type:"structure"`

	// The Amazon Resource Name (ARN (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// associated with the Amazon GameLift build resource that is deployed on instances
	// in this fleet. In a GameLift build ARN, the resource ID matches the BuildId
	// value.
	BuildArn *string `type:"string"`

	// A unique identifier for the build resource that is deployed on instances
	// in this fleet.
	BuildId *string `type:"string"`

	// Determines whether a TLS/SSL certificate is generated for a fleet. This feature
	// must be enabled when creating the fleet. All instances in a fleet share the
	// same certificate. The certificate can be retrieved by calling the Amazon
	// GameLift Server SDK (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk.html)
	// operation GetInstanceCertificate.
	CertificateConfiguration *CertificateConfiguration `type:"structure"`

	// The type of compute resource used to host your game servers. You can use
	// your own compute resources with Amazon GameLift Anywhere or use Amazon EC2
	// instances with managed Amazon GameLift.
	ComputeType *string `type:"string" enum:"ComputeType"`

	// A time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time `type:"timestamp"`

	// A human-readable description of the fleet.
	Description *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// that is assigned to a Amazon GameLift fleet resource and uniquely identifies
	// it. ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912.
	// In a GameLift fleet ARN, the resource ID matches the FleetId value.
	FleetArn *string `type:"string"`

	// A unique identifier for the fleet.
	FleetId *string `type:"string"`

	// Indicates whether to use On-Demand or Spot instances for this fleet. By default,
	// this property is set to ON_DEMAND. Learn more about when to use On-Demand
	// versus Spot Instances (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot).
	// This fleet property can't be changed after the fleet is created.
	FleetType *string `type:"string" enum:"FleetType"`

	// A unique identifier for an IAM role with access permissions to other Amazon
	// Web Services services. Any application that runs on an instance in the fleet--including
	// install scripts, server processes, and other processes--can use these permissions
	// to interact with Amazon Web Services resources that you own or have access
	// to. For more information about using the role with your game server builds,
	// see Communicate with other Amazon Web Services resources from your fleets
	// (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html).
	InstanceRoleArn *string `min:"1" type:"string"`

	// Indicates that fleet instances maintain a shared credentials file for the
	// IAM role defined in InstanceRoleArn. Shared credentials allow applications
	// that are deployed with the game server executable to communicate with other
	// Amazon Web Services resources. This property is used only when the game server
	// is integrated with the server SDK version 5.x. For more information about
	// using shared credentials, see Communicate with other Amazon Web Services
	// resources from your fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html).
	InstanceRoleCredentialsProvider *string `type:"string" enum:"InstanceRoleCredentialsProvider"`

	// The Amazon EC2 instance type that determines the computing resources of each
	// instance in the fleet. Instance type defines the CPU, memory, storage, and
	// networking capacity. See Amazon Elastic Compute Cloud Instance Types (http://aws.amazon.com/ec2/instance-types/)
	// for detailed descriptions.
	InstanceType *string `type:"string" enum:"EC2InstanceType"`

	// This parameter is no longer used. Game session log paths are now defined
	// using the Amazon GameLift server API ProcessReady() logParameters. See more
	// information in the Server API Reference (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process).
	LogPaths []*string `type:"list"`

	// Name of a metric group that metrics for this fleet are added to. In Amazon
	// CloudWatch, you can view aggregated metrics for fleets that are in a metric
	// group. A fleet can be included in only one metric group at a time.
	MetricGroups []*string `type:"list"`

	// A descriptive label that is associated with a fleet. Fleet names do not need
	// to be unique.
	Name *string `min:"1" type:"string"`

	// The type of game session protection to set on all new instances that are
	// started in the fleet.
	//
	//    * NoProtection -- The game session can be terminated during a scale-down
	//    event.
	//
	//    * FullProtection -- If the game session is in an ACTIVE status, it cannot
	//    be terminated during a scale-down event.
	NewGameSessionProtectionPolicy *string `type:"string" enum:"ProtectionPolicy"`

	// The operating system of the fleet's computing resources. A fleet's operating
	// system is determined by the OS of the build or script that is deployed on
	// this fleet.
	OperatingSystem *string `type:"string" enum:"OperatingSystem"`

	// A policy that puts limits on the number of game sessions that a player can
	// create within a specified span of time. With this policy, you can control
	// players' ability to consume available resources.
	//
	// The policy is evaluated when a player tries to create a new game session.
	// On receiving a CreateGameSession request, Amazon GameLift checks that the
	// player (identified by CreatorId) has created fewer than game session limit
	// in the specified time period.
	ResourceCreationLimitPolicy *ResourceCreationLimitPolicy `type:"structure"`

	// The Amazon Resource Name (ARN (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// associated with the GameLift script resource that is deployed on instances
	// in this fleet. In a GameLift script ARN, the resource ID matches the ScriptId
	// value.
	ScriptArn *string `type:"string"`

	// A unique identifier for the Realtime script resource that is deployed on
	// instances in this fleet.
	ScriptId *string `type:"string"`

	// This parameter is no longer used. Server launch parameters are now defined
	// using the fleet's runtime configuration . Requests that use this parameter
	// instead continue to be valid.
	ServerLaunchParameters *string `min:"1" type:"string"`

	// This parameter is no longer used. Server launch paths are now defined using
	// the fleet's RuntimeConfiguration (https://docs.aws.amazon.com/gamelift/latest/apireference/RuntimeConfiguration.html)
	// . Requests that use this parameter instead continue to be valid.
	ServerLaunchPath *string `min:"1" type:"string"`

	// Current status of the fleet. Possible fleet statuses include the following:
	//
	//    * NEW -- A new fleet has been defined and desired instances is set to
	//    1.
	//
	//    * DOWNLOADING/VALIDATING/BUILDING/ACTIVATING -- Amazon GameLift is setting
	//    up the new fleet, creating new instances with the game build or Realtime
	//    script and starting server processes.
	//
	//    * ACTIVE -- Hosts can now accept game sessions.
	//
	//    * ERROR -- An error occurred when downloading, validating, building, or
	//    activating the fleet.
	//
	//    * DELETING -- Hosts are responding to a delete fleet request.
	//
	//    * TERMINATED -- The fleet no longer exists.
	Status *string `type:"string" enum:"FleetStatus"`

	// A list of fleet activity that has been suspended using StopFleetActions (https://docs.aws.amazon.com/gamelift/latest/apireference/API_StopFleetActions.html)
	// . This includes fleet auto-scaling.
	StoppedActions []*string `min:"1" type:"list" enum:"FleetAction"`

	// A time stamp indicating when this data object was terminated. Format is a
	// number expressed in Unix time as milliseconds (for example "1469498468.057").
	TerminationTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FleetAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FleetAttributes) GoString() string {
	return s.String()
}

// SetAnywhereConfiguration sets the AnywhereConfiguration field's value.
func (s *FleetAttributes) SetAnywhereConfiguration(v *AnywhereConfiguration) *FleetAttributes {
	s.AnywhereConfiguration = v
	return s
}

// SetBuildArn sets the BuildArn field's value.
func (s *FleetAttributes) SetBuildArn(v string) *FleetAttributes {
	s.BuildArn = &v
	return s
}

// SetBuildId sets the BuildId field's value.
func (s *FleetAttributes) SetBuildId(v string) *FleetAttributes {
	s.BuildId = &v
	return s
}

// SetCertificateConfiguration sets the CertificateConfiguration field's value.
func (s *FleetAttributes) SetCertificateConfiguration(v *CertificateConfiguration) *FleetAttributes {
	s.CertificateConfiguration = v
	return s
}

// SetComputeType sets the ComputeType field's value.
func (s *FleetAttributes) SetComputeType(v string) *FleetAttributes {
	s.ComputeType = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *FleetAttributes) SetCreationTime(v time.Time) *FleetAttributes {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *FleetAttributes) SetDescription(v string) *FleetAttributes {
	s.Description = &v
	return s
}

// SetFleetArn sets the FleetArn field's value.
func (s *FleetAttributes) SetFleetArn(v string) *FleetAttributes {
	s.FleetArn = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *FleetAttributes) SetFleetId(v string) *FleetAttributes {
	s.FleetId = &v
	return s
}

// SetFleetType sets the FleetType field's value.
func (s *FleetAttributes) SetFleetType(v string) *FleetAttributes {
	s.FleetType = &v
	return s
}

// SetInstanceRoleArn sets the InstanceRoleArn field's value.
func (s *FleetAttributes) SetInstanceRoleArn(v string) *FleetAttributes {
	s.InstanceRoleArn = &v
	return s
}

// SetInstanceRoleCredentialsProvider sets the InstanceRoleCredentialsProvider field's value.
func (s *FleetAttributes) SetInstanceRoleCredentialsProvider(v string) *FleetAttributes {
	s.InstanceRoleCredentialsProvider = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *FleetAttributes) SetInstanceType(v string) *FleetAttributes {
	s.InstanceType = &v
	return s
}

// SetLogPaths sets the LogPaths field's value.
func (s *FleetAttributes) SetLogPaths(v []*string) *FleetAttributes {
	s.LogPaths = v
	return s
}

// SetMetricGroups sets the MetricGroups field's value.
func (s *FleetAttributes) SetMetricGroups(v []*string) *FleetAttributes {
	s.MetricGroups = v
	return s
}

// SetName sets the Name field's value.
func (s *FleetAttributes) SetName(v string) *FleetAttributes {
	s.Name = &v
	return s
}

// SetNewGameSessionProtectionPolicy sets the NewGameSessionProtectionPolicy field's value.
func (s *FleetAttributes) SetNewGameSessionProtectionPolicy(v string) *FleetAttributes {
	s.NewGameSessionProtectionPolicy = &v
	return s
}

// SetOperatingSystem sets the OperatingSystem field's value.
func (s *FleetAttributes) SetOperatingSystem(v string) *FleetAttributes {
	s.OperatingSystem = &v
	return s
}

// SetResourceCreationLimitPolicy sets the ResourceCreationLimitPolicy field's value.
func (s *FleetAttributes) SetResourceCreationLimitPolicy(v *ResourceCreationLimitPolicy) *FleetAttributes {
	s.ResourceCreationLimitPolicy = v
	return s
}

// SetScriptArn sets the ScriptArn field's value.
func (s *FleetAttributes) SetScriptArn(v string) *FleetAttributes {
	s.ScriptArn = &v
	return s
}

// SetScriptId sets the ScriptId field's value.
func (s *FleetAttributes) SetScriptId(v string) *FleetAttributes {
	s.ScriptId = &v
	return s
}

// SetServerLaunchParameters sets the ServerLaunchParameters field's value.
func (s *FleetAttributes) SetServerLaunchParameters(v string) *FleetAttributes {
	s.ServerLaunchParameters = &v
	return s
}

// SetServerLaunchPath sets the ServerLaunchPath field's value.
func (s *FleetAttributes) SetServerLaunchPath(v string) *FleetAttributes {
	s.ServerLaunchPath = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *FleetAttributes) SetStatus(v string) *FleetAttributes {
	s.Status = &v
	return s
}

// SetStoppedActions sets the StoppedActions field's value.
func (s *FleetAttributes) SetStoppedActions(v []*string) *FleetAttributes {
	s.StoppedActions = v
	return s
}

// SetTerminationTime sets the TerminationTime field's value.
func (s *FleetAttributes) SetTerminationTime(v time.Time) *FleetAttributes {
	s.TerminationTime = &v
	return s
}

// Current resource capacity settings in a specified fleet or location. The
// location value might refer to a fleet's remote location or its home Region.
//
// # Related actions
//
// DescribeFleetCapacity (https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetCapacity.html)
// | DescribeFleetLocationCapacity (https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationCapacity.html)
// | UpdateFleetCapacity (https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateFleetCapacity.html)
type FleetCapacity struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// that is assigned to a Amazon GameLift fleet resource and uniquely identifies
	// it. ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912.
	FleetArn *string `type:"string"`

	// A unique identifier for the fleet associated with the location.
	FleetId *string `type:"string"`

	// Resource capacity settings. Fleet capacity is measured in Amazon EC2 instances.
	// Pending and terminating counts are non-zero when the fleet capacity is adjusting
	// to a scaling event or if access to resources is temporarily affected.
	InstanceCounts *EC2InstanceCounts `type:"structure"`

	// The Amazon EC2 instance type that is used for all instances in a fleet. The
	// instance type determines the computing resources in use, including CPU, memory,
	// storage, and networking capacity. See Amazon Elastic Compute Cloud Instance
	// Types (http://aws.amazon.com/ec2/instance-types/) for detailed descriptions.
	InstanceType *string `type:"string" enum:"EC2InstanceType"`

	// The fleet location for the instance count information, expressed as an Amazon
	// Web Services Region code, such as us-west-2.
	Location *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FleetCapacity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FleetCapacity) GoString() string {
	return s.String()
}

// SetFleetArn sets the FleetArn field's value.
func (s *FleetCapacity) SetFleetArn(v string) *FleetCapacity {
	s.FleetArn = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *FleetCapacity) SetFleetId(v string) *FleetCapacity {
	s.FleetId = &v
	return s
}

// SetInstanceCounts sets the InstanceCounts field's value.
func (s *FleetCapacity) SetInstanceCounts(v *EC2InstanceCounts) *FleetCapacity {
	s.InstanceCounts = v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *FleetCapacity) SetInstanceType(v string) *FleetCapacity {
	s.InstanceType = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *FleetCapacity) SetLocation(v string) *FleetCapacity {
	s.Location = &v
	return s
}

// The specified fleet has no available instances to fulfill a CreateGameSession
// request. Clients can retry such requests immediately or after a waiting period.
type FleetCapacityExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FleetCapacityExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FleetCapacityExceededException) GoString() string {
	return s.String()
}

func newErrorFleetCapacityExceededException(v protocol.ResponseMetadata) error {
	return &FleetCapacityExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *FleetCapacityExceededException) Code() string {
	return "FleetCapacityExceededException"
}

// Message returns the exception's message.
func (s *FleetCapacityExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *FleetCapacityExceededException) OrigErr() error {
	return nil
}

func (s *FleetCapacityExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *FleetCapacityExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *FleetCapacityExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Current resource utilization statistics in a specified fleet or location.
// The location value might refer to a fleet's remote location or its home Region.
//
// Related actions
type FleetUtilization struct {
	_ struct{} `type:"structure"`

	// The number of active game sessions that are currently being hosted across
	// all instances in the fleet location.
	ActiveGameSessionCount *int64 `type:"integer"`

	// The number of server processes in ACTIVE status that are currently running
	// across all instances in the fleet location.
	ActiveServerProcessCount *int64 `type:"integer"`

	// The number of active player sessions that are currently being hosted across
	// all instances in the fleet location.
	CurrentPlayerSessionCount *int64 `type:"integer"`

	// The Amazon Resource Name (ARN (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// that is assigned to a Amazon GameLift fleet resource and uniquely identifies
	// it. ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912.
	FleetArn *string `type:"string"`

	// A unique identifier for the fleet associated with the location.
	FleetId *string `type:"string"`

	// The fleet location for the fleet utilization information, expressed as an
	// Amazon Web Services Region code, such as us-west-2.
	Location *string `min:"1" type:"string"`

	// The maximum number of players allowed across all game sessions that are currently
	// being hosted across all instances in the fleet location.
	MaximumPlayerSessionCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FleetUtilization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FleetUtilization) GoString() string {
	return s.String()
}

// SetActiveGameSessionCount sets the ActiveGameSessionCount field's value.
func (s *FleetUtilization) SetActiveGameSessionCount(v int64) *FleetUtilization {
	s.ActiveGameSessionCount = &v
	return s
}

// SetActiveServerProcessCount sets the ActiveServerProcessCount field's value.
func (s *FleetUtilization) SetActiveServerProcessCount(v int64) *FleetUtilization {
	s.ActiveServerProcessCount = &v
	return s
}

// SetCurrentPlayerSessionCount sets the CurrentPlayerSessionCount field's value.
func (s *FleetUtilization) SetCurrentPlayerSessionCount(v int64) *FleetUtilization {
	s.CurrentPlayerSessionCount = &v
	return s
}

// SetFleetArn sets the FleetArn field's value.
func (s *FleetUtilization) SetFleetArn(v string) *FleetUtilization {
	s.FleetArn = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *FleetUtilization) SetFleetId(v string) *FleetUtilization {
	s.FleetId = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *FleetUtilization) SetLocation(v string) *FleetUtilization {
	s.Location = &v
	return s
}

// SetMaximumPlayerSessionCount sets the MaximumPlayerSessionCount field's value.
func (s *FleetUtilization) SetMaximumPlayerSessionCount(v int64) *FleetUtilization {
	s.MaximumPlayerSessionCount = &v
	return s
}

// Set of key-value pairs that contain information about a game session. When
// included in a game session request, these properties communicate details
// to be used when setting up the new game session. For example, a game property
// might specify a game mode, level, or map. Game properties are passed to the
// game server process when initiating a new game session. For more information,
// see the Amazon GameLift Developer Guide (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#gamelift-sdk-client-api-create).
type GameProperty struct {
	_ struct{} `type:"structure"`

	// The game property identifier.
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`

	// The game property value.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GameProperty) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GameProperty) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GameProperty) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GameProperty"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *GameProperty) SetKey(v string) *GameProperty {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *GameProperty) SetValue(v string) *GameProperty {
	s.Value = &v
	return s
}

// This data type is used with the Amazon GameLift FleetIQ and game server groups.
//
// Properties describing a game server that is running on an instance in a game
// server group.
//
// A game server is created by a successful call to RegisterGameServer and deleted
// by calling DeregisterGameServer. A game server is claimed to host a game
// session by calling ClaimGameServer.
type GameServer struct {
	_ struct{} `type:"structure"`

	// Indicates when an available game server has been reserved for gameplay but
	// has not yet started hosting a game. Once it is claimed, the game server remains
	// in CLAIMED status for a maximum of one minute. During this time, game clients
	// connect to the game server to start the game and trigger the game server
	// to update its utilization status. After one minute, the game server claim
	// status reverts to null.
	ClaimStatus *string `type:"string" enum:"GameServerClaimStatus"`

	// The port and IP address that must be used to establish a client connection
	// to the game server.
	ConnectionInfo *string `min:"1" type:"string"`

	// A set of custom game server properties, formatted as a single string value.
	// This data is passed to a game client or service when it requests information
	// on game servers.
	GameServerData *string `min:"1" type:"string"`

	// The ARN identifier for the game server group where the game server is located.
	GameServerGroupArn *string `min:"1" type:"string"`

	// A unique identifier for the game server group where the game server is running.
	GameServerGroupName *string `min:"1" type:"string"`

	// A custom string that uniquely identifies the game server. Game server IDs
	// are developer-defined and are unique across all game server groups in an
	// Amazon Web Services account.
	GameServerId *string `min:"3" type:"string"`

	// The unique identifier for the instance where the game server is running.
	// This ID is available in the instance metadata. EC2 instance IDs use a 17-character
	// format, for example: i-1234567890abcdef0.
	InstanceId *string `min:"19" type:"string"`

	// Timestamp that indicates the last time the game server was claimed. The format
	// is a number expressed in Unix time as milliseconds (for example "1469498468.057").
	// This value is used to calculate when a claimed game server's status should
	// revert to null.
	LastClaimTime *time.Time `type:"timestamp"`

	// Timestamp that indicates the last time the game server was updated with health
	// status. The format is a number expressed in Unix time as milliseconds (for
	// example "1469498468.057"). After game server registration, this property
	// is only changed when a game server update specifies a health check value.
	LastHealthCheckTime *time.Time `type:"timestamp"`

	// Timestamp that indicates when the game server registered. The format is a
	// number expressed in Unix time as milliseconds (for example "1469498468.057").
	RegistrationTime *time.Time `type:"timestamp"`

	// Indicates whether the game server is currently available for new games or
	// is busy. Possible statuses include:
	//
	//    * AVAILABLE - The game server is available to be claimed. A game server
	//    that has been claimed remains in this status until it reports game hosting
	//    activity.
	//
	//    * UTILIZED - The game server is currently hosting a game session with
	//    players.
	UtilizationStatus *string `type:"string" enum:"GameServerUtilizationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GameServer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GameServer) GoString() string {
	return s.String()
}

// SetClaimStatus sets the ClaimStatus field's value.
func (s *GameServer) SetClaimStatus(v string) *GameServer {
	s.ClaimStatus = &v
	return s
}

// SetConnectionInfo sets the ConnectionInfo field's value.
func (s *GameServer) SetConnectionInfo(v string) *GameServer {
	s.ConnectionInfo = &v
	return s
}

// SetGameServerData sets the GameServerData field's value.
func (s *GameServer) SetGameServerData(v string) *GameServer {
	s.GameServerData = &v
	return s
}

// SetGameServerGroupArn sets the GameServerGroupArn field's value.
func (s *GameServer) SetGameServerGroupArn(v string) *GameServer {
	s.GameServerGroupArn = &v
	return s
}

// SetGameServerGroupName sets the GameServerGroupName field's value.
func (s *GameServer) SetGameServerGroupName(v string) *GameServer {
	s.GameServerGroupName = &v
	return s
}

// SetGameServerId sets the GameServerId field's value.
func (s *GameServer) SetGameServerId(v string) *GameServer {
	s.GameServerId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *GameServer) SetInstanceId(v string) *GameServer {
	s.InstanceId = &v
	return s
}

// SetLastClaimTime sets the LastClaimTime field's value.
func (s *GameServer) SetLastClaimTime(v time.Time) *GameServer {
	s.LastClaimTime = &v
	return s
}

// SetLastHealthCheckTime sets the LastHealthCheckTime field's value.
func (s *GameServer) SetLastHealthCheckTime(v time.Time) *GameServer {
	s.LastHealthCheckTime = &v
	return s
}

// SetRegistrationTime sets the RegistrationTime field's value.
func (s *GameServer) SetRegistrationTime(v time.Time) *GameServer {
	s.RegistrationTime = &v
	return s
}

// SetUtilizationStatus sets the UtilizationStatus field's value.
func (s *GameServer) SetUtilizationStatus(v string) *GameServer {
	s.UtilizationStatus = &v
	return s
}

// This data type is used with the Amazon GameLift FleetIQ and game server groups.
//
// Properties that describe a game server group resource. A game server group
// manages certain properties related to a corresponding Amazon EC2 Auto Scaling
// group.
//
// A game server group is created by a successful call to CreateGameServerGroup
// and deleted by calling DeleteGameServerGroup. Game server group activity
// can be temporarily suspended and resumed by calling SuspendGameServerGroup
// and ResumeGameServerGroup, respectively.
type GameServerGroup struct {
	_ struct{} `type:"structure"`

	// A generated unique ID for the Amazon EC2 Auto Scaling group that is associated
	// with this game server group.
	AutoScalingGroupArn *string `type:"string"`

	// Indicates how Amazon GameLift FleetIQ balances the use of Spot Instances
	// and On-Demand Instances in the game server group. Method options include
	// the following:
	//
	//    * SPOT_ONLY - Only Spot Instances are used in the game server group. If
	//    Spot Instances are unavailable or not viable for game hosting, the game
	//    server group provides no hosting capacity until Spot Instances can again
	//    be used. Until then, no new instances are started, and the existing nonviable
	//    Spot Instances are terminated (after current gameplay ends) and are not
	//    replaced.
	//
	//    * SPOT_PREFERRED - (default value) Spot Instances are used whenever available
	//    in the game server group. If Spot Instances are unavailable, the game
	//    server group continues to provide hosting capacity by falling back to
	//    On-Demand Instances. Existing nonviable Spot Instances are terminated
	//    (after current gameplay ends) and are replaced with new On-Demand Instances.
	//
	//    * ON_DEMAND_ONLY - Only On-Demand Instances are used in the game server
	//    group. No Spot Instances are used, even when available, while this balancing
	//    strategy is in force.
	BalancingStrategy *string `type:"string" enum:"BalancingStrategy"`

	// A time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time `type:"timestamp"`

	// A generated unique ID for the game server group.
	GameServerGroupArn *string `min:"1" type:"string"`

	// A developer-defined identifier for the game server group. The name is unique
	// for each Region in each Amazon Web Services account.
	GameServerGroupName *string `min:"1" type:"string"`

	// A flag that indicates whether instances in the game server group are protected
	// from early termination. Unprotected instances that have active game servers
	// running might be terminated during a scale-down event, causing players to
	// be dropped from the game. Protected instances cannot be terminated while
	// there are active game servers running except in the event of a forced game
	// server group deletion (see ). An exception to this is with Spot Instances,
	// which can be terminated by Amazon Web Services regardless of protection status.
	GameServerProtectionPolicy *string `type:"string" enum:"GameServerProtectionPolicy"`

	// The set of Amazon EC2 instance types that Amazon GameLift FleetIQ can use
	// when balancing and automatically scaling instances in the corresponding Auto
	// Scaling group.
	InstanceDefinitions []*InstanceDefinition `min:"2" type:"list"`

	// A timestamp that indicates when this game server group was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// for an IAM role that allows Amazon GameLift to access your Amazon EC2 Auto
	// Scaling groups.
	RoleArn *string `min:"1" type:"string"`

	// The current status of the game server group. Possible statuses include:
	//
	//    * NEW - Amazon GameLift FleetIQ has validated the CreateGameServerGroup()
	//    request.
	//
	//    * ACTIVATING - Amazon GameLift FleetIQ is setting up a game server group,
	//    which includes creating an Auto Scaling group in your Amazon Web Services
	//    account.
	//
	//    * ACTIVE - The game server group has been successfully created.
	//
	//    * DELETE_SCHEDULED - A request to delete the game server group has been
	//    received.
	//
	//    * DELETING - Amazon GameLift FleetIQ has received a valid DeleteGameServerGroup()
	//    request and is processing it. Amazon GameLift FleetIQ must first complete
	//    and release hosts before it deletes the Auto Scaling group and the game
	//    server group.
	//
	//    * DELETED - The game server group has been successfully deleted.
	//
	//    * ERROR - The asynchronous processes of activating or deleting a game
	//    server group has failed, resulting in an error state.
	Status *string `type:"string" enum:"GameServerGroupStatus"`

	// Additional information about the current game server group status. This information
	// might provide additional insight on groups that are in ERROR status.
	StatusReason *string `min:"1" type:"string"`

	// A list of activities that are currently suspended for this game server group.
	// If this property is empty, all activities are occurring.
	SuspendedActions []*string `min:"1" type:"list" enum:"GameServerGroupAction"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GameServerGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GameServerGroup) GoString() string {
	return s.String()
}

// SetAutoScalingGroupArn sets the AutoScalingGroupArn field's value.
func (s *GameServerGroup) SetAutoScalingGroupArn(v string) *GameServerGroup {
	s.AutoScalingGroupArn = &v
	return s
}

// SetBalancingStrategy sets the BalancingStrategy field's value.
func (s *GameServerGroup) SetBalancingStrategy(v string) *GameServerGroup {
	s.BalancingStrategy = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GameServerGroup) SetCreationTime(v time.Time) *GameServerGroup {
	s.CreationTime = &v
	return s
}

// SetGameServerGroupArn sets the GameServerGroupArn field's value.
func (s *GameServerGroup) SetGameServerGroupArn(v string) *GameServerGroup {
	s.GameServerGroupArn = &v
	return s
}

// SetGameServerGroupName sets the GameServerGroupName field's value.
func (s *GameServerGroup) SetGameServerGroupName(v string) *GameServerGroup {
	s.GameServerGroupName = &v
	return s
}

// SetGameServerProtectionPolicy sets the GameServerProtectionPolicy field's value.
func (s *GameServerGroup) SetGameServerProtectionPolicy(v string) *GameServerGroup {
	s.GameServerProtectionPolicy = &v
	return s
}

// SetInstanceDefinitions sets the InstanceDefinitions field's value.
func (s *GameServerGroup) SetInstanceDefinitions(v []*InstanceDefinition) *GameServerGroup {
	s.InstanceDefinitions = v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *GameServerGroup) SetLastUpdatedTime(v time.Time) *GameServerGroup {
	s.LastUpdatedTime = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GameServerGroup) SetRoleArn(v string) *GameServerGroup {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GameServerGroup) SetStatus(v string) *GameServerGroup {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *GameServerGroup) SetStatusReason(v string) *GameServerGroup {
	s.StatusReason = &v
	return s
}

// SetSuspendedActions sets the SuspendedActions field's value.
func (s *GameServerGroup) SetSuspendedActions(v []*string) *GameServerGroup {
	s.SuspendedActions = v
	return s
}

// This data type is used with the Amazon GameLift FleetIQ and game server groups.
//
// Configuration settings for intelligent automatic scaling that uses target
// tracking. These settings are used to add an Auto Scaling policy when creating
// the corresponding Auto Scaling group. After the Auto Scaling group is created,
// all updates to Auto Scaling policies, including changing this policy and
// adding or removing other policies, is done directly on the Auto Scaling group.
type GameServerGroupAutoScalingPolicy struct {
	_ struct{} `type:"structure"`

	// Length of time, in seconds, it takes for a new instance to start new game
	// server processes and register with Amazon GameLift FleetIQ. Specifying a
	// warm-up time can be useful, particularly with game servers that take a long
	// time to start up, because it avoids prematurely starting new instances.
	EstimatedInstanceWarmup *int64 `min:"1" type:"integer"`

	// Settings for a target-based scaling policy applied to Auto Scaling group.
	// These settings are used to create a target-based policy that tracks the Amazon
	// GameLift FleetIQ metric "PercentUtilizedGameServers" and specifies a target
	// value for the metric. As player usage changes, the policy triggers to adjust
	// the game server group capacity so that the metric returns to the target value.
	//
	// TargetTrackingConfiguration is a required field
	TargetTrackingConfiguration *TargetTrackingConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GameServerGroupAutoScalingPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GameServerGroupAutoScalingPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GameServerGroupAutoScalingPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GameServerGroupAutoScalingPolicy"}
	if s.EstimatedInstanceWarmup != nil && *s.EstimatedInstanceWarmup < 1 {
		invalidParams.Add(request.NewErrParamMinValue("EstimatedInstanceWarmup", 1))
	}
	if s.TargetTrackingConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetTrackingConfiguration"))
	}
	if s.TargetTrackingConfiguration != nil {
		if err := s.TargetTrackingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("TargetTrackingConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEstimatedInstanceWarmup sets the EstimatedInstanceWarmup field's value.
func (s *GameServerGroupAutoScalingPolicy) SetEstimatedInstanceWarmup(v int64) *GameServerGroupAutoScalingPolicy {
	s.EstimatedInstanceWarmup = &v
	return s
}

// SetTargetTrackingConfiguration sets the TargetTrackingConfiguration field's value.
func (s *GameServerGroupAutoScalingPolicy) SetTargetTrackingConfiguration(v *TargetTrackingConfiguration) *GameServerGroupAutoScalingPolicy {
	s.TargetTrackingConfiguration = v
	return s
}

// This data type is used with the Amazon GameLift FleetIQ and game server groups.
//
// Additional properties, including status, that describe an EC2 instance in
// a game server group. Instance configurations are set with game server group
// properties (see DescribeGameServerGroup and with the EC2 launch template
// that was used when creating the game server group.
//
// Retrieve game server instances for a game server group by calling DescribeGameServerInstances.
type GameServerInstance struct {
	_ struct{} `type:"structure"`

	// A generated unique identifier for the game server group that includes the
	// game server instance.
	GameServerGroupArn *string `min:"1" type:"string"`

	// A developer-defined identifier for the game server group that includes the
	// game server instance. The name is unique for each Region in each Amazon Web
	// Services account.
	GameServerGroupName *string `min:"1" type:"string"`

	// The unique identifier for the instance where the game server is running.
	// This ID is available in the instance metadata. EC2 instance IDs use a 17-character
	// format, for example: i-1234567890abcdef0.
	InstanceId *string `min:"19" type:"string"`

	// Current status of the game server instance
	InstanceStatus *string `type:"string" enum:"GameServerInstanceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GameServerInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GameServerInstance) GoString() string {
	return s.String()
}

// SetGameServerGroupArn sets the GameServerGroupArn field's value.
func (s *GameServerInstance) SetGameServerGroupArn(v string) *GameServerInstance {
	s.GameServerGroupArn = &v
	return s
}

// SetGameServerGroupName sets the GameServerGroupName field's value.
func (s *GameServerInstance) SetGameServerGroupName(v string) *GameServerInstance {
	s.GameServerGroupName = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *GameServerInstance) SetInstanceId(v string) *GameServerInstance {
	s.InstanceId = &v
	return s
}

// SetInstanceStatus sets the InstanceStatus field's value.
func (s *GameServerInstance) SetInstanceStatus(v string) *GameServerInstance {
	s.InstanceStatus = &v
	return s
}

// Properties describing a game session.
//
// A game session in ACTIVE status can host players. When a game session ends,
// its status is set to TERMINATED.
//
// Amazon GameLift retains a game session resource for 30 days after the game
// session ends. You can reuse idempotency token values after this time. Game
// session logs are retained for 14 days.
//
// All APIs by task (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
type GameSession struct {
	_ struct{} `type:"structure"`

	// A time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time `type:"timestamp"`

	// A unique identifier for a player. This ID is used to enforce a resource protection
	// policy (if one exists), that limits the number of game sessions a player
	// can create.
	CreatorId *string `min:"1" type:"string"`

	// Number of players currently in the game session.
	CurrentPlayerSessionCount *int64 `type:"integer"`

	// The DNS identifier assigned to the instance that is running the game session.
	// Values have the following format:
	//
	//    * TLS-enabled fleets: <unique identifier>.<region identifier>.amazongamelift.com.
	//
	//    * Non-TLS-enabled fleets: ec2-<unique identifier>.compute.amazonaws.com.
	//    (See Amazon EC2 Instance IP Addressing (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses).)
	//
	// When connecting to a game session that is running on a TLS-enabled fleet,
	// you must use the DNS name, not the IP address.
	DnsName *string `type:"string"`

	// The Amazon Resource Name (ARN (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// associated with the GameLift fleet that this game session is running on.
	FleetArn *string `type:"string"`

	// A unique identifier for the fleet that the game session is running on.
	FleetId *string `type:"string"`

	// A set of custom properties for a game session, formatted as key:value pairs.
	// These properties are passed to a game server process with a request to start
	// a new game session (see Start a Game Session (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	GameProperties []*GameProperty `type:"list"`

	// A set of custom game session properties, formatted as a single string value.
	// This data is passed to a game server process with a request to start a new
	// game session (see Start a Game Session (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	GameSessionData *string `min:"1" type:"string"`

	// A unique identifier for the game session. A game session ARN has the following
	// format: arn:aws:gamelift:<region>::gamesession/<fleet ID>/<custom ID string
	// or idempotency token>.
	GameSessionId *string `min:"1" type:"string"`

	// The IP address of the game session. To connect to a Amazon GameLift game
	// server, an app needs both the IP address and port number.
	//
	// IpAddress is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GameSession's
	// String and GoString methods.
	IpAddress *string `min:"1" type:"string" sensitive:"true"`

	// The fleet location where the game session is running. This value might specify
	// the fleet's home Region or a remote location. Location is expressed as an
	// Amazon Web Services Region code such as us-west-2.
	Location *string `min:"1" type:"string"`

	// Information about the matchmaking process that resulted in the game session,
	// if matchmaking was used. Data is in JSON syntax, formatted as a string. Information
	// includes the matchmaker ID as well as player attributes and team assignments.
	// For more details on matchmaker data, see Match Data (https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-server.html#match-server-data).
	// Matchmaker data is updated whenever new players are added during a successful
	// backfill (see StartMatchBackfill (https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartMatchBackfill.html)).
	MatchmakerData *string `min:"1" type:"string"`

	// The maximum number of players that can be connected simultaneously to the
	// game session.
	MaximumPlayerSessionCount *int64 `type:"integer"`

	// A descriptive label that is associated with a game session. Session names
	// do not need to be unique.
	Name *string `min:"1" type:"string"`

	// Indicates whether or not the game session is accepting new players.
	PlayerSessionCreationPolicy *string `type:"string" enum:"PlayerSessionCreationPolicy"`

	// The port number for the game session. To connect to a Amazon GameLift game
	// server, an app needs both the IP address and port number.
	//
	// Port is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GameSession's
	// String and GoString methods.
	Port *int64 `min:"1" type:"integer" sensitive:"true"`

	// Current status of the game session. A game session must have an ACTIVE status
	// to have player sessions.
	Status *string `type:"string" enum:"GameSessionStatus"`

	// Provides additional information about game session status. INTERRUPTED indicates
	// that the game session was hosted on a spot instance that was reclaimed, causing
	// the active game session to be terminated.
	StatusReason *string `type:"string" enum:"GameSessionStatusReason"`

	// A time stamp indicating when this data object was terminated. Format is a
	// number expressed in Unix time as milliseconds (for example "1469498468.057").
	TerminationTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GameSession) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GameSession) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *GameSession) SetCreationTime(v time.Time) *GameSession {
	s.CreationTime = &v
	return s
}

// SetCreatorId sets the CreatorId field's value.
func (s *GameSession) SetCreatorId(v string) *GameSession {
	s.CreatorId = &v
	return s
}

// SetCurrentPlayerSessionCount sets the CurrentPlayerSessionCount field's value.
func (s *GameSession) SetCurrentPlayerSessionCount(v int64) *GameSession {
	s.CurrentPlayerSessionCount = &v
	return s
}

// SetDnsName sets the DnsName field's value.
func (s *GameSession) SetDnsName(v string) *GameSession {
	s.DnsName = &v
	return s
}

// SetFleetArn sets the FleetArn field's value.
func (s *GameSession) SetFleetArn(v string) *GameSession {
	s.FleetArn = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *GameSession) SetFleetId(v string) *GameSession {
	s.FleetId = &v
	return s
}

// SetGameProperties sets the GameProperties field's value.
func (s *GameSession) SetGameProperties(v []*GameProperty) *GameSession {
	s.GameProperties = v
	return s
}

// SetGameSessionData sets the GameSessionData field's value.
func (s *GameSession) SetGameSessionData(v string) *GameSession {
	s.GameSessionData = &v
	return s
}

// SetGameSessionId sets the GameSessionId field's value.
func (s *GameSession) SetGameSessionId(v string) *GameSession {
	s.GameSessionId = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *GameSession) SetIpAddress(v string) *GameSession {
	s.IpAddress = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *GameSession) SetLocation(v string) *GameSession {
	s.Location = &v
	return s
}

// SetMatchmakerData sets the MatchmakerData field's value.
func (s *GameSession) SetMatchmakerData(v string) *GameSession {
	s.MatchmakerData = &v
	return s
}

// SetMaximumPlayerSessionCount sets the MaximumPlayerSessionCount field's value.
func (s *GameSession) SetMaximumPlayerSessionCount(v int64) *GameSession {
	s.MaximumPlayerSessionCount = &v
	return s
}

// SetName sets the Name field's value.
func (s *GameSession) SetName(v string) *GameSession {
	s.Name = &v
	return s
}

// SetPlayerSessionCreationPolicy sets the PlayerSessionCreationPolicy field's value.
func (s *GameSession) SetPlayerSessionCreationPolicy(v string) *GameSession {
	s.PlayerSessionCreationPolicy = &v
	return s
}

// SetPort sets the Port field's value.
func (s *GameSession) SetPort(v int64) *GameSession {
	s.Port = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GameSession) SetStatus(v string) *GameSession {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *GameSession) SetStatusReason(v string) *GameSession {
	s.StatusReason = &v
	return s
}

// SetTerminationTime sets the TerminationTime field's value.
func (s *GameSession) SetTerminationTime(v time.Time) *GameSession {
	s.TerminationTime = &v
	return s
}

// Connection information for a new game session that is created in response
// to a start matchmaking request. Once a match is made, the FlexMatch engine
// creates a new game session for it. This information, including the game session
// endpoint and player sessions for each player in the original matchmaking
// request, is added to the matchmaking ticket.
type GameSessionConnectionInfo struct {
	_ struct{} `type:"structure"`

	// The DNS identifier assigned to the instance that is running the game session.
	// Values have the following format:
	//
	//    * TLS-enabled fleets: <unique identifier>.<region identifier>.amazongamelift.com.
	//
	//    * Non-TLS-enabled fleets: ec2-<unique identifier>.compute.amazonaws.com.
	//    (See Amazon EC2 Instance IP Addressing (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses).)
	//
	// When connecting to a game session that is running on a TLS-enabled fleet,
	// you must use the DNS name, not the IP address.
	DnsName *string `type:"string"`

	// A unique identifier for the game session. Use the game session ID.
	GameSessionArn *string `min:"1" type:"string"`

	// The IP address of the game session. To connect to a Amazon GameLift game
	// server, an app needs both the IP address and port number.
	//
	// IpAddress is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GameSessionConnectionInfo's
	// String and GoString methods.
	IpAddress *string `min:"1" type:"string" sensitive:"true"`

	// A collection of player session IDs, one for each player ID that was included
	// in the original matchmaking request.
	MatchedPlayerSessions []*MatchedPlayerSession `type:"list"`

	// The port number for the game session. To connect to a Amazon GameLift game
	// server, an app needs both the IP address and port number.
	Port *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GameSessionConnectionInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GameSessionConnectionInfo) GoString() string {
	return s.String()
}

// SetDnsName sets the DnsName field's value.
func (s *GameSessionConnectionInfo) SetDnsName(v string) *GameSessionConnectionInfo {
	s.DnsName = &v
	return s
}

// SetGameSessionArn sets the GameSessionArn field's value.
func (s *GameSessionConnectionInfo) SetGameSessionArn(v string) *GameSessionConnectionInfo {
	s.GameSessionArn = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *GameSessionConnectionInfo) SetIpAddress(v string) *GameSessionConnectionInfo {
	s.IpAddress = &v
	return s
}

// SetMatchedPlayerSessions sets the MatchedPlayerSessions field's value.
func (s *GameSessionConnectionInfo) SetMatchedPlayerSessions(v []*MatchedPlayerSession) *GameSessionConnectionInfo {
	s.MatchedPlayerSessions = v
	return s
}

// SetPort sets the Port field's value.
func (s *GameSessionConnectionInfo) SetPort(v int64) *GameSessionConnectionInfo {
	s.Port = &v
	return s
}

// A game session's properties plus the protection policy currently in force.
type GameSessionDetail struct {
	_ struct{} `type:"structure"`

	// Object that describes a game session.
	GameSession *GameSession `type:"structure"`

	// Current status of protection for the game session.
	//
	//    * NoProtection -- The game session can be terminated during a scale-down
	//    event.
	//
	//    * FullProtection -- If the game session is in an ACTIVE status, it cannot
	//    be terminated during a scale-down event.
	ProtectionPolicy *string `type:"string" enum:"ProtectionPolicy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GameSessionDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GameSessionDetail) GoString() string {
	return s.String()
}

// SetGameSession sets the GameSession field's value.
func (s *GameSessionDetail) SetGameSession(v *GameSession) *GameSessionDetail {
	s.GameSession = v
	return s
}

// SetProtectionPolicy sets the ProtectionPolicy field's value.
func (s *GameSessionDetail) SetProtectionPolicy(v string) *GameSessionDetail {
	s.ProtectionPolicy = &v
	return s
}

// The game instance is currently full and cannot allow the requested player(s)
// to join. Clients can retry such requests immediately or after a waiting period.
type GameSessionFullException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GameSessionFullException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GameSessionFullException) GoString() string {
	return s.String()
}

func newErrorGameSessionFullException(v protocol.ResponseMetadata) error {
	return &GameSessionFullException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *GameSessionFullException) Code() string {
	return "GameSessionFullException"
}

// Message returns the exception's message.
func (s *GameSessionFullException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *GameSessionFullException) OrigErr() error {
	return nil
}

func (s *GameSessionFullException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *GameSessionFullException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *GameSessionFullException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents a potential game session placement, including the full details
// of the original placement request and the current status.
//
// If the game session placement status is PENDING, the properties for game
// session ID/ARN, region, IP address/DNS, and port aren't final. A game session
// is not active and ready to accept players until placement status reaches
// FULFILLED. When the placement is in PENDING status, Amazon GameLift may attempt
// to place a game session multiple times before succeeding. With each attempt
// it creates a GameSession object and updates this placement object with the
// new game session properties..
type GameSessionPlacement struct {
	_ struct{} `type:"structure"`

	// The DNS identifier assigned to the instance that is running the game session.
	// Values have the following format:
	//
	//    * TLS-enabled fleets: <unique identifier>.<region identifier>.amazongamelift.com.
	//
	//    * Non-TLS-enabled fleets: ec2-<unique identifier>.compute.amazonaws.com.
	//    (See Amazon EC2 Instance IP Addressing (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses).)
	//
	// When connecting to a game session that is running on a TLS-enabled fleet,
	// you must use the DNS name, not the IP address.
	DnsName *string `type:"string"`

	// Time stamp indicating when this request was completed, canceled, or timed
	// out.
	EndTime *time.Time `type:"timestamp"`

	// A set of custom properties for a game session, formatted as key:value pairs.
	// These properties are passed to a game server process with a request to start
	// a new game session (see Start a Game Session (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	GameProperties []*GameProperty `type:"list"`

	// Identifier for the game session created by this placement request. This identifier
	// is unique across all Regions. This value isn't final until placement status
	// is FULFILLED.
	GameSessionArn *string `min:"1" type:"string"`

	// A set of custom game session properties, formatted as a single string value.
	// This data is passed to a game server process in the GameSession object with
	// a request to start a new game session (see Start a Game Session (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	GameSessionData *string `min:"1" type:"string"`

	// A unique identifier for the game session. This value isn't final until placement
	// status is FULFILLED.
	GameSessionId *string `min:"1" type:"string"`

	// A descriptive label that is associated with a game session. Session names
	// do not need to be unique.
	GameSessionName *string `min:"1" type:"string"`

	// A descriptive label that is associated with game session queue. Queue names
	// must be unique within each Region.
	GameSessionQueueName *string `min:"1" type:"string"`

	// Name of the Region where the game session created by this placement request
	// is running. This value isn't final until placement status is FULFILLED.
	GameSessionRegion *string `min:"1" type:"string"`

	// The IP address of the game session. To connect to a Amazon GameLift game
	// server, an app needs both the IP address and port number. This value isn't
	// final until placement status is FULFILLED.
	//
	// IpAddress is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GameSessionPlacement's
	// String and GoString methods.
	IpAddress *string `min:"1" type:"string" sensitive:"true"`

	// Information on the matchmaking process for this game. Data is in JSON syntax,
	// formatted as a string. It identifies the matchmaking configuration used to
	// create the match, and contains data on all players assigned to the match,
	// including player attributes and team assignments. For more details on matchmaker
	// data, see Match Data (https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-server.html#match-server-data).
	MatchmakerData *string `min:"1" type:"string"`

	// The maximum number of players that can be connected simultaneously to the
	// game session.
	MaximumPlayerSessionCount *int64 `type:"integer"`

	// A collection of information on player sessions created in response to the
	// game session placement request. These player sessions are created only after
	// a new game session is successfully placed (placement status is FULFILLED).
	// This information includes the player ID, provided in the placement request,
	// and a corresponding player session ID.
	PlacedPlayerSessions []*PlacedPlayerSession `type:"list"`

	// A unique identifier for a game session placement.
	PlacementId *string `min:"1" type:"string"`

	// A set of values, expressed in milliseconds, that indicates the amount of
	// latency that a player experiences when connected to Amazon Web Services Regions.
	PlayerLatencies []*PlayerLatency `type:"list"`

	// The port number for the game session. To connect to a Amazon GameLift game
	// server, an app needs both the IP address and port number. This value isn't
	// final until placement status is FULFILLED.
	//
	// Port is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GameSessionPlacement's
	// String and GoString methods.
	Port *int64 `min:"1" type:"integer" sensitive:"true"`

	// Time stamp indicating when this request was placed in the queue. Format is
	// a number expressed in Unix time as milliseconds (for example "1469498468.057").
	StartTime *time.Time `type:"timestamp"`

	// Current status of the game session placement request.
	//
	//    * PENDING -- The placement request is in the queue waiting to be processed.
	//    Game session properties are not yet final.
	//
	//    * FULFILLED -- A new game session has been successfully placed. Game session
	//    properties are now final.
	//
	//    * CANCELLED -- The placement request was canceled.
	//
	//    * TIMED_OUT -- A new game session was not successfully created before
	//    the time limit expired. You can resubmit the placement request as needed.
	//
	//    * FAILED -- Amazon GameLift is not able to complete the process of placing
	//    the game session. Common reasons are the game session terminated before
	//    the placement process was completed, or an unexpected internal error.
	Status *string `type:"string" enum:"GameSessionPlacementState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GameSessionPlacement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GameSessionPlacement) GoString() string {
	return s.String()
}

// SetDnsName sets the DnsName field's value.
func (s *GameSessionPlacement) SetDnsName(v string) *GameSessionPlacement {
	s.DnsName = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *GameSessionPlacement) SetEndTime(v time.Time) *GameSessionPlacement {
	s.EndTime = &v
	return s
}

// SetGameProperties sets the GameProperties field's value.
func (s *GameSessionPlacement) SetGameProperties(v []*GameProperty) *GameSessionPlacement {
	s.GameProperties = v
	return s
}

// SetGameSessionArn sets the GameSessionArn field's value.
func (s *GameSessionPlacement) SetGameSessionArn(v string) *GameSessionPlacement {
	s.GameSessionArn = &v
	return s
}

// SetGameSessionData sets the GameSessionData field's value.
func (s *GameSessionPlacement) SetGameSessionData(v string) *GameSessionPlacement {
	s.GameSessionData = &v
	return s
}

// SetGameSessionId sets the GameSessionId field's value.
func (s *GameSessionPlacement) SetGameSessionId(v string) *GameSessionPlacement {
	s.GameSessionId = &v
	return s
}

// SetGameSessionName sets the GameSessionName field's value.
func (s *GameSessionPlacement) SetGameSessionName(v string) *GameSessionPlacement {
	s.GameSessionName = &v
	return s
}

// SetGameSessionQueueName sets the GameSessionQueueName field's value.
func (s *GameSessionPlacement) SetGameSessionQueueName(v string) *GameSessionPlacement {
	s.GameSessionQueueName = &v
	return s
}

// SetGameSessionRegion sets the GameSessionRegion field's value.
func (s *GameSessionPlacement) SetGameSessionRegion(v string) *GameSessionPlacement {
	s.GameSessionRegion = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *GameSessionPlacement) SetIpAddress(v string) *GameSessionPlacement {
	s.IpAddress = &v
	return s
}

// SetMatchmakerData sets the MatchmakerData field's value.
func (s *GameSessionPlacement) SetMatchmakerData(v string) *GameSessionPlacement {
	s.MatchmakerData = &v
	return s
}

// SetMaximumPlayerSessionCount sets the MaximumPlayerSessionCount field's value.
func (s *GameSessionPlacement) SetMaximumPlayerSessionCount(v int64) *GameSessionPlacement {
	s.MaximumPlayerSessionCount = &v
	return s
}

// SetPlacedPlayerSessions sets the PlacedPlayerSessions field's value.
func (s *GameSessionPlacement) SetPlacedPlayerSessions(v []*PlacedPlayerSession) *GameSessionPlacement {
	s.PlacedPlayerSessions = v
	return s
}

// SetPlacementId sets the PlacementId field's value.
func (s *GameSessionPlacement) SetPlacementId(v string) *GameSessionPlacement {
	s.PlacementId = &v
	return s
}

// SetPlayerLatencies sets the PlayerLatencies field's value.
func (s *GameSessionPlacement) SetPlayerLatencies(v []*PlayerLatency) *GameSessionPlacement {
	s.PlayerLatencies = v
	return s
}

// SetPort sets the Port field's value.
func (s *GameSessionPlacement) SetPort(v int64) *GameSessionPlacement {
	s.Port = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GameSessionPlacement) SetStartTime(v time.Time) *GameSessionPlacement {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GameSessionPlacement) SetStatus(v string) *GameSessionPlacement {
	s.Status = &v
	return s
}

// Configuration for a game session placement mechanism that processes requests
// for new game sessions. A queue can be used on its own or as part of a matchmaking
// solution.
type GameSessionQueue struct {
	_ struct{} `type:"structure"`

	// Information that is added to all events that are related to this game session
	// queue.
	CustomEventData *string `type:"string"`

	// A list of fleets and/or fleet aliases that can be used to fulfill game session
	// placement requests in the queue. Destinations are identified by either a
	// fleet ARN or a fleet alias ARN, and are listed in order of placement preference.
	Destinations []*GameSessionQueueDestination `type:"list"`

	// A list of locations where a queue is allowed to place new game sessions.
	// Locations are specified in the form of Amazon Web Services Region codes,
	// such as us-west-2. If this parameter is not set, game sessions can be placed
	// in any queue location.
	FilterConfiguration *FilterConfiguration `type:"structure"`

	// The Amazon Resource Name (ARN (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// that is assigned to a Amazon GameLift game session queue resource and uniquely
	// identifies it. ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::gamesessionqueue/<queue
	// name>. In a Amazon GameLift game session queue ARN, the resource ID matches
	// the Name value.
	GameSessionQueueArn *string `min:"1" type:"string"`

	// A descriptive label that is associated with game session queue. Queue names
	// must be unique within each Region.
	Name *string `min:"1" type:"string"`

	// An SNS topic ARN that is set up to receive game session placement notifications.
	// See Setting up notifications for game session placement (https://docs.aws.amazon.com/gamelift/latest/developerguide/queue-notification.html).
	NotificationTarget *string `type:"string"`

	// A set of policies that act as a sliding cap on player latency. FleetIQ works
	// to deliver low latency for most players in a game session. These policies
	// ensure that no individual player can be placed into a game with unreasonably
	// high latency. Use multiple policies to gradually relax latency requirements
	// a step at a time. Multiple policies are applied based on their maximum allowed
	// latency, starting with the lowest value.
	PlayerLatencyPolicies []*PlayerLatencyPolicy `type:"list"`

	// Custom settings to use when prioritizing destinations and locations for game
	// session placements. This configuration replaces the FleetIQ default prioritization
	// process. Priority types that are not explicitly named will be automatically
	// applied at the end of the prioritization process.
	PriorityConfiguration *PriorityConfiguration `type:"structure"`

	// The maximum time, in seconds, that a new game session placement request remains
	// in the queue. When a request exceeds this time, the game session placement
	// changes to a TIMED_OUT status. By default, this property is set to 600.
	TimeoutInSeconds *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GameSessionQueue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GameSessionQueue) GoString() string {
	return s.String()
}

// SetCustomEventData sets the CustomEventData field's value.
func (s *GameSessionQueue) SetCustomEventData(v string) *GameSessionQueue {
	s.CustomEventData = &v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *GameSessionQueue) SetDestinations(v []*GameSessionQueueDestination) *GameSessionQueue {
	s.Destinations = v
	return s
}

// SetFilterConfiguration sets the FilterConfiguration field's value.
func (s *GameSessionQueue) SetFilterConfiguration(v *FilterConfiguration) *GameSessionQueue {
	s.FilterConfiguration = v
	return s
}

// SetGameSessionQueueArn sets the GameSessionQueueArn field's value.
func (s *GameSessionQueue) SetGameSessionQueueArn(v string) *GameSessionQueue {
	s.GameSessionQueueArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *GameSessionQueue) SetName(v string) *GameSessionQueue {
	s.Name = &v
	return s
}

// SetNotificationTarget sets the NotificationTarget field's value.
func (s *GameSessionQueue) SetNotificationTarget(v string) *GameSessionQueue {
	s.NotificationTarget = &v
	return s
}

// SetPlayerLatencyPolicies sets the PlayerLatencyPolicies field's value.
func (s *GameSessionQueue) SetPlayerLatencyPolicies(v []*PlayerLatencyPolicy) *GameSessionQueue {
	s.PlayerLatencyPolicies = v
	return s
}

// SetPriorityConfiguration sets the PriorityConfiguration field's value.
func (s *GameSessionQueue) SetPriorityConfiguration(v *PriorityConfiguration) *GameSessionQueue {
	s.PriorityConfiguration = v
	return s
}

// SetTimeoutInSeconds sets the TimeoutInSeconds field's value.
func (s *GameSessionQueue) SetTimeoutInSeconds(v int64) *GameSessionQueue {
	s.TimeoutInSeconds = &v
	return s
}

// A fleet or alias designated in a game session queue. Queues fulfill requests
// for new game sessions by placing a new game session on any of the queue's
// destinations.
type GameSessionQueueDestination struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that is assigned to fleet or fleet alias.
	// ARNs, which include a fleet ID or alias ID and a Region name, provide a unique
	// identifier across all Regions.
	DestinationArn *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GameSessionQueueDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GameSessionQueueDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GameSessionQueueDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GameSessionQueueDestination"}
	if s.DestinationArn != nil && len(*s.DestinationArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DestinationArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationArn sets the DestinationArn field's value.
func (s *GameSessionQueueDestination) SetDestinationArn(v string) *GameSessionQueueDestination {
	s.DestinationArn = &v
	return s
}

type GetComputeAccessInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the compute resource that you want to connect to.
	// You can use either a registered compute name or an instance ID.
	//
	// ComputeName is a required field
	ComputeName *string `type:"string" required:"true"`

	// A unique identifier for the fleet that contains the compute resource you
	// want to connect to. You can use either the fleet ID or ARN value.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComputeAccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComputeAccessInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetComputeAccessInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetComputeAccessInput"}
	if s.ComputeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ComputeName"))
	}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputeName sets the ComputeName field's value.
func (s *GetComputeAccessInput) SetComputeName(v string) *GetComputeAccessInput {
	s.ComputeName = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *GetComputeAccessInput) SetFleetId(v string) *GetComputeAccessInput {
	s.FleetId = &v
	return s
}

type GetComputeAccessOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// that is assigned to an Amazon GameLift compute resource and uniquely identifies
	// it. ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::compute/compute-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912.
	ComputeArn *string `type:"string"`

	// The identifier of the compute resource to be accessed. This value might be
	// either a compute name or an instance ID.
	ComputeName *string `type:"string"`

	// A set of temporary Amazon Web Services credentials for use when connecting
	// to the compute resource with Amazon EC2 Systems Manager (SSM).
	//
	// Credentials is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetComputeAccessOutput's
	// String and GoString methods.
	Credentials *AwsCredentials `type:"structure" sensitive:"true"`

	// The Amazon Resource Name (ARN (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// that is assigned to a Amazon GameLift fleet resource and uniquely identifies
	// it. ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912.
	FleetArn *string `type:"string"`

	// The ID of the fleet that contains the compute resource to be accessed.
	FleetId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComputeAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComputeAccessOutput) GoString() string {
	return s.String()
}

// SetComputeArn sets the ComputeArn field's value.
func (s *GetComputeAccessOutput) SetComputeArn(v string) *GetComputeAccessOutput {
	s.ComputeArn = &v
	return s
}

// SetComputeName sets the ComputeName field's value.
func (s *GetComputeAccessOutput) SetComputeName(v string) *GetComputeAccessOutput {
	s.ComputeName = &v
	return s
}

// SetCredentials sets the Credentials field's value.
func (s *GetComputeAccessOutput) SetCredentials(v *AwsCredentials) *GetComputeAccessOutput {
	s.Credentials = v
	return s
}

// SetFleetArn sets the FleetArn field's value.
func (s *GetComputeAccessOutput) SetFleetArn(v string) *GetComputeAccessOutput {
	s.FleetArn = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *GetComputeAccessOutput) SetFleetId(v string) *GetComputeAccessOutput {
	s.FleetId = &v
	return s
}

type GetComputeAuthTokenInput struct {
	_ struct{} `type:"structure"`

	// The name of the compute resource you are requesting the authentication token
	// for.
	//
	// ComputeName is a required field
	ComputeName *string `type:"string" required:"true"`

	// A unique identifier for the fleet that the compute is registered to.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComputeAuthTokenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComputeAuthTokenInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetComputeAuthTokenInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetComputeAuthTokenInput"}
	if s.ComputeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ComputeName"))
	}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputeName sets the ComputeName field's value.
func (s *GetComputeAuthTokenInput) SetComputeName(v string) *GetComputeAuthTokenInput {
	s.ComputeName = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *GetComputeAuthTokenInput) SetFleetId(v string) *GetComputeAuthTokenInput {
	s.FleetId = &v
	return s
}

type GetComputeAuthTokenOutput struct {
	_ struct{} `type:"structure"`

	// A valid temporary authentication token.
	AuthToken *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// that is assigned to an Amazon GameLift compute resource and uniquely identifies
	// it. ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::compute/compute-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912.
	ComputeArn *string `type:"string"`

	// The name of the compute resource that the authentication token is issued
	// to.
	ComputeName *string `type:"string"`

	// The amount of time until the authentication token is no longer valid.
	ExpirationTimestamp *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// that is assigned to a Amazon GameLift fleet resource and uniquely identifies
	// it. ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912.
	FleetArn *string `type:"string"`

	// A unique identifier for the fleet that the compute is registered to.
	FleetId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComputeAuthTokenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComputeAuthTokenOutput) GoString() string {
	return s.String()
}

// SetAuthToken sets the AuthToken field's value.
func (s *GetComputeAuthTokenOutput) SetAuthToken(v string) *GetComputeAuthTokenOutput {
	s.AuthToken = &v
	return s
}

// SetComputeArn sets the ComputeArn field's value.
func (s *GetComputeAuthTokenOutput) SetComputeArn(v string) *GetComputeAuthTokenOutput {
	s.ComputeArn = &v
	return s
}

// SetComputeName sets the ComputeName field's value.
func (s *GetComputeAuthTokenOutput) SetComputeName(v string) *GetComputeAuthTokenOutput {
	s.ComputeName = &v
	return s
}

// SetExpirationTimestamp sets the ExpirationTimestamp field's value.
func (s *GetComputeAuthTokenOutput) SetExpirationTimestamp(v time.Time) *GetComputeAuthTokenOutput {
	s.ExpirationTimestamp = &v
	return s
}

// SetFleetArn sets the FleetArn field's value.
func (s *GetComputeAuthTokenOutput) SetFleetArn(v string) *GetComputeAuthTokenOutput {
	s.FleetArn = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *GetComputeAuthTokenOutput) SetFleetId(v string) *GetComputeAuthTokenOutput {
	s.FleetId = &v
	return s
}

type GetGameSessionLogUrlInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the game session to get logs for.
	//
	// GameSessionId is a required field
	GameSessionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGameSessionLogUrlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGameSessionLogUrlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGameSessionLogUrlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGameSessionLogUrlInput"}
	if s.GameSessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("GameSessionId"))
	}
	if s.GameSessionId != nil && len(*s.GameSessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GameSessionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGameSessionId sets the GameSessionId field's value.
func (s *GetGameSessionLogUrlInput) SetGameSessionId(v string) *GetGameSessionLogUrlInput {
	s.GameSessionId = &v
	return s
}

type GetGameSessionLogUrlOutput struct {
	_ struct{} `type:"structure"`

	// Location of the requested game session logs, available for download. This
	// URL is valid for 15 minutes, after which S3 will reject any download request
	// using this URL. You can request a new URL any time within the 14-day period
	// that the logs are retained.
	PreSignedUrl *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGameSessionLogUrlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGameSessionLogUrlOutput) GoString() string {
	return s.String()
}

// SetPreSignedUrl sets the PreSignedUrl field's value.
func (s *GetGameSessionLogUrlOutput) SetPreSignedUrl(v string) *GetGameSessionLogUrlOutput {
	s.PreSignedUrl = &v
	return s
}

type GetInstanceAccessInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the fleet that contains the instance you want to
	// access. You can request access to instances in EC2 fleets with the following
	// statuses: ACTIVATING, ACTIVE, or ERROR. Use either a fleet ID or an ARN value.
	//
	// You can access fleets in ERROR status for a short period of time before Amazon
	// GameLift deletes them.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// A unique identifier for the instance you want to access. You can access an
	// instance in any status.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInstanceAccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInstanceAccessInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInstanceAccessInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInstanceAccessInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *GetInstanceAccessInput) SetFleetId(v string) *GetInstanceAccessInput {
	s.FleetId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *GetInstanceAccessInput) SetInstanceId(v string) *GetInstanceAccessInput {
	s.InstanceId = &v
	return s
}

type GetInstanceAccessOutput struct {
	_ struct{} `type:"structure"`

	// The connection information for a fleet instance, including IP address and
	// access credentials.
	InstanceAccess *InstanceAccess `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInstanceAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInstanceAccessOutput) GoString() string {
	return s.String()
}

// SetInstanceAccess sets the InstanceAccess field's value.
func (s *GetInstanceAccessOutput) SetInstanceAccess(v *InstanceAccess) *GetInstanceAccessOutput {
	s.InstanceAccess = v
	return s
}

// A game session with this custom ID string already exists in this fleet. Resolve
// this conflict before retrying this request.
type IdempotentParameterMismatchException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdempotentParameterMismatchException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdempotentParameterMismatchException) GoString() string {
	return s.String()
}

func newErrorIdempotentParameterMismatchException(v protocol.ResponseMetadata) error {
	return &IdempotentParameterMismatchException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *IdempotentParameterMismatchException) Code() string {
	return "IdempotentParameterMismatchException"
}

// Message returns the exception's message.
func (s *IdempotentParameterMismatchException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *IdempotentParameterMismatchException) OrigErr() error {
	return nil
}

func (s *IdempotentParameterMismatchException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *IdempotentParameterMismatchException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *IdempotentParameterMismatchException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents a virtual computing instance that runs game server processes and
// hosts game sessions. In Amazon GameLift, one or more instances make up a
// managed EC2 fleet.
type Instance struct {
	_ struct{} `type:"structure"`

	// A time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time `type:"timestamp"`

	// The DNS identifier assigned to the instance that is running the game session.
	// Values have the following format:
	//
	//    * TLS-enabled fleets: <unique identifier>.<region identifier>.amazongamelift.com.
	//
	//    * Non-TLS-enabled fleets: ec2-<unique identifier>.compute.amazonaws.com.
	//    (See Amazon Elastic Compute Cloud Instance IP Addressing (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses).)
	//
	// When connecting to a game session that is running on a TLS-enabled fleet,
	// you must use the DNS name, not the IP address.
	DnsName *string `type:"string"`

	// The Amazon Resource Name (ARN (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// that is assigned to a Amazon GameLift fleet resource and uniquely identifies
	// it. ARNs are unique across all Regions. Format is arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912.
	FleetArn *string `type:"string"`

	// A unique identifier for the fleet that the instance belongs to.
	FleetId *string `type:"string"`

	// A unique identifier for the instance.
	InstanceId *string `type:"string"`

	// IP address that is assigned to the instance.
	//
	// IpAddress is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Instance's
	// String and GoString methods.
	IpAddress *string `min:"1" type:"string" sensitive:"true"`

	// The fleet location of the instance, expressed as an Amazon Web Services Region
	// code, such as us-west-2.
	Location *string `min:"1" type:"string"`

	// Operating system that is running on this EC2 instance.
	OperatingSystem *string `type:"string" enum:"OperatingSystem"`

	// Current status of the instance. Possible statuses include the following:
	//
	//    * PENDING -- The instance is in the process of being created and launching
	//    server processes as defined in the fleet's run-time configuration.
	//
	//    * ACTIVE -- The instance has been successfully created and at least one
	//    server process has successfully launched and reported back to Amazon GameLift
	//    that it is ready to host a game session. The instance is now considered
	//    ready to host game sessions.
	//
	//    * TERMINATING -- The instance is in the process of shutting down. This
	//    may happen to reduce capacity during a scaling down event or to recycle
	//    resources in the event of a problem.
	Status *string `type:"string" enum:"InstanceStatus"`

	// EC2 instance type that defines the computing resources of this instance.
	Type *string `type:"string" enum:"EC2InstanceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Instance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Instance) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *Instance) SetCreationTime(v time.Time) *Instance {
	s.CreationTime = &v
	return s
}

// SetDnsName sets the DnsName field's value.
func (s *Instance) SetDnsName(v string) *Instance {
	s.DnsName = &v
	return s
}

// SetFleetArn sets the FleetArn field's value.
func (s *Instance) SetFleetArn(v string) *Instance {
	s.FleetArn = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *Instance) SetFleetId(v string) *Instance {
	s.FleetId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *Instance) SetInstanceId(v string) *Instance {
	s.InstanceId = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *Instance) SetIpAddress(v string) *Instance {
	s.IpAddress = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *Instance) SetLocation(v string) *Instance {
	s.Location = &v
	return s
}

// SetOperatingSystem sets the OperatingSystem field's value.
func (s *Instance) SetOperatingSystem(v string) *Instance {
	s.OperatingSystem = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Instance) SetStatus(v string) *Instance {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *Instance) SetType(v string) *Instance {
	s.Type = &v
	return s
}

// Information and credentials that you can use to remotely connect to an instance
// in an EC2 managed fleet. This data type is returned in response to a call
// to GetInstanceAccess.
type InstanceAccess struct {
	_ struct{} `type:"structure"`

	// Security credentials that are required to access the instance.
	//
	// Credentials is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by InstanceAccess's
	// String and GoString methods.
	Credentials *InstanceCredentials `type:"structure" sensitive:"true"`

	// A unique identifier for the fleet containing the instance to be accessed.
	FleetId *string `type:"string"`

	// A unique identifier for the instance to be accessed.
	InstanceId *string `type:"string"`

	// IP address assigned to the instance.
	//
	// IpAddress is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by InstanceAccess's
	// String and GoString methods.
	IpAddress *string `min:"1" type:"string" sensitive:"true"`

	// Operating system that is running on the instance.
	OperatingSystem *string `type:"string" enum:"OperatingSystem"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceAccess) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceAccess) GoString() string {
	return s.String()
}

// SetCredentials sets the Credentials field's value.
func (s *InstanceAccess) SetCredentials(v *InstanceCredentials) *InstanceAccess {
	s.Credentials = v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *InstanceAccess) SetFleetId(v string) *InstanceAccess {
	s.FleetId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *InstanceAccess) SetInstanceId(v string) *InstanceAccess {
	s.InstanceId = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *InstanceAccess) SetIpAddress(v string) *InstanceAccess {
	s.IpAddress = &v
	return s
}

// SetOperatingSystem sets the OperatingSystem field's value.
func (s *InstanceAccess) SetOperatingSystem(v string) *InstanceAccess {
	s.OperatingSystem = &v
	return s
}

// A set of credentials that allow remote access to an instance in an EC2 managed
// fleet. These credentials are returned in response to a call to GetInstanceAccess,
// which requests access for instances that are running game servers with the
// Amazon GameLift server SDK version 4.x or earlier.
type InstanceCredentials struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Secret string. For Windows instances, the secret is a password for use with
	// Windows Remote Desktop. For Linux instances, it's a private key for use with
	// SSH.
	Secret *string `min:"1" type:"string"`

	// A user name for logging in.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceCredentials) GoString() string {
	return s.String()
}

// SetSecret sets the Secret field's value.
func (s *InstanceCredentials) SetSecret(v string) *InstanceCredentials {
	s.Secret = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *InstanceCredentials) SetUserName(v string) *InstanceCredentials {
	s.UserName = &v
	return s
}

// This data type is used with the Amazon GameLift FleetIQ and game server groups.
//
// An allowed instance type for a game server group. All game server groups
// must have at least two instance types defined for it. Amazon GameLift FleetIQ
// periodically evaluates each defined instance type for viability. It then
// updates the Auto Scaling group with the list of viable instance types.
type InstanceDefinition struct {
	_ struct{} `type:"structure"`

	// An Amazon EC2 instance type designation.
	//
	// InstanceType is a required field
	InstanceType *string `type:"string" required:"true" enum:"GameServerGroupInstanceType"`

	// Instance weighting that indicates how much this instance type contributes
	// to the total capacity of a game server group. Instance weights are used by
	// Amazon GameLift FleetIQ to calculate the instance type's cost per unit hour
	// and better identify the most cost-effective options. For detailed information
	// on weighting instance capacity, see Instance Weighting (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html)
	// in the Amazon Elastic Compute Cloud Auto Scaling User Guide. Default value
	// is "1".
	WeightedCapacity *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstanceDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InstanceDefinition"}
	if s.InstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceType"))
	}
	if s.WeightedCapacity != nil && len(*s.WeightedCapacity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WeightedCapacity", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceType sets the InstanceType field's value.
func (s *InstanceDefinition) SetInstanceType(v string) *InstanceDefinition {
	s.InstanceType = &v
	return s
}

// SetWeightedCapacity sets the WeightedCapacity field's value.
func (s *InstanceDefinition) SetWeightedCapacity(v string) *InstanceDefinition {
	s.WeightedCapacity = &v
	return s
}

// The service encountered an unrecoverable internal failure while processing
// the request. Clients can retry such requests immediately or after a waiting
// period.
type InternalServiceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceException) GoString() string {
	return s.String()
}

func newErrorInternalServiceException(v protocol.ResponseMetadata) error {
	return &InternalServiceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServiceException) Code() string {
	return "InternalServiceException"
}

// Message returns the exception's message.
func (s *InternalServiceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServiceException) OrigErr() error {
	return nil
}

func (s *InternalServiceException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServiceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServiceException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The requested operation would cause a conflict with the current state of
// a resource associated with the request and/or the fleet. Resolve the conflict
// before retrying.
type InvalidFleetStatusException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidFleetStatusException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidFleetStatusException) GoString() string {
	return s.String()
}

func newErrorInvalidFleetStatusException(v protocol.ResponseMetadata) error {
	return &InvalidFleetStatusException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidFleetStatusException) Code() string {
	return "InvalidFleetStatusException"
}

// Message returns the exception's message.
func (s *InvalidFleetStatusException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidFleetStatusException) OrigErr() error {
	return nil
}

func (s *InvalidFleetStatusException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidFleetStatusException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidFleetStatusException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The requested operation would cause a conflict with the current state of
// a resource associated with the request and/or the game instance. Resolve
// the conflict before retrying.
type InvalidGameSessionStatusException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidGameSessionStatusException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidGameSessionStatusException) GoString() string {
	return s.String()
}

func newErrorInvalidGameSessionStatusException(v protocol.ResponseMetadata) error {
	return &InvalidGameSessionStatusException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidGameSessionStatusException) Code() string {
	return "InvalidGameSessionStatusException"
}

// Message returns the exception's message.
func (s *InvalidGameSessionStatusException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidGameSessionStatusException) OrigErr() error {
	return nil
}

func (s *InvalidGameSessionStatusException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidGameSessionStatusException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidGameSessionStatusException) RequestID() string {
	return s.RespMetadata.RequestID
}

// One or more parameter values in the request are invalid. Correct the invalid
// parameter values before retrying.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A range of IP addresses and port settings that allow inbound traffic to connect
// to server processes on an instance in a fleet. New game sessions are assigned
// an IP address/port number combination, which must fall into the fleet's allowed
// ranges. Fleets with custom game builds must have permissions explicitly set.
// For Realtime Servers fleets, Amazon GameLift automatically opens two port
// ranges, one for TCP messaging and one for UDP.
type IpPermission struct {
	_ struct{} `type:"structure"`

	// A starting value for a range of allowed port numbers.
	//
	// For fleets using Linux builds, only ports 22 and 1026-60000 are valid.
	//
	// For fleets using Windows builds, only ports 1026-60000 are valid.
	//
	// FromPort is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by IpPermission's
	// String and GoString methods.
	//
	// FromPort is a required field
	FromPort *int64 `min:"1" type:"integer" required:"true" sensitive:"true"`

	// A range of allowed IP addresses. This value must be expressed in CIDR notation.
	// Example: "000.000.000.000/[subnet mask]" or optionally the shortened version
	// "0.0.0.0/[subnet mask]".
	//
	// IpRange is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by IpPermission's
	// String and GoString methods.
	//
	// IpRange is a required field
	IpRange *string `type:"string" required:"true" sensitive:"true"`

	// The network communication protocol used by the fleet.
	//
	// Protocol is a required field
	Protocol *string `type:"string" required:"true" enum:"IpProtocol"`

	// An ending value for a range of allowed port numbers. Port numbers are end-inclusive.
	// This value must be equal to or greater than FromPort.
	//
	// For fleets using Linux builds, only ports 22 and 1026-60000 are valid.
	//
	// For fleets using Windows builds, only ports 1026-60000 are valid.
	//
	// ToPort is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by IpPermission's
	// String and GoString methods.
	//
	// ToPort is a required field
	ToPort *int64 `min:"1" type:"integer" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IpPermission) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IpPermission) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IpPermission) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IpPermission"}
	if s.FromPort == nil {
		invalidParams.Add(request.NewErrParamRequired("FromPort"))
	}
	if s.FromPort != nil && *s.FromPort < 1 {
		invalidParams.Add(request.NewErrParamMinValue("FromPort", 1))
	}
	if s.IpRange == nil {
		invalidParams.Add(request.NewErrParamRequired("IpRange"))
	}
	if s.Protocol == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocol"))
	}
	if s.ToPort == nil {
		invalidParams.Add(request.NewErrParamRequired("ToPort"))
	}
	if s.ToPort != nil && *s.ToPort < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ToPort", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFromPort sets the FromPort field's value.
func (s *IpPermission) SetFromPort(v int64) *IpPermission {
	s.FromPort = &v
	return s
}

// SetIpRange sets the IpRange field's value.
func (s *IpPermission) SetIpRange(v string) *IpPermission {
	s.IpRange = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *IpPermission) SetProtocol(v string) *IpPermission {
	s.Protocol = &v
	return s
}

// SetToPort sets the ToPort field's value.
func (s *IpPermission) SetToPort(v int64) *IpPermission {
	s.ToPort = &v
	return s
}

// This data type is used with the Amazon GameLift FleetIQ and game server groups.
//
// An Amazon Elastic Compute Cloud launch template that contains configuration
// settings and game server code to be deployed to all instances in a game server
// group. The launch template is specified when creating a new game server group.
type LaunchTemplateSpecification struct {
	_ struct{} `type:"structure"`

	// A unique identifier for an existing Amazon EC2 launch template.
	LaunchTemplateId *string `min:"1" type:"string"`

	// A readable identifier for an existing Amazon EC2 launch template.
	LaunchTemplateName *string `min:"3" type:"string"`

	// The version of the Amazon EC2 launch template to use. If no version is specified,
	// the default version will be used. With Amazon EC2, you can specify a default
	// version for a launch template. If none is set, the default is the first version
	// created.
	Version *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchTemplateSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchTemplateSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LaunchTemplateSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LaunchTemplateSpecification"}
	if s.LaunchTemplateId != nil && len(*s.LaunchTemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LaunchTemplateId", 1))
	}
	if s.LaunchTemplateName != nil && len(*s.LaunchTemplateName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("LaunchTemplateName", 3))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLaunchTemplateId sets the LaunchTemplateId field's value.
func (s *LaunchTemplateSpecification) SetLaunchTemplateId(v string) *LaunchTemplateSpecification {
	s.LaunchTemplateId = &v
	return s
}

// SetLaunchTemplateName sets the LaunchTemplateName field's value.
func (s *LaunchTemplateSpecification) SetLaunchTemplateName(v string) *LaunchTemplateSpecification {
	s.LaunchTemplateName = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *LaunchTemplateSpecification) SetVersion(v string) *LaunchTemplateSpecification {
	s.Version = &v
	return s
}

// The requested operation would cause the resource to exceed the allowed service
// limit. Resolve the issue before retrying.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAliasesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// A descriptive label that is associated with an alias. Alias names do not
	// need to be unique.
	Name *string `min:"1" type:"string"`

	// A token that indicates the start of the next sequential page of results.
	// Use the token that is returned with a previous call to this operation. To
	// start at the beginning of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`

	// The routing type to filter results on. Use this parameter to retrieve only
	// aliases with a certain routing type. To retrieve all aliases, leave this
	// parameter empty.
	//
	// Possible routing types include the following:
	//
	//    * SIMPLE -- The alias resolves to one specific fleet. Use this type when
	//    routing to active fleets.
	//
	//    * TERMINAL -- The alias does not resolve to a fleet but instead can be
	//    used to display a message to the user. A terminal alias throws a TerminalRoutingStrategyException
	//    with the RoutingStrategy (https://docs.aws.amazon.com/gamelift/latest/apireference/API_RoutingStrategy.html)
	//    message embedded.
	RoutingStrategyType *string `type:"string" enum:"RoutingStrategyType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAliasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAliasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAliasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAliasesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListAliasesInput) SetLimit(v int64) *ListAliasesInput {
	s.Limit = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListAliasesInput) SetName(v string) *ListAliasesInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAliasesInput) SetNextToken(v string) *ListAliasesInput {
	s.NextToken = &v
	return s
}

// SetRoutingStrategyType sets the RoutingStrategyType field's value.
func (s *ListAliasesInput) SetRoutingStrategyType(v string) *ListAliasesInput {
	s.RoutingStrategyType = &v
	return s
}

type ListAliasesOutput struct {
	_ struct{} `type:"structure"`

	// A collection of alias resources that match the request parameters.
	Aliases []*Alias `type:"list"`

	// A token that indicates where to resume retrieving results on the next call
	// to this operation. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAliasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAliasesOutput) GoString() string {
	return s.String()
}

// SetAliases sets the Aliases field's value.
func (s *ListAliasesOutput) SetAliases(v []*Alias) *ListAliasesOutput {
	s.Aliases = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAliasesOutput) SetNextToken(v string) *ListAliasesOutput {
	s.NextToken = &v
	return s
}

type ListBuildsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// A token that indicates the start of the next sequential page of results.
	// Use the token that is returned with a previous call to this operation. To
	// start at the beginning of the result set, don't specify a value.
	NextToken *string `min:"1" type:"string"`

	// Build status to filter results by. To retrieve all builds, leave this parameter
	// empty.
	//
	// Possible build statuses include the following:
	//
	//    * INITIALIZED -- A new build has been defined, but no files have been
	//    uploaded. You cannot create fleets for builds that are in this status.
	//    When a build is successfully created, the build status is set to this
	//    value.
	//
	//    * READY -- The game build has been successfully uploaded. You can now
	//    create new fleets for this build.
	//
	//    * FAILED -- The game build upload failed. You cannot create new fleets
	//    for this build.
	Status *string `type:"string" enum:"BuildStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBuildsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBuildsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBuildsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBuildsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListBuildsInput) SetLimit(v int64) *ListBuildsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBuildsInput) SetNextToken(v string) *ListBuildsInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListBuildsInput) SetStatus(v string) *ListBuildsInput {
	s.Status = &v
	return s
}

type ListBuildsOutput struct {
	_ struct{} `type:"structure"`

	// A collection of build resources that match the request.
	Builds []*Build `type:"list"`

	// A token that indicates where to resume retrieving results on the next call
	// to this operation. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBuildsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBuildsOutput) GoString() string {
	return s.String()
}

// SetBuilds sets the Builds field's value.
func (s *ListBuildsOutput) SetBuilds(v []*Build) *ListBuildsOutput {
	s.Builds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBuildsOutput) SetNextToken(v string) *ListBuildsOutput {
	s.NextToken = &v
	return s
}

type ListComputeInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the fleet to retrieve compute resources for.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// The name of a location to retrieve compute resources for.
	Location *string `min:"1" type:"string"`

	// A token that indicates the start of the next sequential page of results.
	// Use the token that is returned with a previous call to this operation. To
	// start at the beginning of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComputeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComputeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListComputeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListComputeInput"}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Location != nil && len(*s.Location) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Location", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleetId sets the FleetId field's value.
func (s *ListComputeInput) SetFleetId(v string) *ListComputeInput {
	s.FleetId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListComputeInput) SetLimit(v int64) *ListComputeInput {
	s.Limit = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *ListComputeInput) SetLocation(v string) *ListComputeInput {
	s.Location = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListComputeInput) SetNextToken(v string) *ListComputeInput {
	s.NextToken = &v
	return s
}

type ListComputeOutput struct {
	_ struct{} `type:"structure"`

	// A list of compute resources in the specified fleet.
	ComputeList []*Compute `type:"list"`

	// A token that indicates where to resume retrieving results on the next call
	// to this operation. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComputeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComputeOutput) GoString() string {
	return s.String()
}

// SetComputeList sets the ComputeList field's value.
func (s *ListComputeOutput) SetComputeList(v []*Compute) *ListComputeOutput {
	s.ComputeList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListComputeOutput) SetNextToken(v string) *ListComputeOutput {
	s.NextToken = &v
	return s
}

type ListFleetsInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the build to request fleets for. Use this parameter
	// to return only fleets using a specified build. Us