// Code generated by smithy-go-codegen DO NOT EDIT.

package pinpointsmsvoicev2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves the specified registration field values.
func (c *Client) DescribeRegistrationFieldValues(ctx context.Context, params *DescribeRegistrationFieldValuesInput, optFns ...func(*Options)) (*DescribeRegistrationFieldValuesOutput, error) {
	if params == nil {
		params = &DescribeRegistrationFieldValuesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeRegistrationFieldValues", params, optFns, c.addOperationDescribeRegistrationFieldValuesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeRegistrationFieldValuesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeRegistrationFieldValuesInput struct {

	// The unique identifier for the registration.
	//
	// This member is required.
	RegistrationId *string

	// An array of paths to the registration form field.
	FieldPaths []string

	// The maximum number of results to return per each request.
	MaxResults *int32

	// The token to be used for the next set of paginated results. You don't need to
	// supply a value for this field in the initial request.
	NextToken *string

	// The path to the section of the registration.
	SectionPath *string

	// The version number of the registration.
	VersionNumber *int64

	noSmithyDocumentSerde
}

type DescribeRegistrationFieldValuesOutput struct {

	// The Amazon Resource Name (ARN) for the registration.
	//
	// This member is required.
	RegistrationArn *string

	// An array of RegistrationFieldValues objects that contain the values for the
	// requested registration.
	//
	// This member is required.
	RegistrationFieldValues []types.RegistrationFieldValueInformation

	// The unique identifier for the registration.
	//
	// This member is required.
	RegistrationId *string

	// The current version of the registration.
	//
	// This member is required.
	VersionNumber *int64

	// The token to be used for the next set of paginated results. You don't need to
	// supply a value for this field in the initial request.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeRegistrationFieldValuesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpDescribeRegistrationFieldValues{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpDescribeRegistrationFieldValues{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeRegistrationFieldValues"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeRegistrationFieldValuesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeRegistrationFieldValues(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeRegistrationFieldValuesPaginatorOptions is the paginator options for
// DescribeRegistrationFieldValues
type DescribeRegistrationFieldValuesPaginatorOptions struct {
	// The maximum number of results to return per each request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeRegistrationFieldValuesPaginator is a paginator for
// DescribeRegistrationFieldValues
type DescribeRegistrationFieldValuesPaginator struct {
	options   DescribeRegistrationFieldValuesPaginatorOptions
	client    DescribeRegistrationFieldValuesAPIClient
	params    *DescribeRegistrationFieldValuesInput
	nextToken *string
	firstPage bool
}

// NewDescribeRegistrationFieldValuesPaginator returns a new
// DescribeRegistrationFieldValuesPaginator
func NewDescribeRegistrationFieldValuesPaginator(client DescribeRegistrationFieldValuesAPIClient, params *DescribeRegistrationFieldValuesInput, optFns ...func(*DescribeRegistrationFieldValuesPaginatorOptions)) *DescribeRegistrationFieldValuesPaginator {
	if params == nil {
		params = &DescribeRegistrationFieldValuesInput{}
	}

	options := DescribeRegistrationFieldValuesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeRegistrationFieldValuesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeRegistrationFieldValuesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeRegistrationFieldValues page.
func (p *DescribeRegistrationFieldValuesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeRegistrationFieldValuesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeRegistrationFieldValues(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeRegistrationFieldValuesAPIClient is a client that implements the
// DescribeRegistrationFieldValues operation.
type DescribeRegistrationFieldValuesAPIClient interface {
	DescribeRegistrationFieldValues(context.Context, *DescribeRegistrationFieldValuesInput, ...func(*Options)) (*DescribeRegistrationFieldValuesOutput, error)
}

var _ DescribeRegistrationFieldValuesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeRegistrationFieldValues(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeRegistrationFieldValues",
	}
}
