// Code generated by smithy-go-codegen DO NOT EDIT.

package codepipeline

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/codepipeline/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// You can retry a stage that has failed without having to run a pipeline again
// from the beginning. You do this by either retrying the failed actions in a stage
// or by retrying all actions in the stage starting from the first action in the
// stage. When you retry the failed actions in a stage, all actions that are still
// in progress continue working, and failed actions are triggered again. When you
// retry a failed stage from the first action in the stage, the stage cannot have
// any actions in progress. Before a stage can be retried, it must either have all
// actions failed or some actions failed and some succeeded.
func (c *Client) RetryStageExecution(ctx context.Context, params *RetryStageExecutionInput, optFns ...func(*Options)) (*RetryStageExecutionOutput, error) {
	if params == nil {
		params = &RetryStageExecutionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "RetryStageExecution", params, optFns, c.addOperationRetryStageExecutionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*RetryStageExecutionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Represents the input of a RetryStageExecution action.
type RetryStageExecutionInput struct {

	// The ID of the pipeline execution in the failed stage to be retried. Use the GetPipelineState
	// action to retrieve the current pipelineExecutionId of the failed stage
	//
	// This member is required.
	PipelineExecutionId *string

	// The name of the pipeline that contains the failed stage.
	//
	// This member is required.
	PipelineName *string

	// The scope of the retry attempt.
	//
	// This member is required.
	RetryMode types.StageRetryMode

	// The name of the failed stage to be retried.
	//
	// This member is required.
	StageName *string

	noSmithyDocumentSerde
}

// Represents the output of a RetryStageExecution action.
type RetryStageExecutionOutput struct {

	// The ID of the current workflow execution in the failed stage.
	PipelineExecutionId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationRetryStageExecutionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpRetryStageExecution{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpRetryStageExecution{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "RetryStageExecution"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpRetryStageExecutionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opRetryStageExecution(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opRetryStageExecution(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "RetryStageExecution",
	}
}
