/*
 * Decompiled with CFR 0.152.
 */
package friendless.games.filler.remote;

import friendless.games.filler.remote.IsMessage;
import friendless.games.filler.remote.IsRemoteConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class RemoteConnection
implements IsRemoteConnection {
    private static IsRemoteConnection _connection = null;
    private static String[] _msgNames = new String[]{"NewGame", "Move"};
    private ServerSocket _server = null;
    private Socket _client = null;
    private InputStream _in = null;
    private OutputStream _out = null;

    private RemoteConnection() {
    }

    public static IsRemoteConnection getInstance() {
        if (_connection == null) {
            _connection = new RemoteConnection();
        }
        return _connection;
    }

    public boolean isServer() {
        return this._server != null;
    }

    public void setup(boolean bl, String string, int n) throws IOException {
        this.disconnect();
        if (bl) {
            System.out.println("Server on port " + n);
            if (this._server == null) {
                this._server = new ServerSocket(n, 1);
            }
            System.out.println("Waiting for connection...");
            this._client = this._server.accept();
            System.out.println("Connection arrived...");
        } else {
            System.out.println("Client, connecting to " + string + ":" + n);
            this._client = new Socket(string, n);
            System.out.println("Connection made...");
        }
        this._in = this._client.getInputStream();
        this._out = this._client.getOutputStream();
    }

    public void disconnect() throws IOException {
        if (this._client != null) {
            this._client.close();
        }
        this._client = null;
    }

    public boolean connected() {
        return this._in != null;
    }

    public void sendMessage(IsMessage isMessage) throws IOException {
        System.out.println("Sending message: " + isMessage);
        this._out.write(isMessage.getMessageId());
        this._out.write(isMessage.getPayload());
        this._out.flush();
    }

    public IsMessage receiveMessage() throws IOException {
        byte by = (byte)this._in.read();
        try {
            Class<?> clazz = Class.forName("friendless.games.filler.remote.messages." + _msgNames[by] + "Message");
            IsMessage isMessage = (IsMessage)clazz.newInstance();
            int n = isMessage.getPayloadSize();
            if (n != -1) {
                byte[] byArray = new byte[n];
                int n2 = 0;
                int n3 = 0;
                while (n3 != -1 && n > 0) {
                    n3 = this._in.read(byArray, n2, n);
                    n -= n3;
                    System.out.println("Read " + n3 + "/" + byArray.length + " of payload");
                }
                if (n == 0) {
                    isMessage.init(byArray);
                }
            }
            System.out.println("Received message: " + isMessage);
            return isMessage;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return null;
    }
}

