#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.


from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment
        # examples:
        # self.key_macro = [[1,'KEY_LEFTCTRL'],[1,'KEY_O'],[0.05,'SLEEP'],[0,'KEY_O'],[0,'KEY_LEFTCTRL']]
        # self.key_macro = [[1,'KEY_LEFTSHIFT'],[1,'KEY_LEFTCTRL'],[1,'KEY_N'],[0.05,'SLEEP'],[0,'KEY_N'],[0,'KEY_LEFTCTRL'],[0,'KEY_LEFTSHIFT']]
        self.key_macro = []
        self.byteMakro = []

    def shutdown(self):
        pass

    def get_description(self):
        return "No description found"

    def run(self):
        if self.env["runtime"]["InputManager"].get_shortcut_type() in ["KEY"]:
            self.env["runtime"]["InputManager"].send_keys(self.key_macro)
        elif self.env["runtime"]["InputManager"].get_shortcut_type() in [
            "BYTE"
        ]:
            self.env["runtime"]["ByteManager"].send_bytes(self.byteMakro)

    def set_callback(self, callback):
        pass
