// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file optional.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#ifndef FAST_DDS_GENERATED__OPTIONAL_HPP
#define FAST_DDS_GENERATED__OPTIONAL_HPP

#include <array>
#include <cstdint>
#include <map>
#include <string>
#include <utility>
#include <vector>

#include <fastcdr/cdr/fixed_size_string.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include "helpers/basic_inner_types.hpp"

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(OPTIONAL_SOURCE)
#define OPTIONAL_DllAPI __declspec( dllexport )
#else
#define OPTIONAL_DllAPI __declspec( dllimport )
#endif // OPTIONAL_SOURCE
#else
#define OPTIONAL_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define OPTIONAL_DllAPI
#endif // _WIN32

/*!
 * @brief This class represents the structure short_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class short_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport short_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~short_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object short_optional that will be copied.
     */
    eProsima_user_DllExport short_optional(
            const short_optional& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object short_optional that will be copied.
     */
    eProsima_user_DllExport short_optional(
            short_optional&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object short_optional that will be copied.
     */
    eProsima_user_DllExport short_optional& operator =(
            const short_optional& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object short_optional that will be copied.
     */
    eProsima_user_DllExport short_optional& operator =(
            short_optional&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x short_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const short_optional& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x short_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const short_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<int16_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<int16_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<int16_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<int16_t>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::optional<int16_t> m_value;

};
/*!
 * @brief This class represents the structure ushort_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class ushort_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ushort_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ushort_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ushort_optional that will be copied.
     */
    eProsima_user_DllExport ushort_optional(
            const ushort_optional& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ushort_optional that will be copied.
     */
    eProsima_user_DllExport ushort_optional(
            ushort_optional&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ushort_optional that will be copied.
     */
    eProsima_user_DllExport ushort_optional& operator =(
            const ushort_optional& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ushort_optional that will be copied.
     */
    eProsima_user_DllExport ushort_optional& operator =(
            ushort_optional&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ushort_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ushort_optional& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x ushort_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ushort_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<uint16_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<uint16_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<uint16_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<uint16_t>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::optional<uint16_t> m_value;

};
/*!
 * @brief This class represents the structure long_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class long_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport long_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~long_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object long_optional that will be copied.
     */
    eProsima_user_DllExport long_optional(
            const long_optional& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object long_optional that will be copied.
     */
    eProsima_user_DllExport long_optional(
            long_optional&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object long_optional that will be copied.
     */
    eProsima_user_DllExport long_optional& operator =(
            const long_optional& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object long_optional that will be copied.
     */
    eProsima_user_DllExport long_optional& operator =(
            long_optional&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x long_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const long_optional& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x long_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const long_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<int32_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<int32_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<int32_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<int32_t>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::optional<int32_t> m_value;

};
/*!
 * @brief This class represents the structure ulong_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class ulong_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ulong_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ulong_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ulong_optional that will be copied.
     */
    eProsima_user_DllExport ulong_optional(
            const ulong_optional& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ulong_optional that will be copied.
     */
    eProsima_user_DllExport ulong_optional(
            ulong_optional&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ulong_optional that will be copied.
     */
    eProsima_user_DllExport ulong_optional& operator =(
            const ulong_optional& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ulong_optional that will be copied.
     */
    eProsima_user_DllExport ulong_optional& operator =(
            ulong_optional&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ulong_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ulong_optional& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x ulong_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ulong_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<uint32_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<uint32_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<uint32_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<uint32_t>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::optional<uint32_t> m_value;

};
/*!
 * @brief This class represents the structure longlong_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class longlong_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport longlong_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~longlong_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object longlong_optional that will be copied.
     */
    eProsima_user_DllExport longlong_optional(
            const longlong_optional& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object longlong_optional that will be copied.
     */
    eProsima_user_DllExport longlong_optional(
            longlong_optional&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object longlong_optional that will be copied.
     */
    eProsima_user_DllExport longlong_optional& operator =(
            const longlong_optional& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object longlong_optional that will be copied.
     */
    eProsima_user_DllExport longlong_optional& operator =(
            longlong_optional&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x longlong_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const longlong_optional& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x longlong_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const longlong_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<int64_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<int64_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<int64_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<int64_t>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::optional<int64_t> m_value;

};
/*!
 * @brief This class represents the structure ulonglong_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class ulonglong_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ulonglong_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ulonglong_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ulonglong_optional that will be copied.
     */
    eProsima_user_DllExport ulonglong_optional(
            const ulonglong_optional& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ulonglong_optional that will be copied.
     */
    eProsima_user_DllExport ulonglong_optional(
            ulonglong_optional&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ulonglong_optional that will be copied.
     */
    eProsima_user_DllExport ulonglong_optional& operator =(
            const ulonglong_optional& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ulonglong_optional that will be copied.
     */
    eProsima_user_DllExport ulonglong_optional& operator =(
            ulonglong_optional&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ulonglong_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ulonglong_optional& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x ulonglong_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ulonglong_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<uint64_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<uint64_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<uint64_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<uint64_t>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::optional<uint64_t> m_value;

};
/*!
 * @brief This class represents the structure float_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class float_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport float_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~float_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object float_optional that will be copied.
     */
    eProsima_user_DllExport float_optional(
            const float_optional& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object float_optional that will be copied.
     */
    eProsima_user_DllExport float_optional(
            float_optional&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object float_optional that will be copied.
     */
    eProsima_user_DllExport float_optional& operator =(
            const float_optional& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object float_optional that will be copied.
     */
    eProsima_user_DllExport float_optional& operator =(
            float_optional&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x float_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const float_optional& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x float_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const float_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<float>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<float>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<float>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<float>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::optional<float> m_value;

};
/*!
 * @brief This class represents the structure double_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class double_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport double_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~double_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object double_optional that will be copied.
     */
    eProsima_user_DllExport double_optional(
            const double_optional& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object double_optional that will be copied.
     */
    eProsima_user_DllExport double_optional(
            double_optional&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object double_optional that will be copied.
     */
    eProsima_user_DllExport double_optional& operator =(
            const double_optional& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object double_optional that will be copied.
     */
    eProsima_user_DllExport double_optional& operator =(
            double_optional&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x double_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const double_optional& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x double_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const double_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<double>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<double>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<double>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<double>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::optional<double> m_value;

};
/*!
 * @brief This class represents the structure longdouble_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class longdouble_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport longdouble_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~longdouble_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object longdouble_optional that will be copied.
     */
    eProsima_user_DllExport longdouble_optional(
            const longdouble_optional& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object longdouble_optional that will be copied.
     */
    eProsima_user_DllExport longdouble_optional(
            longdouble_optional&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object longdouble_optional that will be copied.
     */
    eProsima_user_DllExport longdouble_optional& operator =(
            const longdouble_optional& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object longdouble_optional that will be copied.
     */
    eProsima_user_DllExport longdouble_optional& operator =(
            longdouble_optional&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x longdouble_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const longdouble_optional& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x longdouble_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const longdouble_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<long double>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<long double>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<long double>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<long double>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::optional<long double> m_value;

};
/*!
 * @brief This class represents the structure boolean_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class boolean_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport boolean_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~boolean_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object boolean_optional that will be copied.
     */
    eProsima_user_DllExport boolean_optional(
            const boolean_optional& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object boolean_optional that will be copied.
     */
    eProsima_user_DllExport boolean_optional(
            boolean_optional&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object boolean_optional that will be copied.
     */
    eProsima_user_DllExport boolean_optional& operator =(
            const boolean_optional& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object boolean_optional that will be copied.
     */
    eProsima_user_DllExport boolean_optional& operator =(
            boolean_optional&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x boolean_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const boolean_optional& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x boolean_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const boolean_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<bool>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<bool>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<bool>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<bool>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::optional<bool> m_value;

};
/*!
 * @brief This class represents the structure octet_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class octet_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport octet_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~octet_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object octet_optional that will be copied.
     */
    eProsima_user_DllExport octet_optional(
            const octet_optional& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object octet_optional that will be copied.
     */
    eProsima_user_DllExport octet_optional(
            octet_optional&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object octet_optional that will be copied.
     */
    eProsima_user_DllExport octet_optional& operator =(
            const octet_optional& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object octet_optional that will be copied.
     */
    eProsima_user_DllExport octet_optional& operator =(
            octet_optional&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x octet_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const octet_optional& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x octet_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const octet_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<uint8_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<uint8_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<uint8_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<uint8_t>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::optional<uint8_t> m_value;

};
/*!
 * @brief This class represents the structure char_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class char_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport char_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~char_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object char_optional that will be copied.
     */
    eProsima_user_DllExport char_optional(
            const char_optional& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object char_optional that will be copied.
     */
    eProsima_user_DllExport char_optional(
            char_optional&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object char_optional that will be copied.
     */
    eProsima_user_DllExport char_optional& operator =(
            const char_optional& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object char_optional that will be copied.
     */
    eProsima_user_DllExport char_optional& operator =(
            char_optional&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x char_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const char_optional& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x char_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const char_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<char>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<char>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<char>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<char>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::optional<char> m_value;

};
/*!
 * @brief This class represents the structure wchar_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class wchar_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport wchar_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~wchar_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object wchar_optional that will be copied.
     */
    eProsima_user_DllExport wchar_optional(
            const wchar_optional& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object wchar_optional that will be copied.
     */
    eProsima_user_DllExport wchar_optional(
            wchar_optional&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object wchar_optional that will be copied.
     */
    eProsima_user_DllExport wchar_optional& operator =(
            const wchar_optional& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object wchar_optional that will be copied.
     */
    eProsima_user_DllExport wchar_optional& operator =(
            wchar_optional&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x wchar_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const wchar_optional& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x wchar_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const wchar_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<wchar_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<wchar_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<wchar_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<wchar_t>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::optional<wchar_t> m_value;

};
/*!
 * @brief This class represents the structure short_align_1_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class short_align_1_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport short_align_1_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~short_align_1_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object short_align_1_optional that will be copied.
     */
    eProsima_user_DllExport short_align_1_optional(
            const short_align_1_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object short_align_1_optional that will be copied.
     */
    eProsima_user_DllExport short_align_1_optional(
            short_align_1_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object short_align_1_optional that will be copied.
     */
    eProsima_user_DllExport short_align_1_optional& operator =(
            const short_align_1_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object short_align_1_optional that will be copied.
     */
    eProsima_user_DllExport short_align_1_optional& operator =(
            short_align_1_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x short_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const short_align_1_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x short_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const short_align_1_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint8_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint8_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint8_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<int16_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<int16_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<int16_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<int16_t>& value()
    {
        return m_value;
    }



private:

    uint8_t m_align{0};
    eprosima::fastcdr::optional<int16_t> m_value;

};
/*!
 * @brief This class represents the structure short_align_2_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class short_align_2_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport short_align_2_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~short_align_2_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object short_align_2_optional that will be copied.
     */
    eProsima_user_DllExport short_align_2_optional(
            const short_align_2_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object short_align_2_optional that will be copied.
     */
    eProsima_user_DllExport short_align_2_optional(
            short_align_2_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object short_align_2_optional that will be copied.
     */
    eProsima_user_DllExport short_align_2_optional& operator =(
            const short_align_2_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object short_align_2_optional that will be copied.
     */
    eProsima_user_DllExport short_align_2_optional& operator =(
            short_align_2_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x short_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const short_align_2_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x short_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const short_align_2_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint16_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint16_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint16_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<int16_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<int16_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<int16_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<int16_t>& value()
    {
        return m_value;
    }



private:

    uint16_t m_align{0};
    eprosima::fastcdr::optional<int16_t> m_value;

};
/*!
 * @brief This class represents the structure short_align_4_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class short_align_4_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport short_align_4_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~short_align_4_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object short_align_4_optional that will be copied.
     */
    eProsima_user_DllExport short_align_4_optional(
            const short_align_4_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object short_align_4_optional that will be copied.
     */
    eProsima_user_DllExport short_align_4_optional(
            short_align_4_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object short_align_4_optional that will be copied.
     */
    eProsima_user_DllExport short_align_4_optional& operator =(
            const short_align_4_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object short_align_4_optional that will be copied.
     */
    eProsima_user_DllExport short_align_4_optional& operator =(
            short_align_4_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x short_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const short_align_4_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x short_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const short_align_4_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint32_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint32_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint32_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<int16_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<int16_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<int16_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<int16_t>& value()
    {
        return m_value;
    }



private:

    uint32_t m_align{0};
    eprosima::fastcdr::optional<int16_t> m_value;

};
/*!
 * @brief This class represents the structure ushort_align_1_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class ushort_align_1_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ushort_align_1_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ushort_align_1_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ushort_align_1_optional that will be copied.
     */
    eProsima_user_DllExport ushort_align_1_optional(
            const ushort_align_1_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ushort_align_1_optional that will be copied.
     */
    eProsima_user_DllExport ushort_align_1_optional(
            ushort_align_1_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ushort_align_1_optional that will be copied.
     */
    eProsima_user_DllExport ushort_align_1_optional& operator =(
            const ushort_align_1_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ushort_align_1_optional that will be copied.
     */
    eProsima_user_DllExport ushort_align_1_optional& operator =(
            ushort_align_1_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ushort_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ushort_align_1_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x ushort_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ushort_align_1_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint8_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint8_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint8_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<uint16_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<uint16_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<uint16_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<uint16_t>& value()
    {
        return m_value;
    }



private:

    uint8_t m_align{0};
    eprosima::fastcdr::optional<uint16_t> m_value;

};
/*!
 * @brief This class represents the structure ushort_align_2_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class ushort_align_2_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ushort_align_2_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ushort_align_2_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ushort_align_2_optional that will be copied.
     */
    eProsima_user_DllExport ushort_align_2_optional(
            const ushort_align_2_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ushort_align_2_optional that will be copied.
     */
    eProsima_user_DllExport ushort_align_2_optional(
            ushort_align_2_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ushort_align_2_optional that will be copied.
     */
    eProsima_user_DllExport ushort_align_2_optional& operator =(
            const ushort_align_2_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ushort_align_2_optional that will be copied.
     */
    eProsima_user_DllExport ushort_align_2_optional& operator =(
            ushort_align_2_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ushort_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ushort_align_2_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x ushort_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ushort_align_2_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint16_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint16_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint16_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<uint16_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<uint16_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<uint16_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<uint16_t>& value()
    {
        return m_value;
    }



private:

    uint16_t m_align{0};
    eprosima::fastcdr::optional<uint16_t> m_value;

};
/*!
 * @brief This class represents the structure ushort_align_4_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class ushort_align_4_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ushort_align_4_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ushort_align_4_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ushort_align_4_optional that will be copied.
     */
    eProsima_user_DllExport ushort_align_4_optional(
            const ushort_align_4_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ushort_align_4_optional that will be copied.
     */
    eProsima_user_DllExport ushort_align_4_optional(
            ushort_align_4_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ushort_align_4_optional that will be copied.
     */
    eProsima_user_DllExport ushort_align_4_optional& operator =(
            const ushort_align_4_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ushort_align_4_optional that will be copied.
     */
    eProsima_user_DllExport ushort_align_4_optional& operator =(
            ushort_align_4_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ushort_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ushort_align_4_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x ushort_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ushort_align_4_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint32_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint32_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint32_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<uint16_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<uint16_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<uint16_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<uint16_t>& value()
    {
        return m_value;
    }



private:

    uint32_t m_align{0};
    eprosima::fastcdr::optional<uint16_t> m_value;

};
/*!
 * @brief This class represents the structure long_align_1_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class long_align_1_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport long_align_1_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~long_align_1_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object long_align_1_optional that will be copied.
     */
    eProsima_user_DllExport long_align_1_optional(
            const long_align_1_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object long_align_1_optional that will be copied.
     */
    eProsima_user_DllExport long_align_1_optional(
            long_align_1_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object long_align_1_optional that will be copied.
     */
    eProsima_user_DllExport long_align_1_optional& operator =(
            const long_align_1_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object long_align_1_optional that will be copied.
     */
    eProsima_user_DllExport long_align_1_optional& operator =(
            long_align_1_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x long_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const long_align_1_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x long_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const long_align_1_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint8_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint8_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint8_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<int32_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<int32_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<int32_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<int32_t>& value()
    {
        return m_value;
    }



private:

    uint8_t m_align{0};
    eprosima::fastcdr::optional<int32_t> m_value;

};
/*!
 * @brief This class represents the structure long_align_2_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class long_align_2_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport long_align_2_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~long_align_2_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object long_align_2_optional that will be copied.
     */
    eProsima_user_DllExport long_align_2_optional(
            const long_align_2_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object long_align_2_optional that will be copied.
     */
    eProsima_user_DllExport long_align_2_optional(
            long_align_2_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object long_align_2_optional that will be copied.
     */
    eProsima_user_DllExport long_align_2_optional& operator =(
            const long_align_2_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object long_align_2_optional that will be copied.
     */
    eProsima_user_DllExport long_align_2_optional& operator =(
            long_align_2_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x long_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const long_align_2_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x long_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const long_align_2_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint16_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint16_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint16_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<int32_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<int32_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<int32_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<int32_t>& value()
    {
        return m_value;
    }



private:

    uint16_t m_align{0};
    eprosima::fastcdr::optional<int32_t> m_value;

};
/*!
 * @brief This class represents the structure long_align_4_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class long_align_4_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport long_align_4_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~long_align_4_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object long_align_4_optional that will be copied.
     */
    eProsima_user_DllExport long_align_4_optional(
            const long_align_4_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object long_align_4_optional that will be copied.
     */
    eProsima_user_DllExport long_align_4_optional(
            long_align_4_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object long_align_4_optional that will be copied.
     */
    eProsima_user_DllExport long_align_4_optional& operator =(
            const long_align_4_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object long_align_4_optional that will be copied.
     */
    eProsima_user_DllExport long_align_4_optional& operator =(
            long_align_4_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x long_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const long_align_4_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x long_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const long_align_4_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint32_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint32_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint32_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<int32_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<int32_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<int32_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<int32_t>& value()
    {
        return m_value;
    }



private:

    uint32_t m_align{0};
    eprosima::fastcdr::optional<int32_t> m_value;

};
/*!
 * @brief This class represents the structure ulong_align_1_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class ulong_align_1_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ulong_align_1_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ulong_align_1_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ulong_align_1_optional that will be copied.
     */
    eProsima_user_DllExport ulong_align_1_optional(
            const ulong_align_1_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ulong_align_1_optional that will be copied.
     */
    eProsima_user_DllExport ulong_align_1_optional(
            ulong_align_1_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ulong_align_1_optional that will be copied.
     */
    eProsima_user_DllExport ulong_align_1_optional& operator =(
            const ulong_align_1_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ulong_align_1_optional that will be copied.
     */
    eProsima_user_DllExport ulong_align_1_optional& operator =(
            ulong_align_1_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ulong_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ulong_align_1_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x ulong_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ulong_align_1_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint8_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint8_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint8_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<uint32_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<uint32_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<uint32_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<uint32_t>& value()
    {
        return m_value;
    }



private:

    uint8_t m_align{0};
    eprosima::fastcdr::optional<uint32_t> m_value;

};
/*!
 * @brief This class represents the structure ulong_align_2_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class ulong_align_2_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ulong_align_2_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ulong_align_2_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ulong_align_2_optional that will be copied.
     */
    eProsima_user_DllExport ulong_align_2_optional(
            const ulong_align_2_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ulong_align_2_optional that will be copied.
     */
    eProsima_user_DllExport ulong_align_2_optional(
            ulong_align_2_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ulong_align_2_optional that will be copied.
     */
    eProsima_user_DllExport ulong_align_2_optional& operator =(
            const ulong_align_2_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ulong_align_2_optional that will be copied.
     */
    eProsima_user_DllExport ulong_align_2_optional& operator =(
            ulong_align_2_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ulong_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ulong_align_2_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x ulong_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ulong_align_2_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint16_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint16_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint16_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<uint32_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<uint32_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<uint32_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<uint32_t>& value()
    {
        return m_value;
    }



private:

    uint16_t m_align{0};
    eprosima::fastcdr::optional<uint32_t> m_value;

};
/*!
 * @brief This class represents the structure ulong_align_4_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class ulong_align_4_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ulong_align_4_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ulong_align_4_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ulong_align_4_optional that will be copied.
     */
    eProsima_user_DllExport ulong_align_4_optional(
            const ulong_align_4_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ulong_align_4_optional that will be copied.
     */
    eProsima_user_DllExport ulong_align_4_optional(
            ulong_align_4_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ulong_align_4_optional that will be copied.
     */
    eProsima_user_DllExport ulong_align_4_optional& operator =(
            const ulong_align_4_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ulong_align_4_optional that will be copied.
     */
    eProsima_user_DllExport ulong_align_4_optional& operator =(
            ulong_align_4_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ulong_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ulong_align_4_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x ulong_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ulong_align_4_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint32_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint32_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint32_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<uint32_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<uint32_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<uint32_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<uint32_t>& value()
    {
        return m_value;
    }



private:

    uint32_t m_align{0};
    eprosima::fastcdr::optional<uint32_t> m_value;

};
/*!
 * @brief This class represents the structure longlong_align_1_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class longlong_align_1_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport longlong_align_1_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~longlong_align_1_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object longlong_align_1_optional that will be copied.
     */
    eProsima_user_DllExport longlong_align_1_optional(
            const longlong_align_1_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object longlong_align_1_optional that will be copied.
     */
    eProsima_user_DllExport longlong_align_1_optional(
            longlong_align_1_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object longlong_align_1_optional that will be copied.
     */
    eProsima_user_DllExport longlong_align_1_optional& operator =(
            const longlong_align_1_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object longlong_align_1_optional that will be copied.
     */
    eProsima_user_DllExport longlong_align_1_optional& operator =(
            longlong_align_1_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x longlong_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const longlong_align_1_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x longlong_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const longlong_align_1_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint8_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint8_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint8_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<int64_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<int64_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<int64_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<int64_t>& value()
    {
        return m_value;
    }



private:

    uint8_t m_align{0};
    eprosima::fastcdr::optional<int64_t> m_value;

};
/*!
 * @brief This class represents the structure longlong_align_2_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class longlong_align_2_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport longlong_align_2_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~longlong_align_2_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object longlong_align_2_optional that will be copied.
     */
    eProsima_user_DllExport longlong_align_2_optional(
            const longlong_align_2_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object longlong_align_2_optional that will be copied.
     */
    eProsima_user_DllExport longlong_align_2_optional(
            longlong_align_2_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object longlong_align_2_optional that will be copied.
     */
    eProsima_user_DllExport longlong_align_2_optional& operator =(
            const longlong_align_2_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object longlong_align_2_optional that will be copied.
     */
    eProsima_user_DllExport longlong_align_2_optional& operator =(
            longlong_align_2_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x longlong_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const longlong_align_2_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x longlong_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const longlong_align_2_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint16_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint16_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint16_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<int64_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<int64_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<int64_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<int64_t>& value()
    {
        return m_value;
    }



private:

    uint16_t m_align{0};
    eprosima::fastcdr::optional<int64_t> m_value;

};
/*!
 * @brief This class represents the structure longlong_align_4_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class longlong_align_4_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport longlong_align_4_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~longlong_align_4_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object longlong_align_4_optional that will be copied.
     */
    eProsima_user_DllExport longlong_align_4_optional(
            const longlong_align_4_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object longlong_align_4_optional that will be copied.
     */
    eProsima_user_DllExport longlong_align_4_optional(
            longlong_align_4_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object longlong_align_4_optional that will be copied.
     */
    eProsima_user_DllExport longlong_align_4_optional& operator =(
            const longlong_align_4_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object longlong_align_4_optional that will be copied.
     */
    eProsima_user_DllExport longlong_align_4_optional& operator =(
            longlong_align_4_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x longlong_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const longlong_align_4_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x longlong_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const longlong_align_4_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint32_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint32_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint32_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<int64_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<int64_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<int64_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<int64_t>& value()
    {
        return m_value;
    }



private:

    uint32_t m_align{0};
    eprosima::fastcdr::optional<int64_t> m_value;

};
/*!
 * @brief This class represents the structure ulonglong_align_1_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class ulonglong_align_1_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ulonglong_align_1_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ulonglong_align_1_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ulonglong_align_1_optional that will be copied.
     */
    eProsima_user_DllExport ulonglong_align_1_optional(
            const ulonglong_align_1_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ulonglong_align_1_optional that will be copied.
     */
    eProsima_user_DllExport ulonglong_align_1_optional(
            ulonglong_align_1_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ulonglong_align_1_optional that will be copied.
     */
    eProsima_user_DllExport ulonglong_align_1_optional& operator =(
            const ulonglong_align_1_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ulonglong_align_1_optional that will be copied.
     */
    eProsima_user_DllExport ulonglong_align_1_optional& operator =(
            ulonglong_align_1_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ulonglong_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ulonglong_align_1_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x ulonglong_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ulonglong_align_1_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint8_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint8_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint8_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<uint64_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<uint64_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<uint64_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<uint64_t>& value()
    {
        return m_value;
    }



private:

    uint8_t m_align{0};
    eprosima::fastcdr::optional<uint64_t> m_value;

};
/*!
 * @brief This class represents the structure ulonglong_align_2_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class ulonglong_align_2_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ulonglong_align_2_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ulonglong_align_2_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ulonglong_align_2_optional that will be copied.
     */
    eProsima_user_DllExport ulonglong_align_2_optional(
            const ulonglong_align_2_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ulonglong_align_2_optional that will be copied.
     */
    eProsima_user_DllExport ulonglong_align_2_optional(
            ulonglong_align_2_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ulonglong_align_2_optional that will be copied.
     */
    eProsima_user_DllExport ulonglong_align_2_optional& operator =(
            const ulonglong_align_2_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ulonglong_align_2_optional that will be copied.
     */
    eProsima_user_DllExport ulonglong_align_2_optional& operator =(
            ulonglong_align_2_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ulonglong_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ulonglong_align_2_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x ulonglong_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ulonglong_align_2_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint16_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint16_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint16_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<uint64_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<uint64_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<uint64_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<uint64_t>& value()
    {
        return m_value;
    }



private:

    uint16_t m_align{0};
    eprosima::fastcdr::optional<uint64_t> m_value;

};
/*!
 * @brief This class represents the structure ulonglong_align_4_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class ulonglong_align_4_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ulonglong_align_4_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ulonglong_align_4_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ulonglong_align_4_optional that will be copied.
     */
    eProsima_user_DllExport ulonglong_align_4_optional(
            const ulonglong_align_4_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ulonglong_align_4_optional that will be copied.
     */
    eProsima_user_DllExport ulonglong_align_4_optional(
            ulonglong_align_4_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ulonglong_align_4_optional that will be copied.
     */
    eProsima_user_DllExport ulonglong_align_4_optional& operator =(
            const ulonglong_align_4_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ulonglong_align_4_optional that will be copied.
     */
    eProsima_user_DllExport ulonglong_align_4_optional& operator =(
            ulonglong_align_4_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ulonglong_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ulonglong_align_4_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x ulonglong_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ulonglong_align_4_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint32_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint32_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint32_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<uint64_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<uint64_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<uint64_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<uint64_t>& value()
    {
        return m_value;
    }



private:

    uint32_t m_align{0};
    eprosima::fastcdr::optional<uint64_t> m_value;

};
/*!
 * @brief This class represents the structure float_align_1_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class float_align_1_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport float_align_1_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~float_align_1_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object float_align_1_optional that will be copied.
     */
    eProsima_user_DllExport float_align_1_optional(
            const float_align_1_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object float_align_1_optional that will be copied.
     */
    eProsima_user_DllExport float_align_1_optional(
            float_align_1_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object float_align_1_optional that will be copied.
     */
    eProsima_user_DllExport float_align_1_optional& operator =(
            const float_align_1_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object float_align_1_optional that will be copied.
     */
    eProsima_user_DllExport float_align_1_optional& operator =(
            float_align_1_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x float_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const float_align_1_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x float_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const float_align_1_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint8_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint8_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint8_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<float>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<float>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<float>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<float>& value()
    {
        return m_value;
    }



private:

    uint8_t m_align{0};
    eprosima::fastcdr::optional<float> m_value;

};
/*!
 * @brief This class represents the structure float_align_2_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class float_align_2_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport float_align_2_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~float_align_2_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object float_align_2_optional that will be copied.
     */
    eProsima_user_DllExport float_align_2_optional(
            const float_align_2_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object float_align_2_optional that will be copied.
     */
    eProsima_user_DllExport float_align_2_optional(
            float_align_2_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object float_align_2_optional that will be copied.
     */
    eProsima_user_DllExport float_align_2_optional& operator =(
            const float_align_2_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object float_align_2_optional that will be copied.
     */
    eProsima_user_DllExport float_align_2_optional& operator =(
            float_align_2_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x float_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const float_align_2_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x float_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const float_align_2_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint16_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint16_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint16_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<float>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<float>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<float>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<float>& value()
    {
        return m_value;
    }



private:

    uint16_t m_align{0};
    eprosima::fastcdr::optional<float> m_value;

};
/*!
 * @brief This class represents the structure float_align_4_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class float_align_4_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport float_align_4_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~float_align_4_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object float_align_4_optional that will be copied.
     */
    eProsima_user_DllExport float_align_4_optional(
            const float_align_4_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object float_align_4_optional that will be copied.
     */
    eProsima_user_DllExport float_align_4_optional(
            float_align_4_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object float_align_4_optional that will be copied.
     */
    eProsima_user_DllExport float_align_4_optional& operator =(
            const float_align_4_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object float_align_4_optional that will be copied.
     */
    eProsima_user_DllExport float_align_4_optional& operator =(
            float_align_4_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x float_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const float_align_4_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x float_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const float_align_4_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint32_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint32_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint32_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<float>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<float>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<float>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<float>& value()
    {
        return m_value;
    }



private:

    uint32_t m_align{0};
    eprosima::fastcdr::optional<float> m_value;

};
/*!
 * @brief This class represents the structure double_align_1_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class double_align_1_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport double_align_1_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~double_align_1_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object double_align_1_optional that will be copied.
     */
    eProsima_user_DllExport double_align_1_optional(
            const double_align_1_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object double_align_1_optional that will be copied.
     */
    eProsima_user_DllExport double_align_1_optional(
            double_align_1_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object double_align_1_optional that will be copied.
     */
    eProsima_user_DllExport double_align_1_optional& operator =(
            const double_align_1_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object double_align_1_optional that will be copied.
     */
    eProsima_user_DllExport double_align_1_optional& operator =(
            double_align_1_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x double_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const double_align_1_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x double_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const double_align_1_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint8_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint8_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint8_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<double>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<double>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<double>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<double>& value()
    {
        return m_value;
    }



private:

    uint8_t m_align{0};
    eprosima::fastcdr::optional<double> m_value;

};
/*!
 * @brief This class represents the structure double_align_2_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class double_align_2_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport double_align_2_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~double_align_2_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object double_align_2_optional that will be copied.
     */
    eProsima_user_DllExport double_align_2_optional(
            const double_align_2_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object double_align_2_optional that will be copied.
     */
    eProsima_user_DllExport double_align_2_optional(
            double_align_2_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object double_align_2_optional that will be copied.
     */
    eProsima_user_DllExport double_align_2_optional& operator =(
            const double_align_2_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object double_align_2_optional that will be copied.
     */
    eProsima_user_DllExport double_align_2_optional& operator =(
            double_align_2_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x double_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const double_align_2_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x double_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const double_align_2_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint16_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint16_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint16_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<double>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<double>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<double>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<double>& value()
    {
        return m_value;
    }



private:

    uint16_t m_align{0};
    eprosima::fastcdr::optional<double> m_value;

};
/*!
 * @brief This class represents the structure double_align_4_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class double_align_4_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport double_align_4_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~double_align_4_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object double_align_4_optional that will be copied.
     */
    eProsima_user_DllExport double_align_4_optional(
            const double_align_4_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object double_align_4_optional that will be copied.
     */
    eProsima_user_DllExport double_align_4_optional(
            double_align_4_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object double_align_4_optional that will be copied.
     */
    eProsima_user_DllExport double_align_4_optional& operator =(
            const double_align_4_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object double_align_4_optional that will be copied.
     */
    eProsima_user_DllExport double_align_4_optional& operator =(
            double_align_4_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x double_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const double_align_4_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x double_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const double_align_4_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint32_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint32_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint32_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<double>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<double>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<double>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<double>& value()
    {
        return m_value;
    }



private:

    uint32_t m_align{0};
    eprosima::fastcdr::optional<double> m_value;

};
/*!
 * @brief This class represents the structure longdouble_align_1_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class longdouble_align_1_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport longdouble_align_1_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~longdouble_align_1_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object longdouble_align_1_optional that will be copied.
     */
    eProsima_user_DllExport longdouble_align_1_optional(
            const longdouble_align_1_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object longdouble_align_1_optional that will be copied.
     */
    eProsima_user_DllExport longdouble_align_1_optional(
            longdouble_align_1_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object longdouble_align_1_optional that will be copied.
     */
    eProsima_user_DllExport longdouble_align_1_optional& operator =(
            const longdouble_align_1_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object longdouble_align_1_optional that will be copied.
     */
    eProsima_user_DllExport longdouble_align_1_optional& operator =(
            longdouble_align_1_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x longdouble_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const longdouble_align_1_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x longdouble_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const longdouble_align_1_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint8_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint8_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint8_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<long double>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<long double>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<long double>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<long double>& value()
    {
        return m_value;
    }



private:

    uint8_t m_align{0};
    eprosima::fastcdr::optional<long double> m_value;

};
/*!
 * @brief This class represents the structure longdouble_align_2_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class longdouble_align_2_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport longdouble_align_2_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~longdouble_align_2_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object longdouble_align_2_optional that will be copied.
     */
    eProsima_user_DllExport longdouble_align_2_optional(
            const longdouble_align_2_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object longdouble_align_2_optional that will be copied.
     */
    eProsima_user_DllExport longdouble_align_2_optional(
            longdouble_align_2_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object longdouble_align_2_optional that will be copied.
     */
    eProsima_user_DllExport longdouble_align_2_optional& operator =(
            const longdouble_align_2_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object longdouble_align_2_optional that will be copied.
     */
    eProsima_user_DllExport longdouble_align_2_optional& operator =(
            longdouble_align_2_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x longdouble_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const longdouble_align_2_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x longdouble_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const longdouble_align_2_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint16_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint16_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint16_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<long double>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<long double>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<long double>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<long double>& value()
    {
        return m_value;
    }



private:

    uint16_t m_align{0};
    eprosima::fastcdr::optional<long double> m_value;

};
/*!
 * @brief This class represents the structure longdouble_align_4_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class longdouble_align_4_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport longdouble_align_4_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~longdouble_align_4_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object longdouble_align_4_optional that will be copied.
     */
    eProsima_user_DllExport longdouble_align_4_optional(
            const longdouble_align_4_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object longdouble_align_4_optional that will be copied.
     */
    eProsima_user_DllExport longdouble_align_4_optional(
            longdouble_align_4_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object longdouble_align_4_optional that will be copied.
     */
    eProsima_user_DllExport longdouble_align_4_optional& operator =(
            const longdouble_align_4_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object longdouble_align_4_optional that will be copied.
     */
    eProsima_user_DllExport longdouble_align_4_optional& operator =(
            longdouble_align_4_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x longdouble_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const longdouble_align_4_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x longdouble_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const longdouble_align_4_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint32_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint32_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint32_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<long double>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<long double>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<long double>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<long double>& value()
    {
        return m_value;
    }



private:

    uint32_t m_align{0};
    eprosima::fastcdr::optional<long double> m_value;

};
/*!
 * @brief This class represents the structure boolean_align_1_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class boolean_align_1_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport boolean_align_1_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~boolean_align_1_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object boolean_align_1_optional that will be copied.
     */
    eProsima_user_DllExport boolean_align_1_optional(
            const boolean_align_1_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object boolean_align_1_optional that will be copied.
     */
    eProsima_user_DllExport boolean_align_1_optional(
            boolean_align_1_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object boolean_align_1_optional that will be copied.
     */
    eProsima_user_DllExport boolean_align_1_optional& operator =(
            const boolean_align_1_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object boolean_align_1_optional that will be copied.
     */
    eProsima_user_DllExport boolean_align_1_optional& operator =(
            boolean_align_1_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x boolean_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const boolean_align_1_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x boolean_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const boolean_align_1_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint8_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint8_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint8_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<bool>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<bool>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<bool>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<bool>& value()
    {
        return m_value;
    }



private:

    uint8_t m_align{0};
    eprosima::fastcdr::optional<bool> m_value;

};
/*!
 * @brief This class represents the structure boolean_align_2_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class boolean_align_2_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport boolean_align_2_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~boolean_align_2_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object boolean_align_2_optional that will be copied.
     */
    eProsima_user_DllExport boolean_align_2_optional(
            const boolean_align_2_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object boolean_align_2_optional that will be copied.
     */
    eProsima_user_DllExport boolean_align_2_optional(
            boolean_align_2_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object boolean_align_2_optional that will be copied.
     */
    eProsima_user_DllExport boolean_align_2_optional& operator =(
            const boolean_align_2_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object boolean_align_2_optional that will be copied.
     */
    eProsima_user_DllExport boolean_align_2_optional& operator =(
            boolean_align_2_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x boolean_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const boolean_align_2_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x boolean_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const boolean_align_2_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint16_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint16_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint16_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<bool>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<bool>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<bool>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<bool>& value()
    {
        return m_value;
    }



private:

    uint16_t m_align{0};
    eprosima::fastcdr::optional<bool> m_value;

};
/*!
 * @brief This class represents the structure boolean_align_4_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class boolean_align_4_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport boolean_align_4_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~boolean_align_4_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object boolean_align_4_optional that will be copied.
     */
    eProsima_user_DllExport boolean_align_4_optional(
            const boolean_align_4_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object boolean_align_4_optional that will be copied.
     */
    eProsima_user_DllExport boolean_align_4_optional(
            boolean_align_4_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object boolean_align_4_optional that will be copied.
     */
    eProsima_user_DllExport boolean_align_4_optional& operator =(
            const boolean_align_4_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object boolean_align_4_optional that will be copied.
     */
    eProsima_user_DllExport boolean_align_4_optional& operator =(
            boolean_align_4_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x boolean_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const boolean_align_4_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x boolean_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const boolean_align_4_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint32_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint32_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint32_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<bool>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<bool>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<bool>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<bool>& value()
    {
        return m_value;
    }



private:

    uint32_t m_align{0};
    eprosima::fastcdr::optional<bool> m_value;

};
/*!
 * @brief This class represents the structure octet_align_1_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class octet_align_1_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport octet_align_1_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~octet_align_1_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object octet_align_1_optional that will be copied.
     */
    eProsima_user_DllExport octet_align_1_optional(
            const octet_align_1_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object octet_align_1_optional that will be copied.
     */
    eProsima_user_DllExport octet_align_1_optional(
            octet_align_1_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object octet_align_1_optional that will be copied.
     */
    eProsima_user_DllExport octet_align_1_optional& operator =(
            const octet_align_1_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object octet_align_1_optional that will be copied.
     */
    eProsima_user_DllExport octet_align_1_optional& operator =(
            octet_align_1_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x octet_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const octet_align_1_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x octet_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const octet_align_1_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint8_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint8_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint8_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<uint8_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<uint8_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<uint8_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<uint8_t>& value()
    {
        return m_value;
    }



private:

    uint8_t m_align{0};
    eprosima::fastcdr::optional<uint8_t> m_value;

};
/*!
 * @brief This class represents the structure octet_align_2_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class octet_align_2_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport octet_align_2_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~octet_align_2_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object octet_align_2_optional that will be copied.
     */
    eProsima_user_DllExport octet_align_2_optional(
            const octet_align_2_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object octet_align_2_optional that will be copied.
     */
    eProsima_user_DllExport octet_align_2_optional(
            octet_align_2_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object octet_align_2_optional that will be copied.
     */
    eProsima_user_DllExport octet_align_2_optional& operator =(
            const octet_align_2_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object octet_align_2_optional that will be copied.
     */
    eProsima_user_DllExport octet_align_2_optional& operator =(
            octet_align_2_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x octet_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const octet_align_2_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x octet_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const octet_align_2_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint16_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint16_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint16_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<uint8_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<uint8_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<uint8_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<uint8_t>& value()
    {
        return m_value;
    }



private:

    uint16_t m_align{0};
    eprosima::fastcdr::optional<uint8_t> m_value;

};
/*!
 * @brief This class represents the structure octet_align_4_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class octet_align_4_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport octet_align_4_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~octet_align_4_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object octet_align_4_optional that will be copied.
     */
    eProsima_user_DllExport octet_align_4_optional(
            const octet_align_4_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object octet_align_4_optional that will be copied.
     */
    eProsima_user_DllExport octet_align_4_optional(
            octet_align_4_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object octet_align_4_optional that will be copied.
     */
    eProsima_user_DllExport octet_align_4_optional& operator =(
            const octet_align_4_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object octet_align_4_optional that will be copied.
     */
    eProsima_user_DllExport octet_align_4_optional& operator =(
            octet_align_4_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x octet_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const octet_align_4_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x octet_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const octet_align_4_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint32_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint32_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint32_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<uint8_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<uint8_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<uint8_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<uint8_t>& value()
    {
        return m_value;
    }



private:

    uint32_t m_align{0};
    eprosima::fastcdr::optional<uint8_t> m_value;

};
/*!
 * @brief This class represents the structure char_align_1_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class char_align_1_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport char_align_1_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~char_align_1_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object char_align_1_optional that will be copied.
     */
    eProsima_user_DllExport char_align_1_optional(
            const char_align_1_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object char_align_1_optional that will be copied.
     */
    eProsima_user_DllExport char_align_1_optional(
            char_align_1_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object char_align_1_optional that will be copied.
     */
    eProsima_user_DllExport char_align_1_optional& operator =(
            const char_align_1_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object char_align_1_optional that will be copied.
     */
    eProsima_user_DllExport char_align_1_optional& operator =(
            char_align_1_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x char_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const char_align_1_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x char_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const char_align_1_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint8_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint8_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint8_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<char>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<char>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<char>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<char>& value()
    {
        return m_value;
    }



private:

    uint8_t m_align{0};
    eprosima::fastcdr::optional<char> m_value;

};
/*!
 * @brief This class represents the structure char_align_2_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class char_align_2_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport char_align_2_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~char_align_2_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object char_align_2_optional that will be copied.
     */
    eProsima_user_DllExport char_align_2_optional(
            const char_align_2_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object char_align_2_optional that will be copied.
     */
    eProsima_user_DllExport char_align_2_optional(
            char_align_2_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object char_align_2_optional that will be copied.
     */
    eProsima_user_DllExport char_align_2_optional& operator =(
            const char_align_2_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object char_align_2_optional that will be copied.
     */
    eProsima_user_DllExport char_align_2_optional& operator =(
            char_align_2_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x char_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const char_align_2_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x char_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const char_align_2_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint16_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint16_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint16_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<char>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<char>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<char>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<char>& value()
    {
        return m_value;
    }



private:

    uint16_t m_align{0};
    eprosima::fastcdr::optional<char> m_value;

};
/*!
 * @brief This class represents the structure char_align_4_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class char_align_4_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport char_align_4_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~char_align_4_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object char_align_4_optional that will be copied.
     */
    eProsima_user_DllExport char_align_4_optional(
            const char_align_4_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object char_align_4_optional that will be copied.
     */
    eProsima_user_DllExport char_align_4_optional(
            char_align_4_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object char_align_4_optional that will be copied.
     */
    eProsima_user_DllExport char_align_4_optional& operator =(
            const char_align_4_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object char_align_4_optional that will be copied.
     */
    eProsima_user_DllExport char_align_4_optional& operator =(
            char_align_4_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x char_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const char_align_4_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x char_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const char_align_4_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint32_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint32_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint32_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<char>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<char>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<char>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<char>& value()
    {
        return m_value;
    }



private:

    uint32_t m_align{0};
    eprosima::fastcdr::optional<char> m_value;

};
/*!
 * @brief This class represents the structure wchar_align_1_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class wchar_align_1_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport wchar_align_1_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~wchar_align_1_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object wchar_align_1_optional that will be copied.
     */
    eProsima_user_DllExport wchar_align_1_optional(
            const wchar_align_1_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object wchar_align_1_optional that will be copied.
     */
    eProsima_user_DllExport wchar_align_1_optional(
            wchar_align_1_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object wchar_align_1_optional that will be copied.
     */
    eProsima_user_DllExport wchar_align_1_optional& operator =(
            const wchar_align_1_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object wchar_align_1_optional that will be copied.
     */
    eProsima_user_DllExport wchar_align_1_optional& operator =(
            wchar_align_1_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x wchar_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const wchar_align_1_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x wchar_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const wchar_align_1_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint8_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint8_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint8_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<wchar_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<wchar_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<wchar_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<wchar_t>& value()
    {
        return m_value;
    }



private:

    uint8_t m_align{0};
    eprosima::fastcdr::optional<wchar_t> m_value;

};
/*!
 * @brief This class represents the structure wchar_align_2_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class wchar_align_2_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport wchar_align_2_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~wchar_align_2_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object wchar_align_2_optional that will be copied.
     */
    eProsima_user_DllExport wchar_align_2_optional(
            const wchar_align_2_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object wchar_align_2_optional that will be copied.
     */
    eProsima_user_DllExport wchar_align_2_optional(
            wchar_align_2_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object wchar_align_2_optional that will be copied.
     */
    eProsima_user_DllExport wchar_align_2_optional& operator =(
            const wchar_align_2_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object wchar_align_2_optional that will be copied.
     */
    eProsima_user_DllExport wchar_align_2_optional& operator =(
            wchar_align_2_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x wchar_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const wchar_align_2_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x wchar_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const wchar_align_2_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint16_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint16_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint16_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<wchar_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<wchar_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<wchar_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<wchar_t>& value()
    {
        return m_value;
    }



private:

    uint16_t m_align{0};
    eprosima::fastcdr::optional<wchar_t> m_value;

};
/*!
 * @brief This class represents the structure wchar_align_4_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class wchar_align_4_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport wchar_align_4_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~wchar_align_4_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object wchar_align_4_optional that will be copied.
     */
    eProsima_user_DllExport wchar_align_4_optional(
            const wchar_align_4_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object wchar_align_4_optional that will be copied.
     */
    eProsima_user_DllExport wchar_align_4_optional(
            wchar_align_4_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object wchar_align_4_optional that will be copied.
     */
    eProsima_user_DllExport wchar_align_4_optional& operator =(
            const wchar_align_4_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object wchar_align_4_optional that will be copied.
     */
    eProsima_user_DllExport wchar_align_4_optional& operator =(
            wchar_align_4_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x wchar_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const wchar_align_4_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x wchar_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const wchar_align_4_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint32_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint32_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint32_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<wchar_t>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<wchar_t>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<wchar_t>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<wchar_t>& value()
    {
        return m_value;
    }



private:

    uint32_t m_align{0};
    eprosima::fastcdr::optional<wchar_t> m_value;

};
/*!
 * @brief This class represents the structure sequence_short_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class sequence_short_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport sequence_short_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~sequence_short_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object sequence_short_optional that will be copied.
     */
    eProsima_user_DllExport sequence_short_optional(
            const sequence_short_optional& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object sequence_short_optional that will be copied.
     */
    eProsima_user_DllExport sequence_short_optional(
            sequence_short_optional&& x) noexcept
    {
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object sequence_short_optional that will be copied.
     */
    eProsima_user_DllExport sequence_short_optional& operator =(
            const sequence_short_optional& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object sequence_short_optional that will be copied.
     */
    eProsima_user_DllExport sequence_short_optional& operator =(
            sequence_short_optional&& x) noexcept
    {

        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x sequence_short_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const sequence_short_optional& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x sequence_short_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const sequence_short_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<std::vector<int16_t>>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<std::vector<int16_t>>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<std::vector<int16_t>>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<std::vector<int16_t>>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::optional<std::vector<int16_t>> m_value;

};
/*!
 * @brief This class represents the structure sequence_short_align_1_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class sequence_short_align_1_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport sequence_short_align_1_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~sequence_short_align_1_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object sequence_short_align_1_optional that will be copied.
     */
    eProsima_user_DllExport sequence_short_align_1_optional(
            const sequence_short_align_1_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object sequence_short_align_1_optional that will be copied.
     */
    eProsima_user_DllExport sequence_short_align_1_optional(
            sequence_short_align_1_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object sequence_short_align_1_optional that will be copied.
     */
    eProsima_user_DllExport sequence_short_align_1_optional& operator =(
            const sequence_short_align_1_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object sequence_short_align_1_optional that will be copied.
     */
    eProsima_user_DllExport sequence_short_align_1_optional& operator =(
            sequence_short_align_1_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x sequence_short_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const sequence_short_align_1_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x sequence_short_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const sequence_short_align_1_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint8_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint8_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint8_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<std::vector<int16_t>>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<std::vector<int16_t>>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<std::vector<int16_t>>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<std::vector<int16_t>>& value()
    {
        return m_value;
    }



private:

    uint8_t m_align{0};
    eprosima::fastcdr::optional<std::vector<int16_t>> m_value;

};
/*!
 * @brief This class represents the structure sequence_short_align_2_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class sequence_short_align_2_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport sequence_short_align_2_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~sequence_short_align_2_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object sequence_short_align_2_optional that will be copied.
     */
    eProsima_user_DllExport sequence_short_align_2_optional(
            const sequence_short_align_2_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object sequence_short_align_2_optional that will be copied.
     */
    eProsima_user_DllExport sequence_short_align_2_optional(
            sequence_short_align_2_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object sequence_short_align_2_optional that will be copied.
     */
    eProsima_user_DllExport sequence_short_align_2_optional& operator =(
            const sequence_short_align_2_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object sequence_short_align_2_optional that will be copied.
     */
    eProsima_user_DllExport sequence_short_align_2_optional& operator =(
            sequence_short_align_2_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x sequence_short_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const sequence_short_align_2_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x sequence_short_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const sequence_short_align_2_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint16_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint16_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint16_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<std::vector<int16_t>>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<std::vector<int16_t>>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<std::vector<int16_t>>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<std::vector<int16_t>>& value()
    {
        return m_value;
    }



private:

    uint16_t m_align{0};
    eprosima::fastcdr::optional<std::vector<int16_t>> m_value;

};
/*!
 * @brief This class represents the structure sequence_short_align_4_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class sequence_short_align_4_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport sequence_short_align_4_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~sequence_short_align_4_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object sequence_short_align_4_optional that will be copied.
     */
    eProsima_user_DllExport sequence_short_align_4_optional(
            const sequence_short_align_4_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object sequence_short_align_4_optional that will be copied.
     */
    eProsima_user_DllExport sequence_short_align_4_optional(
            sequence_short_align_4_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object sequence_short_align_4_optional that will be copied.
     */
    eProsima_user_DllExport sequence_short_align_4_optional& operator =(
            const sequence_short_align_4_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object sequence_short_align_4_optional that will be copied.
     */
    eProsima_user_DllExport sequence_short_align_4_optional& operator =(
            sequence_short_align_4_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x sequence_short_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const sequence_short_align_4_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x sequence_short_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const sequence_short_align_4_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint32_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint32_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint32_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<std::vector<int16_t>>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<std::vector<int16_t>>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<std::vector<int16_t>>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<std::vector<int16_t>>& value()
    {
        return m_value;
    }



private:

    uint32_t m_align{0};
    eprosima::fastcdr::optional<std::vector<int16_t>> m_value;

};
/*!
 * @brief This class represents the structure string_unbounded_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class string_unbounded_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport string_unbounded_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~string_unbounded_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object string_unbounded_optional that will be copied.
     */
    eProsima_user_DllExport string_unbounded_optional(
            const string_unbounded_optional& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object string_unbounded_optional that will be copied.
     */
    eProsima_user_DllExport string_unbounded_optional(
            string_unbounded_optional&& x) noexcept
    {
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object string_unbounded_optional that will be copied.
     */
    eProsima_user_DllExport string_unbounded_optional& operator =(
            const string_unbounded_optional& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object string_unbounded_optional that will be copied.
     */
    eProsima_user_DllExport string_unbounded_optional& operator =(
            string_unbounded_optional&& x) noexcept
    {

        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x string_unbounded_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const string_unbounded_optional& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x string_unbounded_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const string_unbounded_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<std::string>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<std::string>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<std::string>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<std::string>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::optional<std::string> m_value;

};
/*!
 * @brief This class represents the structure string_unbounded_align_1_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class string_unbounded_align_1_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport string_unbounded_align_1_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~string_unbounded_align_1_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object string_unbounded_align_1_optional that will be copied.
     */
    eProsima_user_DllExport string_unbounded_align_1_optional(
            const string_unbounded_align_1_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object string_unbounded_align_1_optional that will be copied.
     */
    eProsima_user_DllExport string_unbounded_align_1_optional(
            string_unbounded_align_1_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object string_unbounded_align_1_optional that will be copied.
     */
    eProsima_user_DllExport string_unbounded_align_1_optional& operator =(
            const string_unbounded_align_1_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object string_unbounded_align_1_optional that will be copied.
     */
    eProsima_user_DllExport string_unbounded_align_1_optional& operator =(
            string_unbounded_align_1_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x string_unbounded_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const string_unbounded_align_1_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x string_unbounded_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const string_unbounded_align_1_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint8_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint8_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint8_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<std::string>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<std::string>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<std::string>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<std::string>& value()
    {
        return m_value;
    }



private:

    uint8_t m_align{0};
    eprosima::fastcdr::optional<std::string> m_value;

};
/*!
 * @brief This class represents the structure string_unbounded_align_2_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class string_unbounded_align_2_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport string_unbounded_align_2_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~string_unbounded_align_2_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object string_unbounded_align_2_optional that will be copied.
     */
    eProsima_user_DllExport string_unbounded_align_2_optional(
            const string_unbounded_align_2_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object string_unbounded_align_2_optional that will be copied.
     */
    eProsima_user_DllExport string_unbounded_align_2_optional(
            string_unbounded_align_2_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object string_unbounded_align_2_optional that will be copied.
     */
    eProsima_user_DllExport string_unbounded_align_2_optional& operator =(
            const string_unbounded_align_2_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object string_unbounded_align_2_optional that will be copied.
     */
    eProsima_user_DllExport string_unbounded_align_2_optional& operator =(
            string_unbounded_align_2_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x string_unbounded_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const string_unbounded_align_2_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x string_unbounded_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const string_unbounded_align_2_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint16_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint16_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint16_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<std::string>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<std::string>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<std::string>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<std::string>& value()
    {
        return m_value;
    }



private:

    uint16_t m_align{0};
    eprosima::fastcdr::optional<std::string> m_value;

};
/*!
 * @brief This class represents the structure string_unbounded_align_4_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class string_unbounded_align_4_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport string_unbounded_align_4_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~string_unbounded_align_4_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object string_unbounded_align_4_optional that will be copied.
     */
    eProsima_user_DllExport string_unbounded_align_4_optional(
            const string_unbounded_align_4_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object string_unbounded_align_4_optional that will be copied.
     */
    eProsima_user_DllExport string_unbounded_align_4_optional(
            string_unbounded_align_4_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object string_unbounded_align_4_optional that will be copied.
     */
    eProsima_user_DllExport string_unbounded_align_4_optional& operator =(
            const string_unbounded_align_4_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object string_unbounded_align_4_optional that will be copied.
     */
    eProsima_user_DllExport string_unbounded_align_4_optional& operator =(
            string_unbounded_align_4_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x string_unbounded_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const string_unbounded_align_4_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x string_unbounded_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const string_unbounded_align_4_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint32_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint32_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint32_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<std::string>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<std::string>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<std::string>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<std::string>& value()
    {
        return m_value;
    }



private:

    uint32_t m_align{0};
    eprosima::fastcdr::optional<std::string> m_value;

};
/*!
 * @brief This class represents the structure string_bounded_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class string_bounded_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport string_bounded_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~string_bounded_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object string_bounded_optional that will be copied.
     */
    eProsima_user_DllExport string_bounded_optional(
            const string_bounded_optional& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object string_bounded_optional that will be copied.
     */
    eProsima_user_DllExport string_bounded_optional(
            string_bounded_optional&& x) noexcept
    {
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object string_bounded_optional that will be copied.
     */
    eProsima_user_DllExport string_bounded_optional& operator =(
            const string_bounded_optional& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object string_bounded_optional that will be copied.
     */
    eProsima_user_DllExport string_bounded_optional& operator =(
            string_bounded_optional&& x) noexcept
    {

        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x string_bounded_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const string_bounded_optional& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x string_bounded_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const string_bounded_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<eprosima::fastcdr::fixed_string<8>>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<eprosima::fastcdr::fixed_string<8>>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<eprosima::fastcdr::fixed_string<8>>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<eprosima::fastcdr::fixed_string<8>>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::optional<eprosima::fastcdr::fixed_string<8>> m_value;

};
/*!
 * @brief This class represents the structure string_bounded_align_1_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class string_bounded_align_1_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport string_bounded_align_1_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~string_bounded_align_1_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object string_bounded_align_1_optional that will be copied.
     */
    eProsima_user_DllExport string_bounded_align_1_optional(
            const string_bounded_align_1_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object string_bounded_align_1_optional that will be copied.
     */
    eProsima_user_DllExport string_bounded_align_1_optional(
            string_bounded_align_1_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object string_bounded_align_1_optional that will be copied.
     */
    eProsima_user_DllExport string_bounded_align_1_optional& operator =(
            const string_bounded_align_1_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object string_bounded_align_1_optional that will be copied.
     */
    eProsima_user_DllExport string_bounded_align_1_optional& operator =(
            string_bounded_align_1_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x string_bounded_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const string_bounded_align_1_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x string_bounded_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const string_bounded_align_1_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint8_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint8_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint8_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<eprosima::fastcdr::fixed_string<8>>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<eprosima::fastcdr::fixed_string<8>>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<eprosima::fastcdr::fixed_string<8>>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<eprosima::fastcdr::fixed_string<8>>& value()
    {
        return m_value;
    }



private:

    uint8_t m_align{0};
    eprosima::fastcdr::optional<eprosima::fastcdr::fixed_string<8>> m_value;

};
/*!
 * @brief This class represents the structure string_bounded_align_2_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class string_bounded_align_2_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport string_bounded_align_2_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~string_bounded_align_2_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object string_bounded_align_2_optional that will be copied.
     */
    eProsima_user_DllExport string_bounded_align_2_optional(
            const string_bounded_align_2_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object string_bounded_align_2_optional that will be copied.
     */
    eProsima_user_DllExport string_bounded_align_2_optional(
            string_bounded_align_2_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object string_bounded_align_2_optional that will be copied.
     */
    eProsima_user_DllExport string_bounded_align_2_optional& operator =(
            const string_bounded_align_2_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object string_bounded_align_2_optional that will be copied.
     */
    eProsima_user_DllExport string_bounded_align_2_optional& operator =(
            string_bounded_align_2_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x string_bounded_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const string_bounded_align_2_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x string_bounded_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const string_bounded_align_2_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint16_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint16_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint16_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<eprosima::fastcdr::fixed_string<8>>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<eprosima::fastcdr::fixed_string<8>>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<eprosima::fastcdr::fixed_string<8>>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<eprosima::fastcdr::fixed_string<8>>& value()
    {
        return m_value;
    }



private:

    uint16_t m_align{0};
    eprosima::fastcdr::optional<eprosima::fastcdr::fixed_string<8>> m_value;

};
/*!
 * @brief This class represents the structure string_bounded_align_4_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class string_bounded_align_4_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport string_bounded_align_4_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~string_bounded_align_4_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object string_bounded_align_4_optional that will be copied.
     */
    eProsima_user_DllExport string_bounded_align_4_optional(
            const string_bounded_align_4_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object string_bounded_align_4_optional that will be copied.
     */
    eProsima_user_DllExport string_bounded_align_4_optional(
            string_bounded_align_4_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object string_bounded_align_4_optional that will be copied.
     */
    eProsima_user_DllExport string_bounded_align_4_optional& operator =(
            const string_bounded_align_4_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object string_bounded_align_4_optional that will be copied.
     */
    eProsima_user_DllExport string_bounded_align_4_optional& operator =(
            string_bounded_align_4_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x string_bounded_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const string_bounded_align_4_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x string_bounded_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const string_bounded_align_4_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint32_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint32_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint32_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<eprosima::fastcdr::fixed_string<8>>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<eprosima::fastcdr::fixed_string<8>>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<eprosima::fastcdr::fixed_string<8>>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<eprosima::fastcdr::fixed_string<8>>& value()
    {
        return m_value;
    }



private:

    uint32_t m_align{0};
    eprosima::fastcdr::optional<eprosima::fastcdr::fixed_string<8>> m_value;

};
/*!
 * @brief This class represents the structure map_short_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class map_short_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport map_short_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~map_short_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object map_short_optional that will be copied.
     */
    eProsima_user_DllExport map_short_optional(
            const map_short_optional& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object map_short_optional that will be copied.
     */
    eProsima_user_DllExport map_short_optional(
            map_short_optional&& x) noexcept
    {
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object map_short_optional that will be copied.
     */
    eProsima_user_DllExport map_short_optional& operator =(
            const map_short_optional& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object map_short_optional that will be copied.
     */
    eProsima_user_DllExport map_short_optional& operator =(
            map_short_optional&& x) noexcept
    {

        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x map_short_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const map_short_optional& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x map_short_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const map_short_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<std::map<int32_t, int16_t>>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<std::map<int32_t, int16_t>>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<std::map<int32_t, int16_t>>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<std::map<int32_t, int16_t>>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::optional<std::map<int32_t, int16_t>> m_value;

};
/*!
 * @brief This class represents the structure map_short_align_1_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class map_short_align_1_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport map_short_align_1_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~map_short_align_1_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object map_short_align_1_optional that will be copied.
     */
    eProsima_user_DllExport map_short_align_1_optional(
            const map_short_align_1_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object map_short_align_1_optional that will be copied.
     */
    eProsima_user_DllExport map_short_align_1_optional(
            map_short_align_1_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object map_short_align_1_optional that will be copied.
     */
    eProsima_user_DllExport map_short_align_1_optional& operator =(
            const map_short_align_1_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object map_short_align_1_optional that will be copied.
     */
    eProsima_user_DllExport map_short_align_1_optional& operator =(
            map_short_align_1_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x map_short_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const map_short_align_1_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x map_short_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const map_short_align_1_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint8_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint8_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint8_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<std::map<int32_t, int16_t>>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<std::map<int32_t, int16_t>>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<std::map<int32_t, int16_t>>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<std::map<int32_t, int16_t>>& value()
    {
        return m_value;
    }



private:

    uint8_t m_align{0};
    eprosima::fastcdr::optional<std::map<int32_t, int16_t>> m_value;

};
/*!
 * @brief This class represents the structure map_short_align_2_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class map_short_align_2_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport map_short_align_2_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~map_short_align_2_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object map_short_align_2_optional that will be copied.
     */
    eProsima_user_DllExport map_short_align_2_optional(
            const map_short_align_2_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object map_short_align_2_optional that will be copied.
     */
    eProsima_user_DllExport map_short_align_2_optional(
            map_short_align_2_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object map_short_align_2_optional that will be copied.
     */
    eProsima_user_DllExport map_short_align_2_optional& operator =(
            const map_short_align_2_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object map_short_align_2_optional that will be copied.
     */
    eProsima_user_DllExport map_short_align_2_optional& operator =(
            map_short_align_2_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x map_short_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const map_short_align_2_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x map_short_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const map_short_align_2_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint16_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint16_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint16_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<std::map<int32_t, int16_t>>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<std::map<int32_t, int16_t>>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<std::map<int32_t, int16_t>>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<std::map<int32_t, int16_t>>& value()
    {
        return m_value;
    }



private:

    uint16_t m_align{0};
    eprosima::fastcdr::optional<std::map<int32_t, int16_t>> m_value;

};
/*!
 * @brief This class represents the structure map_short_align_4_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class map_short_align_4_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport map_short_align_4_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~map_short_align_4_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object map_short_align_4_optional that will be copied.
     */
    eProsima_user_DllExport map_short_align_4_optional(
            const map_short_align_4_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object map_short_align_4_optional that will be copied.
     */
    eProsima_user_DllExport map_short_align_4_optional(
            map_short_align_4_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object map_short_align_4_optional that will be copied.
     */
    eProsima_user_DllExport map_short_align_4_optional& operator =(
            const map_short_align_4_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object map_short_align_4_optional that will be copied.
     */
    eProsima_user_DllExport map_short_align_4_optional& operator =(
            map_short_align_4_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x map_short_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const map_short_align_4_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x map_short_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const map_short_align_4_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint32_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint32_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint32_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<std::map<int32_t, int16_t>>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<std::map<int32_t, int16_t>>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<std::map<int32_t, int16_t>>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<std::map<int32_t, int16_t>>& value()
    {
        return m_value;
    }



private:

    uint32_t m_align{0};
    eprosima::fastcdr::optional<std::map<int32_t, int16_t>> m_value;

};
/*!
 * @brief This class represents the structure array_short_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class array_short_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport array_short_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~array_short_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object array_short_optional that will be copied.
     */
    eProsima_user_DllExport array_short_optional(
            const array_short_optional& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object array_short_optional that will be copied.
     */
    eProsima_user_DllExport array_short_optional(
            array_short_optional&& x) noexcept
    {
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object array_short_optional that will be copied.
     */
    eProsima_user_DllExport array_short_optional& operator =(
            const array_short_optional& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object array_short_optional that will be copied.
     */
    eProsima_user_DllExport array_short_optional& operator =(
            array_short_optional&& x) noexcept
    {

        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x array_short_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const array_short_optional& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x array_short_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const array_short_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<std::array<int16_t, 10>>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<std::array<int16_t, 10>>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<std::array<int16_t, 10>>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<std::array<int16_t, 10>>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::optional<std::array<int16_t, 10>> m_value;

};
/*!
 * @brief This class represents the structure array_short_align_1_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class array_short_align_1_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport array_short_align_1_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~array_short_align_1_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object array_short_align_1_optional that will be copied.
     */
    eProsima_user_DllExport array_short_align_1_optional(
            const array_short_align_1_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object array_short_align_1_optional that will be copied.
     */
    eProsima_user_DllExport array_short_align_1_optional(
            array_short_align_1_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object array_short_align_1_optional that will be copied.
     */
    eProsima_user_DllExport array_short_align_1_optional& operator =(
            const array_short_align_1_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object array_short_align_1_optional that will be copied.
     */
    eProsima_user_DllExport array_short_align_1_optional& operator =(
            array_short_align_1_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x array_short_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const array_short_align_1_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x array_short_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const array_short_align_1_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint8_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint8_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint8_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<std::array<int16_t, 10>>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<std::array<int16_t, 10>>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<std::array<int16_t, 10>>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<std::array<int16_t, 10>>& value()
    {
        return m_value;
    }



private:

    uint8_t m_align{0};
    eprosima::fastcdr::optional<std::array<int16_t, 10>> m_value;

};
/*!
 * @brief This class represents the structure array_short_align_2_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class array_short_align_2_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport array_short_align_2_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~array_short_align_2_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object array_short_align_2_optional that will be copied.
     */
    eProsima_user_DllExport array_short_align_2_optional(
            const array_short_align_2_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object array_short_align_2_optional that will be copied.
     */
    eProsima_user_DllExport array_short_align_2_optional(
            array_short_align_2_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object array_short_align_2_optional that will be copied.
     */
    eProsima_user_DllExport array_short_align_2_optional& operator =(
            const array_short_align_2_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object array_short_align_2_optional that will be copied.
     */
    eProsima_user_DllExport array_short_align_2_optional& operator =(
            array_short_align_2_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x array_short_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const array_short_align_2_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x array_short_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const array_short_align_2_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint16_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint16_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint16_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<std::array<int16_t, 10>>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<std::array<int16_t, 10>>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<std::array<int16_t, 10>>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<std::array<int16_t, 10>>& value()
    {
        return m_value;
    }



private:

    uint16_t m_align{0};
    eprosima::fastcdr::optional<std::array<int16_t, 10>> m_value;

};
/*!
 * @brief This class represents the structure array_short_align_4_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class array_short_align_4_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport array_short_align_4_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~array_short_align_4_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object array_short_align_4_optional that will be copied.
     */
    eProsima_user_DllExport array_short_align_4_optional(
            const array_short_align_4_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object array_short_align_4_optional that will be copied.
     */
    eProsima_user_DllExport array_short_align_4_optional(
            array_short_align_4_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object array_short_align_4_optional that will be copied.
     */
    eProsima_user_DllExport array_short_align_4_optional& operator =(
            const array_short_align_4_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object array_short_align_4_optional that will be copied.
     */
    eProsima_user_DllExport array_short_align_4_optional& operator =(
            array_short_align_4_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x array_short_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const array_short_align_4_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x array_short_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const array_short_align_4_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint32_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint32_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint32_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<std::array<int16_t, 10>>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<std::array<int16_t, 10>>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<std::array<int16_t, 10>>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<std::array<int16_t, 10>>& value()
    {
        return m_value;
    }



private:

    uint32_t m_align{0};
    eprosima::fastcdr::optional<std::array<int16_t, 10>> m_value;

};
/*!
 * @brief This class represents the structure struct_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class struct_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport struct_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~struct_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object struct_optional that will be copied.
     */
    eProsima_user_DllExport struct_optional(
            const struct_optional& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object struct_optional that will be copied.
     */
    eProsima_user_DllExport struct_optional(
            struct_optional&& x) noexcept
    {
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object struct_optional that will be copied.
     */
    eProsima_user_DllExport struct_optional& operator =(
            const struct_optional& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object struct_optional that will be copied.
     */
    eProsima_user_DllExport struct_optional& operator =(
            struct_optional&& x) noexcept
    {

        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x struct_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const struct_optional& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x struct_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const struct_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<InnerStructureHelper>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<InnerStructureHelper>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<InnerStructureHelper>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<InnerStructureHelper>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::optional<InnerStructureHelper> m_value;

};
/*!
 * @brief This class represents the structure struct_align_1_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class struct_align_1_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport struct_align_1_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~struct_align_1_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object struct_align_1_optional that will be copied.
     */
    eProsima_user_DllExport struct_align_1_optional(
            const struct_align_1_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object struct_align_1_optional that will be copied.
     */
    eProsima_user_DllExport struct_align_1_optional(
            struct_align_1_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object struct_align_1_optional that will be copied.
     */
    eProsima_user_DllExport struct_align_1_optional& operator =(
            const struct_align_1_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object struct_align_1_optional that will be copied.
     */
    eProsima_user_DllExport struct_align_1_optional& operator =(
            struct_align_1_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x struct_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const struct_align_1_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x struct_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const struct_align_1_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint8_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint8_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint8_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<InnerStructureHelper>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<InnerStructureHelper>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<InnerStructureHelper>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<InnerStructureHelper>& value()
    {
        return m_value;
    }



private:

    uint8_t m_align{0};
    eprosima::fastcdr::optional<InnerStructureHelper> m_value;

};
/*!
 * @brief This class represents the structure struct_align_2_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class struct_align_2_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport struct_align_2_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~struct_align_2_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object struct_align_2_optional that will be copied.
     */
    eProsima_user_DllExport struct_align_2_optional(
            const struct_align_2_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object struct_align_2_optional that will be copied.
     */
    eProsima_user_DllExport struct_align_2_optional(
            struct_align_2_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object struct_align_2_optional that will be copied.
     */
    eProsima_user_DllExport struct_align_2_optional& operator =(
            const struct_align_2_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object struct_align_2_optional that will be copied.
     */
    eProsima_user_DllExport struct_align_2_optional& operator =(
            struct_align_2_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x struct_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const struct_align_2_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x struct_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const struct_align_2_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint16_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint16_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint16_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<InnerStructureHelper>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<InnerStructureHelper>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<InnerStructureHelper>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<InnerStructureHelper>& value()
    {
        return m_value;
    }



private:

    uint16_t m_align{0};
    eprosima::fastcdr::optional<InnerStructureHelper> m_value;

};
/*!
 * @brief This class represents the structure struct_align_4_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class struct_align_4_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport struct_align_4_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~struct_align_4_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object struct_align_4_optional that will be copied.
     */
    eProsima_user_DllExport struct_align_4_optional(
            const struct_align_4_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object struct_align_4_optional that will be copied.
     */
    eProsima_user_DllExport struct_align_4_optional(
            struct_align_4_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object struct_align_4_optional that will be copied.
     */
    eProsima_user_DllExport struct_align_4_optional& operator =(
            const struct_align_4_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object struct_align_4_optional that will be copied.
     */
    eProsima_user_DllExport struct_align_4_optional& operator =(
            struct_align_4_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x struct_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const struct_align_4_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x struct_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const struct_align_4_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint32_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint32_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint32_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<InnerStructureHelper>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<InnerStructureHelper>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<InnerStructureHelper>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<InnerStructureHelper>& value()
    {
        return m_value;
    }



private:

    uint32_t m_align{0};
    eprosima::fastcdr::optional<InnerStructureHelper> m_value;

};
/*!
 * @brief This class represents the structure InnerStructOptional defined by the user in the IDL file.
 * @ingroup optional
 */
class InnerStructOptional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport InnerStructOptional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~InnerStructOptional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object InnerStructOptional that will be copied.
     */
    eProsima_user_DllExport InnerStructOptional(
            const InnerStructOptional& x)
    {
                    m_s = x.m_s;

                    m_l = x.m_l;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object InnerStructOptional that will be copied.
     */
    eProsima_user_DllExport InnerStructOptional(
            InnerStructOptional&& x) noexcept
    {
        m_s = x.m_s;
        m_l = x.m_l;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object InnerStructOptional that will be copied.
     */
    eProsima_user_DllExport InnerStructOptional& operator =(
            const InnerStructOptional& x)
    {

                    m_s = x.m_s;

                    m_l = x.m_l;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object InnerStructOptional that will be copied.
     */
    eProsima_user_DllExport InnerStructOptional& operator =(
            InnerStructOptional&& x) noexcept
    {

        m_s = x.m_s;
        m_l = x.m_l;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x InnerStructOptional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const InnerStructOptional& x) const
    {
        return (m_s == x.m_s &&
           m_l == x.m_l);
    }

    /*!
     * @brief Comparison operator.
     * @param x InnerStructOptional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const InnerStructOptional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member s
     * @param _s New value for member s
     */
    eProsima_user_DllExport void s(
            int16_t _s)
    {
        m_s = _s;
    }

    /*!
     * @brief This function returns the value of member s
     * @return Value of member s
     */
    eProsima_user_DllExport int16_t s() const
    {
        return m_s;
    }

    /*!
     * @brief This function returns a reference to member s
     * @return Reference to member s
     */
    eProsima_user_DllExport int16_t& s()
    {
        return m_s;
    }


    /*!
     * @brief This function copies the value in member l
     * @param _l New value to be copied in member l
     */
    eProsima_user_DllExport void l(
            const eprosima::fastcdr::optional<int32_t>& _l)
    {
        m_l = _l;
    }

    /*!
     * @brief This function moves the value in member l
     * @param _l New value to be moved in member l
     */
    eProsima_user_DllExport void l(
            eprosima::fastcdr::optional<int32_t>&& _l)
    {
        m_l = std::move(_l);
    }

    /*!
     * @brief This function returns a constant reference to member l
     * @return Constant reference to member l
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<int32_t>& l() const
    {
        return m_l;
    }

    /*!
     * @brief This function returns a reference to member l
     * @return Reference to member l
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<int32_t>& l()
    {
        return m_l;
    }



private:

    int16_t m_s{0};
    eprosima::fastcdr::optional<int32_t> m_l;

};
/*!
 * @brief This class represents the structure opt_struct_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class opt_struct_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport opt_struct_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~opt_struct_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object opt_struct_optional that will be copied.
     */
    eProsima_user_DllExport opt_struct_optional(
            const opt_struct_optional& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object opt_struct_optional that will be copied.
     */
    eProsima_user_DllExport opt_struct_optional(
            opt_struct_optional&& x) noexcept
    {
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object opt_struct_optional that will be copied.
     */
    eProsima_user_DllExport opt_struct_optional& operator =(
            const opt_struct_optional& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object opt_struct_optional that will be copied.
     */
    eProsima_user_DllExport opt_struct_optional& operator =(
            opt_struct_optional&& x) noexcept
    {

        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x opt_struct_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const opt_struct_optional& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x opt_struct_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const opt_struct_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<InnerStructOptional>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<InnerStructOptional>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<InnerStructOptional>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<InnerStructOptional>& value()
    {
        return m_value;
    }



private:

    eprosima::fastcdr::optional<InnerStructOptional> m_value;

};
/*!
 * @brief This class represents the structure opt_struct_align_1_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class opt_struct_align_1_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport opt_struct_align_1_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~opt_struct_align_1_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object opt_struct_align_1_optional that will be copied.
     */
    eProsima_user_DllExport opt_struct_align_1_optional(
            const opt_struct_align_1_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object opt_struct_align_1_optional that will be copied.
     */
    eProsima_user_DllExport opt_struct_align_1_optional(
            opt_struct_align_1_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object opt_struct_align_1_optional that will be copied.
     */
    eProsima_user_DllExport opt_struct_align_1_optional& operator =(
            const opt_struct_align_1_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object opt_struct_align_1_optional that will be copied.
     */
    eProsima_user_DllExport opt_struct_align_1_optional& operator =(
            opt_struct_align_1_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x opt_struct_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const opt_struct_align_1_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x opt_struct_align_1_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const opt_struct_align_1_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint8_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint8_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint8_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<InnerStructOptional>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<InnerStructOptional>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<InnerStructOptional>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<InnerStructOptional>& value()
    {
        return m_value;
    }



private:

    uint8_t m_align{0};
    eprosima::fastcdr::optional<InnerStructOptional> m_value;

};
/*!
 * @brief This class represents the structure opt_struct_align_2_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class opt_struct_align_2_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport opt_struct_align_2_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~opt_struct_align_2_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object opt_struct_align_2_optional that will be copied.
     */
    eProsima_user_DllExport opt_struct_align_2_optional(
            const opt_struct_align_2_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object opt_struct_align_2_optional that will be copied.
     */
    eProsima_user_DllExport opt_struct_align_2_optional(
            opt_struct_align_2_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object opt_struct_align_2_optional that will be copied.
     */
    eProsima_user_DllExport opt_struct_align_2_optional& operator =(
            const opt_struct_align_2_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object opt_struct_align_2_optional that will be copied.
     */
    eProsima_user_DllExport opt_struct_align_2_optional& operator =(
            opt_struct_align_2_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x opt_struct_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const opt_struct_align_2_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x opt_struct_align_2_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const opt_struct_align_2_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint16_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint16_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint16_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<InnerStructOptional>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<InnerStructOptional>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<InnerStructOptional>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<InnerStructOptional>& value()
    {
        return m_value;
    }



private:

    uint16_t m_align{0};
    eprosima::fastcdr::optional<InnerStructOptional> m_value;

};
/*!
 * @brief This class represents the structure opt_struct_align_4_optional defined by the user in the IDL file.
 * @ingroup optional
 */
class opt_struct_align_4_optional
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport opt_struct_align_4_optional()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~opt_struct_align_4_optional()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object opt_struct_align_4_optional that will be copied.
     */
    eProsima_user_DllExport opt_struct_align_4_optional(
            const opt_struct_align_4_optional& x)
    {
                    m_align = x.m_align;

                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object opt_struct_align_4_optional that will be copied.
     */
    eProsima_user_DllExport opt_struct_align_4_optional(
            opt_struct_align_4_optional&& x) noexcept
    {
        m_align = x.m_align;
        m_value = std::move(x.m_value);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object opt_struct_align_4_optional that will be copied.
     */
    eProsima_user_DllExport opt_struct_align_4_optional& operator =(
            const opt_struct_align_4_optional& x)
    {

                    m_align = x.m_align;

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object opt_struct_align_4_optional that will be copied.
     */
    eProsima_user_DllExport opt_struct_align_4_optional& operator =(
            opt_struct_align_4_optional&& x) noexcept
    {

        m_align = x.m_align;
        m_value = std::move(x.m_value);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x opt_struct_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const opt_struct_align_4_optional& x) const
    {
        return (m_align == x.m_align &&
           m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x opt_struct_align_4_optional object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const opt_struct_align_4_optional& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member align
     * @param _align New value for member align
     */
    eProsima_user_DllExport void align(
            uint32_t _align)
    {
        m_align = _align;
    }

    /*!
     * @brief This function returns the value of member align
     * @return Value of member align
     */
    eProsima_user_DllExport uint32_t align() const
    {
        return m_align;
    }

    /*!
     * @brief This function returns a reference to member align
     * @return Reference to member align
     */
    eProsima_user_DllExport uint32_t& align()
    {
        return m_align;
    }


    /*!
     * @brief This function copies the value in member value
     * @param _value New value to be copied in member value
     */
    eProsima_user_DllExport void value(
            const eprosima::fastcdr::optional<InnerStructOptional>& _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function moves the value in member value
     * @param _value New value to be moved in member value
     */
    eProsima_user_DllExport void value(
            eprosima::fastcdr::optional<InnerStructOptional>&& _value)
    {
        m_value = std::move(_value);
    }

    /*!
     * @brief This function returns a constant reference to member value
     * @return Constant reference to member value
     */
    eProsima_user_DllExport const eprosima::fastcdr::optional<InnerStructOptional>& value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport eprosima::fastcdr::optional<InnerStructOptional>& value()
    {
        return m_value;
    }



private:

    uint32_t m_align{0};
    eprosima::fastcdr::optional<InnerStructOptional> m_value;

};

#endif // _FAST_DDS_GENERATED_OPTIONAL_HPP_


