/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.maven.doxia.siterenderer;

import java.io.File;

import org.codehaus.plexus.util.FileUtils;

import static org.junit.jupiter.api.Assertions.assertTrue;

/**
 * Verifies that there are no DOXIASITETOOLS-146 comments
 */
public class CommentsVerifier extends AbstractVerifier {
    /** {@inheritDoc} */
    public void verify(String file) throws Exception {
        String content = FileUtils.fileRead(new File(file), "UTF-8");

        assertTrue(
                content.indexOf("DOXIASITETOOLS-146") < 0,
                file + " should not contain 'DOXIASITETOOLS-146' text in comments");
    }
}
