/*
 * Decompiled with CFR 0.152.
 */
package com.sittinglittleduck.DirBuster.gui;

import com.sittinglittleduck.DirBuster.Manager;
import com.sittinglittleduck.DirBuster.workGenerators.MultiThreadedGenerator;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;

public class JPanelScanInfo
extends JPanel {
    private int id;
    private Manager manager = Manager.getInstance();
    private MultiThreadedGenerator gen;
    private int type;
    private JButton jButtonStop;
    private JLabel jLabelText;
    private JProgressBar jProgressBar1;
    private JSeparator jSeparator1;
    private JToggleButton jToggleButtonPause;

    public JPanelScanInfo(int ThreadId, int type) {
        this.type = type;
        this.id = ThreadId;
        this.initComponents();
        if (type == 0) {
            this.gen = this.manager.genThreads.elementAt(this.id);
            this.jProgressBar1.setMaximum((int)this.manager.getTotalPass());
            if (this.gen.getType() == 0) {
                this.jLabelText.setText("Testing for dirs in " + this.gen.getStartpoint());
            } else if (this.gen.getType() == 1) {
                String ext = "extention " + this.gen.getFileExt();
                if (this.gen.getFileExt().equals("")) {
                    ext = "no extention";
                }
                this.jLabelText.setText("Testing for files in " + this.gen.getStartpoint() + " with " + ext);
            }
        } else if (type == 2) {
            this.gen = this.manager.genThreads.elementAt(this.id);
            this.jProgressBar1.setMaximum((int)this.manager.getTotalPass());
            if (this.gen.getType() == 0) {
                this.jLabelText.setText("Brute forcing dirs in " + this.gen.getStartpoint());
            } else if (this.gen.getType() == 1) {
                String ext = "extention " + this.gen.getFileExt();
                if (this.gen.getFileExt().equals("")) {
                    ext = "no extention";
                }
                this.jLabelText.setText("Brute forcing files in " + this.gen.getStartpoint() + " with " + ext);
            }
        } else if (type == 1) {
            this.jButtonStop.setEnabled(false);
            this.jToggleButtonPause.setEnabled(false);
            this.jLabelText.setText("List based fuzzing: " + this.manager.workGenFuzz.getStartPoint());
        } else if (type == 3) {
            this.jButtonStop.setEnabled(false);
            this.jToggleButtonPause.setEnabled(false);
            this.jLabelText.setText("Brute force fuzzing: " + this.manager.workGenBruteFuzz.getStartPoint());
        }
    }

    public void setProgressMax(int max) {
        this.jProgressBar1.setMaximum(max);
    }

    public void setProgressText(String text) {
        this.jProgressBar1.setString(text);
    }

    public void setProgressCurrentValue(int value) {
        this.jProgressBar1.setMaximum((int)this.manager.getTotalPass());
        boolean working = true;
        boolean paused = false;
        if (this.type == 0) {
            working = this.gen.isWorking();
            paused = this.gen.isPaused();
        } else if (this.type == 1) {
            working = this.manager.workGenFuzz.isWorking();
            paused = false;
        } else if (this.type != 2 && this.type == 3) {
            working = this.manager.workGenBruteFuzz.isWorking();
            paused = false;
        }
        if (!working) {
            this.jProgressBar1.setMaximum((int)this.manager.getTotalPass());
            this.jProgressBar1.setValue((int)this.manager.getTotalPass());
            this.jProgressBar1.setString("Complete");
            return;
        }
        if (value == -1) {
            this.jProgressBar1.setValue((int)this.manager.getTotalPass());
            this.jProgressBar1.setString("Complete");
        } else {
            this.jProgressBar1.setValue(value);
            if (paused) {
                this.jProgressBar1.setString("Paused");
            } else {
                int percent = (int)((double)value / this.manager.getTotalPass() * 100.0);
                this.jProgressBar1.setString(percent + "%");
            }
        }
    }

    private void initComponents() {
        this.jLabelText = new JLabel();
        this.jProgressBar1 = new JProgressBar();
        this.jToggleButtonPause = new JToggleButton();
        this.jButtonStop = new JButton();
        this.jSeparator1 = new JSeparator();
        this.setBackground(new Color(255, 255, 255));
        this.setBorder(BorderFactory.createEmptyBorder(5, 1, 1, 1));
        this.jLabelText.setText("jLabel1");
        this.jProgressBar1.setStringPainted(true);
        this.jToggleButtonPause.setIcon(new ImageIcon(this.getClass().getResource("/com/sittinglittleduck/DirBuster/gui/icons/media-playback-pause.png")));
        this.jToggleButtonPause.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPanelScanInfo.this.jToggleButtonPauseActionPerformed(evt);
            }
        });
        this.jButtonStop.setIcon(new ImageIcon(this.getClass().getResource("/com/sittinglittleduck/DirBuster/gui/icons/media-playback-stop.png")));
        this.jButtonStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPanelScanInfo.this.jButtonStopActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jSeparator1, -1, 493, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.jLabelText, -1, 250, Short.MAX_VALUE).addGap(10, 10, 10).addComponent(this.jProgressBar1, -2, -1, -2).addGap(22, 22, 22).addComponent(this.jToggleButtonPause, -2, 30, -2).addGap(10, 10, 10).addComponent(this.jButtonStop, -2, 30, -2).addGap(15, 15, 15)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelText).addComponent(this.jProgressBar1, -2, 20, -2).addComponent(this.jToggleButtonPause, -2, 20, -2).addComponent(this.jButtonStop, -2, 20, -2)).addGap(8, 8, 8).addComponent(this.jSeparator1, -2, -1, -2)));
    }

    private void jToggleButtonPauseActionPerformed(ActionEvent evt) {
        if (this.jToggleButtonPause.isSelected()) {
            this.manager.pauseWorkGen(this.id);
        } else {
            this.manager.unPauseWorkGen(this.id);
        }
    }

    private void jButtonStopActionPerformed(ActionEvent evt) {
        int n = -1;
        n = this.gen.getType() == 0 ? JOptionPane.showConfirmDialog(this.manager.gui, "Are you sure you wish to stop scanning for dirs in:\n" + this.gen.getStartpoint(), "Are you sure?", 0) : JOptionPane.showConfirmDialog(this.manager.gui, "Are you sure you wish to stop scanning for files with extention " + this.gen.getFileExt() + " in:\n" + this.gen.getStartpoint(), "Are you sure?", 0);
        if (n == 0) {
            this.manager.genThreads.elementAt(this.id).stopMe();
        }
    }
}

