window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = {"version": "0.9.5", "fields": ["qualname", "fullname", "annotation", "default_value", "signature", "bases", "doc"], "ref": "fullname", "documentStore": {"docs": {"coercer": {"fullname": "coercer", "modulename": "coercer", "kind": "module", "doc": "<p></p>\n"}, "coercer.core": {"fullname": "coercer.core", "modulename": "coercer.core", "kind": "module", "doc": "<p></p>\n"}, "coercer.core.Filter": {"fullname": "coercer.core.Filter", "modulename": "coercer.core.Filter", "kind": "module", "doc": "<p></p>\n"}, "coercer.core.Filter.Filter": {"fullname": "coercer.core.Filter.Filter", "modulename": "coercer.core.Filter", "qualname": "Filter", "kind": "class", "doc": "<p>Documentation for class Filter</p>\n"}, "coercer.core.Filter.Filter.__init__": {"fullname": "coercer.core.Filter.Filter.__init__", "modulename": "coercer.core.Filter", "qualname": "Filter.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">filter_method_name</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filter_protocol_name</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">filter_pipe_name</span><span class=\"o\">=</span><span class=\"kc\">None</span></span>)</span>"}, "coercer.core.Filter.Filter.filter_method_name": {"fullname": "coercer.core.Filter.Filter.filter_method_name", "modulename": "coercer.core.Filter", "qualname": "Filter.filter_method_name", "kind": "variable", "doc": "<p></p>\n"}, "coercer.core.Filter.Filter.filter_protocol_name": {"fullname": "coercer.core.Filter.Filter.filter_protocol_name", "modulename": "coercer.core.Filter", "qualname": "Filter.filter_protocol_name", "kind": "variable", "doc": "<p></p>\n"}, "coercer.core.Filter.Filter.filter_pipe_name": {"fullname": "coercer.core.Filter.Filter.filter_pipe_name", "modulename": "coercer.core.Filter", "qualname": "Filter.filter_pipe_name", "kind": "variable", "doc": "<p></p>\n"}, "coercer.core.Filter.Filter.method_matches_filter": {"fullname": "coercer.core.Filter.Filter.method_matches_filter", "modulename": "coercer.core.Filter", "qualname": "Filter.method_matches_filter", "kind": "function", "doc": "<p>Function method_matches_filter</p>\n\n<p>Parameters:\n    ?:instance</p>\n\n<p>Return:\n    bool:outcome</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">instance</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.core.Filter.Filter.pipe_matches_filter": {"fullname": "coercer.core.Filter.Filter.pipe_matches_filter", "modulename": "coercer.core.Filter", "qualname": "Filter.pipe_matches_filter", "kind": "function", "doc": "<p>Function pipe_matches_filter</p>\n\n<p>Parameters:\n    ?:pipe_name</p>\n\n<p>Return:\n    bool:outcome</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">pipe_name</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.core.Reporter": {"fullname": "coercer.core.Reporter", "modulename": "coercer.core.Reporter", "kind": "module", "doc": "<p></p>\n"}, "coercer.core.Reporter.CURSOR_UP_ONE": {"fullname": "coercer.core.Reporter.CURSOR_UP_ONE", "modulename": "coercer.core.Reporter", "qualname": "CURSOR_UP_ONE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;\\x1b[1A&#x27;"}, "coercer.core.Reporter.ERASE_LINE": {"fullname": "coercer.core.Reporter.ERASE_LINE", "modulename": "coercer.core.Reporter", "qualname": "ERASE_LINE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&#x27;\\x1b[2K&#x27;"}, "coercer.core.Reporter.Reporter": {"fullname": "coercer.core.Reporter.Reporter", "modulename": "coercer.core.Reporter", "qualname": "Reporter", "kind": "class", "doc": "<p>Documentation for class Reporter</p>\n"}, "coercer.core.Reporter.Reporter.__init__": {"fullname": "coercer.core.Reporter.Reporter.__init__", "modulename": "coercer.core.Reporter", "qualname": "Reporter.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">options</span>, </span><span class=\"param\"><span class=\"n\">verbose</span><span class=\"o\">=</span><span class=\"kc\">False</span></span>)</span>"}, "coercer.core.Reporter.Reporter.options": {"fullname": "coercer.core.Reporter.Reporter.options", "modulename": "coercer.core.Reporter", "qualname": "Reporter.options", "kind": "variable", "doc": "<p></p>\n"}, "coercer.core.Reporter.Reporter.verbose": {"fullname": "coercer.core.Reporter.Reporter.verbose", "modulename": "coercer.core.Reporter", "qualname": "Reporter.verbose", "kind": "variable", "doc": "<p></p>\n"}, "coercer.core.Reporter.Reporter.test_results": {"fullname": "coercer.core.Reporter.Reporter.test_results", "modulename": "coercer.core.Reporter", "qualname": "Reporter.test_results", "kind": "variable", "doc": "<p></p>\n"}, "coercer.core.Reporter.Reporter.print_testing": {"fullname": "coercer.core.Reporter.Reporter.print_testing", "modulename": "coercer.core.Reporter", "qualname": "Reporter.print_testing", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">msprotocol_rpc_instance</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.core.Reporter.Reporter.print_info": {"fullname": "coercer.core.Reporter.Reporter.print_info", "modulename": "coercer.core.Reporter", "qualname": "Reporter.print_info", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">message</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.core.Reporter.Reporter.print_warn": {"fullname": "coercer.core.Reporter.Reporter.print_warn", "modulename": "coercer.core.Reporter", "qualname": "Reporter.print_warn", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">message</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.core.Reporter.Reporter.print_verbose": {"fullname": "coercer.core.Reporter.Reporter.print_verbose", "modulename": "coercer.core.Reporter", "qualname": "Reporter.print_verbose", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">message</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.core.Reporter.Reporter.report_test_result": {"fullname": "coercer.core.Reporter.Reporter.report_test_result", "modulename": "coercer.core.Reporter", "qualname": "Reporter.report_test_result", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">uuid</span>,</span><span class=\"param\">\t<span class=\"n\">version</span>,</span><span class=\"param\">\t<span class=\"n\">namedpipe</span>,</span><span class=\"param\">\t<span class=\"n\">msprotocol_rpc_instance</span>,</span><span class=\"param\">\t<span class=\"n\">result</span>,</span><span class=\"param\">\t<span class=\"n\">exploitpath</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.core.Reporter.Reporter.exportXLSX": {"fullname": "coercer.core.Reporter.Reporter.exportXLSX", "modulename": "coercer.core.Reporter", "qualname": "Reporter.exportXLSX", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">filename</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.core.Reporter.Reporter.exportJSON": {"fullname": "coercer.core.Reporter.Reporter.exportJSON", "modulename": "coercer.core.Reporter", "qualname": "Reporter.exportJSON", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">filename</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.core.Reporter.Reporter.exportSQLITE": {"fullname": "coercer.core.Reporter.Reporter.exportSQLITE", "modulename": "coercer.core.Reporter", "qualname": "Reporter.exportSQLITE", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">target</span>, </span><span class=\"param\"><span class=\"n\">filename</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.core.loader": {"fullname": "coercer.core.loader", "modulename": "coercer.core.loader", "kind": "module", "doc": "<p></p>\n"}, "coercer.core.loader.find_and_load_coerce_methods": {"fullname": "coercer.core.loader.find_and_load_coerce_methods", "modulename": "coercer.core.loader", "qualname": "find_and_load_coerce_methods", "kind": "function", "doc": "<p>Function find_and_load_coerce_methods()</p>\n\n<p>Parameters:\n    bool:debug Enable or disable debug output</p>\n\n<p>Returns:\n    list:coerce_methods</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">debug</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.core.modes": {"fullname": "coercer.core.modes", "modulename": "coercer.core.modes", "kind": "module", "doc": "<p></p>\n"}, "coercer.core.modes.coerce": {"fullname": "coercer.core.modes.coerce", "modulename": "coercer.core.modes.coerce", "kind": "module", "doc": "<p></p>\n"}, "coercer.core.modes.coerce.action_coerce": {"fullname": "coercer.core.modes.coerce.action_coerce", "modulename": "coercer.core.modes.coerce", "qualname": "action_coerce", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">target</span>, </span><span class=\"param\"><span class=\"n\">available_methods</span>, </span><span class=\"param\"><span class=\"n\">options</span>, </span><span class=\"param\"><span class=\"n\">credentials</span>, </span><span class=\"param\"><span class=\"n\">reporter</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.core.modes.fuzz": {"fullname": "coercer.core.modes.fuzz", "modulename": "coercer.core.modes.fuzz", "kind": "module", "doc": "<p></p>\n"}, "coercer.core.modes.fuzz.action_fuzz": {"fullname": "coercer.core.modes.fuzz.action_fuzz", "modulename": "coercer.core.modes.fuzz", "qualname": "action_fuzz", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">target</span>, </span><span class=\"param\"><span class=\"n\">available_methods</span>, </span><span class=\"param\"><span class=\"n\">options</span>, </span><span class=\"param\"><span class=\"n\">credentials</span>, </span><span class=\"param\"><span class=\"n\">reporter</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.core.modes.scan": {"fullname": "coercer.core.modes.scan", "modulename": "coercer.core.modes.scan", "kind": "module", "doc": "<p></p>\n"}, "coercer.core.modes.scan.action_scan": {"fullname": "coercer.core.modes.scan.action_scan", "modulename": "coercer.core.modes.scan", "qualname": "action_scan", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">target</span>, </span><span class=\"param\"><span class=\"n\">available_methods</span>, </span><span class=\"param\"><span class=\"n\">options</span>, </span><span class=\"param\"><span class=\"n\">credentials</span>, </span><span class=\"param\"><span class=\"n\">reporter</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.core.utils": {"fullname": "coercer.core.utils", "modulename": "coercer.core.utils", "kind": "module", "doc": "<p></p>\n"}, "coercer.core.utils.gen_random_name": {"fullname": "coercer.core.utils.gen_random_name", "modulename": "coercer.core.utils", "qualname": "gen_random_name", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">length</span><span class=\"o\">=</span><span class=\"mi\">8</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.core.utils.generate_exploit_templates": {"fullname": "coercer.core.utils.generate_exploit_templates", "modulename": "coercer.core.utils", "qualname": "generate_exploit_templates", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">desired_auth_type</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.core.utils.generate_exploit_path_from_template": {"fullname": "coercer.core.utils.generate_exploit_path_from_template", "modulename": "coercer.core.utils", "qualname": "generate_exploit_path_from_template", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">template</span>, </span><span class=\"param\"><span class=\"n\">listener</span>, </span><span class=\"param\"><span class=\"n\">http_listen_port</span><span class=\"o\">=</span><span class=\"mi\">80</span>, </span><span class=\"param\"><span class=\"n\">smb_listen_port</span><span class=\"o\">=</span><span class=\"mi\">445</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.methods": {"fullname": "coercer.methods", "modulename": "coercer.methods", "kind": "module", "doc": "<p></p>\n"}, "coercer.methods.MS_DFSNM": {"fullname": "coercer.methods.MS_DFSNM", "modulename": "coercer.methods.MS_DFSNM", "kind": "module", "doc": "<p></p>\n"}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot": {"fullname": "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot", "modulename": "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot", "kind": "module", "doc": "<p></p>\n"}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"fullname": "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot", "modulename": "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot", "qualname": "NetrDfsAddStdRoot", "kind": "class", "doc": "<p>Coercing a machine to authenticate using function NetrDfsAddStdRoot (opnum 12) of [MS-DFSNM]: Distributed File System (DFS): Namespace Management Protocol (<a href=\"https://docs.microsoft.com/en-us/openspecs/windows_protocols/ms-dfsnm/95a506a8-cae6-4c42-b19d-9c1ed1223979\">https://docs.microsoft.com/en-us/openspecs/windows_protocols/ms-dfsnm/95a506a8-cae6-4c42-b19d-9c1ed1223979</a>)</p>\n\n<p>Method found by:</p>\n\n<ul>\n<li><a href=\"https://twitter.com/filip_dragovic\">@filip_dragovic</a></li>\n</ul>\n", "bases": "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL"}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.exploit_paths": {"fullname": "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.exploit_paths", "modulename": "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot", "qualname": "NetrDfsAddStdRoot.exploit_paths", "kind": "variable", "doc": "<p></p>\n", "default_value": "[(&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\\\file.txt\\x00&#x27;), (&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\\\\\x00&#x27;), (&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\x00&#x27;), (&#x27;http&#x27;, &#x27;\\\\\\\\{{listener}}{{http_listen_port}}/{{rnd(3)}}\\\\file.txt\\x00&#x27;)]"}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.access": {"fullname": "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.access", "modulename": "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot", "qualname": "NetrDfsAddStdRoot.access", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;ncan_np&#x27;: [{&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\netdfs&#x27;, &#x27;uuid&#x27;: &#x27;4fc742e0-4a10-11cf-8273-00aa004ae673&#x27;, &#x27;version&#x27;: &#x27;3.0&#x27;}], &#x27;ncacn_ip_tcp&#x27;: [{&#x27;uuid&#x27;: &#x27;4fc742e0-4a10-11cf-8273-00aa004ae673&#x27;, &#x27;version&#x27;: &#x27;3.0&#x27;}]}"}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.protocol": {"fullname": "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.protocol", "modulename": "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot", "qualname": "NetrDfsAddStdRoot.protocol", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;longname&#x27;: &#x27;[MS-DFSNM]: Distributed File System (DFS): Namespace Management Protocol&#x27;, &#x27;shortname&#x27;: &#x27;MS-DFSNM&#x27;}"}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.function": {"fullname": "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.function", "modulename": "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot", "qualname": "NetrDfsAddStdRoot.function", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;name&#x27;: &#x27;NetrDfsAddStdRoot&#x27;, &#x27;opnum&#x27;: 12, &#x27;vulnerable_arguments&#x27;: [&#x27;ServerName&#x27;]}"}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.trigger": {"fullname": "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.trigger", "modulename": "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot", "qualname": "NetrDfsAddStdRoot.trigger", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">dcerpc_session</span>, </span><span class=\"param\"><span class=\"n\">target</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot": {"fullname": "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot", "modulename": "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot", "kind": "module", "doc": "<p></p>\n"}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"fullname": "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot", "modulename": "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot", "qualname": "NetrDfsRemoveStdRoot", "kind": "class", "doc": "<p>Coercing a machine to authenticate using function NetrDfsRemoveStdRoot (opnum 13) of [MS-DFSNM]: Distributed File System (DFS): Namespace Management Protocol (<a href=\"https://docs.microsoft.com/en-us/openspecs/windows_protocols/ms-dfsnm/95a506a8-cae6-4c42-b19d-9c1ed1223979\">https://docs.microsoft.com/en-us/openspecs/windows_protocols/ms-dfsnm/95a506a8-cae6-4c42-b19d-9c1ed1223979</a>)</p>\n\n<p>Method found by:</p>\n\n<ul>\n<li><a href=\"https://twitter.com/filip_dragovic\">@filip_dragovic</a></li>\n</ul>\n", "bases": "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL"}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.exploit_paths": {"fullname": "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.exploit_paths", "modulename": "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot", "qualname": "NetrDfsRemoveStdRoot.exploit_paths", "kind": "variable", "doc": "<p></p>\n", "default_value": "[(&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\\\file.txt\\x00&#x27;), (&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\\\\\x00&#x27;), (&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\x00&#x27;), (&#x27;http&#x27;, &#x27;\\\\\\\\{{listener}}{{http_listen_port}}/{{rnd(3)}}\\\\file.txt\\x00&#x27;)]"}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.access": {"fullname": "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.access", "modulename": "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot", "qualname": "NetrDfsRemoveStdRoot.access", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;ncan_np&#x27;: [{&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\netdfs&#x27;, &#x27;uuid&#x27;: &#x27;4fc742e0-4a10-11cf-8273-00aa004ae673&#x27;, &#x27;version&#x27;: &#x27;3.0&#x27;}], &#x27;ncacn_ip_tcp&#x27;: [{&#x27;uuid&#x27;: &#x27;4fc742e0-4a10-11cf-8273-00aa004ae673&#x27;, &#x27;version&#x27;: &#x27;3.0&#x27;}]}"}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.protocol": {"fullname": "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.protocol", "modulename": "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot", "qualname": "NetrDfsRemoveStdRoot.protocol", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;longname&#x27;: &#x27;[MS-DFSNM]: Distributed File System (DFS): Namespace Management Protocol&#x27;, &#x27;shortname&#x27;: &#x27;MS-DFSNM&#x27;}"}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.function": {"fullname": "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.function", "modulename": "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot", "qualname": "NetrDfsRemoveStdRoot.function", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;name&#x27;: &#x27;NetrDfsRemoveStdRoot&#x27;, &#x27;opnum&#x27;: 13, &#x27;vulnerable_arguments&#x27;: [&#x27;ServerName&#x27;]}"}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.trigger": {"fullname": "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.trigger", "modulename": "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot", "qualname": "NetrDfsRemoveStdRoot.trigger", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">dcerpc_session</span>, </span><span class=\"param\"><span class=\"n\">target</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.methods.MS_EFSR": {"fullname": "coercer.methods.MS_EFSR", "modulename": "coercer.methods.MS_EFSR", "kind": "module", "doc": "<p></p>\n"}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile": {"fullname": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile", "modulename": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile", "kind": "module", "doc": "<p></p>\n"}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"fullname": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB", "modulename": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile", "qualname": "EFS_HASH_BLOB", "kind": "class", "doc": "<p>This will be the base class for all DCERPC NDR Types and represents a NDR Primitive Type</p>\n", "bases": "impacket.dcerpc.v5.ndr.NDRSTRUCT"}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB.structure": {"fullname": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB.structure", "modulename": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile", "qualname": "EFS_HASH_BLOB.structure", "kind": "variable", "doc": "<p></p>\n", "default_value": "((&#x27;Data&#x27;, &lt;class &#x27;impacket.dcerpc.v5.ndr.NDRULONG&#x27;&gt;), (&#x27;cbData&#x27;, &lt;class &#x27;impacket.dcerpc.v5.dtypes.PCHAR&#x27;&gt;))"}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"fullname": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH", "modulename": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile", "qualname": "ENCRYPTION_CERTIFICATE_HASH", "kind": "class", "doc": "<p>This will be the base class for all DCERPC NDR Types and represents a NDR Primitive Type</p>\n", "bases": "impacket.dcerpc.v5.ndr.NDRSTRUCT"}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"fullname": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure", "modulename": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile", "qualname": "ENCRYPTION_CERTIFICATE_HASH.structure", "kind": "variable", "doc": "<p></p>\n", "default_value": "((&#x27;Lenght&#x27;, &lt;class &#x27;impacket.dcerpc.v5.ndr.NDRULONG&#x27;&gt;), (&#x27;SID&#x27;, &lt;class &#x27;impacket.dcerpc.v5.dtypes.RPC_SID&#x27;&gt;), (&#x27;Hash&#x27;, &lt;class &#x27;coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB&#x27;&gt;), (&#x27;Display&#x27;, &lt;class &#x27;impacket.dcerpc.v5.dtypes.LPWSTR&#x27;&gt;))"}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"fullname": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST", "modulename": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile", "qualname": "ENCRYPTION_CERTIFICATE_LIST", "kind": "class", "doc": "<p>This will be the base class for all DCERPC NDR Types and represents a NDR Primitive Type</p>\n", "bases": "impacket.dcerpc.v5.ndr.NDRSTRUCT"}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"fullname": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure", "modulename": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile", "qualname": "ENCRYPTION_CERTIFICATE_LIST.structure", "kind": "variable", "doc": "<p></p>\n", "default_value": "((&#x27;nUsers&#x27;, &lt;class &#x27;impacket.dcerpc.v5.ndr.NDRULONG&#x27;&gt;), (&#x27;Users&#x27;, &lt;class &#x27;coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH&#x27;&gt;))"}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile": {"fullname": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile", "modulename": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile", "qualname": "EfsRpcAddUsersToFile", "kind": "class", "doc": "<p>Coercing a machine to authenticate using function EfsRpcDecryptFileSrv (opnum 5) of <a href=\"https://learn.microsoft.com/en-us/openspecs/windows_protocols/ms-efsr/08796ba8-01c8-4872-9221-1000ec2eff31\">MS-EFSR Protocol</a></p>\n\n<p>Method found by:</p>\n\n<ul>\n<li><a href=\"https://twitter.com/topotam77\">@topotam77</a></li>\n</ul>\n", "bases": "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL"}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.exploit_paths": {"fullname": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.exploit_paths", "modulename": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile", "qualname": "EfsRpcAddUsersToFile.exploit_paths", "kind": "variable", "doc": "<p></p>\n", "default_value": "[(&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\\\file.txt\\x00&#x27;), (&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\\\\\x00&#x27;), (&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\x00&#x27;), (&#x27;http&#x27;, &#x27;\\\\\\\\{{listener}}{{http_listen_port}}/{{rnd(3)}}\\\\file.txt\\x00&#x27;)]"}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"fullname": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access", "modulename": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile", "qualname": "EfsRpcAddUsersToFile.access", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;ncan_np&#x27;: [{&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\efsrpc&#x27;, &#x27;uuid&#x27;: &#x27;df1941c5-fe89-4e79-bf10-463657acf44d&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\lsarpc&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\samr&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\lsass&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\netlogon&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}], &#x27;ncacn_ip_tcp&#x27;: [{&#x27;uuid&#x27;: &#x27;df1941c5-fe89-4e79-bf10-463657acf44d&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}]}"}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.protocol": {"fullname": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.protocol", "modulename": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile", "qualname": "EfsRpcAddUsersToFile.protocol", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;longname&#x27;: &#x27;[MS-EFSR]: Encrypting File System Remote (EFSRPC) Protocol&#x27;, &#x27;shortname&#x27;: &#x27;MS-EFSR&#x27;}"}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.function": {"fullname": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.function", "modulename": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile", "qualname": "EfsRpcAddUsersToFile.function", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;name&#x27;: &#x27;EfsRpcAddUsersToFile&#x27;, &#x27;opnum&#x27;: 9, &#x27;vulnerable_arguments&#x27;: [&#x27;FileName&#x27;]}"}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.trigger": {"fullname": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.trigger", "modulename": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile", "qualname": "EfsRpcAddUsersToFile.trigger", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">dcerpc_session</span>, </span><span class=\"param\"><span class=\"n\">target</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx": {"fullname": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx", "modulename": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx", "kind": "module", "doc": "<p></p>\n"}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"fullname": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB", "modulename": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx", "qualname": "EFS_RPC_BLOB", "kind": "class", "doc": "<p>This will be the base class for all DCERPC NDR Types and represents a NDR Primitive Type</p>\n", "bases": "impacket.dcerpc.v5.ndr.NDRSTRUCT"}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB.structure": {"fullname": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB.structure", "modulename": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx", "qualname": "EFS_RPC_BLOB.structure", "kind": "variable", "doc": "<p></p>\n", "default_value": "((&#x27;Data&#x27;, &lt;class &#x27;impacket.dcerpc.v5.ndr.NDRULONG&#x27;&gt;), (&#x27;cbData&#x27;, &lt;class &#x27;impacket.dcerpc.v5.dtypes.PCHAR&#x27;&gt;))"}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"fullname": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB", "modulename": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx", "qualname": "EFS_HASH_BLOB", "kind": "class", "doc": "<p>This will be the base class for all DCERPC NDR Types and represents a NDR Primitive Type</p>\n", "bases": "impacket.dcerpc.v5.ndr.NDRSTRUCT"}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB.structure": {"fullname": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB.structure", "modulename": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx", "qualname": "EFS_HASH_BLOB.structure", "kind": "variable", "doc": "<p></p>\n", "default_value": "((&#x27;Data&#x27;, &lt;class &#x27;impacket.dcerpc.v5.ndr.NDRULONG&#x27;&gt;), (&#x27;cbData&#x27;, &lt;class &#x27;impacket.dcerpc.v5.dtypes.PCHAR&#x27;&gt;))"}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"fullname": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH", "modulename": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx", "qualname": "ENCRYPTION_CERTIFICATE_HASH", "kind": "class", "doc": "<p>This will be the base class for all DCERPC NDR Types and represents a NDR Primitive Type</p>\n", "bases": "impacket.dcerpc.v5.ndr.NDRSTRUCT"}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"fullname": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure", "modulename": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx", "qualname": "ENCRYPTION_CERTIFICATE_HASH.structure", "kind": "variable", "doc": "<p></p>\n", "default_value": "((&#x27;Lenght&#x27;, &lt;class &#x27;impacket.dcerpc.v5.ndr.NDRULONG&#x27;&gt;), (&#x27;SID&#x27;, &lt;class &#x27;impacket.dcerpc.v5.dtypes.RPC_SID&#x27;&gt;), (&#x27;Hash&#x27;, &lt;class &#x27;coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB&#x27;&gt;), (&#x27;Display&#x27;, &lt;class &#x27;impacket.dcerpc.v5.dtypes.LPWSTR&#x27;&gt;))"}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"fullname": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST", "modulename": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx", "qualname": "ENCRYPTION_CERTIFICATE_LIST", "kind": "class", "doc": "<p>This will be the base class for all DCERPC NDR Types and represents a NDR Primitive Type</p>\n", "bases": "impacket.dcerpc.v5.ndr.NDRSTRUCT"}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"fullname": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure", "modulename": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx", "qualname": "ENCRYPTION_CERTIFICATE_LIST.structure", "kind": "variable", "doc": "<p></p>\n", "default_value": "((&#x27;nUsers&#x27;, &lt;class &#x27;impacket.dcerpc.v5.ndr.NDRULONG&#x27;&gt;), (&#x27;Users&#x27;, &lt;class &#x27;coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH&#x27;&gt;))"}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx": {"fullname": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx", "modulename": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx", "qualname": "EfsRpcAddUsersToFileEx", "kind": "class", "doc": "<p><a href=\"https://learn.microsoft.com/en-us/openspecs/windows_protocols/ms-efsr/d36df703-edc9-4482-87b7-d05c7783d65e\">https://learn.microsoft.com/en-us/openspecs/windows_protocols/ms-efsr/d36df703-edc9-4482-87b7-d05c7783d65e</a></p>\n", "bases": "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL"}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.exploit_paths": {"fullname": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.exploit_paths", "modulename": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx", "qualname": "EfsRpcAddUsersToFileEx.exploit_paths", "kind": "variable", "doc": "<p></p>\n", "default_value": "[(&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}\\\\Share\\\\file.txt\\x00&#x27;), (&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}\\\\Share\\\\\\x00&#x27;), (&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}\\\\Share\\x00&#x27;)]"}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"fullname": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access", "modulename": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx", "qualname": "EfsRpcAddUsersToFileEx.access", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;ncan_np&#x27;: [{&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\efsrpc&#x27;, &#x27;uuid&#x27;: &#x27;df1941c5-fe89-4e79-bf10-463657acf44d&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\lsarpc&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\samr&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\lsass&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\netlogon&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}], &#x27;ncacn_ip_tcp&#x27;: [{&#x27;uuid&#x27;: &#x27;df1941c5-fe89-4e79-bf10-463657acf44d&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}]}"}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.protocol": {"fullname": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.protocol", "modulename": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx", "qualname": "EfsRpcAddUsersToFileEx.protocol", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;longname&#x27;: &#x27;[MS-EFSR]: Encrypting File System Remote (EFSRPC) Protocol&#x27;, &#x27;shortname&#x27;: &#x27;MS-EFSR&#x27;}"}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.function": {"fullname": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.function", "modulename": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx", "qualname": "EfsRpcAddUsersToFileEx.function", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;name&#x27;: &#x27;EfsRpcAddUsersToFileEx&#x27;, &#x27;opnum&#x27;: 15, &#x27;vulnerable_arguments&#x27;: [&#x27;FileName&#x27;]}"}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.trigger": {"fullname": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.trigger", "modulename": "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx", "qualname": "EfsRpcAddUsersToFileEx.trigger", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">dcerpc_session</span>, </span><span class=\"param\"><span class=\"n\">target</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv": {"fullname": "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv", "modulename": "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv", "kind": "module", "doc": "<p></p>\n"}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv": {"fullname": "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv", "modulename": "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv", "qualname": "EfsRpcDecryptFileSrv", "kind": "class", "doc": "<p>Coercing a machine to authenticate using function EfsRpcDecryptFileSrv (opnum 5) of <a href=\"https://learn.microsoft.com/en-us/openspecs/windows_protocols/ms-efsr/08796ba8-01c8-4872-9221-1000ec2eff31\">MS-EFSR Protocol</a></p>\n\n<p>Method found by:</p>\n\n<ul>\n<li><a href=\"https://twitter.com/topotam77\">@topotam77</a></li>\n</ul>\n", "bases": "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL"}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.exploit_paths": {"fullname": "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.exploit_paths", "modulename": "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv", "qualname": "EfsRpcDecryptFileSrv.exploit_paths", "kind": "variable", "doc": "<p></p>\n", "default_value": "[(&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\\\file.txt\\x00&#x27;), (&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\\\\\x00&#x27;), (&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\x00&#x27;), (&#x27;http&#x27;, &#x27;\\\\\\\\{{listener}}{{http_listen_port}}/{{rnd(3)}}\\\\file.txt\\x00&#x27;)]"}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"fullname": "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access", "modulename": "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv", "qualname": "EfsRpcDecryptFileSrv.access", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;ncan_np&#x27;: [{&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\efsrpc&#x27;, &#x27;uuid&#x27;: &#x27;df1941c5-fe89-4e79-bf10-463657acf44d&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\lsarpc&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\samr&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\lsass&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\netlogon&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}], &#x27;ncacn_ip_tcp&#x27;: [{&#x27;uuid&#x27;: &#x27;df1941c5-fe89-4e79-bf10-463657acf44d&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}]}"}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.protocol": {"fullname": "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.protocol", "modulename": "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv", "qualname": "EfsRpcDecryptFileSrv.protocol", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;longname&#x27;: &#x27;[MS-EFSR]: Encrypting File System Remote (EFSRPC) Protocol&#x27;, &#x27;shortname&#x27;: &#x27;MS-EFSR&#x27;}"}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.function": {"fullname": "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.function", "modulename": "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv", "qualname": "EfsRpcDecryptFileSrv.function", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;name&#x27;: &#x27;EfsRpcDecryptFileSrv&#x27;, &#x27;opnum&#x27;: 5, &#x27;vulnerable_arguments&#x27;: [&#x27;FileName&#x27;]}"}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.trigger": {"fullname": "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.trigger", "modulename": "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv", "qualname": "EfsRpcDecryptFileSrv.trigger", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">dcerpc_session</span>, </span><span class=\"param\"><span class=\"n\">target</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile": {"fullname": "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile", "modulename": "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile", "kind": "module", "doc": "<p></p>\n"}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"fullname": "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB", "modulename": "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile", "qualname": "EFS_RPC_BLOB", "kind": "class", "doc": "<p>This will be the base class for all DCERPC NDR Types and represents a NDR Primitive Type</p>\n", "bases": "impacket.dcerpc.v5.ndr.NDRSTRUCT"}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB.structure": {"fullname": "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB.structure", "modulename": "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile", "qualname": "EFS_RPC_BLOB.structure", "kind": "variable", "doc": "<p></p>\n", "default_value": "((&#x27;Data&#x27;, &lt;class &#x27;impacket.dcerpc.v5.ndr.NDRULONG&#x27;&gt;), (&#x27;cbData&#x27;, &lt;class &#x27;impacket.dcerpc.v5.dtypes.PCHAR&#x27;&gt;))"}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile": {"fullname": "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile", "modulename": "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile", "qualname": "EfsRpcDuplicateEncryptionInfoFile", "kind": "class", "doc": "<p>Coercing a machine to authenticate using function EfsRpcDuplicateEncryptionInfoFile (opnum 5) of <a href=\"https://learn.microsoft.com/en-us/openspecs/windows_protocols/ms-efsr/08796ba8-01c8-4872-9221-1000ec2eff31\">MS-EFSR Protocol</a></p>\n\n<p>Method found by:</p>\n\n<ul>\n<li><a href=\"https://twitter.com/topotam77\">@topotam77</a></li>\n</ul>\n", "bases": "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL"}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.exploit_paths": {"fullname": "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.exploit_paths", "modulename": "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile", "qualname": "EfsRpcDuplicateEncryptionInfoFile.exploit_paths", "kind": "variable", "doc": "<p></p>\n", "default_value": "[(&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\\\file.txt\\x00&#x27;), (&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\\\\\x00&#x27;), (&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\x00&#x27;), (&#x27;http&#x27;, &#x27;\\\\\\\\{{listener}}{{http_listen_port}}/{{rnd(3)}}\\\\file.txt\\x00&#x27;)]"}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"fullname": "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access", "modulename": "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile", "qualname": "EfsRpcDuplicateEncryptionInfoFile.access", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;ncan_np&#x27;: [{&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\efsrpc&#x27;, &#x27;uuid&#x27;: &#x27;df1941c5-fe89-4e79-bf10-463657acf44d&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\lsarpc&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\samr&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\lsass&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\netlogon&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}], &#x27;ncacn_ip_tcp&#x27;: [{&#x27;uuid&#x27;: &#x27;df1941c5-fe89-4e79-bf10-463657acf44d&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}]}"}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.protocol": {"fullname": "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.protocol", "modulename": "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile", "qualname": "EfsRpcDuplicateEncryptionInfoFile.protocol", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;longname&#x27;: &#x27;[MS-EFSR]: Encrypting File System Remote (EFSRPC) Protocol&#x27;, &#x27;shortname&#x27;: &#x27;MS-EFSR&#x27;}"}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.function": {"fullname": "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.function", "modulename": "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile", "qualname": "EfsRpcDuplicateEncryptionInfoFile.function", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;name&#x27;: &#x27;EfsRpcDuplicateEncryptionInfoFile&#x27;, &#x27;opnum&#x27;: 12, &#x27;vulnerable_arguments&#x27;: [&#x27;SrcFileName&#x27;]}"}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.trigger": {"fullname": "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.trigger", "modulename": "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile", "qualname": "EfsRpcDuplicateEncryptionInfoFile.trigger", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">dcerpc_session</span>, </span><span class=\"param\"><span class=\"n\">target</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv": {"fullname": "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv", "modulename": "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv", "kind": "module", "doc": "<p></p>\n"}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv": {"fullname": "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv", "modulename": "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv", "qualname": "EfsRpcEncryptFileSrv", "kind": "class", "doc": "<p>Coercing a machine to authenticate using function EfsRpcEncryptFileSrv (opnum 4) of <a href=\"https://learn.microsoft.com/en-us/openspecs/windows_protocols/ms-fsrvp/dae107ec-8198-4778-a950-faa7edad125b\">MS-FSRVP Protocol</a></p>\n\n<p>Method found by:</p>\n\n<ul>\n<li><a href=\"https://twitter.com/topotam77\">@topotam77</a></li>\n</ul>\n", "bases": "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL"}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.exploit_paths": {"fullname": "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.exploit_paths", "modulename": "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv", "qualname": "EfsRpcEncryptFileSrv.exploit_paths", "kind": "variable", "doc": "<p></p>\n", "default_value": "[(&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\\\file.txt\\x00&#x27;), (&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\\\\\x00&#x27;), (&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\x00&#x27;), (&#x27;http&#x27;, &#x27;\\\\\\\\{{listener}}{{http_listen_port}}/{{rnd(3)}}\\\\file.txt\\x00&#x27;)]"}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"fullname": "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access", "modulename": "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv", "qualname": "EfsRpcEncryptFileSrv.access", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;ncan_np&#x27;: [{&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\efsrpc&#x27;, &#x27;uuid&#x27;: &#x27;df1941c5-fe89-4e79-bf10-463657acf44d&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\lsarpc&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\samr&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\lsass&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\netlogon&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}], &#x27;ncacn_ip_tcp&#x27;: [{&#x27;uuid&#x27;: &#x27;df1941c5-fe89-4e79-bf10-463657acf44d&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}]}"}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.protocol": {"fullname": "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.protocol", "modulename": "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv", "qualname": "EfsRpcEncryptFileSrv.protocol", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;longname&#x27;: &#x27;[MS-EFSR]: Encrypting File System Remote (EFSRPC) Protocol&#x27;, &#x27;shortname&#x27;: &#x27;MS-EFSR&#x27;}"}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.function": {"fullname": "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.function", "modulename": "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv", "qualname": "EfsRpcEncryptFileSrv.function", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;name&#x27;: &#x27;EfsRpcEncryptFileSrv&#x27;, &#x27;opnum&#x27;: 4, &#x27;vulnerable_arguments&#x27;: [&#x27;FileName&#x27;]}"}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.trigger": {"fullname": "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.trigger", "modulename": "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv", "qualname": "EfsRpcEncryptFileSrv.trigger", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">dcerpc_session</span>, </span><span class=\"param\"><span class=\"n\">target</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo": {"fullname": "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo", "modulename": "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo", "kind": "module", "doc": "<p></p>\n"}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo": {"fullname": "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo", "modulename": "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo", "qualname": "EfsRpcFileKeyInfo", "kind": "class", "doc": "<p>Coercing a machine to authenticate using function EfsRpcFileKeyInfo (opnum 12) of <a href=\"https://learn.microsoft.com/en-us/openspecs/windows_protocols/ms-fsrvp/dae107ec-8198-4778-a950-faa7edad125b\">MS-FSRVP Protocol</a></p>\n\n<p>Method found by:</p>\n\n<ul>\n<li><a href=\"https://twitter.com/topotam77\">@topotam77</a></li>\n</ul>\n", "bases": "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL"}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.exploit_paths": {"fullname": "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.exploit_paths", "modulename": "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo", "qualname": "EfsRpcFileKeyInfo.exploit_paths", "kind": "variable", "doc": "<p></p>\n", "default_value": "[(&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\\\file.txt\\x00&#x27;), (&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\\\\\x00&#x27;), (&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\x00&#x27;), (&#x27;http&#x27;, &#x27;\\\\\\\\{{listener}}{{http_listen_port}}/{{rnd(3)}}\\\\file.txt\\x00&#x27;)]"}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"fullname": "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access", "modulename": "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo", "qualname": "EfsRpcFileKeyInfo.access", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;ncan_np&#x27;: [{&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\efsrpc&#x27;, &#x27;uuid&#x27;: &#x27;df1941c5-fe89-4e79-bf10-463657acf44d&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\lsarpc&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\samr&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\lsass&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\netlogon&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}], &#x27;ncacn_ip_tcp&#x27;: [{&#x27;uuid&#x27;: &#x27;df1941c5-fe89-4e79-bf10-463657acf44d&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}]}"}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.protocol": {"fullname": "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.protocol", "modulename": "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo", "qualname": "EfsRpcFileKeyInfo.protocol", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;longname&#x27;: &#x27;[MS-EFSR]: Encrypting File System Remote (EFSRPC) Protocol&#x27;, &#x27;shortname&#x27;: &#x27;MS-EFSR&#x27;}"}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.function": {"fullname": "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.function", "modulename": "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo", "qualname": "EfsRpcFileKeyInfo.function", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;name&#x27;: &#x27;EfsRpcFileKeyInfo&#x27;, &#x27;opnum&#x27;: 12, &#x27;vulnerable_arguments&#x27;: [&#x27;FileName&#x27;]}"}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.trigger": {"fullname": "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.trigger", "modulename": "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo", "qualname": "EfsRpcFileKeyInfo.trigger", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">dcerpc_session</span>, </span><span class=\"param\"><span class=\"n\">target</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw": {"fullname": "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw", "modulename": "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw", "kind": "module", "doc": "<p></p>\n"}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw": {"fullname": "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw", "modulename": "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw", "qualname": "EfsRpcOpenFileRaw", "kind": "class", "doc": "<p>Coercing a machine to authenticate using function EfsRpcOpenFileRaw (opnum 0) of <a href=\"https://learn.microsoft.com/en-us/openspecs/windows_protocols/ms-efsr/08796ba8-01c8-4872-9221-1000ec2eff31\">MS-EFSR Protocol</a></p>\n\n<p>Method found by:</p>\n\n<ul>\n<li><a href=\"https://twitter.com/topotam77\">@topotam77</a></li>\n</ul>\n", "bases": "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL"}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.exploit_paths": {"fullname": "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.exploit_paths", "modulename": "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw", "qualname": "EfsRpcOpenFileRaw.exploit_paths", "kind": "variable", "doc": "<p></p>\n", "default_value": "[(&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\\\file.txt\\x00&#x27;), (&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\\\\\x00&#x27;), (&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\x00&#x27;), (&#x27;http&#x27;, &#x27;\\\\\\\\{{listener}}{{http_listen_port}}/{{rnd(3)}}\\\\file.txt\\x00&#x27;)]"}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"fullname": "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access", "modulename": "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw", "qualname": "EfsRpcOpenFileRaw.access", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;ncan_np&#x27;: [{&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\efsrpc&#x27;, &#x27;uuid&#x27;: &#x27;df1941c5-fe89-4e79-bf10-463657acf44d&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\lsarpc&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\samr&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\lsass&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\netlogon&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}], &#x27;ncacn_ip_tcp&#x27;: [{&#x27;uuid&#x27;: &#x27;df1941c5-fe89-4e79-bf10-463657acf44d&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}]}"}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.protocol": {"fullname": "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.protocol", "modulename": "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw", "qualname": "EfsRpcOpenFileRaw.protocol", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;longname&#x27;: &#x27;[MS-EFSR]: Encrypting File System Remote (EFSRPC) Protocol&#x27;, &#x27;shortname&#x27;: &#x27;MS-EFSR&#x27;}"}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.function": {"fullname": "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.function", "modulename": "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw", "qualname": "EfsRpcOpenFileRaw.function", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;name&#x27;: &#x27;EfsRpcOpenFileRaw&#x27;, &#x27;opnum&#x27;: 0, &#x27;vulnerable_arguments&#x27;: [&#x27;FileName&#x27;]}"}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.trigger": {"fullname": "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.trigger", "modulename": "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw", "qualname": "EfsRpcOpenFileRaw.trigger", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">dcerpc_session</span>, </span><span class=\"param\"><span class=\"n\">target</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents": {"fullname": "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents", "modulename": "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents", "kind": "module", "doc": "<p></p>\n"}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents": {"fullname": "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents", "modulename": "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents", "qualname": "EfsRpcQueryRecoveryAgents", "kind": "class", "doc": "<p>Coercing a machine to authenticate using function EfsRpcQueryRecoveryAgents (opnum 7) of <a href=\"https://learn.microsoft.com/en-us/openspecs/windows_protocols/ms-fsrvp/dae107ec-8198-4778-a950-faa7edad125b\">MS-FSRVP Protocol</a></p>\n\n<p>Method found by:</p>\n\n<ul>\n<li><a href=\"https://twitter.com/topotam77\">@topotam77</a></li>\n</ul>\n", "bases": "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL"}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.exploit_paths": {"fullname": "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.exploit_paths", "modulename": "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents", "qualname": "EfsRpcQueryRecoveryAgents.exploit_paths", "kind": "variable", "doc": "<p></p>\n", "default_value": "[(&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\\\file.txt\\x00&#x27;), (&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\\\\\x00&#x27;), (&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\x00&#x27;), (&#x27;http&#x27;, &#x27;\\\\\\\\{{listener}}{{http_listen_port}}/{{rnd(3)}}\\\\file.txt\\x00&#x27;)]"}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"fullname": "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access", "modulename": "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents", "qualname": "EfsRpcQueryRecoveryAgents.access", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;ncan_np&#x27;: [{&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\efsrpc&#x27;, &#x27;uuid&#x27;: &#x27;df1941c5-fe89-4e79-bf10-463657acf44d&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\lsarpc&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\samr&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\lsass&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\netlogon&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}], &#x27;ncacn_ip_tcp&#x27;: [{&#x27;uuid&#x27;: &#x27;df1941c5-fe89-4e79-bf10-463657acf44d&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}]}"}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.protocol": {"fullname": "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.protocol", "modulename": "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents", "qualname": "EfsRpcQueryRecoveryAgents.protocol", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;longname&#x27;: &#x27;[MS-EFSR]: Encrypting File System Remote (EFSRPC) Protocol&#x27;, &#x27;shortname&#x27;: &#x27;MS-EFSR&#x27;}"}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.function": {"fullname": "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.function", "modulename": "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents", "qualname": "EfsRpcQueryRecoveryAgents.function", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;name&#x27;: &#x27;EfsRpcQueryRecoveryAgents&#x27;, &#x27;opnum&#x27;: 7, &#x27;vulnerable_arguments&#x27;: [&#x27;FileName&#x27;]}"}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.trigger": {"fullname": "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.trigger", "modulename": "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents", "qualname": "EfsRpcQueryRecoveryAgents.trigger", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">dcerpc_session</span>, </span><span class=\"param\"><span class=\"n\">target</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile": {"fullname": "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile", "modulename": "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile", "kind": "module", "doc": "<p></p>\n"}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile": {"fullname": "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile", "modulename": "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile", "qualname": "EfsRpcQueryUsersOnFile", "kind": "class", "doc": "<p>Coercing a machine to authenticate using function EfsRpcQueryUsersOnFile (opnum 6) of <a href=\"https://learn.microsoft.com/en-us/openspecs/windows_protocols/ms-efsr/08796ba8-01c8-4872-9221-1000ec2eff31\">MS-EFSR Protocol</a></p>\n\n<p>Method found by:</p>\n\n<ul>\n<li><a href=\"https://twitter.com/topotam77\">@topotam77</a></li>\n</ul>\n", "bases": "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL"}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.exploit_paths": {"fullname": "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.exploit_paths", "modulename": "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile", "qualname": "EfsRpcQueryUsersOnFile.exploit_paths", "kind": "variable", "doc": "<p></p>\n", "default_value": "[(&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\\\file.txt\\x00&#x27;), (&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\\\\\x00&#x27;), (&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\x00&#x27;), (&#x27;http&#x27;, &#x27;\\\\\\\\{{listener}}{{http_listen_port}}/{{rnd(3)}}\\\\file.txt\\x00&#x27;)]"}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"fullname": "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access", "modulename": "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile", "qualname": "EfsRpcQueryUsersOnFile.access", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;ncan_np&#x27;: [{&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\efsrpc&#x27;, &#x27;uuid&#x27;: &#x27;df1941c5-fe89-4e79-bf10-463657acf44d&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\lsarpc&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\samr&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\lsass&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\netlogon&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}], &#x27;ncacn_ip_tcp&#x27;: [{&#x27;uuid&#x27;: &#x27;df1941c5-fe89-4e79-bf10-463657acf44d&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}]}"}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.protocol": {"fullname": "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.protocol", "modulename": "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile", "qualname": "EfsRpcQueryUsersOnFile.protocol", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;longname&#x27;: &#x27;[MS-EFSR]: Encrypting File System Remote (EFSRPC) Protocol&#x27;, &#x27;shortname&#x27;: &#x27;MS-EFSR&#x27;}"}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.function": {"fullname": "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.function", "modulename": "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile", "qualname": "EfsRpcQueryUsersOnFile.function", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;name&#x27;: &#x27;EfsRpcQueryUsersOnFile&#x27;, &#x27;opnum&#x27;: 6, &#x27;vulnerable_arguments&#x27;: [&#x27;FileName&#x27;]}"}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.trigger": {"fullname": "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.trigger", "modulename": "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile", "qualname": "EfsRpcQueryUsersOnFile.trigger", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">dcerpc_session</span>, </span><span class=\"param\"><span class=\"n\">target</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile": {"fullname": "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile", "modulename": "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile", "kind": "module", "doc": "<p></p>\n"}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"fullname": "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB", "modulename": "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile", "qualname": "EFS_HASH_BLOB", "kind": "class", "doc": "<p>This will be the base class for all DCERPC NDR Types and represents a NDR Primitive Type</p>\n", "bases": "impacket.dcerpc.v5.ndr.NDRSTRUCT"}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB.structure": {"fullname": "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB.structure", "modulename": "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile", "qualname": "EFS_HASH_BLOB.structure", "kind": "variable", "doc": "<p></p>\n", "default_value": "((&#x27;Data&#x27;, &lt;class &#x27;impacket.dcerpc.v5.ndr.NDRULONG&#x27;&gt;), (&#x27;cbData&#x27;, &lt;class &#x27;impacket.dcerpc.v5.dtypes.PCHAR&#x27;&gt;))"}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"fullname": "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH", "modulename": "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile", "qualname": "ENCRYPTION_CERTIFICATE_HASH", "kind": "class", "doc": "<p>This will be the base class for all DCERPC NDR Types and represents a NDR Primitive Type</p>\n", "bases": "impacket.dcerpc.v5.ndr.NDRSTRUCT"}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"fullname": "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure", "modulename": "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile", "qualname": "ENCRYPTION_CERTIFICATE_HASH.structure", "kind": "variable", "doc": "<p></p>\n", "default_value": "((&#x27;Lenght&#x27;, &lt;class &#x27;impacket.dcerpc.v5.ndr.NDRULONG&#x27;&gt;), (&#x27;SID&#x27;, &lt;class &#x27;impacket.dcerpc.v5.dtypes.RPC_SID&#x27;&gt;), (&#x27;Hash&#x27;, &lt;class &#x27;coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB&#x27;&gt;), (&#x27;Display&#x27;, &lt;class &#x27;impacket.dcerpc.v5.dtypes.LPWSTR&#x27;&gt;))"}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"fullname": "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST", "modulename": "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile", "qualname": "ENCRYPTION_CERTIFICATE_HASH_LIST", "kind": "class", "doc": "<p>This will be the base class for all DCERPC NDR Types and represents a NDR Primitive Type</p>\n", "bases": "impacket.dcerpc.v5.ndr.NDRSTRUCT"}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.align": {"fullname": "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.align", "modulename": "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile", "qualname": "ENCRYPTION_CERTIFICATE_HASH_LIST.align", "kind": "variable", "doc": "<p></p>\n", "default_value": "1"}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"fullname": "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure", "modulename": "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile", "qualname": "ENCRYPTION_CERTIFICATE_HASH_LIST.structure", "kind": "variable", "doc": "<p></p>\n", "default_value": "((&#x27;Cert&#x27;, &lt;class &#x27;impacket.dcerpc.v5.ndr.NDRULONG&#x27;&gt;), (&#x27;Users&#x27;, &lt;class &#x27;coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH&#x27;&gt;))"}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile": {"fullname": "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile", "modulename": "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile", "qualname": "EfsRpcRemoveUsersFromFile", "kind": "class", "doc": "<p>Coercing a machine to authenticate using function EfsRpcOpenFileRaw (opnum 0) of <a href=\"https://learn.microsoft.com/en-us/openspecs/windows_protocols/ms-efsr/08796ba8-01c8-4872-9221-1000ec2eff31\">MS-EFSR Protocol</a></p>\n\n<p>Method found by:</p>\n\n<ul>\n<li><a href=\"https://twitter.com/topotam77\">@topotam77</a></li>\n</ul>\n", "bases": "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL"}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.exploit_paths": {"fullname": "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.exploit_paths", "modulename": "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile", "qualname": "EfsRpcRemoveUsersFromFile.exploit_paths", "kind": "variable", "doc": "<p></p>\n", "default_value": "[(&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\\\file.txt\\x00&#x27;), (&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\\\\\x00&#x27;), (&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\x00&#x27;), (&#x27;http&#x27;, &#x27;\\\\\\\\{{listener}}{{http_listen_port}}/{{rnd(3)}}\\\\file.txt\\x00&#x27;)]"}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"fullname": "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access", "modulename": "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile", "qualname": "EfsRpcRemoveUsersFromFile.access", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;ncan_np&#x27;: [{&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\efsrpc&#x27;, &#x27;uuid&#x27;: &#x27;df1941c5-fe89-4e79-bf10-463657acf44d&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\lsarpc&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\samr&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\lsass&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\netlogon&#x27;, &#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}], &#x27;ncacn_ip_tcp&#x27;: [{&#x27;uuid&#x27;: &#x27;df1941c5-fe89-4e79-bf10-463657acf44d&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}, {&#x27;uuid&#x27;: &#x27;c681d488-d850-11d0-8c52-00c04fd90f7e&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}]}"}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.protocol": {"fullname": "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.protocol", "modulename": "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile", "qualname": "EfsRpcRemoveUsersFromFile.protocol", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;longname&#x27;: &#x27;[MS-EFSR]: Encrypting File System Remote (EFSRPC) Protocol&#x27;, &#x27;shortname&#x27;: &#x27;MS-EFSR&#x27;}"}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.function": {"fullname": "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.function", "modulename": "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile", "qualname": "EfsRpcRemoveUsersFromFile.function", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;name&#x27;: &#x27;EfsRpcRemoveUsersFromFile&#x27;, &#x27;opnum&#x27;: 8, &#x27;vulnerable_arguments&#x27;: [&#x27;FileName&#x27;]}"}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.trigger": {"fullname": "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.trigger", "modulename": "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile", "qualname": "EfsRpcRemoveUsersFromFile.trigger", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">dcerpc_session</span>, </span><span class=\"param\"><span class=\"n\">target</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.methods.MS_EVEN": {"fullname": "coercer.methods.MS_EVEN", "modulename": "coercer.methods.MS_EVEN", "kind": "module", "doc": "<p></p>\n"}, "coercer.methods.MS_EVEN.ElfrOpenBELW": {"fullname": "coercer.methods.MS_EVEN.ElfrOpenBELW", "modulename": "coercer.methods.MS_EVEN.ElfrOpenBELW", "kind": "module", "doc": "<p></p>\n"}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW": {"fullname": "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW", "modulename": "coercer.methods.MS_EVEN.ElfrOpenBELW", "qualname": "ElfrOpenBELW", "kind": "class", "doc": "<p>Coercing a machine to authenticate using function <a href=\"https://learn.microsoft.com/en-us/openspecs/windows_protocols/ms-even/4db1601c-7bc2-4d5c-8375-c58a6f8fc7e1\">ElfrOpenBELW</a> (opnum 9) of <a href=\"https://learn.microsoft.com/en-us/openspecs/windows_protocols/ms-even/55b13664-f739-4e4e-bd8d-04eeda59d09f\">MS-EVEN: EventLog Remoting Protocol</a></p>\n\n<p>Method found by:</p>\n\n<ul>\n<li><a href=\"https://github.com/evilashz/\">@evilashz</a></li>\n</ul>\n", "bases": "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL"}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.exploit_paths": {"fullname": "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.exploit_paths", "modulename": "coercer.methods.MS_EVEN.ElfrOpenBELW", "qualname": "ElfrOpenBELW.exploit_paths", "kind": "variable", "doc": "<p></p>\n", "default_value": "[(&#x27;smb&#x27;, &#x27;\\\\??\\\\UNC\\\\{{listener}}{{smb_listen_port}}\\\\{{rnd(8)}}\\\\aa&#x27;)]"}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.access": {"fullname": "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.access", "modulename": "coercer.methods.MS_EVEN.ElfrOpenBELW", "qualname": "ElfrOpenBELW.access", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;ncan_np&#x27;: [{&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\eventlog&#x27;, &#x27;uuid&#x27;: &#x27;82273fdc-e32a-18c3-3f78-827929dc23ea&#x27;, &#x27;version&#x27;: &#x27;0.0&#x27;}], &#x27;ncacn_ip_tcp&#x27;: [{&#x27;uuid&#x27;: &#x27;82273fdc-e32a-18c3-3f78-827929dc23ea&#x27;, &#x27;version&#x27;: &#x27;0.0&#x27;}]}"}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.protocol": {"fullname": "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.protocol", "modulename": "coercer.methods.MS_EVEN.ElfrOpenBELW", "qualname": "ElfrOpenBELW.protocol", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;longname&#x27;: &#x27;[MS-EVEN]: EventLog Remoting Protocol&#x27;, &#x27;shortname&#x27;: &#x27;MS-EVEN&#x27;}"}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.function": {"fullname": "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.function", "modulename": "coercer.methods.MS_EVEN.ElfrOpenBELW", "qualname": "ElfrOpenBELW.function", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;name&#x27;: &#x27;ElfrOpenBELW&#x27;, &#x27;opnum&#x27;: 9, &#x27;vulnerable_arguments&#x27;: [&#x27;BackupFileName&#x27;]}"}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.trigger": {"fullname": "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.trigger", "modulename": "coercer.methods.MS_EVEN.ElfrOpenBELW", "qualname": "ElfrOpenBELW.trigger", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">dcerpc_session</span>, </span><span class=\"param\"><span class=\"n\">target</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.methods.MS_FSRVP": {"fullname": "coercer.methods.MS_FSRVP", "modulename": "coercer.methods.MS_FSRVP", "kind": "module", "doc": "<p></p>\n"}, "coercer.methods.MS_FSRVP.IsPathShadowCopied": {"fullname": "coercer.methods.MS_FSRVP.IsPathShadowCopied", "modulename": "coercer.methods.MS_FSRVP.IsPathShadowCopied", "kind": "module", "doc": "<p></p>\n"}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied": {"fullname": "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied", "modulename": "coercer.methods.MS_FSRVP.IsPathShadowCopied", "qualname": "IsPathShadowCopied", "kind": "class", "doc": "<p>Coercing a machine to authenticate using function IsPathShadowCopied (opnum 9) of <a href=\"https://learn.microsoft.com/en-us/openspecs/windows_protocols/ms-fsrvp/dae107ec-8198-4778-a950-faa7edad125b\">MS-FSRVP Protocol</a></p>\n\n<p>Method found by:</p>\n\n<ul>\n<li><a href=\"https://twitter.com/topotam77\">@topotam77</a></li>\n</ul>\n", "bases": "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL"}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.exploit_paths": {"fullname": "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.exploit_paths", "modulename": "coercer.methods.MS_FSRVP.IsPathShadowCopied", "qualname": "IsPathShadowCopied.exploit_paths", "kind": "variable", "doc": "<p></p>\n", "default_value": "[(&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}\\x00&#x27;)]"}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.access": {"fullname": "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.access", "modulename": "coercer.methods.MS_FSRVP.IsPathShadowCopied", "qualname": "IsPathShadowCopied.access", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;ncan_np&#x27;: [{&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\Fssagentrpc&#x27;, &#x27;uuid&#x27;: &#x27;a8e0653c-2744-4389-a61d-7373df8b2292&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}], &#x27;ncacn_ip_tcp&#x27;: [{&#x27;uuid&#x27;: &#x27;a8e0653c-2744-4389-a61d-7373df8b2292&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}]}"}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.protocol": {"fullname": "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.protocol", "modulename": "coercer.methods.MS_FSRVP.IsPathShadowCopied", "qualname": "IsPathShadowCopied.protocol", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;longname&#x27;: &#x27;[MS-FSRVP]: File Server Remote VSS Protocol&#x27;, &#x27;shortname&#x27;: &#x27;MS-FSRVP&#x27;}"}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.function": {"fullname": "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.function", "modulename": "coercer.methods.MS_FSRVP.IsPathShadowCopied", "qualname": "IsPathShadowCopied.function", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;name&#x27;: &#x27;IsPathShadowCopied&#x27;, &#x27;opnum&#x27;: 9, &#x27;vulnerable_arguments&#x27;: [&#x27;ShareName&#x27;]}"}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.trigger": {"fullname": "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.trigger", "modulename": "coercer.methods.MS_FSRVP.IsPathShadowCopied", "qualname": "IsPathShadowCopied.trigger", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">dcerpc_session</span>, </span><span class=\"param\"><span class=\"n\">target</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.methods.MS_FSRVP.IsPathSupported": {"fullname": "coercer.methods.MS_FSRVP.IsPathSupported", "modulename": "coercer.methods.MS_FSRVP.IsPathSupported", "kind": "module", "doc": "<p></p>\n"}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported": {"fullname": "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported", "modulename": "coercer.methods.MS_FSRVP.IsPathSupported", "qualname": "IsPathSupported", "kind": "class", "doc": "<p>Coercing a machine to authenticate using function IsPathSupported (opnum 8) of <a href=\"https://learn.microsoft.com/en-us/openspecs/windows_protocols/ms-fsrvp/dae107ec-8198-4778-a950-faa7edad125b\">MS-FSRVP Protocol</a></p>\n\n<p>Method found by:</p>\n\n<ul>\n<li><a href=\"https://twitter.com/topotam77\">@topotam77</a></li>\n</ul>\n", "bases": "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL"}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.exploit_paths": {"fullname": "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.exploit_paths", "modulename": "coercer.methods.MS_FSRVP.IsPathSupported", "qualname": "IsPathSupported.exploit_paths", "kind": "variable", "doc": "<p></p>\n", "default_value": "[(&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}\\x00&#x27;)]"}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.access": {"fullname": "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.access", "modulename": "coercer.methods.MS_FSRVP.IsPathSupported", "qualname": "IsPathSupported.access", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;ncan_np&#x27;: [{&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\Fssagentrpc&#x27;, &#x27;uuid&#x27;: &#x27;a8e0653c-2744-4389-a61d-7373df8b2292&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}], &#x27;ncacn_ip_tcp&#x27;: [{&#x27;uuid&#x27;: &#x27;a8e0653c-2744-4389-a61d-7373df8b2292&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}]}"}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.protocol": {"fullname": "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.protocol", "modulename": "coercer.methods.MS_FSRVP.IsPathSupported", "qualname": "IsPathSupported.protocol", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;longname&#x27;: &#x27;[MS-FSRVP]: File Server Remote VSS Protocol&#x27;, &#x27;shortname&#x27;: &#x27;MS-FSRVP&#x27;}"}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.function": {"fullname": "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.function", "modulename": "coercer.methods.MS_FSRVP.IsPathSupported", "qualname": "IsPathSupported.function", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;name&#x27;: &#x27;IsPathSupported&#x27;, &#x27;opnum&#x27;: 8, &#x27;vulnerable_arguments&#x27;: [&#x27;ShareName&#x27;]}"}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.trigger": {"fullname": "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.trigger", "modulename": "coercer.methods.MS_FSRVP.IsPathSupported", "qualname": "IsPathSupported.trigger", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">dcerpc_session</span>, </span><span class=\"param\"><span class=\"n\">target</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.methods.MS_RPRN": {"fullname": "coercer.methods.MS_RPRN", "modulename": "coercer.methods.MS_RPRN", "kind": "module", "doc": "<p></p>\n"}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification": {"fullname": "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification", "modulename": "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification", "kind": "module", "doc": "<p></p>\n"}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"fullname": "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification", "modulename": "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification", "qualname": "RpcRemoteFindFirstPrinterChangeNotification", "kind": "class", "doc": "<p>Coercing a machine to authenticate using function RpcRemoteFindFirstPrinterChangeNotification (opnum 62) of [MS-RPRN]: Print System Remote Protocol (<a href=\"https://learn.microsoft.com/en-us/openspecs/windows_protocols/ms-rprn/b8b414d9-f1cd-4191-bb6b-87d09ab2fd83\">https://learn.microsoft.com/en-us/openspecs/windows_protocols/ms-rprn/b8b414d9-f1cd-4191-bb6b-87d09ab2fd83</a>)</p>\n\n<p>Method found by:\n -</p>\n", "bases": "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL"}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.exploit_paths": {"fullname": "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.exploit_paths", "modulename": "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification", "qualname": "RpcRemoteFindFirstPrinterChangeNotification.exploit_paths", "kind": "variable", "doc": "<p></p>\n", "default_value": "[(&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}\\x00&#x27;)]"}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.access": {"fullname": "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.access", "modulename": "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification", "qualname": "RpcRemoteFindFirstPrinterChangeNotification.access", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;ncan_np&#x27;: [{&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\spoolss&#x27;, &#x27;uuid&#x27;: &#x27;12345678-1234-abcd-ef00-0123456789ab&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}], &#x27;ncacn_ip_tcp&#x27;: [{&#x27;uuid&#x27;: &#x27;12345678-1234-ABCD-EF00-0123456789AB&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}]}"}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.protocol": {"fullname": "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.protocol", "modulename": "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification", "qualname": "RpcRemoteFindFirstPrinterChangeNotification.protocol", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;longname&#x27;: &#x27;[MS-RPRN]: Print System Remote Protocol&#x27;, &#x27;shortname&#x27;: &#x27;MS-RPRN&#x27;}"}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.function": {"fullname": "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.function", "modulename": "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification", "qualname": "RpcRemoteFindFirstPrinterChangeNotification.function", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;name&#x27;: &#x27;RpcRemoteFindFirstPrinterChangeNotification&#x27;, &#x27;opnum&#x27;: 62, &#x27;vulnerable_arguments&#x27;: [&#x27;pszLocalMachine&#x27;]}"}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.trigger": {"fullname": "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.trigger", "modulename": "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification", "qualname": "RpcRemoteFindFirstPrinterChangeNotification.trigger", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">dcerpc_session</span>, </span><span class=\"param\"><span class=\"n\">target</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx": {"fullname": "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx", "modulename": "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx", "kind": "module", "doc": "<p></p>\n"}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"fullname": "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx", "modulename": "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx", "qualname": "RpcRemoteFindFirstPrinterChangeNotificationEx", "kind": "class", "doc": "<p>Coercing a machine to authenticate using function RpcRemoteFindFirstPrinterChangeNotificationEx (opnum 65) of [MS-RPRN]: Print System Remote Protocol (<a href=\"https://docs.microsoft.com/en-us/openspecs/windows_protocols/ms-rprn/eb66b221-1c1f-4249-b8bc-c5befec2314d\">https://docs.microsoft.com/en-us/openspecs/windows_protocols/ms-rprn/eb66b221-1c1f-4249-b8bc-c5befec2314d</a>)</p>\n\n<p>Method found by:\n -</p>\n", "bases": "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL"}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.exploit_paths": {"fullname": "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.exploit_paths", "modulename": "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx", "qualname": "RpcRemoteFindFirstPrinterChangeNotificationEx.exploit_paths", "kind": "variable", "doc": "<p></p>\n", "default_value": "[(&#x27;smb&#x27;, &#x27;\\\\\\\\{{listener}}\\x00&#x27;)]"}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.access": {"fullname": "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.access", "modulename": "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx", "qualname": "RpcRemoteFindFirstPrinterChangeNotificationEx.access", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;ncan_np&#x27;: [{&#x27;namedpipe&#x27;: &#x27;\\\\PIPE\\\\spoolss&#x27;, &#x27;uuid&#x27;: &#x27;12345678-1234-abcd-ef00-0123456789ab&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}], &#x27;ncacn_ip_tcp&#x27;: [{&#x27;uuid&#x27;: &#x27;12345678-1234-ABCD-EF00-0123456789AB&#x27;, &#x27;version&#x27;: &#x27;1.0&#x27;}]}"}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.protocol": {"fullname": "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.protocol", "modulename": "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx", "qualname": "RpcRemoteFindFirstPrinterChangeNotificationEx.protocol", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;longname&#x27;: &#x27;[MS-RPRN]: Print System Remote Protocol&#x27;, &#x27;shortname&#x27;: &#x27;MS-RPRN&#x27;}"}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.function": {"fullname": "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.function", "modulename": "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx", "qualname": "RpcRemoteFindFirstPrinterChangeNotificationEx.function", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;name&#x27;: &#x27;RpcRemoteFindFirstPrinterChangeNotificationEx&#x27;, &#x27;opnum&#x27;: 65, &#x27;vulnerable_arguments&#x27;: [&#x27;pszLocalMachine&#x27;]}"}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.trigger": {"fullname": "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.trigger", "modulename": "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx", "qualname": "RpcRemoteFindFirstPrinterChangeNotificationEx.trigger", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">dcerpc_session</span>, </span><span class=\"param\"><span class=\"n\">target</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.models": {"fullname": "coercer.models", "modulename": "coercer.models", "kind": "module", "doc": "<p></p>\n"}, "coercer.models.MSPROTOCOLRPCCALL": {"fullname": "coercer.models.MSPROTOCOLRPCCALL", "modulename": "coercer.models.MSPROTOCOLRPCCALL", "kind": "module", "doc": "<p></p>\n"}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL": {"fullname": "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL", "modulename": "coercer.models.MSPROTOCOLRPCCALL", "qualname": "MSPROTOCOLRPCCALL", "kind": "class", "doc": "<p>Documentation for class MSPROTOCOLRPCCALL</p>\n"}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.__init__": {"fullname": "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.__init__", "modulename": "coercer.models.MSPROTOCOLRPCCALL", "qualname": "MSPROTOCOLRPCCALL.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">path</span></span>)</span>"}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.method_type": {"fullname": "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.method_type", "modulename": "coercer.models.MSPROTOCOLRPCCALL", "qualname": "MSPROTOCOLRPCCALL.method_type", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;MethodType.MICROSOFT_PROTOCOL: 1&gt;"}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.exploit_paths": {"fullname": "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.exploit_paths", "modulename": "coercer.models.MSPROTOCOLRPCCALL", "qualname": "MSPROTOCOLRPCCALL.exploit_paths", "kind": "variable", "doc": "<p></p>\n", "default_value": "[]"}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.path": {"fullname": "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.path", "modulename": "coercer.models.MSPROTOCOLRPCCALL", "qualname": "MSPROTOCOLRPCCALL.path", "kind": "variable", "doc": "<p></p>\n", "default_value": "None"}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.protocol": {"fullname": "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.protocol", "modulename": "coercer.models.MSPROTOCOLRPCCALL", "qualname": "MSPROTOCOLRPCCALL.protocol", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;longname&#x27;: &#x27;&#x27;, &#x27;shortname&#x27;: &#x27;&#x27;}"}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.function": {"fullname": "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.function", "modulename": "coercer.models.MSPROTOCOLRPCCALL", "qualname": "MSPROTOCOLRPCCALL.function", "kind": "variable", "doc": "<p></p>\n", "default_value": "{&#x27;name&#x27;: &#x27;&#x27;, &#x27;opnum&#x27;: 0}"}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.generate_exploit_templates": {"fullname": "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.generate_exploit_templates", "modulename": "coercer.models.MSPROTOCOLRPCCALL", "qualname": "MSPROTOCOLRPCCALL.generate_exploit_templates", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">desired_auth_type</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.network": {"fullname": "coercer.network", "modulename": "coercer.network", "kind": "module", "doc": "<p></p>\n"}, "coercer.network.DCERPCSession": {"fullname": "coercer.network.DCERPCSession", "modulename": "coercer.network.DCERPCSession", "kind": "module", "doc": "<p></p>\n"}, "coercer.network.DCERPCSession.DCERPCSession": {"fullname": "coercer.network.DCERPCSession.DCERPCSession", "modulename": "coercer.network.DCERPCSession", "qualname": "DCERPCSession", "kind": "class", "doc": "<p>Documentation for class DCERPCSession</p>\n"}, "coercer.network.DCERPCSession.DCERPCSession.__init__": {"fullname": "coercer.network.DCERPCSession.DCERPCSession.__init__", "modulename": "coercer.network.DCERPCSession", "qualname": "DCERPCSession.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">credentials</span>, </span><span class=\"param\"><span class=\"n\">verbose</span><span class=\"o\">=</span><span class=\"kc\">False</span></span>)</span>"}, "coercer.network.DCERPCSession.DCERPCSession.session": {"fullname": "coercer.network.DCERPCSession.DCERPCSession.session", "modulename": "coercer.network.DCERPCSession", "qualname": "DCERPCSession.session", "kind": "variable", "doc": "<p></p>\n", "default_value": "None"}, "coercer.network.DCERPCSession.DCERPCSession.target": {"fullname": "coercer.network.DCERPCSession.DCERPCSession.target", "modulename": "coercer.network.DCERPCSession", "qualname": "DCERPCSession.target", "kind": "variable", "doc": "<p></p>\n", "default_value": "None"}, "coercer.network.DCERPCSession.DCERPCSession.credentials": {"fullname": "coercer.network.DCERPCSession.DCERPCSession.credentials", "modulename": "coercer.network.DCERPCSession", "qualname": "DCERPCSession.credentials", "kind": "variable", "doc": "<p></p>\n"}, "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_ip_tcp": {"fullname": "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_ip_tcp", "modulename": "coercer.network.DCERPCSession", "qualname": "DCERPCSession.connect_ncacn_ip_tcp", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">target</span>, </span><span class=\"param\"><span class=\"n\">port</span>, </span><span class=\"param\"><span class=\"n\">targetIp</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">debug</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_np": {"fullname": "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_np", "modulename": "coercer.network.DCERPCSession", "qualname": "DCERPCSession.connect_ncacn_np", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">target</span>, </span><span class=\"param\"><span class=\"n\">pipe</span>, </span><span class=\"param\"><span class=\"n\">targetIp</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">debug</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.network.DCERPCSession.DCERPCSession.bind": {"fullname": "coercer.network.DCERPCSession.DCERPCSession.bind", "modulename": "coercer.network.DCERPCSession", "qualname": "DCERPCSession.bind", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">interface_uuid</span>, </span><span class=\"param\"><span class=\"n\">interface_version</span>, </span><span class=\"param\"><span class=\"n\">debug</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.network.DCERPCSession.DCERPCSession.set_verbose": {"fullname": "coercer.network.DCERPCSession.DCERPCSession.set_verbose", "modulename": "coercer.network.DCERPCSession", "qualname": "DCERPCSession.set_verbose", "kind": "function", "doc": "<p>set_verbose(value)</p>\n\n<p>Sets the current verbosity level</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">value</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.network.DCERPCSession.DCERPCSession.get_verbose": {"fullname": "coercer.network.DCERPCSession.DCERPCSession.get_verbose", "modulename": "coercer.network.DCERPCSession", "qualname": "DCERPCSession.get_verbose", "kind": "function", "doc": "<p>get_verbose()</p>\n\n<p>Gets the current verbosity level</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.network.DCERPCSessionError": {"fullname": "coercer.network.DCERPCSessionError", "modulename": "coercer.network.DCERPCSessionError", "kind": "module", "doc": "<p></p>\n"}, "coercer.network.DCERPCSessionError.DCERPCSessionError": {"fullname": "coercer.network.DCERPCSessionError.DCERPCSessionError", "modulename": "coercer.network.DCERPCSessionError", "qualname": "DCERPCSessionError", "kind": "class", "doc": "<p></p>\n", "bases": "impacket.dcerpc.v5.rpcrt.DCERPCException"}, "coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"fullname": "coercer.network.DCERPCSessionError.DCERPCSessionError.__init__", "modulename": "coercer.network.DCERPCSessionError", "qualname": "DCERPCSessionError.__init__", "kind": "function", "doc": "<p>:param string error_string: A string you want to show explaining the exception. Otherwise the default ones will be used\n:param integer error_code: the error_code if we're using a dictionary with error's descriptions\n:param NDR packet: if successfully decoded, the NDR packet of the response call. This could probably have useful\ninformation</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">error_string</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">error_code</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">packet</span><span class=\"o\">=</span><span class=\"kc\">None</span></span>)</span>"}, "coercer.network.Listener": {"fullname": "coercer.network.Listener", "modulename": "coercer.network.Listener", "kind": "module", "doc": "<p></p>\n"}, "coercer.network.Listener.Listener": {"fullname": "coercer.network.Listener.Listener", "modulename": "coercer.network.Listener", "qualname": "Listener", "kind": "class", "doc": "<p>class Listener</p>\n"}, "coercer.network.Listener.Listener.__init__": {"fullname": "coercer.network.Listener.Listener.__init__", "modulename": "coercer.network.Listener", "qualname": "Listener.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">options</span>, </span><span class=\"param\"><span class=\"n\">listen_ip</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">timeout</span><span class=\"o\">=</span><span class=\"kc\">None</span></span>)</span>"}, "coercer.network.Listener.Listener.options": {"fullname": "coercer.network.Listener.Listener.options", "modulename": "coercer.network.Listener", "qualname": "Listener.options", "kind": "variable", "doc": "<p></p>\n"}, "coercer.network.Listener.Listener.timeout": {"fullname": "coercer.network.Listener.Listener.timeout", "modulename": "coercer.network.Listener", "qualname": "Listener.timeout", "kind": "variable", "doc": "<p></p>\n"}, "coercer.network.Listener.Listener.listen_ip": {"fullname": "coercer.network.Listener.Listener.listen_ip", "modulename": "coercer.network.Listener", "qualname": "Listener.listen_ip", "kind": "variable", "doc": "<p></p>\n"}, "coercer.network.Listener.Listener.start_smb": {"fullname": "coercer.network.Listener.Listener.start_smb", "modulename": "coercer.network.Listener", "qualname": "Listener.start_smb", "kind": "function", "doc": "<p>Function start_smb(self, control_structure)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">control_structure</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.network.Listener.Listener.start_http": {"fullname": "coercer.network.Listener.Listener.start_http", "modulename": "coercer.network.Listener", "qualname": "Listener.start_http", "kind": "function", "doc": "<p>Function start_http(self, control_structure, http_port=80)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">control_structure</span>, </span><span class=\"param\"><span class=\"n\">http_port</span><span class=\"o\">=</span><span class=\"mi\">80</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.network.authentications": {"fullname": "coercer.network.authentications", "modulename": "coercer.network.authentications", "kind": "module", "doc": "<p></p>\n"}, "coercer.network.authentications.trigger_and_catch_authentication": {"fullname": "coercer.network.authentications.trigger_and_catch_authentication", "modulename": "coercer.network.authentications", "qualname": "trigger_and_catch_authentication", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">options</span>,</span><span class=\"param\">\t<span class=\"n\">dcerpc_session</span>,</span><span class=\"param\">\t<span class=\"n\">target</span>,</span><span class=\"param\">\t<span class=\"n\">method_trigger_function</span>,</span><span class=\"param\">\t<span class=\"n\">listenertype</span>,</span><span class=\"param\">\t<span class=\"n\">listen_ip</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">http_port</span><span class=\"o\">=</span><span class=\"mi\">80</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.network.authentications.trigger_authentication": {"fullname": "coercer.network.authentications.trigger_authentication", "modulename": "coercer.network.authentications", "qualname": "trigger_authentication", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">dcerpc_session</span>, </span><span class=\"param\"><span class=\"n\">target</span>, </span><span class=\"param\"><span class=\"n\">method_trigger_function</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.network.rpc": {"fullname": "coercer.network.rpc", "modulename": "coercer.network.rpc", "kind": "module", "doc": "<p></p>\n"}, "coercer.network.rpc.portmap_discover": {"fullname": "coercer.network.rpc.portmap_discover", "modulename": "coercer.network.rpc", "qualname": "portmap_discover", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">target</span>, </span><span class=\"param\"><span class=\"n\">port</span><span class=\"o\">=</span><span class=\"mi\">135</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.network.rpc.is_port_open": {"fullname": "coercer.network.rpc.is_port_open", "modulename": "coercer.network.rpc", "qualname": "is_port_open", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">target</span>, </span><span class=\"param\"><span class=\"n\">port</span>, </span><span class=\"param\"><span class=\"n\">verbose</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.network.rpc.can_bind_to_interface_on_port": {"fullname": "coercer.network.rpc.can_bind_to_interface_on_port", "modulename": "coercer.network.rpc", "qualname": "can_bind_to_interface_on_port", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">target</span>, </span><span class=\"param\"><span class=\"n\">port</span>, </span><span class=\"param\"><span class=\"n\">credentials</span>, </span><span class=\"param\"><span class=\"n\">uuid</span>, </span><span class=\"param\"><span class=\"n\">version</span>, </span><span class=\"param\"><span class=\"n\">verbose</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.network.smb": {"fullname": "coercer.network.smb", "modulename": "coercer.network.smb", "kind": "module", "doc": "<p></p>\n"}, "coercer.network.smb.init_smb_session": {"fullname": "coercer.network.smb.init_smb_session", "modulename": "coercer.network.smb", "qualname": "init_smb_session", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">args</span>,</span><span class=\"param\">\t<span class=\"n\">domain</span>,</span><span class=\"param\">\t<span class=\"n\">username</span>,</span><span class=\"param\">\t<span class=\"n\">password</span>,</span><span class=\"param\">\t<span class=\"n\">address</span>,</span><span class=\"param\">\t<span class=\"n\">lmhash</span>,</span><span class=\"param\">\t<span class=\"n\">nthash</span>,</span><span class=\"param\">\t<span class=\"n\">verbose</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.network.smb.try_login": {"fullname": "coercer.network.smb.try_login", "modulename": "coercer.network.smb", "qualname": "try_login", "kind": "function", "doc": "<p>Documentation for try_login</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">credentials</span>, </span><span class=\"param\"><span class=\"n\">target</span>, </span><span class=\"param\"><span class=\"n\">port</span><span class=\"o\">=</span><span class=\"mi\">445</span>, </span><span class=\"param\"><span class=\"n\">verbose</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.network.smb.list_remote_pipes": {"fullname": "coercer.network.smb.list_remote_pipes", "modulename": "coercer.network.smb", "qualname": "list_remote_pipes", "kind": "function", "doc": "<p>Function list_remote_pipes(target, credentials, share='IPC$', maxdepth=-1, debug=False)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">target</span>, </span><span class=\"param\"><span class=\"n\">credentials</span>, </span><span class=\"param\"><span class=\"n\">share</span><span class=\"o\">=</span><span class=\"s1\">&#39;IPC$&#39;</span>, </span><span class=\"param\"><span class=\"n\">maxdepth</span><span class=\"o\">=-</span><span class=\"mi\">1</span>, </span><span class=\"param\"><span class=\"n\">debug</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.network.smb.can_connect_to_pipe": {"fullname": "coercer.network.smb.can_connect_to_pipe", "modulename": "coercer.network.smb", "qualname": "can_connect_to_pipe", "kind": "function", "doc": "<p>Function can_connect_to_pipe(target, pipe, credentials, targetIp=None, verbose=False)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">target</span>, </span><span class=\"param\"><span class=\"n\">pipe</span>, </span><span class=\"param\"><span class=\"n\">credentials</span>, </span><span class=\"param\"><span class=\"n\">targetIp</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">verbose</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.network.smb.can_bind_to_interface": {"fullname": "coercer.network.smb.can_bind_to_interface", "modulename": "coercer.network.smb", "qualname": "can_bind_to_interface", "kind": "function", "doc": "<p>Function can_bind_to_interface(target, pipe, credentials, uuid, version, targetIp=None, verbose=False)</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">target</span>,</span><span class=\"param\">\t<span class=\"n\">pipe</span>,</span><span class=\"param\">\t<span class=\"n\">credentials</span>,</span><span class=\"param\">\t<span class=\"n\">uuid</span>,</span><span class=\"param\">\t<span class=\"n\">version</span>,</span><span class=\"param\">\t<span class=\"n\">targetIp</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">verbose</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.network.utils": {"fullname": "coercer.network.utils", "modulename": "coercer.network.utils", "kind": "module", "doc": "<p></p>\n"}, "coercer.network.utils.get_ip_address_of_interface": {"fullname": "coercer.network.utils.get_ip_address_of_interface", "modulename": "coercer.network.utils", "qualname": "get_ip_address_of_interface", "kind": "function", "doc": "<p>Function get_ip_address_of_interface(ifname)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">ifname</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.network.utils.get_ip_address_to_target_remote_host": {"fullname": "coercer.network.utils.get_ip_address_to_target_remote_host", "modulename": "coercer.network.utils", "qualname": "get_ip_address_to_target_remote_host", "kind": "function", "doc": "<p>Function get_ip_address_to_target_remote_host(host, port)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">host</span>, </span><span class=\"param\"><span class=\"n\">port</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.network.utils.can_listen_on_port": {"fullname": "coercer.network.utils.can_listen_on_port", "modulename": "coercer.network.utils", "qualname": "can_listen_on_port", "kind": "function", "doc": "<p>Function can_listen_on_port(listen_ip, port)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">listen_ip</span>, </span><span class=\"param\"><span class=\"n\">port</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.network.utils.get_ip_addr_to_listen_on": {"fullname": "coercer.network.utils.get_ip_addr_to_listen_on", "modulename": "coercer.network.utils", "qualname": "get_ip_addr_to_listen_on", "kind": "function", "doc": "<p>Function get_ip_addr_to_listen_on(target, options)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">target</span>, </span><span class=\"param\"><span class=\"n\">options</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.network.utils.get_next_http_listener_port": {"fullname": "coercer.network.utils.get_next_http_listener_port", "modulename": "coercer.network.utils", "qualname": "get_next_http_listener_port", "kind": "function", "doc": "<p>Function get_next_http_listener_port(current_value, listen_ip, options)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">current_value</span>, </span><span class=\"param\"><span class=\"n\">listen_ip</span>, </span><span class=\"param\"><span class=\"n\">options</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.structures": {"fullname": "coercer.structures", "modulename": "coercer.structures", "kind": "module", "doc": "<p></p>\n"}, "coercer.structures.Credentials": {"fullname": "coercer.structures.Credentials", "modulename": "coercer.structures.Credentials", "kind": "module", "doc": "<p></p>\n"}, "coercer.structures.Credentials.Credentials": {"fullname": "coercer.structures.Credentials.Credentials", "modulename": "coercer.structures.Credentials", "qualname": "Credentials", "kind": "class", "doc": "<p>Documentation for class Credentials</p>\n"}, "coercer.structures.Credentials.Credentials.__init__": {"fullname": "coercer.structures.Credentials.Credentials.__init__", "modulename": "coercer.structures.Credentials", "qualname": "Credentials.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">username</span>,</span><span class=\"param\">\t<span class=\"n\">password</span>,</span><span class=\"param\">\t<span class=\"n\">domain</span>,</span><span class=\"param\">\t<span class=\"n\">lmhash</span>,</span><span class=\"param\">\t<span class=\"n\">nthash</span>,</span><span class=\"param\">\t<span class=\"n\">doKerberos</span><span class=\"o\">=</span><span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">kdcHost</span><span class=\"o\">=</span><span class=\"kc\">None</span></span>)</span>"}, "coercer.structures.Credentials.Credentials.username": {"fullname": "coercer.structures.Credentials.Credentials.username", "modulename": "coercer.structures.Credentials", "qualname": "Credentials.username", "kind": "variable", "doc": "<p></p>\n"}, "coercer.structures.Credentials.Credentials.password": {"fullname": "coercer.structures.Credentials.Credentials.password", "modulename": "coercer.structures.Credentials", "qualname": "Credentials.password", "kind": "variable", "doc": "<p></p>\n"}, "coercer.structures.Credentials.Credentials.domain": {"fullname": "coercer.structures.Credentials.Credentials.domain", "modulename": "coercer.structures.Credentials", "qualname": "Credentials.domain", "kind": "variable", "doc": "<p></p>\n"}, "coercer.structures.Credentials.Credentials.lmhash": {"fullname": "coercer.structures.Credentials.Credentials.lmhash", "modulename": "coercer.structures.Credentials", "qualname": "Credentials.lmhash", "kind": "variable", "doc": "<p></p>\n"}, "coercer.structures.Credentials.Credentials.nthash": {"fullname": "coercer.structures.Credentials.Credentials.nthash", "modulename": "coercer.structures.Credentials", "qualname": "Credentials.nthash", "kind": "variable", "doc": "<p></p>\n"}, "coercer.structures.Credentials.Credentials.doKerberos": {"fullname": "coercer.structures.Credentials.Credentials.doKerberos", "modulename": "coercer.structures.Credentials", "qualname": "Credentials.doKerberos", "kind": "variable", "doc": "<p></p>\n"}, "coercer.structures.Credentials.Credentials.kdcHost": {"fullname": "coercer.structures.Credentials.Credentials.kdcHost", "modulename": "coercer.structures.Credentials", "qualname": "Credentials.kdcHost", "kind": "variable", "doc": "<p></p>\n"}, "coercer.structures.Credentials.Credentials.is_anonymous": {"fullname": "coercer.structures.Credentials.Credentials.is_anonymous", "modulename": "coercer.structures.Credentials", "qualname": "Credentials.is_anonymous", "kind": "function", "doc": "<p>Function is_anonymous()\nReturns True if anonymous authentication is used False otherwise</p>\n\n<p>Returns:\nbool:anonymous</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "coercer.structures.MethodType": {"fullname": "coercer.structures.MethodType", "modulename": "coercer.structures.MethodType", "kind": "module", "doc": "<p></p>\n"}, "coercer.structures.MethodType.MethodType": {"fullname": "coercer.structures.MethodType.MethodType", "modulename": "coercer.structures.MethodType", "qualname": "MethodType", "kind": "class", "doc": "<p>Enum class MethodType</p>\n", "bases": "enum.Enum"}, "coercer.structures.MethodType.MethodType.MICROSOFT_PROTOCOL": {"fullname": "coercer.structures.MethodType.MethodType.MICROSOFT_PROTOCOL", "modulename": "coercer.structures.MethodType", "qualname": "MethodType.MICROSOFT_PROTOCOL", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;MethodType.MICROSOFT_PROTOCOL: 1&gt;"}, "coercer.structures.MethodType.MethodType.OTHER": {"fullname": "coercer.structures.MethodType.MethodType.OTHER", "modulename": "coercer.structures.MethodType", "qualname": "MethodType.OTHER", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;MethodType.OTHER: 255&gt;"}, "coercer.structures.ReportingLevel": {"fullname": "coercer.structures.ReportingLevel", "modulename": "coercer.structures.ReportingLevel", "kind": "module", "doc": "<p></p>\n"}, "coercer.structures.ReportingLevel.ReportingLevel": {"fullname": "coercer.structures.ReportingLevel.ReportingLevel", "modulename": "coercer.structures.ReportingLevel", "qualname": "ReportingLevel", "kind": "class", "doc": "<p>Enum class ReportingLevel</p>\n", "bases": "enum.Enum"}, "coercer.structures.ReportingLevel.ReportingLevel.INFO": {"fullname": "coercer.structures.ReportingLevel.ReportingLevel.INFO", "modulename": "coercer.structures.ReportingLevel", "qualname": "ReportingLevel.INFO", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;ReportingLevel.INFO: 1&gt;"}, "coercer.structures.ReportingLevel.ReportingLevel.VERBOSE": {"fullname": "coercer.structures.ReportingLevel.ReportingLevel.VERBOSE", "modulename": "coercer.structures.ReportingLevel", "qualname": "ReportingLevel.VERBOSE", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;ReportingLevel.VERBOSE: 2&gt;"}, "coercer.structures.ReportingLevel.ReportingLevel.DEBUg": {"fullname": "coercer.structures.ReportingLevel.ReportingLevel.DEBUg", "modulename": "coercer.structures.ReportingLevel", "qualname": "ReportingLevel.DEBUg", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;ReportingLevel.DEBUg: 255&gt;"}, "coercer.structures.TestResult": {"fullname": "coercer.structures.TestResult", "modulename": "coercer.structures.TestResult", "kind": "module", "doc": "<p></p>\n"}, "coercer.structures.TestResult.TestResult": {"fullname": "coercer.structures.TestResult.TestResult", "modulename": "coercer.structures.TestResult", "qualname": "TestResult", "kind": "class", "doc": "<p>Enum class TestResult</p>\n", "bases": "enum.Enum"}, "coercer.structures.TestResult.TestResult.NO_AUTH_RECEIVED": {"fullname": "coercer.structures.TestResult.TestResult.NO_AUTH_RECEIVED", "modulename": "coercer.structures.TestResult", "qualname": "TestResult.NO_AUTH_RECEIVED", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;TestResult.NO_AUTH_RECEIVED: 0&gt;"}, "coercer.structures.TestResult.TestResult.SMB_AUTH_RECEIVED": {"fullname": "coercer.structures.TestResult.TestResult.SMB_AUTH_RECEIVED", "modulename": "coercer.structures.TestResult", "qualname": "TestResult.SMB_AUTH_RECEIVED", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;TestResult.SMB_AUTH_RECEIVED: 1&gt;"}, "coercer.structures.TestResult.TestResult.HTTP_AUTH_RECEIVED": {"fullname": "coercer.structures.TestResult.TestResult.HTTP_AUTH_RECEIVED", "modulename": "coercer.structures.TestResult", "qualname": "TestResult.HTTP_AUTH_RECEIVED", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;TestResult.HTTP_AUTH_RECEIVED: 2&gt;"}, "coercer.structures.TestResult.TestResult.NCA_S_UNK_IF": {"fullname": "coercer.structures.TestResult.TestResult.NCA_S_UNK_IF", "modulename": "coercer.structures.TestResult", "qualname": "TestResult.NCA_S_UNK_IF", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;TestResult.NCA_S_UNK_IF: 65537&gt;"}, "coercer.structures.TestResult.TestResult.ERROR_BAD_NETPATH": {"fullname": "coercer.structures.TestResult.TestResult.ERROR_BAD_NETPATH", "modulename": "coercer.structures.TestResult", "qualname": "TestResult.ERROR_BAD_NETPATH", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;TestResult.ERROR_BAD_NETPATH: 53&gt;"}, "coercer.structures.TestResult.TestResult.ERROR_INVALID_NAME": {"fullname": "coercer.structures.TestResult.TestResult.ERROR_INVALID_NAME", "modulename": "coercer.structures.TestResult", "qualname": "TestResult.ERROR_INVALID_NAME", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;TestResult.ERROR_INVALID_NAME: 123&gt;"}, "coercer.structures.TestResult.TestResult.RPC_X_BAD_STUB_DATA": {"fullname": "coercer.structures.TestResult.TestResult.RPC_X_BAD_STUB_DATA", "modulename": "coercer.structures.TestResult", "qualname": "TestResult.RPC_X_BAD_STUB_DATA", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;TestResult.RPC_X_BAD_STUB_DATA: 131073&gt;"}, "coercer.structures.TestResult.TestResult.RPC_S_ACCESS_DENIED": {"fullname": "coercer.structures.TestResult.TestResult.RPC_S_ACCESS_DENIED", "modulename": "coercer.structures.TestResult", "qualname": "TestResult.RPC_S_ACCESS_DENIED", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;TestResult.RPC_S_ACCESS_DENIED: 5&gt;"}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_BINDING": {"fullname": "coercer.structures.TestResult.TestResult.RPC_S_INVALID_BINDING", "modulename": "coercer.structures.TestResult", "qualname": "TestResult.RPC_S_INVALID_BINDING", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;TestResult.RPC_S_INVALID_BINDING: 1702&gt;"}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_NET_ADDR": {"fullname": "coercer.structures.TestResult.TestResult.RPC_S_INVALID_NET_ADDR", "modulename": "coercer.structures.TestResult", "qualname": "TestResult.RPC_S_INVALID_NET_ADDR", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;TestResult.RPC_S_INVALID_NET_ADDR: 1707&gt;"}, "coercer.structures.TestResult.TestResult.SMB_STATUS_PIPE_DISCONNECTED": {"fullname": "coercer.structures.TestResult.TestResult.SMB_STATUS_PIPE_DISCONNECTED", "modulename": "coercer.structures.TestResult", "qualname": "TestResult.SMB_STATUS_PIPE_DISCONNECTED", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;TestResult.SMB_STATUS_PIPE_DISCONNECTED: 196609&gt;"}}, "docInfo": {"coercer": {"qualname": 0, "fullname": 1, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.core": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.core.Filter": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.core.Filter.Filter": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 6}, "coercer.core.Filter.Filter.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 43, "bases": 0, "doc": 3}, "coercer.core.Filter.Filter.filter_method_name": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.core.Filter.Filter.filter_protocol_name": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.core.Filter.Filter.filter_pipe_name": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.core.Filter.Filter.method_matches_filter": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 14}, "coercer.core.Filter.Filter.pipe_matches_filter": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 17, "bases": 0, "doc": 15}, "coercer.core.Reporter": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.core.Reporter.CURSOR_UP_ONE": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "coercer.core.Reporter.ERASE_LINE": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 5, "signature": 0, "bases": 0, "doc": 3}, "coercer.core.Reporter.Reporter": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 6}, "coercer.core.Reporter.Reporter.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 3}, "coercer.core.Reporter.Reporter.options": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.core.Reporter.Reporter.verbose": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.core.Reporter.Reporter.test_results": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.core.Reporter.Reporter.print_testing": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 18, "bases": 0, "doc": 3}, "coercer.core.Reporter.Reporter.print_info": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 3}, "coercer.core.Reporter.Reporter.print_warn": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 3}, "coercer.core.Reporter.Reporter.print_verbose": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 3}, "coercer.core.Reporter.Reporter.report_test_result": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 50, "bases": 0, "doc": 3}, "coercer.core.Reporter.Reporter.exportXLSX": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 3}, "coercer.core.Reporter.Reporter.exportJSON": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 3}, "coercer.core.Reporter.Reporter.exportSQLITE": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 3}, "coercer.core.loader": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.core.loader.find_and_load_coerce_methods": {"qualname": 5, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 23}, "coercer.core.modes": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.core.modes.coerce": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.core.modes.coerce.action_coerce": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 32, "bases": 0, "doc": 3}, "coercer.core.modes.fuzz": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.core.modes.fuzz.action_fuzz": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 32, "bases": 0, "doc": 3}, "coercer.core.modes.scan": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.core.modes.scan.action_scan": {"qualname": 2, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 32, "bases": 0, "doc": 3}, "coercer.core.utils": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.core.utils.gen_random_name": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 3}, "coercer.core.utils.generate_exploit_templates": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 18, "bases": 0, "doc": 3}, "coercer.core.utils.generate_exploit_path_from_template": {"qualname": 5, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 40, "bases": 0, "doc": 3}, "coercer.methods": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_DFSNM": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 51}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.exploit_paths": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 44, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.access": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 61, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.protocol": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 26, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.function": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 23, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.trigger": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 3}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 51}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.exploit_paths": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 44, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.access": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 61, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.protocol": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 26, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.function": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 23, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.trigger": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 19}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB.structure": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 28, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 19}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 58, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 19}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 31, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 32}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.exploit_paths": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 44, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 194, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.protocol": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 24, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.function": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 23, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.trigger": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 19}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB.structure": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 28, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 19}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB.structure": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 28, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 19}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 58, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 19}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 31, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 14}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.exploit_paths": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 21, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 194, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.protocol": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 24, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.function": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 23, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.trigger": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 32}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.exploit_paths": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 44, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 194, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.protocol": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 24, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.function": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 23, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.trigger": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 19}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB.structure": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 28, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 32}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.exploit_paths": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 44, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 194, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.protocol": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 24, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.function": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 23, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.trigger": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 32}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.exploit_paths": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 44, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 194, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.protocol": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 24, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.function": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 23, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.trigger": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 32}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.exploit_paths": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 44, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 194, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.protocol": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 24, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.function": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 23, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.trigger": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 32}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.exploit_paths": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 44, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 194, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.protocol": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 24, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.function": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 23, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.trigger": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 32}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.exploit_paths": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 44, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 194, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.protocol": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 24, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.function": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 23, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.trigger": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 32}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.exploit_paths": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 44, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 194, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.protocol": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 24, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.function": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 23, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.trigger": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 19}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB.structure": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 28, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 19}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 58, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"qualname": 4, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 19}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.align": {"qualname": 5, "fullname": 10, "annotation": 0, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"qualname": 5, "fullname": 10, "annotation": 0, "default_value": 31, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 32}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.exploit_paths": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 44, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 194, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.protocol": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 24, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.function": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 23, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.trigger": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 3}, "coercer.methods.MS_EVEN": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EVEN.ElfrOpenBELW": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 36}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.exploit_paths": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 12, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.access": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 61, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.protocol": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 21, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.function": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 23, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.trigger": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 3}, "coercer.methods.MS_FSRVP": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_FSRVP.IsPathShadowCopied": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 32}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.exploit_paths": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 8, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.access": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 61, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.protocol": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 23, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.function": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 23, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.trigger": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 3}, "coercer.methods.MS_FSRVP.IsPathSupported": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 32}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.exploit_paths": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 8, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.access": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 61, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.protocol": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 23, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.function": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 23, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.trigger": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 3}, "coercer.methods.MS_RPRN": {"qualname": 0, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 38}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.exploit_paths": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 8, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.access": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 61, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.protocol": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 22, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.function": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 23, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.trigger": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 3}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 4, "doc": 38}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.exploit_paths": {"qualname": 3, "fullname": 8, "annotation": 0, "default_value": 8, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.access": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 61, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.protocol": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 22, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.function": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 23, "signature": 0, "bases": 0, "doc": 3}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.trigger": {"qualname": 2, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 3}, "coercer.models": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.models.MSPROTOCOLRPCCALL": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 6}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 9, "bases": 0, "doc": 3}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.method_type": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 8, "signature": 0, "bases": 0, "doc": 3}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.exploit_paths": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.path": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.protocol": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 14, "signature": 0, "bases": 0, "doc": 3}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.function": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 12, "signature": 0, "bases": 0, "doc": 3}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.generate_exploit_templates": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 23, "bases": 0, "doc": 3}, "coercer.network": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.network.DCERPCSession": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.network.DCERPCSession.DCERPCSession": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 6}, "coercer.network.DCERPCSession.DCERPCSession.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 3}, "coercer.network.DCERPCSession.DCERPCSession.session": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "coercer.network.DCERPCSession.DCERPCSession.target": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "coercer.network.DCERPCSession.DCERPCSession.credentials": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_ip_tcp": {"qualname": 5, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 41, "bases": 0, "doc": 3}, "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_np": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 41, "bases": 0, "doc": 3}, "coercer.network.DCERPCSession.DCERPCSession.bind": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 33, "bases": 0, "doc": 3}, "coercer.network.DCERPCSession.DCERPCSession.set_verbose": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 13}, "coercer.network.DCERPCSession.DCERPCSession.get_verbose": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 12}, "coercer.network.DCERPCSessionError": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.network.DCERPCSessionError.DCERPCSessionError": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 5, "doc": 3}, "coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 36, "bases": 0, "doc": 58}, "coercer.network.Listener": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.network.Listener.Listener": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 4}, "coercer.network.Listener.Listener.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 3}, "coercer.network.Listener.Listener.options": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.network.Listener.Listener.timeout": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.network.Listener.Listener.listen_ip": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.network.Listener.Listener.start_smb": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 17, "bases": 0, "doc": 9}, "coercer.network.Listener.Listener.start_http": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 28, "bases": 0, "doc": 12}, "coercer.network.authentications": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.network.authentications.trigger_and_catch_authentication": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 63, "bases": 0, "doc": 3}, "coercer.network.authentications.trigger_authentication": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 24, "bases": 0, "doc": 3}, "coercer.network.rpc": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.network.rpc.portmap_discover": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 3}, "coercer.network.rpc.is_port_open": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 3}, "coercer.network.rpc.can_bind_to_interface_on_port": {"qualname": 6, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 41, "bases": 0, "doc": 3}, "coercer.network.smb": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.network.smb.init_smb_session": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 59, "bases": 0, "doc": 3}, "coercer.network.smb.try_login": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 36, "bases": 0, "doc": 6}, "coercer.network.smb.list_remote_pipes": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 50, "bases": 0, "doc": 15}, "coercer.network.smb.can_connect_to_pipe": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 41, "bases": 0, "doc": 15}, "coercer.network.smb.can_bind_to_interface": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 58, "bases": 0, "doc": 17}, "coercer.network.utils": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.network.utils.get_ip_address_of_interface": {"qualname": 5, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 10}, "coercer.network.utils.get_ip_address_to_target_remote_host": {"qualname": 7, "fullname": 10, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 13}, "coercer.network.utils.can_listen_on_port": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 17, "bases": 0, "doc": 11}, "coercer.network.utils.get_ip_addr_to_listen_on": {"qualname": 6, "fullname": 9, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 12}, "coercer.network.utils.get_next_http_listener_port": {"qualname": 5, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 23, "bases": 0, "doc": 14}, "coercer.structures": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.structures.Credentials": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.structures.Credentials.Credentials": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 6}, "coercer.structures.Credentials.Credentials.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 56, "bases": 0, "doc": 3}, "coercer.structures.Credentials.Credentials.username": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.structures.Credentials.Credentials.password": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.structures.Credentials.Credentials.domain": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.structures.Credentials.Credentials.lmhash": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.structures.Credentials.Credentials.nthash": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.structures.Credentials.Credentials.doKerberos": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.structures.Credentials.Credentials.kdcHost": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.structures.Credentials.Credentials.is_anonymous": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 18}, "coercer.structures.MethodType": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.structures.MethodType.MethodType": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 5}, "coercer.structures.MethodType.MethodType.MICROSOFT_PROTOCOL": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 8, "signature": 0, "bases": 0, "doc": 3}, "coercer.structures.MethodType.MethodType.OTHER": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 7, "signature": 0, "bases": 0, "doc": 3}, "coercer.structures.ReportingLevel": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.structures.ReportingLevel.ReportingLevel": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 5}, "coercer.structures.ReportingLevel.ReportingLevel.INFO": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 7, "signature": 0, "bases": 0, "doc": 3}, "coercer.structures.ReportingLevel.ReportingLevel.VERBOSE": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 7, "signature": 0, "bases": 0, "doc": 3}, "coercer.structures.ReportingLevel.ReportingLevel.DEBUg": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 7, "signature": 0, "bases": 0, "doc": 3}, "coercer.structures.TestResult": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "coercer.structures.TestResult.TestResult": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 5}, "coercer.structures.TestResult.TestResult.NO_AUTH_RECEIVED": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "coercer.structures.TestResult.TestResult.SMB_AUTH_RECEIVED": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "coercer.structures.TestResult.TestResult.HTTP_AUTH_RECEIVED": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "coercer.structures.TestResult.TestResult.NCA_S_UNK_IF": {"qualname": 5, "fullname": 8, "annotation": 0, "default_value": 10, "signature": 0, "bases": 0, "doc": 3}, "coercer.structures.TestResult.TestResult.ERROR_BAD_NETPATH": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "coercer.structures.TestResult.TestResult.ERROR_INVALID_NAME": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "coercer.structures.TestResult.TestResult.RPC_X_BAD_STUB_DATA": {"qualname": 6, "fullname": 9, "annotation": 0, "default_value": 11, "signature": 0, "bases": 0, "doc": 3}, "coercer.structures.TestResult.TestResult.RPC_S_ACCESS_DENIED": {"qualname": 5, "fullname": 8, "annotation": 0, "default_value": 10, "signature": 0, "bases": 0, "doc": 3}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_BINDING": {"qualname": 5, "fullname": 8, "annotation": 0, "default_value": 10, "signature": 0, "bases": 0, "doc": 3}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_NET_ADDR": {"qualname": 6, "fullname": 9, "annotation": 0, "default_value": 11, "signature": 0, "bases": 0, "doc": 3}, "coercer.structures.TestResult.TestResult.SMB_STATUS_PIPE_DISCONNECTED": {"qualname": 5, "fullname": 8, "annotation": 0, "default_value": 10, "signature": 0, "bases": 0, "doc": 3}}, "length": 273, "save": true}, "index": {"qualname": {"root": {"docs": {"coercer.core.Filter.Filter.__init__": {"tf": 1}, "coercer.core.Reporter.Reporter.__init__": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.__init__": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.__init__": {"tf": 1}, "coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}, "coercer.network.Listener.Listener.__init__": {"tf": 1}, "coercer.structures.Credentials.Credentials.__init__": {"tf": 1}}, "df": 7, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"coercer.core.Filter.Filter": {"tf": 1}, "coercer.core.Filter.Filter.__init__": {"tf": 1}, "coercer.core.Filter.Filter.filter_method_name": {"tf": 1.4142135623730951}, "coercer.core.Filter.Filter.filter_protocol_name": {"tf": 1.4142135623730951}, "coercer.core.Filter.Filter.filter_pipe_name": {"tf": 1.4142135623730951}, "coercer.core.Filter.Filter.method_matches_filter": {"tf": 1.4142135623730951}, "coercer.core.Filter.Filter.pipe_matches_filter": {"tf": 1.4142135623730951}}, "df": 7}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"coercer.core.loader.find_and_load_coerce_methods": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "z": {"docs": {"coercer.core.modes.fuzz.action_fuzz": {"tf": 1}}, "df": 1}}, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.function": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.function": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.function": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.function": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.function": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.function": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.function": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.function": {"tf": 1}}, "df": 18}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"coercer.core.utils.generate_exploit_path_from_template": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"coercer.core.Filter.Filter.__init__": {"tf": 1}, "coercer.core.Reporter.Reporter.__init__": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.__init__": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.__init__": {"tf": 1}, "coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}, "coercer.network.Listener.Listener.__init__": {"tf": 1}, "coercer.network.smb.init_smb_session": {"tf": 1}, "coercer.structures.Credentials.Credentials.__init__": {"tf": 1}}, "df": 8}}, "f": {"docs": {}, "df": 0, "o": {"docs": {"coercer.core.Reporter.Reporter.print_info": {"tf": 1}, "coercer.structures.ReportingLevel.ReportingLevel.INFO": {"tf": 1}}, "df": 2}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"coercer.network.rpc.can_bind_to_interface_on_port": {"tf": 1}, "coercer.network.smb.can_bind_to_interface": {"tf": 1}, "coercer.network.utils.get_ip_address_of_interface": {"tf": 1}}, "df": 3}}}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {"coercer.structures.TestResult.TestResult.ERROR_INVALID_NAME": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_BINDING": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_NET_ADDR": {"tf": 1}}, "df": 3}}}}}}, "s": {"docs": {"coercer.network.rpc.is_port_open": {"tf": 1}, "coercer.structures.Credentials.Credentials.is_anonymous": {"tf": 1}}, "df": 2, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.exploit_paths": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.access": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.protocol": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.function": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.trigger": {"tf": 1}}, "df": 6}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.exploit_paths": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.access": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.protocol": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.function": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.trigger": {"tf": 1}}, "df": 6}}}}}}}}}}}}}}, "p": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_ip_tcp": {"tf": 1}, "coercer.network.Listener.Listener.listen_ip": {"tf": 1}, "coercer.network.utils.get_ip_address_of_interface": {"tf": 1}, "coercer.network.utils.get_ip_address_to_target_remote_host": {"tf": 1}, "coercer.network.utils.get_ip_addr_to_listen_on": {"tf": 1}}, "df": 5}, "f": {"docs": {"coercer.structures.TestResult.TestResult.NCA_S_UNK_IF": {"tf": 1}}, "df": 1}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"coercer.core.Filter.Filter.filter_method_name": {"tf": 1}, "coercer.core.Filter.Filter.method_matches_filter": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.method_type": {"tf": 1}}, "df": 3, "s": {"docs": {"coercer.core.loader.find_and_load_coerce_methods": {"tf": 1}}, "df": 1}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"coercer.structures.MethodType.MethodType": {"tf": 1}, "coercer.structures.MethodType.MethodType.MICROSOFT_PROTOCOL": {"tf": 1}, "coercer.structures.MethodType.MethodType.OTHER": {"tf": 1}}, "df": 3}}}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"coercer.core.Filter.Filter.method_matches_filter": {"tf": 1}, "coercer.core.Filter.Filter.pipe_matches_filter": {"tf": 1}}, "df": 2}}}}}}, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.__init__": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.method_type": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.exploit_paths": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.path": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.protocol": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.function": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.generate_exploit_templates": {"tf": 1}}, "df": 8}}}}}}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "t": {"docs": {"coercer.structures.MethodType.MethodType.MICROSOFT_PROTOCOL": {"tf": 1}}, "df": 1}}}}}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.Filter.Filter.filter_method_name": {"tf": 1}, "coercer.core.Filter.Filter.filter_protocol_name": {"tf": 1}, "coercer.core.Filter.Filter.filter_pipe_name": {"tf": 1}, "coercer.core.utils.gen_random_name": {"tf": 1}, "coercer.structures.TestResult.TestResult.ERROR_INVALID_NAME": {"tf": 1}}, "df": 5}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {"coercer.structures.TestResult.TestResult.RPC_S_INVALID_NET_ADDR": {"tf": 1}}, "df": 1, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.exploit_paths": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.access": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.protocol": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.function": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.trigger": {"tf": 1}}, "df": 6}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.exploit_paths": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.access": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.protocol": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.function": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.trigger": {"tf": 1}}, "df": 6}}}}}}}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"coercer.structures.TestResult.TestResult.ERROR_BAD_NETPATH": {"tf": 1}}, "df": 1}}}}}, "x": {"docs": {}, "df": 0, "t": {"docs": {"coercer.network.utils.get_next_http_listener_port": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {"coercer.structures.TestResult.TestResult.NCA_S_UNK_IF": {"tf": 1}}, "df": 1, "c": {"docs": {}, "df": 0, "n": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_ip_tcp": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_np": {"tf": 1}}, "df": 2}}}}, "p": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_np": {"tf": 1}}, "df": 1}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {"coercer.structures.Credentials.Credentials.nthash": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {"coercer.structures.TestResult.TestResult.NO_AUTH_RECEIVED": {"tf": 1}}, "df": 1}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"coercer.core.Filter.Filter.filter_protocol_name": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.protocol": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.protocol": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.protocol": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.protocol": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.protocol": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.protocol": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.protocol": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.protocol": {"tf": 1}, "coercer.structures.MethodType.MethodType.MICROSOFT_PROTOCOL": {"tf": 1}}, "df": 20}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"coercer.core.Reporter.Reporter.print_testing": {"tf": 1}, "coercer.core.Reporter.Reporter.print_info": {"tf": 1}, "coercer.core.Reporter.Reporter.print_warn": {"tf": 1}, "coercer.core.Reporter.Reporter.print_verbose": {"tf": 1}}, "df": 4}}}}, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.Filter.Filter.filter_pipe_name": {"tf": 1}, "coercer.core.Filter.Filter.pipe_matches_filter": {"tf": 1}, "coercer.network.smb.can_connect_to_pipe": {"tf": 1}, "coercer.structures.TestResult.TestResult.SMB_STATUS_PIPE_DISCONNECTED": {"tf": 1}}, "df": 4, "s": {"docs": {"coercer.network.smb.list_remote_pipes": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"coercer.core.utils.generate_exploit_path_from_template": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.path": {"tf": 1}}, "df": 2, "s": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.exploit_paths": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.exploit_paths": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.exploit_paths": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.exploit_paths": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.exploit_paths": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.exploit_paths": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.exploit_paths": {"tf": 1}}, "df": 18}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"coercer.structures.Credentials.Credentials.password": {"tf": 1}}, "df": 1}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"coercer.network.rpc.is_port_open": {"tf": 1}, "coercer.network.rpc.can_bind_to_interface_on_port": {"tf": 1}, "coercer.network.utils.can_listen_on_port": {"tf": 1}, "coercer.network.utils.get_next_http_listener_port": {"tf": 1}}, "df": 4, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {"coercer.network.rpc.portmap_discover": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"coercer.core.Reporter.CURSOR_UP_ONE": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.loader.find_and_load_coerce_methods": {"tf": 1}, "coercer.core.modes.coerce.action_coerce": {"tf": 1}}, "df": 2}}}}, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_ip_tcp": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_np": {"tf": 1}, "coercer.network.smb.can_connect_to_pipe": {"tf": 1}}, "df": 3}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.align": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1}}, "df": 13}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.credentials": {"tf": 1}, "coercer.structures.Credentials.Credentials": {"tf": 1}, "coercer.structures.Credentials.Credentials.__init__": {"tf": 1}, "coercer.structures.Credentials.Credentials.username": {"tf": 1}, "coercer.structures.Credentials.Credentials.password": {"tf": 1}, "coercer.structures.Credentials.Credentials.domain": {"tf": 1}, "coercer.structures.Credentials.Credentials.lmhash": {"tf": 1}, "coercer.structures.Credentials.Credentials.nthash": {"tf": 1}, "coercer.structures.Credentials.Credentials.doKerberos": {"tf": 1}, "coercer.structures.Credentials.Credentials.kdcHost": {"tf": 1}, "coercer.structures.Credentials.Credentials.is_anonymous": {"tf": 1}}, "df": 11}}}}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"coercer.network.authentications.trigger_and_catch_authentication": {"tf": 1}}, "df": 1}}}, "n": {"docs": {"coercer.network.rpc.can_bind_to_interface_on_port": {"tf": 1}, "coercer.network.smb.can_connect_to_pipe": {"tf": 1}, "coercer.network.smb.can_bind_to_interface": {"tf": 1}, "coercer.network.utils.can_listen_on_port": {"tf": 1}}, "df": 4}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {"coercer.core.Reporter.CURSOR_UP_ONE": {"tf": 1}}, "df": 1}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"coercer.structures.Credentials.Credentials.username": {"tf": 1}}, "df": 1}}}}}}}, "n": {"docs": {}, "df": 0, "k": {"docs": {"coercer.structures.TestResult.TestResult.NCA_S_UNK_IF": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.network.rpc.can_bind_to_interface_on_port": {"tf": 1}, "coercer.network.utils.can_listen_on_port": {"tf": 1}, "coercer.network.utils.get_ip_addr_to_listen_on": {"tf": 1}}, "df": 3, "e": {"docs": {"coercer.core.Reporter.CURSOR_UP_ONE": {"tf": 1}}, "df": 1}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"coercer.core.Reporter.Reporter.options": {"tf": 1}, "coercer.network.Listener.Listener.options": {"tf": 1}}, "df": 2}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {"coercer.network.rpc.is_port_open": {"tf": 1}}, "df": 1}}}, "f": {"docs": {"coercer.network.utils.get_ip_address_of_interface": {"tf": 1}}, "df": 1}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"coercer.structures.MethodType.MethodType.OTHER": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.Reporter.ERASE_LINE": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"coercer.structures.TestResult.TestResult.ERROR_BAD_NETPATH": {"tf": 1}, "coercer.structures.TestResult.TestResult.ERROR_INVALID_NAME": {"tf": 1}}, "df": 2}}}}, "x": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "x": {"docs": {"coercer.core.Reporter.Reporter.exportXLSX": {"tf": 1}}, "df": 1}}}}, "j": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.core.Reporter.Reporter.exportJSON": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.Reporter.Reporter.exportSQLITE": {"tf": 1}}, "df": 1}}}}}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"coercer.core.utils.generate_exploit_templates": {"tf": 1}, "coercer.core.utils.generate_exploit_path_from_template": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.exploit_paths": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.exploit_paths": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.exploit_paths": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.exploit_paths": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.exploit_paths": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.exploit_paths": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.exploit_paths": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.generate_exploit_templates": {"tf": 1}}, "df": 21}}}}}}, "f": {"docs": {}, "df": 0, "s": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB.structure": {"tf": 1}}, "df": 10, "r": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.trigger": {"tf": 1}}, "df": 6, "e": {"docs": {}, "df": 0, "x": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.trigger": {"tf": 1}}, "df": 6}}}}}}}}}}}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {"coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.trigger": {"tf": 1}}, "df": 6}}}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.trigger": {"tf": 1}}, "df": 6}}}}}}}}}}}}}}}}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {"coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.trigger": {"tf": 1}}, "df": 6}}}}}}}}}}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {"coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.trigger": {"tf": 1}}, "df": 6}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "w": {"docs": {"coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.trigger": {"tf": 1}}, "df": 6}}}}}}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.trigger": {"tf": 1}}, "df": 6}}}}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.trigger": {"tf": 1}}, "df": 6}}}}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.trigger": {"tf": 1}}, "df": 6}}}}}}}}}}}}}}}}}}}}}}}}, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.align": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1}}, "df": 13}}}}}}}}}, "l": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "w": {"docs": {"coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.exploit_paths": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.access": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.protocol": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.function": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.trigger": {"tf": 1}}, "df": 6}}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.Reporter.ERASE_LINE": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.align": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1}, "coercer.network.smb.list_remote_pipes": {"tf": 1}}, "df": 8, "e": {"docs": {}, "df": 0, "n": {"docs": {"coercer.network.Listener.Listener.listen_ip": {"tf": 1}, "coercer.network.utils.can_listen_on_port": {"tf": 1}, "coercer.network.utils.get_ip_addr_to_listen_on": {"tf": 1}}, "df": 3, "e": {"docs": {}, "df": 0, "r": {"docs": {"coercer.network.Listener.Listener": {"tf": 1}, "coercer.network.Listener.Listener.__init__": {"tf": 1}, "coercer.network.Listener.Listener.options": {"tf": 1}, "coercer.network.Listener.Listener.timeout": {"tf": 1}, "coercer.network.Listener.Listener.listen_ip": {"tf": 1}, "coercer.network.Listener.Listener.start_smb": {"tf": 1}, "coercer.network.Listener.Listener.start_http": {"tf": 1}, "coercer.network.utils.get_next_http_listener_port": {"tf": 1}}, "df": 8}}}}}}}, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"coercer.core.loader.find_and_load_coerce_methods": {"tf": 1}}, "df": 1}}, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"coercer.network.smb.try_login": {"tf": 1}}, "df": 1}}}}, "m": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {"coercer.structures.Credentials.Credentials.lmhash": {"tf": 1}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"coercer.core.Reporter.Reporter.report_test_result": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "r": {"docs": {"coercer.core.Reporter.Reporter": {"tf": 1}, "coercer.core.Reporter.Reporter.__init__": {"tf": 1}, "coercer.core.Reporter.Reporter.options": {"tf": 1}, "coercer.core.Reporter.Reporter.verbose": {"tf": 1}, "coercer.core.Reporter.Reporter.test_results": {"tf": 1}, "coercer.core.Reporter.Reporter.print_testing": {"tf": 1}, "coercer.core.Reporter.Reporter.print_info": {"tf": 1}, "coercer.core.Reporter.Reporter.print_warn": {"tf": 1}, "coercer.core.Reporter.Reporter.print_verbose": {"tf": 1}, "coercer.core.Reporter.Reporter.report_test_result": {"tf": 1}, "coercer.core.Reporter.Reporter.exportXLSX": {"tf": 1}, "coercer.core.Reporter.Reporter.exportJSON": {"tf": 1}, "coercer.core.Reporter.Reporter.exportSQLITE": {"tf": 1}}, "df": 13}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"coercer.structures.ReportingLevel.ReportingLevel": {"tf": 1}, "coercer.structures.ReportingLevel.ReportingLevel.INFO": {"tf": 1}, "coercer.structures.ReportingLevel.ReportingLevel.VERBOSE": {"tf": 1}, "coercer.structures.ReportingLevel.ReportingLevel.DEBUg": {"tf": 1}}, "df": 4}}}}}}}}}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"coercer.core.Reporter.Reporter.report_test_result": {"tf": 1}}, "df": 1, "s": {"docs": {"coercer.core.Reporter.Reporter.test_results": {"tf": 1}}, "df": 1}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"coercer.network.smb.list_remote_pipes": {"tf": 1}, "coercer.network.utils.get_ip_address_to_target_remote_host": {"tf": 1}}, "df": 2}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"coercer.structures.TestResult.TestResult.NO_AUTH_RECEIVED": {"tf": 1}, "coercer.structures.TestResult.TestResult.SMB_AUTH_RECEIVED": {"tf": 1}, "coercer.structures.TestResult.TestResult.HTTP_AUTH_RECEIVED": {"tf": 1}}, "df": 3}}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"coercer.core.utils.gen_random_name": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "c": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_X_BAD_STUB_DATA": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_ACCESS_DENIED": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_BINDING": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_NET_ADDR": {"tf": 1}}, "df": 8, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.exploit_paths": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.access": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.protocol": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.function": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.trigger": {"tf": 1}}, "df": 6, "e": {"docs": {}, "df": 0, "x": {"docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.exploit_paths": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.access": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.protocol": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.function": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.trigger": {"tf": 1}}, "df": 6}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.Reporter.Reporter.verbose": {"tf": 1}, "coercer.core.Reporter.Reporter.print_verbose": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.set_verbose": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.get_verbose": {"tf": 1}, "coercer.structures.ReportingLevel.ReportingLevel.VERBOSE": {"tf": 1}}, "df": 5}}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"coercer.core.Reporter.Reporter.test_results": {"tf": 1}, "coercer.core.Reporter.Reporter.report_test_result": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"coercer.core.Reporter.Reporter.print_testing": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"coercer.structures.TestResult.TestResult": {"tf": 1}, "coercer.structures.TestResult.TestResult.NO_AUTH_RECEIVED": {"tf": 1}, "coercer.structures.TestResult.TestResult.SMB_AUTH_RECEIVED": {"tf": 1}, "coercer.structures.TestResult.TestResult.HTTP_AUTH_RECEIVED": {"tf": 1}, "coercer.structures.TestResult.TestResult.NCA_S_UNK_IF": {"tf": 1}, "coercer.structures.TestResult.TestResult.ERROR_BAD_NETPATH": {"tf": 1}, "coercer.structures.TestResult.TestResult.ERROR_INVALID_NAME": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_X_BAD_STUB_DATA": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_ACCESS_DENIED": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_BINDING": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_NET_ADDR": {"tf": 1}, "coercer.structures.TestResult.TestResult.SMB_STATUS_PIPE_DISCONNECTED": {"tf": 1}}, "df": 12}}}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.utils.generate_exploit_path_from_template": {"tf": 1}}, "df": 1, "s": {"docs": {"coercer.core.utils.generate_exploit_templates": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.generate_exploit_templates": {"tf": 1}}, "df": 2}}}}}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.trigger": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.trigger": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.trigger": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.trigger": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.trigger": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.trigger": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.trigger": {"tf": 1}, "coercer.network.authentications.trigger_and_catch_authentication": {"tf": 1}, "coercer.network.authentications.trigger_authentication": {"tf": 1}}, "df": 19}}}}}, "y": {"docs": {"coercer.network.smb.try_login": {"tf": 1}}, "df": 1}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.method_type": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.target": {"tf": 1}, "coercer.network.utils.get_ip_address_to_target_remote_host": {"tf": 1}}, "df": 2}}}}}, "c": {"docs": {}, "df": 0, "p": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_ip_tcp": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"coercer.network.Listener.Listener.timeout": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {"coercer.network.rpc.can_bind_to_interface_on_port": {"tf": 1}, "coercer.network.smb.can_connect_to_pipe": {"tf": 1}, "coercer.network.smb.can_bind_to_interface": {"tf": 1}, "coercer.network.utils.get_ip_address_to_target_remote_host": {"tf": 1}, "coercer.network.utils.get_ip_addr_to_listen_on": {"tf": 1}}, "df": 5}}, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"coercer.core.Reporter.Reporter.print_warn": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"coercer.core.loader.find_and_load_coerce_methods": {"tf": 1}, "coercer.network.authentications.trigger_and_catch_authentication": {"tf": 1}}, "df": 2}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"coercer.structures.Credentials.Credentials.is_anonymous": {"tf": 1}}, "df": 1}}}}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.core.modes.coerce.action_coerce": {"tf": 1}, "coercer.core.modes.fuzz.action_fuzz": {"tf": 1}, "coercer.core.modes.scan.action_scan": {"tf": 1}}, "df": 3}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.access": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.access": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.access": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.access": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.access": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.access": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_ACCESS_DENIED": {"tf": 1}}, "df": 18}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {"coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.align": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"coercer.structures.TestResult.TestResult.NO_AUTH_RECEIVED": {"tf": 1}, "coercer.structures.TestResult.TestResult.SMB_AUTH_RECEIVED": {"tf": 1}, "coercer.structures.TestResult.TestResult.HTTP_AUTH_RECEIVED": {"tf": 1}}, "df": 3, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.network.authentications.trigger_and_catch_authentication": {"tf": 1}, "coercer.network.authentications.trigger_authentication": {"tf": 1}}, "df": 2}}}}}}}}}}}}}, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {"coercer.network.utils.get_ip_addr_to_listen_on": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_NET_ADDR": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"coercer.network.utils.get_ip_address_of_interface": {"tf": 1}, "coercer.network.utils.get_ip_address_to_target_remote_host": {"tf": 1}}, "df": 2}}}}}}}, "s": {"docs": {"coercer.structures.TestResult.TestResult.NCA_S_UNK_IF": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_ACCESS_DENIED": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_BINDING": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_NET_ADDR": {"tf": 1}}, "df": 4, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"coercer.core.modes.scan.action_scan": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1}}, "df": 11}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"coercer.network.Listener.Listener.start_smb": {"tf": 1}, "coercer.network.Listener.Listener.start_http": {"tf": 1}}, "df": 2}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"coercer.structures.TestResult.TestResult.SMB_STATUS_PIPE_DISCONNECTED": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "b": {"docs": {"coercer.structures.TestResult.TestResult.RPC_X_BAD_STUB_DATA": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.session": {"tf": 1}, "coercer.network.smb.init_smb_session": {"tf": 1}}, "df": 2}}}}}, "t": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.set_verbose": {"tf": 1}}, "df": 1}}, "m": {"docs": {}, "df": 0, "b": {"docs": {"coercer.network.Listener.Listener.start_smb": {"tf": 1}, "coercer.network.smb.init_smb_session": {"tf": 1}, "coercer.structures.TestResult.TestResult.SMB_AUTH_RECEIVED": {"tf": 1}, "coercer.structures.TestResult.TestResult.SMB_STATUS_PIPE_DISCONNECTED": {"tf": 1}}, "df": 4}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"coercer.core.utils.gen_random_name": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.utils.generate_exploit_templates": {"tf": 1}, "coercer.core.utils.generate_exploit_path_from_template": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.generate_exploit_templates": {"tf": 1}}, "df": 3}}}}}}, "t": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.get_verbose": {"tf": 1}, "coercer.network.utils.get_ip_address_of_interface": {"tf": 1}, "coercer.network.utils.get_ip_address_to_target_remote_host": {"tf": 1}, "coercer.network.utils.get_ip_addr_to_listen_on": {"tf": 1}, "coercer.network.utils.get_next_http_listener_port": {"tf": 1}}, "df": 5}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.align": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1}}, "df": 15}}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {"coercer.network.Listener.Listener.start_http": {"tf": 1}, "coercer.network.utils.get_next_http_listener_port": {"tf": 1}, "coercer.structures.TestResult.TestResult.HTTP_AUTH_RECEIVED": {"tf": 1}}, "df": 3}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"coercer.network.utils.get_ip_address_to_target_remote_host": {"tf": 1}}, "df": 1}}}}, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "b": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB.structure": {"tf": 1}}, "df": 10}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.bind": {"tf": 1}, "coercer.network.rpc.can_bind_to_interface_on_port": {"tf": 1}, "coercer.network.smb.can_bind_to_interface": {"tf": 1}}, "df": 3, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"coercer.structures.TestResult.TestResult.RPC_S_INVALID_BINDING": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {"coercer.structures.TestResult.TestResult.ERROR_BAD_NETPATH": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_X_BAD_STUB_DATA": {"tf": 1}}, "df": 2}}}, "d": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.network.DCERPCSession.DCERPCSession": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.__init__": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.session": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.target": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.credentials": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_ip_tcp": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_np": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.bind": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.set_verbose": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.get_verbose": {"tf": 1}}, "df": 10, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError": {"tf": 1}, "coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"coercer.network.rpc.portmap_discover": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"coercer.structures.TestResult.TestResult.SMB_STATUS_PIPE_DISCONNECTED": {"tf": 1}}, "df": 1}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"coercer.structures.Credentials.Credentials.domain": {"tf": 1}}, "df": 1}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {"coercer.structures.Credentials.Credentials.doKerberos": {"tf": 1}}, "df": 1}}}}}}}}}, "e": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "g": {"docs": {"coercer.structures.ReportingLevel.ReportingLevel.DEBUg": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"coercer.structures.TestResult.TestResult.RPC_S_ACCESS_DENIED": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"coercer.structures.TestResult.TestResult.RPC_X_BAD_STUB_DATA": {"tf": 1}}, "df": 1}}}}, "k": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"coercer.structures.Credentials.Credentials.kdcHost": {"tf": 1}}, "df": 1}}}}}}}, "x": {"docs": {"coercer.structures.TestResult.TestResult.RPC_X_BAD_STUB_DATA": {"tf": 1}}, "df": 1}}}, "fullname": {"root": {"docs": {"coercer.core.Filter.Filter.__init__": {"tf": 1}, "coercer.core.Reporter.Reporter.__init__": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.__init__": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.__init__": {"tf": 1}, "coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}, "coercer.network.Listener.Listener.__init__": {"tf": 1}, "coercer.structures.Credentials.Credentials.__init__": {"tf": 1}}, "df": 7, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.loader.find_and_load_coerce_methods": {"tf": 1}, "coercer.core.modes.coerce": {"tf": 1}, "coercer.core.modes.coerce.action_coerce": {"tf": 1.4142135623730951}}, "df": 3, "r": {"docs": {"coercer": {"tf": 1}, "coercer.core": {"tf": 1}, "coercer.core.Filter": {"tf": 1}, "coercer.core.Filter.Filter": {"tf": 1}, "coercer.core.Filter.Filter.__init__": {"tf": 1}, "coercer.core.Filter.Filter.filter_method_name": {"tf": 1}, "coercer.core.Filter.Filter.filter_protocol_name": {"tf": 1}, "coercer.core.Filter.Filter.filter_pipe_name": {"tf": 1}, "coercer.core.Filter.Filter.method_matches_filter": {"tf": 1}, "coercer.core.Filter.Filter.pipe_matches_filter": {"tf": 1}, "coercer.core.Reporter": {"tf": 1}, "coercer.core.Reporter.CURSOR_UP_ONE": {"tf": 1}, "coercer.core.Reporter.ERASE_LINE": {"tf": 1}, "coercer.core.Reporter.Reporter": {"tf": 1}, "coercer.core.Reporter.Reporter.__init__": {"tf": 1}, "coercer.core.Reporter.Reporter.options": {"tf": 1}, "coercer.core.Reporter.Reporter.verbose": {"tf": 1}, "coercer.core.Reporter.Reporter.test_results": {"tf": 1}, "coercer.core.Reporter.Reporter.print_testing": {"tf": 1}, "coercer.core.Reporter.Reporter.print_info": {"tf": 1}, "coercer.core.Reporter.Reporter.print_warn": {"tf": 1}, "coercer.core.Reporter.Reporter.print_verbose": {"tf": 1}, "coercer.core.Reporter.Reporter.report_test_result": {"tf": 1}, "coercer.core.Reporter.Reporter.exportXLSX": {"tf": 1}, "coercer.core.Reporter.Reporter.exportJSON": {"tf": 1}, "coercer.core.Reporter.Reporter.exportSQLITE": {"tf": 1}, "coercer.core.loader": {"tf": 1}, "coercer.core.loader.find_and_load_coerce_methods": {"tf": 1}, "coercer.core.modes": {"tf": 1}, "coercer.core.modes.coerce": {"tf": 1}, "coercer.core.modes.coerce.action_coerce": {"tf": 1}, "coercer.core.modes.fuzz": {"tf": 1}, "coercer.core.modes.fuzz.action_fuzz": {"tf": 1}, "coercer.core.modes.scan": {"tf": 1}, "coercer.core.modes.scan.action_scan": {"tf": 1}, "coercer.core.utils": {"tf": 1}, "coercer.core.utils.gen_random_name": {"tf": 1}, "coercer.core.utils.generate_exploit_templates": {"tf": 1}, "coercer.core.utils.generate_exploit_path_from_template": {"tf": 1}, "coercer.methods": {"tf": 1}, "coercer.methods.MS_DFSNM": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.exploit_paths": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.access": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.protocol": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.function": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.trigger": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.exploit_paths": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.access": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.protocol": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.function": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.trigger": {"tf": 1}, "coercer.methods.MS_EFSR": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.align": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.trigger": {"tf": 1}, "coercer.methods.MS_EVEN": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.exploit_paths": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.access": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.protocol": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.function": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.trigger": {"tf": 1}, "coercer.methods.MS_FSRVP": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.exploit_paths": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.access": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.protocol": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.function": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.trigger": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.exploit_paths": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.access": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.protocol": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.function": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.trigger": {"tf": 1}, "coercer.methods.MS_RPRN": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.exploit_paths": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.access": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.protocol": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.function": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.trigger": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.exploit_paths": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.access": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.protocol": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.function": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.trigger": {"tf": 1}, "coercer.models": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.__init__": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.method_type": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.exploit_paths": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.path": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.protocol": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.function": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.generate_exploit_templates": {"tf": 1}, "coercer.network": {"tf": 1}, "coercer.network.DCERPCSession": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.__init__": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.session": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.target": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.credentials": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_ip_tcp": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_np": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.bind": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.set_verbose": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.get_verbose": {"tf": 1}, "coercer.network.DCERPCSessionError": {"tf": 1}, "coercer.network.DCERPCSessionError.DCERPCSessionError": {"tf": 1}, "coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}, "coercer.network.Listener": {"tf": 1}, "coercer.network.Listener.Listener": {"tf": 1}, "coercer.network.Listener.Listener.__init__": {"tf": 1}, "coercer.network.Listener.Listener.options": {"tf": 1}, "coercer.network.Listener.Listener.timeout": {"tf": 1}, "coercer.network.Listener.Listener.listen_ip": {"tf": 1}, "coercer.network.Listener.Listener.start_smb": {"tf": 1}, "coercer.network.Listener.Listener.start_http": {"tf": 1}, "coercer.network.authentications": {"tf": 1}, "coercer.network.authentications.trigger_and_catch_authentication": {"tf": 1}, "coercer.network.authentications.trigger_authentication": {"tf": 1}, "coercer.network.rpc": {"tf": 1}, "coercer.network.rpc.portmap_discover": {"tf": 1}, "coercer.network.rpc.is_port_open": {"tf": 1}, "coercer.network.rpc.can_bind_to_interface_on_port": {"tf": 1}, "coercer.network.smb": {"tf": 1}, "coercer.network.smb.init_smb_session": {"tf": 1}, "coercer.network.smb.try_login": {"tf": 1}, "coercer.network.smb.list_remote_pipes": {"tf": 1}, "coercer.network.smb.can_connect_to_pipe": {"tf": 1}, "coercer.network.smb.can_bind_to_interface": {"tf": 1}, "coercer.network.utils": {"tf": 1}, "coercer.network.utils.get_ip_address_of_interface": {"tf": 1}, "coercer.network.utils.get_ip_address_to_target_remote_host": {"tf": 1}, "coercer.network.utils.can_listen_on_port": {"tf": 1}, "coercer.network.utils.get_ip_addr_to_listen_on": {"tf": 1}, "coercer.network.utils.get_next_http_listener_port": {"tf": 1}, "coercer.structures": {"tf": 1}, "coercer.structures.Credentials": {"tf": 1}, "coercer.structures.Credentials.Credentials": {"tf": 1}, "coercer.structures.Credentials.Credentials.__init__": {"tf": 1}, "coercer.structures.Credentials.Credentials.username": {"tf": 1}, "coercer.structures.Credentials.Credentials.password": {"tf": 1}, "coercer.structures.Credentials.Credentials.domain": {"tf": 1}, "coercer.structures.Credentials.Credentials.lmhash": {"tf": 1}, "coercer.structures.Credentials.Credentials.nthash": {"tf": 1}, "coercer.structures.Credentials.Credentials.doKerberos": {"tf": 1}, "coercer.structures.Credentials.Credentials.kdcHost": {"tf": 1}, "coercer.structures.Credentials.Credentials.is_anonymous": {"tf": 1}, "coercer.structures.MethodType": {"tf": 1}, "coercer.structures.MethodType.MethodType": {"tf": 1}, "coercer.structures.MethodType.MethodType.MICROSOFT_PROTOCOL": {"tf": 1}, "coercer.structures.MethodType.MethodType.OTHER": {"tf": 1}, "coercer.structures.ReportingLevel": {"tf": 1}, "coercer.structures.ReportingLevel.ReportingLevel": {"tf": 1}, "coercer.structures.ReportingLevel.ReportingLevel.INFO": {"tf": 1}, "coercer.structures.ReportingLevel.ReportingLevel.VERBOSE": {"tf": 1}, "coercer.structures.ReportingLevel.ReportingLevel.DEBUg": {"tf": 1}, "coercer.structures.TestResult": {"tf": 1}, "coercer.structures.TestResult.TestResult": {"tf": 1}, "coercer.structures.TestResult.TestResult.NO_AUTH_RECEIVED": {"tf": 1}, "coercer.structures.TestResult.TestResult.SMB_AUTH_RECEIVED": {"tf": 1}, "coercer.structures.TestResult.TestResult.HTTP_AUTH_RECEIVED": {"tf": 1}, "coercer.structures.TestResult.TestResult.NCA_S_UNK_IF": {"tf": 1}, "coercer.structures.TestResult.TestResult.ERROR_BAD_NETPATH": {"tf": 1}, "coercer.structures.TestResult.TestResult.ERROR_INVALID_NAME": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_X_BAD_STUB_DATA": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_ACCESS_DENIED": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_BINDING": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_NET_ADDR": {"tf": 1}, "coercer.structures.TestResult.TestResult.SMB_STATUS_PIPE_DISCONNECTED": {"tf": 1}}, "df": 273}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core": {"tf": 1}, "coercer.core.Filter": {"tf": 1}, "coercer.core.Filter.Filter": {"tf": 1}, "coercer.core.Filter.Filter.__init__": {"tf": 1}, "coercer.core.Filter.Filter.filter_method_name": {"tf": 1}, "coercer.core.Filter.Filter.filter_protocol_name": {"tf": 1}, "coercer.core.Filter.Filter.filter_pipe_name": {"tf": 1}, "coercer.core.Filter.Filter.method_matches_filter": {"tf": 1}, "coercer.core.Filter.Filter.pipe_matches_filter": {"tf": 1}, "coercer.core.Reporter": {"tf": 1}, "coercer.core.Reporter.CURSOR_UP_ONE": {"tf": 1}, "coercer.core.Reporter.ERASE_LINE": {"tf": 1}, "coercer.core.Reporter.Reporter": {"tf": 1}, "coercer.core.Reporter.Reporter.__init__": {"tf": 1}, "coercer.core.Reporter.Reporter.options": {"tf": 1}, "coercer.core.Reporter.Reporter.verbose": {"tf": 1}, "coercer.core.Reporter.Reporter.test_results": {"tf": 1}, "coercer.core.Reporter.Reporter.print_testing": {"tf": 1}, "coercer.core.Reporter.Reporter.print_info": {"tf": 1}, "coercer.core.Reporter.Reporter.print_warn": {"tf": 1}, "coercer.core.Reporter.Reporter.print_verbose": {"tf": 1}, "coercer.core.Reporter.Reporter.report_test_result": {"tf": 1}, "coercer.core.Reporter.Reporter.exportXLSX": {"tf": 1}, "coercer.core.Reporter.Reporter.exportJSON": {"tf": 1}, "coercer.core.Reporter.Reporter.exportSQLITE": {"tf": 1}, "coercer.core.loader": {"tf": 1}, "coercer.core.loader.find_and_load_coerce_methods": {"tf": 1}, "coercer.core.modes": {"tf": 1}, "coercer.core.modes.coerce": {"tf": 1}, "coercer.core.modes.coerce.action_coerce": {"tf": 1}, "coercer.core.modes.fuzz": {"tf": 1}, "coercer.core.modes.fuzz.action_fuzz": {"tf": 1}, "coercer.core.modes.scan": {"tf": 1}, "coercer.core.modes.scan.action_scan": {"tf": 1}, "coercer.core.utils": {"tf": 1}, "coercer.core.utils.gen_random_name": {"tf": 1}, "coercer.core.utils.generate_exploit_templates": {"tf": 1}, "coercer.core.utils.generate_exploit_path_from_template": {"tf": 1}}, "df": 38}}, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_ip_tcp": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_np": {"tf": 1}, "coercer.network.smb.can_connect_to_pipe": {"tf": 1}}, "df": 3}}}}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"coercer.core.Reporter.CURSOR_UP_ONE": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.align": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1}}, "df": 13}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.credentials": {"tf": 1}, "coercer.structures.Credentials": {"tf": 1}, "coercer.structures.Credentials.Credentials": {"tf": 1.4142135623730951}, "coercer.structures.Credentials.Credentials.__init__": {"tf": 1.4142135623730951}, "coercer.structures.Credentials.Credentials.username": {"tf": 1.4142135623730951}, "coercer.structures.Credentials.Credentials.password": {"tf": 1.4142135623730951}, "coercer.structures.Credentials.Credentials.domain": {"tf": 1.4142135623730951}, "coercer.structures.Credentials.Credentials.lmhash": {"tf": 1.4142135623730951}, "coercer.structures.Credentials.Credentials.nthash": {"tf": 1.4142135623730951}, "coercer.structures.Credentials.Credentials.doKerberos": {"tf": 1.4142135623730951}, "coercer.structures.Credentials.Credentials.kdcHost": {"tf": 1.4142135623730951}, "coercer.structures.Credentials.Credentials.is_anonymous": {"tf": 1.4142135623730951}}, "df": 12}}}}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"coercer.network.authentications.trigger_and_catch_authentication": {"tf": 1}}, "df": 1}}}, "n": {"docs": {"coercer.network.rpc.can_bind_to_interface_on_port": {"tf": 1}, "coercer.network.smb.can_connect_to_pipe": {"tf": 1}, "coercer.network.smb.can_bind_to_interface": {"tf": 1}, "coercer.network.utils.can_listen_on_port": {"tf": 1}}, "df": 4}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"coercer.core.Filter": {"tf": 1}, "coercer.core.Filter.Filter": {"tf": 1.4142135623730951}, "coercer.core.Filter.Filter.__init__": {"tf": 1.4142135623730951}, "coercer.core.Filter.Filter.filter_method_name": {"tf": 1.7320508075688772}, "coercer.core.Filter.Filter.filter_protocol_name": {"tf": 1.7320508075688772}, "coercer.core.Filter.Filter.filter_pipe_name": {"tf": 1.7320508075688772}, "coercer.core.Filter.Filter.method_matches_filter": {"tf": 1.7320508075688772}, "coercer.core.Filter.Filter.pipe_matches_filter": {"tf": 1.7320508075688772}}, "df": 8}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"coercer.core.loader.find_and_load_coerce_methods": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "z": {"docs": {"coercer.core.modes.fuzz": {"tf": 1}, "coercer.core.modes.fuzz.action_fuzz": {"tf": 1.4142135623730951}}, "df": 2}}, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.function": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.function": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.function": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.function": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.function": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.function": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.function": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.function": {"tf": 1}}, "df": 18}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"coercer.core.utils.generate_exploit_path_from_template": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "p": {"docs": {"coercer.methods.MS_FSRVP": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.exploit_paths": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.access": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.protocol": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.function": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.trigger": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.exploit_paths": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.access": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.protocol": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.function": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.trigger": {"tf": 1}}, "df": 15}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"coercer.core.Filter.Filter.__init__": {"tf": 1}, "coercer.core.Reporter.Reporter.__init__": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.__init__": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.__init__": {"tf": 1}, "coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}, "coercer.network.Listener.Listener.__init__": {"tf": 1}, "coercer.network.smb.init_smb_session": {"tf": 1}, "coercer.structures.Credentials.Credentials.__init__": {"tf": 1}}, "df": 8}}, "f": {"docs": {}, "df": 0, "o": {"docs": {"coercer.core.Reporter.Reporter.print_info": {"tf": 1}, "coercer.structures.ReportingLevel.ReportingLevel.INFO": {"tf": 1}}, "df": 2}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"coercer.network.rpc.can_bind_to_interface_on_port": {"tf": 1}, "coercer.network.smb.can_bind_to_interface": {"tf": 1}, "coercer.network.utils.get_ip_address_of_interface": {"tf": 1}}, "df": 3}}}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {"coercer.structures.TestResult.TestResult.ERROR_INVALID_NAME": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_BINDING": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_NET_ADDR": {"tf": 1}}, "df": 3}}}}}}, "s": {"docs": {"coercer.network.rpc.is_port_open": {"tf": 1}, "coercer.structures.Credentials.Credentials.is_anonymous": {"tf": 1}}, "df": 2, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"coercer.methods.MS_FSRVP.IsPathShadowCopied": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied": {"tf": 1.4142135623730951}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.function": {"tf": 1.4142135623730951}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.trigger": {"tf": 1.4142135623730951}}, "df": 7}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"coercer.methods.MS_FSRVP.IsPathSupported": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported": {"tf": 1.4142135623730951}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.function": {"tf": 1.4142135623730951}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.trigger": {"tf": 1.4142135623730951}}, "df": 7}}}}}}}}}}}}}}, "p": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_ip_tcp": {"tf": 1}, "coercer.network.Listener.Listener.listen_ip": {"tf": 1}, "coercer.network.utils.get_ip_address_of_interface": {"tf": 1}, "coercer.network.utils.get_ip_address_to_target_remote_host": {"tf": 1}, "coercer.network.utils.get_ip_addr_to_listen_on": {"tf": 1}}, "df": 5}, "f": {"docs": {"coercer.structures.TestResult.TestResult.NCA_S_UNK_IF": {"tf": 1}}, "df": 1}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"coercer.core.Filter.Filter.filter_method_name": {"tf": 1}, "coercer.core.Filter.Filter.method_matches_filter": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.method_type": {"tf": 1}}, "df": 3, "s": {"docs": {"coercer.core.loader.find_and_load_coerce_methods": {"tf": 1}, "coercer.methods": {"tf": 1}, "coercer.methods.MS_DFSNM": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.exploit_paths": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.access": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.protocol": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.function": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.trigger": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.exploit_paths": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.access": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.protocol": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.function": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.trigger": {"tf": 1}, "coercer.methods.MS_EFSR": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.align": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.trigger": {"tf": 1}, "coercer.methods.MS_EVEN": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.exploit_paths": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.access": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.protocol": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.function": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.trigger": {"tf": 1}, "coercer.methods.MS_FSRVP": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.exploit_paths": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.access": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.protocol": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.function": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.trigger": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.exploit_paths": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.access": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.protocol": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.function": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.trigger": {"tf": 1}, "coercer.methods.MS_RPRN": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.exploit_paths": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.access": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.protocol": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.function": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.trigger": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.exploit_paths": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.access": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.protocol": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.function": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.trigger": {"tf": 1}}, "df": 149}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"coercer.structures.MethodType": {"tf": 1}, "coercer.structures.MethodType.MethodType": {"tf": 1.4142135623730951}, "coercer.structures.MethodType.MethodType.MICROSOFT_PROTOCOL": {"tf": 1.4142135623730951}, "coercer.structures.MethodType.MethodType.OTHER": {"tf": 1.4142135623730951}}, "df": 4}}}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"coercer.core.Filter.Filter.method_matches_filter": {"tf": 1}, "coercer.core.Filter.Filter.pipe_matches_filter": {"tf": 1}}, "df": 2}}}}}}, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"coercer.core.modes": {"tf": 1}, "coercer.core.modes.coerce": {"tf": 1}, "coercer.core.modes.coerce.action_coerce": {"tf": 1}, "coercer.core.modes.fuzz": {"tf": 1}, "coercer.core.modes.fuzz.action_fuzz": {"tf": 1}, "coercer.core.modes.scan": {"tf": 1}, "coercer.core.modes.scan.action_scan": {"tf": 1}}, "df": 7}, "l": {"docs": {}, "df": 0, "s": {"docs": {"coercer.models": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.__init__": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.method_type": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.exploit_paths": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.path": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.protocol": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.function": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.generate_exploit_templates": {"tf": 1}}, "df": 10}}}}}, "s": {"docs": {"coercer.methods.MS_DFSNM": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.exploit_paths": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.access": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.protocol": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.function": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.trigger": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.exploit_paths": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.access": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.protocol": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.function": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.trigger": {"tf": 1}, "coercer.methods.MS_EFSR": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.align": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.trigger": {"tf": 1}, "coercer.methods.MS_EVEN": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.exploit_paths": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.access": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.protocol": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.function": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.trigger": {"tf": 1}, "coercer.methods.MS_FSRVP": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.exploit_paths": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.access": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.protocol": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.function": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.trigger": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.exploit_paths": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.access": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.protocol": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.function": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.trigger": {"tf": 1}, "coercer.methods.MS_RPRN": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.exploit_paths": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.access": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.protocol": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.function": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.trigger": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.exploit_paths": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.access": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.protocol": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.function": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.trigger": {"tf": 1}}, "df": 147, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"coercer.models.MSPROTOCOLRPCCALL": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL": {"tf": 1.4142135623730951}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.__init__": {"tf": 1.4142135623730951}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.method_type": {"tf": 1.4142135623730951}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.exploit_paths": {"tf": 1.4142135623730951}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.path": {"tf": 1.4142135623730951}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.protocol": {"tf": 1.4142135623730951}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.function": {"tf": 1.4142135623730951}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.generate_exploit_templates": {"tf": 1.4142135623730951}}, "df": 9}}}}}}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "t": {"docs": {"coercer.structures.MethodType.MethodType.MICROSOFT_PROTOCOL": {"tf": 1}}, "df": 1}}}}}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.Filter.Filter.filter_method_name": {"tf": 1}, "coercer.core.Filter.Filter.filter_protocol_name": {"tf": 1}, "coercer.core.Filter.Filter.filter_pipe_name": {"tf": 1}, "coercer.core.utils.gen_random_name": {"tf": 1}, "coercer.structures.TestResult.TestResult.ERROR_INVALID_NAME": {"tf": 1}}, "df": 5}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {"coercer.structures.TestResult.TestResult.RPC_S_INVALID_NET_ADDR": {"tf": 1}}, "df": 1, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1.4142135623730951}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.function": {"tf": 1.4142135623730951}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.trigger": {"tf": 1.4142135623730951}}, "df": 7}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1.4142135623730951}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.function": {"tf": 1.4142135623730951}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.trigger": {"tf": 1.4142135623730951}}, "df": 7}}}}}}}}}}}}}}}}}, "w": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {"coercer.network": {"tf": 1}, "coercer.network.DCERPCSession": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.__init__": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.session": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.target": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.credentials": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_ip_tcp": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_np": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.bind": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.set_verbose": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.get_verbose": {"tf": 1}, "coercer.network.DCERPCSessionError": {"tf": 1}, "coercer.network.DCERPCSessionError.DCERPCSessionError": {"tf": 1}, "coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}, "coercer.network.Listener": {"tf": 1}, "coercer.network.Listener.Listener": {"tf": 1}, "coercer.network.Listener.Listener.__init__": {"tf": 1}, "coercer.network.Listener.Listener.options": {"tf": 1}, "coercer.network.Listener.Listener.timeout": {"tf": 1}, "coercer.network.Listener.Listener.listen_ip": {"tf": 1}, "coercer.network.Listener.Listener.start_smb": {"tf": 1}, "coercer.network.Listener.Listener.start_http": {"tf": 1}, "coercer.network.authentications": {"tf": 1}, "coercer.network.authentications.trigger_and_catch_authentication": {"tf": 1}, "coercer.network.authentications.trigger_authentication": {"tf": 1}, "coercer.network.rpc": {"tf": 1}, "coercer.network.rpc.portmap_discover": {"tf": 1}, "coercer.network.rpc.is_port_open": {"tf": 1}, "coercer.network.rpc.can_bind_to_interface_on_port": {"tf": 1}, "coercer.network.smb": {"tf": 1}, "coercer.network.smb.init_smb_session": {"tf": 1}, "coercer.network.smb.try_login": {"tf": 1}, "coercer.network.smb.list_remote_pipes": {"tf": 1}, "coercer.network.smb.can_connect_to_pipe": {"tf": 1}, "coercer.network.smb.can_bind_to_interface": {"tf": 1}, "coercer.network.utils": {"tf": 1}, "coercer.network.utils.get_ip_address_of_interface": {"tf": 1}, "coercer.network.utils.get_ip_address_to_target_remote_host": {"tf": 1}, "coercer.network.utils.can_listen_on_port": {"tf": 1}, "coercer.network.utils.get_ip_addr_to_listen_on": {"tf": 1}, "coercer.network.utils.get_next_http_listener_port": {"tf": 1}}, "df": 42}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"coercer.structures.TestResult.TestResult.ERROR_BAD_NETPATH": {"tf": 1}}, "df": 1}}}}}, "x": {"docs": {}, "df": 0, "t": {"docs": {"coercer.network.utils.get_next_http_listener_port": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {"coercer.structures.TestResult.TestResult.NCA_S_UNK_IF": {"tf": 1}}, "df": 1, "c": {"docs": {}, "df": 0, "n": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_ip_tcp": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_np": {"tf": 1}}, "df": 2}}}}, "p": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_np": {"tf": 1}}, "df": 1}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {"coercer.structures.Credentials.Credentials.nthash": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {"coercer.structures.TestResult.TestResult.NO_AUTH_RECEIVED": {"tf": 1}}, "df": 1}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"coercer.core.Filter.Filter.filter_protocol_name": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.protocol": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.protocol": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.protocol": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.protocol": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.protocol": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.protocol": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.protocol": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.protocol": {"tf": 1}, "coercer.structures.MethodType.MethodType.MICROSOFT_PROTOCOL": {"tf": 1}}, "df": 20}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"coercer.core.Reporter.Reporter.print_testing": {"tf": 1}, "coercer.core.Reporter.Reporter.print_info": {"tf": 1}, "coercer.core.Reporter.Reporter.print_warn": {"tf": 1}, "coercer.core.Reporter.Reporter.print_verbose": {"tf": 1}}, "df": 4}}}}, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.Filter.Filter.filter_pipe_name": {"tf": 1}, "coercer.core.Filter.Filter.pipe_matches_filter": {"tf": 1}, "coercer.network.smb.can_connect_to_pipe": {"tf": 1}, "coercer.structures.TestResult.TestResult.SMB_STATUS_PIPE_DISCONNECTED": {"tf": 1}}, "df": 4, "s": {"docs": {"coercer.network.smb.list_remote_pipes": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"coercer.core.utils.generate_exploit_path_from_template": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.path": {"tf": 1}}, "df": 2, "s": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.exploit_paths": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.exploit_paths": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.exploit_paths": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.exploit_paths": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.exploit_paths": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.exploit_paths": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.exploit_paths": {"tf": 1}}, "df": 18}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"coercer.structures.Credentials.Credentials.password": {"tf": 1}}, "df": 1}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"coercer.network.rpc.is_port_open": {"tf": 1}, "coercer.network.rpc.can_bind_to_interface_on_port": {"tf": 1}, "coercer.network.utils.can_listen_on_port": {"tf": 1}, "coercer.network.utils.get_next_http_listener_port": {"tf": 1}}, "df": 4, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {"coercer.network.rpc.portmap_discover": {"tf": 1}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"coercer.core.Reporter.Reporter.report_test_result": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "r": {"docs": {"coercer.core.Reporter": {"tf": 1}, "coercer.core.Reporter.CURSOR_UP_ONE": {"tf": 1}, "coercer.core.Reporter.ERASE_LINE": {"tf": 1}, "coercer.core.Reporter.Reporter": {"tf": 1.4142135623730951}, "coercer.core.Reporter.Reporter.__init__": {"tf": 1.4142135623730951}, "coercer.core.Reporter.Reporter.options": {"tf": 1.4142135623730951}, "coercer.core.Reporter.Reporter.verbose": {"tf": 1.4142135623730951}, "coercer.core.Reporter.Reporter.test_results": {"tf": 1.4142135623730951}, "coercer.core.Reporter.Reporter.print_testing": {"tf": 1.4142135623730951}, "coercer.core.Reporter.Reporter.print_info": {"tf": 1.4142135623730951}, "coercer.core.Reporter.Reporter.print_warn": {"tf": 1.4142135623730951}, "coercer.core.Reporter.Reporter.print_verbose": {"tf": 1.4142135623730951}, "coercer.core.Reporter.Reporter.report_test_result": {"tf": 1.4142135623730951}, "coercer.core.Reporter.Reporter.exportXLSX": {"tf": 1.4142135623730951}, "coercer.core.Reporter.Reporter.exportJSON": {"tf": 1.4142135623730951}, "coercer.core.Reporter.Reporter.exportSQLITE": {"tf": 1.4142135623730951}}, "df": 16}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"coercer.structures.ReportingLevel": {"tf": 1}, "coercer.structures.ReportingLevel.ReportingLevel": {"tf": 1.4142135623730951}, "coercer.structures.ReportingLevel.ReportingLevel.INFO": {"tf": 1.4142135623730951}, "coercer.structures.ReportingLevel.ReportingLevel.VERBOSE": {"tf": 1.4142135623730951}, "coercer.structures.ReportingLevel.ReportingLevel.DEBUg": {"tf": 1.4142135623730951}}, "df": 5}}}}}}}}}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"coercer.core.Reporter.Reporter.report_test_result": {"tf": 1}}, "df": 1, "s": {"docs": {"coercer.core.Reporter.Reporter.test_results": {"tf": 1}}, "df": 1}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"coercer.network.smb.list_remote_pipes": {"tf": 1}, "coercer.network.utils.get_ip_address_to_target_remote_host": {"tf": 1}}, "df": 2}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"coercer.structures.TestResult.TestResult.NO_AUTH_RECEIVED": {"tf": 1}, "coercer.structures.TestResult.TestResult.SMB_AUTH_RECEIVED": {"tf": 1}, "coercer.structures.TestResult.TestResult.HTTP_AUTH_RECEIVED": {"tf": 1}}, "df": 3}}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"coercer.core.utils.gen_random_name": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "c": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.network.rpc": {"tf": 1}, "coercer.network.rpc.portmap_discover": {"tf": 1}, "coercer.network.rpc.is_port_open": {"tf": 1}, "coercer.network.rpc.can_bind_to_interface_on_port": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_X_BAD_STUB_DATA": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_ACCESS_DENIED": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_BINDING": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_NET_ADDR": {"tf": 1}}, "df": 12, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1.4142135623730951}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.function": {"tf": 1.4142135623730951}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.trigger": {"tf": 1.4142135623730951}}, "df": 7, "e": {"docs": {}, "df": 0, "x": {"docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1.4142135623730951}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.function": {"tf": 1.4142135623730951}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.trigger": {"tf": 1.4142135623730951}}, "df": 7}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "n": {"docs": {"coercer.methods.MS_RPRN": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.exploit_paths": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.access": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.protocol": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.function": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.trigger": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.exploit_paths": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.access": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.protocol": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.function": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.trigger": {"tf": 1}}, "df": 15}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {"coercer.core.Reporter.CURSOR_UP_ONE": {"tf": 1}}, "df": 1}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"coercer.core.utils": {"tf": 1}, "coercer.core.utils.gen_random_name": {"tf": 1}, "coercer.core.utils.generate_exploit_templates": {"tf": 1}, "coercer.core.utils.generate_exploit_path_from_template": {"tf": 1}, "coercer.network.utils": {"tf": 1}, "coercer.network.utils.get_ip_address_of_interface": {"tf": 1}, "coercer.network.utils.get_ip_address_to_target_remote_host": {"tf": 1}, "coercer.network.utils.can_listen_on_port": {"tf": 1}, "coercer.network.utils.get_ip_addr_to_listen_on": {"tf": 1}, "coercer.network.utils.get_next_http_listener_port": {"tf": 1}}, "df": 10}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"coercer.structures.Credentials.Credentials.username": {"tf": 1}}, "df": 1}}}}}}}, "n": {"docs": {}, "df": 0, "k": {"docs": {"coercer.structures.TestResult.TestResult.NCA_S_UNK_IF": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.network.rpc.can_bind_to_interface_on_port": {"tf": 1}, "coercer.network.utils.can_listen_on_port": {"tf": 1}, "coercer.network.utils.get_ip_addr_to_listen_on": {"tf": 1}}, "df": 3, "e": {"docs": {"coercer.core.Reporter.CURSOR_UP_ONE": {"tf": 1}}, "df": 1}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"coercer.core.Reporter.Reporter.options": {"tf": 1}, "coercer.network.Listener.Listener.options": {"tf": 1}}, "df": 2}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {"coercer.network.rpc.is_port_open": {"tf": 1}}, "df": 1}}}, "f": {"docs": {"coercer.network.utils.get_ip_address_of_interface": {"tf": 1}}, "df": 1}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"coercer.structures.MethodType.MethodType.OTHER": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.Reporter.ERASE_LINE": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"coercer.structures.TestResult.TestResult.ERROR_BAD_NETPATH": {"tf": 1}, "coercer.structures.TestResult.TestResult.ERROR_INVALID_NAME": {"tf": 1}}, "df": 2}}}}, "x": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "x": {"docs": {"coercer.core.Reporter.Reporter.exportXLSX": {"tf": 1}}, "df": 1}}}}, "j": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.core.Reporter.Reporter.exportJSON": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.Reporter.Reporter.exportSQLITE": {"tf": 1}}, "df": 1}}}}}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"coercer.core.utils.generate_exploit_templates": {"tf": 1}, "coercer.core.utils.generate_exploit_path_from_template": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.exploit_paths": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.exploit_paths": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.exploit_paths": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.exploit_paths": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.exploit_paths": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.exploit_paths": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.exploit_paths": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.generate_exploit_templates": {"tf": 1}}, "df": 21}}}}}}, "f": {"docs": {}, "df": 0, "s": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB.structure": {"tf": 1}}, "df": 10, "r": {"docs": {"coercer.methods.MS_EFSR": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.align": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.trigger": {"tf": 1}}, "df": 94, "p": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.function": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.trigger": {"tf": 1.4142135623730951}}, "df": 13, "e": {"docs": {}, "df": 0, "x": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.function": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.trigger": {"tf": 1.4142135623730951}}, "df": 15}}}}}}}}}}}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {"coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.function": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.trigger": {"tf": 1.4142135623730951}}, "df": 7}}}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.function": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.trigger": {"tf": 1.4142135623730951}}, "df": 9}}}}}}}}}}}}}}}}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {"coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.function": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.trigger": {"tf": 1.4142135623730951}}, "df": 7}}}}}}}}}}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {"coercer.methods.MS_EFSR.EfsRpcFileKeyInfo": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.function": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.trigger": {"tf": 1.4142135623730951}}, "df": 7}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "w": {"docs": {"coercer.methods.MS_EFSR.EfsRpcOpenFileRaw": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.function": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.trigger": {"tf": 1.4142135623730951}}, "df": 7}}}}}}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.function": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.trigger": {"tf": 1.4142135623730951}}, "df": 7}}}}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.function": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.trigger": {"tf": 1.4142135623730951}}, "df": 7}}}}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.align": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.function": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.trigger": {"tf": 1.4142135623730951}}, "df": 14}}}}}}}}}}}}}}}}}}}}}}}}, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.align": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1}}, "df": 13}}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"coercer.methods.MS_EVEN": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.exploit_paths": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.access": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.protocol": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.function": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.trigger": {"tf": 1}}, "df": 8}}}, "l": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "w": {"docs": {"coercer.methods.MS_EVEN.ElfrOpenBELW": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW": {"tf": 1.4142135623730951}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.function": {"tf": 1.4142135623730951}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.trigger": {"tf": 1.4142135623730951}}, "df": 7}}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.Reporter.ERASE_LINE": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.align": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1}, "coercer.network.smb.list_remote_pipes": {"tf": 1}}, "df": 8, "e": {"docs": {}, "df": 0, "n": {"docs": {"coercer.network.Listener.Listener.listen_ip": {"tf": 1}, "coercer.network.utils.can_listen_on_port": {"tf": 1}, "coercer.network.utils.get_ip_addr_to_listen_on": {"tf": 1}}, "df": 3, "e": {"docs": {}, "df": 0, "r": {"docs": {"coercer.network.Listener": {"tf": 1}, "coercer.network.Listener.Listener": {"tf": 1.4142135623730951}, "coercer.network.Listener.Listener.__init__": {"tf": 1.4142135623730951}, "coercer.network.Listener.Listener.options": {"tf": 1.4142135623730951}, "coercer.network.Listener.Listener.timeout": {"tf": 1.4142135623730951}, "coercer.network.Listener.Listener.listen_ip": {"tf": 1.4142135623730951}, "coercer.network.Listener.Listener.start_smb": {"tf": 1.4142135623730951}, "coercer.network.Listener.Listener.start_http": {"tf": 1.4142135623730951}, "coercer.network.utils.get_next_http_listener_port": {"tf": 1}}, "df": 9}}}}}}}, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"coercer.core.loader.find_and_load_coerce_methods": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "r": {"docs": {"coercer.core.loader": {"tf": 1}, "coercer.core.loader.find_and_load_coerce_methods": {"tf": 1}}, "df": 2}}}}, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"coercer.network.smb.try_login": {"tf": 1}}, "df": 1}}}}, "m": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {"coercer.structures.Credentials.Credentials.lmhash": {"tf": 1}}, "df": 1}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.Reporter.Reporter.verbose": {"tf": 1}, "coercer.core.Reporter.Reporter.print_verbose": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.set_verbose": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.get_verbose": {"tf": 1}, "coercer.structures.ReportingLevel.ReportingLevel.VERBOSE": {"tf": 1}}, "df": 5}}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"coercer.core.Reporter.Reporter.test_results": {"tf": 1}, "coercer.core.Reporter.Reporter.report_test_result": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"coercer.core.Reporter.Reporter.print_testing": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"coercer.structures.TestResult": {"tf": 1}, "coercer.structures.TestResult.TestResult": {"tf": 1.4142135623730951}, "coercer.structures.TestResult.TestResult.NO_AUTH_RECEIVED": {"tf": 1.4142135623730951}, "coercer.structures.TestResult.TestResult.SMB_AUTH_RECEIVED": {"tf": 1.4142135623730951}, "coercer.structures.TestResult.TestResult.HTTP_AUTH_RECEIVED": {"tf": 1.4142135623730951}, "coercer.structures.TestResult.TestResult.NCA_S_UNK_IF": {"tf": 1.4142135623730951}, "coercer.structures.TestResult.TestResult.ERROR_BAD_NETPATH": {"tf": 1.4142135623730951}, "coercer.structures.TestResult.TestResult.ERROR_INVALID_NAME": {"tf": 1.4142135623730951}, "coercer.structures.TestResult.TestResult.RPC_X_BAD_STUB_DATA": {"tf": 1.4142135623730951}, "coercer.structures.TestResult.TestResult.RPC_S_ACCESS_DENIED": {"tf": 1.4142135623730951}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_BINDING": {"tf": 1.4142135623730951}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_NET_ADDR": {"tf": 1.4142135623730951}, "coercer.structures.TestResult.TestResult.SMB_STATUS_PIPE_DISCONNECTED": {"tf": 1.4142135623730951}}, "df": 13}}}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.utils.generate_exploit_path_from_template": {"tf": 1}}, "df": 1, "s": {"docs": {"coercer.core.utils.generate_exploit_templates": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.generate_exploit_templates": {"tf": 1}}, "df": 2}}}}}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.trigger": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.trigger": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.trigger": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.trigger": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.trigger": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.trigger": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.trigger": {"tf": 1}, "coercer.network.authentications.trigger_and_catch_authentication": {"tf": 1}, "coercer.network.authentications.trigger_authentication": {"tf": 1}}, "df": 19}}}}}, "y": {"docs": {"coercer.network.smb.try_login": {"tf": 1}}, "df": 1}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.method_type": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.target": {"tf": 1}, "coercer.network.utils.get_ip_address_to_target_remote_host": {"tf": 1}}, "df": 2}}}}}, "c": {"docs": {}, "df": 0, "p": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_ip_tcp": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"coercer.network.Listener.Listener.timeout": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {"coercer.network.rpc.can_bind_to_interface_on_port": {"tf": 1}, "coercer.network.smb.can_connect_to_pipe": {"tf": 1}, "coercer.network.smb.can_bind_to_interface": {"tf": 1}, "coercer.network.utils.get_ip_address_to_target_remote_host": {"tf": 1}, "coercer.network.utils.get_ip_addr_to_listen_on": {"tf": 1}}, "df": 5}}, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"coercer.core.Reporter.Reporter.print_warn": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"coercer.core.loader.find_and_load_coerce_methods": {"tf": 1}, "coercer.network.authentications.trigger_and_catch_authentication": {"tf": 1}}, "df": 2}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"coercer.structures.Credentials.Credentials.is_anonymous": {"tf": 1}}, "df": 1}}}}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.core.modes.coerce.action_coerce": {"tf": 1}, "coercer.core.modes.fuzz.action_fuzz": {"tf": 1}, "coercer.core.modes.scan.action_scan": {"tf": 1}}, "df": 3}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.access": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.access": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.access": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.access": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.access": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.access": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_ACCESS_DENIED": {"tf": 1}}, "df": 18}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {"coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.align": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"coercer.structures.TestResult.TestResult.NO_AUTH_RECEIVED": {"tf": 1}, "coercer.structures.TestResult.TestResult.SMB_AUTH_RECEIVED": {"tf": 1}, "coercer.structures.TestResult.TestResult.HTTP_AUTH_RECEIVED": {"tf": 1}}, "df": 3, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.network.authentications.trigger_and_catch_authentication": {"tf": 1}, "coercer.network.authentications.trigger_authentication": {"tf": 1}}, "df": 2, "s": {"docs": {"coercer.network.authentications": {"tf": 1}, "coercer.network.authentications.trigger_and_catch_authentication": {"tf": 1}, "coercer.network.authentications.trigger_authentication": {"tf": 1}}, "df": 3}}}}}}}}}}}}}}, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {"coercer.network.utils.get_ip_addr_to_listen_on": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_NET_ADDR": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"coercer.network.utils.get_ip_address_of_interface": {"tf": 1}, "coercer.network.utils.get_ip_address_to_target_remote_host": {"tf": 1}}, "df": 2}}}}}}}, "s": {"docs": {"coercer.structures.TestResult.TestResult.NCA_S_UNK_IF": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_ACCESS_DENIED": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_BINDING": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_NET_ADDR": {"tf": 1}}, "df": 4, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"coercer.core.modes.scan": {"tf": 1}, "coercer.core.modes.scan.action_scan": {"tf": 1.4142135623730951}}, "df": 2}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1}}, "df": 11, "s": {"docs": {"coercer.structures": {"tf": 1}, "coercer.structures.Credentials": {"tf": 1}, "coercer.structures.Credentials.Credentials": {"tf": 1}, "coercer.structures.Credentials.Credentials.__init__": {"tf": 1}, "coercer.structures.Credentials.Credentials.username": {"tf": 1}, "coercer.structures.Credentials.Credentials.password": {"tf": 1}, "coercer.structures.Credentials.Credentials.domain": {"tf": 1}, "coercer.structures.Credentials.Credentials.lmhash": {"tf": 1}, "coercer.structures.Credentials.Credentials.nthash": {"tf": 1}, "coercer.structures.Credentials.Credentials.doKerberos": {"tf": 1}, "coercer.structures.Credentials.Credentials.kdcHost": {"tf": 1}, "coercer.structures.Credentials.Credentials.is_anonymous": {"tf": 1}, "coercer.structures.MethodType": {"tf": 1}, "coercer.structures.MethodType.MethodType": {"tf": 1}, "coercer.structures.MethodType.MethodType.MICROSOFT_PROTOCOL": {"tf": 1}, "coercer.structures.MethodType.MethodType.OTHER": {"tf": 1}, "coercer.structures.ReportingLevel": {"tf": 1}, "coercer.structures.ReportingLevel.ReportingLevel": {"tf": 1}, "coercer.structures.ReportingLevel.ReportingLevel.INFO": {"tf": 1}, "coercer.structures.ReportingLevel.ReportingLevel.VERBOSE": {"tf": 1}, "coercer.structures.ReportingLevel.ReportingLevel.DEBUg": {"tf": 1}, "coercer.structures.TestResult": {"tf": 1}, "coercer.structures.TestResult.TestResult": {"tf": 1}, "coercer.structures.TestResult.TestResult.NO_AUTH_RECEIVED": {"tf": 1}, "coercer.structures.TestResult.TestResult.SMB_AUTH_RECEIVED": {"tf": 1}, "coercer.structures.TestResult.TestResult.HTTP_AUTH_RECEIVED": {"tf": 1}, "coercer.structures.TestResult.TestResult.NCA_S_UNK_IF": {"tf": 1}, "coercer.structures.TestResult.TestResult.ERROR_BAD_NETPATH": {"tf": 1}, "coercer.structures.TestResult.TestResult.ERROR_INVALID_NAME": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_X_BAD_STUB_DATA": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_ACCESS_DENIED": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_BINDING": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_NET_ADDR": {"tf": 1}, "coercer.structures.TestResult.TestResult.SMB_STATUS_PIPE_DISCONNECTED": {"tf": 1}}, "df": 34}}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"coercer.network.Listener.Listener.start_smb": {"tf": 1}, "coercer.network.Listener.Listener.start_http": {"tf": 1}}, "df": 2}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"coercer.structures.TestResult.TestResult.SMB_STATUS_PIPE_DISCONNECTED": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "b": {"docs": {"coercer.structures.TestResult.TestResult.RPC_X_BAD_STUB_DATA": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.session": {"tf": 1}, "coercer.network.smb.init_smb_session": {"tf": 1}}, "df": 2}}}}}, "t": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.set_verbose": {"tf": 1}}, "df": 1}}, "m": {"docs": {}, "df": 0, "b": {"docs": {"coercer.network.Listener.Listener.start_smb": {"tf": 1}, "coercer.network.smb": {"tf": 1}, "coercer.network.smb.init_smb_session": {"tf": 1.4142135623730951}, "coercer.network.smb.try_login": {"tf": 1}, "coercer.network.smb.list_remote_pipes": {"tf": 1}, "coercer.network.smb.can_connect_to_pipe": {"tf": 1}, "coercer.network.smb.can_bind_to_interface": {"tf": 1}, "coercer.structures.TestResult.TestResult.SMB_AUTH_RECEIVED": {"tf": 1}, "coercer.structures.TestResult.TestResult.SMB_STATUS_PIPE_DISCONNECTED": {"tf": 1}}, "df": 9}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"coercer.core.utils.gen_random_name": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.utils.generate_exploit_templates": {"tf": 1}, "coercer.core.utils.generate_exploit_path_from_template": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.generate_exploit_templates": {"tf": 1}}, "df": 3}}}}}}, "t": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.get_verbose": {"tf": 1}, "coercer.network.utils.get_ip_address_of_interface": {"tf": 1}, "coercer.network.utils.get_ip_address_to_target_remote_host": {"tf": 1}, "coercer.network.utils.get_ip_addr_to_listen_on": {"tf": 1}, "coercer.network.utils.get_next_http_listener_port": {"tf": 1}}, "df": 5}}}, "d": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "m": {"docs": {"coercer.methods.MS_DFSNM": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.exploit_paths": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.access": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.protocol": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.function": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.trigger": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.exploit_paths": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.access": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.protocol": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.function": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.trigger": {"tf": 1}}, "df": 15}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.network.DCERPCSession": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession": {"tf": 1.4142135623730951}, "coercer.network.DCERPCSession.DCERPCSession.__init__": {"tf": 1.4142135623730951}, "coercer.network.DCERPCSession.DCERPCSession.session": {"tf": 1.4142135623730951}, "coercer.network.DCERPCSession.DCERPCSession.target": {"tf": 1.4142135623730951}, "coercer.network.DCERPCSession.DCERPCSession.credentials": {"tf": 1.4142135623730951}, "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_ip_tcp": {"tf": 1.4142135623730951}, "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_np": {"tf": 1.4142135623730951}, "coercer.network.DCERPCSession.DCERPCSession.bind": {"tf": 1.4142135623730951}, "coercer.network.DCERPCSession.DCERPCSession.set_verbose": {"tf": 1.4142135623730951}, "coercer.network.DCERPCSession.DCERPCSession.get_verbose": {"tf": 1.4142135623730951}}, "df": 11, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"coercer.network.DCERPCSessionError": {"tf": 1}, "coercer.network.DCERPCSessionError.DCERPCSessionError": {"tf": 1.4142135623730951}, "coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1.4142135623730951}}, "df": 3}}}}}}}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"coercer.network.rpc.portmap_discover": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"coercer.structures.TestResult.TestResult.SMB_STATUS_PIPE_DISCONNECTED": {"tf": 1}}, "df": 1}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"coercer.structures.Credentials.Credentials.domain": {"tf": 1}}, "df": 1}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {"coercer.structures.Credentials.Credentials.doKerberos": {"tf": 1}}, "df": 1}}}}}}}}}, "e": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "g": {"docs": {"coercer.structures.ReportingLevel.ReportingLevel.DEBUg": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"coercer.structures.TestResult.TestResult.RPC_S_ACCESS_DENIED": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"coercer.structures.TestResult.TestResult.RPC_X_BAD_STUB_DATA": {"tf": 1}}, "df": 1}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.align": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1}}, "df": 15}}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {"coercer.network.Listener.Listener.start_http": {"tf": 1}, "coercer.network.utils.get_next_http_listener_port": {"tf": 1}, "coercer.structures.TestResult.TestResult.HTTP_AUTH_RECEIVED": {"tf": 1}}, "df": 3}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"coercer.network.utils.get_ip_address_to_target_remote_host": {"tf": 1}}, "df": 1}}}}, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "b": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB.structure": {"tf": 1}}, "df": 10}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.bind": {"tf": 1}, "coercer.network.rpc.can_bind_to_interface_on_port": {"tf": 1}, "coercer.network.smb.can_bind_to_interface": {"tf": 1}}, "df": 3, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"coercer.structures.TestResult.TestResult.RPC_S_INVALID_BINDING": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {"coercer.structures.TestResult.TestResult.ERROR_BAD_NETPATH": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_X_BAD_STUB_DATA": {"tf": 1}}, "df": 2}}}, "k": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"coercer.structures.Credentials.Credentials.kdcHost": {"tf": 1}}, "df": 1}}}}}}}, "x": {"docs": {"coercer.structures.TestResult.TestResult.RPC_X_BAD_STUB_DATA": {"tf": 1}}, "df": 1}}}, "annotation": {"root": {"docs": {}, "df": 0}}, "default_value": {"root": {"0": {"0": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "a": {"0": {"0": {"4": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "e": {"6": {"7": {"3": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.access": {"tf": 1.4142135623730951}}, "df": 2}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "c": {"0": {"4": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "d": {"9": {"0": {"docs": {}, "df": 0, "f": {"7": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 2.23606797749979}}, "df": 10}}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "1": {"2": {"3": {"4": {"5": {"6": {"7": {"8": {"9": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.access": {"tf": 1.4142135623730951}}, "df": 2}}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.access": {"tf": 2}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.access": {"tf": 1.4142135623730951}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.function": {"tf": 1}, "coercer.structures.TestResult.TestResult.NO_AUTH_RECEIVED": {"tf": 1}}, "df": 20}, "1": {"1": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "f": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.access": {"tf": 1.4142135623730951}}, "df": 2}}, "d": {"0": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 2.23606797749979}}, "df": 10}, "docs": {}, "df": 0}}, "2": {"3": {"4": {"5": {"6": {"7": {"8": {"docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.access": {"tf": 1.4142135623730951}}, "df": 2}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.access": {"tf": 1.4142135623730951}}, "df": 2}, "docs": {"coercer.structures.TestResult.TestResult.ERROR_INVALID_NAME": {"tf": 1}}, "df": 1}, "docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.function": {"tf": 1}}, "df": 3}, "3": {"1": {"0": {"7": {"3": {"docs": {"coercer.structures.TestResult.TestResult.RPC_X_BAD_STUB_DATA": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.function": {"tf": 1}}, "df": 1}, "5": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.function": {"tf": 1}}, "df": 1}, "7": {"0": {"2": {"docs": {"coercer.structures.TestResult.TestResult.RPC_S_INVALID_BINDING": {"tf": 1}}, "df": 1}, "7": {"docs": {"coercer.structures.TestResult.TestResult.RPC_S_INVALID_NET_ADDR": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "8": {"docs": {}, "df": 0, "c": {"3": {"docs": {"coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.access": {"tf": 1.4142135623730951}}, "df": 1}, "docs": {}, "df": 0}}, "9": {"6": {"6": {"0": {"9": {"docs": {"coercer.structures.TestResult.TestResult.SMB_STATUS_PIPE_DISCONNECTED": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.align": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.access": {"tf": 1.4142135623730951}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.method_type": {"tf": 1}, "coercer.structures.MethodType.MethodType.MICROSOFT_PROTOCOL": {"tf": 1}, "coercer.structures.ReportingLevel.ReportingLevel.INFO": {"tf": 1}, "coercer.structures.TestResult.TestResult.SMB_AUTH_RECEIVED": {"tf": 1}}, "df": 19}, "2": {"5": {"5": {"docs": {"coercer.structures.MethodType.MethodType.OTHER": {"tf": 1}, "coercer.structures.ReportingLevel.ReportingLevel.DEBUg": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}, "7": {"4": {"4": {"docs": {"coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.access": {"tf": 1.4142135623730951}}, "df": 2}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"coercer.structures.ReportingLevel.ReportingLevel.VERBOSE": {"tf": 1}, "coercer.structures.TestResult.TestResult.HTTP_AUTH_RECEIVED": {"tf": 1}}, "df": 2}, "3": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.exploit_paths": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.exploit_paths": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.exploit_paths": {"tf": 1}}, "df": 13, "f": {"7": {"8": {"docs": {"coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.access": {"tf": 1.4142135623730951}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "4": {"3": {"8": {"9": {"docs": {"coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.access": {"tf": 1.4142135623730951}}, "df": 2}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "6": {"3": {"6": {"5": {"7": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "f": {"4": {"4": {"docs": {}, "df": 0, "d": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 1.4142135623730951}}, "df": 10}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.function": {"tf": 1}}, "df": 1, "f": {"docs": {}, "df": 0, "c": {"7": {"4": {"2": {"docs": {}, "df": 0, "e": {"0": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.access": {"tf": 1.4142135623730951}}, "df": 2}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "a": {"1": {"0": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.access": {"tf": 1.4142135623730951}}, "df": 2}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "e": {"7": {"9": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 1.4142135623730951}}, "df": 10}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "5": {"3": {"docs": {"coercer.structures.TestResult.TestResult.ERROR_BAD_NETPATH": {"tf": 1}}, "df": 1}, "docs": {"coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.function": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_ACCESS_DENIED": {"tf": 1}}, "df": 2}, "6": {"2": {"docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.function": {"tf": 1}}, "df": 1}, "5": {"5": {"3": {"7": {"docs": {"coercer.structures.TestResult.TestResult.NCA_S_UNK_IF": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.function": {"tf": 1}}, "df": 1}, "docs": {"coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.function": {"tf": 1}}, "df": 1}, "7": {"3": {"7": {"3": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "f": {"8": {"docs": {}, "df": 0, "b": {"2": {"2": {"9": {"2": {"docs": {"coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.access": {"tf": 1.4142135623730951}}, "df": 2}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.function": {"tf": 1}}, "df": 1}, "8": {"2": {"2": {"7": {"3": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "c": {"docs": {"coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.access": {"tf": 1.4142135623730951}}, "df": 1}}}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "7": {"3": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.access": {"tf": 1.4142135623730951}}, "df": 2}, "9": {"2": {"9": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "c": {"2": {"3": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {"coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.access": {"tf": 1.4142135623730951}}, "df": 1}}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.function": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.exploit_paths": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.function": {"tf": 1}}, "df": 14, "c": {"5": {"2": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 2.23606797749979}}, "df": 10}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "9": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.function": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.function": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.function": {"tf": 1}}, "df": 3}, "docs": {"coercer.core.Reporter.CURSOR_UP_ONE": {"tf": 1.4142135623730951}, "coercer.core.Reporter.ERASE_LINE": {"tf": 1.4142135623730951}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.access": {"tf": 3.4641016151377544}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.protocol": {"tf": 2.23606797749979}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.function": {"tf": 2.449489742783178}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.access": {"tf": 3.4641016151377544}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.protocol": {"tf": 2.23606797749979}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.function": {"tf": 2.449489742783178}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 6}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.protocol": {"tf": 2}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.function": {"tf": 2.449489742783178}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 6}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.protocol": {"tf": 2}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.function": {"tf": 2.449489742783178}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 6}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.protocol": {"tf": 2}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.function": {"tf": 2.449489742783178}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 6}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.protocol": {"tf": 2}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.function": {"tf": 2.449489742783178}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 6}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.protocol": {"tf": 2}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.function": {"tf": 2.449489742783178}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 6}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.protocol": {"tf": 2}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.function": {"tf": 2.449489742783178}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 6}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.protocol": {"tf": 2}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.function": {"tf": 2.449489742783178}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 6}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.protocol": {"tf": 2}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.function": {"tf": 2.449489742783178}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 6}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.protocol": {"tf": 2}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.function": {"tf": 2.449489742783178}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 6}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.protocol": {"tf": 2}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.function": {"tf": 2.449489742783178}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.access": {"tf": 3.4641016151377544}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.protocol": {"tf": 2}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.function": {"tf": 2.449489742783178}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.access": {"tf": 3.4641016151377544}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.protocol": {"tf": 2}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.function": {"tf": 2.449489742783178}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.access": {"tf": 3.4641016151377544}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.protocol": {"tf": 2}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.function": {"tf": 2.449489742783178}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.access": {"tf": 3.4641016151377544}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.protocol": {"tf": 2}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.function": {"tf": 2.449489742783178}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.access": {"tf": 3.4641016151377544}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.protocol": {"tf": 2}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.function": {"tf": 2.449489742783178}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.method_type": {"tf": 1.4142135623730951}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.exploit_paths": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.protocol": {"tf": 2}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.function": {"tf": 1.7320508075688772}, "coercer.structures.MethodType.MethodType.MICROSOFT_PROTOCOL": {"tf": 1.4142135623730951}, "coercer.structures.MethodType.MethodType.OTHER": {"tf": 1.4142135623730951}, "coercer.structures.ReportingLevel.ReportingLevel.INFO": {"tf": 1.4142135623730951}, "coercer.structures.ReportingLevel.ReportingLevel.VERBOSE": {"tf": 1.4142135623730951}, "coercer.structures.ReportingLevel.ReportingLevel.DEBUg": {"tf": 1.4142135623730951}, "coercer.structures.TestResult.TestResult.NO_AUTH_RECEIVED": {"tf": 1.4142135623730951}, "coercer.structures.TestResult.TestResult.SMB_AUTH_RECEIVED": {"tf": 1.4142135623730951}, "coercer.structures.TestResult.TestResult.HTTP_AUTH_RECEIVED": {"tf": 1.4142135623730951}, "coercer.structures.TestResult.TestResult.NCA_S_UNK_IF": {"tf": 1.4142135623730951}, "coercer.structures.TestResult.TestResult.ERROR_BAD_NETPATH": {"tf": 1.4142135623730951}, "coercer.structures.TestResult.TestResult.ERROR_INVALID_NAME": {"tf": 1.4142135623730951}, "coercer.structures.TestResult.TestResult.RPC_X_BAD_STUB_DATA": {"tf": 1.4142135623730951}, "coercer.structures.TestResult.TestResult.RPC_S_ACCESS_DENIED": {"tf": 1.4142135623730951}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_BINDING": {"tf": 1.4142135623730951}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_NET_ADDR": {"tf": 1.4142135623730951}, "coercer.structures.TestResult.TestResult.SMB_STATUS_PIPE_DISCONNECTED": {"tf": 1.4142135623730951}}, "df": 101, "x": {"0": {"0": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.exploit_paths": {"tf": 1.4142135623730951}}, "df": 11}, "docs": {}, "df": 0}, "1": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "[": {"1": {"docs": {}, "df": 0, "a": {"docs": {"coercer.core.Reporter.CURSOR_UP_ONE": {"tf": 1}}, "df": 1}}, "2": {"docs": {}, "df": 0, "k": {"docs": {"coercer.core.Reporter.ERASE_LINE": {"tf": 1}}, "df": 1}}, "docs": {}, "df": 0}}}, "2": {"7": {"docs": {"coercer.core.Reporter.CURSOR_UP_ONE": {"tf": 1.4142135623730951}, "coercer.core.Reporter.ERASE_LINE": {"tf": 1.4142135623730951}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.exploit_paths": {"tf": 4}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.access": {"tf": 4.898979485566356}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.protocol": {"tf": 2.8284271247461903}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.function": {"tf": 3.1622776601683795}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.exploit_paths": {"tf": 4}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.access": {"tf": 4.898979485566356}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.protocol": {"tf": 2.8284271247461903}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.function": {"tf": 3.1622776601683795}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB.structure": {"tf": 2.8284271247461903}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 4}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 2.8284271247461903}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.exploit_paths": {"tf": 4}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 8.94427190999916}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.protocol": {"tf": 2.8284271247461903}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.function": {"tf": 3.1622776601683795}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB.structure": {"tf": 2.8284271247461903}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB.structure": {"tf": 2.8284271247461903}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 4}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 2.8284271247461903}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.exploit_paths": {"tf": 3.4641016151377544}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 8.94427190999916}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.protocol": {"tf": 2.8284271247461903}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.function": {"tf": 3.1622776601683795}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.exploit_paths": {"tf": 4}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 8.94427190999916}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.protocol": {"tf": 2.8284271247461903}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.function": {"tf": 3.1622776601683795}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB.structure": {"tf": 2.8284271247461903}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.exploit_paths": {"tf": 4}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 8.94427190999916}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.protocol": {"tf": 2.8284271247461903}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.function": {"tf": 3.1622776601683795}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.exploit_paths": {"tf": 4}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 8.94427190999916}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.protocol": {"tf": 2.8284271247461903}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.function": {"tf": 3.1622776601683795}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.exploit_paths": {"tf": 4}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 8.94427190999916}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.protocol": {"tf": 2.8284271247461903}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.function": {"tf": 3.1622776601683795}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.exploit_paths": {"tf": 4}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 8.94427190999916}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.protocol": {"tf": 2.8284271247461903}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.function": {"tf": 3.1622776601683795}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.exploit_paths": {"tf": 4}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 8.94427190999916}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.protocol": {"tf": 2.8284271247461903}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.function": {"tf": 3.1622776601683795}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.exploit_paths": {"tf": 4}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 8.94427190999916}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.protocol": {"tf": 2.8284271247461903}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.function": {"tf": 3.1622776601683795}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB.structure": {"tf": 2.8284271247461903}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 4}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 2.8284271247461903}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.exploit_paths": {"tf": 4}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 8.94427190999916}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.protocol": {"tf": 2.8284271247461903}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.function": {"tf": 3.1622776601683795}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.exploit_paths": {"tf": 2}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.access": {"tf": 4.898979485566356}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.protocol": {"tf": 2.8284271247461903}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.function": {"tf": 3.1622776601683795}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.exploit_paths": {"tf": 2}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.access": {"tf": 4.898979485566356}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.protocol": {"tf": 2.8284271247461903}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.function": {"tf": 3.1622776601683795}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.exploit_paths": {"tf": 2}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.access": {"tf": 4.898979485566356}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.protocol": {"tf": 2.8284271247461903}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.function": {"tf": 3.1622776601683795}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.exploit_paths": {"tf": 2}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.access": {"tf": 4.898979485566356}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.protocol": {"tf": 2.8284271247461903}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.function": {"tf": 3.1622776601683795}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.exploit_paths": {"tf": 2}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.access": {"tf": 4.898979485566356}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.protocol": {"tf": 2.8284271247461903}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.function": {"tf": 3.1622776601683795}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.protocol": {"tf": 2.8284271247461903}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.function": {"tf": 2.449489742783178}}, "df": 83}, "docs": {}, "df": 0}, "docs": {"coercer.structures.TestResult.TestResult.RPC_X_BAD_STUB_DATA": {"tf": 1}}, "df": 1}, "s": {"docs": {"coercer.structures.TestResult.TestResult.NCA_S_UNK_IF": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_ACCESS_DENIED": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_BINDING": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_NET_ADDR": {"tf": 1}}, "df": 4, "m": {"docs": {}, "df": 0, "b": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.exploit_paths": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.exploit_paths": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.exploit_paths": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.exploit_paths": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.exploit_paths": {"tf": 1}, "coercer.structures.TestResult.TestResult.SMB_AUTH_RECEIVED": {"tf": 1}, "coercer.structures.TestResult.TestResult.SMB_STATUS_PIPE_DISCONNECTED": {"tf": 1}}, "df": 19}}, "y": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.protocol": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.protocol": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.protocol": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.protocol": {"tf": 1}}, "df": 14}}}}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.protocol": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.protocol": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.protocol": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.protocol": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.protocol": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.protocol": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.protocol": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.protocol": {"tf": 1}}, "df": 18}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.function": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.function": {"tf": 1}}, "df": 2}}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.protocol": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.protocol": {"tf": 1}}, "df": 2, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.function": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.function": {"tf": 1}}, "df": 2}}}}}}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1.4142135623730951}}, "df": 3}}, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.function": {"tf": 1}}, "df": 1}}}}}}}}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {"coercer.structures.TestResult.TestResult.RPC_X_BAD_STUB_DATA": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"coercer.structures.TestResult.TestResult.SMB_STATUS_PIPE_DISCONNECTED": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.exploit_paths": {"tf": 2}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.exploit_paths": {"tf": 2}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.exploit_paths": {"tf": 2}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.exploit_paths": {"tf": 2}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.exploit_paths": {"tf": 2}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.exploit_paths": {"tf": 2}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.exploit_paths": {"tf": 2}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.exploit_paths": {"tf": 2}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.exploit_paths": {"tf": 2}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.exploit_paths": {"tf": 2}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.exploit_paths": {"tf": 2}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.exploit_paths": {"tf": 1}}, "df": 12, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "}": {"docs": {}, "df": 0, "}": {"docs": {}, "df": 0, "{": {"docs": {}, "df": 0, "{": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "b": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.exploit_paths": {"tf": 1.7320508075688772}}, "df": 11}}}, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.exploit_paths": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.exploit_paths": {"tf": 1}}, "df": 11}}}}}}, "\\": {"docs": {}, "df": 0, "\\": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "\\": {"docs": {}, "df": 0, "\\": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.exploit_paths": {"tf": 1}}, "df": 1}}}}, "\\": {"docs": {}, "df": 0, "x": {"0": {"0": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.exploit_paths": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}}, "x": {"0": {"0": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.exploit_paths": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}}}}}}}, "x": {"0": {"0": {"docs": {"coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.exploit_paths": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.exploit_paths": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.exploit_paths": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.exploit_paths": {"tf": 1}}, "df": 4}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.protocol": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.protocol": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.protocol": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.protocol": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.protocol": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.protocol": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.protocol": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.protocol": {"tf": 1}}, "df": 18}}}}}}}, "t": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 2}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 2}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 2}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1.4142135623730951}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.method_type": {"tf": 1}, "coercer.structures.MethodType.MethodType.MICROSOFT_PROTOCOL": {"tf": 1}, "coercer.structures.MethodType.MethodType.OTHER": {"tf": 1}, "coercer.structures.ReportingLevel.ReportingLevel.INFO": {"tf": 1}, "coercer.structures.ReportingLevel.ReportingLevel.VERBOSE": {"tf": 1}, "coercer.structures.ReportingLevel.ReportingLevel.DEBUg": {"tf": 1}, "coercer.structures.TestResult.TestResult.NO_AUTH_RECEIVED": {"tf": 1}, "coercer.structures.TestResult.TestResult.SMB_AUTH_RECEIVED": {"tf": 1}, "coercer.structures.TestResult.TestResult.HTTP_AUTH_RECEIVED": {"tf": 1}, "coercer.structures.TestResult.TestResult.NCA_S_UNK_IF": {"tf": 1}, "coercer.structures.TestResult.TestResult.ERROR_BAD_NETPATH": {"tf": 1}, "coercer.structures.TestResult.TestResult.ERROR_INVALID_NAME": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_X_BAD_STUB_DATA": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_ACCESS_DENIED": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_BINDING": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_NET_ADDR": {"tf": 1}, "coercer.structures.TestResult.TestResult.SMB_STATUS_PIPE_DISCONNECTED": {"tf": 1}}, "df": 28}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}}, "df": 3}}}}}, "p": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}}, "df": 3}}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "}": {"docs": {}, "df": 0, "}": {"docs": {}, "df": 0, "\\": {"docs": {}, "df": 0, "\\": {"docs": {}, "df": 0, "{": {"docs": {}, "df": 0, "{": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.exploit_paths": {"tf": 1}}, "df": 12}}}}}}}, "/": {"docs": {}, "df": 0, "{": {"docs": {}, "df": 0, "{": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.exploit_paths": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.exploit_paths": {"tf": 1}}, "df": 11}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"coercer.structures.TestResult.TestResult.SMB_STATUS_PIPE_DISCONNECTED": {"tf": 1}}, "df": 1, "\\": {"docs": {}, "df": 0, "\\": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "s": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.access": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.access": {"tf": 1}}, "df": 2}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 1}}, "df": 10}}}}}}}}, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "c": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 1}}, "df": 10}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {"coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.access": {"tf": 1}}, "df": 1}}}}}}}}, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "c": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 1}}, "df": 10}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 1}}, "df": 10}}}}}, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "r": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 1}}, "df": 10}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.access": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.access": {"tf": 1}}, "df": 2}}}}}}}, "f": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "c": {"docs": {"coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.access": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.access": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.protocol": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.protocol": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.protocol": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.protocol": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.protocol": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.protocol": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.protocol": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.method_type": {"tf": 1}, "coercer.structures.MethodType.MethodType.MICROSOFT_PROTOCOL": {"tf": 1}}, "df": 19}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.protocol": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.protocol": {"tf": 1}}, "df": 2}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB.structure": {"tf": 1}}, "df": 5}}}}, "s": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.function": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.function": {"tf": 1}}, "df": 2}}}}}}}}}}}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.protocol": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.protocol": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.protocol": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.protocol": {"tf": 1}}, "df": 25, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.function": {"tf": 1}}, "df": 9}}}}}}}, "e": {"8": {"9": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 1.4142135623730951}}, "df": 10}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "s": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "p": {"docs": {"coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.protocol": {"tf": 1.4142135623730951}}, "df": 2}}}}}, "t": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "\\": {"docs": {}, "df": 0, "x": {"0": {"0": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.exploit_paths": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.exploit_paths": {"tf": 1.4142135623730951}}, "df": 12}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}}}, "c": {"docs": {}, "df": 0, "p": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.access": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.access": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.access": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.access": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.access": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.access": {"tf": 1}}, "df": 17}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"coercer.structures.TestResult.TestResult.NO_AUTH_RECEIVED": {"tf": 1}, "coercer.structures.TestResult.TestResult.SMB_AUTH_RECEIVED": {"tf": 1}, "coercer.structures.TestResult.TestResult.HTTP_AUTH_RECEIVED": {"tf": 1}, "coercer.structures.TestResult.TestResult.NCA_S_UNK_IF": {"tf": 1}, "coercer.structures.TestResult.TestResult.ERROR_BAD_NETPATH": {"tf": 1}, "coercer.structures.TestResult.TestResult.ERROR_INVALID_NAME": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_X_BAD_STUB_DATA": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_ACCESS_DENIED": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_BINDING": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_NET_ADDR": {"tf": 1}, "coercer.structures.TestResult.TestResult.SMB_STATUS_PIPE_DISCONNECTED": {"tf": 1}}, "df": 11}}}}}}}}}}, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.exploit_paths": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.exploit_paths": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.exploit_paths": {"tf": 1}, "coercer.structures.TestResult.TestResult.HTTP_AUTH_RECEIVED": {"tf": 1}}, "df": 12}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1}}, "df": 6}}}}, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {"coercer.structures.TestResult.TestResult.NCA_S_UNK_IF": {"tf": 1}}, "df": 1, "n": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.access": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.access": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.access": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.access": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.access": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.access": {"tf": 1}}, "df": 17}, "c": {"docs": {}, "df": 0, "n": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.access": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.access": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.access": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.access": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.access": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.access": {"tf": 1}}, "df": 17}}}}, "p": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.access": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.access": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.access": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.access": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.access": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.access": {"tf": 1}}, "df": 17}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.function": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.function": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.function": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.function": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.function": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.function": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.function": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.function": {"tf": 1}, "coercer.structures.TestResult.TestResult.ERROR_INVALID_NAME": {"tf": 1}}, "df": 19, "d": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.access": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.access": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.access": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.access": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.access": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.access": {"tf": 1}}, "df": 17}}}}}, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.protocol": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.protocol": {"tf": 1}}, "df": 2}}}}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {"coercer.structures.TestResult.TestResult.RPC_S_INVALID_NET_ADDR": {"tf": 1}}, "df": 1, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.function": {"tf": 1}}, "df": 1}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.function": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"coercer.structures.TestResult.TestResult.ERROR_BAD_NETPATH": {"tf": 1}}, "df": 1}}}}}}, "d": {"docs": {}, "df": 0, "r": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1}}, "df": 11, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1}}, "df": 11}}}}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}}, "df": 2}}}}}, "o": {"docs": {"coercer.structures.TestResult.TestResult.NO_AUTH_RECEIVED": {"tf": 1}}, "df": 1, "n": {"docs": {}, "df": 0, "e": {"docs": {"coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.path": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.session": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.target": {"tf": 1}}, "df": 3}}}}, "u": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.access": {"tf": 1.4142135623730951}}, "df": 17}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1}}, "df": 3}}}}, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "\\": {"docs": {}, "df": 0, "\\": {"docs": {}, "df": 0, "{": {"docs": {}, "df": 0, "{": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "}": {"docs": {}, "df": 0, "}": {"docs": {}, "df": 0, "{": {"docs": {}, "df": 0, "{": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "b": {"docs": {"coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.exploit_paths": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}, "k": {"docs": {"coercer.structures.TestResult.TestResult.NCA_S_UNK_IF": {"tf": 1}}, "df": 1}}}, "v": {"5": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1}}, "df": 11}, "docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 2.6457513110645907}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.access": {"tf": 1.4142135623730951}}, "df": 17}}}}, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"coercer.structures.ReportingLevel.ReportingLevel.VERBOSE": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.function": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.function": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.function": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.function": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.function": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.function": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.function": {"tf": 1}}, "df": 17}}}}}}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {"coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.protocol": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.protocol": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "p": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.access": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.access": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.access": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.access": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.access": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.access": {"tf": 1}}, "df": 17}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1}}, "df": 11}}}}}}}, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.function": {"tf": 1}}, "df": 1}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.function": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {"coercer.structures.ReportingLevel.ReportingLevel.INFO": {"tf": 1}}, "df": 1}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {"coercer.structures.TestResult.TestResult.ERROR_INVALID_NAME": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_BINDING": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_NET_ADDR": {"tf": 1}}, "df": 3}}}}}}, "f": {"docs": {"coercer.structures.TestResult.TestResult.NCA_S_UNK_IF": {"tf": 1}}, "df": 1}}, "m": {"docs": {}, "df": 0, "s": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.protocol": {"tf": 1.4142135623730951}}, "df": 23}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.protocol": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.protocol": {"tf": 1}}, "df": 2}}}}}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1}}, "df": 6}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.method_type": {"tf": 1}, "coercer.structures.MethodType.MethodType.MICROSOFT_PROTOCOL": {"tf": 1}, "coercer.structures.MethodType.MethodType.OTHER": {"tf": 1}}, "df": 3}}}}}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "t": {"docs": {"coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.method_type": {"tf": 1}, "coercer.structures.MethodType.MethodType.MICROSOFT_PROTOCOL": {"tf": 1}}, "df": 2}}}}}}}}}, "d": {"8": {"5": {"0": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 2.23606797749979}}, "df": 10}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0, "f": {"1": {"9": {"4": {"1": {"docs": {}, "df": 0, "c": {"5": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 1.4142135623730951}}, "df": 10}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0, "s": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.protocol": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.protocol": {"tf": 1}}, "df": 2, "n": {"docs": {}, "df": 0, "m": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.protocol": {"tf": 1.4142135623730951}}, "df": 2}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.protocol": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.protocol": {"tf": 1}}, "df": 2}}}}}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}}, "df": 3}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"coercer.structures.TestResult.TestResult.SMB_STATUS_PIPE_DISCONNECTED": {"tf": 1}}, "df": 1}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_X_BAD_STUB_DATA": {"tf": 1}}, "df": 6}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "c": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1}}, "df": 11}}}}}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1.4142135623730951}}, "df": 8}}}}}, "e": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "g": {"docs": {"coercer.structures.ReportingLevel.ReportingLevel.DEBUg": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"coercer.structures.TestResult.TestResult.RPC_S_ACCESS_DENIED": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.function": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.function": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.function": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.function": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.function": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.function": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.function": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.function": {"tf": 1}}, "df": 18}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"coercer.structures.MethodType.MethodType.OTHER": {"tf": 1}}, "df": 1}}}}}, "a": {"6": {"1": {"docs": {}, "df": 0, "d": {"docs": {"coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.access": {"tf": 1.4142135623730951}}, "df": 2}}, "docs": {}, "df": 0}, "8": {"docs": {}, "df": 0, "e": {"0": {"6": {"5": {"3": {"docs": {}, "df": 0, "c": {"docs": {"coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.access": {"tf": 1.4142135623730951}}, "df": 2}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.function": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.function": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.function": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.function": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.function": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.function": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.function": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.function": {"tf": 1}}, "df": 17}}}}}}}}, "a": {"docs": {"coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.exploit_paths": {"tf": 1}}, "df": 1}, "b": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "d": {"docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.access": {"tf": 1.4142135623730951}}, "df": 2}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"coercer.structures.TestResult.TestResult.NO_AUTH_RECEIVED": {"tf": 1}, "coercer.structures.TestResult.TestResult.SMB_AUTH_RECEIVED": {"tf": 1}, "coercer.structures.TestResult.TestResult.HTTP_AUTH_RECEIVED": {"tf": 1}}, "df": 3}}}, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"coercer.structures.TestResult.TestResult.RPC_S_ACCESS_DENIED": {"tf": 1}}, "df": 1}}}}}, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {"coercer.structures.TestResult.TestResult.RPC_S_INVALID_NET_ADDR": {"tf": 1}}, "df": 1}}}}, "c": {"6": {"8": {"1": {"docs": {}, "df": 0, "d": {"4": {"8": {"8": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 2.23606797749979}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 2.23606797749979}}, "df": 10}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 2}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 2}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 2}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1.4142135623730951}}, "df": 11}}}}, "b": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB.structure": {"tf": 1}}, "df": 5}}}}}, "o": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1}}, "df": 6}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1}}, "df": 3}}}}}}}}}}}, "g": {"docs": {}, "df": 0, "t": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 2}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 2}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB.structure": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 2}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1.4142135623730951}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.method_type": {"tf": 1}, "coercer.structures.MethodType.MethodType.MICROSOFT_PROTOCOL": {"tf": 1}, "coercer.structures.MethodType.MethodType.OTHER": {"tf": 1}, "coercer.structures.ReportingLevel.ReportingLevel.INFO": {"tf": 1}, "coercer.structures.ReportingLevel.ReportingLevel.VERBOSE": {"tf": 1}, "coercer.structures.ReportingLevel.ReportingLevel.DEBUg": {"tf": 1}, "coercer.structures.TestResult.TestResult.NO_AUTH_RECEIVED": {"tf": 1}, "coercer.structures.TestResult.TestResult.SMB_AUTH_RECEIVED": {"tf": 1}, "coercer.structures.TestResult.TestResult.HTTP_AUTH_RECEIVED": {"tf": 1}, "coercer.structures.TestResult.TestResult.NCA_S_UNK_IF": {"tf": 1}, "coercer.structures.TestResult.TestResult.ERROR_BAD_NETPATH": {"tf": 1}, "coercer.structures.TestResult.TestResult.ERROR_INVALID_NAME": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_X_BAD_STUB_DATA": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_ACCESS_DENIED": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_BINDING": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_NET_ADDR": {"tf": 1}, "coercer.structures.TestResult.TestResult.SMB_STATUS_PIPE_DISCONNECTED": {"tf": 1}}, "df": 28}}, "r": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "c": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_X_BAD_STUB_DATA": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_ACCESS_DENIED": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_BINDING": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_NET_ADDR": {"tf": 1}}, "df": 7, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.function": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "x": {"docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.function": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "n": {"docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.protocol": {"tf": 1.4142135623730951}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.protocol": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.protocol": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.protocol": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.protocol": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.protocol": {"tf": 1}}, "df": 14}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.protocol": {"tf": 1}}, "df": 1}}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"coercer.structures.ReportingLevel.ReportingLevel.INFO": {"tf": 1}, "coercer.structures.ReportingLevel.ReportingLevel.VERBOSE": {"tf": 1}, "coercer.structures.ReportingLevel.ReportingLevel.DEBUg": {"tf": 1}}, "df": 3}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"coercer.structures.TestResult.TestResult.NO_AUTH_RECEIVED": {"tf": 1}, "coercer.structures.TestResult.TestResult.SMB_AUTH_RECEIVED": {"tf": 1}, "coercer.structures.TestResult.TestResult.HTTP_AUTH_RECEIVED": {"tf": 1}}, "df": 3}}}}}}}}, "e": {"3": {"2": {"docs": {}, "df": 0, "a": {"docs": {"coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.access": {"tf": 1.4142135623730951}}, "df": 1}}, "docs": {}, "df": 0}, "docs": {}, "df": 0, "f": {"0": {"0": {"docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.access": {"tf": 1.4142135623730951}}, "df": 2}, "docs": {}, "df": 0}, "docs": {}, "df": 0, "s": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}}, "df": 3, "r": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.protocol": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.protocol": {"tf": 1.4142135623730951}}, "df": 16, "p": {"docs": {}, "df": 0, "c": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.protocol": {"tf": 1}}, "df": 10, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.function": {"tf": 1}}, "df": 3, "e": {"docs": {}, "df": 0, "x": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.function": {"tf": 1}}, "df": 3}}}}}}}}}}}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {"coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.function": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.function": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {"coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.function": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {"coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.function": {"tf": 1}}, "df": 1}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "w": {"docs": {"coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.function": {"tf": 1}}, "df": 1}}}}}}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.function": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.function": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.function": {"tf": 1}}, "df": 3}}}}}}}}}}}}}}}}}}}}}}}}, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1}}, "df": 3}}, "n": {"docs": {}, "df": 0, "g": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.protocol": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.protocol": {"tf": 1}}, "df": 10}}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.protocol": {"tf": 1.4142135623730951}}, "df": 1, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {"coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.protocol": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "w": {"docs": {"coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.function": {"tf": 1}}, "df": 1}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"coercer.structures.TestResult.TestResult.ERROR_BAD_NETPATH": {"tf": 1}, "coercer.structures.TestResult.TestResult.ERROR_INVALID_NAME": {"tf": 1}}, "df": 2}}}}}, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "b": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1}}, "df": 3}}}, "f": {"1": {"0": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 1.4142135623730951}}, "df": 10}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.function": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "d": {"docs": {"coercer.structures.TestResult.TestResult.ERROR_BAD_NETPATH": {"tf": 1}, "coercer.structures.TestResult.TestResult.RPC_X_BAD_STUB_DATA": {"tf": 1}}, "df": 2}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"coercer.structures.TestResult.TestResult.RPC_S_INVALID_BINDING": {"tf": 1}}, "df": 1}}}}}}}}}, "signature": {"root": {"1": {"3": {"5": {"docs": {"coercer.network.rpc.portmap_discover": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {"coercer.network.smb.list_remote_pipes": {"tf": 1}}, "df": 1}, "3": {"9": {"docs": {"coercer.network.smb.list_remote_pipes": {"tf": 1.4142135623730951}}, "df": 1}, "docs": {}, "df": 0}, "4": {"4": {"5": {"docs": {"coercer.core.utils.generate_exploit_path_from_template": {"tf": 1}, "coercer.network.smb.try_login": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "8": {"0": {"docs": {"coercer.core.utils.generate_exploit_path_from_template": {"tf": 1}, "coercer.network.Listener.Listener.start_http": {"tf": 1}, "coercer.network.authentications.trigger_and_catch_authentication": {"tf": 1}}, "df": 3}, "docs": {"coercer.core.utils.gen_random_name": {"tf": 1}}, "df": 1}, "docs": {"coercer.core.Filter.Filter.__init__": {"tf": 5.5677643628300215}, "coercer.core.Filter.Filter.method_matches_filter": {"tf": 3.7416573867739413}, "coercer.core.Filter.Filter.pipe_matches_filter": {"tf": 3.7416573867739413}, "coercer.core.Reporter.Reporter.__init__": {"tf": 4}, "coercer.core.Reporter.Reporter.print_testing": {"tf": 3.7416573867739413}, "coercer.core.Reporter.Reporter.print_info": {"tf": 3.7416573867739413}, "coercer.core.Reporter.Reporter.print_warn": {"tf": 3.7416573867739413}, "coercer.core.Reporter.Reporter.print_verbose": {"tf": 3.7416573867739413}, "coercer.core.Reporter.Reporter.report_test_result": {"tf": 6.4031242374328485}, "coercer.core.Reporter.Reporter.exportXLSX": {"tf": 3.7416573867739413}, "coercer.core.Reporter.Reporter.exportJSON": {"tf": 3.7416573867739413}, "coercer.core.Reporter.Reporter.exportSQLITE": {"tf": 4.242640687119285}, "coercer.core.loader.find_and_load_coerce_methods": {"tf": 3.7416573867739413}, "coercer.core.modes.coerce.action_coerce": {"tf": 5.0990195135927845}, "coercer.core.modes.fuzz.action_fuzz": {"tf": 5.0990195135927845}, "coercer.core.modes.scan.action_scan": {"tf": 5.0990195135927845}, "coercer.core.utils.gen_random_name": {"tf": 3.7416573867739413}, "coercer.core.utils.generate_exploit_templates": {"tf": 3.7416573867739413}, "coercer.core.utils.generate_exploit_path_from_template": {"tf": 5.477225575051661}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.trigger": {"tf": 4.242640687119285}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.trigger": {"tf": 4.242640687119285}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.trigger": {"tf": 4.242640687119285}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.trigger": {"tf": 4.242640687119285}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.trigger": {"tf": 4.242640687119285}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.trigger": {"tf": 4.242640687119285}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.trigger": {"tf": 4.242640687119285}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.trigger": {"tf": 4.242640687119285}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.trigger": {"tf": 4.242640687119285}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.trigger": {"tf": 4.242640687119285}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.trigger": {"tf": 4.242640687119285}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.trigger": {"tf": 4.242640687119285}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.trigger": {"tf": 4.242640687119285}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.trigger": {"tf": 4.242640687119285}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.trigger": {"tf": 4.242640687119285}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.trigger": {"tf": 4.242640687119285}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.trigger": {"tf": 4.242640687119285}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.__init__": {"tf": 2.8284271247461903}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.generate_exploit_templates": {"tf": 4.242640687119285}, "coercer.network.DCERPCSession.DCERPCSession.__init__": {"tf": 4}, "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_ip_tcp": {"tf": 5.830951894845301}, "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_np": {"tf": 5.830951894845301}, "coercer.network.DCERPCSession.DCERPCSession.bind": {"tf": 5.0990195135927845}, "coercer.network.DCERPCSession.DCERPCSession.set_verbose": {"tf": 3.7416573867739413}, "coercer.network.DCERPCSession.DCERPCSession.get_verbose": {"tf": 3.1622776601683795}, "coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 5.291502622129181}, "coercer.network.Listener.Listener.__init__": {"tf": 4.898979485566356}, "coercer.network.Listener.Listener.start_smb": {"tf": 3.7416573867739413}, "coercer.network.Listener.Listener.start_http": {"tf": 4.69041575982343}, "coercer.network.authentications.trigger_and_catch_authentication": {"tf": 7}, "coercer.network.authentications.trigger_authentication": {"tf": 4.242640687119285}, "coercer.network.rpc.portmap_discover": {"tf": 4.242640687119285}, "coercer.network.rpc.is_port_open": {"tf": 4.69041575982343}, "coercer.network.rpc.can_bind_to_interface_on_port": {"tf": 5.830951894845301}, "coercer.network.smb.init_smb_session": {"tf": 7.0710678118654755}, "coercer.network.smb.try_login": {"tf": 5.477225575051661}, "coercer.network.smb.list_remote_pipes": {"tf": 6.324555320336759}, "coercer.network.smb.can_connect_to_pipe": {"tf": 5.830951894845301}, "coercer.network.smb.can_bind_to_interface": {"tf": 7}, "coercer.network.utils.get_ip_address_of_interface": {"tf": 3.1622776601683795}, "coercer.network.utils.get_ip_address_to_target_remote_host": {"tf": 3.7416573867739413}, "coercer.network.utils.can_listen_on_port": {"tf": 3.7416573867739413}, "coercer.network.utils.get_ip_addr_to_listen_on": {"tf": 3.7416573867739413}, "coercer.network.utils.get_next_http_listener_port": {"tf": 4.242640687119285}, "coercer.structures.Credentials.Credentials.__init__": {"tf": 6.855654600401044}, "coercer.structures.Credentials.Credentials.is_anonymous": {"tf": 3.1622776601683795}}, "df": 65, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"coercer.core.Filter.Filter.__init__": {"tf": 1.7320508075688772}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.Reporter.Reporter.exportXLSX": {"tf": 1}, "coercer.core.Reporter.Reporter.exportJSON": {"tf": 1}, "coercer.core.Reporter.Reporter.exportSQLITE": {"tf": 1}}, "df": 3}}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.Reporter.Reporter.__init__": {"tf": 1}, "coercer.core.loader.find_and_load_coerce_methods": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.__init__": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_ip_tcp": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_np": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.bind": {"tf": 1}, "coercer.network.rpc.is_port_open": {"tf": 1}, "coercer.network.rpc.can_bind_to_interface_on_port": {"tf": 1}, "coercer.network.smb.init_smb_session": {"tf": 1}, "coercer.network.smb.try_login": {"tf": 1}, "coercer.network.smb.list_remote_pipes": {"tf": 1}, "coercer.network.smb.can_connect_to_pipe": {"tf": 1}, "coercer.network.smb.can_bind_to_interface": {"tf": 1}, "coercer.structures.Credentials.Credentials.__init__": {"tf": 1}}, "df": 14}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.network.authentications.trigger_and_catch_authentication": {"tf": 1}, "coercer.network.authentications.trigger_authentication": {"tf": 1}}, "df": 2}}}}}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"coercer.core.Filter.Filter.__init__": {"tf": 1}, "coercer.network.authentications.trigger_and_catch_authentication": {"tf": 1}, "coercer.network.authentications.trigger_authentication": {"tf": 1}}, "df": 3, "s": {"docs": {"coercer.core.modes.coerce.action_coerce": {"tf": 1}, "coercer.core.modes.fuzz.action_fuzz": {"tf": 1}, "coercer.core.modes.scan.action_scan": {"tf": 1}}, "df": 3}}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.Reporter.Reporter.print_info": {"tf": 1}, "coercer.core.Reporter.Reporter.print_warn": {"tf": 1}, "coercer.core.Reporter.Reporter.print_verbose": {"tf": 1}}, "df": 3}}}}}}, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"coercer.core.Reporter.Reporter.print_testing": {"tf": 1}, "coercer.core.Reporter.Reporter.report_test_result": {"tf": 1}}, "df": 2}}}}}}}}}, "a": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"coercer.network.smb.list_remote_pipes": {"tf": 1}}, "df": 1}}}}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.Filter.Filter.__init__": {"tf": 1.7320508075688772}, "coercer.core.Filter.Filter.pipe_matches_filter": {"tf": 1}}, "df": 2, "d": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.Reporter.Reporter.report_test_result": {"tf": 1}}, "df": 1}}}}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.Filter.Filter.__init__": {"tf": 1.7320508075688772}, "coercer.core.utils.generate_exploit_templates": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.generate_exploit_templates": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_ip_tcp": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_np": {"tf": 1}, "coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1.7320508075688772}, "coercer.network.Listener.Listener.__init__": {"tf": 1.4142135623730951}, "coercer.network.authentications.trigger_and_catch_authentication": {"tf": 1}, "coercer.network.smb.can_connect_to_pipe": {"tf": 1}, "coercer.network.smb.can_bind_to_interface": {"tf": 1}, "coercer.structures.Credentials.Credentials.__init__": {"tf": 1}}, "df": 11}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {"coercer.network.smb.init_smb_session": {"tf": 1}, "coercer.structures.Credentials.Credentials.__init__": {"tf": 1}}, "df": 2}}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"coercer.core.Filter.Filter.__init__": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.Filter.Filter.__init__": {"tf": 1}, "coercer.core.Filter.Filter.pipe_matches_filter": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_np": {"tf": 1}, "coercer.network.smb.can_connect_to_pipe": {"tf": 1}, "coercer.network.smb.can_bind_to_interface": {"tf": 1}}, "df": 5}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"coercer.core.utils.generate_exploit_path_from_template": {"tf": 1.4142135623730951}, "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_ip_tcp": {"tf": 1}, "coercer.network.Listener.Listener.start_http": {"tf": 1}, "coercer.network.authentications.trigger_and_catch_authentication": {"tf": 1}, "coercer.network.rpc.portmap_discover": {"tf": 1}, "coercer.network.rpc.is_port_open": {"tf": 1}, "coercer.network.rpc.can_bind_to_interface_on_port": {"tf": 1}, "coercer.network.smb.try_login": {"tf": 1}, "coercer.network.utils.get_ip_address_to_target_remote_host": {"tf": 1}, "coercer.network.utils.can_listen_on_port": {"tf": 1}}, "df": 10}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.__init__": {"tf": 1}}, "df": 1}}, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"coercer.network.smb.init_smb_session": {"tf": 1}, "coercer.structures.Credentials.Credentials.__init__": {"tf": 1}}, "df": 2}}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "f": {"docs": {"coercer.core.Filter.Filter.method_matches_filter": {"tf": 1}, "coercer.core.Filter.Filter.pipe_matches_filter": {"tf": 1}, "coercer.core.Reporter.Reporter.print_testing": {"tf": 1}, "coercer.core.Reporter.Reporter.print_info": {"tf": 1}, "coercer.core.Reporter.Reporter.print_warn": {"tf": 1}, "coercer.core.Reporter.Reporter.print_verbose": {"tf": 1}, "coercer.core.Reporter.Reporter.report_test_result": {"tf": 1}, "coercer.core.Reporter.Reporter.exportXLSX": {"tf": 1}, "coercer.core.Reporter.Reporter.exportJSON": {"tf": 1}, "coercer.core.Reporter.Reporter.exportSQLITE": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.trigger": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.trigger": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.trigger": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.trigger": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.trigger": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.trigger": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.trigger": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_ip_tcp": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_np": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.bind": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.set_verbose": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.get_verbose": {"tf": 1}, "coercer.network.Listener.Listener.start_smb": {"tf": 1}, "coercer.network.Listener.Listener.start_http": {"tf": 1}, "coercer.structures.Credentials.Credentials.is_anonymous": {"tf": 1}}, "df": 35}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.trigger": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.trigger": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.trigger": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.trigger": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.trigger": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.trigger": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.trigger": {"tf": 1}, "coercer.network.authentications.trigger_and_catch_authentication": {"tf": 1}, "coercer.network.authentications.trigger_authentication": {"tf": 1}}, "df": 19}}}}}}, "m": {"docs": {}, "df": 0, "b": {"docs": {"coercer.core.utils.generate_exploit_path_from_template": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"coercer.network.Listener.Listener.start_smb": {"tf": 1}, "coercer.network.Listener.Listener.start_http": {"tf": 1}}, "df": 2}}}}}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"coercer.network.smb.list_remote_pipes": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.Filter.Filter.method_matches_filter": {"tf": 1}, "coercer.core.Reporter.Reporter.print_testing": {"tf": 1}, "coercer.core.Reporter.Reporter.report_test_result": {"tf": 1}}, "df": 3}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.bind": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "p": {"docs": {"coercer.network.Listener.Listener.__init__": {"tf": 1}, "coercer.network.authentications.trigger_and_catch_authentication": {"tf": 1}, "coercer.network.utils.can_listen_on_port": {"tf": 1}, "coercer.network.utils.get_next_http_listener_port": {"tf": 1}}, "df": 4, "c": {"docs": {"coercer.network.smb.list_remote_pipes": {"tf": 1}}, "df": 1}}, "f": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"coercer.network.utils.get_ip_address_of_interface": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"coercer.core.Reporter.Reporter.__init__": {"tf": 1}, "coercer.core.modes.coerce.action_coerce": {"tf": 1}, "coercer.core.modes.fuzz.action_fuzz": {"tf": 1}, "coercer.core.modes.scan.action_scan": {"tf": 1}, "coercer.network.Listener.Listener.__init__": {"tf": 1}, "coercer.network.authentications.trigger_and_catch_authentication": {"tf": 1}, "coercer.network.utils.get_ip_addr_to_listen_on": {"tf": 1}, "coercer.network.utils.get_next_http_listener_port": {"tf": 1}}, "df": 8}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.Reporter.Reporter.__init__": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.__init__": {"tf": 1}, "coercer.network.rpc.is_port_open": {"tf": 1}, "coercer.network.rpc.can_bind_to_interface_on_port": {"tf": 1}, "coercer.network.smb.init_smb_session": {"tf": 1}, "coercer.network.smb.try_login": {"tf": 1}, "coercer.network.smb.can_connect_to_pipe": {"tf": 1}, "coercer.network.smb.can_bind_to_interface": {"tf": 1}}, "df": 8}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.core.Reporter.Reporter.report_test_result": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.bind": {"tf": 1}, "coercer.network.rpc.can_bind_to_interface_on_port": {"tf": 1}, "coercer.network.smb.can_bind_to_interface": {"tf": 1}}, "df": 4}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.set_verbose": {"tf": 1}, "coercer.network.utils.get_next_http_listener_port": {"tf": 1}}, "df": 2}}}}}, "r": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "c": {"docs": {"coercer.core.Reporter.Reporter.print_testing": {"tf": 1}, "coercer.core.Reporter.Reporter.report_test_result": {"tf": 1}}, "df": 2}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"coercer.core.Reporter.Reporter.report_test_result": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"coercer.core.modes.coerce.action_coerce": {"tf": 1}, "coercer.core.modes.fuzz.action_fuzz": {"tf": 1}, "coercer.core.modes.scan.action_scan": {"tf": 1}}, "df": 3}}}}}}}}, "u": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {"coercer.core.Reporter.Reporter.report_test_result": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.bind": {"tf": 1}, "coercer.network.rpc.can_bind_to_interface_on_port": {"tf": 1}, "coercer.network.smb.can_bind_to_interface": {"tf": 1}}, "df": 4}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"coercer.network.smb.init_smb_session": {"tf": 1}, "coercer.structures.Credentials.Credentials.__init__": {"tf": 1}}, "df": 2}}}}}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"coercer.core.Reporter.Reporter.report_test_result": {"tf": 1}}, "df": 1}}}}}}}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"coercer.core.Reporter.Reporter.exportSQLITE": {"tf": 1}, "coercer.core.modes.coerce.action_coerce": {"tf": 1}, "coercer.core.modes.fuzz.action_fuzz": {"tf": 1}, "coercer.core.modes.scan.action_scan": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.trigger": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.trigger": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.trigger": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.trigger": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.trigger": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.trigger": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.trigger": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_ip_tcp": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_np": {"tf": 1}, "coercer.network.authentications.trigger_and_catch_authentication": {"tf": 1}, "coercer.network.authentications.trigger_authentication": {"tf": 1}, "coercer.network.rpc.portmap_discover": {"tf": 1}, "coercer.network.rpc.is_port_open": {"tf": 1}, "coercer.network.rpc.can_bind_to_interface_on_port": {"tf": 1}, "coercer.network.smb.try_login": {"tf": 1}, "coercer.network.smb.list_remote_pipes": {"tf": 1}, "coercer.network.smb.can_connect_to_pipe": {"tf": 1}, "coercer.network.smb.can_bind_to_interface": {"tf": 1}, "coercer.network.utils.get_ip_addr_to_listen_on": {"tf": 1}}, "df": 33, "i": {"docs": {}, "df": 0, "p": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_ip_tcp": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_np": {"tf": 1}, "coercer.network.smb.can_connect_to_pipe": {"tf": 1}, "coercer.network.smb.can_bind_to_interface": {"tf": 1}}, "df": 4}}}}}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.utils.generate_exploit_templates": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.generate_exploit_templates": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.utils.generate_exploit_path_from_template": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"coercer.network.Listener.Listener.__init__": {"tf": 1}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"coercer.network.authentications.trigger_and_catch_authentication": {"tf": 1}, "coercer.network.authentications.trigger_authentication": {"tf": 1}}, "df": 2}}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "g": {"docs": {"coercer.core.loader.find_and_load_coerce_methods": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_ip_tcp": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_np": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.bind": {"tf": 1}, "coercer.network.smb.list_remote_pipes": {"tf": 1}}, "df": 5}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"coercer.core.utils.generate_exploit_templates": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.generate_exploit_templates": {"tf": 1}}, "df": 2}}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "c": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.trigger": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.trigger": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.trigger": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.trigger": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.trigger": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.trigger": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.trigger": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.trigger": {"tf": 1}, "coercer.network.authentications.trigger_and_catch_authentication": {"tf": 1}, "coercer.network.authentications.trigger_authentication": {"tf": 1}}, "df": 19}}}}}, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"coercer.network.smb.init_smb_session": {"tf": 1}, "coercer.structures.Credentials.Credentials.__init__": {"tf": 1}}, "df": 2}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {"coercer.structures.Credentials.Credentials.__init__": {"tf": 1}}, "df": 1}}}}}}}}}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.modes.coerce.action_coerce": {"tf": 1}, "coercer.core.modes.fuzz.action_fuzz": {"tf": 1}, "coercer.core.modes.scan.action_scan": {"tf": 1}}, "df": 3}}}}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"coercer.core.utils.generate_exploit_templates": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.generate_exploit_templates": {"tf": 1}}, "df": 2}}}, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"coercer.network.smb.init_smb_session": {"tf": 1}}, "df": 1}}}, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"coercer.network.smb.init_smb_session": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"coercer.core.modes.coerce.action_coerce": {"tf": 1}, "coercer.core.modes.fuzz.action_fuzz": {"tf": 1}, "coercer.core.modes.scan.action_scan": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.__init__": {"tf": 1}, "coercer.network.rpc.can_bind_to_interface_on_port": {"tf": 1}, "coercer.network.smb.try_login": {"tf": 1}, "coercer.network.smb.list_remote_pipes": {"tf": 1}, "coercer.network.smb.can_connect_to_pipe": {"tf": 1}, "coercer.network.smb.can_bind_to_interface": {"tf": 1}}, "df": 9}}}}}}}}}}, "l": {"docs": {}, "df": 0, "s": {"docs": {"coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.generate_exploit_templates": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}}, "df": 1}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"coercer.network.Listener.Listener.start_smb": {"tf": 1}, "coercer.network.Listener.Listener.start_http": {"tf": 1}}, "df": 2}}}}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"coercer.network.utils.get_next_http_listener_port": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"coercer.core.utils.gen_random_name": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"coercer.core.utils.generate_exploit_path_from_template": {"tf": 1.4142135623730951}, "coercer.network.Listener.Listener.__init__": {"tf": 1}, "coercer.network.authentications.trigger_and_catch_authentication": {"tf": 1}, "coercer.network.utils.can_listen_on_port": {"tf": 1}, "coercer.network.utils.get_next_http_listener_port": {"tf": 1}}, "df": 5, "e": {"docs": {}, "df": 0, "r": {"docs": {"coercer.core.utils.generate_exploit_path_from_template": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"coercer.network.authentications.trigger_and_catch_authentication": {"tf": 1}}, "df": 1}}}}}}}}}}}, "m": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {"coercer.network.smb.init_smb_session": {"tf": 1}, "coercer.structures.Credentials.Credentials.__init__": {"tf": 1}}, "df": 2}}}}}}, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {"coercer.core.utils.generate_exploit_path_from_template": {"tf": 1}, "coercer.network.Listener.Listener.start_http": {"tf": 1}, "coercer.network.authentications.trigger_and_catch_authentication": {"tf": 1}}, "df": 3}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"coercer.network.utils.get_ip_address_to_target_remote_host": {"tf": 1}}, "df": 1}}}}, "k": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"coercer.structures.Credentials.Credentials.__init__": {"tf": 1}}, "df": 1}}}}}}}}}, "bases": {"root": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}}, "df": 17}}}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}}, "df": 17}}}}}, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1.4142135623730951}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile": {"tf": 1.4142135623730951}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW": {"tf": 1.4142135623730951}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied": {"tf": 1.4142135623730951}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported": {"tf": 1.4142135623730951}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1.4142135623730951}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1.4142135623730951}}, "df": 17}}}}}}}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1}, "coercer.network.DCERPCSessionError.DCERPCSessionError": {"tf": 1}}, "df": 12}}}}}}}}, "d": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "c": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1}, "coercer.network.DCERPCSessionError.DCERPCSessionError": {"tf": 1}}, "df": 12, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}, "v": {"5": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1}, "coercer.network.DCERPCSessionError.DCERPCSessionError": {"tf": 1}}, "df": 12}, "docs": {}, "df": 0}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1}}, "df": 11, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1}}, "df": 11}}}}}}}}}, "r": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {"coercer.structures.MethodType.MethodType": {"tf": 1.4142135623730951}, "coercer.structures.ReportingLevel.ReportingLevel": {"tf": 1.4142135623730951}, "coercer.structures.TestResult.TestResult": {"tf": 1.4142135623730951}}, "df": 3}}}}}}, "doc": {"root": {"0": {"docs": {"coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile": {"tf": 1}}, "df": 2}, "1": {"2": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo": {"tf": 1}}, "df": 2}, "3": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}}, "df": 1}, "docs": {"coercer.network.smb.list_remote_pipes": {"tf": 1}}, "df": 1, "c": {"1": {"docs": {}, "df": 0, "f": {"docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}}, "df": 1}}, "docs": {}, "df": 0}}, "4": {"1": {"9": {"1": {"docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "2": {"4": {"9": {"docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "4": {"8": {"2": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv": {"tf": 1}}, "df": 1, "c": {"4": {"2": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "5": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile": {"tf": 1}}, "df": 3}, "6": {"2": {"docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}}, "df": 1}, "5": {"docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}}, "df": 1}, "docs": {"coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile": {"tf": 1}}, "df": 1}, "7": {"docs": {"coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents": {"tf": 1}}, "df": 1}, "8": {"0": {"docs": {"coercer.network.Listener.Listener.start_http": {"tf": 1}}, "df": 1}, "7": {"docs": {}, "df": 0, "b": {"7": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "d": {"0": {"9": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"2": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "d": {"8": {"3": {"docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}}, "docs": {}, "df": 0}}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {"coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported": {"tf": 1}}, "df": 1}, "9": {"docs": {"coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied": {"tf": 1}}, "df": 2, "c": {"1": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"1": {"2": {"2": {"3": {"9": {"7": {"9": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}}, "docs": {}, "df": 0}}, "docs": {"coercer": {"tf": 1.7320508075688772}, "coercer.core": {"tf": 1.7320508075688772}, "coercer.core.Filter": {"tf": 1.7320508075688772}, "coercer.core.Filter.Filter": {"tf": 1.4142135623730951}, "coercer.core.Filter.Filter.__init__": {"tf": 1.7320508075688772}, "coercer.core.Filter.Filter.filter_method_name": {"tf": 1.7320508075688772}, "coercer.core.Filter.Filter.filter_protocol_name": {"tf": 1.7320508075688772}, "coercer.core.Filter.Filter.filter_pipe_name": {"tf": 1.7320508075688772}, "coercer.core.Filter.Filter.method_matches_filter": {"tf": 2.449489742783178}, "coercer.core.Filter.Filter.pipe_matches_filter": {"tf": 2.449489742783178}, "coercer.core.Reporter": {"tf": 1.7320508075688772}, "coercer.core.Reporter.CURSOR_UP_ONE": {"tf": 1.7320508075688772}, "coercer.core.Reporter.ERASE_LINE": {"tf": 1.7320508075688772}, "coercer.core.Reporter.Reporter": {"tf": 1.4142135623730951}, "coercer.core.Reporter.Reporter.__init__": {"tf": 1.7320508075688772}, "coercer.core.Reporter.Reporter.options": {"tf": 1.7320508075688772}, "coercer.core.Reporter.Reporter.verbose": {"tf": 1.7320508075688772}, "coercer.core.Reporter.Reporter.test_results": {"tf": 1.7320508075688772}, "coercer.core.Reporter.Reporter.print_testing": {"tf": 1.7320508075688772}, "coercer.core.Reporter.Reporter.print_info": {"tf": 1.7320508075688772}, "coercer.core.Reporter.Reporter.print_warn": {"tf": 1.7320508075688772}, "coercer.core.Reporter.Reporter.print_verbose": {"tf": 1.7320508075688772}, "coercer.core.Reporter.Reporter.report_test_result": {"tf": 1.7320508075688772}, "coercer.core.Reporter.Reporter.exportXLSX": {"tf": 1.7320508075688772}, "coercer.core.Reporter.Reporter.exportJSON": {"tf": 1.7320508075688772}, "coercer.core.Reporter.Reporter.exportSQLITE": {"tf": 1.7320508075688772}, "coercer.core.loader": {"tf": 1.7320508075688772}, "coercer.core.loader.find_and_load_coerce_methods": {"tf": 2.6457513110645907}, "coercer.core.modes": {"tf": 1.7320508075688772}, "coercer.core.modes.coerce": {"tf": 1.7320508075688772}, "coercer.core.modes.coerce.action_coerce": {"tf": 1.7320508075688772}, "coercer.core.modes.fuzz": {"tf": 1.7320508075688772}, "coercer.core.modes.fuzz.action_fuzz": {"tf": 1.7320508075688772}, "coercer.core.modes.scan": {"tf": 1.7320508075688772}, "coercer.core.modes.scan.action_scan": {"tf": 1.7320508075688772}, "coercer.core.utils": {"tf": 1.7320508075688772}, "coercer.core.utils.gen_random_name": {"tf": 1.7320508075688772}, "coercer.core.utils.generate_exploit_templates": {"tf": 1.7320508075688772}, "coercer.core.utils.generate_exploit_path_from_template": {"tf": 1.7320508075688772}, "coercer.methods": {"tf": 1.7320508075688772}, "coercer.methods.MS_DFSNM": {"tf": 1.7320508075688772}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot": {"tf": 1.7320508075688772}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 4}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.access": {"tf": 1.7320508075688772}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.protocol": {"tf": 1.7320508075688772}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.function": {"tf": 1.7320508075688772}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot.trigger": {"tf": 1.7320508075688772}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot": {"tf": 1.7320508075688772}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 4}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.access": {"tf": 1.7320508075688772}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.protocol": {"tf": 1.7320508075688772}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.function": {"tf": 1.7320508075688772}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot.trigger": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB.structure": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile": {"tf": 3.7416573867739413}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.access": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.protocol": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.function": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile.trigger": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB.structure": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB.structure": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST.structure": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx": {"tf": 2}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.access": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.protocol": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.function": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx.trigger": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv": {"tf": 3.7416573867739413}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.access": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.protocol": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.function": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv.trigger": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB.structure": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile": {"tf": 3.7416573867739413}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.access": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.protocol": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.function": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile.trigger": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv": {"tf": 3.7416573867739413}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.access": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.protocol": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.function": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv.trigger": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo": {"tf": 3.7416573867739413}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.access": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.protocol": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.function": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo.trigger": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw": {"tf": 3.7416573867739413}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.access": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.protocol": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.function": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw.trigger": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents": {"tf": 3.7416573867739413}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.access": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.protocol": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.function": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents.trigger": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile": {"tf": 3.7416573867739413}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.access": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.protocol": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.function": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile.trigger": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB.structure": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH.structure": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.align": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST.structure": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile": {"tf": 3.7416573867739413}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.access": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.protocol": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.function": {"tf": 1.7320508075688772}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile.trigger": {"tf": 1.7320508075688772}, "coercer.methods.MS_EVEN": {"tf": 1.7320508075688772}, "coercer.methods.MS_EVEN.ElfrOpenBELW": {"tf": 1.7320508075688772}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW": {"tf": 4}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.access": {"tf": 1.7320508075688772}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.protocol": {"tf": 1.7320508075688772}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.function": {"tf": 1.7320508075688772}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW.trigger": {"tf": 1.7320508075688772}, "coercer.methods.MS_FSRVP": {"tf": 1.7320508075688772}, "coercer.methods.MS_FSRVP.IsPathShadowCopied": {"tf": 1.7320508075688772}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied": {"tf": 3.7416573867739413}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.access": {"tf": 1.7320508075688772}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.protocol": {"tf": 1.7320508075688772}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.function": {"tf": 1.7320508075688772}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied.trigger": {"tf": 1.7320508075688772}, "coercer.methods.MS_FSRVP.IsPathSupported": {"tf": 1.7320508075688772}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported": {"tf": 3.7416573867739413}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.access": {"tf": 1.7320508075688772}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.protocol": {"tf": 1.7320508075688772}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.function": {"tf": 1.7320508075688772}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported.trigger": {"tf": 1.7320508075688772}, "coercer.methods.MS_RPRN": {"tf": 1.7320508075688772}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1.7320508075688772}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 2.8284271247461903}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.access": {"tf": 1.7320508075688772}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.protocol": {"tf": 1.7320508075688772}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.function": {"tf": 1.7320508075688772}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification.trigger": {"tf": 1.7320508075688772}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1.7320508075688772}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 2.8284271247461903}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.exploit_paths": {"tf": 1.7320508075688772}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.access": {"tf": 1.7320508075688772}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.protocol": {"tf": 1.7320508075688772}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.function": {"tf": 1.7320508075688772}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx.trigger": {"tf": 1.7320508075688772}, "coercer.models": {"tf": 1.7320508075688772}, "coercer.models.MSPROTOCOLRPCCALL": {"tf": 1.7320508075688772}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL": {"tf": 1.4142135623730951}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.__init__": {"tf": 1.7320508075688772}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.method_type": {"tf": 1.7320508075688772}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.exploit_paths": {"tf": 1.7320508075688772}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.path": {"tf": 1.7320508075688772}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.protocol": {"tf": 1.7320508075688772}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.function": {"tf": 1.7320508075688772}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL.generate_exploit_templates": {"tf": 1.7320508075688772}, "coercer.network": {"tf": 1.7320508075688772}, "coercer.network.DCERPCSession": {"tf": 1.7320508075688772}, "coercer.network.DCERPCSession.DCERPCSession": {"tf": 1.4142135623730951}, "coercer.network.DCERPCSession.DCERPCSession.__init__": {"tf": 1.7320508075688772}, "coercer.network.DCERPCSession.DCERPCSession.session": {"tf": 1.7320508075688772}, "coercer.network.DCERPCSession.DCERPCSession.target": {"tf": 1.7320508075688772}, "coercer.network.DCERPCSession.DCERPCSession.credentials": {"tf": 1.7320508075688772}, "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_ip_tcp": {"tf": 1.7320508075688772}, "coercer.network.DCERPCSession.DCERPCSession.connect_ncacn_np": {"tf": 1.7320508075688772}, "coercer.network.DCERPCSession.DCERPCSession.bind": {"tf": 1.7320508075688772}, "coercer.network.DCERPCSession.DCERPCSession.set_verbose": {"tf": 2.23606797749979}, "coercer.network.DCERPCSession.DCERPCSession.get_verbose": {"tf": 2.23606797749979}, "coercer.network.DCERPCSessionError": {"tf": 1.7320508075688772}, "coercer.network.DCERPCSessionError.DCERPCSessionError": {"tf": 1.7320508075688772}, "coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1.4142135623730951}, "coercer.network.Listener": {"tf": 1.7320508075688772}, "coercer.network.Listener.Listener": {"tf": 1.4142135623730951}, "coercer.network.Listener.Listener.__init__": {"tf": 1.7320508075688772}, "coercer.network.Listener.Listener.options": {"tf": 1.7320508075688772}, "coercer.network.Listener.Listener.timeout": {"tf": 1.7320508075688772}, "coercer.network.Listener.Listener.listen_ip": {"tf": 1.7320508075688772}, "coercer.network.Listener.Listener.start_smb": {"tf": 1.7320508075688772}, "coercer.network.Listener.Listener.start_http": {"tf": 1.7320508075688772}, "coercer.network.authentications": {"tf": 1.7320508075688772}, "coercer.network.authentications.trigger_and_catch_authentication": {"tf": 1.7320508075688772}, "coercer.network.authentications.trigger_authentication": {"tf": 1.7320508075688772}, "coercer.network.rpc": {"tf": 1.7320508075688772}, "coercer.network.rpc.portmap_discover": {"tf": 1.7320508075688772}, "coercer.network.rpc.is_port_open": {"tf": 1.7320508075688772}, "coercer.network.rpc.can_bind_to_interface_on_port": {"tf": 1.7320508075688772}, "coercer.network.smb": {"tf": 1.7320508075688772}, "coercer.network.smb.init_smb_session": {"tf": 1.7320508075688772}, "coercer.network.smb.try_login": {"tf": 1.4142135623730951}, "coercer.network.smb.list_remote_pipes": {"tf": 1.7320508075688772}, "coercer.network.smb.can_connect_to_pipe": {"tf": 1.7320508075688772}, "coercer.network.smb.can_bind_to_interface": {"tf": 1.7320508075688772}, "coercer.network.utils": {"tf": 1.7320508075688772}, "coercer.network.utils.get_ip_address_of_interface": {"tf": 1.7320508075688772}, "coercer.network.utils.get_ip_address_to_target_remote_host": {"tf": 1.7320508075688772}, "coercer.network.utils.can_listen_on_port": {"tf": 1.7320508075688772}, "coercer.network.utils.get_ip_addr_to_listen_on": {"tf": 1.7320508075688772}, "coercer.network.utils.get_next_http_listener_port": {"tf": 1.7320508075688772}, "coercer.structures": {"tf": 1.7320508075688772}, "coercer.structures.Credentials": {"tf": 1.7320508075688772}, "coercer.structures.Credentials.Credentials": {"tf": 1.4142135623730951}, "coercer.structures.Credentials.Credentials.__init__": {"tf": 1.7320508075688772}, "coercer.structures.Credentials.Credentials.username": {"tf": 1.7320508075688772}, "coercer.structures.Credentials.Credentials.password": {"tf": 1.7320508075688772}, "coercer.structures.Credentials.Credentials.domain": {"tf": 1.7320508075688772}, "coercer.structures.Credentials.Credentials.lmhash": {"tf": 1.7320508075688772}, "coercer.structures.Credentials.Credentials.nthash": {"tf": 1.7320508075688772}, "coercer.structures.Credentials.Credentials.doKerberos": {"tf": 1.7320508075688772}, "coercer.structures.Credentials.Credentials.kdcHost": {"tf": 1.7320508075688772}, "coercer.structures.Credentials.Credentials.is_anonymous": {"tf": 2}, "coercer.structures.MethodType": {"tf": 1.7320508075688772}, "coercer.structures.MethodType.MethodType": {"tf": 1.4142135623730951}, "coercer.structures.MethodType.MethodType.MICROSOFT_PROTOCOL": {"tf": 1.7320508075688772}, "coercer.structures.MethodType.MethodType.OTHER": {"tf": 1.7320508075688772}, "coercer.structures.ReportingLevel": {"tf": 1.7320508075688772}, "coercer.structures.ReportingLevel.ReportingLevel": {"tf": 1.4142135623730951}, "coercer.structures.ReportingLevel.ReportingLevel.INFO": {"tf": 1.7320508075688772}, "coercer.structures.ReportingLevel.ReportingLevel.VERBOSE": {"tf": 1.7320508075688772}, "coercer.structures.ReportingLevel.ReportingLevel.DEBUg": {"tf": 1.7320508075688772}, "coercer.structures.TestResult": {"tf": 1.7320508075688772}, "coercer.structures.TestResult.TestResult": {"tf": 1.4142135623730951}, "coercer.structures.TestResult.TestResult.NO_AUTH_RECEIVED": {"tf": 1.7320508075688772}, "coercer.structures.TestResult.TestResult.SMB_AUTH_RECEIVED": {"tf": 1.7320508075688772}, "coercer.structures.TestResult.TestResult.HTTP_AUTH_RECEIVED": {"tf": 1.7320508075688772}, "coercer.structures.TestResult.TestResult.NCA_S_UNK_IF": {"tf": 1.7320508075688772}, "coercer.structures.TestResult.TestResult.ERROR_BAD_NETPATH": {"tf": 1.7320508075688772}, "coercer.structures.TestResult.TestResult.ERROR_INVALID_NAME": {"tf": 1.7320508075688772}, "coercer.structures.TestResult.TestResult.RPC_X_BAD_STUB_DATA": {"tf": 1.7320508075688772}, "coercer.structures.TestResult.TestResult.RPC_S_ACCESS_DENIED": {"tf": 1.7320508075688772}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_BINDING": {"tf": 1.7320508075688772}, "coercer.structures.TestResult.TestResult.RPC_S_INVALID_NET_ADDR": {"tf": 1.7320508075688772}, "coercer.structures.TestResult.TestResult.SMB_STATUS_PIPE_DISCONNECTED": {"tf": 1.7320508075688772}}, "df": 273, "d": {"0": {"5": {"docs": {}, "df": 0, "c": {"7": {"7": {"8": {"3": {"docs": {}, "df": 0, "d": {"6": {"5": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx": {"tf": 1}}, "df": 1}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.core.Filter.Filter": {"tf": 1}, "coercer.core.Reporter.Reporter": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession": {"tf": 1}, "coercer.network.smb.try_login": {"tf": 1}, "coercer.structures.Credentials.Credentials": {"tf": 1}}, "df": 6}}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.loader.find_and_load_coerce_methods": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}}, "df": 2}}}}}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}}, "df": 1}}}}}}}}}, "e": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "g": {"docs": {"coercer.core.loader.find_and_load_coerce_methods": {"tf": 1}, "coercer.network.smb.list_remote_pipes": {"tf": 1}}, "df": 2}}}, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}}, "df": 1}}}}}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}}, "df": 1}}}}}}, "f": {"docs": {}, "df": 0, "s": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}}, "df": 2, "n": {"docs": {}, "df": 0, "m": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}}, "df": 2, "/": {"9": {"5": {"docs": {}, "df": 0, "a": {"5": {"0": {"6": {"docs": {}, "df": 0, "a": {"8": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}}, "df": 2}}}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "c": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1}}, "df": 11, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.network.DCERPCSession.DCERPCSession": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "f": {"1": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "d": {"docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}}, "df": 1}}}, "docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"coercer.core.Filter.Filter": {"tf": 1}, "coercer.core.Reporter.Reporter": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession": {"tf": 1}, "coercer.network.smb.try_login": {"tf": 1}, "coercer.structures.Credentials.Credentials": {"tf": 1}}, "df": 17}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}}, "df": 16}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"coercer.core.Filter.Filter": {"tf": 1}, "coercer.core.Filter.Filter.method_matches_filter": {"tf": 1}, "coercer.core.Filter.Filter.pipe_matches_filter": {"tf": 1}}, "df": 3}}}, "e": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}}, "df": 2}, "i": {"docs": {}, "df": 0, "p": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}}, "df": 2}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"coercer.core.loader.find_and_load_coerce_methods": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.core.Filter.Filter.method_matches_filter": {"tf": 1}, "coercer.core.Filter.Filter.pipe_matches_filter": {"tf": 1}, "coercer.core.loader.find_and_load_coerce_methods": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}, "coercer.network.Listener.Listener.start_smb": {"tf": 1}, "coercer.network.Listener.Listener.start_http": {"tf": 1}, "coercer.network.smb.list_remote_pipes": {"tf": 1}, "coercer.network.smb.can_connect_to_pipe": {"tf": 1}, "coercer.network.smb.can_bind_to_interface": {"tf": 1}, "coercer.network.utils.get_ip_address_of_interface": {"tf": 1}, "coercer.network.utils.get_ip_address_to_target_remote_host": {"tf": 1}, "coercer.network.utils.can_listen_on_port": {"tf": 1}, "coercer.network.utils.get_ip_addr_to_listen_on": {"tf": 1}, "coercer.network.utils.get_next_http_listener_port": {"tf": 1}, "coercer.structures.Credentials.Credentials.is_anonymous": {"tf": 1}}, "df": 30}}}}}}}, "s": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "p": {"docs": {"coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported": {"tf": 1}}, "df": 5}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"coercer.network.smb.list_remote_pipes": {"tf": 1}, "coercer.network.smb.can_connect_to_pipe": {"tf": 1}, "coercer.network.smb.can_bind_to_interface": {"tf": 1}, "coercer.structures.Credentials.Credentials.is_anonymous": {"tf": 1}}, "df": 4}}}}}, "c": {"5": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"2": {"3": {"1": {"4": {"docs": {}, "df": 0, "d": {"docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}}, "df": 1}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}}}}}, "docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"coercer.core.Filter.Filter": {"tf": 1}, "coercer.core.Reporter.Reporter": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1}, "coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession": {"tf": 1}, "coercer.network.Listener.Listener": {"tf": 1}, "coercer.structures.Credentials.Credentials": {"tf": 1}, "coercer.structures.MethodType.MethodType": {"tf": 1}, "coercer.structures.ReportingLevel.ReportingLevel": {"tf": 1}, "coercer.structures.TestResult.TestResult": {"tf": 1}}, "df": 20}}}}, "o": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.loader.find_and_load_coerce_methods": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}}, "df": 16}}}}}}, "m": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}}, "df": 5}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1.4142135623730951}}, "df": 1}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"coercer.network.Listener.Listener.start_smb": {"tf": 1}, "coercer.network.Listener.Listener.start_http": {"tf": 1}}, "df": 2}}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"coercer.network.smb.can_connect_to_pipe": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "e": {"6": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}, "l": {"docs": {}, "df": 0, "l": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}}, "df": 1}}, "n": {"docs": {"coercer.network.smb.can_connect_to_pipe": {"tf": 1}, "coercer.network.smb.can_bind_to_interface": {"tf": 1}, "coercer.network.utils.can_listen_on_port": {"tf": 1}}, "df": 3}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.set_verbose": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.get_verbose": {"tf": 1}, "coercer.network.utils.get_next_http_listener_port": {"tf": 1}}, "df": 3}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"coercer.network.smb.list_remote_pipes": {"tf": 1}, "coercer.network.smb.can_connect_to_pipe": {"tf": 1}, "coercer.network.smb.can_bind_to_interface": {"tf": 1}, "coercer.structures.Credentials.Credentials": {"tf": 1}}, "df": 4}}}}}}}}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"coercer.core.Filter.Filter.method_matches_filter": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}}, "df": 17, "s": {"docs": {"coercer.core.loader.find_and_load_coerce_methods": {"tf": 1.4142135623730951}}, "df": 1}, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"coercer.structures.MethodType.MethodType": {"tf": 1}}, "df": 1}}}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"coercer.core.Filter.Filter.method_matches_filter": {"tf": 1}, "coercer.core.Filter.Filter.pipe_matches_filter": {"tf": 1}}, "df": 2}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}}, "df": 16}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}}, "df": 2}}}}}}}}, "x": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"coercer.network.smb.list_remote_pipes": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}}, "df": 16, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"coercer.models.MSPROTOCOLRPCCALL.MSPROTOCOLRPCCALL": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "t": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}}, "df": 5}}}}}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1.7320508075688772}}, "df": 1, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"coercer.core.Filter.Filter.method_matches_filter": {"tf": 1}, "coercer.core.Filter.Filter.pipe_matches_filter": {"tf": 1}, "coercer.core.loader.find_and_load_coerce_methods": {"tf": 1}}, "df": 3}}}}}}}}, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.Filter.Filter.pipe_matches_filter": {"tf": 1.4142135623730951}, "coercer.network.smb.can_connect_to_pipe": {"tf": 1.4142135623730951}, "coercer.network.smb.can_bind_to_interface": {"tf": 1}}, "df": 3, "s": {"docs": {"coercer.network.smb.list_remote_pipes": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}}, "df": 16, "s": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}}, "df": 5}}}}}}}}}, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1}}, "df": 11}}}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}}, "df": 2}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"coercer.network.Listener.Listener.start_http": {"tf": 1}, "coercer.network.utils.get_ip_address_to_target_remote_host": {"tf": 1}, "coercer.network.utils.can_listen_on_port": {"tf": 1.4142135623730951}, "coercer.network.utils.get_next_http_listener_port": {"tf": 1}}, "df": 4}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.Filter.Filter.method_matches_filter": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"coercer.network.smb.can_bind_to_interface": {"tf": 1}, "coercer.network.utils.get_ip_address_of_interface": {"tf": 1}}, "df": 2}}}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}}, "df": 1}}}}}}}}}}, "s": {"docs": {"coercer.structures.Credentials.Credentials.is_anonymous": {"tf": 1.4142135623730951}}, "df": 1, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied": {"tf": 1}}, "df": 1}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}, "f": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1.4142135623730951}, "coercer.structures.Credentials.Credentials.is_anonymous": {"tf": 1}}, "df": 2, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"coercer.network.utils.get_ip_address_of_interface": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {"coercer.network.utils.get_ip_address_of_interface": {"tf": 1}, "coercer.network.utils.get_ip_address_to_target_remote_host": {"tf": 1}, "coercer.network.utils.can_listen_on_port": {"tf": 1}, "coercer.network.utils.get_ip_addr_to_listen_on": {"tf": 1}, "coercer.network.utils.get_next_http_listener_port": {"tf": 1}}, "df": 5, "c": {"docs": {"coercer.network.smb.list_remote_pipes": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"coercer.core.Filter.Filter.method_matches_filter": {"tf": 1}, "coercer.core.Filter.Filter.pipe_matches_filter": {"tf": 1}}, "df": 2, "s": {"docs": {"coercer.core.loader.find_and_load_coerce_methods": {"tf": 1}, "coercer.structures.Credentials.Credentials.is_anonymous": {"tf": 1.4142135623730951}}, "df": 2}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"coercer.core.Reporter.Reporter": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"coercer.structures.ReportingLevel.ReportingLevel": {"tf": 1}}, "df": 1}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1}}, "df": 11}}}}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW": {"tf": 1}}, "df": 1}}}, "e": {"docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}, "coercer.network.smb.list_remote_pipes": {"tf": 1}, "coercer.network.utils.get_ip_address_to_target_remote_host": {"tf": 1}}, "df": 4}}}}, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}}, "df": 1}}}}}}}, "p": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "x": {"docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "n": {"docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}}, "df": 2, "/": {"docs": {}, "df": 0, "b": {"8": {"docs": {}, "df": 0, "b": {"4": {"1": {"4": {"docs": {}, "df": 0, "d": {"9": {"docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "e": {"docs": {}, "df": 0, "b": {"6": {"6": {"docs": {}, "df": 0, "b": {"2": {"2": {"1": {"docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}}}}}}, "b": {"1": {"9": {"docs": {}, "df": 0, "d": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}}, "df": 2}}, "docs": {}, "df": 0}, "8": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "c": {"docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}}, "df": 1}}}, "docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, ":": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.Filter.Filter.method_matches_filter": {"tf": 1}, "coercer.core.Filter.Filter.pipe_matches_filter": {"tf": 1}}, "df": 2}}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "g": {"docs": {"coercer.core.loader.find_and_load_coerce_methods": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"coercer.structures.Credentials.Credentials.is_anonymous": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "y": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}}, "df": 16}, "e": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1}, "coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}}, "df": 12}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1}}, "df": 11}}}, "b": {"6": {"docs": {}, "df": 0, "b": {"docs": {"coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}}, "df": 1}}, "docs": {}, "df": 0}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"coercer.network.smb.can_bind_to_interface": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.Filter.Filter.pipe_matches_filter": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}}, "df": 2}}}}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}}, "df": 1}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}, "x": {"docs": {}, "df": 0, "t": {"docs": {"coercer.network.utils.get_next_http_listener_port": {"tf": 1}}, "df": 1}}}, "d": {"docs": {}, "df": 0, "r": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1.4142135623730951}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1.4142135623730951}, "coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1.4142135623730951}}, "df": 12}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"coercer.network.smb.can_connect_to_pipe": {"tf": 1}, "coercer.network.smb.can_bind_to_interface": {"tf": 1}}, "df": 2}}}}, "a": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}, "coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1.4142135623730951}}, "df": 28, "n": {"docs": {}, "df": 0, "d": {"docs": {"coercer.core.loader.find_and_load_coerce_methods": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1}}, "df": 12}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"coercer.structures.Credentials.Credentials.is_anonymous": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}}, "df": 16}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.structures.Credentials.Credentials.is_anonymous": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1}}, "df": 11}}, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "r": {"docs": {"coercer.network.utils.get_ip_addr_to_listen_on": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"coercer.network.utils.get_ip_address_of_interface": {"tf": 1}, "coercer.network.utils.get_ip_address_to_target_remote_host": {"tf": 1}}, "df": 2}}}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"coercer.core.loader.find_and_load_coerce_methods": {"tf": 1}}, "df": 1}}, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"coercer.network.smb.try_login": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"coercer.network.smb.list_remote_pipes": {"tf": 1}}, "df": 1, ":": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.loader.find_and_load_coerce_methods": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {"coercer.network.utils.can_listen_on_port": {"tf": 1.4142135623730951}, "coercer.network.utils.get_ip_addr_to_listen_on": {"tf": 1}, "coercer.network.utils.get_next_http_listener_port": {"tf": 1}}, "df": 3, "e": {"docs": {}, "df": 0, "r": {"docs": {"coercer.network.Listener.Listener": {"tf": 1}, "coercer.network.utils.get_next_http_listener_port": {"tf": 1}}, "df": 2}}}}}}}, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.set_verbose": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.get_verbose": {"tf": 1}}, "df": 2}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"coercer.core.loader.find_and_load_coerce_methods": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {"coercer.structures.MethodType.MethodType": {"tf": 1}, "coercer.structures.ReportingLevel.ReportingLevel": {"tf": 1}, "coercer.structures.TestResult.TestResult": {"tf": 1}}, "df": 3}}}, "f": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "r": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile": {"tf": 1}}, "df": 6, "p": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv": {"tf": 1}}, "df": 2}}}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {"coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {"coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo": {"tf": 1}}, "df": 1}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "w": {"docs": {"coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile": {"tf": 1}}, "df": 2}}}}}}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}, "/": {"docs": {}, "df": 0, "d": {"3": {"6": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "f": {"7": {"0": {"3": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}}}}, "d": {"docs": {}, "df": 0, "c": {"9": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}}, "l": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "w": {"docs": {"coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW": {"tf": 1}}, "df": 1}}}}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {"coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "z": {"docs": {"coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW": {"tf": 1}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 2}}, "df": 1}}}}, "x": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}}, "df": 1}}}}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}}, "df": 1}}}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"coercer.core.loader.find_and_load_coerce_methods": {"tf": 1}}, "df": 1}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"coercer.core.loader.find_and_load_coerce_methods": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}}, "df": 16}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"coercer.network.utils.get_ip_addr_to_listen_on": {"tf": 1}, "coercer.network.utils.get_next_http_listener_port": {"tf": 1}}, "df": 2}}}}}}, "f": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}, "coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}, "coercer.network.utils.get_ip_address_of_interface": {"tf": 1}}, "df": 18}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}, "coercer.structures.Credentials.Credentials.is_anonymous": {"tf": 1}}, "df": 2}}}}}}}}, "n": {"docs": {"coercer.network.utils.can_listen_on_port": {"tf": 1}, "coercer.network.utils.get_ip_addr_to_listen_on": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "s": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "o": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}, "coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}, "coercer.network.smb.can_connect_to_pipe": {"tf": 1}, "coercer.network.smb.can_bind_to_interface": {"tf": 1}, "coercer.network.utils.get_ip_address_to_target_remote_host": {"tf": 1}, "coercer.network.utils.get_ip_addr_to_listen_on": {"tf": 1}}, "df": 21, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"7": {"7": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported": {"tf": 1}}, "df": 11}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1}, "coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}}, "df": 12}}, "e": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.set_verbose": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.get_verbose": {"tf": 1}, "coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 2.23606797749979}}, "df": 14}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1}}, "df": 11, "s": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1}}, "df": 11}}}}, "r": {"docs": {}, "df": 0, "y": {"docs": {"coercer.network.smb.try_login": {"tf": 1}}, "df": 1}, "u": {"docs": {}, "df": 0, "e": {"docs": {"coercer.structures.Credentials.Credentials.is_anonymous": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"coercer.network.smb.list_remote_pipes": {"tf": 1}, "coercer.network.smb.can_connect_to_pipe": {"tf": 1}, "coercer.network.smb.can_bind_to_interface": {"tf": 1}, "coercer.network.utils.get_ip_address_to_target_remote_host": {"tf": 1}, "coercer.network.utils.get_ip_addr_to_listen_on": {"tf": 1}}, "df": 5, "i": {"docs": {}, "df": 0, "p": {"docs": {"coercer.network.smb.can_connect_to_pipe": {"tf": 1}, "coercer.network.smb.can_bind_to_interface": {"tf": 1}}, "df": 2}}}}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"coercer.structures.TestResult.TestResult": {"tf": 1}}, "df": 1}}}}}}}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EfsRpcAddUsersToFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDecryptFileSrv.EfsRpcDecryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EfsRpcDuplicateEncryptionInfoFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcEncryptFileSrv.EfsRpcEncryptFileSrv": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcFileKeyInfo.EfsRpcFileKeyInfo": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcOpenFileRaw.EfsRpcOpenFileRaw": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryRecoveryAgents.EfsRpcQueryRecoveryAgents": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcQueryUsersOnFile.EfsRpcQueryUsersOnFile": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EfsRpcRemoveUsersFromFile": {"tf": 1}, "coercer.methods.MS_EVEN.ElfrOpenBELW.ElfrOpenBELW": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathShadowCopied.IsPathShadowCopied": {"tf": 1}, "coercer.methods.MS_FSRVP.IsPathSupported.IsPathSupported": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}, "coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}}, "df": 17}}}, "/": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "s": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}}, "df": 5}}}}}}}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}, "coercer.structures.Credentials.Credentials.is_anonymous": {"tf": 1}}, "df": 2}, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {"coercer.network.smb.can_bind_to_interface": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}}, "df": 1, "y": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}}, "df": 4}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.set_verbose": {"tf": 1}}, "df": 1, "s": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.set_verbose": {"tf": 1}}, "df": 1}}, "l": {"docs": {}, "df": 0, "f": {"docs": {"coercer.network.Listener.Listener.start_smb": {"tf": 1}, "coercer.network.Listener.Listener.start_http": {"tf": 1}}, "df": 2}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1.7320508075688772}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"coercer.network.Listener.Listener.start_smb": {"tf": 1}, "coercer.network.Listener.Listener.start_http": {"tf": 1}}, "df": 2}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"coercer.network.Listener.Listener.start_smb": {"tf": 1}, "coercer.network.Listener.Listener.start_http": {"tf": 1}}, "df": 2}}}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"coercer.network.smb.list_remote_pipes": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}}, "df": 1}}}}}}}}}}}, "m": {"docs": {}, "df": 0, "b": {"docs": {"coercer.network.Listener.Listener.start_smb": {"tf": 1}}, "df": 1}}}, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {"coercer.network.Listener.Listener.start_http": {"tf": 1.4142135623730951}, "coercer.network.utils.get_next_http_listener_port": {"tf": 1}}, "df": 2, "s": {"docs": {}, "df": 0, ":": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {"coercer.methods.MS_DFSNM.NetrDfsAddStdRoot.NetrDfsAddStdRoot": {"tf": 1}, "coercer.methods.MS_DFSNM.NetrDfsRemoveStdRoot.NetrDfsRemoveStdRoot": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotificationEx.RpcRemoteFindFirstPrinterChangeNotificationEx": {"tf": 1}}, "df": 3}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EfsRpcAddUsersToFileEx": {"tf": 1}, "coercer.methods.MS_RPRN.RpcRemoteFindFirstPrinterChangeNotification.RpcRemoteFindFirstPrinterChangeNotification": {"tf": 1}}, "df": 2}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"coercer.network.utils.get_ip_address_to_target_remote_host": {"tf": 1.4142135623730951}}, "df": 1}}}}, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFile.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcAddUsersToFileEx.ENCRYPTION_CERTIFICATE_LIST": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcDuplicateEncryptionInfoFile.EFS_RPC_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.EFS_HASH_BLOB": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH": {"tf": 1}, "coercer.methods.MS_EFSR.EfsRpcRemoveUsersFromFile.ENCRYPTION_CERTIFICATE_HASH_LIST": {"tf": 1}, "coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}}, "df": 12}}, "t": {"docs": {}, "df": 0, "h": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}}, "df": 1}}}, "e": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}}, "df": 1}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.set_verbose": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.get_verbose": {"tf": 1}, "coercer.network.smb.can_connect_to_pipe": {"tf": 1}, "coercer.network.smb.can_bind_to_interface": {"tf": 1}}, "df": 4}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.set_verbose": {"tf": 1}, "coercer.network.DCERPCSession.DCERPCSession.get_verbose": {"tf": 1}}, "df": 2}}}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"coercer.network.smb.can_bind_to_interface": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.set_verbose": {"tf": 1}, "coercer.network.utils.get_next_http_listener_port": {"tf": 1}}, "df": 2}}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.get_verbose": {"tf": 1}, "coercer.network.utils.get_ip_address_of_interface": {"tf": 1}, "coercer.network.utils.get_ip_address_to_target_remote_host": {"tf": 1}, "coercer.network.utils.get_ip_addr_to_listen_on": {"tf": 1}, "coercer.network.utils.get_next_http_listener_port": {"tf": 1}}, "df": 5, "s": {"docs": {"coercer.network.DCERPCSession.DCERPCSession.get_verbose": {"tf": 1}}, "df": 1}}}}, "y": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {"coercer.network.DCERPCSessionError.DCERPCSessionError.__init__": {"tf": 1}}, "df": 1}}}}}}, "pipeline": ["trimmer"], "_isPrebuiltIndex": true};

    // mirrored in build-search-index.js (part 1)
    // Also split on html tags. this is a cheap heuristic, but good enough.
    elasticlunr.tokenizer.setSeperator(/[\s\-.;&_'"=,()]+|<[^>]*>/);

    let searchIndex;
    if (docs._isPrebuiltIndex) {
        console.info("using precompiled search index");
        searchIndex = elasticlunr.Index.load(docs);
    } else {
        console.time("building search index");
        // mirrored in build-search-index.js (part 2)
        searchIndex = elasticlunr(function () {
            this.pipeline.remove(elasticlunr.stemmer);
            this.pipeline.remove(elasticlunr.stopWordFilter);
            this.addField("qualname");
            this.addField("fullname");
            this.addField("annotation");
            this.addField("default_value");
            this.addField("signature");
            this.addField("bases");
            this.addField("doc");
            this.setRef("fullname");
        });
        for (let doc of docs) {
            searchIndex.addDoc(doc);
        }
        console.timeEnd("building search index");
    }

    return (term) => searchIndex.search(term, {
        fields: {
            qualname: {boost: 4},
            fullname: {boost: 2},
            annotation: {boost: 2},
            default_value: {boost: 2},
            signature: {boost: 2},
            bases: {boost: 2},
            doc: {boost: 1},
        },
        expand: true
    });
})();