/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.schema;

import cz.startnet.utils.pgdiff.schema.PgExtension;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PgDatabase {
    private final List<PgSchema> schemas = new ArrayList<PgSchema>(1);
    private final List<String> ignoredStatements = new ArrayList<String>();
    private PgSchema defaultSchema;
    private String comment;
    private final List<PgExtension> extensions = new ArrayList<PgExtension>();

    public PgDatabase() {
        this.schemas.add(new PgSchema("public"));
        this.defaultSchema = this.schemas.get(0);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setDefaultSchema(String string) {
        this.defaultSchema = this.getSchema(string);
    }

    public PgSchema getDefaultSchema() {
        return this.defaultSchema;
    }

    public List<String> getIgnoredStatements() {
        return Collections.unmodifiableList(this.ignoredStatements);
    }

    public void addIgnoredStatement(String string) {
        this.ignoredStatements.add(string);
    }

    public PgSchema getSchema(String string) {
        if (string == null) {
            return this.getDefaultSchema();
        }
        for (PgSchema pgSchema : this.schemas) {
            if (!pgSchema.getName().equals(string)) continue;
            return pgSchema;
        }
        return null;
    }

    public List<PgSchema> getSchemas() {
        return Collections.unmodifiableList(this.schemas);
    }

    public void addSchema(PgSchema pgSchema) {
        if (this.schemas.isEmpty()) {
            this.schemas.add(pgSchema);
        } else if (!this.schemas.stream().filter(pgSchema2 -> pgSchema2.getName().equals(pgSchema.getName())).findFirst().isPresent()) {
            this.schemas.add(pgSchema);
        }
    }

    public List<PgExtension> getExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }

    public void addExtension(PgExtension pgExtension) {
        this.extensions.add(pgExtension);
    }

    public PgExtension getExtension(String string) {
        for (PgExtension pgExtension : this.extensions) {
            if (!pgExtension.getName().equals(string)) continue;
            return pgExtension;
        }
        return null;
    }
}

