# Print the Adventure Game Studio name for the current game
# This function should not fail if no AGS name is set for the current game,
# so it can be used to automatically detect games using the "ags" type variant.
# USAGE: ags_name
ags_name() {
	context_value 'AGS_NAME'
}

# Adventure Game Studio - Print the list of files to include from the archive for a given identifier
# USAGE: ags_content_files_default $content_id
ags_content_files_default() {
	local content_id
	content_id="$1"

	local ags_name
	ags_name=$(ags_name)

	local content_files
	case "$content_id" in
		('GAME_MAIN')
			content_files='
			acsetup.cfg
			*.0??
			*.ags
			*.exe
			*.vox
			*.tra'
	esac

	printf '%s' "${content_files:-}"
}

