// Copyright 2023 Google LLC
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.

// Arguments are:
// XNN_DWCONV_UNIPASS(arch, name, first_pass_tile, middle_pass_tile, last_pass_tile, channel_tile, channel_subtile, channel_round, datatype, weights_type, buffer_type,params_type, init_fn)

#if XNN_ARCH_ARM || XNN_ARCH_ARM64
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l8c8s8r__neon_mla8_ld64, 5, 5, 5, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neon_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l8c8s8r__neon_mul8_ld64, 5, 5, 5, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neon_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l8c8s8r__neon_mul16, 5, 5, 5, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neon_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon_v8, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l8c8s8r__neonv8_mla8_ld64, 5, 5, 5, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neonv8_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon_v8, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l8c8s8r__neonv8_mul8_ld64, 5, 5, 5, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neonv8_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon_v8, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l8c8s8r__neonv8_mul16, 5, 5, 5, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neonv8_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l16c8s8r__neon_mla8_ld64, 5, 5, 5, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neon_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l16c8s8r__neon_mla8_ld128, 5, 5, 5, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neon_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l16c8s8r__neon_mul8_ld64, 5, 5, 5, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neon_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l16c8s8r__neon_mul8_ld128, 5, 5, 5, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neon_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l16c8s8r__neon_mul16, 5, 5, 5, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neon_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon_v8, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l16c8s8r__neonv8_mla8_ld64, 5, 5, 5, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neonv8_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon_v8, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l16c8s8r__neonv8_mla8_ld128, 5, 5, 5, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neonv8_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon_v8, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l16c8s8r__neonv8_mul8_ld64, 5, 5, 5, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neonv8_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon_v8, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l16c8s8r__neonv8_mul8_ld128, 5, 5, 5, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neonv8_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon_v8, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l16c8s8r__neonv8_mul16, 5, 5, 5, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neonv8_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l32c8s8r__neon_mul16, 5, 5, 5, 32, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neon_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon_v8, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l32c8s8r__neonv8_mul16, 5, 5, 5, 32, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neonv8_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l8c8s8r__neon_mla8_ld64, 6, 6, 7, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neon_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l8c8s8r__neon_mul8_ld64, 6, 6, 7, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neon_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l8c8s8r__neon_mul16, 6, 6, 7, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neon_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon_v8, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l8c8s8r__neonv8_mla8_ld64, 6, 6, 7, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neonv8_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon_v8, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l8c8s8r__neonv8_mul8_ld64, 6, 6, 7, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neonv8_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon_v8, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l8c8s8r__neonv8_mul16, 6, 6, 7, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neonv8_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l16c8s8r__neon_mla8_ld64, 6, 6, 7, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neon_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l16c8s8r__neon_mla8_ld128, 6, 6, 7, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neon_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l16c8s8r__neon_mul8_ld64, 6, 6, 7, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neon_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l16c8s8r__neon_mul8_ld128, 6, 6, 7, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neon_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l16c8s8r__neon_mul16, 6, 6, 7, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neon_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon_v8, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l16c8s8r__neonv8_mla8_ld64, 6, 6, 7, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neonv8_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon_v8, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l16c8s8r__neonv8_mla8_ld128, 6, 6, 7, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neonv8_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon_v8, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l16c8s8r__neonv8_mul8_ld64, 6, 6, 7, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neonv8_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon_v8, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l16c8s8r__neonv8_mul8_ld128, 6, 6, 7, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neonv8_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon_v8, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l16c8s8r__neonv8_mul16, 6, 6, 7, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neonv8_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l32c8s8r__neon_mul16, 6, 6, 7, 32, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neon_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon_v8, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l32c8s8r__neonv8_mul16, 6, 6, 7, 32, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neonv8_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l8c8s8r__neon_mla8_ld64, 8, 8, 9, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neon_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l8c8s8r__neon_mul8_ld64, 8, 8, 9, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neon_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l8c8s8r__neon_mul16, 8, 8, 9, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neon_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon_v8, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l8c8s8r__neonv8_mla8_ld64, 8, 8, 9, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neonv8_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon_v8, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l8c8s8r__neonv8_mul8_ld64, 8, 8, 9, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neonv8_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon_v8, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l8c8s8r__neonv8_mul16, 8, 8, 9, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neonv8_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l16c8s8r__neon_mla8_ld64, 8, 8, 9, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neon_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l16c8s8r__neon_mla8_ld128, 8, 8, 9, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neon_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l16c8s8r__neon_mul8_ld64, 8, 8, 9, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neon_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l16c8s8r__neon_mul8_ld128, 8, 8, 9, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neon_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l16c8s8r__neon_mul16, 8, 8, 9, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neon_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon_v8, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l16c8s8r__neonv8_mla8_ld64, 8, 8, 9, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neonv8_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon_v8, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l16c8s8r__neonv8_mla8_ld128, 8, 8, 9, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neonv8_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon_v8, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l16c8s8r__neonv8_mul8_ld64, 8, 8, 9, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neonv8_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon_v8, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l16c8s8r__neonv8_mul8_ld128, 8, 8, 9, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neonv8_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon_v8, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l16c8s8r__neonv8_mul16, 8, 8, 9, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neonv8_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l32c8s8r__neon_mul16, 8, 8, 9, 32, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neon_params)
XNN_DWCONV_MULTIPASS(xnn_arch_arm_neon_v8, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l32c8s8r__neonv8_mul16, 8, 8, 9, 32, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_neonv8_params)
#endif  // XNN_ARCH_ARM || XNN_ARCH_ARM64

#if XNN_ARCH_X86 || XNN_ARCH_X86_64
XNN_DWCONV_MULTIPASS(xnn_arch_x86_sse4_1, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l8c4s4r__sse41_mul32, 5, 5, 5, 8, 4, 4, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l8c8s8r__sse2_mul16, 5, 5, 5, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l8c8s8r__sse2_mul16_add16, 5, 5, 5, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_sse4_1, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l8c8s8r__sse41_mul16, 5, 5, 5, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_sse4_1, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l8c8s8r__sse41_mul16_add16, 5, 5, 5, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_sse4_1, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l16c4s4r__sse41_mul32, 5, 5, 5, 16, 4, 4, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l16c8s8r__sse2_mul16, 5, 5, 5, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l16c8s8r__sse2_mul16_add16, 5, 5, 5, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_sse4_1, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l16c8s8r__sse41_mul16, 5, 5, 5, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_sse4_1, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l16c8s8r__sse41_mul16_add16, 5, 5, 5, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_sse4_1, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l8c4s4r__sse41_mul32, 6, 6, 7, 8, 4, 4, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l8c8s8r__sse2_mul16, 6, 6, 7, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l8c8s8r__sse2_mul16_add16, 6, 6, 7, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_sse4_1, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l8c8s8r__sse41_mul16, 6, 6, 7, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_sse4_1, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l8c8s8r__sse41_mul16_add16, 6, 6, 7, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_sse4_1, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l16c4s4r__sse41_mul32, 6, 6, 7, 16, 4, 4, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l16c8s8r__sse2_mul16, 6, 6, 7, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l16c8s8r__sse2_mul16_add16, 6, 6, 7, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_sse4_1, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l16c8s8r__sse41_mul16, 6, 6, 7, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_sse4_1, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l16c8s8r__sse41_mul16_add16, 6, 6, 7, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_sse4_1, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l8c4s4r__sse41_mul32, 8, 8, 9, 8, 4, 4, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l8c8s8r__sse2_mul16, 8, 8, 9, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l8c8s8r__sse2_mul16_add16, 8, 8, 9, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_sse4_1, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l8c8s8r__sse41_mul16, 8, 8, 9, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_sse4_1, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l8c8s8r__sse41_mul16_add16, 8, 8, 9, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_sse4_1, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l16c4s4r__sse41_mul32, 8, 8, 9, 16, 4, 4, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l16c8s8r__sse2_mul16, 8, 8, 9, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l16c8s8r__sse2_mul16_add16, 8, 8, 9, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_sse4_1, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l16c8s8r__sse41_mul16, 8, 8, 9, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_sse4_1, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l16c8s8r__sse41_mul16_add16, 8, 8, 9, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l8c4s4r__avx_mul32, 5, 5, 5, 8, 4, 4, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx2, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l8c8s8r__avx2_mul32, 5, 5, 5, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l16c4s4r__avx_mul32, 5, 5, 5, 16, 4, 4, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx2, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l16c8s8r__avx2_mul32, 5, 5, 5, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx2, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l16c16s16r__avx2_mul16_add16_vpunpck, 5, 5, 5, 16, 16, 16, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx2, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l16c16s16r__avx2_mul16_vpmovsx, 5, 5, 5, 16, 16, 16, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx2, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l16c16s16r__avx2_mul16_vpunpck, 5, 5, 5, 16, 16, 16, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx2, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l32c8s8r__avx2_mul32, 5, 5, 5, 32, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx2, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l32c16s16r__avx2_mul16_add16_vpunpck, 5, 5, 5, 32, 16, 16, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx2, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l32c16s16r__avx2_mul16_vpmovsx, 5, 5, 5, 32, 16, 16, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx2, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l32c16s16r__avx2_mul16_vpunpck, 5, 5, 5, 32, 16, 16, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l8c4s4r__avx_mul32, 6, 6, 7, 8, 4, 4, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx2, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l8c8s8r__avx2_mul32, 6, 6, 7, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l16c4s4r__avx_mul32, 6, 6, 7, 16, 4, 4, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx2, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l16c8s8r__avx2_mul32, 6, 6, 7, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx2, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l16c16s16r__avx2_mul16_add16_vpunpck, 6, 6, 7, 16, 16, 16, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx2, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l16c16s16r__avx2_mul16_vpmovsx, 6, 6, 7, 16, 16, 16, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx2, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l16c16s16r__avx2_mul16_vpunpck, 6, 6, 7, 16, 16, 16, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx2, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l32c8s8r__avx2_mul32, 6, 6, 7, 32, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx2, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l32c16s16r__avx2_mul16_add16_vpunpck, 6, 6, 7, 32, 16, 16, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx2, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l32c16s16r__avx2_mul16_vpmovsx, 6, 6, 7, 32, 16, 16, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx2, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l32c16s16r__avx2_mul16_vpunpck, 6, 6, 7, 32, 16, 16, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l8c4s4r__avx_mul32, 8, 8, 9, 8, 4, 4, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx2, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l8c8s8r__avx2_mul32, 8, 8, 9, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l16c4s4r__avx_mul32, 8, 8, 9, 16, 4, 4, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx2, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l16c8s8r__avx2_mul32, 8, 8, 9, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx2, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l16c16s16r__avx2_mul16_add16_vpunpck, 8, 8, 9, 16, 16, 16, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx2, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l16c16s16r__avx2_mul16_vpmovsx, 8, 8, 9, 16, 16, 16, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx2, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l16c16s16r__avx2_mul16_vpunpck, 8, 8, 9, 16, 16, 16, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx2, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l32c8s8r__avx2_mul32, 8, 8, 9, 32, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx2, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l32c16s16r__avx2_mul16_add16_vpunpck, 8, 8, 9, 32, 16, 16, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx2, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l32c16s16r__avx2_mul16_vpmovsx, 8, 8, 9, 32, 16, 16, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx2, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l32c16s16r__avx2_mul16_vpunpck, 8, 8, 9, 32, 16, 16, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
#endif  // XNN_ARCH_X86 || XNN_ARCH_X86_64

#if XNN_ENABLE_AVX512SKX && (XNN_ARCH_X86 || XNN_ARCH_X86_64)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx512skx, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l16c16s1r__avx512skx_mul32, 5, 5, 5, 16, 16, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx512skx, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l32c16s1r__avx512skx_mul32, 5, 5, 5, 32, 16, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx512skx, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l16c16s1r__avx512skx_mul32, 6, 6, 7, 16, 16, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx512skx, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l32c16s1r__avx512skx_mul32, 6, 6, 7, 32, 16, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx512skx, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l16c16s1r__avx512skx_mul32, 8, 8, 9, 16, 16, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(xnn_arch_x86_avx512skx, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l32c16s1r__avx512skx_mul32, 8, 8, 9, 32, 16, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
#endif  // XNN_ENABLE_AVX512SKX && (XNN_ARCH_X86 || XNN_ARCH_X86_64)

#if XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l8c8s8r__wasmsimd_mul16, 5, 5, 5, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l8c8s8r__wasmsimd_mul16_add16, 5, 5, 5, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l16c8s8r__wasmsimd_mul16, 5, 5, 5, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l16c8s8r__wasmsimd_mul16_add16, 5, 5, 5, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l8c8s8r__wasmsimd_mul16, 6, 6, 7, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l8c8s8r__wasmsimd_mul16_add16, 6, 6, 7, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l16c8s8r__wasmsimd_mul16, 6, 6, 7, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l16c8s8r__wasmsimd_mul16_add16, 6, 6, 7, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l8c8s8r__wasmsimd_mul16, 8, 8, 9, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l8c8s8r__wasmsimd_mul16_add16, 8, 8, 9, 8, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l16c8s8r__wasmsimd_mul16, 8, 8, 9, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l16c8s8r__wasmsimd_mul16_add16, 8, 8, 9, 16, 8, 8, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
#endif  // XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD

#if XNN_ARCH_WASM || XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l1c1s1r__wasm_fmagic, 5, 5, 5, 1, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l2c1s1r__wasm_fmagic, 5, 5, 5, 2, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l4c1s1r__wasm_fmagic, 5, 5, 5, 4, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l1c1s1r__wasm_fmagic, 6, 6, 7, 1, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l2c1s1r__wasm_fmagic, 6, 6, 7, 2, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l4c1s1r__wasm_fmagic, 6, 6, 7, 4, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l1c1s1r__wasm_fmagic, 8, 8, 9, 1, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l2c1s1r__wasm_fmagic, 8, 8, 9, 2, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l4c1s1r__wasm_fmagic, 8, 8, 9, 4, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
#endif  // XNN_ARCH_WASM || XNN_ARCH_WASMSIMD || XNN_ARCH_WASMRELAXEDSIMD

XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l1c1s1r__scalar_fmagic, 5, 5, 5, 1, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l1c1s1r__scalar_imagic, 5, 5, 5, 1, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l1c1s1r__scalar_lrintf, 5, 5, 5, 1, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l2c1s1r__scalar_fmagic, 5, 5, 5, 2, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l2c1s1r__scalar_imagic, 5, 5, 5, 2, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l2c1s1r__scalar_lrintf, 5, 5, 5, 2, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l4c1s1r__scalar_fmagic, 5, 5, 5, 4, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l4c1s1r__scalar_imagic, 5, 5, 5, 4, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_5f5m5l4c1s1r__scalar_lrintf, 5, 5, 5, 4, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l1c1s1r__scalar_fmagic, 6, 6, 7, 1, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l1c1s1r__scalar_imagic, 6, 6, 7, 1, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l1c1s1r__scalar_lrintf, 6, 6, 7, 1, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l2c1s1r__scalar_fmagic, 6, 6, 7, 2, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l2c1s1r__scalar_imagic, 6, 6, 7, 2, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l2c1s1r__scalar_lrintf, 6, 6, 7, 2, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l4c1s1r__scalar_fmagic, 6, 6, 7, 4, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l4c1s1r__scalar_imagic, 6, 6, 7, 4, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_6f6m7l4c1s1r__scalar_lrintf, 6, 6, 7, 4, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l1c1s1r__scalar_fmagic, 8, 8, 9, 1, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l1c1s1r__scalar_imagic, 8, 8, 9, 1, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l1c1s1r__scalar_lrintf, 8, 8, 9, 1, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l2c1s1r__scalar_fmagic, 8, 8, 9, 2, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l2c1s1r__scalar_imagic, 8, 8, 9, 2, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l2c1s1r__scalar_lrintf, 8, 8, 9, 2, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l4c1s1r__scalar_fmagic, 8, 8, 9, 4, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l4c1s1r__scalar_imagic, 8, 8, 9, 4, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)
XNN_DWCONV_MULTIPASS(0, xnn_qs8_qc8w_dwconv_minmax_fp32_ukernel_8f8m9l4c1s1r__scalar_lrintf, 8, 8, 9, 4, 1, 1, int8_t, void, int32_t, union xnn_qs8_qc8w_conv_minmax_params, xnn_init_qs8_qc8w_conv_minmax_fp32_scalar_params)

