/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.consumer;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.consumer.AbstractNonceVerifier;
import org.openid4java.consumer.NonceVerifier;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

public class JdbcNonceVerifier
extends JdbcDaoSupport
implements NonceVerifier {
    private static Log _log = LogFactory.getLog(JdbcNonceVerifier.class);
    private NonceVerifier _verifier;
    private String _tableName;
    private String _deleteSQL;
    private String _insertSQL;

    public JdbcNonceVerifier(int maxAge) {
        this._verifier = new GenericNonceVerifier(maxAge);
    }

    public JdbcNonceVerifier(int maxAge, String tableName) {
        this(maxAge);
        this.setTableName(tableName);
    }

    public int getMaxAge() {
        return this._verifier.getMaxAge();
    }

    public void setMaxAge(int ageSeconds) {
        this._verifier.setMaxAge(ageSeconds);
    }

    public int seen(String opUrl, String nonce) {
        return this._verifier.seen(opUrl, nonce);
    }

    public String getTableName() {
        return this._tableName;
    }

    public void setTableName(String tableName) {
        this._tableName = tableName;
        this._deleteSQL = "DELETE FROM " + tableName + " WHERE date<?";
        this._insertSQL = "INSERT INTO " + tableName + " (opurl, nonce, date) VALUES (?,?,?)";
    }

    private class GenericNonceVerifier
    extends AbstractNonceVerifier {
        public GenericNonceVerifier(int maxAge) {
            super(maxAge);
        }

        protected int seen(Date now, String opUrl, String nonce) {
            this.cleanupAged();
            JdbcTemplate jdbcTemplate = JdbcNonceVerifier.this.getJdbcTemplate();
            try {
                jdbcTemplate.update(JdbcNonceVerifier.this._insertSQL, new Object[]{opUrl, nonce, now});
                return 0;
            }
            catch (DataIntegrityViolationException e) {
                _log.warn((Object)"Nonce already seen. Possible replay attack!");
            }
            catch (Exception e) {
                _log.error((Object)"Problem executing database method", (Throwable)e);
            }
            return 1;
        }

        private void cleanupAged() {
            try {
                Date boundary = new Date(System.currentTimeMillis() - 1000L * (long)this._maxAgeSeconds);
                JdbcTemplate jdbcTemplate = JdbcNonceVerifier.this.getJdbcTemplate();
                int cnt = jdbcTemplate.update(JdbcNonceVerifier.this._deleteSQL, new Object[]{boundary});
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Client nonce cleanup removed " + cnt + " entries"));
                }
            }
            catch (Exception e) {
                _log.error((Object)("Error cleaning up client nonces from table: " + JdbcNonceVerifier.this._tableName), (Throwable)e);
            }
        }
    }
}

