/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.security;

import flex.messaging.FlexComponent;
import flex.messaging.FlexContext;
import flex.messaging.config.ConfigMap;
import flex.messaging.config.ConfigurationException;
import flex.messaging.config.SecurityConstraint;
import flex.messaging.security.AppServerLoginCommand;
import flex.messaging.security.LoginCommand;
import flex.messaging.security.LoginCommandExt;
import flex.messaging.security.SecurityException;
import java.security.Principal;
import java.util.List;

public class LoginManager
implements FlexComponent {
    public static final String LOG_CATEGORY = "Security";
    private static final int INVALID_LOGIN = 10050;
    private static final int LOGIN_REQ = 10051;
    private static final int NO_LOGIN_COMMAND = 10053;
    private static final int CANNOT_REAUTH = 10054;
    private static final int ACCESS_DENIED = 10055;
    private static final int LOGIN_REQ_FOR_AUTH = 10056;
    private static final int RTMP_NO_BASIC_SECURITY = 10057;
    private static final int PER_CLIENT_ANT_APPSERVER = 10065;
    private LoginCommand loginCommand;
    private boolean perClientAuthentication = false;
    private boolean started;

    public void initialize(String id, ConfigMap configMap) {
    }

    protected void validate() {
        if (this.perClientAuthentication && this.loginCommand instanceof AppServerLoginCommand) {
            ConfigurationException configException = new ConfigurationException();
            configException.setMessage(10065);
            throw configException;
        }
    }

    public void start() {
        if (!this.started) {
            this.validate();
            this.started = true;
        }
    }

    public void stop() {
        if (this.started) {
            this.started = false;
        }
    }

    public boolean isPerClientAuthentication() {
        return this.perClientAuthentication;
    }

    public void setPerClientAuthentication(boolean perClientAuthentication) {
        this.perClientAuthentication = perClientAuthentication;
    }

    public boolean isStarted() {
        return this.started;
    }

    public LoginCommand getLoginCommand() {
        return this.loginCommand;
    }

    public void setLoginCommand(LoginCommand loginCommand) {
        this.loginCommand = loginCommand;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void login(String username, Object credentials) {
        if (this.getCurrentPrincipal() == null) {
            if (this.loginCommand == null) {
                SecurityException se = new SecurityException();
                se.setMessage(10053);
                se.setCode("Server.Authentication");
                throw se;
            }
            if (username != null && credentials != null) {
                Principal authenticated = this.loginCommand.doAuthentication(username, credentials);
                if (authenticated == null) {
                    SecurityException se = new SecurityException();
                    se.setMessage(10050);
                    se.setCode("Client.Authentication");
                    throw se;
                }
                this.setCurrentPrincipal(authenticated);
                return;
            }
            SecurityException se = new SecurityException();
            se.setMessage(10051);
            se.setCode("Client.Authentication");
            throw se;
        }
        String comparisonUsername = this.loginCommand instanceof LoginCommandExt ? ((LoginCommandExt)((Object)this.loginCommand)).getPrincipalNameFromCredentials(username, credentials) : username;
        if (comparisonUsername == null) return;
        if (comparisonUsername.equals(this.getCurrentPrincipal().getName())) return;
        SecurityException se = new SecurityException();
        se.setMessage(10054);
        se.setCode("Client.Authentication");
        throw se;
    }

    public void logout() {
        if (this.loginCommand != null) {
            this.loginCommand.logout(this.getCurrentPrincipal());
            if (FlexContext.isPerClientAuthentication()) {
                FlexContext.setUserPrincipal(null);
            } else {
                FlexContext.getFlexSession().invalidate();
            }
        } else {
            FlexContext.getFlexSession().invalidate();
            SecurityException se = new SecurityException();
            se.setMessage(10053);
            se.setCode("Server.Authorization");
            throw se;
        }
    }

    public void checkConstraint(SecurityConstraint constraint) {
        if (constraint != null) {
            Principal currentPrincipal = this.getCurrentPrincipal();
            if (currentPrincipal != null) {
                boolean authorized;
                List roles = constraint.getRoles();
                boolean bl = authorized = roles == null || this.checkRoles(currentPrincipal, roles);
                if (!authorized) {
                    SecurityException se = new SecurityException();
                    se.setMessage(10055);
                    se.setCode("Client.Authorization");
                    throw se;
                }
            } else {
                if (!this.isCustomAuth(constraint)) {
                    if (FlexContext.getHttpResponse() == null) {
                        SecurityException se = new SecurityException();
                        se.setMessage(10057);
                        se.setCode("Client.Authorization");
                        throw se;
                    }
                    FlexContext.getHttpResponse().setStatus(401);
                    FlexContext.getHttpResponse().addHeader("WWW-Authenticate", "Basic realm=\"default\"");
                }
                SecurityException se = new SecurityException();
                se.setMessage(10056);
                se.setCode("Client.Authentication");
                throw se;
            }
        }
    }

    public boolean checkRoles(Principal principal, List roles) {
        if (this.loginCommand == null) {
            return false;
        }
        return this.loginCommand.doAuthorization(principal, roles);
    }

    private Principal getCurrentPrincipal() {
        return FlexContext.getUserPrincipal();
    }

    private void setCurrentPrincipal(Principal p) {
        FlexContext.setUserPrincipal(p);
    }

    private boolean isCustomAuth(SecurityConstraint constraint) {
        return "Custom".equals(constraint.getMethod());
    }
}

