//: version "2.1"
//: property encoding = "utf-8"
//: property locale = "de"
//: property prefix = "_GG"
//: property title = "Willkommen zu TkGate"
//: property discardChanges = 1
//: property timingViolationMode = 2
//: property initTime = "0 ns"

`timescale 1ns/1ns


//: /symbolBegin: 155045944
//: /iconBegin normal 2990 3 3
//: /data "#define bitmap_width 57"
//: /data "#define bitmap_height 58"
//: /data "static unsigned char bitmap_bits[] = {"
//: /data "   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x01, 0x00, 0x00, 0x00,"
//: /data "   0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,"
//: /data "   0x01, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x80, 0x02,"
//: /data "   0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x80, 0x92, 0x02, 0x00, 0x00, 0x01,"
//: /data "   0x01, 0x00, 0xc0, 0x97, 0x05, 0x00, 0x00, 0x01, 0x01, 0x00, 0x40, 0x94,"
//: /data "   0x04, 0x00, 0x00, 0x01, 0x01, 0x00, 0x40, 0x94, 0x04, 0x00, 0x00, 0x01,"
//: /data "   0x01, 0x00, 0x40, 0x94, 0x04, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00,"
//: /data "   0x00, 0x00, 0x00, 0x01, 0x71, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,"
//: /data "   0x09, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x09, 0x14, 0xf8, 0xff,"
//: /data "   0xff, 0xff, 0x1f, 0x01, 0x71, 0x3e, 0x08, 0x00, 0x00, 0x00, 0x10, 0x01,"
//: /data "   0x81, 0x22, 0x08, 0x00, 0x00, 0x00, 0x10, 0x01, 0x81, 0x22, 0xf8, 0xff,"
//: /data "   0xff, 0xff, 0x1f, 0x01, 0x71, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,"
//: /data "   0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00,"
//: /data "   0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,"
//: /data "   0x01, 0x00, 0xf8, 0xff, 0xff, 0xff, 0x1f, 0x01, 0x01, 0x00, 0x08, 0x00,"
//: /data "   0x00, 0x00, 0x10, 0x01, 0x01, 0x00, 0x08, 0x00, 0x00, 0x00, 0x10, 0x01,"
//: /data "   0x01, 0x00, 0xf8, 0xff, 0xff, 0xff, 0x1f, 0x01, 0x71, 0x1e, 0x00, 0x00,"
//: /data "   0x00, 0x00, 0x00, 0x01, 0x09, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,"
//: /data "   0x09, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x71, 0x1e, 0x00, 0x00,"
//: /data "   0x00, 0x00, 0x00, 0x01, 0x81, 0x22, 0xf8, 0xff, 0xff, 0xff, 0x1f, 0x01,"
//: /data "   0x81, 0x22, 0x08, 0x00, 0x00, 0x00, 0x10, 0x01, 0x71, 0x1e, 0x08, 0x00,"
//: /data "   0x00, 0x00, 0x10, 0x01, 0x01, 0x00, 0xf8, 0xff, 0xff, 0xff, 0x1f, 0x01,"
//: /data "   0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00,"
//: /data "   0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x01,"
//: /data "   0x01, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00,"
//: /data "   0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,"
//: /data "   0x01, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00,"
//: /data "   0x0c, 0x00, 0x00, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,"
//: /data "   0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x11, 0x00, 0x00, 0x00,"
//: /data "   0x0c, 0x00, 0x00, 0x01, 0x09, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x01,"
//: /data "   0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x00, 0x00, 0x00,"
//: /data "   0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,"
//: /data "   0x01, 0x02, 0x00, 0x01, 0x1e, 0x00, 0x04, 0x01, 0x01, 0x05, 0x00, 0x01,"
//: /data "   0x22, 0x00, 0x04, 0x01, 0x01, 0xc5, 0xa4, 0x03, 0x22, 0x93, 0x0e, 0x01,"
//: /data "   0x81, 0x2f, 0x25, 0x01, 0x9e, 0x94, 0x04, 0x01, 0x81, 0x28, 0x25, 0x01,"
//: /data "   0xa2, 0x94, 0x04, 0x01, 0x81, 0x28, 0x25, 0x09, 0xa2, 0x94, 0x24, 0x01,"
//: /data "   0x81, 0xc8, 0x38, 0x06, 0x1e, 0xe3, 0x18, 0x01, 0x01, 0x00, 0x00, 0x00,"
//: /data "   0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,"
//: /data "   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01};"
//: /iconEnd
//: /iconBegin select 2990 3 3
//: /data "#define bitmap_width 57"
//: /data "#define bitmap_height 58"
//: /data "static unsigned char bitmap_bits[] = {"
//: /data "   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0xff, 0xff, 0xff, 0xff,"
//: /data "   0xff, 0xff, 0xff, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01,"
//: /data "   0x03, 0x00, 0x00, 0x11, 0x00, 0x00, 0x80, 0x01, 0x03, 0x00, 0x80, 0x02,"
//: /data "   0x00, 0x00, 0x80, 0x01, 0x03, 0x00, 0x80, 0x92, 0x02, 0x00, 0x80, 0x01,"
//: /data "   0x03, 0x00, 0xc0, 0x97, 0x05, 0x00, 0x80, 0x01, 0x03, 0x00, 0x40, 0x94,"
//: /data "   0x04, 0x00, 0x80, 0x01, 0x03, 0x00, 0x40, 0x94, 0x04, 0x00, 0x80, 0x01,"
//: /data "   0x03, 0x00, 0x40, 0x94, 0x04, 0x00, 0x80, 0x01, 0x03, 0x00, 0x00, 0x00,"
//: /data "   0x00, 0x00, 0x80, 0x01, 0x73, 0x08, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01,"
//: /data "   0x0b, 0x14, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x0b, 0x14, 0xf8, 0xff,"
//: /data "   0xff, 0xff, 0x9f, 0x01, 0x73, 0x3e, 0x08, 0x00, 0x00, 0x00, 0x90, 0x01,"
//: /data "   0x83, 0x22, 0x08, 0x00, 0x00, 0x00, 0x90, 0x01, 0x83, 0x22, 0xf8, 0xff,"
//: /data "   0xff, 0xff, 0x9f, 0x01, 0x73, 0x22, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01,"
//: /data "   0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x03, 0x00, 0x00, 0x00,"
//: /data "   0x00, 0x00, 0x80, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01,"
//: /data "   0x03, 0x00, 0xf8, 0xff, 0xff, 0xff, 0x9f, 0x01, 0x03, 0x00, 0x08, 0x00,"
//: /data "   0x00, 0x00, 0x90, 0x01, 0x03, 0x00, 0x08, 0x00, 0x00, 0x00, 0x90, 0x01,"
//: /data "   0x03, 0x00, 0xf8, 0xff, 0xff, 0xff, 0x9f, 0x01, 0x73, 0x1e, 0x00, 0x00,"
//: /data "   0x00, 0x00, 0x80, 0x01, 0x0b, 0x22, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01,"
//: /data "   0x0b, 0x22, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x73, 0x1e, 0x00, 0x00,"
//: /data "   0x00, 0x00, 0x80, 0x01, 0x83, 0x22, 0xf8, 0xff, 0xff, 0xff, 0x9f, 0x01,"
//: /data "   0x83, 0x22, 0x08, 0x00, 0x00, 0x00, 0x90, 0x01, 0x73, 0x1e, 0x08, 0x00,"
//: /data "   0x00, 0x00, 0x90, 0x01, 0x03, 0x00, 0xf8, 0xff, 0xff, 0xff, 0x9f, 0x01,"
//: /data "   0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x03, 0x00, 0x00, 0x00,"
//: /data "   0x00, 0x00, 0x80, 0x01, 0x03, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x80, 0x01,"
//: /data "   0x03, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x80, 0x01, 0x03, 0x00, 0x00, 0x00,"
//: /data "   0x00, 0x00, 0x80, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01,"
//: /data "   0x03, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x80, 0x01, 0x03, 0x00, 0x00, 0x00,"
//: /data "   0x0c, 0x00, 0x80, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01,"
//: /data "   0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x13, 0x00, 0x00, 0x00,"
//: /data "   0x0c, 0x00, 0x80, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x80, 0x01,"
//: /data "   0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x03, 0x00, 0x00, 0x00,"
//: /data "   0x00, 0x00, 0x80, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01,"
//: /data "   0x03, 0x02, 0x00, 0x01, 0x1e, 0x00, 0x84, 0x01, 0x03, 0x05, 0x00, 0x01,"
//: /data "   0x22, 0x00, 0x84, 0x01, 0x03, 0xc5, 0xa4, 0x03, 0x22, 0x93, 0x8e, 0x01,"
//: /data "   0x83, 0x2f, 0x25, 0x01, 0x9e, 0x94, 0x84, 0x01, 0x83, 0x28, 0x25, 0x01,"
//: /data "   0xa2, 0x94, 0x84, 0x01, 0x83, 0x28, 0x25, 0x09, 0xa2, 0x94, 0xa4, 0x01,"
//: /data "   0x83, 0xc8, 0x38, 0x06, 0x1e, 0xe3, 0x98, 0x01, 0x03, 0x00, 0x00, 0x00,"
//: /data "   0x00, 0x00, 0x80, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01,"
//: /data "   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01};"
//: /iconEnd
//: /port input SA[1:0] @(2, 16) /r:2
//: /port input AIN[7:0] @(31, 2) /r:1
//: /port output AOUT[7:0] @(19, 61) /r:3
//: /port input SB[1:0] @(2, 31) /r:2
//: /port output BOUT[7:0] @(46, 61) /r:3
//: /port input ck @(2, 46) /r:2
//: /symbolEnd
//: /netlistBegin main
module main;    //: root_module
reg b;    //: {0}(41:73,134)(107,134){1}
//: {2}(109,132)(109,84)(127,84){3}
//: {4}(109,136)(109,160)(139,160){5}
supply1 w7;    //: /sn:0 {0}(456,31)(456,18){1}
reg [7:0] w19;    //: /sn:0 {0}(#:703,66)(703,39){1}
reg w0;    //: /sn:0 {0}(357,39)(429,39){1}
//: {2}(433,39)(442,39){3}
//: {4}(431,37)(431,29){5}
//: {6}(431,41)(431,141)(481,141){7}
reg [1:0] sa;    //: /sn:0 {0}(#:136,463)(103,463)(103,428)(90,428){1}
reg w28;    //: /sn:0 {0}(69,268)(118,268){1}
reg w20;    //: /sn:0 {0}(661,137)(624,137){1}
reg w1;    //: /sn:0 {0}(357,87)(392,87){1}
//: {2}(396,87)(442,87){3}
//: {4}(394,85)(394,78){5}
//: {6}(394,89)(394,140)(409,140){7}
reg [1:0] sb;    //: /sn:0 {0}(#:136,478)(90,478){1}
reg [7:0] w25;    //: /sn:0 {0}(#:90,208)(131,208)(131,252){1}
supply0 w18;    //: /sn:0 {0}(741,206)(741,188)(723,188){1}
reg ci;    //: {0}(12:74,33)(177,33)(177,85){1}
//: {2}(179,87)(202,87){3}
//: {4}(177,89)(177,116){5}
supply0 w11;    //: /sn:0 {0}(759,102)(759,80)(743,80){1}
supply0 w2;    //: /sn:0 {0}(495,150)(495,166)(458,166){1}
//: {2}(454,166)(423,166)(423,149){3}
//: {4}(456,168)(456,177){5}
supply1 w10;    //: /sn:0 {0}(723,178)(737,178)(737,160){1}
reg a;    //: {0}(30:73,79)(115,79){1}
//: {2}(119,79)(127,79){3}
//: {4}(117,81)(117,155)(139,155){5}
supply0 [7:0] w9;    //: /sn:0 {0}(#:650,102)(650,92)(674,92)(674,121){1}
reg [1:0] w26;    //: /sn:0 {0}(#:90,331)(111,331)(111,368)(120,368){1}
wire [7:0] w14;    //: /sn:0 {0}(#:153,508)(153,545)(248,545)(248,237)(215,237){1}
//: {2}(213,235)(213,218){3}
//: {4}(211,237)(151,237)(151,252){5}
wire w4;    //: /sn:0 {0}(205,158)(160,158){1}
wire w3;    //: /sn:0 {0}(205,153)(175,153)(175,137){1}
wire w24;    //: /sn:0 {0}(695,80)(685,80){1}
wire co;    //: {0}(245,146)(-68:245,156)(226,156){1}
wire w8;    //: /sn:0 {0}(202,82)(174,82){1}
//: {2}(170,82)(148,82){3}
//: {4}(172,84)(172,116){5}
wire [7:0] w30;    //: /sn:0 {0}(#:180,508)(180,520)(228,520)(228,310)(215,310){1}
//: {2}(213,308)(213,295){3}
//: {4}(211,310)(188,310)(188,339){5}
wire [7:0] w22;    //: /sn:0 {0}(#:694,121)(694,107)(719,107)(719,95){1}
wire clk;    //: {0}(20:593,183)(647,183){1}
wire [7:0] w12;    //: /sn:0 {0}(#:165,449)(165,406){1}
wire [7:0] w27;    //: /sn:0 {0}(#:684,150)(684,173){1}
wire s;    //: {0}(246,97)(39:246,85)(223,85){1}
wire w13;    //: /sn:0 {0}(423,132)(423,113)(454,113){1}
//: {2}(458,113)(493,113){3}
//: {4}(495,111)(495,101){5}
//: {6}(495,115)(495,133){7}
//: {8}(456,111)(456,96){9}
wire w5;    //: /sn:0 {0}(456,48)(456,79){1}
wire w33;    //: /sn:0 {0}(136,493)(86,493)(86,529)(59,529){1}
wire [7:0] reg_out;    //: {0}(#:684,194)(50:684,230)(729,230){1}
//: {2}(-24:733,230)(783,230)(783,55)(735,55)(735,66){3}
//: {4}(731,232)(731,249){5}
wire [7:0] w29;    //: /sn:0 {0}(#:141,339)(141,281){1}
//: enddecls

  //: joint g61 (reg_out) @(731, 230) /w:[ 2 -1 1 4 ]
  //: VDD g8 (w7) @(467,18) /sn:0 /w:[ 1 ]
  _GGNMOS #(2, 1) g4 (.Z(w13), .S(w2), .G(w0));   //: @(489,141) /sn:0 /w:[ 7 0 7 ]
  //: LED g55 (w0) @(431,22) /sn:0 /w:[ 5 ] /type:0
  _GGOR2 #(6) g34 (.I0(w3), .I1(w4), .Z(co));   //: @(216,156) /sn:0 /w:[ 0 0 1 ] /eb:0
  //: joint g13 (w1) @(394, 87) /w:[ 2 4 1 6 ]
  //: SWITCH g3 (w0) @(340,39) /sn:0 /w:[ 0 ] /st:0 /dn:1
  _GGCLOCK_P200_0_50 g51 (.Z(w33));   //: @(46,529) /sn:0 /w:[ 1 ] /omega:200 /phi:0 /duty:50
  REGS g2 (.SA(sa), .AIN(w12), .AOUT(w14), .SB(sb), .BOUT(w30), .ck(w33));   //: @(165, 479) /symbol:155045944 /sn:0 /w:[ 0 0 0 0 0 0 ]
  //: LED g59 (w30) @(213,288) /sn:0 /w:[ 3 ] /type:2
  _GGCLOCK_P120_0_50 g1 (.Z(clk));   //: @(580,183) /sn:0 /w:[ 0 ] /omega:120 /phi:0 /duty:50
  //: joint g11 (w2) @(456, 166) /w:[ 1 -1 2 4 ]
  //: joint g16 (w30) @(213, 310) /w:[ 1 2 4 -1 ]
  _GGAND2 #(6) g28 (.I0(a), .I1(b), .Z(w4));   //: @(150,158) /sn:0 /w:[ 5 5 1 ] /eb:0
  //: GROUND g10 (w2) @(456,183) /sn:0 /w:[ 5 ]
  //: joint g32 (w8) @(172, 82) /w:[ 1 -1 2 4 ]
  //: SWITCH g27 (ci) @(57,33) /sn:0 /w:[ 0 ] /st:0 /dn:1
  //: joint g19 (w0) @(431, 39) /w:[ 2 4 1 6 ]
  _GGNMOS #(2, 1) g6 (.Z(w13), .S(w2), .G(w1));   //: @(417,140) /sn:0 /w:[ 0 3 7 ]
  //: DIP sa (sa) @(52,428) /sn:0 /R:1 /w:[ 1 ] /st:0 /dn:1
  //: joint g57 (w13) @(495, 113) /w:[ -1 4 3 6 ]
  //: joint g9 (w13) @(456, 113) /w:[ 2 8 1 -1 ]
  _GGPMOS #(2, 1) g7 (.Z(w5), .S(w7), .G(w0));   //: @(450,39) /sn:0 /w:[ 0 0 3 ]
  _GGMUX2x8 #(8, 8) g53 (.I0(w25), .I1(w14), .S(w28), .Z(w29));   //: @(141,268) /sn:0 /w:[ 1 5 1 1 ] /ss:0 /do:0
  _GGAND2 #(6) g31 (.I0(w8), .I1(ci), .Z(w3));   //: @(175,127) /sn:0 /R:3 /w:[ 5 5 1 ] /eb:0
  //: LED g15 (s) @(246,104) /sn:0 /R:2 /w:[ 0 ] /type:0
  //: DIP sb (sb) @(52,478) /sn:0 /R:1 /w:[ 1 ] /st:1 /dn:1
  //: LED g48 (reg_out) @(731,256) /sn:0 /R:2 /w:[ 5 ] /type:1
  //: GROUND g43 (w11) @(759,108) /sn:0 /w:[ 0 ]
  ALU alu (.B(w30), .A(w29), .F(w26), .Z(w12));   //: @(121, 340) /sz:(89, 65) /p:[ Ti0>5 Ti1>0 Li0>1 Bo0<1 ]
  //: DIP func (w26) @(52,331) /sn:0 /R:1 /w:[ 0 ] /st:0 /dn:1
  //: LED g62 (w14) @(213,211) /sn:0 /w:[ 3 ] /type:2
  //: joint g29 (a) @(117, 79) /w:[ 2 -1 1 4 ]
  //: SWITCH g25 (a) @(56,79) /sn:0 /w:[ 0 ] /st:0 /dn:1
  //: joint g17 (w14) @(213, 237) /w:[ 1 2 4 -1 ]
  //: DIP g42 (w19) @(703,29) /sn:0 /w:[ 1 ] /st:248 /dn:1
  //: DIP data_in (w25) @(52,208) /sn:0 /R:1 /w:[ 0 ] /st:11 /dn:1
  //: LED g56 (w13) @(495,94) /sn:0 /w:[ 5 ] /type:0
  _GGPMOS #(2, 1) g5 (.Z(w13), .S(w5), .G(w1));   //: @(450,87) /sn:0 /w:[ 9 1 3 ]
  //: LED g14 (co) @(245,139) /sn:0 /w:[ 0 ] /type:0
  _GGMUX2x8 #(8, 8) g47 (.I0(w9), .I1(w22), .S(w20), .Z(w27));   //: @(684,137) /sn:0 /w:[ 1 0 0 0 ] /ss:0 /do:0
  //: SWITCH g44 (w20) @(607,137) /sn:0 /w:[ 1 ] /st:1 /dn:1
  _GGXOR2 #(8) g24 (.I0(w8), .I1(ci), .Z(s));   //: @(213,85) /sn:0 /w:[ 0 3 1 ] /eb:0
  //: VDD g41 (w10) @(748,160) /sn:0 /w:[ 1 ]
  _GGXOR2 #(8) g23 (.I0(a), .I1(b), .Z(w8));   //: @(138,82) /sn:0 /w:[ 3 3 3 ] /eb:0
  //: GROUND g40 (w18) @(741,212) /sn:0 /w:[ 0 ]
  //: LED g54 (w1) @(394,71) /sn:0 /w:[ 5 ] /type:0
  //: GROUND g46 (w9) @(650,108) /sn:0 /w:[ 0 ]
  _GGADD8 #(68, 70, 62, 64) g45 (.A(w19), .B(reg_out), .S(w22), .CI(w11), .CO(w24));   //: @(719,82) /sn:0 /w:[ 0 3 1 1 0 ]
  //: SWITCH g26 (b) @(56,134) /sn:0 /w:[ 0 ] /st:1 /dn:1
  //: comment g0 @(279,271)
  //: /line:"<h1 color=green4>Willkommen bei TkGate <value-of name=\"tkgate-version\"></h1>"
  //: /line:""
  //: /line:"<value-of name=\"tkgate-copyright\">"
  //: /line:"TKGate kommt mit KEINERLEI GARANTIE; siehe dazu auch im Menu 'Hilfe...Lizenz'"
  //: /line:"die Lizenz- und Garantiedetails. Fehlerberichte bitte an <a href=\"mailto:starling13@gmail.com\"><value-of name=\"tkgate-mailcontact\"></a> senden"
  //: /line:"[freigegeben <value-of name=\"tkgate-release-date\">]"
  //: /line:""
  //: /line:"<h3>Zum Ausprobieren von TkGate auf einen der Links unten klicken!</h3>"
  //: /line:""
  //: /line:"<a href=\"file:///@T/index.v\">* Zum Tutorial</a>"
  //: /line:""
  //: /line:"<a href=\"file:///@E/index.v\">* Zu den Beispielschaltungen</a>"
  //: /line:""
  //: /line:"<a href=\"action:newFile\">* Editieren einer neuen Schaltung</a>"
  //: /line:""
  //: /line:"<a href=\"file:///@H/doc/en/index.html\">* Öffnen der Dokumentation </a>"
  //: /end
  //: SWITCH data_select (w28) @(52,268) /sn:0 /w:[ 0 ] /st:0 /dn:1
  //: SWITCH g12 (w1) @(340,87) /sn:0 /w:[ 0 ] /st:0 /dn:1
  //: joint g33 (ci) @(177, 87) /w:[ 2 1 -1 4 ]
  //: joint g30 (b) @(109, 134) /w:[ -1 2 1 4 ]
  _GGREG8 #(10, 10, 20) g49 (.Q(reg_out), .D(w27), .EN(w18), .CLR(w10), .CK(clk));   //: @(684,183) /sn:0 /w:[ 0 1 1 0 1 ]

endmodule
//: /netlistEnd

//: /netlistBegin ALU
module ALU(F, A, B, Z);
//: interface  /sz:(89, 65) /bd:[ Ti0>A[7:0](21/89) Ti1>B[7:0](67/89) Li0>F[1:0](39/65) Bo0<Z[7:0](44/89) ] /pd: 0 /pi: 0 /pe: 0 /pp: 1
input [7:0] B;    //: /sn:0 {0}(#:342,147)(342,184){1}
//: {2}(344,186)(367,186){3}
//: {4}(371,186)(425,186)(425,258){5}
//: {6}(369,188)(369,261){7}
//: {8}(342,188)(342,258){9}
input [1:0] F;    //: /sn:0 {0}(#:343,353)(214,353){1}
supply0 w0;    //: /sn:0 {0}(491,295)(491,272)(465,272){1}
input [7:0] A;    //: /sn:0 {0}(#:265,147)(265,215){1}
//: {2}(267,217)(345,217){3}
//: {4}(349,217)(372,217){5}
//: {6}(376,217)(457,217)(457,258){7}
//: {8}(374,219)(374,261){9}
//: {10}(347,219)(347,258){11}
//: {12}(265,219)(265,322)(348,322)(348,337){13}
output [7:0] Z;    //: /sn:0 {0}(#:366,404)(366,366){1}
wire [7:0] w14;    //: /sn:0 {0}(#:345,279)(345,310)(360,310)(360,337){1}
wire w4;    //: /sn:0 {0}(417,272)(407,272){1}
wire [7:0] w11;    //: /sn:0 {0}(#:372,282)(372,337){1}
wire [7:0] w10;    //: /sn:0 {0}(#:384,337)(384,307)(441,307)(441,287){1}
//: enddecls

  _GGADD8 #(68, 70, 62, 64) g4 (.A(B), .B(A), .S(w10), .CI(w0), .CO(w4));   //: @(441,274) /sn:0 /w:[ 5 7 1 1 0 ]
  //: joint g8 (A) @(347, 217) /w:[ 4 -1 3 10 ]
  //: IN g3 (F) @(212,353) /sn:0 /w:[ 1 ]
  //: GROUND g13 (w0) @(491,301) /sn:0 /w:[ 0 ]
  //: IN g2 (A) @(265,145) /sn:0 /R:3 /w:[ 0 ]
  //: IN g1 (B) @(342,145) /sn:0 /R:3 /w:[ 0 ]
  //: joint g11 (B) @(369, 186) /w:[ 4 -1 3 6 ]
  //: joint g10 (A) @(374, 217) /w:[ 6 -1 5 8 ]
  _GGAND2x8 #(6) g6 (.I0(B), .I1(A), .Z(w11));   //: @(372,272) /sn:0 /R:3 /w:[ 7 9 0 ] /eb:0
  _GGOR2x8 #(6) g7 (.I0(B), .I1(A), .Z(w14));   //: @(345,269) /sn:0 /R:3 /w:[ 9 11 0 ] /eb:0
  //: joint g9 (A) @(265, 217) /w:[ 2 1 -1 12 ]
  //: OUT g5 (Z) @(366,401) /sn:0 /R:3 /w:[ 0 ]
  _GGMUX4x8 #(12, 12) g0 (.I0(A), .I1(w14), .I2(w11), .I3(w10), .S(F), .Z(Z));   //: @(366,353) /sn:0 /w:[ 13 1 1 0 0 1 ] /ss:0 /do:0
  //: joint g12 (B) @(342, 186) /w:[ 2 1 -1 8 ]

endmodule
//: /netlistEnd

//: /netlistBegin REGS
module REGS(SB, SA, BOUT, AOUT, ck, AIN);
//: /symbol:155045944
//: interface  /sz:(40, 40) /bd:[ ] /pd: 0 /pi: 0 /pe: 0 /pp: 0
//: property pptype=0
supply1 w0;    //: /sn:0 {0}(368,281)(380,281)(380,262){1}
supply1 w21;    //: /sn:0 {0}(267,134)(188,134)(188,96){1}
input [1:0] SB;    //: /sn:0 {0}(#:514,430)(577,430){1}
supply1 w1;    //: /sn:0 {0}(513,281)(526,281)(526,262){1}
output [7:0] BOUT;    //: /sn:0 {0}(#:600,472)(600,443){1}
input [1:0] SA;    //: /sn:0 {0}(#:389,430)(99,430)(99,61){1}
//: {2}(101,59)(291,59)(291,121){3}
//: {4}(97,59)(54,59){5}
supply1 w2;    //: /sn:0 {0}(226,280)(238,280)(238,263){1}
input [7:0] AIN;    //: /sn:0 {0}(#:474,67)(474,208){1}
//: {2}(476,210)(633,210)(633,276){3}
//: {4}(472,210)(331,210){5}
//: {6}(327,210)(187,210)(187,275){7}
//: {8}(329,212)(329,276){9}
//: {10}(474,212)(474,276){11}
output [7:0] AOUT;    //: /sn:0 {0}(#:412,443)(412,472){1}
input ck;    //: /sn:0 {0}(58,315)(131,315){1}
//: {2}(135,315)(280,315){3}
//: {4}(284,315)(419,315){5}
//: {6}(423,315)(581,315)(581,286)(596,286){7}
//: {8}(421,313)(421,286)(437,286){9}
//: {10}(282,313)(282,286)(292,286){11}
//: {12}(133,313)(133,285)(150,285){13}
supply1 w5;    //: /sn:0 {0}(672,281)(687,281)(687,263){1}
wire w4;    //: /sn:0 {0}(297,150)(297,189)(562,189)(562,291)(513,291){1}
wire w3;    //: /sn:0 {0}(285,150)(285,204)(411,204)(411,291)(368,291){1}
wire [7:0] R2;    //: {0}(#:50:418,414)(418,355)(472,355){1}
//: {2}(476,355)(606,355)(606,414){3}
//: {4}(474,353)(474,297){5}
wire w20;    //: /sn:0 {0}(309,150)(309,171)(719,171)(719,291)(672,291){1}
wire [7:0] R1;    //: {0}(#:50:406,414)(406,345){1}
//: {2}(408,343)(594,343)(594,414){3}
//: {4}(404,343)(329,343)(329,297){5}
wire [7:0] R3;    //: {0}(#:50:430,414)(430,370)(616,370){1}
//: {2}(620,370)(633,370)(633,297){3}
//: {4}(618,372)(618,414){5}
wire w8;    //: /sn:0 {0}(226,290)(273,290)(273,150){1}
wire [7:0] R0;    //: {0}(#:50:582,414)(582,383)(396,383){1}
//: {2}(392,383)(187,383)(187,296){3}
//: {4}(394,385)(394,414){5}
//: enddecls

  //: IN g4 (SB) @(512,430) /sn:0 /w:[ 0 ]
  _GGREG8 #(10, 10, 20) g8 (.Q(R3), .D(AIN), .EN(w20), .CLR(w5), .CK(ck));   //: @(633,286) /sn:0 /w:[ 3 3 1 0 7 ]
  //: IN g3 (SA) @(52,59) /sn:0 /w:[ 5 ]
  _GGMUX4x8 #(12, 12) g13 (.I0(R0), .I1(R1), .I2(R2), .I3(R3), .S(SB), .Z(BOUT));   //: @(600,430) /sn:0 /w:[ 0 3 3 5 1 1 ] /ss:0 /do:0
  //: OUT g2 (BOUT) @(600,469) /sn:0 /R:3 /w:[ 0 ]
  //: OUT g1 (AOUT) @(412,469) /sn:0 /R:3 /w:[ 1 ]
  //: joint g11 (ck) @(282, 315) /w:[ 4 10 3 -1 ]
  //: joint g16 (R0) @(394, 383) /w:[ 1 -1 2 4 ]
  //: VDD g10 (w21) @(199,96) /sn:0 /w:[ 1 ]
  //: joint g19 (R1) @(406, 343) /w:[ 2 -1 4 1 ]
  //: joint g27 (ck) @(133, 315) /w:[ 2 12 1 -1 ]
  _GGREG8 #(10, 10, 20) g6 (.Q(R1), .D(AIN), .EN(w3), .CLR(w0), .CK(ck));   //: @(329,286) /sn:0 /w:[ 5 9 1 0 11 ]
  _GGREG8 #(10, 10, 20) g7 (.Q(R2), .D(AIN), .EN(w4), .CLR(w1), .CK(ck));   //: @(474,286) /sn:0 /w:[ 5 11 1 0 9 ]
  _GGNDECODER4 #(4, 4) g9 (.I(SA), .E(w21), .Z0(w8), .Z1(w3), .Z2(w4), .Z3(w20));   //: @(291,134) /sn:0 /w:[ 3 0 1 0 0 0 ] /ss:0 /do:0
  //: joint g20 (SA) @(99, 59) /w:[ 2 -1 4 1 ]
  _GGREG8 #(10, 10, 20) g15 (.Q(R0), .D(AIN), .EN(w8), .CLR(w2), .CK(ck));   //: @(187,285) /sn:0 /w:[ 3 7 0 0 13 ]
  //: joint g17 (R3) @(618, 370) /w:[ 2 -1 1 4 ]
  //: VDD g25 (w2) @(249,263) /sn:0 /w:[ 1 ]
  //: IN g5 (ck) @(56,315) /sn:0 /w:[ 0 ]
  _GGMUX4x8 #(12, 12) g14 (.I0(R0), .I1(R1), .I2(R2), .I3(R3), .S(SA), .Z(AOUT));   //: @(412,430) /sn:0 /w:[ 5 0 0 0 0 0 ] /ss:0 /do:0
  //: VDD g21 (w0) @(391,262) /sn:0 /w:[ 1 ]
  //: joint g24 (AIN) @(474, 210) /w:[ 2 1 4 10 ]
  //: VDD g23 (w5) @(698,263) /sn:0 /w:[ 1 ]
  //: IN g0 (AIN) @(474,65) /sn:0 /R:3 /w:[ 0 ]
  //: VDD g22 (w1) @(537,262) /sn:0 /w:[ 1 ]
  //: joint g26 (AIN) @(329, 210) /w:[ 5 -1 6 8 ]
  //: joint g12 (ck) @(421, 315) /w:[ 6 8 5 -1 ]
  //: joint g18 (R2) @(474, 355) /w:[ 2 4 1 -1 ]

endmodule
//: /netlistEnd

