/*
    TikZiT - a GUI diagram editor for TikZ
    Copyright (C) 2018 Aleks Kissinger

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
*/

/*!
 * Class representing an edge in a Graph.
 */

#ifndef EDGE_H
#define EDGE_H

#include "graphelementdata.h"
#include "node.h"
#include "style.h"

class Path;

#include <QObject>
#include <QPointF>

class Edge : public QObject
{
    Q_OBJECT
public:
    explicit Edge(Node *s, Node *t, QObject *parent = nullptr);
    Edge *copy(QMap<Node *, Node *> *nodeTable = nullptr);

    Node *source() const;
    Node *target() const;

    bool isSelfLoop();
    bool isStraight();

    GraphElementData *data() const;
    void setData(GraphElementData *data);

    QString sourceAnchor() const;
    void setSourceAnchor(const QString &sourceAnchor);

    QString targetAnchor() const;
    void setTargetAnchor(const QString &targetAnchor);

    Node *edgeNode() const;
    void setEdgeNode(Node *edgeNode);
    bool hasEdgeNode();

    void updateControls();
    void setAttributesFromData();
    void updateData();

    QPointF head() const;
    QPointF tail() const;
    QPointF cp1() const;
    QPointF cp2() const;
    QPointF mid() const;
	QPointF headTangent() const;
	QPointF tailTangent() const;

    int bend() const;
    int inAngle() const;
    int outAngle() const;
    qreal weight() const;
    bool basicBendMode() const;
    qreal cpDist() const;

    void setBasicBendMode(bool mode);
    void setBend(int bend);
    void setInAngle(int inAngle);
    void setOutAngle(int outAngle);
    void setWeight(qreal weight);

    void reverse();

    int tikzLine() const;
    void setTikzLine(int tikzLine);


	void attachStyle();
	QString styleName() const;
	void setStyleName(const QString & styleName);
    Style *style() const;

    Path *path() const;
    void setPath(Path *path);

signals:

public slots:

private:
    QPointF bezierTangent(qreal start, qreal end) const;
    QString _sourceAnchor;
    QString _targetAnchor;

    // owned
    Node *_edgeNode;
    GraphElementData *_data;

    // referenced
    Node *_source;
    Node *_target;
    Path *_path;


    Style *_style;

    bool _dirty;
    bool _basicBendMode;
    int _bend;
    int _inAngle;
    int _outAngle;
    qreal _weight;
    qreal _cpDist;

    QPointF _head;
    QPointF _tail;
    QPointF _cp1;
    QPointF _cp2;
    QPointF _mid;

	QPointF _headTangent;
	QPointF _tailTangent;

    int _tikzLine;
};

#endif // EDGE_H
