/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.util;

import info.monitorenter.util.collections.Entry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtil {
    private static final ResourceBundle m_bundle = ResourceBundle.getBundle("messages");

    public static Map.Entry<String, String> cutExtension(String filename) {
        String prefix;
        String suffix = null;
        StringTokenizer tokenizer = new StringTokenizer(filename, ".");
        int tokenCount = tokenizer.countTokens();
        if (tokenCount > 1) {
            StringBuffer prefCollect = new StringBuffer();
            while (tokenCount > 1) {
                prefCollect.append(tokenizer.nextToken());
                if (--tokenCount <= 1) continue;
                prefCollect.append(".");
            }
            prefix = prefCollect.toString();
            suffix = tokenizer.nextToken();
        } else {
            prefix = filename;
            suffix = "";
        }
        return new Entry<String, String>(prefix, suffix);
    }

    public static String getDefaultFileName(String name) {
        String result;
        File f = new File(name);
        if (!f.exists()) {
            result = f.getAbsolutePath();
        } else {
            Map.Entry<String, String> cut = FileUtil.cutExtension(name);
            String prefix = cut.getKey();
            String suffix = cut.getValue();
            int num = 0;
            while (f.exists()) {
                f = new File(prefix + '_' + num + '.' + suffix);
                ++num;
            }
            result = f.getAbsolutePath();
        }
        return result;
    }

    public static boolean isAllASCII(File f) throws IOException {
        return FileUtil.isAllASCII(new FileInputStream(f));
    }

    public static boolean isAllASCII(InputStream in) throws IOException {
        boolean ret = true;
        int read = -1;
        do {
            if ((read = in.read()) <= 127) continue;
            ret = false;
            break;
        } while (read != -1);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEqual(File document, Charset a, Charset b) throws IOException {
        boolean ret = true;
        FileInputStream aIn = null;
        FileInputStream bIn = null;
        InputStreamReader aReader = null;
        InputStreamReader bReader = null;
        try {
            aIn = new FileInputStream(document);
            bIn = new FileInputStream(document);
            aReader = new InputStreamReader((InputStream)aIn, a);
            bReader = new InputStreamReader((InputStream)bIn, b);
            int readA = -1;
            int readB = -1;
            do {
                if ((readA = aReader.read()) == (readB = bReader.read())) continue;
                ret = false;
                break;
            } while (readA != -1 && readB != -1);
            boolean bl = ret;
            return bl;
        }
        finally {
            if (aReader != null) {
                aReader.close();
            }
            if (bReader != null) {
                bReader.close();
            }
        }
    }

    private FileUtil() {
    }
}

