from RedDB import db
from Routes.api.config import filter
from Routes.api import constants

def exploits_info(db_name: str, args: dict) -> list:
    exploits = []
    raw_exploits = db.get_all_exploits(db_name)

    for exploit in raw_exploits:
        data = {
            "name": exploit[1],
            "data": exploit[2],
            "related_file": exploit[3]
        }
        is_match = filter(args, data)
        if is_match:
            exploits.append(data)

    return exploits


def add_new_exploit(db_name: str, args: dict) -> dict:
    details = dict(
        name = args.get("name"),
        data = args.get("data"),
        file_path = None
    )

    db.insert_new_exploit(db_name, **details)
    return constants.success_msg("Exploit added successfully")


def help() -> dict:
    return constants.help_msg({
        "arguments for POST /api/exploits": {
            "name": "Name of the exploits",
            "data": "Additional data about the exploit"
        }, 
        "arguments for GET /api/exploits": {
            "filters": "Filter by any of the returned parameters (wildcards are supported)"
        },
    })